/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

abstract class DeviceCanvas
extends GameCanvas
implements Constants {
    Player player;
    boolean paused;
    SoundListener listener;
    int playing;
    int pausedSound;
    boolean looping;

    DeviceCanvas() {
        super(false);
        this.setFullScreenMode(true);
        this.playing = -1;
        this.listener = new SoundListener(this);
    }

    void playSound(int n, boolean bl) {
        this.stopSound();
        if (n == -1) {
            return;
        }
        try {
            this.player = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/" + Integer.toString(n) + ".mid"), (String)"audio/midi");
            this.player.setLoopCount(bl ? -1 : 1);
            this.player.start();
            this.playing = n;
            this.looping = bl;
            this.player.addPlayerListener((PlayerListener)this.listener);
            this.pausedSound = n == 244 ? n : -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void playFX(int n) {
        if (this.playing == -1) {
            this.stopSound();
            try {
                this.player = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/" + Integer.toString(n) + ".wav"), (String)"audio/x-wav");
                this.player.setLoopCount(1);
                this.player.start();
                this.playing = n;
                this.player.addPlayerListener((PlayerListener)this.listener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void stopSound() {
        try {
            MySims.display.vibrate(0);
            this.player.stop();
            this.player.removePlayerListener((PlayerListener)this.listener);
            this.player.close();
            this.player = null;
            this.playing = -1;
            this.looping = false;
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void pauseSounds() {
        if (this.pausedSound == -1) {
            this.pausedSound = this.looping ? this.playing : -1;
            this.stopSound();
        } else {
            try {
                this.player.stop();
                this.player.close();
                this.player = null;
                this.looping = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void resumeSounds() {
        if (this.pausedSound != -1) {
            boolean bl = this.pausedSound != 244;
            this.playSound(this.pausedSound, bl);
        }
    }

    static void doVibrate(int n) {
        MySims.display.vibrate(n);
    }
}

