/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordStore;

class Prefs
implements Constants {
    public static final int SOUND_OFF = 0;
    public static final int SOUND_ON = 1;
    public static final int NUM_VOLUME_LEVELS = 2;
    public static final int ARROWS_OFF = 0;
    public static final int ARROWS_ON = 1;
    public static final int ARROWS_ON_PARTIAL = 2;
    public static final int NUM_ARROWS_OPTIONS = 3;
    public static final int CONV_DIFFICULTY_EASY = 1;
    public static final int CONV_DIFFICULTY_MED = 2;
    public static final int CONV_DIFFICULTY_HARD = 3;
    public static final int NUM_CONV_DIFFICULTIES = 4;
    String recordStoreName = "prefs";
    int volume;
    boolean vibration;
    Game game;
    int curPoint;
    int arrowsState;
    int convDifficulty;
    int numConvCorrect;
    String townName;
    String language;
    boolean wasSaved;
    int[] highscores;
    boolean[] minigames;
    int[][] fish;
    int[][] medalsObtained;
    Sim[] sims;

    Prefs(Game game) {
        this.game = game;
        this.wasSaved = false;
        this.sims = new Sim[24];
        for (int i = 0; i < 24; ++i) {
            this.sims[i] = new Sim();
            this.sims[i].isCreated = false;
        }
        this.reset();
    }

    void reset() {
        this.volume = 0;
        this.game.stop();
        this.vibration = true;
        this.arrowsState = 1;
        if (this.language == null) {
            this.language = "";
        }
        this.resetMiniGames();
        this.resetGame();
    }

    void resetGame() {
        this.curPoint = 0;
        this.game.playerSim = new Sim();
        this.convDifficulty = 1;
        this.numConvCorrect = 0;
        this.townName = "";
        this.fish = new int[12][];
        for (int i = 0; i < 12; ++i) {
            this.fish[i] = new int[2];
            for (int j = 0; j < 2; ++j) {
                this.fish[i][j] = 0;
            }
        }
    }

    void resetMiniGames() {
        int n;
        this.highscores = new int[6];
        this.minigames = new boolean[6];
        for (n = 0; n < 6; ++n) {
            this.minigames[n] = true;
            this.highscores[n] = 0;
        }
        this.medalsObtained = new int[6][];
        for (n = 0; n < 6; ++n) {
            this.medalsObtained[n] = new int[3];
            for (int i = 0; i < 3; ++i) {
                this.medalsObtained[n][i] = 0;
            }
        }
    }

    boolean save() {
        try {
            int n;
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.wasSaved = true;
            dataOutputStream.writeBoolean(this.wasSaved);
            dataOutputStream.writeInt(this.volume);
            dataOutputStream.writeBoolean(this.vibration);
            this.arrowsState = 1;
            dataOutputStream.writeInt(this.arrowsState);
            dataOutputStream.writeInt(this.convDifficulty);
            dataOutputStream.writeInt(this.numConvCorrect);
            dataOutputStream.writeUTF(this.townName);
            dataOutputStream.writeUTF(this.language);
            for (n2 = 0; n2 < 6; ++n2) {
                dataOutputStream.writeBoolean(this.minigames[n2]);
                dataOutputStream.writeInt(this.highscores[n2]);
            }
            for (n2 = 0; n2 < 24; ++n2) {
                dataOutputStream.writeBoolean(this.sims[n2].isCreated);
                dataOutputStream.writeInt(this.sims[n2].curBodyColor);
                dataOutputStream.writeInt(this.sims[n2].faceFrame);
                dataOutputStream.writeInt(this.sims[n2].curFaceColor);
                dataOutputStream.writeInt(this.sims[n2].hairFrame);
                dataOutputStream.writeInt(this.sims[n2].curHairColor);
                dataOutputStream.writeInt(this.sims[n2].curShirtColor);
                dataOutputStream.writeInt(this.sims[n2].curPantColor);
                dataOutputStream.writeInt(this.sims[n2].curShirtType);
                dataOutputStream.writeInt(this.sims[n2].curPantType);
                dataOutputStream.writeBoolean(this.sims[n2].isFemale);
                dataOutputStream.writeUTF(this.sims[n2].name);
            }
            for (n2 = 0; n2 < 12; ++n2) {
                for (n = 0; n < 2; ++n) {
                    dataOutputStream.writeByte(this.fish[n2][n]);
                }
            }
            for (n2 = 0; n2 < 6; ++n2) {
                for (n = 0; n < 3; ++n) {
                    dataOutputStream.writeInt(this.medalsObtained[n2][n]);
                }
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            RecordStore recordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean load() {
        try {
            int n;
            int n2;
            RecordStore recordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)false);
            if (recordStore.getNumRecords() == 0) {
                return false;
            }
            byte[] byArray = recordStore.getRecord(1);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.wasSaved = dataInputStream.readBoolean();
            this.volume = dataInputStream.readInt();
            this.vibration = dataInputStream.readBoolean();
            this.arrowsState = 1;
            this.arrowsState = dataInputStream.readInt();
            this.convDifficulty = dataInputStream.readInt();
            this.numConvCorrect = dataInputStream.readInt();
            this.townName = dataInputStream.readUTF();
            this.language = dataInputStream.readUTF();
            this.highscores = new int[6];
            this.minigames = new boolean[6];
            for (n2 = 0; n2 < 6; ++n2) {
                this.minigames[n2] = dataInputStream.readBoolean();
                this.highscores[n2] = dataInputStream.readInt();
            }
            this.sims = new Sim[24];
            for (n2 = 0; n2 < 24; ++n2) {
                this.sims[n2] = new Sim();
                this.sims[n2].isCreated = dataInputStream.readBoolean();
                this.sims[n2].curBodyColor = dataInputStream.readInt();
                this.sims[n2].faceFrame = dataInputStream.readInt();
                this.sims[n2].curFaceColor = dataInputStream.readInt();
                this.sims[n2].hairFrame = dataInputStream.readInt();
                this.sims[n2].curHairColor = dataInputStream.readInt();
                this.sims[n2].curShirtColor = dataInputStream.readInt();
                this.sims[n2].curPantColor = dataInputStream.readInt();
                this.sims[n2].curShirtType = dataInputStream.readInt();
                this.sims[n2].curPantType = dataInputStream.readInt();
                this.sims[n2].isFemale = dataInputStream.readBoolean();
                this.sims[n2].name = dataInputStream.readUTF();
            }
            this.fish = new int[12][];
            for (n2 = 0; n2 < 12; ++n2) {
                this.fish[n2] = new int[2];
                for (n = 0; n < 2; ++n) {
                    this.fish[n2][n] = dataInputStream.readByte();
                }
            }
            this.medalsObtained = new int[6][];
            for (n2 = 0; n2 < 6; ++n2) {
                this.medalsObtained[n2] = new int[3];
                for (n = 0; n < 3; ++n) {
                    this.medalsObtained[n2][n] = dataInputStream.readInt();
                }
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

