/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Fishing
implements Constants,
Strings {
    public static final int MODE_SCORE = 0;
    public static final int MODE_FISH = 1;
    public static final int MODE_CLEAN = 2;
    public static final int STATE_INTRO = 0;
    public static final int STATE_STOP = 1;
    public static final int STATE_READY = 2;
    public static final int STATE_GO = 3;
    public static final int STATE_FIRST_SCROLL = 4;
    public static final int STATE_WAITING = 5;
    public static final int STATE_CASTING = 6;
    public static final int STATE_FISHING = 7;
    public static final int STATE_AUTO_REEL = 8;
    public static final int STATE_REELING = 9;
    public static final int STATE_SNAP = 10;
    public static final int STATE_SCROLL = 11;
    public static final int STATE_CAUGHT = 12;
    public static final int STATE_RESULTS = 13;
    public static final int FISH_RIGHT = 0;
    public static final int FISH_DOWN = 1;
    public static final int FISH_LEFT = 2;
    public static final int FISH_UP = 3;
    public static final int NUM_FISH_DIRECTIONS = 4;
    public static final int FISH_ENTERING = 0;
    public static final int FISH_CURIOUS = 1;
    public static final int FISH_ATTRACTED = 2;
    public static final int FISH_NIBBLE = 3;
    public static final int FISH_FLEE = 4;
    public static final int FISH_ESCAPE = 5;
    public static final int FISH_HOOKED = 6;
    public static final int FISHING_TIME_LIMIT = 300000;
    public static final int FISHING_SPEED = 25;
    public static final int FISH_SPEED = 60;
    public static final int NUM_FISH = 6;
    public static final int FISH_SPAWN = 10000;
    public static final int FISH_IDLE_SPEED = 30;
    public static final int FISH_PULL_SPEED = 300;
    public static final int NIBBLE_TIME = 1000;
    public static final int MIN_SPAWN_DISTANCE = 5;
    public static final int LINE_RECOVER = 8;
    public static final int FISH_NIBBLE_RANGE = 2560;
    public static final int FISH_SCARE_RANGE = 10240;
    public static final int FISH_CURIOUS_RANGE = 20480;
    public static final int FISH_FLEE_RANGE = 20480;
    public static final int MAX_CAST = 1500;
    public static final int DEGREES_0 = 0;
    public static final int DEGREES_90 = 64;
    public static final int DEGREES_180 = 128;
    public static final int DEGREES_360 = 256;
    Game game;
    Vector fish;
    Image imgIntro;
    Image imgBG;
    Image imgScore;
    Image imgTime;
    Image imgPole;
    Image imgMeter;
    Image imgExclaim;
    Image imgFish;
    Image imgDPad;
    GraphicFont font;
    PackedSprite sprSplash;
    PackedSprite sprSnap;
    PackedSprite sprFishPrize;
    PackedSprite sprBobber;
    PackedSprite sprButton;
    PackedSprite currentFish;
    PackedSprite sprTension;
    PackedSprite sprReel;
    PackedSprite sprJunk;
    PackedSprite[] sprFish;
    int goal;
    int target;
    int[] num_caught;
    int line_strength;
    int location;
    int current_x;
    int current_y;
    int playarea_h;
    int offset_y;
    int mode;
    int state;
    int nextState;
    int power;
    int score;
    int weight;
    int value;
    int fish_txt_h;
    boolean isFishPulling;
    boolean powerUp;
    long update_time;
    long spawn_delay;
    long fish_time;
    long reel_tension;
    long nibble_time;
    long wait_time;
    long throw_time;
    long last_tick;
    long game_time;
    long clock_time;
    String fish_txt;
    Random rand;
    Position fishingPole;
    boolean won;

    public Fishing(Game game, int n, int n2, int n3) {
        this.game = game;
        this.mode = n;
        this.location = n2;
        this.goal = n3;
        this.target = n3;
    }

    public Fishing(Game game, int n, int n2) {
        this.game = game;
        this.mode = n;
        this.location = n2;
    }

    public void init() {
        int n;
        this.fish = new Vector();
        this.rand = new Random(System.currentTimeMillis());
        this.won = false;
        this.game_time = 0L;
        this.clock_time = 0L;
        this.last_tick = -1L;
        this.nibble_time = -1L;
        this.reel_tension = 0L;
        this.spawn_delay = -1L;
        this.update_time = -1L;
        this.score = 0;
        this.state = 0;
        this.wait_time = 500L;
        this.nextState = -1;
        this.num_caught = new int[12];
        for (n = 0; n < 12; ++n) {
            this.num_caught[n] = 0;
        }
        this.playarea_h = 408;
        this.offset_y = 0;
        this.current_x = 0;
        this.current_y = 0;
        switch (this.location) {
            case 0: {
                this.current_y = 20000;
                break;
            }
            case 1: {
                this.current_x = 20000;
                break;
            }
            case 2: 
            case 3: {
                this.current_x = 20000;
            }
        }
        n = 1;
        switch (n) {
            case 0: {
                this.line_strength = 1200;
                break;
            }
            case 1: {
                this.line_strength = 800;
                break;
            }
            case 2: {
                this.line_strength = 400;
            }
        }
        this.fishingPole = new Position(this.itofx(120), this.itofx(this.playarea_h));
        this.sprBobber.animation = 0;
        this.sprBobber.position.y = this.itofx(0);
        this.sprBobber.position.z = 1;
        for (int i = 0; i < 3 + this.goal; ++i) {
            this.spawnFish(true);
        }
        this.game.stop();
    }

    public void spawnFish(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = Math.abs(this.rand.nextInt()) % 1000;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; n3 < Constants.FISHING_SPOTS[this.location].length >> 1; ++n3) {
            if (n4 > (n6 += Constants.FISHING_SPOTS[this.location][(n3 << 1) + 1])) continue;
            n7 = Constants.FISHING_SPOTS[this.location][n3 << 1];
            if (n7 != 9) break;
            n2 = 1;
            for (n = 0; n < 10; ++n) {
                if (n == 9 || this.game.prefs.fish[n][0] > 0) continue;
                n2 = 0;
                break;
            }
            if (n2 != 0 && this.game.prefs.fish[9][1] <= 0) break;
            n7 = 4;
            break;
        }
        if (this.mode == 2) {
            n3 = 0;
            for (n2 = 0; n2 < this.fish.size(); ++n2) {
                PackedSprite packedSprite = (PackedSprite)this.fish.elementAt(n2);
                if (!this.isJunk(packedSprite.type)) continue;
                ++n3;
            }
            if (n3 < this.goal) {
                n7 = 10;
                if (n4 <= 30) {
                    n7 = 11;
                }
            }
        }
        n5 = Constants.FISH_STATS[n7][0];
        n3 = this.sprFish[n5].frameWidth;
        n2 = this.sprFish[n5].frameHeight;
        n = this.playarea_h - (n2 << 1) - this.sprBobber.frameHeight;
        int n8 = 2;
        if (this.mode == 0) {
            n8 += this.imgScore.getHeight();
        }
        if (n5 == 2 && this.mode != 2) {
            n >>= 1;
        }
        int n9 = n - n8 - this.imgPole.getHeight();
        int n10 = 0;
        int n11 = 0;
        PackedSprite packedSprite = null;
        packedSprite = this.isJunk(n7) ? this.sprJunk.copy() : this.sprFish[n5].copy();
        packedSprite.speed = 200;
        if (this.isJunk(n7)) {
            packedSprite.speed = 1000;
        }
        packedSprite.type = n7;
        packedSprite.animation = Math.abs(this.rand.nextInt()) % 4;
        if (this.isJunk(n7)) {
            packedSprite.animation = 0;
        }
        int n12 = 240 - (n3 << 1);
        int n13 = n3 + Math.abs(this.rand.nextInt()) % n12;
        int n14 = n8 + n9;
        int n15 = Math.abs(this.rand.nextInt()) % n14;
        if (bl) {
            n11 = n13;
            n10 = n15;
            packedSprite.state = 0;
        } else {
            int n16 = Math.abs(this.rand.nextInt()) % 4;
            boolean bl2 = true;
            while (bl2) {
                switch (n16) {
                    case 2: {
                        bl2 = this.current_x < 0;
                        n11 = 240 + n3;
                        n10 = n15;
                        break;
                    }
                    case 0: {
                        bl2 = this.current_x > 0;
                        n11 = -n3;
                        n10 = n15;
                        break;
                    }
                    case 3: {
                        bl2 = true;
                        break;
                    }
                    case 1: {
                        bl2 = this.current_y > 0;
                        n11 = n13;
                        n10 = -n2;
                    }
                }
                if (!bl2) {
                    packedSprite.animation = n16;
                    break;
                }
                if (++n16 < 4) continue;
                n16 = 0;
            }
            packedSprite.state = 0;
        }
        packedSprite.position = new Position(this.itofx(n11), this.itofx(n10));
        packedSprite.delay = this.game_time + 2500L + (long)(1000 * Math.abs(this.rand.nextInt() % 5));
        if (this.isJunk(n7)) {
            packedSprite.position = this.checkFishPosition(bl, packedSprite, n9);
        }
        this.fish.addElement(packedSprite);
    }

    Position checkFishPosition(boolean bl, PackedSprite packedSprite, int n) {
        boolean bl2 = bl || !bl && (packedSprite.animation == 1 || packedSprite.animation == 3);
        boolean bl3 = bl || !bl && (packedSprite.animation == 2 || packedSprite.animation == 0);
        int n2 = this.fxtoi(packedSprite.position.x);
        int n3 = this.fxtoi(packedSprite.position.y);
        int n4 = 10;
        int n5 = 0;
        while (n5 < this.fish.size() && n4 > 0) {
            int n6;
            PackedSprite packedSprite2 = (PackedSprite)this.fish.elementAt(n5);
            int n7 = this.fxtoi(packedSprite2.position.x);
            int n8 = this.fxtoi(packedSprite2.position.y);
            if (bl2 && n2 >= n7 - 5 && n2 <= n7 + 5) {
                n6 = Math.abs(this.rand.nextInt() % 10) + 5;
                n2 = n2 <= n7 ? (n2 - n6 > 2 + packedSprite.frameWidth ? (n2 -= n6) : (n2 += n6 + 10)) : (n2 + n6 < 238 - packedSprite.frameWidth ? (n2 += n6) : (n2 -= n6 + 10));
                n5 = 0;
                --n4;
                continue;
            }
            if (bl3 && n3 >= n8 - 5 && n3 <= n8 + 5) {
                n6 = Math.abs(this.rand.nextInt() % 10) + 5;
                n3 = n3 <= n8 ? (n3 - n6 < 2 + packedSprite.frameHeight ? (n3 -= n6) : (n3 += n6 + 10)) : (n3 + n6 < 2 + n + packedSprite.frameHeight ? (n3 += n6) : (n3 -= n6 + 10));
                n5 = 0;
                --n4;
                continue;
            }
            ++n5;
        }
        return new Position(this.itofx(n2), this.itofx(n3));
    }

    public void loadRes() {
        int[] nArray = this.location == 2 ? this.game.findPalette(140) : this.game.findPalette(139);
        this.imgBG = Game.createImage(269, nArray);
        this.imgDPad = Game.createImage(320);
        this.font = new GraphicFont(201, 182, "abcdefghijklmnopqrstuvwxyz1234567890/=:.", 1);
        this.sprBobber = new PackedSprite(268, 240, nArray);
        this.sprBobber.speed = 400;
        this.sprBobber.position = new Position(this.itofx(120), this.itofx(this.playarea_h));
        this.sprSnap = new PackedSprite(281, 248, nArray);
        this.sprSnap.speed = 200;
        this.sprTension = new PackedSprite(279, 246);
        this.imgMeter = Game.createImage(277);
        this.imgFish = Game.createImage(275);
        this.imgExclaim = Game.createImage(280);
        this.imgPole = Game.createImage(276);
        this.sprReel = new PackedSprite(278, 247);
        this.sprReel.speed = 200;
        this.sprSplash = new PackedSprite(274, 245, nArray);
        this.sprSplash.speed = 200;
        this.sprSplash.loop = 0;
        this.sprFishPrize = new PackedSprite(273, 244);
        this.sprFish = new PackedSprite[3];
        for (int i = 0; i < 3; ++i) {
            this.sprFish[i] = new PackedSprite(270 + i, 241 + i, nArray);
        }
        this.sprJunk = new PackedSprite(306, 266, nArray);
        if (this.mode == 0) {
            this.imgScore = Game.createImage(230);
            this.imgTime = Game.createImage(229);
        }
        this.game.sprStopLight = new PackedSprite(258, 235);
        this.imgIntro = Game.createImage(284);
    }

    public void process(int n, int n2, long l) {
        PackedSprite packedSprite;
        int n3;
        int n4;
        boolean bl = false;
        int n5 = (int)(l - this.last_tick);
        if (this.last_tick > 0L && this.state <= 11) {
            this.game_time += l - this.last_tick;
            if (this.state >= 5 & this.state < 13) {
                this.clock_time += l - this.last_tick;
            }
            if (this.mode == 0 && this.clock_time > 300000L) {
                this.state = 13;
                this.game.setResultScreen(5, this.score);
            }
        }
        this.last_tick = l;
        this.sprBobber.position.dx = 0;
        block0 : switch (this.state) {
            case 0: {
                if (this.game_time < this.wait_time || n != 8) break;
                if (this.mode == 0) {
                    this.state = 1;
                    this.wait_time = this.game_time + 1000L;
                    break;
                }
                this.state = 4;
                this.wait_time = this.game_time + 1000L;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (this.state == 1 && this.game_time > this.wait_time) {
                    this.wait_time = this.game_time + 1000L;
                    this.state = 2;
                }
                if (this.state == 2 && this.game_time > this.wait_time) {
                    this.wait_time = this.game_time + 500L;
                    this.state = 3;
                }
                if (this.state != 3 || this.game_time <= this.wait_time) break;
                this.state = 4;
                this.wait_time = this.game_time + 1000L;
                break;
            }
            case 5: {
                this.sprBobber.animation = 0;
                this.sprBobber.position.y = this.itofx(this.playarea_h - this.imgPole.getHeight());
                this.sprBobber.position.z = 1;
                this.power = 0;
                this.nibble_time = -1L;
                if (this.game_time >= this.wait_time && (n2 & 2) != 0) {
                    this.throw_time = this.game_time;
                    this.state = 6;
                }
                this.fishingPole.dx = 0;
                if ((n2 & 8) != 0) {
                    this.fishingPole.dx = -360;
                }
                if ((n2 & 0x10) != 0) {
                    this.fishingPole.dx = 360;
                }
                if (this.game_time <= this.update_time) break;
                this.sprBobber.position.x = this.fishingPole.x = Math.min(Math.max(this.fishingPole.x + this.fishingPole.dx, 0), this.itofx(240));
                break;
            }
            case 6: {
                this.sprBobber.position.z = 1;
                if (this.powerUp) {
                    this.power += 75;
                    if (this.power >= 1500) {
                        this.powerUp = false;
                        this.power = 1500;
                    }
                } else {
                    this.power -= 75;
                    if (this.power <= 0) {
                        this.powerUp = true;
                        this.power = 0;
                    }
                }
                this.fishingPole.dx = 0;
                if ((n2 & 8) != 0) {
                    this.fishingPole.dx = -360;
                }
                if ((n2 & 0x10) != 0) {
                    this.fishingPole.dx = 360;
                }
                if (this.game_time > this.update_time) {
                    this.sprBobber.position.x = this.fishingPole.x = Math.min(Math.max(this.fishingPole.x + this.fishingPole.dx, 0), this.itofx(240));
                }
                if ((n2 & 2) != 0) break;
                this.sprBobber.position.y = this.itofx(this.playarea_h - this.imgPole.getHeight());
                this.power = Math.min(this.power, 1500);
                this.sprBobber.speed = 400;
                this.sprBobber.position.dy = -(this.power * 1100 / 1500);
                this.sprBobber.position.dz = 1200;
                this.state = 7;
                break;
            }
            case 9: {
                this.sprBobber.animation = 1;
                if (this.game_time > this.fish_time) {
                    this.isFishPulling = !this.isFishPulling;
                    this.fish_time = this.game_time + 1000L + (long)(250 * Math.abs(this.rand.nextInt() % 5));
                }
                this.sprBobber.position.dy = 0;
                if (this.isFishPulling) {
                    this.sprBobber.animation = 2;
                    this.sprBobber.speed = 100;
                    this.game.vibrate(200);
                    n4 = Fishing.angleBetweenPoints(this.sprBobber.position, this.fishingPole);
                    this.sprBobber.position.dx += Fishing.fxmul(-60, Fishing.fcos(n4));
                    this.sprBobber.position.dy += Fishing.fxmul(-60, Fishing.fsin(n4));
                } else {
                    this.sprBobber.animation = 1;
                    this.sprBobber.speed = 400;
                }
                if ((n2 & 8) != 0) {
                    this.sprBobber.position.dx += -100;
                }
                if ((n2 & 0x10) != 0) {
                    this.sprBobber.position.dx += 100;
                }
                if ((n2 & 4) != 0) {
                    bl = true;
                    n3 = 300 * (3 - Constants.FISH_STATS[this.currentFish.type][0] + 1) / 3;
                    if (this.isFishPulling) {
                        if (this.game_time > this.update_time) {
                            this.reel_tension += (long)Constants.FISH_STATS[this.currentFish.type][1];
                        }
                        n3 >>= 1;
                    }
                    n4 = Fishing.angleBetweenPoints(this.sprBobber.position, this.fishingPole);
                    this.sprBobber.position.dx += Fishing.fxmul(n3, Fishing.fcos(n4));
                    this.sprBobber.position.dy += Fishing.fxmul(n3, Fishing.fsin(n4));
                } else if (this.game_time > this.update_time) {
                    this.reel_tension -= 8L;
                }
                this.reel_tension = Math.max(this.reel_tension, 0L);
                for (n4 = 0; n4 < this.fish.size(); ++n4) {
                    packedSprite = (PackedSprite)this.fish.elementAt(n4);
                    if (packedSprite.state != 6) continue;
                    packedSprite.position.x = this.sprBobber.position.x;
                    packedSprite.position.y = this.sprBobber.position.y - this.itofx(this.sprBobber.frameHeight >> 1);
                    packedSprite.animation = 1;
                    packedSprite.speed = this.isFishPulling ? 50 : 200;
                    if ((n2 & 0x20) != 0) {
                        this.state = 8;
                        this.nibble_time = -1L;
                        this.reel_tension = 0L;
                        packedSprite.speed = 200;
                        packedSprite.state = 1;
                        continue;
                    }
                    if (this.sprBobber.position.y <= 0 || this.reel_tension >= (long)this.line_strength) {
                        this.reel_tension = 0L;
                        this.sprBobber.speed = 400;
                        this.state = 10;
                        this.wait_time = this.game_time + 1000L;
                        this.sprSnap.frame = 0;
                        this.sprSnap.loop = 1;
                        this.sprSnap.num_loops = 1;
                        this.sprSnap.timer = this.game_time + (long)this.sprSnap.speed;
                        packedSprite.speed = 200;
                        packedSprite.state = 5;
                        break block0;
                    }
                    if (this.sprBobber.position.y <= this.itofx(this.playarea_h - this.imgPole.getHeight())) break block0;
                    this.fish.removeElementAt(n4);
                    this.weight = Constants.FISH_STATS[this.currentFish.type][3] + Math.abs(this.rand.nextInt()) % (Constants.FISH_STATS[this.currentFish.type][4] - Constants.FISH_STATS[this.currentFish.type][3]);
                    this.value = this.weight * Constants.FISH_STATS[this.currentFish.type][2];
                    this.score += this.value;
                    int n6 = this.currentFish.type;
                    this.num_caught[n6] = this.num_caught[n6] + 1;
                    if (this.mode == 1 || this.mode == 2) {
                        if (this.weight > this.game.prefs.fish[this.currentFish.type][0]) {
                            this.game.prefs.fish[this.currentFish.type][0] = this.weight;
                        }
                        int[] nArray = this.game.prefs.fish[this.currentFish.type];
                        nArray[1] = nArray[1] + 1;
                        this.game.prefs.save();
                        if (this.mode == 2) {
                            switch (this.currentFish.type) {
                                case 10: 
                                case 11: {
                                    --this.goal;
                                }
                            }
                        }
                    }
                    this.fish_txt = this.game.strings[91];
                    String string = this.game.strings[79 + this.currentFish.type];
                    this.fish_txt = new String(this.game.fontTiny.wrap(Game.substitute(this.fish_txt, string), 120));
                    this.fish_txt_h = this.game.fontTiny.getStringHeight(this.fish_txt.toCharArray());
                    this.reel_tension = 0L;
                    this.sprBobber.speed = 400;
                    this.state = 12;
                    this.wait_time = this.game_time + 3000L;
                    break block0;
                }
                break;
            }
            case 8: {
                n4 = Fishing.angleBetweenPoints(this.sprBobber.position, this.fishingPole);
                this.sprBobber.position.dx += Fishing.fxmul(500, Fishing.fcos(n4));
                this.sprBobber.position.dy += Fishing.fxmul(500, Fishing.fsin(n4));
                if (this.sprBobber.position.dy <= 0 || this.sprBobber.position.y < this.itofx(this.playarea_h - this.imgPole.getHeight())) break;
                this.state = 5;
                this.wait_time = this.game_time + 500L;
                break;
            }
            case 7: {
                if ((n2 & 0x20) != 0) {
                    this.state = 8;
                    this.nibble_time = -1L;
                }
                this.sprBobber.animation = 0;
                n3 = 100;
                if (this.sprBobber.position.z > 0) {
                    n3 = 360;
                } else {
                    this.sprBobber.position.dy = 0;
                }
                if (this.nibble_time < 0L) {
                    if ((n2 & 8) != 0) {
                        this.sprBobber.position.dx += -n3;
                    }
                    if ((n2 & 0x10) != 0) {
                        this.sprBobber.position.dx += n3;
                    }
                }
                if (this.game_time > this.update_time && this.sprBobber.position.z > 0) {
                    this.sprBobber.position.dz -= 32;
                    this.sprBobber.position.z += this.sprBobber.position.dz;
                    if (this.sprBobber.position.z < 0) {
                        this.sprBobber.position.dz = 0;
                        this.sprBobber.position.z = 0;
                        this.sprSplash.frame = 0;
                        this.sprSplash.loop = 1;
                        this.sprSplash.num_loops = 1;
                        this.game.playFx(312);
                        this.scareFish(this.sprBobber.position.x, this.sprBobber.position.y);
                    }
                }
                if (this.sprBobber.position.z == 0 && (n2 & 4) != 0) {
                    bl = true;
                    int n7 = Fishing.angleBetweenPoints(this.sprBobber.position, this.fishingPole);
                    this.sprBobber.position.dx += Fishing.fxmul(360, Fishing.fcos(n7));
                    this.sprBobber.position.dy += Fishing.fxmul(360, Fishing.fsin(n7));
                }
                if (this.sprBobber.position.dy <= 0 || this.sprBobber.position.y < this.itofx(this.playarea_h - this.imgPole.getHeight())) break;
                this.state = 5;
                this.wait_time = this.game_time + 500L;
                break;
            }
            case 10: {
                this.sprBobber.animation = 0;
                this.sprBobber.position.dx = 0;
                this.sprBobber.position.dy = 0;
                if (this.game_time <= this.wait_time) break;
                this.state = 11;
                this.wait_time = this.game_time + 1000L;
                break;
            }
            case 4: 
            case 11: {
                n3 = Math.min(Math.max(this.fxtoi(this.sprBobber.position.y) - 174, 0), this.playarea_h - 348);
                int n8 = this.playarea_h - 348 - n3;
                this.offset_y = -n3 - n8 + (int)((long)n8 * Math.max(this.wait_time - this.game_time, 0L) / 1000L);
                if (this.game_time < this.wait_time) break;
                this.sprBobber.position.dx = 0;
                this.sprBobber.position.dy = 0;
                this.sprBobber.position.y = this.itofx(this.playarea_h - this.imgPole.getHeight());
                this.offset_y = this.playarea_h - 348;
                this.state = 5;
                break;
            }
            case 12: {
                this.sprBobber.animation = 0;
                if ((n2 & 0x20) == 0) break;
                if (this.mode == 2 && this.goal <= 0) {
                    this.game.state = 2;
                    this.won = true;
                    return;
                }
                this.wait_time = this.game_time + 500L;
                this.state = 5;
                break;
            }
            case 13: {
                if ((n2 & 0x20) == 0) break;
                this.game.state = this.game.isMini ? 4 : 2;
            }
        }
        if (this.game_time > this.update_time && this.state >= 1 && this.state < 12) {
            this.processFish(n2);
            for (n4 = this.fish.size() - 1; n4 >= 0; --n4) {
                packedSprite = (PackedSprite)this.fish.elementAt(n4);
                if (this.isJunk(packedSprite.type)) {
                    packedSprite.animation = 0;
                }
                packedSprite.nextFrame(this.game_time);
                if (packedSprite.state == 6) continue;
                if (!this.isJunk(packedSprite.type)) {
                    if (this.current_x != 0) {
                        packedSprite.position.x += this.itofx(this.imgBG.getWidth() >> 1) * n5 / this.current_x;
                    }
                    if (this.current_y != 0) {
                        packedSprite.position.y += this.itofx(this.imgBG.getHeight() >> 1) * n5 / this.current_y;
                    }
                    switch (packedSprite.animation) {
                        case 2: {
                            packedSprite.position.x -= 30;
                            break;
                        }
                        case 0: {
                            packedSprite.position.x += 30;
                            break;
                        }
                        case 3: {
                            packedSprite.position.y -= 30;
                            break;
                        }
                        case 1: {
                            packedSprite.position.y += 30;
                        }
                    }
                }
                if (packedSprite.state == 0 || packedSprite.position.x > -this.itofx(packedSprite.frameWidth >> 1) && packedSprite.position.x < this.itofx(240 + (packedSprite.frameWidth >> 1)) && packedSprite.position.y < this.itofx(this.playarea_h + (packedSprite.frameHeight >> 1)) && packedSprite.position.y > -this.itofx(packedSprite.frameHeight >> 1)) continue;
                this.fish.removeElementAt(n4);
            }
        }
        if (this.game_time > this.update_time) {
            if (this.sprBobber.position.z == 0) {
                n4 = Fishing.angleBetweenPoints(this.sprBobber.position, this.fishingPole);
                if (this.current_x != 0) {
                    n3 = this.itofx(this.imgBG.getWidth() >> 1) * n5 / this.current_x;
                    this.sprBobber.position.dx += Fishing.fxmul(n3, Fishing.fcos(n4));
                }
                if (this.current_y != 0) {
                    n3 = this.itofx(this.imgBG.getHeight() >> 1) * n5 / this.current_y;
                    this.sprBobber.position.dy += Fishing.fxmul(n3, Fishing.fsin(n4));
                }
            }
            this.sprBobber.position.x = Math.min(Math.max(this.sprBobber.position.x + this.sprBobber.position.dx, 0), this.itofx(240));
            this.sprBobber.position.y = Math.min(Math.max(this.sprBobber.position.y + this.sprBobber.position.dy, 0), this.itofx(this.playarea_h));
            if (this.sprBobber.position.z == 0) {
                this.sprBobber.nextFrame(this.game_time);
            } else {
                this.sprBobber.frame = 0;
            }
        }
        if (this.state <= 10 && this.state >= 5) {
            this.offset_y = -Math.min(Math.max(this.fxtoi(this.sprBobber.position.y) - 174, 0), this.playarea_h - 348);
        }
        if (this.state == 10) {
            this.sprSnap.nextFrame(this.game_time);
        }
        this.sprSplash.nextFrame(this.game_time);
        if (bl) {
            this.sprReel.nextFrame(this.game_time);
        }
        if (this.game_time > this.update_time) {
            this.update_time = this.game_time + 25L;
        }
    }

    public void processFish(int n) {
        for (int i = 0; i < this.fish.size(); ++i) {
            PackedSprite packedSprite = (PackedSprite)this.fish.elementAt(i);
            int n2 = Math.abs(packedSprite.position.x - this.sprBobber.position.x);
            int n3 = Math.abs(packedSprite.position.y - this.sprBobber.position.y);
            int n4 = n2 + n3;
            packedSprite.position.dx = 0;
            packedSprite.position.dy = 0;
            switch (packedSprite.state) {
                case 0: {
                    if (packedSprite.position.x < this.itofx(packedSprite.frameWidth)) {
                        packedSprite.position.dx = 60;
                        packedSprite.animation = 0;
                    } else if (packedSprite.position.x > this.itofx(240 - packedSprite.frameWidth)) {
                        packedSprite.position.dx = -60;
                        packedSprite.animation = 2;
                    }
                    if (packedSprite.position.y < this.itofx(packedSprite.frameHeight)) {
                        packedSprite.position.dy = 60;
                        packedSprite.animation = 1;
                    } else if (packedSprite.position.y > this.itofx(this.playarea_h - packedSprite.frameHeight)) {
                        packedSprite.position.dy = -60;
                        packedSprite.animation = 3;
                    }
                    if (packedSprite.position.x < this.itofx(packedSprite.frameWidth) || packedSprite.position.x > this.itofx(240 - packedSprite.frameWidth) || packedSprite.position.y < this.itofx(packedSprite.frameHeight) || packedSprite.position.y > this.itofx(this.playarea_h - packedSprite.frameHeight)) break;
                    packedSprite.state = 1;
                    break;
                }
                case 1: {
                    if (this.sprBobber.position.z > 0 || this.state == 9 || this.state == 10) break;
                    if (n4 < 10240 && (n & 4) != 0 && !this.isJunk(packedSprite.type)) {
                        packedSprite.state = 4;
                        break;
                    }
                    if (this.game_time <= packedSprite.delay) break;
                    packedSprite.delay = this.game_time + 2500L + (long)(1000 * Math.abs(this.rand.nextInt() % 5));
                    if (n4 < 20480) {
                        packedSprite.state = 2;
                        break;
                    }
                    if (!this.isJunk(packedSprite.type)) {
                        if (Math.abs(this.rand.nextInt() % 100) > 25) break;
                        packedSprite.animation = Math.abs(this.rand.nextInt() % 4);
                        break;
                    }
                    packedSprite.animation = 0;
                    break;
                }
                case 2: {
                    if (this.sprBobber.position.z > 0 || this.state == 9 || this.state == 10 || this.nibble_time > 0L) {
                        packedSprite.state = 1;
                        break;
                    }
                    if (n4 < 2560 && this.nibble_time < 0L && this.state != 8) {
                        this.game.vibrate(100);
                        this.nibble_time = this.game_time + 1000L;
                        this.sprBobber.speed = 100;
                        packedSprite.state = 3;
                        packedSprite.animation = 1;
                        break;
                    }
                    if (n4 < 10240 && (n & 4) != 0 && !this.isJunk(packedSprite.type)) {
                        packedSprite.state = 4;
                        break;
                    }
                    if (this.isJunk(packedSprite.type)) break;
                    if (packedSprite.position.x > this.sprBobber.position.x) {
                        packedSprite.animation = 2;
                        packedSprite.position.dx = -Math.min(60, n2);
                    } else if (packedSprite.position.x < this.sprBobber.position.x) {
                        packedSprite.animation = 0;
                        packedSprite.position.dx = Math.min(60, n2);
                    }
                    if (n3 < n2 << 1) break;
                    if (packedSprite.position.y > this.sprBobber.position.y) {
                        packedSprite.animation = 3;
                        packedSprite.position.dy = -Math.min(60, n3);
                        break;
                    }
                    if (packedSprite.position.y >= this.sprBobber.position.y) break;
                    packedSprite.animation = 1;
                    packedSprite.position.dy = Math.min(60, n3);
                    break;
                }
                case 3: {
                    if (this.state != 5 && this.state != 8) {
                        packedSprite.position.x = this.sprBobber.position.x;
                        packedSprite.position.y = this.sprBobber.position.y - this.itofx(this.sprBobber.frameHeight >> 1);
                        packedSprite.animation = 1;
                        if ((n & 4) != 0) {
                            this.currentFish = packedSprite;
                            this.nibble_time = -1L;
                            this.fish_time = this.game_time + 1000L + (long)(500 * Math.abs(this.rand.nextInt() % 4));
                            this.isFishPulling = false;
                            this.reel_tension = 0L;
                            packedSprite.state = 6;
                            this.state = 9;
                            this.scareFish(this.sprBobber.position.x, this.sprBobber.position.y);
                            break;
                        }
                        if (this.game_time <= this.nibble_time) break;
                        this.sprBobber.speed = 400;
                        this.nibble_time = -1L;
                        packedSprite.state = 4;
                        break;
                    }
                    if (this.game_time <= this.nibble_time) break;
                    this.sprBobber.speed = 400;
                    this.nibble_time = -1L;
                    packedSprite.state = 4;
                    break;
                }
                case 4: {
                    if (n4 < 20480) {
                        if (packedSprite.position.x > this.sprBobber.position.x) {
                            packedSprite.position.dx = 120;
                            packedSprite.animation = 0;
                            break;
                        }
                        if (packedSprite.position.x < this.sprBobber.position.x) {
                            packedSprite.animation = 2;
                            packedSprite.position.dx = -120;
                            break;
                        }
                        if (packedSprite.position.y > this.sprBobber.position.y) {
                            packedSprite.animation = 1;
                            packedSprite.position.dy = 120;
                            break;
                        }
                        if (packedSprite.position.y >= this.sprBobber.position.y) break;
                        packedSprite.animation = 3;
                        packedSprite.position.dy = -120;
                        break;
                    }
                    packedSprite.state = 1;
                    break;
                }
                case 5: {
                    packedSprite.animation = 3;
                    packedSprite.position.dy = -120;
                }
            }
            packedSprite.position.x += packedSprite.position.dx;
            packedSprite.position.y += packedSprite.position.dy;
        }
        if (this.fish.size() < 6 && this.game_time > this.spawn_delay) {
            this.spawn_delay = this.game_time + 10000L;
            this.spawnFish(false);
        }
    }

    public void scareFish(int n, int n2) {
        for (int i = 0; i < this.fish.size(); ++i) {
            int n3;
            int n4;
            int n5;
            PackedSprite packedSprite = (PackedSprite)this.fish.elementAt(i);
            if (packedSprite.state > 2 || this.isJunk(packedSprite.type) || (n5 = (n4 = Math.abs(packedSprite.position.x - n)) + (n3 = Math.abs(packedSprite.position.y - n2))) >= 10240) continue;
            packedSprite.state = 4;
        }
    }

    public void render(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        graphics.setClip(0, 0, 240, 348);
        int n6 = 0;
        int n7 = 0;
        int n8 = Math.abs(this.current_y);
        if (n8 > 0) {
            n7 = (int)(this.game_time % (long)n8 * (long)this.imgBG.getHeight() / (long)n8);
            if (this.current_y > 0) {
                n7 = this.imgBG.getHeight() - n7;
            }
        }
        if ((n8 = Math.abs(this.current_x)) > 0) {
            n6 = (int)((long)this.imgBG.getHeight() - this.game_time % (long)n8 * (long)this.imgBG.getHeight() / (long)n8);
            if (this.current_x > 0) {
                n6 = this.imgBG.getHeight() - n6;
            }
        }
        for (n5 = this.offset_y - n7; n5 < 348; n5 += this.imgBG.getHeight()) {
            if (n5 < -this.imgBG.getHeight()) continue;
            for (n4 = -n6; n4 < 240; n4 += this.imgBG.getHeight()) {
                graphics.drawImage(this.imgBG, n4, n5, 20);
            }
        }
        for (n4 = 0; n4 < this.fish.size(); ++n4) {
            PackedSprite packedSprite = (PackedSprite)this.fish.elementAt(n4);
            n3 = 2;
            if (this.isJunk(packedSprite.type)) {
                packedSprite.animation = 0;
                if (packedSprite.state == 6 || packedSprite.state == 3) {
                    n3 = 16;
                }
            }
            packedSprite.render(graphics, this.fxtoi(packedSprite.position.x), this.fxtoi(packedSprite.position.y) + this.offset_y, packedSprite.frame, packedSprite.animation, 1 | n3);
            if (packedSprite.state != 5) continue;
            this.sprSnap.render(graphics, this.fxtoi(packedSprite.position.x), this.fxtoi(packedSprite.position.y) - (packedSprite.frameHeight >> 1) + this.offset_y, this.sprSnap.frame, this.sprSnap.animation, 17);
            this.sprBobber.render(graphics, this.fxtoi(packedSprite.position.x), this.fxtoi(packedSprite.position.y) - (packedSprite.frameHeight >> 1) + this.offset_y, this.sprBobber.frame, 2, 3);
        }
        if (this.sprSplash.loop != 0) {
            this.sprSplash.render(graphics, this.fxtoi(this.sprBobber.position.x), this.fxtoi(this.sprBobber.position.y) - this.fxtoi(this.sprBobber.position.z) + this.offset_y, this.sprSplash.frame, 0, 3);
        } else if (this.state > 6 && this.state <= 9) {
            if (this.sprBobber.position.z > 1) {
                graphics.setColor(0);
                n4 = this.sprBobber.frameWidth >> 1;
                graphics.fillArc(this.fxtoi(this.sprBobber.position.x) - (n4 >> 1), this.fxtoi(this.sprBobber.position.y) - (n4 >> 1) + this.offset_y, n4, n4, 0, 360);
                graphics.drawLine(this.fxtoi(this.sprBobber.position.x), this.fxtoi(this.sprBobber.position.y) + this.offset_y, this.fxtoi(this.fishingPole.x), this.playarea_h - this.sprBobber.frameHeight);
            }
            this.sprBobber.render(graphics, this.fxtoi(this.sprBobber.position.x), this.fxtoi(this.sprBobber.position.y) - this.fxtoi(this.sprBobber.position.z) + this.offset_y, this.sprBobber.frame, this.sprBobber.animation, 3);
        }
        if (this.state <= 9 && this.state >= 5) {
            n8 = (int)(255L - 255L * this.reel_tension / (long)this.line_strength);
            n4 = 0xFF0000 | n8 << 8 | n8;
            graphics.setColor(n4);
            graphics.drawLine(this.fxtoi(this.sprBobber.position.x), this.fxtoi(this.sprBobber.position.y) - this.fxtoi(this.sprBobber.position.z) + this.offset_y, this.fxtoi(this.fishingPole.x), this.playarea_h - this.imgPole.getHeight() + this.offset_y);
            graphics.drawLine(this.fxtoi(this.fishingPole.x), this.playarea_h - this.imgPole.getHeight() + this.offset_y, this.fxtoi(this.fishingPole.x), this.playarea_h + this.offset_y);
        }
        graphics.drawImage(this.imgPole, this.fxtoi(this.fishingPole.x), this.playarea_h + this.offset_y, 33);
        this.sprReel.render(graphics, this.fxtoi(this.fishingPole.x) + -5, this.playarea_h + this.offset_y, this.sprReel.frame, 0, 33);
        if ((this.nibble_time > 0L || this.state == 9 && this.isFishPulling) && this.game_time / 250L % 2L == 0L) {
            n4 = this.fxtoi(this.sprBobber.position.x) - (this.sprBobber.frameWidth >> 1) - 2 - this.imgExclaim.getWidth();
            if (n4 <= 4) {
                n4 = this.fxtoi(this.sprBobber.position.x) + (this.sprBobber.frameWidth >> 1) + 2;
            }
            graphics.drawImage(this.imgExclaim, n4, this.fxtoi(this.sprBobber.position.y) + this.offset_y, 3);
        }
        if (this.state == 9) {
            this.sprTension.render(graphics, 0, 348, 1, 0, 36);
            n8 = (int)(this.reel_tension * (long)this.sprTension.frameWidth / (long)this.line_strength);
            graphics.setClip(this.sprTension.frameWidth - n8, 348 - this.sprTension.frameHeight, n8, this.sprTension.frameHeight);
            this.sprTension.render(graphics, 0, 348, 0, 0, 36);
            graphics.setClip(0, 0, 240, 348);
            n4 = 2;
            if (this.mode == 0) {
                n4 += this.imgScore.getHeight();
            }
            n8 = this.imgMeter.getHeight() * this.fxtoi(this.currentFish.position.y) / (this.playarea_h - this.imgPole.getHeight());
            graphics.drawImage(this.imgMeter, 238, n4 + 2, 24);
            graphics.drawImage(this.imgFish, 238 - (this.imgMeter.getWidth() >> 1), n4 + 2 + n8, 3);
        }
        if (this.state == 6 || this.state == 7 && this.sprBobber.position.z > 0) {
            n4 = 18;
            int n9 = 174;
            n3 = 2;
            n2 = 346 - n9;
            for (n = 0; n < 5; ++n) {
                graphics.setColor(Constants.BORDER_COLORS[n]);
                graphics.fillRoundRect(n3 + n, n2 + n, n4 - (n << 1), n9 - (n << 1), 12, 12);
            }
            n8 = this.power * (n9 - 10) / 1500;
            n5 = n2 + 5 + n9 - 10 - n8;
            graphics.setClip(n3, n5, n4, n8);
            graphics.setColor(0xFFFF00);
            graphics.fillRoundRect(n3 + 5, n2 + 5, n4 - 10, n9 - 10, 4, 4);
            graphics.setClip(0, 0, 240, 348);
        }
        if (this.state == 12) {
            n4 = this.sprFishPrize.frameHeight;
            int n10 = this.sprFishPrize.frameWidth;
            n3 = 130;
            n2 = n4 + (this.fish_txt_h << 1) + 4 + 10;
            n = 120 - (n3 >> 1);
            int n11 = 174 - (n2 >> 1);
            Menu.drawMenuBox(graphics, n, n11, n3, n2);
            Game.addPointer(0, 0, 240, 348, -5);
            int n12 = 0;
            if (this.mode != 2 && this.isJunk(this.currentFish.type)) {
                n12 = this.fish_txt_h >> 1;
            }
            this.game.fontTiny.print(graphics, this.fish_txt, n + (n3 >> 1), n11 + 5 + 2 + n12, 17);
            this.sprFishPrize.render(graphics, n + (n3 >> 1), n11 + (n2 >> 1) + n12, this.currentFish.type, 0, 3);
            if (this.mode == 2 && this.isJunk(this.currentFish.type)) {
                this.game.fontTiny.print(graphics, Integer.toString(this.target - this.goal) + " / " + Integer.toString(this.target), n + (n3 >> 1), n11 + (n2 >> 1) + (n4 >> 1) + 2, 17);
            } else if (!this.isJunk(this.currentFish.type)) {
                String string = Integer.toString(this.weight) + this.game.strings[93];
                if (this.mode == 0) {
                    string = string + "  " + Integer.toString(this.value) + this.game.strings[92];
                }
                this.game.fontTiny.print(graphics, string, n + (n3 >> 1), n11 + (n2 >> 1) + (n4 >> 1) + 2, 17);
            }
        } else if (this.state == 13) {
            this.game.renderResultScreen(graphics, 5, this.score);
        }
        if (this.mode == 0) {
            graphics.drawImage(this.imgScore, 240, 0, 24);
            this.font.print(graphics, this.game.formatScore(this.score), 236, 2, 24);
            n4 = (int)(300000L - this.clock_time);
            int n13 = n4 / 1000;
            n3 = n4 % 1000 / 100;
            graphics.drawImage(this.imgTime, 0, 0, 20);
            String string = ".";
            this.font.print(graphics, Integer.toString(n13) + string + Integer.toString(n3), 26, 2, 20);
        }
        if (this.state <= 3) {
            this.game.drawStoplight(graphics, this.state);
        }
        if (this.state == 0) {
            this.drawIntroScreen(graphics);
        }
        if (this.state != 0 && this.state != 13) {
            n4 = 198 - this.imgDPad.getWidth();
            int n14 = 348 - this.imgDPad.getHeight() - 4;
            graphics.drawImage(this.imgDPad, n4, n14, 20);
            Game.addPointer(n4 + 24, n14, 24, 24, -1);
            Game.addPointer(n4, n14 + 24, 24, 24, -3);
            Game.addPointer(n4 + 24, n14 + 24, 24, 24, -5);
            Game.addPointer(n4 + 48, n14 + 24, 24, 24, -4);
            Game.addPointer(n4 + 24, n14 + 48, 24, 24, -2);
        }
    }

    void drawIntroScreen(Graphics graphics) {
        char[] cArray = this.game.fontTiny.wrap(this.game.strings[99], 222);
        int n = this.imgIntro.getWidth() + 10 + 8;
        int n2 = this.imgIntro.getHeight() + this.game.defaultFont.height + 10 + 8;
        int n3 = 120 - (n >> 1);
        int n4 = 174 - (n2 >> 1);
        Menu.drawMenuBox(graphics, n3, n4, n, n2);
        Game.addPointer(0, 0, 240, 348, -5);
        graphics.drawImage(this.imgIntro, n3 + (n >> 1), n4 + this.game.defaultFont.height + 5 + 4, 17);
        this.game.defaultFont.print(graphics, this.game.strings[36], n3 + (n >> 1), n4 + 2 + 5, 17);
    }

    boolean isJunk(int n) {
        return n == 10 || n == 11;
    }

    public int fxtoi(int n) {
        return n >> 8;
    }

    public int itofx(int n) {
        return n << 8;
    }

    static int angleBetweenPoints(Position position, Position position2) {
        int n = position.x;
        int n2 = position.y;
        int n3 = position2.x;
        int n4 = position2.y;
        int n5 = Math.abs(n - n3);
        if (n5 == 0) {
            if (n4 > n2) {
                return 64;
            }
            if (n4 < n2) {
                return 192;
            }
            return 0;
        }
        int n6 = Math.abs(n2 - n4);
        int n7 = Fishing.farctan(Fishing.fxdiv(n6, n5));
        if (n3 >= n && n4 <= n2) {
            n7 = 256 - n7;
        } else if (n3 < n && n4 <= n2) {
            n7 = 128 + n7;
        } else if (n3 < n && n4 > n2) {
            n7 = 128 - n7;
        }
        return n7 & 0xFF;
    }

    static int farctan(int n) {
        int n2;
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        n = Math.abs(n);
        int n5 = 0;
        while (n5 < 64 && (n2 = Math.abs(n - Constants.TAN[n5])) < n4) {
            n4 = n2;
            n3 = n5++;
        }
        return n3;
    }

    static int fsin(int n) {
        return Constants.SIN[0xFF & n];
    }

    static int fcos(int n) {
        return Constants.SIN[0xFF & 64 - n];
    }

    static int fxmul(int n, int n2) {
        return n2 * n >> 8;
    }

    static int fxdiv(int n, int n2) {
        return (n << 8) / n2;
    }
}

