/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Racquetball
implements Constants {
    public static final int MODE_RALLY = 0;
    public static final int MODE_TARGET = 1;
    public static final int TARGET_APPLE = 0;
    public static final int TARGET_BOMB = 1;
    public static final int NUM_TARGETS = 2;
    public static final int STATE_INTRO = 0;
    public static final int STATE_STOP = 1;
    public static final int STATE_READY = 2;
    public static final int STATE_GO = 3;
    public static final int STATE_TOSS = 4;
    public static final int STATE_SERVE = 5;
    public static final int STATE_PLAYING = 6;
    public static final int STATE_RESULTS = 7;
    public static final int RACQUETBALL_TIMELIMIT = 160000;
    public static final int WALL_HIT_PTS = 10;
    public static final int APPLE_HIT_PTS = 50;
    public static final int APPLE_MAX_PTS = 500;
    public static final int BOMB_HIT_PTS = -200;
    public static final int TARGET_SPEED = 400;
    public static final int TARGET_OFFSET = 2;
    public static final int BOMB_WAVES = 4;
    public static final int TARGET_WAVES = 2;
    public static final int RACQUETBALL_GRAVITY = 34;
    public static final int BALL_FRICTION = 68;
    public static final int MIN_BALL_BOUNCE = 600;
    public static final int BALL_LOFT = 300;
    public static final int NUM_HIT_ANGLES = 6;
    public static final int BALL_CURVE = 80;
    public static final int NUM_BRICK_ROWS = 6;
    public static final int BRICK_W = 14;
    Game game;
    public Animation player;
    public Animation playerEyes;
    public Animation playerHair;
    public Animation racquet;
    public Vector targets;
    public Vector bricks;
    public Position ball;
    public GraphicFont font;
    public Random rand;
    public PackedSprite sprTargets;
    public Image imgIntro;
    public Image imgBg;
    public Image imgHudMid;
    public Image imgHudEnd;
    public Image imgScore;
    public Image imgTime;
    public Image imgDPad;
    public int score;
    public int combo;
    public int wave;
    public int mode;
    public int toX;
    public int state;
    public int zone;
    public int hud_amt;
    public int hud_ticks;
    public int brick_h;
    public int target_w;
    public int target_h;
    public long game_time;
    public long clock_time;
    public long update_time;
    public long wait_time;
    public long last_tick;

    public Racquetball(Game game, int n) {
        this.game = game;
        this.mode = n;
    }

    public void init() {
        this.rand = new Random(System.currentTimeMillis());
        this.player.timer = -1L;
        this.playerEyes.timer = -1L;
        this.playerHair.timer = -1L;
        this.racquet.timer = -1L;
        int n = 20;
        this.player.position = new Position(this.itofx(120), this.itofx(348 - n));
        this.player.loop = 2;
        this.setAnim(11, -1);
        this.ball = new Position(-1, -1);
        this.ball.x = this.player.position.x + this.itofx(20);
        this.ball.y = this.player.position.y + -6144;
        this.ball.z = -1;
        this.state = 0;
        this.game_time = 0L;
        this.update_time = 0L;
        this.clock_time = 0L;
        this.last_tick = -1L;
        this.hud_amt = 0;
        this.hud_ticks = -1;
        this.score = 0;
        this.combo = 0;
        this.wave = 1;
        this.target_w = this.sprTargets.frameWidth;
        this.target_h = this.sprTargets.frameHeight;
        if (this.mode == 1) {
            this.targets = new Vector();
            this.setTargets();
        }
        this.setBrickPositions();
    }

    public int itofx(int n) {
        return n << 8;
    }

    public int fxtoi(int n) {
        return n >> 8;
    }

    public void loadRes() {
        this.player = new Animation(122, 128, this.game.findPalette(68 + this.game.playerSim.curBodyColor));
        this.playerEyes = new Animation(126 + (!this.game.playerSim.isFemale ? this.game.playerSim.faceFrame + 4 : this.game.playerSim.faceFrame), 132 + (!this.game.playerSim.isFemale ? this.game.playerSim.faceFrame + 4 : this.game.playerSim.faceFrame), this.game.findPalette(40 + this.game.playerSim.curFaceColor));
        this.playerHair = new Animation(134 + (!this.game.playerSim.isFemale ? this.game.playerSim.hairFrame + 4 : this.game.playerSim.hairFrame), 140 + (!this.game.playerSim.isFemale ? this.game.playerSim.hairFrame + 4 : this.game.playerSim.hairFrame), this.game.findPalette(48 + this.game.playerSim.curHairColor));
        this.racquet = new Animation(227, 201);
        if (this.mode == 1) {
            this.sprTargets = new PackedSprite(228, 202);
        }
        this.player.speed = 200;
        this.playerEyes.speed = 200;
        this.playerHair.speed = 200;
        this.racquet.speed = 200;
        this.imgDPad = Game.createImage(323);
        this.game.sprStopLight = new PackedSprite(258, 235);
        this.font = new GraphicFont(201, 182, "abcdefghijklmnopqrstuvwxyz1234567890/=:.", 1);
        this.imgHudMid = Game.createImage(316);
        this.imgHudEnd = Game.createImage(317);
        this.imgScore = Game.createImage(230);
        this.imgTime = Game.createImage(229);
        this.imgIntro = Game.createImage(283);
    }

    public void setAnim(int n, int n2) {
        this.player.loop = 2;
        this.playerEyes.loop = 2;
        this.playerHair.loop = 2;
        this.racquet.loop = 2;
        this.player.setAnim(n);
        this.playerEyes.setAnim(n);
        this.playerHair.setAnim(n);
        this.racquet.setAnim(n - 11);
        this.player.num_loops = n2;
        this.playerEyes.num_loops = n2;
        this.playerHair.num_loops = n2;
        this.racquet.num_loops = n2;
    }

    public void setTargets() {
        int n;
        for (n = 0; n < this.targets.size(); ++n) {
            Position position = (Position)this.targets.elementAt(n);
            position.moveTo(this.fxtoi(position.x), -1, 0, 800);
        }
        n = Math.max(Math.min(this.wave / 2, 4), 1);
        int n2 = Math.min(n - 1, this.wave / 4);
        int n3 = (230 - this.target_w * n) / (n + 1);
        int n4 = 5 + n3;
        for (int i = 0; i < n; ++i) {
            int n5;
            int n6;
            Position position = new Position(this.itofx(n4 += Math.abs(this.rand.nextInt() % n3)), 0);
            position.type = 0;
            if (n2 > 0 && (n6 = Math.abs(this.rand.nextInt() % 100)) <= (n5 = n2 * 100 / n)) {
                position.type = 1;
                --n2;
            }
            position.moveTo(n4, this.target_h, 0, 400);
            this.targets.addElement(position);
            if ((n4 += this.target_w) + this.target_w > 235) break;
        }
    }

    public void process(int n, long l) {
        int n2;
        if (this.last_tick > 0L) {
            this.game_time += l - this.last_tick;
            if (this.state >= 4 && this.state < 7) {
                this.clock_time += l - this.last_tick;
            }
        }
        this.last_tick = l;
        int n3 = 15616;
        int n4 = 8192;
        int n5 = this.ball.y - (this.player.position.y + -6144);
        int n6 = Math.abs(n5) < 100 ? 0 : n5 / 733;
        this.toX = this.ball.x;
        if (this.ball.dy != 0) {
            n2 = this.ball.dy > 0 ? this.player.position.y - this.ball.y : this.player.position.y - n3 + (this.ball.y - n3);
            this.toX += this.ball.dx * n2 / Math.abs(this.ball.dy);
        }
        switch (this.state) {
            case 0: {
                if (n != 8) break;
                this.state = 1;
                this.wait_time = this.game_time + 1000L;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (this.state == 1 && this.game_time > this.wait_time) {
                    this.wait_time = this.game_time + 1000L;
                    this.state = 2;
                }
                if (this.state == 2 && this.game_time > this.wait_time) {
                    this.wait_time = this.game_time + 500L;
                    this.state = 3;
                }
                if (this.state == 3 && this.game_time > this.wait_time) {
                    this.state = 4;
                    this.wait_time = -1L;
                }
                this.player.nextFrame(this.game_time);
                this.playerEyes.nextFrame(this.game_time);
                this.playerHair.nextFrame(this.game_time);
                this.racquet.nextFrame(this.game_time);
                break;
            }
            case 4: 
            case 5: {
                if (n != 0) {
                    switch (n) {
                        case 2: 
                        case 52: {
                            break;
                        }
                        case 5: 
                        case 54: {
                            break;
                        }
                        case 8: 
                        case 53: {
                            if (this.state == 4 && this.ball.z <= 0 && this.player.animation == 11) {
                                this.ball.x = this.player.position.x + this.itofx(20);
                                this.ball.y = this.player.position.y + -6144;
                                this.ball.z = this.itofx(this.player.frameHeight >> 1);
                                this.ball.dz = 400;
                                this.setAnim(12, 1);
                                this.state = 5;
                                break;
                            }
                            if (this.state != 5 || this.ball.z < 600) break;
                            this.ball.z = this.itofx(this.player.frameHeight >> 1);
                            this.ball.dx = 0;
                            this.ball.dy = -1600;
                            this.ball.dz = 0;
                            this.setAnim(13, 1);
                            this.state = 6;
                        }
                    }
                }
                this.toX = -1;
                if (this.mode == 1) {
                    for (n2 = this.targets.size() - 1; n2 >= 0; --n2) {
                        Position position = (Position)this.targets.elementAt(n2);
                        int n7 = position.x + this.itofx(this.target_w >> 1) - n4 + this.itofx(7);
                        n5 = Math.abs(n7 - this.player.position.x);
                        if ((n5 < Math.abs(this.player.position.x - this.toX) || this.toX < 0) && position.type == 0) {
                            this.toX = n7;
                        }
                        position.tick();
                    }
                }
                if (this.game_time > this.update_time && this.toX > 0) {
                    if (this.player.loop == 0 && this.player.animation != 12) {
                        this.setAnim(11, -1);
                    }
                    if (this.player.position.x < this.toX) {
                        this.player.position.x += Math.min(500, this.toX - this.player.position.x);
                        if (this.player.animation != 14) {
                            this.setAnim(14, 1);
                        }
                    } else if (this.player.position.x > this.toX) {
                        this.player.position.x -= Math.min(500, this.player.position.x - this.toX);
                        if (this.player.animation != 15) {
                            this.setAnim(15, 1);
                        }
                    }
                }
                if (this.mode == 1 && this.clock_time >= 160000L) {
                    this.state = 7;
                    this.game.setResultScreen(2, this.score);
                }
                if (this.game_time > this.update_time) {
                    this.ball.dz -= 34;
                    this.ball.z += this.ball.dz;
                    if (this.ball.z <= 0) {
                        this.ball.z = 0;
                        if (this.state == 5) {
                            this.state = 4;
                            this.setAnim(11, -1);
                        }
                    }
                }
                this.player.nextFrame(this.game_time);
                this.playerEyes.nextFrame(this.game_time);
                this.playerHair.nextFrame(this.game_time);
                this.racquet.nextFrame(this.game_time);
                break;
            }
            case 6: {
                if (n != 0) {
                    switch (n) {
                        case 8: 
                        case 53: {
                            if (this.player.animation == 17 || this.player.animation == 16) break;
                            this.wait_time = this.game_time + 250L;
                            break;
                        }
                    }
                }
                if (this.wait_time > 0L) {
                    if (this.game_time >= this.wait_time) {
                        this.wait_time = -1L;
                    }
                    if (Math.abs(n5) <= 4400) {
                        this.wait_time = -1L;
                        this.ball.dy = -1600;
                        this.ball.dz = 300;
                        if (this.ball.x < this.player.position.x) {
                            this.setAnim(17, 1);
                            this.ball.dx = -n6 * 80;
                        } else {
                            this.setAnim(16, 1);
                            this.ball.dx = n6 * 80;
                        }
                    }
                }
                if (this.game_time > this.update_time) {
                    this.ball.dz -= 34;
                    this.ball.x += this.ball.dx;
                    this.ball.z += this.ball.dz;
                    this.ball.y = this.ball.dy > 0 && Math.abs(n5) <= 4400 ? (this.ball.y += this.ball.dy >> 1) : (this.ball.y += this.ball.dy);
                    if (this.ball.z <= 0) {
                        this.ball.z = 0;
                        this.ball.dz = Math.abs(this.ball.dz) - 68;
                        this.ball.dz = Math.max(this.ball.dz, 600);
                        if (this.ball.dy != 0) {
                            this.ball.dy = this.ball.dy > 0 ? (this.ball.dy -= 68) : (this.ball.dy += 68);
                        }
                        if (this.ball.dx != 0) {
                            this.ball.dx = this.ball.dx > 0 ? (this.ball.dx -= 68) : (this.ball.dx += 68);
                        }
                    }
                    if (this.ball.y <= n3 && this.ball.x >= this.itofx(5) && this.ball.x <= this.itofx(235)) {
                        ++this.combo;
                        this.score += 10;
                        this.ball.y = n3;
                        this.ball.dy = -Math.min(this.ball.dy, 800);
                        if (Math.abs(this.ball.dx) >= 240) {
                            if (this.ball.dx > 0) {
                                this.ball.dx -= 68;
                            } else if (this.ball.dx < 0) {
                                this.ball.dx += 68;
                            }
                        }
                        if (this.ball.dz > 0) {
                            this.ball.dz -= 68;
                        }
                        for (n2 = 0; n2 < this.targets.size(); ++n2) {
                            Position position = (Position)this.targets.elementAt(n2);
                            if (this.ball.x < position.x || this.ball.x > position.x + this.itofx(this.target_w)) continue;
                            switch (position.type) {
                                case 0: {
                                    this.score += Math.min(50 * this.combo, 500);
                                    break;
                                }
                                case 1: {
                                    this.score += -200;
                                }
                            }
                            position.moveTo(this.fxtoi(position.x), -1, 0, 800);
                        }
                    }
                    if (this.ball.x <= 0 || this.ball.x > this.itofx(240) || this.ball.y > this.itofx(348) && Math.abs(n5) > 4400 || this.ball.y <= 0) {
                        this.combo = 0;
                        this.ball.z = -1;
                        this.ball.dz = -1;
                        this.ball.y = this.player.position.y + -6144;
                        if (this.mode == 0) {
                            this.state = 7;
                            this.game.setResultScreen(2, this.score);
                        } else {
                            this.wait_time = -1L;
                            this.state = 4;
                            this.setAnim(11, -1);
                            return;
                        }
                    }
                    if (this.mode == 1 && this.clock_time >= 160000L) {
                        this.state = 7;
                        this.game.setResultScreen(2, this.score);
                    }
                    if (this.player.animation == 11 || this.player.animation == 15 || this.player.animation == 14) {
                        n2 = this.player.position.x + n4 - this.itofx(7);
                        int n8 = this.player.position.x - n4 + this.itofx(7);
                        int n9 = Math.abs(this.toX - n2);
                        int n10 = Math.abs(this.toX - n8);
                        int n11 = n4 + (n4 >> 1);
                        if (n9 > n11 || n10 > n11) {
                            this.player.position.dx = 0;
                            this.player.position.dx = n9 <= n10 ? this.toX - n4 + this.itofx(7) : this.toX + n4 - this.itofx(7);
                            if (this.player.position.dx != 0) {
                                int n12 = Math.max(Math.min(this.player.position.dx - this.player.position.x, 500), -500);
                                this.player.position.x += n12;
                                if (n12 > 0 && this.player.animation != 14) {
                                    this.setAnim(14, 1);
                                } else if (n12 < 0 && this.player.animation != 15) {
                                    this.setAnim(15, 1);
                                }
                            } else if (this.player.animation != 11) {
                                this.setAnim(11, -1);
                            }
                        } else if (this.player.animation != 11) {
                            this.setAnim(11, -1);
                        }
                    }
                }
                this.player.nextFrame(this.game_time);
                this.playerEyes.nextFrame(this.game_time);
                this.playerHair.nextFrame(this.game_time);
                this.racquet.nextFrame(this.game_time);
                if (this.mode == 1) {
                    n2 = 0;
                    for (int i = this.targets.size() - 1; i >= 0; --i) {
                        Position position = (Position)this.targets.elementAt(i);
                        position.tick();
                        if (position.type != 1) {
                            ++n2;
                        }
                        if (position.moving || position.y > 0) continue;
                        this.targets.removeElementAt(i);
                    }
                    if (n2 == 0) {
                        ++this.wave;
                        this.setTargets();
                    }
                }
                if (this.player.loop != 0) break;
                this.setAnim(11, -1);
                break;
            }
            case 7: {
                if (n == 0) break;
                switch (n) {
                    case 8: 
                    case 53: {
                        this.game.state = this.game.isMini ? 4 : 2;
                    }
                }
            }
        }
        if (this.game_time > this.update_time) {
            this.update_time = this.game_time + 30L;
        }
    }

    public void render(Graphics graphics) {
        int n;
        int n2;
        int n3;
        this.drawBackground(graphics);
        graphics.setClip(0, 0, 240, this.fxtoi(15616) + 2);
        if (this.mode == 1) {
            for (n3 = 0; n3 < this.targets.size(); ++n3) {
                Position position = (Position)this.targets.elementAt(n3);
                n2 = this.target_w >> 1;
                n = this.target_h >> 1;
                this.sprTargets.render(graphics, this.fxtoi(position.x) + n2, this.fxtoi(15616 - position.y) + 2 + n, position.type, 0, 3);
            }
        }
        graphics.setClip(0, 0, 240, 348);
        if (this.state >= 6 || this.state >= 4 && this.ball.z > 0) {
            graphics.setColor(0);
            graphics.fillArc(this.fxtoi(this.ball.x) - 3, this.fxtoi(this.ball.y) - 3, 7, 7, 10, 360);
            graphics.setColor(1163454);
            graphics.fillArc(this.fxtoi(this.ball.x) - 3, this.fxtoi(this.ball.y) - 3 - this.fxtoi(this.ball.z), 7, 7, 0, 360);
        }
        this.player.render(graphics, this.fxtoi(this.player.position.x), this.fxtoi(this.player.position.y), this.player.frame, this.player.animation, 33);
        this.playerEyes.render(graphics, this.fxtoi(this.player.position.x), this.fxtoi(this.player.position.y), this.playerEyes.frame, this.playerEyes.animation, 33);
        this.playerHair.render(graphics, this.fxtoi(this.player.position.x), this.fxtoi(this.player.position.y), this.playerHair.frame, this.playerHair.animation, 33);
        this.racquet.render(graphics, this.fxtoi(this.player.position.x), this.fxtoi(this.player.position.y), this.racquet.frame, this.racquet.animation, 33);
        n3 = 238;
        int n4 = 64;
        n2 = this.imgHudEnd.getHeight();
        n = 120 - (n3 >> 1);
        int n5 = this.player.position.y + -6144 - this.ball.y;
        n = Math.max(n, 2);
        n = Math.min(n, 238 - n3);
        int n6 = 0;
        int n7 = this.imgHudEnd.getWidth() >> 1;
        graphics.setClip(n6, 0, n7, 348);
        graphics.drawImage(this.imgHudEnd, n6, 348, 36);
        n6 += n7;
        while (n6 < 240 - (n7 << 1)) {
            graphics.setClip(n6, 0, n7, 348);
            graphics.drawImage(this.imgHudEnd, n6 - n7, 348, 36);
            n6 += n7;
        }
        graphics.setClip(240 - (n7 << 1), 0, n7, 348);
        graphics.drawImage(this.imgHudEnd, 240 - (n7 << 1) - n7, 348, 36);
        graphics.setClip(0, 0, 240, 348);
        graphics.drawRegion(this.imgHudEnd, 0, 0, n7, this.imgHudEnd.getHeight(), 2, 240, 348, 40);
        graphics.drawImage(this.imgHudMid, 120, 348, 40);
        graphics.drawRegion(this.imgHudMid, 0, 0, this.imgHudMid.getWidth(), this.imgHudMid.getHeight(), 2, 120, 348, 36);
        int n8 = this.player.position.y + -6144 - 15616;
        int n9 = (n4 >> 1) + (Math.abs(n5) - 4400) * (n3 - n4 >> 1) / (n8 - 4400);
        if (n5 < 0) {
            n9 = -n9;
        }
        if (Math.abs(n5) < 4400) {
            n9 = n5 * (n4 >> 1) / 4400;
        }
        if (this.toX > this.player.position.x) {
            n9 = -n9;
        }
        if (Math.abs(this.hud_amt - n9) > n4 >> 1 && this.hud_ticks <= 0) {
            this.hud_ticks = 10;
        } else if (this.hud_ticks > 0) {
            this.hud_amt += (n9 - this.hud_amt) / this.hud_ticks;
            if (--this.hud_ticks <= 0) {
                this.hud_ticks = -1;
                this.hud_amt = n9;
            }
        } else {
            this.hud_amt = n9;
        }
        int n10 = Math.max(Math.min(n + (n3 >> 1) + this.hud_amt, 232), 8);
        graphics.setColor(0);
        graphics.fillArc(n10 - 4, 348 - (n2 >> 1) - 4, 9, 9, 0, 360);
        graphics.setColor(1163454);
        graphics.fillArc(n10 - 3, 348 - (n2 >> 1) - 3, 7, 7, 0, 360);
        graphics.drawImage(this.imgScore, 240, 0, 24);
        this.font.print(graphics, this.game.formatScore(this.score), 236, 8, 10);
        if (this.mode == 1) {
            n6 = Math.max((int)(160000L - this.clock_time), 0);
            n7 = n6 / 1000;
            n8 = n6 % 1000 / 10;
            graphics.drawImage(this.imgTime, 0, 0, 20);
            String string = ".";
            this.font.print(graphics, Integer.toString(n7) + string + Integer.toString(n8), 43, 8, 3);
        }
        if (this.state == 0) {
            this.drawIntroScreen(graphics);
        } else if (this.state <= 3) {
            this.game.drawStoplight(graphics, this.state);
        } else if (this.state == 7) {
            this.game.renderResultScreen(graphics, 2, this.score);
        }
        if (this.state != 0 && this.state != 7) {
            n6 = 240 - this.imgDPad.getWidth() - 4;
            n7 = (348 - this.imgDPad.getHeight() >> 1) - 4;
            graphics.drawImage(this.imgDPad, n6, n7, 20);
            Game.addPointer(n6, n7, this.imgDPad.getWidth(), this.imgDPad.getHeight(), -5);
        }
    }

    void drawIntroScreen(Graphics graphics) {
        char[] cArray = this.game.fontTiny.wrap(this.game.strings[96], 222);
        int n = this.imgIntro.getWidth() + 10 + 8;
        int n2 = this.imgIntro.getHeight() + this.game.defaultFont.height + 10 + 8;
        int n3 = 120 - (n >> 1);
        int n4 = 174 - (n2 >> 1);
        Menu.drawMenuBox(graphics, n3, n4, n, n2);
        Game.addPointer(0, 0, 240, 348, -5);
        graphics.drawImage(this.imgIntro, n3 + (n >> 1), n4 + this.game.defaultFont.height + 5 + 4, 17);
        this.game.defaultFont.print(graphics, this.game.strings[33], n3 + (n >> 1), n4 + 2 + 5, 17);
    }

    void drawBackground(Graphics graphics) {
        if (this.imgBg == null) {
            Image image = Image.createImage((int)240, (int)348);
            Graphics graphics2 = image.getGraphics();
            graphics2.setColor(8962394);
            graphics2.fillRect(0, 0, 240, 348);
            int n = 5;
            int n2 = 61;
            int n3 = 240 - (n << 1);
            int n4 = 348 - n2 - 21;
            int n5 = n;
            int n6 = n2 - 1;
            graphics2.setColor(14958102);
            graphics2.fillRect(n5, n6, n3, n4);
            int n7 = n3 / 7;
            graphics2.setColor(0xEEEEEE);
            n4 -= n4 / 6;
            int n8 = 0;
            graphics2.drawRect((n5 += n7 >> 1) + n8, n6, 240 - (n5 << 1) - (n8 >> 1), n4 - n8);
            graphics2.drawRect(n5 + ++n8, n6, 240 - (n5 << 1) - (n8 >> 1), n4 - n8);
            n8 = 0;
            graphics2.drawRect((n5 += n7) + n8, n6, 240 - (n5 << 1) - (n8 >> 1), n4 - n8);
            graphics2.drawRect(n5 + ++n8, n6, 240 - (n5 << 1) - (n8 >> 1), n4 - n8);
            n8 = 0;
            graphics2.drawRect(n5 + n8, n6, 240 - (n5 << 1) - (n8 >> 1), (n4 >>= 1) - n8);
            graphics2.drawRect(n5 + ++n8, n6, 240 - (n5 << 1) - (n8 >> 1), n4 - n8);
            n5 = 119;
            graphics2.drawLine(n5, n6, n5, n6 + n4);
            graphics2.drawLine(++n5, n6, n5, n6 + n4);
            int n9 = n2 - 10;
            int n10 = 240 - (n << 1);
            graphics2.setColor(10702419);
            graphics2.fillRect(n, 10, n10, n9);
            for (int i = 0; i < this.bricks.size(); ++i) {
                n5 = ((Position)this.bricks.elementAt((int)i)).x;
                n6 = ((Position)this.bricks.elementAt((int)i)).y;
                graphics2.setColor(10900819);
                graphics2.fillRect(n5 + 1, n6, 12, this.brick_h - 1);
                graphics2.setColor(9584968);
                graphics2.fillRect(n5, n6 + 1, 13, this.brick_h - 2);
            }
            this.imgBg = Image.createImage((Image)image);
        }
        graphics.drawImage(this.imgBg, 0, 0, 20);
    }

    void setBrickPositions() {
        this.bricks = new Vector();
        int n = 51;
        int n2 = 230;
        this.brick_h = n / 6;
        for (int i = 0; i < 6; ++i) {
            int n3 = 10 + this.brick_h * i;
            int n4 = Math.abs(this.rand.nextInt()) % 3 + 1;
            for (int j = 0; j < n4; ++j) {
                int n5 = n2 / n4;
                int n6 = 5 + j * n5 + Math.abs(this.rand.nextInt()) % (n5 - 14);
                this.bricks.addElement(new Position(n6, n3));
            }
        }
    }
}

