/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Animation
implements Constants {
    static final int DUPLICATE_MASK = 128;
    static final int ROTATION_MASK = 7;
    static final int LOOP_NONE = 0;
    static final int LOOP_ONCE = 1;
    static final int LOOP_WRAP = 2;
    static final int LOOP_PINGPONG = 3;
    static final int COLLISION_TYPE_NORMAL = 0;
    static final int COLLISION_TYPE_FLIPPED = 1;
    static final int PART_X_OFFSET = 0;
    static final int PART_Y_OFFSET = 1;
    static final int PART_ROTATION = 2;
    static final int PART_PARENT = 3;
    static final int NUM_PART_DATA = 4;
    static final int PACK_X = 0;
    static final int PACK_Y = 1;
    static final int PACK_WIDTH = 2;
    static final int PACK_HEIGHT = 3;
    static final int NUM_PACK_DATA = 4;
    static final int FRAME_NUM_PARTS = 0;
    static final int FRAME_PARTS_START = 1;
    Image image;
    int version;
    int frame;
    int animation;
    int defaultFrame;
    int startFrame;
    int endFrame;
    int frameWidth;
    int frameHeight;
    int frames;
    int numAnimations;
    int speed;
    long timer;
    int num_loops;
    int loop;
    int direction;
    boolean finishedLoop;
    short[] packData;
    short[] partData;
    short[][][] frameData;
    Position position;

    Animation() {
    }

    Animation(Image image, int n) {
        this.init(image, n);
    }

    Animation(int n, int n2) {
        this.init(Game.createImage(n), n2);
    }

    Animation(int n, int n2, int[] nArray) {
        this.init(Game.createImage(n, nArray), n2);
    }

    Animation copyData(Image image) {
        Animation animation = new Animation();
        animation.version = this.version;
        animation.partData = this.partData;
        animation.packData = this.packData;
        animation.frameData = this.frameData;
        animation.frameWidth = this.frameWidth;
        animation.frameHeight = this.frameHeight;
        animation.numAnimations = this.numAnimations;
        animation.startFrame = 0;
        animation.frames = this.frameData[0].length;
        animation.defaultFrame = animation.endFrame = animation.frames - 1;
        animation.finishedLoop = false;
        animation.loop = 2;
        animation.direction = 1;
        animation.position = new Position();
        animation.image = image;
        return animation;
    }

    void init(Image image, int n) {
        this.image = image;
        InputStream inputStream = MySims.canvas.parent.getClass().getResourceAsStream("/" + n + ".bin");
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            this.version = dataInputStream.readUnsignedByte();
            if (this.version == 2) {
                this.frameWidth = dataInputStream.readShort();
                this.frameHeight = dataInputStream.readShort();
                this.numAnimations = dataInputStream.readUnsignedByte();
                this.partData = new short[dataInputStream.readShort() * 4];
                this.packData = new short[dataInputStream.readShort() * 4];
                this.frameData = new short[this.numAnimations][][];
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                for (int i = 0; i < this.numAnimations; ++i) {
                    int n5 = dataInputStream.readUnsignedByte();
                    this.frameData[i] = new short[n5][];
                    for (int j = 0; j < n5; ++j) {
                        int n6 = dataInputStream.readUnsignedByte();
                        this.frameData[i][j] = new short[2];
                        this.frameData[i][j][0] = (short)n6;
                        this.frameData[i][j][1] = (short)n2;
                        for (int k = 0; k < n6; ++k) {
                            int n7 = dataInputStream.readUnsignedByte();
                            this.partData[n2 + 0] = (short)dataInputStream.readUnsignedShort();
                            this.partData[n2 + 1] = (short)dataInputStream.readUnsignedShort();
                            this.partData[n2 + 2] = (byte)(n7 & 7);
                            if ((n7 & 0x80) != 128) {
                                this.packData[n3 + 0] = (short)dataInputStream.readUnsignedShort();
                                this.packData[n3 + 1] = (short)dataInputStream.readUnsignedShort();
                                this.packData[n3 + 2] = (short)dataInputStream.readUnsignedByte();
                                this.packData[n3 + 3] = (short)dataInputStream.readUnsignedByte();
                                this.partData[n2 + 3] = (short)n4;
                                ++n4;
                                n3 += 4;
                            } else {
                                int n8 = dataInputStream.readUnsignedShort();
                                this.partData[n2 + 3] = this.partData[n8 * 4 + 3];
                            }
                            n2 += 4;
                        }
                    }
                }
                this.frames = this.frameData[0].length;
            }
            this.startFrame = 0;
            this.defaultFrame = this.endFrame = this.frames - 1;
            this.loop = 2;
            this.direction = 1;
            this.position = new Position();
        }
        catch (Exception exception) {
            System.out.println("Animation " + n + " " + exception);
        }
    }

    boolean collide(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.version == 2) {
            int n7 = this.position.x;
            if (n6 == 1) {
                n7 = 61440 - this.position.x;
                n = 61440 - n + (this.frameWidth << 8);
            }
            if (n + n3 >= n7 && n <= n7 + (this.frameWidth << 8) && n2 + n4 >= this.position.y && n2 <= this.position.y + (this.frameHeight << 8)) {
                if (n5 < 0) {
                    n5 = this.frameData[this.animation][this.frame][0];
                }
                for (int i = 0; i < n5; ++i) {
                    int n8;
                    int n9 = this.frameData[this.animation][this.frame][1] + i * 4;
                    int n10 = this.partData[n9 + 3] * 4;
                    int n11 = this.packData[n10 + 2] << 8;
                    int n12 = this.packData[n10 + 3] << 8;
                    if (this.partData[n9 + 2] >= 4 && this.partData[n9 + 2] <= 7) {
                        n8 = n11;
                        n11 = n12;
                        n12 = n8;
                    }
                    n8 = n7;
                    int n13 = this.position.y;
                    if (n + n3 < (n8 += this.partData[n9 + 0] << 8) || n > n8 + n11 || n2 + n4 < (n13 += this.partData[n9 + 1] << 8) || n2 > n13 + n12) continue;
                    return true;
                }
            }
        }
        return false;
    }

    void setAnim(int n) {
        this.animation = n;
        this.frames = this.frameData[n].length;
        this.startFrame = 0;
        this.defaultFrame = this.endFrame = this.frames - 1;
        this.frame = 0;
        this.finishedLoop = false;
    }

    void nextFrame(long l) {
        if (this.speed > 0) {
            if (l - this.timer > (long)this.speed) {
                this.timer = l;
            } else {
                return;
            }
        }
        this.nextFrame();
    }

    void nextFrame() {
        this.finishedLoop = false;
        if (this.loop != 0) {
            this.frame += this.direction;
        }
        if (this.frame < this.startFrame || this.frame > this.endFrame) {
            this.finishedLoop = true;
            switch (this.loop) {
                case 2: {
                    this.frame = this.startFrame;
                    break;
                }
                case 3: {
                    this.direction = -this.direction;
                    this.frame += this.direction << 1;
                    this.frame = Math.max(this.frame, this.startFrame);
                    this.frame = Math.min(this.frame, this.endFrame);
                    break;
                }
                case 1: {
                    this.frame = this.defaultFrame;
                }
            }
            if (this.num_loops > 0) {
                --this.num_loops;
                if (this.num_loops <= 0) {
                    this.loop = 0;
                    this.frame = this.defaultFrame;
                }
            }
        }
    }

    void render(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n3 < 0 || n4 < 0) {
            return;
        }
        if (this.version == 2) {
            for (int i = 0; i < this.frameData[n4][n3][0]; ++i) {
                int n6 = this.frameData[n4][n3][1] + i * 4;
                int n7 = this.partData[n6 + 3] * 4;
                short s = this.packData[n7 + 2];
                short s2 = this.packData[n7 + 3];
                if (s == 0 || s2 == 0) continue;
                int n8 = n;
                int n9 = n2;
                n8 += this.partData[n6 + 0];
                n9 += this.partData[n6 + 1];
                if ((n5 & 1) != 0) {
                    n8 -= this.frameWidth >> 1;
                } else if ((n5 & 8) != 0) {
                    n8 -= this.frameWidth - 1;
                }
                if ((n5 & 2) != 0) {
                    n9 -= this.frameHeight >> 1;
                } else if ((n5 & 0x20) != 0) {
                    n9 -= this.frameHeight - 1;
                }
                short s3 = this.packData[n7 + 0];
                short s4 = this.packData[n7 + 1];
                graphics.drawRegion(this.image, (int)s3, (int)s4, (int)s, (int)s2, (int)this.partData[n6 + 2], n8, n9, 20);
            }
        }
    }
}

