/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Skydiving
implements Constants {
    public static final int DIAMOND_BLUE = 0;
    public static final int DIAMOND_PINK = 1;
    public static final int DIAMOND_RED = 2;
    public static final int POP = 3;
    public static final int NUM_OBJECTS = 4;
    public static final int NUM_DIAMOND_COLORS = 3;
    public static final int STATE_INTRO = 0;
    public static final int STATE_STOP = 1;
    public static final int STATE_READY = 2;
    public static final int STATE_GO = 3;
    public static final int STATE_PLAYING = 4;
    public static final int STATE_ENDING = 5;
    public static final int STATE_FLOAT = 6;
    public static final int STATE_LANDING = 7;
    public static final int STATE_CRASHING = 8;
    public static final int STATE_RESULTS = 9;
    public static final int SKY_DIMAOND_SPACING = 8;
    public static final int DIAMOND_SHIFT_FREQUENCY = 3;
    public static final int SKYDIVE_DIAMOND_SPEED = 500;
    public static final int SKYDIVE_DIAMOND_PTS = 200;
    public static final int SKYDIVE_ACCEL = 40;
    public static final int GEM_BUFFER = 5;
    public static final int SKYDIVE_FRICTION = 10;
    public static final int SKYDIVE_FLOAT_SPEED = 400;
    public static final int VELOCITY_INCREMENT = 100;
    public static final int VELOCITY_INCREMENT_TIME = 4000;
    public static final int SKYDIVE_LANDING_ZONE_START = 95;
    public static final int SKYDIVE_LANDING_ZONE_HEIGHT = 5;
    public static final int SKYDIVE_COMBO_LENGTH = 5;
    public static final int SKYDIVE_TIMELIMIT = 60000;
    public Game game;
    public Animation player;
    public PackedSprite sprButton;
    public Image imgIntro;
    public Image imgForeground;
    public Image imgBackground;
    public Image imgPop;
    public Image imgHud;
    public Image imgHudBar;
    public Image imgHudTile;
    public Image imgHudBottom;
    public Image[] imgCloud;
    public Image[] imgDiamond;
    public Image imgDPad;
    public GraphicFont font;
    public Vector objects;
    public Vector clouds;
    public Random rand;
    public Position foreground;
    public Position background;
    public int start_height;
    public int height;
    public int counter;
    public int combo;
    public int velocity;
    public int score;
    public int state;
    public int last_x;
    public int num_hits;
    public int last_pos;
    public int velocityIncrement;
    public long spin_time;
    public long wait_time;
    public long spawn_time;
    public long bird_spawn;
    public long game_time;
    public long clock_time;
    public long last_tick;
    public long last_increment;
    boolean createNextRight;

    public Skydiving(Game game) {
        this.game = game;
    }

    public void init() {
        this.objects = new Vector();
        this.clouds = new Vector();
        this.rand = new Random(System.currentTimeMillis());
        this.clouds.removeAllElements();
        for (int i = 3; i >= 0; --i) {
            int n = Math.max(i, 2);
            for (int j = 0; j < n; ++j) {
                int n2 = i % 4;
                int n3 = 348 * j / n;
                int n4 = (this.rand.nextInt() >>> 1) % 4;
                int n5 = 48 + 240 * n4 / 6;
                Position position = new Position(this.itofx(n5), this.itofx(n3));
                position.param1 = n2;
                position.moveTo(n5, -this.imgCloud[n2].getHeight(), 0, 50 + (4 - n2) * 100);
                this.clouds.addElement(position);
            }
        }
        this.player.timer = -1L;
        this.player.position = new Position(this.itofx(120), this.itofx(87));
        this.player.loop = 2;
        this.player.setAnim(6);
        this.state = 0;
        this.game_time = 0L;
        this.last_tick = -1L;
        this.velocity = 300;
        this.height = this.start_height = 60000 * this.velocity / 1000;
        this.counter = 0;
        this.combo = 0;
        this.score = 0;
        this.num_hits = 0;
        this.spawn_time = this.height;
        this.foreground = new Position(0, this.itofx(this.imgForeground.getHeight()));
        this.background = new Position(this.itofx(120), 0);
        this.last_x = this.itofx(120);
    }

    public int itofx(int n) {
        return n << 8;
    }

    public int fxtoi(int n) {
        return n >> 8;
    }

    public void loadRes() {
        int n;
        this.player = new Animation(215, 194);
        this.player.speed = 250;
        this.font = new GraphicFont(201, 182, "abcdefghijklmnopqrstuvwxyz1234567890/=:.", 1);
        this.imgDiamond = new Image[3];
        this.imgDiamond[0] = Game.createImage(216);
        for (n = 0; n < 2; ++n) {
            this.imgDiamond[n + 1] = Game.createImage(216, this.game.findPalette(106 + n));
        }
        this.imgCloud = new Image[4];
        for (n = 0; n < 4; ++n) {
            this.imgCloud[n] = Game.createImage(217 + n);
        }
        this.sprButton = new PackedSprite(257, 234);
        this.sprButton.speed = 100;
        this.imgPop = Game.createImage(224);
        this.imgDPad = Game.createImage(321);
        this.game.sprStopLight = new PackedSprite(258, 235);
        this.imgForeground = Game.createImage(221);
        this.imgBackground = Game.createImage(222);
        this.imgHud = Game.createImage(231);
        this.imgHudBar = Game.createImage(232);
        this.imgHudTile = Game.createImage(234);
        this.imgHudBottom = Game.createImage(233);
        this.imgIntro = Game.createImage(291);
    }

    public void createDiamond(int n) {
        if (this.counter < 3) {
            PackedSprite packedSprite = new PackedSprite(this.imgDiamond[n], 195);
            packedSprite.speed = 200;
            packedSprite.type = n;
            int n2 = 348 + packedSprite.frameWidth;
            int n3 = this.last_x;
            if (this.counter == 0) {
                this.last_pos = Math.abs(this.rand.nextInt() % 8);
                n3 = this.itofx(240 * this.last_pos / 8);
                this.createNextRight = false;
                if (this.last_pos < 3) {
                    this.createNextRight = true;
                }
            } else {
                if (this.createNextRight) {
                    ++this.last_pos;
                    this.last_pos %= 8;
                } else {
                    --this.last_pos;
                    if (this.last_pos < 0) {
                        this.last_pos = 7;
                    }
                }
                n3 = this.itofx(240 * this.last_pos / 8);
            }
            int n4 = 40;
            n3 = Math.min(n3, this.itofx(240 - n4));
            n3 = Math.max(n3, this.itofx(n4));
            packedSprite.position = new Position(n3, this.itofx(n2));
            packedSprite.position.moveTo(this.fxtoi(n3), -packedSprite.frameHeight, 0, this.velocity);
            this.objects.addElement(packedSprite);
            if (this.counter == 0) {
                this.last_x = n3;
            }
        }
        if (++this.counter > 3) {
            this.counter = 0;
        }
    }

    public void process(int n, int n2, long l) {
        int n3;
        int n4;
        int n5;
        if (this.last_tick > 0L) {
            n5 = (int)(l - this.last_tick);
            this.game_time += (long)n5;
            if (this.state >= 4 && this.state < 9) {
                this.height -= n5 * this.velocity / 1000;
                this.height = Math.max(this.height, 0);
                this.clock_time += (long)n5;
            }
        }
        this.last_tick = l;
        n5 = 0;
        switch (this.state) {
            case 0: {
                if (n != 8) break;
                this.state = 1;
                this.wait_time = this.game_time + 1000L;
                break;
            }
            case 1: {
                if (this.game_time <= this.wait_time) break;
                this.wait_time = this.game_time + 1000L;
                this.state = 2;
                break;
            }
            case 2: {
                if (this.game_time <= this.wait_time) break;
                this.wait_time = this.game_time + 500L;
                this.state = 3;
                break;
            }
            case 3: {
                if (this.game_time <= this.wait_time) break;
                this.state = 4;
                break;
            }
            case 4: {
                n4 = 0;
                if (n2 != 0) {
                    if ((n2 & 0x20) != 0 || (n2 & 0x1000) != 0) {
                        if (this.height <= this.start_height * 5 / 100 && this.height >= this.start_height * 5 / 100 - this.start_height * 5 / 100) {
                            this.velocity = 300;
                            this.player.position.moveTo(this.fxtoi(this.player.position.x), 348 + (this.player.frameHeight >> 1), 0, 1200);
                            this.state = 5;
                            this.wait_time = -1L;
                            return;
                        }
                        if (this.player.position.dx != 0 && this.player.animation != 8 && this.player.animation != 7) {
                            this.player.num_loops = 1;
                            this.player.loop = 1;
                            if (this.player.position.dx > 0) {
                                this.velocity = 200;
                                this.player.setAnim(8);
                                this.player.position.dx = 800;
                            } else {
                                this.velocity = 200;
                                this.player.setAnim(7);
                                this.player.position.dx = -800;
                            }
                        }
                    } else if ((n2 & 0x800) != 0 || (n2 & 8) != 0) {
                        n4 = 1;
                        this.player.position.dx = Math.max(this.player.position.dx -= 40, -400);
                        this.velocity = Math.min(this.velocity + 20, 1200);
                    } else if ((n2 & 0x2000) != 0 || (n2 & 0x10) != 0) {
                        n4 = 1;
                        this.player.position.dx = Math.min(this.player.position.dx += 40, 400);
                        this.velocity = Math.min(this.velocity + 20, 1200);
                    }
                }
                if (l - this.last_increment >= 4000L) {
                    this.last_increment = l;
                    this.velocityIncrement += 100;
                }
                if (n4 == 0) {
                    this.velocity = Math.max(this.velocity - 20, 300 + this.velocityIncrement);
                }
                this.sprButton.nextFrame(l);
                n5 = Math.abs(this.player.position.dx);
                if (n5 > 0) {
                    n5 = Math.max(n5 - 10, 0);
                    if (this.player.position.dx > 0) {
                        this.player.position.dx = n5;
                    } else if (this.player.position.dx < 0) {
                        this.player.position.dx = -n5;
                    }
                }
                this.player.position.x += this.player.position.dx;
                this.player.position.x = Math.max(0, this.player.position.x);
                this.player.position.x = Math.min(this.itofx(240), this.player.position.x);
                if (this.player.loop != 1) {
                    this.player.loop = 2;
                    if (this.player.position.dx == 0 && this.player.animation != 6) {
                        this.player.setAnim(6);
                    } else if (this.player.position.dx > 0 && this.player.animation != 5) {
                        this.player.setAnim(5);
                    } else if (this.player.position.dx < 0 && this.player.animation != 4) {
                        this.player.setAnim(4);
                    }
                }
                if ((long)this.height <= this.spawn_time && 100 * this.height / this.start_height > 10) {
                    n3 = Math.min(this.combo / 5, 2);
                    this.createDiamond(n3);
                    this.spawn_time = this.height - 750;
                }
                this.processGems();
                if (this.height > 0 || this.objects.size() != 0) break;
                this.velocity = 300;
                this.player.position.moveTo(120, 348, 0, 1200);
                this.state = 7;
                this.score = 0;
                this.wait_time = -1L;
                break;
            }
            case 5: {
                this.player.position.tick();
                this.player.nextFrame(this.game_time);
                this.processGems();
                if (this.player.position.moving) break;
                if (this.wait_time > 0L && this.game_time > this.wait_time) {
                    this.player.setAnim(2);
                    this.player.frame = 1;
                    this.player.loop = 0;
                    this.state = 6;
                    this.wait_time = -1L;
                    this.player.position.moveTo(120, 174, 0, 400);
                    break;
                }
                if (this.wait_time >= 0L) break;
                this.wait_time = this.game_time + 1000L;
                break;
            }
            case 6: {
                this.player.position.tick();
                this.processGems();
                if (this.player.position.moving) break;
                if (this.wait_time > 0L && this.game_time > this.wait_time) {
                    this.player.position.moveTo(120, 348, 0, 400);
                    this.state = 7;
                    break;
                }
                if (this.wait_time >= 0L) break;
                this.wait_time = this.game_time + 2000L;
                break;
            }
            case 7: {
                this.player.position.tick();
                this.processGems();
                if (!this.player.collide(0, this.itofx(348 + (this.player.frameHeight >> 1)), this.itofx(240), 1, -1, 0)) break;
                this.state = 9;
                this.game.setResultScreen(4, this.score);
                break;
            }
            case 9: {
                if ((n2 & 0x20) == 0 && (n2 & 0x1000) == 0) break;
                this.game.state = this.game.isMini ? 4 : 2;
            }
        }
        if (this.state != 9) {
            n4 = Math.max(348 - (this.fxtoi(this.player.position.y) + (this.player.frameHeight >> 1)), 0);
            if (n4 > 0 || this.state < 7) {
                for (n3 = this.clouds.size() - 1; n3 >= 0; --n3) {
                    n5 = this.velocity / 6;
                    Position position = (Position)this.clouds.elementAt(n3);
                    position.speed = n5 + (4 - position.param1) * n5;
                    position.tick();
                    if (position.moving || this.state > 6) continue;
                    int n6 = (this.rand.nextInt() >>> 1) % 5;
                    int n7 = 240 * n6 / 5;
                    position.x = this.itofx(n7);
                    position.y = this.itofx(348 + this.imgCloud[position.param1].getHeight());
                    position.moveTo(n7, -this.imgCloud[position.param1].getHeight(), 0, n5 + (4 - position.param1) * n5);
                }
            }
            this.player.nextFrame(this.game_time);
        }
    }

    public void processGems() {
        for (int i = this.objects.size() - 1; i >= 0; --i) {
            PackedSprite packedSprite = (PackedSprite)this.objects.elementAt(i);
            packedSprite.nextFrame(this.game_time);
            packedSprite.position.speed = this.velocity;
            packedSprite.position.tick();
            boolean bl = false;
            if (packedSprite.type <= 2) {
                bl = this.player.collide(packedSprite.position.x + this.itofx(this.player.frameWidth >> 1), packedSprite.position.y + this.itofx(this.player.frameHeight >> 1), 1, 1, -1, 0);
            }
            if (packedSprite.type <= 2 && !packedSprite.position.moving) {
                this.combo = 0;
            }
            if (bl) {
                ++this.combo;
                this.score += 200 * (packedSprite.type + 1);
                packedSprite.position.moving = false;
                PackedSprite packedSprite2 = new PackedSprite(this.imgPop, 197);
                packedSprite2.type = 3;
                packedSprite2.position = new Position(packedSprite.position.x, packedSprite.position.y);
                packedSprite2.position.moveTo(this.fxtoi(packedSprite2.position.x), -packedSprite.frameHeight, 0, this.velocity);
                packedSprite2.speed = 200;
                packedSprite2.timer = this.game_time + (long)packedSprite2.speed;
                packedSprite2.loop = 1;
                packedSprite2.num_loops = 1;
                this.objects.addElement(packedSprite2);
            }
            if ((packedSprite.type > 2 || packedSprite.position.moving) && (packedSprite.type != 3 || packedSprite.loop != 0)) continue;
            this.objects.removeElementAt(i);
        }
    }

    public void render(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.imgForeground.getHeight();
        graphics.setColor(1151738);
        graphics.fillRect(0, 0, 240, 348);
        Game.GradientHorizontal(graphics, 0, 87, 240, 261, 1151738, 0xFFFFFF);
        for (n4 = 0; n4 < this.clouds.size(); ++n4) {
            Position position = (Position)this.clouds.elementAt(n4);
            graphics.drawImage(this.imgCloud[position.param1], this.fxtoi(position.x), this.fxtoi(position.y), 6);
        }
        if (this.state >= 7) {
            n4 = 348 - n5;
            int n6 = Math.max(348 - (this.fxtoi(this.player.position.y) + (this.player.frameHeight >> 1)), 0);
            n3 = (n4 += n6) - 174 + (174 - n5);
            Game.GradientHorizontal(graphics, 0, n3, 240, 348 - n3, 10382121, 15114827);
            graphics.drawImage(this.imgBackground, this.fxtoi(this.background.x), n4, 36);
            for (n2 = this.fxtoi(this.foreground.x); n2 < 240; n2 += this.imgForeground.getWidth() * 3) {
                graphics.drawImage(this.imgForeground, n2, n4, 6);
            }
        }
        for (n4 = 0; n4 < this.objects.size(); ++n4) {
            PackedSprite packedSprite = (PackedSprite)this.objects.elementAt(n4);
            packedSprite.render(graphics, this.fxtoi(packedSprite.position.x), this.fxtoi(packedSprite.position.y), packedSprite.frame, 0, 3);
        }
        this.player.render(graphics, this.fxtoi(this.player.position.x), this.fxtoi(this.player.position.y), this.player.frame, this.player.animation, 3);
        graphics.drawImage(this.imgHud, 0, 0, 20);
        n4 = 174;
        int n7 = n4 - this.imgHud.getHeight();
        n3 = n7 * this.height / this.start_height;
        graphics.setColor(65280);
        graphics.fillRect(0, this.imgHud.getHeight() + (this.imgHudBar.getHeight() >> 1) + n7 * 95 / 100, this.imgHudTile.getWidth(), n7 * 5 / 100);
        graphics.setColor(0);
        n2 = this.imgHud.getHeight() + (this.imgHudBar.getHeight() >> 1) + n7 * 95 / 100 + (n7 * 5 / 100 >> 1);
        graphics.drawRect(-1, this.imgHud.getHeight() + (this.imgHudBar.getHeight() >> 1) + n7 * 95 / 100, this.imgHudTile.getWidth(), n7 * 5 / 100);
        graphics.drawLine(0, n2, this.imgHudTile.getWidth() - 1, n2);
        graphics.setClip(0, this.imgHud.getHeight(), this.imgHudTile.getWidth(), n7);
        for (int i = 0; i <= n7; i += this.imgHudTile.getHeight()) {
            graphics.drawImage(this.imgHudTile, 0, this.imgHud.getHeight() + i, 20);
        }
        graphics.setClip(0, 0, 240, 348);
        graphics.drawImage(this.imgHudBottom, 0, this.imgHud.getHeight() + n7, 20);
        graphics.drawImage(this.imgHudBar, 0, this.imgHud.getHeight() + n7 - n3, 6);
        this.font.print(graphics, this.game.formatScore(this.score), 240, 2, 24);
        if (this.state == 4 && this.height <= this.start_height * 5 / 100 && this.height >= this.start_height * 5 / 100 - this.start_height * 5 / 100) {
            for (n = this.sprButton.framesHigh - 1; n >= 0; --n) {
                this.sprButton.renderPointer(graphics, 120, 348 - this.game.sprSoftkeys.frameHeight, this.sprButton.frame, n, 3, -5);
            }
        }
        if (this.state == 0) {
            this.drawIntroScreen(graphics);
        } else if (this.state <= 3) {
            this.game.drawStoplight(graphics, this.state);
        } else if (this.state == 9) {
            this.game.renderResultScreen(graphics, 4, this.score);
        }
        if (this.state != 0 && this.state != 9 && (this.state != 4 || this.height > this.start_height * 5 / 100 || this.height < this.start_height * 5 / 100 - this.start_height * 5 / 100)) {
            n = 240 - this.imgDPad.getWidth() >> 1;
            int n8 = 348 - this.imgDPad.getHeight() - 4;
            graphics.drawImage(this.imgDPad, n, n8, 20);
            Game.addPointer(n, n8, 24, 24, -3);
            Game.addPointer(n + 24, n8, 24, 24, -5);
            Game.addPointer(n + 48, n8, 24, 24, -4);
        }
    }

    void drawIntroScreen(Graphics graphics) {
        char[] cArray = this.game.fontTiny.wrap(this.game.strings[98], 222);
        int n = this.imgIntro.getWidth() + 10 + 8;
        int n2 = this.imgIntro.getHeight() + this.game.defaultFont.height + 10 + 8;
        int n3 = 120 - (n >> 1);
        int n4 = 174 - (n2 >> 1);
        Menu.drawMenuBox(graphics, n3, n4, n, n2);
        Game.addPointer(0, 0, 240, 348, -5);
        graphics.drawImage(this.imgIntro, n3 + (n >> 1), n4 + this.game.defaultFont.height + 5 + 4, 17);
        this.game.defaultFont.print(graphics, this.game.strings[35], n3 + (n >> 1), n4 + 2 + 5, 17);
    }
}

