/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class PackedSprite
implements Constants {
    public static final int LOOP_NONE = 0;
    public static final int LOOP_ONCE = 1;
    public static final int LOOP_WRAP = 2;
    public static final int LOOP_PINGPONG = 3;
    public static final int LOOP_TIMES_DISAPPEAR = 4;
    public static final int PACK_X = 0;
    public static final int PACK_Y = 1;
    public static final int PACK_WIDTH = 2;
    public static final int PACK_HEIGHT = 3;
    public static final int PACK_TOP = 4;
    public static final int PACK_LEFT = 5;
    public static final int NUM_PACK_ITEMS = 6;
    Image image;
    int frame;
    int animation;
    int defaultFrame;
    int startFrame;
    int endFrame;
    int frameWidth;
    int frameHeight;
    int framesWide;
    int framesHigh;
    int num_loops;
    int loop;
    int direction;
    int speed;
    long timer;
    short[][] packedData;
    byte[] rotation;
    boolean disappear;
    boolean finishedLoop;
    int timesThrough;
    int numTimes;
    Position position;
    int type;
    int state;
    long delay;

    PackedSprite() {
    }

    PackedSprite(int n, int n2) {
        this.image = Game.createImage(n);
        this.init(n2);
    }

    PackedSprite(int n, int n2, int[] nArray) {
        this.image = Game.createImage(n, nArray);
        this.init(n2);
    }

    PackedSprite(Image image, int n) {
        this.image = image;
        this.init(n);
    }

    public PackedSprite copy() {
        PackedSprite packedSprite = new PackedSprite();
        packedSprite.image = this.image;
        packedSprite.frameWidth = this.frameWidth;
        packedSprite.frameHeight = this.frameHeight;
        packedSprite.framesWide = this.framesWide;
        packedSprite.framesHigh = this.framesHigh;
        packedSprite.packedData = this.packedData;
        packedSprite.rotation = this.rotation;
        packedSprite.startFrame = 0;
        packedSprite.defaultFrame = packedSprite.endFrame = packedSprite.framesWide - 1;
        packedSprite.disappear = false;
        packedSprite.timesThrough = 0;
        packedSprite.numTimes = 0;
        packedSprite.finishedLoop = false;
        packedSprite.loop = 2;
        packedSprite.direction = 1;
        return packedSprite;
    }

    void init(int n) {
        try {
            int n2;
            InputStream inputStream = this.getClass().getResourceAsStream("/" + n + ".bin");
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.frameWidth = dataInputStream.readUnsignedByte();
            this.frameHeight = dataInputStream.readUnsignedByte();
            this.framesWide = dataInputStream.readUnsignedByte();
            this.framesHigh = dataInputStream.readUnsignedByte();
            this.packedData = new short[6][];
            for (n2 = 0; n2 < this.packedData.length; ++n2) {
                this.packedData[n2] = new short[this.framesHigh * this.framesWide];
            }
            this.rotation = new byte[this.framesHigh * this.framesWide];
            for (n2 = 0; n2 < this.framesHigh; ++n2) {
                for (int i = 0; i < this.framesWide; ++i) {
                    int n3 = n2 * this.framesWide + i;
                    this.packedData[0][n3] = (short)dataInputStream.readUnsignedShort();
                    this.packedData[1][n3] = (short)dataInputStream.readUnsignedShort();
                    this.packedData[2][n3] = (short)dataInputStream.readUnsignedShort();
                    this.packedData[3][n3] = (short)dataInputStream.readUnsignedShort();
                    this.packedData[4][n3] = (short)dataInputStream.readUnsignedShort();
                    this.packedData[5][n3] = (short)dataInputStream.readUnsignedShort();
                    this.rotation[n2 * this.framesWide + i] = (byte)dataInputStream.readUnsignedByte();
                }
            }
            this.startFrame = 0;
            this.defaultFrame = this.endFrame = this.framesWide - 1;
            this.disappear = false;
            this.timesThrough = 0;
            this.numTimes = 0;
            this.finishedLoop = false;
            this.loop = 2;
            this.direction = 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void render(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.renderPointer(graphics, n, n2, n3, n4, n5, -999);
    }

    void renderPointer(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        this.renderPointer(graphics, n, n2, n3, n4, n5, n6, 1, -1);
    }

    void renderPointer(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.renderPointer(graphics, n, n2, n3, n4, n5, -999, n6, n7);
    }

    void renderPointer(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.disappear) {
            return;
        }
        short s = 0;
        short s2 = 0;
        int n9 = n;
        int n10 = n2;
        int n11 = n4 * this.framesWide + n3;
        short s3 = this.packedData[2][n11];
        short s4 = this.packedData[3][n11];
        s = this.packedData[5][n11];
        s2 = this.packedData[4][n11];
        n9 += s;
        n10 += s2;
        if ((n5 & 1) != 0) {
            n9 -= this.frameWidth >> 1;
        } else if ((n5 & 8) != 0) {
            n9 -= this.frameWidth;
        }
        if ((n5 & 2) != 0) {
            n10 -= this.frameHeight >> 1;
        } else if ((n5 & 0x20) != 0) {
            n10 -= this.frameHeight;
        }
        short s5 = this.packedData[0][n11];
        short s6 = this.packedData[1][n11];
        graphics.drawRegion(this.image, (int)s5, (int)s6, (int)s3, (int)s4, (int)this.rotation[n11], n9, n10, 20);
        if (n7 == 1) {
            if (n6 != -999) {
                Game.addPointer(n9, n10, s3, s4, n6);
            }
        } else {
            Game.addPointer(n9, n10, s3, s4, -5, n7, n8);
        }
    }

    void nextFrame(long l) {
        if (this.speed > 0) {
            if (l - this.timer > (long)this.speed) {
                this.timer = l;
            } else {
                return;
            }
        }
        this.nextFrame();
    }

    void nextFrame() {
        if (this.loop != 0) {
            this.frame += this.direction;
        }
        if (this.frame < this.startFrame || this.frame > this.endFrame) {
            switch (this.loop) {
                case 2: {
                    this.frame = this.startFrame;
                    break;
                }
                case 3: {
                    this.direction = -this.direction;
                    this.frame += this.direction << 1;
                    break;
                }
                case 4: {
                    if (this.disappear) break;
                    ++this.timesThrough;
                    this.frame = this.startFrame;
                    if (this.timesThrough < this.numTimes) break;
                    this.disappear = true;
                    break;
                }
                case 1: {
                    this.frame = this.defaultFrame;
                    this.finishedLoop = true;
                }
            }
            if (this.num_loops > 0) {
                --this.num_loops;
                if (this.num_loops <= 0) {
                    this.loop = 0;
                    this.frame = this.defaultFrame;
                }
            }
        }
    }

    void setFraming(int n, int n2) {
        this.startFrame = n;
        this.endFrame = n2;
        if (this.frame < n) {
            this.frame = n;
        } else if (this.frame > n2) {
            this.frame = n2;
        }
    }
}

