/*
 * Decompiled with CFR 0.152.
 */
class Position {
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    public static final int SOUTHWEST = 4;
    public static final int SOUTHEAST = 5;
    public static final int NORTHEAST = 6;
    public static final int NORTHWEST = 7;
    public static final int TYPE_NONE = -1;
    public static final int TYPE_CONSTANT = 0;
    public static final int TYPE_TIMED = 1;
    public static final int TYPE_TICK = 2;
    public static final int TYPE_ACCELERATE = 3;
    public static final int TYPE_DECELERATE = 4;
    int x;
    int y;
    int z;
    int dx;
    int dy;
    int dz;
    int origX;
    int origY;
    long length;
    long time;
    boolean moving;
    int positionType;
    int type;
    int originalSpeed;
    int speed;
    int facing;
    int param1;
    int param2;

    Position() {
    }

    Position(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.positionType = -1;
    }

    void moveToTimed(int n, int n2, long l) {
        this.positionType = 1;
        this.origX = this.x;
        this.origY = this.y;
        this.dx = n << 8;
        this.dy = n2 << 8;
        this.length = l;
        this.time = System.currentTimeMillis() + l;
        if (l <= 0L) {
            this.x = this.dx;
            this.y = this.dy;
        }
        this.moving = true;
        this.setDirection();
    }

    void moveTo(int n, int n2, int n3, int n4) {
        this.positionType = n3;
        this.dx = n << 8;
        this.dy = n2 << 8;
        this.originalSpeed = n4;
        this.speed = n4;
        if (n4 == 0) {
            this.x = this.dx;
            this.y = this.dy;
        }
        this.moving = true;
        this.setDirection();
    }

    void setDirection() {
        int n = this.x - this.dx;
        int n2 = this.y - this.dy;
        if (n < 0) {
            this.facing = n2 < 0 ? 5 : (n2 > 0 ? 6 : 1);
        } else if (n > 0) {
            this.facing = n2 < 0 ? 4 : (n2 > 0 ? 7 : 3);
        } else if (n2 < 0) {
            this.facing = 2;
        } else if (n2 > 0) {
            this.facing = 0;
        }
    }

    void tick() {
        switch (this.positionType) {
            case 0: {
                this.moving = false;
                if (this.x == this.dx && this.y == this.dy) break;
                this.moving = true;
                int n = Math.abs(this.dx - this.x);
                int n2 = Math.abs(this.dy - this.y);
                int n3 = (n << 8) / (n + n2) * this.speed >> 8;
                int n4 = (n2 << 8) / (n + n2) * this.speed >> 8;
                this.x = this.dx - this.x > 0 ? Math.min(this.x + n3, this.dx) : Math.max(this.x - n3, this.dx);
                this.y = this.dy - this.y > 0 ? Math.min(this.y + n4, this.dy) : Math.max(this.y - n4, this.dy);
                if (this.x != this.dx || this.y != this.dy) break;
                this.moving = false;
                break;
            }
            case 4: {
                if (!this.moving) break;
                this.moving = false;
                if (this.x == this.dx && this.y == this.dy) break;
                this.moving = true;
                int n = Math.abs(this.dx - this.x);
                int n5 = Math.abs(this.dy - this.y);
                this.x = this.dx - this.x > 0 ? Math.min(this.x + Math.max(n / this.speed, 15), this.dx) : Math.max(this.x - Math.max(n / this.speed, 15), this.dx);
                this.y = this.dy - this.y > 0 ? Math.min(this.y + Math.max(n5 / this.speed, 15), this.dy) : Math.max(this.y - Math.max(n5 / this.speed, 15), this.dy);
                if (this.x != this.dx || this.y != this.dy) break;
                this.moving = false;
                break;
            }
            case 3: {
                if (!this.moving) break;
                this.moving = false;
                if (this.x == this.dx && this.y == this.dy) break;
                this.moving = true;
                int n = Math.abs(this.dx - this.x);
                int n6 = Math.abs(this.dy - this.y);
                this.x = this.dx - this.x > 0 ? Math.min(this.x + Math.max(this.speed, 15), this.dx) : Math.max(this.x - Math.max(this.speed, 15), this.dx);
                this.y = this.dy - this.y > 0 ? Math.min(this.y + Math.max(this.speed, 15), this.dy) : Math.max(this.y - Math.max(this.speed, 15), this.dy);
                this.speed += this.speed;
                if (this.x != this.dx || this.y != this.dy) break;
                this.moving = false;
                break;
            }
            case 2: {
                this.moving = false;
                if (this.speed <= 0) break;
                this.moving = true;
                if (--this.speed > 0) {
                    if (this.speed == 0) break;
                    this.x += (this.dx - this.x) / this.speed;
                    this.y += (this.dy - this.y) / this.speed;
                    break;
                }
                this.x = this.dx;
                this.y = this.dy;
            }
        }
    }

    void tick(long l) {
        if (this.positionType == 1) {
            long l2 = this.time - l;
            if (l2 >= 0L) {
                this.moving = true;
                long l3 = 256L - (l2 << 8 << 8) / (this.length << 8);
                this.x = this.origX + ((this.dx - this.origX) * (int)l3 >> 8);
                this.y = this.origY + ((this.dy - this.origY) * (int)l3 >> 8);
            } else {
                this.moving = false;
                this.x = this.dx;
                this.y = this.dy;
            }
        }
    }

    int getDistance(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = Math.abs(n - this.x);
        if (n6 < (n5 = Math.abs(n2 - this.y))) {
            n4 = n6;
            n3 = n5;
        } else {
            n4 = n5;
            n3 = n6;
        }
        int n7 = (n3 << 8) + (n3 << 3) - (n3 << 4) - (n3 << 1) + (n4 << 7) - (n4 << 5) + (n4 << 3) - (n4 << 1);
        return n7;
    }
}

