/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class GraphicFont
implements Constants {
    static final char LINEBREAK = '\u00b6';
    PackedSprite sprFont;
    int spaceWidth;
    int height;
    String charset;
    int tracking;
    int leading;
    int baseline;
    int wrapWidth;
    String cachedWrappedString;
    char[] cachedWrappedCharArray;
    int cachedWrapWidth;
    boolean scroll;
    boolean back;
    int scroll_ofs;
    int scroll_amt;
    long scrollDelay;
    String cachedScrollString;
    int cachedScrollWidth;

    GraphicFont(int n, int n2, String string, int n3) {
        this.sprFont = new PackedSprite(n, n2);
        this.init(string, n3);
    }

    GraphicFont(PackedSprite packedSprite, String string, int n) {
        this.sprFont = packedSprite.copy();
        this.init(string, n);
    }

    GraphicFont(int n, int n2, String string, int n3, int[] nArray) {
        this.sprFont = new PackedSprite(n, n2, nArray);
        this.init(string, n3);
    }

    void init(String string, int n) {
        for (int i = 0; i < this.sprFont.framesWide; ++i) {
            this.height = Math.max(this.height, this.sprFont.packedData[4][i] + this.sprFont.packedData[3][i]);
            this.spaceWidth = Math.max(this.spaceWidth, this.sprFont.packedData[5][i] + this.sprFont.packedData[2][i]);
        }
        this.charset = string;
        this.tracking = n;
        this.leading = this.height + 1;
        this.spaceWidth >>= 1;
    }

    void print(Graphics graphics, String string, int n, int n2, int n3) {
        this.printPointer(graphics, string.toCharArray(), n, n2, n3, -1, -1);
    }

    void printPointer(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        this.printPointer(graphics, string.toCharArray(), n, n2, n3, n4, n5);
    }

    void print(Graphics graphics, char[] cArray, int n, int n2, int n3) {
        this.printPointer(graphics, cArray, n, n2, n3, -1, -1);
    }

    void printPointer(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = cArray.length;
        int n8 = n;
        int n9 = n2;
        int n10 = 0;
        int n11 = graphics.getClipX();
        int n12 = graphics.getClipY();
        int n13 = graphics.getClipWidth();
        int n14 = graphics.getClipHeight();
        int n15 = n11 + n13;
        int n16 = n12 + n14;
        int n17 = 240;
        int n18 = 0;
        int n19 = 348;
        int n20 = 0;
        if ((n3 & 2) != 0) {
            n9 -= this.getStringHeight(cArray) >> 1;
        } else if ((n3 & 0x20) != 0) {
            n9 -= this.getStringHeight(cArray);
        } else if ((n3 & 0x40) != 0) {
            n9 -= this.getStringHeight(cArray);
            n9 += this.height - this.baseline;
        }
        for (n6 = 0; n9 + this.height < n12 && n6 < n7; ++n6) {
            if (cArray[n6] != '\u00b6') continue;
            n9 += this.leading;
        }
        if ((n3 & 1) != 0) {
            n8 -= this.getLineWidth(cArray, n6) >> 1;
        } else if ((n3 & 8) != 0) {
            n8 -= this.getLineWidth(cArray, n6);
        }
        for (int i = n6; i < n7; ++i) {
            char c = cArray[i];
            if (c != '\u00b6') {
                if (c != ' ') {
                    if (n8 < n15) {
                        int n21 = this.getCharacterIndex(c);
                        if (n21 >= 0 && n8 > -(n10 = this.sprFont.packedData[2][n21]) && n8 + n10 > n11) {
                            short s = this.sprFont.packedData[4][n21];
                            graphics.setClip(n11, n12, n13, n14);
                            graphics.drawRegion(this.sprFont.image, (int)this.sprFont.packedData[0][n21], (int)this.sprFont.packedData[1][n21], n10, (int)this.sprFont.packedData[3][n21], (int)this.sprFont.rotation[n21], n8, n9 + s, 20);
                            if (n5 != -1) {
                                if (n17 > n8) {
                                    n17 = n8;
                                }
                                if (n19 > n9 + s) {
                                    n19 = n9 + s;
                                }
                                if (n18 < n8 + n10) {
                                    n18 = n8 + n10;
                                }
                                if (n20 < n9 + s + this.sprFont.packedData[3][n21]) {
                                    n20 = n9 + s + this.sprFont.packedData[3][n21];
                                }
                            }
                        }
                    } else {
                        while (i + 1 < n7 && cArray[i + 1] != '\u00b6') {
                            ++i;
                        }
                    }
                } else {
                    n10 = this.spaceWidth;
                }
                n8 += n10 + this.tracking;
                continue;
            }
            n8 = n;
            if ((n9 += this.leading) > n16) break;
            if ((n3 & 1) != 0) {
                n8 -= this.getLineWidth(cArray, i + 1) >> 1;
                continue;
            }
            if ((n3 & 8) == 0) continue;
            n8 -= this.getLineWidth(cArray, i + 1);
        }
        if (n5 != -1 && n17 < n18 && n19 < n20) {
            Game.addPointer(n17, n19, n18 - n17, n20 - n19, -5, n4, n5);
        }
        graphics.setClip(n11, n12, n13, n14);
    }

    void printScrollText(Graphics graphics, String string, int n, int n2, int n3) {
        if (this.scroll) {
            int n4 = 0;
            int n5 = -this.scroll_amt;
            if ((n3 & 1) != 0) {
                int n6 = (this.scroll_amt & 1) != 0 ? 1 : 0;
                n4 = (this.scroll_amt >> 1) + n6;
                n5 = -((this.scroll_amt >> 1) + n6);
            }
            if ((n3 & 8) != 0) {
                n4 = this.scroll_amt;
                n5 = 0;
            }
            if (!this.back) {
                if (this.scroll_ofs < n4) {
                    ++this.scroll_ofs;
                } else {
                    this.hangOut();
                }
            } else if (this.scroll_ofs > n5) {
                --this.scroll_ofs;
            } else {
                this.hangOut();
            }
        }
        this.print(graphics, string, n + this.scroll_ofs, n2, n3);
    }

    void hangOut() {
        if (this.scrollDelay == -1L) {
            this.scrollDelay = System.currentTimeMillis() + 600L;
        } else if (this.scrollDelay < System.currentTimeMillis()) {
            this.back = !this.back;
            this.scrollDelay = -1L;
        }
    }

    char[] wrap(String string, int n) {
        if (string.equals(this.cachedWrappedString) && this.cachedWrapWidth == n) {
            return this.cachedWrappedCharArray;
        }
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < n2; ++i) {
            int n5;
            if (cArray[i] == ' ') {
                n3 = i + 1;
                int n6 = 0;
                if (n3 < n2) {
                    while (cArray[n3] != ' ' && cArray[n3] != '\u00b6' && n4 + n6 <= n) {
                        n5 = this.getCharacterIndex(cArray[n3]);
                        n6 += this.sprFont.packedData[2][n5 < 0 ? 0 : n5] + this.tracking;
                        if (++n3 < n2) continue;
                    }
                }
                if (n4 + n6 + this.spaceWidth + this.tracking > n) {
                    cArray[i] = 182;
                } else {
                    n4 += this.spaceWidth + this.tracking;
                }
            }
            if (cArray[i] != '\u00b6' && cArray[i] != ' ') {
                n5 = this.getCharacterIndex(cArray[i]);
                n4 += this.sprFont.packedData[2][n5 < 0 ? 0 : n5] + this.tracking;
                continue;
            }
            if (cArray[i] != '\u00b6') continue;
            n4 = 0;
        }
        this.cachedWrappedString = string;
        this.cachedWrappedCharArray = cArray;
        this.cachedWrapWidth = n;
        return cArray;
    }

    char[] split(String string, int n) {
        String string2 = string + " ";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        while (string2.length() > 0) {
            int n2 = string2.indexOf(32);
            int n3 = string2.indexOf(182);
            if (n2 < 0 && n3 < 0) {
                string4 = string2;
            } else {
                if (n2 < 0) {
                    n2 = string2.length();
                }
                if (n3 < 0) {
                    n3 = string2.length();
                }
                if (n3 < n2) {
                    n2 = n3;
                }
                string4 = string2.substring(0, n2);
            }
            string3 = string4 + " ";
            while (this.getLineWidth(string4) > n) {
                int n4 = 0;
                string3 = "";
                while (this.getLineWidth(string3 + string4.charAt(n4)) <= n) {
                    string3 = string3 + string4.charAt(n4++);
                }
                string4 = string4.substring(string3.length());
            }
            string2 = string2.substring(string3.length());
            string5 = string5 + string3 + " ";
        }
        return string5.trim().toCharArray();
    }

    int getStringWidth(char[] cArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n < cArray.length) {
            int n4;
            char c;
            if ((c = cArray[n++]) == ' ') {
                n4 = this.spaceWidth;
            } else if (c != '\u00b6') {
                int n5 = this.getCharacterIndex(c);
                n4 = this.sprFont.packedData[2][n5 < 0 ? 0 : n5];
            } else {
                n3 = Math.max(n3, n2);
                n2 = 0;
                continue;
            }
            if (n >= cArray.length) {
                n2 += n4;
                continue;
            }
            n2 += n4 + this.tracking;
        }
        n3 = Math.max(n3, n2);
        return n3;
    }

    int getLineWidth(char[] cArray, int n) {
        int n2 = 0;
        while (n < cArray.length) {
            int n3;
            char c;
            if ((c = cArray[n++]) == ' ') {
                n3 = this.spaceWidth;
            } else {
                if (c == '\u00b6') break;
                int n4 = this.getCharacterIndex(c);
                n3 = this.sprFont.packedData[2][n4 < 0 ? 0 : n4];
            }
            n2 += n3 + this.tracking;
        }
        return n2;
    }

    int getLineWidth(String string) {
        return this.getLineWidth(string.toCharArray(), 0);
    }

    int getStringHeight(char[] cArray) {
        int n = cArray.length;
        int n2 = this.leading;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != '\u00b6') continue;
            n2 += this.leading;
        }
        return n2;
    }

    int getCharacterIndex(char c) {
        int n = this.charset.indexOf(c);
        if (n >= 0) {
            return n;
        }
        if (Character.isLowerCase(c)) {
            return this.charset.indexOf(Character.toUpperCase(c));
        }
        if (Character.isUpperCase(c)) {
            return this.charset.indexOf(Character.toLowerCase(c));
        }
        return n;
    }

    void setScrollText(String string, int n) {
        if (string.equals(this.cachedScrollString) && n == this.cachedScrollWidth) {
            return;
        }
        this.scrollDelay = -1L;
        this.scroll = false;
        this.scroll_amt = 0;
        this.back = true;
        this.scroll_ofs = 0;
        int n2 = this.getLineWidth(string);
        if (n2 > n) {
            this.scroll = true;
            this.scroll_amt = n2 - n;
        }
        this.cachedScrollWidth = n;
        this.cachedScrollString = string;
    }
}

