/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Block;
import sk.inlogic.Common;
import sk.inlogic.Game;
import sk.inlogic.Jewel;
import sk.inlogic.Level;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.graphics.GFont;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.screen.ScreenSelectBonusLevel;
import sk.inlogic.screen.ScreenSelectLevel;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    private MainCanvas mainCanvas;
    private boolean _bNeedRepaint;
    private int _iStatus = -1;
    private int _iGameMode;
    private int gameScore;
    private static final int STATUS_GAME = 0;
    private static final int STATUS_INGAMEMENU = 1;
    private static final int STATUS_RESULTDIALOG = 2;
    private static final int STATUS_INSTRUCTIONS = 3;
    private static final int STATUS_TUTORIAL = 4;
    private static final int STATUS_STARTSCREEN = 5;
    private static final int STATUS_RESTARTSCREEN = 6;
    private static final int STATUS_LAST_MESSAGE = 7;
    private static final int STATUS_REALY_QUIT = 8;
    private static final int STATUS_MAIN_MENU = 9;
    private static final int STATUS_MAIN_LEVEL_SELECT = 9;
    private static final int COMP_ID_HINT = 0;
    private static final int COMP_ID_MENU = 4;
    private static final int COMP_ID_RESTART = 5;
    private static final int COMP_ID_SOUNDS = 3;
    private static final int COMP_ID_MAINMENU = 6;
    private static final int COMP_ID_INSTRUCTIONS = 1;
    private static final int COMP_ID_ARR_UP = 7;
    private static final int COMP_ID_ARR_DOWN = 8;
    private static final int CENTER_BUTTON = 9;
    private static final int TOTAL_COMP_IDS = 10;
    private Rectangle[] _rectItems = new Rectangle[10];
    private Rectangle _rectGameArea;
    private Rectangle _rectDialog;
    private Rectangle _rectLogo;
    private Rectangle _rectText;
    private Rectangle _rectTop;
    private Rectangle rectDialogInstr;
    private Rectangle rectSmallDialogInstr;
    private Rectangle rectFK;
    private int _iOffsetY;
    private int _iOffsetXDefault = 5;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private boolean _bChangeSequence = false;
    private Image imgBG;
    private Image imgMiddleButton;
    private Image imgSmallButton;
    private Image imgArrowUp;
    private Image imgArrowDown;
    private Image imgBigButton;
    private Image imgTopBar;
    private Image imgStarActive;
    private Image imgStarInactive;
    private Image imgMiddleSelector;
    private Image _imgGameLogo;
    private Sprite _sprMenuIcons;
    private Sprite sprGameMode;
    private Sprite sprStarsActive;
    private Sprite sprStarsInactive;
    private Sprite _sprTopbarStats;
    private Sprite sprSmallIcons;
    private Sprite sprMediumIcons1;
    private Sprite sprBigIcons;
    private Sprite sprMediumIcons2;
    private Sprite sprWindow;
    private Sprite sprResult;
    private PreparedText _ptInstructions;
    private PreparedText _ptGameTutorial;
    private PreparedText _ptGameTxts;
    private PreparedText _ptGameTxts2;
    private PreparedText _ptGameScore;
    private PreparedText _ptMoves;
    private int[][] _animationSequence = new int[9][13];
    private AnimationComponent[] _animationComponents = new AnimationComponent[13];
    private int _iSelectedCompId;
    private int icount;
    private int _iTextOffsetY;
    private boolean _bScrollUP = false;
    private boolean _bScrollDOWN = true;
    int level = 0;
    private int actualLevel;
    private boolean _bBonusPack = false;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iFinalHeight;
    private GFont fontRed;
    private GFont fontMain;
    public int interuption = 0;
    public int _iCycle;
    public int _iMusicControler;
    Sprite _sprSelectorBig;
    int _iBw;
    private int score = 0;
    private String stars = "";
    int lvl = 0;
    int checkButton = 5;
    int checkButton2 = 5;
    boolean bDragInstructions = false;

    public ScreenGame(MainCanvas mC, int gameMode, int level, boolean bonus) {
        this.mainCanvas = mC;
        this._iGameMode = gameMode;
        this.actualLevel = level;
        this._bBonusPack = bonus;
        if (this._bBonusPack) {
            Level.getBonusLevel(this.actualLevel);
        } else {
            Level.getLevel(this.actualLevel);
        }
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.calculatePositions();
        this.preapreTxt();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.loadLevel();
        this.loadData();
        if (Level._bIsTutorial) {
            this.startAnimation(true, 4);
        } else {
            this.startAnimation(true, 5);
        }
    }

    public void afterHide() {
        RMSObjects.freeRMSConnect(this.getRMSConnectIdByGameType(this._iGameMode));
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 4, 5, 15, 9, 12, 13, 16, 17, 18, 19, 22});
        Resources.loadSprites(new int[]{22, 41, 13, 14, 15, 16, 17, 18, 30, 19, 24, 26, 27, 31, 32, 34, 39, 35, 36, 37, 40, 43, 42, 44, 47, 49, 48});
        Resources.loadGFonts(new int[]{0, 1});
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2, 4, 5, 15, 9, 12, 13, 16, 17, 18, 19, 22});
        Resources.freeSprites(new int[]{22, 13, 14, 15, 16, 17, 18, 30, 19, 24, 26, 27, 34, 39, 35, 36, 37, 40, 41, 43, 42, 44, 47, 49, 48});
        Resources.freeGFonts(new int[]{0, 1});
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
    }

    private void initImages() {
        this.imgBG = Resources.resImgs[2];
        this.imgMiddleButton = Resources.resImgs[15];
        this.imgSmallButton = Resources.resImgs[9];
        this.imgArrowDown = Resources.resImgs[13];
        this.imgArrowUp = Resources.resImgs[12];
        this.imgBigButton = Resources.resImgs[16];
        this.imgTopBar = Resources.resImgs[17];
        this.imgStarActive = Resources.resImgs[18];
        this.imgStarInactive = Resources.resImgs[19];
        this._imgGameLogo = Resources.resImgs[4];
        this.imgMiddleSelector = Resources.resImgs[22];
    }

    private void initSprites() {
        this._sprSelectorBig = Resources.resSprs[26];
        this._sprMenuIcons = Resources.resSprs[41];
        this._sprTopbarStats = Resources.resSprs[39];
        this.sprGameMode = Resources.resSprs[37];
        this.sprStarsActive = Resources.resSprs[48];
        this.sprStarsInactive = Resources.resSprs[49];
        this.sprSmallIcons = Resources.resSprs[40];
        this.sprMediumIcons1 = Resources.resSprs[41];
        this.sprMediumIcons2 = Resources.resSprs[42];
        this.sprBigIcons = Resources.resSprs[43];
        this.sprWindow = Resources.resSprs[44];
        this.sprResult = Resources.resSprs[47];
    }

    private void initFonts() {
        this.fontRed = Resources.resGFonts[1];
        this.fontMain = Resources.resGFonts[0];
        this._ptInstructions = new PreparedText(this.fontMain);
        this._ptGameScore = new PreparedText(this.fontMain);
        this._ptMoves = new PreparedText(this.fontRed);
        this._ptGameTutorial = new PreparedText(this.fontMain);
        this._ptGameTxts = new PreparedText(this.fontMain);
        this._ptGameTxts2 = new PreparedText(this.fontMain);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 5;
        this._animationSequence[0][1] = 10;
        this._animationSequence[0][2] = 11;
        this._animationSequence[0][3] = 12;
        this._animationSequence[0][4] = -1;
        this._animationSequence[0][5] = -1;
        this._animationSequence[1][0] = 4;
        this._animationSequence[1][1] = 6;
        this._animationSequence[1][2] = 7;
        this._animationSequence[1][3] = 8;
        this._animationSequence[1][4] = 9;
        this._animationSequence[1][5] = 10;
        this._animationSequence[3][0] = 1;
        this._animationSequence[3][1] = 3;
        this._animationSequence[3][2] = 5;
        this._animationSequence[3][3] = 10;
        this._animationSequence[3][4] = -1;
        this._animationSequence[3][5] = -1;
        this._animationSequence[7][0] = 1;
        this._animationSequence[7][1] = 3;
        this._animationSequence[7][2] = 10;
        this._animationSequence[7][3] = -1;
        this._animationSequence[7][4] = -1;
        this._animationSequence[7][5] = -1;
        this._animationSequence[8][0] = 1;
        this._animationSequence[8][1] = 3;
        this._animationSequence[8][2] = 10;
        this._animationSequence[8][3] = 11;
        this._animationSequence[8][4] = -1;
        this._animationSequence[8][5] = -1;
        this._animationSequence[6][0] = 1;
        this._animationSequence[6][1] = 3;
        this._animationSequence[6][2] = 10;
        this._animationSequence[6][3] = 11;
        this._animationSequence[6][4] = -1;
        this._animationSequence[6][5] = -1;
        this._animationSequence[2][0] = 1;
        this._animationSequence[2][1] = 3;
        this._animationSequence[2][2] = 10;
        this._animationSequence[2][3] = 11;
        this._animationSequence[2][4] = -1;
        this._animationSequence[2][5] = -1;
        this._animationSequence[5][0] = 1;
        this._animationSequence[5][1] = 3;
        this._animationSequence[5][2] = 11;
        this._animationSequence[5][3] = -1;
        this._animationSequence[5][4] = -1;
        this._animationSequence[5][5] = -1;
        this._animationSequence[4][0] = 1;
        this._animationSequence[4][1] = 3;
        this._animationSequence[4][2] = 11;
        this._animationSequence[4][3] = -1;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, new Rectangle(0, 0, 0, 0), this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, new Rectangle(0, 0, 0, 0), this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this._rectText, this._WIDTH, this._HEIGHT);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this._rectLogo, this._WIDTH, this._HEIGHT);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this._rectTop, this._WIDTH, this._HEIGHT);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, this._rectItems[5], this._WIDTH, this._HEIGHT);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this._rectItems[3], this._WIDTH, this._HEIGHT);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this._rectItems[1], this._WIDTH, this._HEIGHT);
        this._animationComponents[9] = new AnimationComponent(this.mainCanvas, this._rectItems[6], this._WIDTH, this._HEIGHT);
        this._animationComponents[10] = new AnimationComponent(this.mainCanvas, this._rectItems[4], this._WIDTH, this._HEIGHT);
        this._animationComponents[11] = new AnimationComponent(this.mainCanvas, this._rectItems[0], this._WIDTH, this._HEIGHT);
        this._animationComponents[12] = new AnimationComponent(this.mainCanvas, this._rectGameArea, this._WIDTH, this._HEIGHT);
        this.showAnimationComponent();
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[2].startShowAnimation(2);
        this._animationComponents[3].startShowAnimation(3);
        this._animationComponents[4].startShowAnimation(2);
        this._animationComponents[5].startShowAnimation(2);
        this._animationComponents[6].startShowAnimation(1);
        this._animationComponents[7].startShowAnimation(0);
        this._animationComponents[8].startShowAnimation(1);
        this._animationComponents[9].startShowAnimation(0);
        this._animationComponents[10].startShowAnimation(1);
        this._animationComponents[11].startShowAnimation(0);
        this._animationComponents[12].startShowAnimation(3);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[2].startHideAnimation(2);
        this._animationComponents[3].startHideAnimation(3);
        this._animationComponents[4].startHideAnimation(2);
        this._animationComponents[5].startHideAnimation(2);
        this._animationComponents[6].startHideAnimation(1);
        this._animationComponents[7].startHideAnimation(0);
        this._animationComponents[8].startHideAnimation(1);
        this._animationComponents[9].startHideAnimation(0);
        this._animationComponents[10].startHideAnimation(1);
        this._animationComponents[11].startHideAnimation(0);
        this._animationComponents[12].startHideAnimation(3);
    }

    private void preapreTxt() {
        String _sTmpControls = Resources.resTexts[0].getHashedString(16);
        int iSpace = Resources.resGFonts[0].getHeight();
        this._ptInstructions.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + _sTmpControls, this._rectText.width - iSpace);
        this._ptInstructions.setLineHeightCorrection(-2);
        this._ptGameScore.prepareText("0", this._rectTop.width);
        this._ptMoves.prepareText("0", this._rectTop.width);
    }

    private void loadLevel() {
        this.lvl = this._iGameMode == Level.TYPE_BLOCKER || this._iGameMode == Level.TYPE_MIXED_TIME_AND_BLOCKS ? Level._iBlockScheme : 1;
        RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
    }

    private void loadData() {
        int rmsConnectId = this.getRMSConnectIdByGameType(0);
        RMSObjects.createRMSConnect(rmsConnectId);
        if (!this._bBonusPack) {
            RMSObjects.createRMSConnect(0);
            RMSObjects.rmsConnects[0].load();
        } else {
            RMSObjects.createRMSConnect(9);
            RMSObjects.rmsConnects[9].load();
        }
    }

    private void freeGraphics() {
        this.imgBG = null;
        this._imgGameLogo = null;
        this._sprMenuIcons = null;
        this._ptInstructions = null;
        this.sprGameMode = null;
    }

    private void addScoreToTable() {
        if (!this._bBonusPack) {
            PowV2ScoreItem scoreItem = new PowV2ScoreItem();
            scoreItem.powGameId = 0;
            scoreItem.scorePos = this.actualLevel;
            scoreItem.userName = Integer.toString(this.actualLevel);
            scoreItem.scoreValue = RMSObjects.game.getScore() >= Level._iScoreHig ? 3 : (RMSObjects.game.getScore() >= Level._iScoreMid ? 2 : (RMSObjects.game.getScore() >= Level._iScoreMin ? 1 : 0));
            RMSObjects.localScores.userName = Integer.toString(this.actualLevel);
            RMSObjects.localScores.insertScoreItem(scoreItem, this.actualLevel);
            if (!RMSObjects.rmsConnects[0].isExist()) {
                RMSObjects.rmsConnects[0].create();
            }
            RMSObjects.rmsConnects[0].save();
        } else {
            PowV2ScoreItem scoreItem = new PowV2ScoreItem();
            scoreItem.powGameId = 0;
            scoreItem.scorePos = this.actualLevel;
            scoreItem.userName = Integer.toString(this.actualLevel);
            scoreItem.scoreValue = RMSObjects.game.getScore() >= Level._iScoreHig ? 3 : (RMSObjects.game.getScore() >= Level._iScoreMid ? 2 : (RMSObjects.game.getScore() >= Level._iScoreMin ? 1 : 0));
            RMSObjects.localScoresBonus.userName = Integer.toString(this.actualLevel);
            RMSObjects.localScoresBonus.insertScoreItem(scoreItem, this.actualLevel);
            if (!RMSObjects.rmsConnects[9].isExist()) {
                RMSObjects.rmsConnects[9].create();
            }
            RMSObjects.rmsConnects[9].save();
        }
    }

    private int getRMSConnectIdByGameType(int gameType) {
        switch (0) {
            case 20: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
        }
        return 0;
    }

    public void beforeInteruption() {
        if (this._iStatus == 0) {
            this.setGameMenuStatus();
        }
        this.mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
    }

    private void calculatePositions() {
        Jewel.SHIFT_HORIZONTAL_SEL = 0;
        Jewel.SHIFT_VERTICAL_SEL = 0;
        Jewel.BLOCKSIZE = Resources.resImgs[5].getWidth();
        Jewel.SHIFT_HORIZONTAL = (Resources.resImgs[5].getWidth() >> 1) - (Resources.resSprs[13].getWidth() >> 1);
        Jewel.SHIFT_VERTICAL = (Resources.resImgs[5].getHeight() >> 1) - (Resources.resSprs[13].getHeight() >> 1);
        Jewel.SHIFT_HORIZONTAL_FALL = (Resources.resImgs[5].getWidth() >> 1) - (Resources.resSprs[13].getWidth() >> 1);
        Jewel.SHIFT_VERTICAL_FALL = (Resources.resImgs[5].getHeight() >> 1) - 1;
        Jewel.SHIFT_HORIZONTAL_ESCAPE = (Resources.resImgs[5].getWidth() >> 1) - (Resources.resSprs[18].getWidth() >> 1);
        Jewel.SHIFT_VERTICAL_ESCAPE = (Resources.resImgs[5].getHeight() >> 1) - (Resources.resSprs[18].getHeight() >> 1);
        int _windowWidth = this._WIDTH >> 1;
        int _offsetTopY = this.imgSmallButton.getHeight();
        int _offsetBottomY = this.imgSmallButton.getHeight();
        int _panelHeight = this._HEIGHT - _offsetTopY - _offsetBottomY;
        this._iOffsetY >>= 3;
        boolean posX = false;
        int posY = this._imgGameLogo.getHeight() + this._iOffsetY;
        int _iTmpY = (MainCanvas.HEIGHT - (Jewel.BLOCKSIZE << 3) >> 1) - this.imgTopBar.getHeight() >> 1;
        this._rectTop = new Rectangle(this._iOffsetXDefault, _iTmpY, this._WIDTH - (this._iOffsetXDefault << 1), this.imgTopBar.getHeight());
        this._rectItems[5] = new Rectangle((this._WIDTH >> 1) - (this.imgMiddleButton.getWidth() >> 1), this._HEIGHT - (this.imgMiddleButton.getHeight() << 2) - 1, this.imgMiddleButton.getWidth(), this.imgMiddleButton.getHeight());
        int pY = this._rectItems[5].y + this._rectItems[5].height + (this.imgMiddleButton.getHeight() >> 3);
        int pX = (this._WIDTH >> 1) - (this.imgMiddleButton.getWidth() >> 1);
        int pXoffset = this.imgMiddleButton.getWidth() + (this.imgMiddleButton.getWidth() >> 2);
        this._rectLogo = new Rectangle((this._WIDTH >> 1) - (this._imgGameLogo.getWidth() >> 1), 0, this._imgGameLogo.getWidth(), this._imgGameLogo.getHeight());
        int iRectTextShiftY = 0;
        iRectTextShiftY = MainCanvas.HEIGHT >= 640 ? _offsetTopY << 1 : (MainCanvas.HEIGHT >= 480 ? (_offsetTopY << 1) - (_offsetTopY >> 2) : (MainCanvas.HEIGHT >= 320 ? _offsetTopY + (_offsetTopY >> 1) : (MainCanvas.HEIGHT >= 287 ? _offsetTopY + (_offsetTopY >> 2) : _offsetTopY + (_offsetTopY >> 2))));
        int iRectTextHeightShiftY = 0;
        if (MainCanvas.HEIGHT < 320 && MainCanvas.HEIGHT < 287) {
            iRectTextHeightShiftY = _offsetTopY;
        }
        int countX = MainCanvas.WIDTH / this.sprWindow.getWidth();
        int countY = (MainCanvas.HEIGHT - (this.imgMiddleButton.getHeight() << 1)) / this.sprWindow.getHeight();
        if (MainCanvas.HEIGHT <= 300) {
            --countX;
            --countY;
            if (MainCanvas.HEIGHT <= 220) {
                ++countY;
            }
        }
        int width = this.sprWindow.getWidth() * countX;
        int height = this.sprWindow.getHeight() * countY;
        if (countX % 2 == 1) {
            width += this.sprWindow.getWidth() >> 1;
        }
        if (countY % 2 == 1) {
            height += this.sprWindow.getHeight() >> 1;
        }
        if (MainCanvas.HEIGHT <= 220) {
            height += this.sprWindow.getHeight() >> 1;
        }
        if (MainCanvas.HEIGHT == 208) {
            height += this.sprWindow.getHeight() >> 1;
        }
        int y = MainCanvas.HEIGHT - height - this.imgBigButton.getHeight();
        if (MainCanvas.HEIGHT == 240 && MainCanvas.WIDTH == 320) {
            y -= this.sprWindow.getHeight();
            height += this.sprWindow.getHeight();
        }
        if (MainCanvas.HEIGHT == 640) {
            y -= this.sprWindow.getHeight() >> 1;
            height += this.sprWindow.getHeight() >> 1;
        }
        if (MainCanvas.HEIGHT == 320 && MainCanvas.WIDTH == 240) {
            y = 2;
            height += this.sprWindow.getHeight();
        }
        this.rectDialogInstr = new Rectangle((MainCanvas.WIDTH >> 1) - (width >> 1), y, width, height);
        this.rectSmallDialogInstr = new Rectangle(this.rectDialogInstr.x + this.sprWindow.getWidth(), y + this.sprWindow.getHeight(), width - (this.sprWindow.getWidth() << 1), height - (this.sprWindow.getHeight() << 1));
        this._rectItems[3] = new Rectangle(pX, pY + this.imgMiddleButton.getHeight(), this.imgMiddleButton.getWidth(), this.imgMiddleButton.getHeight());
        this._rectItems[1] = new Rectangle(pX - (pXoffset >> 1), pY - (this.imgMiddleButton.getHeight() >> 3), this.imgMiddleButton.getWidth(), this.imgMiddleButton.getHeight());
        this._rectItems[6] = new Rectangle(pX + (pXoffset >> 1), pY - (this.imgMiddleButton.getHeight() >> 3), this.imgMiddleButton.getWidth(), this.imgMiddleButton.getHeight());
        int heightArrow = this.imgArrowDown.getHeight();
        int widthArrow = this.imgArrowDown.getWidth();
        this._rectText = new Rectangle(this.rectDialogInstr.x + (heightArrow >> 1), this.rectDialogInstr.y + heightArrow + (heightArrow >> 2), this.rectDialogInstr.width - heightArrow, this.rectDialogInstr.height - (heightArrow + (heightArrow >> 2) << 1));
        this._rectItems[7] = new Rectangle((MainCanvas.WIDTH >> 1) - (widthArrow >> 1), this.rectDialogInstr.y + (heightArrow >> 3), widthArrow, heightArrow);
        this._rectItems[8] = new Rectangle((MainCanvas.WIDTH >> 1) - (widthArrow >> 1), this.rectDialogInstr.getBottom() - heightArrow - (heightArrow >> 3), widthArrow, heightArrow);
        int widthBtn = MainCanvas.WIDTH / 3;
        this._rectItems[0] = new Rectangle(0, this.rectDialogInstr.getBottom() - (this.imgMiddleButton.getHeight() >> 2), widthBtn, this.imgBigButton.getHeight());
        this._rectItems[4] = new Rectangle(MainCanvas.WIDTH - widthBtn, this.rectDialogInstr.getBottom() - (this.imgMiddleButton.getHeight() >> 2), widthBtn, this.imgBigButton.getHeight());
        int iShiftY = 0;
        if (MainCanvas.HEIGHT < 640) {
            iShiftY = MainCanvas.HEIGHT >= 480 ? Jewel.BLOCKSIZE >> 3 : Jewel.BLOCKSIZE >> 2;
        }
        this._rectGameArea = new Rectangle(MainCanvas.WIDTH - (Jewel.BLOCKSIZE << 3) >> 1, (MainCanvas.HEIGHT - (Jewel.BLOCKSIZE << 3) >> 1) + iShiftY, Jewel.BLOCKSIZE << 3, Jewel.BLOCKSIZE << 3);
        Jewel.MOVE_VELOCITY = (this._rectGameArea.width << 8) / 48;
        Jewel.DSP_BNSBOMB = Resources.resSprs[16].getWidth() - Jewel.BLOCKSIZE >> 1;
        Jewel.DSP_BNSCROSS = Resources.resSprs[17].getWidth() - Jewel.BLOCKSIZE >> 1;
        this._rectItems[9] = new Rectangle((MainCanvas.WIDTH >> 1) - (widthBtn >> 1), this._rectItems[4].y, widthBtn, this.imgBigButton.getHeight());
        int offset = this.imgSmallButton.getWidth() >> 3;
        int xCenterFK = MainCanvas.WIDTH - (this.imgSmallButton.getWidth() >> 1) - offset;
        int yCenterFK = MainCanvas.HEIGHT - (this.imgSmallButton.getHeight() >> 1) - offset;
        this.rectFK = new Rectangle(xCenterFK - (this.imgSmallButton.getWidth() >> 1), yCenterFK - (this.imgSmallButton.getHeight() >> 1), this.imgSmallButton.getWidth(), this.imgSmallButton.getHeight());
        if (MainCanvas.HEIGHT == 320 && MainCanvas.WIDTH == 240) {
            int newY;
            this._rectItems[9].y = newY = MainCanvas.HEIGHT - this.imgBigButton.getHeight();
            this._rectItems[0].y = newY;
            this._rectItems[4].y = newY;
        }
        if (MainCanvas.HEIGHT == 480 && MainCanvas.WIDTH == 360) {
            this._rectLogo.y += this._rectLogo.height >> 1;
        }
    }

    public void update(long lastRunLenght) {
        if (this._iStatus == 5) {
            this.reset();
        }
        if (this._iStatus == 0 && this._iNextMode != 2) {
            RMSObjects.game.update(lastRunLenght);
            this.gameScore = RMSObjects.game.getScore();
            if (RMSObjects.game.isLevelDone()) {
                this.startAnimation(true, 2);
                this.addScoreToTable();
            } else if (RMSObjects.game.isGameOver()) {
                this.startAnimation(true, 2);
                this.icount = -1;
                if (this.getTopScore() < this.gameScore) {
                    this.icount = 0;
                }
            }
            this.mainCanvas.repaint();
        }
        if (this._iStatus == 2 && this.icount >= 0) {
            ++this.icount;
            this.icount %= 10;
            this.mainCanvas.repaint();
        }
        if (this._iStatus == 3) {
            this._bNeedRepaint = false;
            this.textMove();
            if (this._bNeedRepaint) {
                this.mainCanvas.repaint();
            }
        }
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == 4 ? this._iSequenceHide : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        if (this._iSequence == this._iSequenceHide) {
            this._iSequence = this._iSequenceShow;
            this._iStatus = this._iNextMode;
            this._bChangeSequence = true;
            this.mainCanvas.repaint();
        } else if (this._iSequence == this._iSequenceShow) {
            this._iSequence = this._iSequenceStop;
            this.mainCanvas.repaint();
        }
        boolean _return = false;
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                if (this._iNextMode == 9) {
                    this.startMenuScreen();
                }
                if (this._iNextMode == 9) {
                    this.startSelectLevel();
                }
                this._iSequence = this._iSequenceShow;
                this._iStatus = this._iNextMode;
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startMenuScreen() {
        ScreenMenu sg = new ScreenMenu(this.mainCanvas, 0);
        this.mainCanvas.changeLastActiveScreen(sg);
    }

    private void startSelectLevel() {
        if (!this._bBonusPack) {
            this.mainCanvas.changeLastActiveScreen(new ScreenSelectLevel(this.mainCanvas, 0));
        } else {
            this.mainCanvas.changeLastActiveScreen(new ScreenSelectBonusLevel(this.mainCanvas, 0));
        }
        this.mainCanvas.getSoundManager().Stop();
    }

    private void reset() {
        try {
            this.score = 0;
            this.stars = "";
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this._iStatus) {
            case 0: {
                this.paintGame(g);
                break;
            }
            case 1: {
                this.paintGameMenuScreen(g);
                break;
            }
            case 3: {
                this.paintInstructionsScreen(g);
                break;
            }
            case 7: {
                this.paintLastMessageScreen(g);
                break;
            }
            case 8: {
                this.paintRealyQuitScreen(g);
                break;
            }
            case 6: {
                this.paintRestartScreen(g);
                break;
            }
            case 2: {
                this.paintResultScreen(g);
                break;
            }
            case 5: {
                this.paintLevelGoalScreen(g);
                break;
            }
            case 4: {
                this.paintTutorialScreen(g);
            }
        }
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        if (this._iStatus == 1) {
            g.drawImage(this.imgBG, 0, 0, 20);
        } else {
            g.drawImage(this.imgBG, 0, 0, 20);
        }
    }

    private void paintGame(Graphics g) {
        RMSObjects.game.paint(g);
        this.paintGameProgressBar(g);
    }

    private void paintGameMenuScreen(Graphics g) {
        this.paintLogo(g);
        this.paintDialog(g);
    }

    private void paintInstructionsScreen(Graphics g) {
        this.paintWindow(g, false, false, true);
        this.paintInstructionsTxt(g);
        this.paintArrows(g);
    }

    private void paintLastMessageScreen(Graphics g) {
        this.paintWindow(g, false, true, false);
        this.paintLastMessageTxt(g);
    }

    private void paintRealyQuitScreen(Graphics g) {
        this.paintWindow(g, true, false, false);
        this.paintRealyQuitMessageTxt(g);
    }

    private void paintRestartScreen(Graphics g) {
        this.paintWindow(g, true, false, false);
        this.paintRestartTxt(g);
    }

    private void paintResultScreen(Graphics g) {
        this.paintWindow(g, false, true, false);
        this.paintResultTxt(g);
    }

    private void paintLevelGoalScreen(Graphics g) {
        this.paintWindow(g, false, false, false);
        this.paintLevelGoalTxt(g);
    }

    private void paintTutorialScreen(Graphics g) {
        this.paintWindow(g, false, false, false);
        this.paintTutorialTxt(g);
    }

    private void paintLogo(Graphics g) {
        g.drawImage(this._imgGameLogo, this._rectLogo.getCenterX(), this._rectLogo.getCenterY(), 3);
    }

    private void paintDialog(Graphics g) {
        if (this._iSelectedCompId == 5) {
            this.paintButton(g, 5, true);
        } else {
            this.paintButton(g, 5, false);
        }
        if (this._iSelectedCompId == 1) {
            this.paintButton(g, 1, true);
        } else {
            this.paintButton(g, 1, false);
        }
        if (this._iSelectedCompId == 6) {
            this.paintButton(g, 6, true);
        } else {
            this.paintButton(g, 6, false);
        }
    }

    private void paintButton(Graphics g, int _iDx, boolean _bSelected) {
        switch (_iDx) {
            case 5: {
                g.drawImage(this.imgMiddleButton, this._rectItems[_iDx].getCenterX(), this._rectItems[_iDx].getCenterY(), 3);
                this.sprMediumIcons1.setFrame(Common.MIDDLE_RESTART);
                this.sprMediumIcons1.setPosition(this._rectItems[_iDx].getCenterX() - (this.sprMediumIcons1.getWidth() >> 1), this._rectItems[_iDx].getCenterY() - (this.sprMediumIcons1.getHeight() >> 1));
                this.sprMediumIcons1.paint(g);
                break;
            }
            case 1: {
                g.drawImage(this.imgMiddleButton, this._rectItems[_iDx].getCenterX(), this._rectItems[_iDx].getCenterY(), 3);
                this.sprMediumIcons1.setFrame(Common.MIDDLE_INSTRUCTIONS);
                this.sprMediumIcons1.setPosition(this._rectItems[_iDx].getCenterX() - (this.sprMediumIcons1.getWidth() >> 1), this._rectItems[_iDx].getCenterY() - (this.sprMediumIcons1.getHeight() >> 1));
                this.sprMediumIcons1.paint(g);
                break;
            }
            case 3: {
                g.drawImage(this.imgMiddleButton, this._rectItems[_iDx].getCenterX(), this._rectItems[_iDx].getCenterY(), 3);
                this.sprMediumIcons1.setFrame(this.mainCanvas.getSoundManager().IsSoundOn() ? Common.MIDDLE_SOUND_ON : Common.MIDDLE_SOUND_OFF);
                this.sprMediumIcons1.setPosition(this._rectItems[_iDx].getCenterX() - (this.sprMediumIcons1.getWidth() >> 1), this._rectItems[_iDx].getCenterY() - (this.sprMediumIcons1.getHeight() >> 1));
                this.sprMediumIcons1.paint(g);
                break;
            }
            case 6: {
                g.drawImage(this.imgMiddleButton, this._rectItems[_iDx].getCenterX(), this._rectItems[_iDx].getCenterY(), 3);
                this.sprMediumIcons1.setFrame(Common.MIDDLE_MENU);
                this.sprMediumIcons1.setPosition(this._rectItems[_iDx].getCenterX() - (this.sprMediumIcons1.getWidth() >> 1), this._rectItems[_iDx].getCenterY() - (this.sprMediumIcons1.getHeight() >> 1));
                this.sprMediumIcons1.paint(g);
            }
        }
        if (_bSelected && _bSelected) {
            g.drawImage(this.imgMiddleSelector, this._rectItems[_iDx].getCenterX(), this._rectItems[_iDx].getCenterY(), 3);
        }
    }

    private void paint3x1Skin(int x, int y, int width, Sprite spr, Graphics g) {
        g.setClip(x + spr.getWidth(), y, width - (spr.getWidth() << 1), spr.getHeight());
        spr.setFrame(1);
        for (int i = 0; i < width / spr.getWidth(); ++i) {
            spr.setPosition(x + i * spr.getWidth(), y);
            spr.paint(g);
        }
        g.setClip(x, y, width, spr.getHeight());
        spr.setFrame(0);
        spr.setPosition(x, y);
        spr.paint(g);
        spr.setFrame(2);
        spr.setPosition(x + width - spr.getWidth(), y);
        spr.paint(g);
        g.setClip(0, 0, this._WIDTH, this._HEIGHT);
    }

    private void paintMoves(Graphics g) {
        String _s = Level._iMoves - MainCanvas.moveCounter + "";
        Rectangle _lect = new Rectangle(0, 0 - (this._animationComponents[5]._iDefaultY - this._animationComponents[5]._defaultRectangle.y), this._WIDTH, this.imgTopBar.getHeight() / 3 * 2);
        this._ptMoves.prepareText(_s, this._rectTop.width);
        int iTextShiftY = 0;
        this._sprTopbarStats.setFrame(0);
        this._sprTopbarStats.setPosition(_lect.getCenterX() - (this._sprTopbarStats.getWidth() >> 1), _lect.getCenterY() - (this._sprTopbarStats.getHeight() >> 1));
        this._sprTopbarStats.paint(g);
        this._ptMoves.drawText(g, _lect, iTextShiftY, 3);
    }

    private void paintTime(Graphics g) {
        String _s = Integer.toString((int)Level._lTime - RMSObjects.game.getTimeInSec() < 0 ? 0 : (int)Level._lTime - RMSObjects.game.getTimeInSec()) + "";
        Rectangle _lect = new Rectangle(0, 0 - (this._animationComponents[5]._iDefaultY - this._animationComponents[5]._defaultRectangle.y), this._WIDTH, this.imgTopBar.getHeight() / 3 * 2);
        this._ptMoves.prepareText(_s, this._rectTop.width);
        int iTextShiftY = 0;
        this._sprTopbarStats.setFrame(0);
        this._sprTopbarStats.setPosition(_lect.getCenterX() - (this._sprTopbarStats.getWidth() >> 1), _lect.getCenterY() - (this._sprTopbarStats.getHeight() >> 1));
        this._sprTopbarStats.paint(g);
        this._ptMoves.drawText(g, _lect, iTextShiftY, 3);
    }

    private void paintScore(Graphics g) {
        Sprite sprBar = Resources.resSprs[34];
        String _s = Integer.toString(this.gameScore) + "";
        int width = sprBar.getHeight() * 3;
        Rectangle _lect = new Rectangle((MainCanvas.WIDTH >> 1) - width - this._sprTopbarStats.getWidth(), this.imgTopBar.getHeight() / 3 - (sprBar.getHeight() >> 1), width, sprBar.getHeight());
        this.paint3x1Skin(_lect.x, _lect.y, _lect.width, sprBar, g);
        this._ptGameScore.prepareText(_s, this._rectTop.width);
        int iTextShiftY = 0;
        _lect.width -= sprBar.getWidth() >> 1;
        this._ptGameScore.drawText(g, _lect, iTextShiftY, 10);
    }

    private void paintLevelGoal(int icon, int value, Graphics g) {
        if (value < 0) {
            value = 0;
        }
        String _s = "X" + Integer.toString(value) + " ";
        Sprite sprBar = Resources.resSprs[34];
        int width = sprBar.getHeight() * 3;
        Rectangle _lect = new Rectangle((MainCanvas.WIDTH >> 1) + this._sprTopbarStats.getWidth(), this.imgTopBar.getHeight() / 3 - (sprBar.getHeight() >> 1), width, sprBar.getHeight());
        this.paint3x1Skin(_lect.x, _lect.y, _lect.width, sprBar, g);
        Rectangle _rectRight = new Rectangle(_lect);
        _rectRight.x += (_rectRight.width >> 1) - (_rectRight.width >> 3);
        this._ptGameScore.prepareText(_s, this._rectTop.width);
        int iTextShiftY = 0;
        this._ptGameScore.drawText(g, _rectRight, iTextShiftY, 6);
        Resources.resSprs[31].setFrame(icon);
        Resources.resSprs[31].setPosition(_lect.x + ((_lect.width >> 1) - (_lect.width >> 3) - Resources.resSprs[31].getWidth() >> 1), _lect.y + (sprBar.getHeight() - Resources.resSprs[31].getHeight() >> 1));
        Resources.resSprs[31].paint(g);
    }

    private void paintStars(Graphics g) {
        Sprite sprBg = Resources.resSprs[35];
        Sprite sprFill = Resources.resSprs[36];
        Sprite sprStars = Resources.resSprs[32];
        int y = this.imgTopBar.getHeight() - sprBg.getHeight() - (sprBg.getHeight() >> 1);
        this.score = this.gameScore;
        int offset = this._WIDTH >> 2;
        int barW = this._WIDTH - (offset << 1);
        int fillOffset = sprBg.getHeight() - sprFill.getHeight() >> 1;
        int scoreClip = (this.score << 7) / ((Level._iScoreHig << 7) / (barW - (fillOffset << 1)));
        if (scoreClip > barW - (fillOffset << 1)) {
            scoreClip = barW - (fillOffset << 1);
        }
        this.paint3x1Skin(offset, y, barW, sprBg, g);
        this.paint3x1Skin(offset + fillOffset, y + fillOffset, scoreClip, sprFill, g);
        int starY = y + (sprBg.getHeight() >> 1) - (sprStars.getHeight() >> 1);
        int starX = offset + (Level._iScoreMin << 7) / ((Level._iScoreHig << 7) / barW) - (sprStars.getWidth() >> 1);
        sprStars.setFrame(this.score > Level._iScoreMin ? 0 : 1);
        sprStars.setPosition(starX, starY);
        sprStars.paint(g);
        starX = offset + (Level._iScoreMid << 7) / ((Level._iScoreHig << 7) / barW) - (sprStars.getWidth() >> 1);
        sprStars.setFrame(this.score > Level._iScoreMid ? 0 : 1);
        sprStars.setPosition(starX, starY);
        sprStars.paint(g);
        sprStars.setFrame(this.score > Level._iScoreHig ? 0 : 1);
        sprStars.setPosition(this._WIDTH - offset - (sprStars.getWidth() >> 1), starY);
        sprStars.paint(g);
    }

    private void paintGameProgressBar(Graphics g) {
        g.drawImage(this.imgTopBar, MainCanvas.WIDTH >> 1, this.imgTopBar.getHeight() >> 1, 3);
        this.paintScore(g);
        if (this._iGameMode == 0) {
            this.paintMoves(g);
        } else if (this._iGameMode == 1) {
            this.paintTime(g);
        } else if (this._iGameMode == 2) {
            this.paintMoves(g);
            this.paintLevelGoal(2, Level._iEscapeObjCount - Game._iProgressSecondary, g);
        } else if (this._iGameMode == 3) {
            this.paintMoves(g);
            this.paintLevelGoal(0, Level._iDownfallObjCount - Game._iProgressSecondary, g);
        } else if (this._iGameMode == 4) {
            this.paintTime(g);
            this.paintLevelGoal(1, Block.count(), g);
        } else if (this._iGameMode == 5) {
            this.paintMoves(g);
            this.paintLevelGoal(1, Block.count(), g);
        } else if (this._iGameMode == 7) {
            this.paintTime(g);
            this.paintLevelGoal(3, Level._iMoves - MainCanvas.moveCounter, g);
        }
        this.paintStars(g);
    }

    private void paintWindow(Graphics g, boolean bSmall, boolean bBig, boolean bInstructions) {
        int y;
        Sprite sprite = this.sprWindow;
        if (this._iStatus == 2) {
            sprite = this.sprResult;
        }
        for (int x = this.rectSmallDialogInstr.x; x < this.rectSmallDialogInstr.getRight(); x += this.sprWindow.getWidth()) {
            if (x + this.sprWindow.getWidth() > this.rectSmallDialogInstr.getRight()) {
                x = this.rectSmallDialogInstr.getRight() - this.sprWindow.getWidth();
            }
            sprite.setFrame(1);
            sprite.setPosition(x, this.rectDialogInstr.y);
            sprite.paint(g);
            this.sprWindow.setFrame(7);
            this.sprWindow.setPosition(x, this.rectDialogInstr.getBottom() - this.sprWindow.getHeight());
            this.sprWindow.paint(g);
        }
        for (y = this.rectSmallDialogInstr.y; y < this.rectSmallDialogInstr.getBottom(); y += this.sprWindow.getHeight()) {
            if (y + this.sprWindow.getHeight() > this.rectSmallDialogInstr.getBottom()) {
                y = this.rectSmallDialogInstr.getBottom() - this.sprWindow.getHeight();
            }
            this.sprWindow.setFrame(3);
            this.sprWindow.setPosition(this.rectDialogInstr.x, y);
            this.sprWindow.paint(g);
            this.sprWindow.setFrame(5);
            this.sprWindow.setPosition(this.rectDialogInstr.getRight() - this.sprWindow.getWidth(), y);
            this.sprWindow.paint(g);
        }
        for (y = this.rectSmallDialogInstr.y; y < this.rectSmallDialogInstr.getBottom(); y += this.sprWindow.getHeight()) {
            for (int x = this.rectSmallDialogInstr.x; x < this.rectSmallDialogInstr.getRight(); x += this.sprWindow.getWidth()) {
                if (x + this.sprWindow.getWidth() > this.rectSmallDialogInstr.getRight()) {
                    x = this.rectSmallDialogInstr.getRight() - this.sprWindow.getWidth();
                }
                this.sprWindow.setFrame(4);
                this.sprWindow.setPosition(x, y);
                this.sprWindow.paint(g);
            }
        }
        sprite.setFrame(0);
        sprite.setPosition(this.rectDialogInstr.x, this.rectDialogInstr.y);
        sprite.paint(g);
        sprite.setFrame(2);
        sprite.setPosition(this.rectDialogInstr.getRight() - sprite.getWidth(), this.rectDialogInstr.y);
        sprite.paint(g);
        this.sprWindow.setFrame(6);
        this.sprWindow.setPosition(this.rectDialogInstr.x, this.rectDialogInstr.getBottom() - this.sprWindow.getHeight());
        this.sprWindow.paint(g);
        this.sprWindow.setFrame(8);
        this.sprWindow.setPosition(this.rectDialogInstr.getRight() - this.sprWindow.getWidth(), this.rectDialogInstr.getBottom() - this.sprWindow.getHeight());
        this.sprWindow.paint(g);
    }

    private void paintArrows(Graphics g) {
        if (this._ptInstructions.getTextHeight() < this._rectText.height) {
            System.out.println("nothing");
        } else {
            if (this._bScrollUP) {
                g.drawImage(this.imgArrowUp, this._rectItems[7].getCenterX(), this._rectItems[7].getCenterY(), 3);
            }
            if (this._bScrollDOWN) {
                g.drawImage(this.imgArrowDown, this._rectItems[8].getCenterX(), this._rectItems[8].getCenterY(), 3);
            }
        }
    }

    private void paintInstructionsTxt(Graphics g) {
        this._ptInstructions.drawText(g, this._rectText, this._iTextOffsetY, 17);
    }

    private void paintTutorialTxt(Graphics g) {
        String _sTutotialTxt = "";
        if (MainCanvas.controlsTut == 0 && this.level == 0) {
            _sTutotialTxt = Resources.resTexts[0].getHashedString(29);
        } else {
            switch (this._iGameMode) {
                case 0: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(31);
                    break;
                }
                case 1: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(35);
                    break;
                }
                case 2: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(33);
                    break;
                }
                case 3: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(34);
                    break;
                }
                case 5: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(32);
                }
            }
        }
        boolean _bShitDevice = false;
        if (this._WIDTH == 176 && this._HEIGHT == 208) {
            _bShitDevice = true;
        }
        if (this._WIDTH == 176 && this._HEIGHT == 220) {
            _bShitDevice = true;
        }
        if (this._WIDTH == 208 && this._HEIGHT == 208) {
            _bShitDevice = true;
        }
        if (MainCanvas._bFranceLang) {
            _bShitDevice = true;
        }
        if (_bShitDevice) {
            this._ptGameTutorial.prepareText(_sTutotialTxt, this._rectText.width);
            Rectangle _rectTmp = new Rectangle(this._rectText.x, this._rectText.getCenterY() - (this._ptGameTutorial.getTextHeight() >> 1), this._rectText.width, this._ptGameTutorial.getTextHeight());
            this._ptGameTutorial.setLineHeightCorrection(-2);
            this._ptGameTutorial.drawText(g, _rectTmp, 0, 17);
        } else {
            this._ptGameTutorial.prepareText(_sTutotialTxt, this._rectText.width);
            Rectangle _rectTmp = new Rectangle(this._rectText.x, this._rectText.getCenterY() - (this._ptGameTutorial.getTextHeight() >> 1), this._rectText.width, this._ptGameTutorial.getTextHeight());
            this._ptGameTutorial.setLineHeightCorrection(-2);
            this._ptGameTutorial.drawText(g, _rectTmp, 0, 17);
        }
    }

    private void paintLevelGoalTxt(Graphics g) {
        String _sGoalsTxt = "";
        switch (this._iGameMode) {
            case 0: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(43) + " " + Level._iMoves + " " + Resources.resTexts[0].getHashedString(44) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 1: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level._lTime + " " + Resources.resTexts[0].getHashedString(46);
                break;
            }
            case 2: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(39) + " " + Level._iEscapeObjCount + " " + Resources.resTexts[0].getHashedString(59) + " " + Resources.resTexts[0].getHashedString(43) + " " + Level._iMoves + " " + Resources.resTexts[0].getHashedString(48) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 3: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(41) + " " + Level._iDownfallObjCount + " " + Resources.resTexts[0].getHashedString(42) + " " + Resources.resTexts[0].getHashedString(47) + " " + Level._iMoves + " " + Resources.resTexts[0].getHashedString(48) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 4: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(38) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level._lTime + " " + Resources.resTexts[0].getHashedString(46) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 5: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(38) + "\n" + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 6: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(39) + " " + Level._iEscapeObjCount + " " + Resources.resTexts[0].getHashedString(40) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level._lTime + " " + Resources.resTexts[0].getHashedString(46) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 7: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(43) + " " + Level._iMoves + " " + Resources.resTexts[0].getHashedString(44) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level._lTime + " " + Resources.resTexts[0].getHashedString(46) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
            }
        }
        this._ptGameTxts.prepareText(_sGoalsTxt, this._rectText.width);
        this._ptGameTxts2.prepareText(Resources.resTexts[0].getHashedString(8) + " " + (this.actualLevel + 1), this._rectText.width);
        Rectangle _rectTmp = new Rectangle(this._rectText.x, this._rectText.getCenterY() - (this._ptGameTxts.getTextHeight() >> 1) + (this.sprGameMode.getHeight() >> 1) + (this._ptGameTxts2.getTextHeight() >> 1), this._rectText.width, this._ptGameTxts.getTextHeight());
        Rectangle _rectTmp2 = new Rectangle(this._rectText.x, this._rectText.getCenterY() - (this._ptGameTxts.getTextHeight() >> 1) - (this.sprGameMode.getHeight() >> 1) - (this._ptGameTxts2.getTextHeight() >> 1), this._rectText.width, this._ptGameTxts.getTextHeight());
        this._ptGameTxts2.setLineHeightCorrection(-2);
        this._ptGameTxts2.drawText(g, _rectTmp2, 0, 17);
        switch (this._iGameMode) {
            case 0: {
                this.sprGameMode.setFrame(0);
                this.sprGameMode.setPosition(this._WIDTH - this.sprGameMode.getWidth() >> 1, _rectTmp.y - this.sprGameMode.getHeight());
                this.sprGameMode.paint(g);
                break;
            }
            case 1: {
                this.sprGameMode.setFrame(4);
                this.sprGameMode.setPosition(this._WIDTH - this.sprGameMode.getWidth() >> 1, _rectTmp.y - this.sprGameMode.getHeight());
                this.sprGameMode.paint(g);
                break;
            }
            case 2: {
                this.sprGameMode.setFrame(2);
                this.sprGameMode.setPosition(this._WIDTH - this.sprGameMode.getWidth() >> 1, _rectTmp.y - this.sprGameMode.getHeight());
                this.sprGameMode.paint(g);
                break;
            }
            case 3: {
                this.sprGameMode.setFrame(1);
                this.sprGameMode.setPosition(this._WIDTH - this.sprGameMode.getWidth() >> 1, _rectTmp.y - this.sprGameMode.getHeight());
                this.sprGameMode.paint(g);
                break;
            }
            case 4: {
                this.sprGameMode.setFrame(4);
                this.sprGameMode.setPosition((this._WIDTH >> 1) - this.sprGameMode.getWidth() + this.sprGameMode.getWidth() / 5, _rectTmp.y - this.sprGameMode.getHeight());
                this.sprGameMode.paint(g);
                this.sprGameMode.setFrame(3);
                this.sprGameMode.setPosition((this._WIDTH >> 1) - this.sprGameMode.getWidth() / 5, _rectTmp.y - this.sprGameMode.getHeight());
                this.sprGameMode.paint(g);
                break;
            }
            case 5: {
                this.sprGameMode.setFrame(3);
                this.sprGameMode.setPosition(this._WIDTH - this.sprGameMode.getWidth() >> 1, _rectTmp.y - this.sprGameMode.getHeight());
                this.sprGameMode.paint(g);
                break;
            }
            case 6: {
                this.sprGameMode.setFrame(4);
                this.sprGameMode.setPosition((this._WIDTH >> 1) - this.sprGameMode.getWidth() + this.sprGameMode.getWidth() / 5, _rectTmp.y - this.sprGameMode.getHeight());
                this.sprGameMode.paint(g);
                this.sprGameMode.setFrame(2);
                this.sprGameMode.setPosition((this._WIDTH >> 1) - this.sprGameMode.getWidth() / 5, _rectTmp.y - this.sprGameMode.getHeight());
                this.sprGameMode.paint(g);
                break;
            }
            case 7: {
                this.sprGameMode.setFrame(4);
                this.sprGameMode.setPosition((this._WIDTH >> 1) - this.sprGameMode.getWidth() + this.sprGameMode.getWidth() / 5, _rectTmp.y - this.sprGameMode.getHeight());
                this.sprGameMode.paint(g);
                this.sprGameMode.setFrame(0);
                this.sprGameMode.setPosition((this._WIDTH >> 1) - this.sprGameMode.getWidth() / 5, _rectTmp.y - this.sprGameMode.getHeight());
                this.sprGameMode.paint(g);
            }
        }
        this._ptGameTxts.setLineHeightCorrection(-2);
        this._ptGameTxts.drawText(g, _rectTmp, 0, 17);
    }

    private void paintLastMessageTxt(Graphics g) {
        String _sLastLevelGameMessge = "";
        _sLastLevelGameMessge = !this._bBonusPack ? (MainCanvas.totalStars == 180 ? Resources.resTexts[0].getHashedString(73) + " " + Resources.resTexts[0].getHashedString(74) : Resources.resTexts[0].getHashedString(72)) : (MainCanvas.totalBonusStars == 60 ? Resources.resTexts[0].getHashedString(76) : Resources.resTexts[0].getHashedString(75));
        this._ptGameTxts.prepareText(_sLastLevelGameMessge, this._rectText.width);
        Rectangle _rectTmp = new Rectangle(this._rectText.x, this._rectText.getCenterY() - (this._ptGameTxts.getTextHeight() >> 1), this._rectText.width, this._ptGameTxts.getTextHeight());
        this._ptGameTxts.setLineHeightCorrection(-2);
        this._ptGameTxts.drawText(g, _rectTmp, 0, 17);
    }

    private void paintRealyQuitMessageTxt(Graphics g) {
        String _sQuitQuestion = Resources.resTexts[0].getHashedString(77);
        this._ptGameTxts.prepareText(_sQuitQuestion, this._rectText.width);
        int iLinesCount = this._ptGameTxts.getTextLines();
        int iY = this._rectText.getCenterY() - (this._ptGameTxts.getTextHeight() >> 1);
        if (iLinesCount >= 7) {
            iY -= Resources.resGFonts[0].getHeight() >> 1;
        } else if (iLinesCount >= 5) {
            iY -= Resources.resGFonts[0].getHeight() >> 2;
        } else if (iLinesCount >= 3) {
            iY -= Resources.resGFonts[0].getHeight() >> 3;
        }
        for (int i = 0; i < iLinesCount; ++i) {
            Resources.resGFonts[0].drawString(g, this._ptGameTxts.getText(i).toCharArray(), this._rectText.getCenterX(), iY, 17);
            iY += Resources.resGFonts[0].getHeight();
        }
    }

    private void paintRestartTxt(Graphics g) {
        String _sRestart = Resources.resTexts[0].getHashedString(78);
        this._ptGameTxts.prepareText(_sRestart, this._rectText.width);
        this._ptGameTxts.setLineHeightCorrection(-2);
        this._ptGameTxts.drawText(g, this._rectText, 0, 3);
    }

    private void paintResultTxt(Graphics g) {
        if (RMSObjects.game.isLevelDone()) {
            this.paintWinTxt(g);
        } else if (RMSObjects.game.isGameOver()) {
            this.paintLoseTxt(g);
        }
    }

    private void paintWinTxt(Graphics g) {
        int iSpace = Resources.resGFonts[0].getHeight();
        this._ptGameTxts.prepareText(Resources.resTexts[0].getHashedString(56), this._rectText.width - iSpace * 2);
        String _sTmpFinal = Resources.resTexts[0].getHashedString(10) + ": " + (this.gameScore - RMSObjects.game.getBombScore() - RMSObjects.game.getEscScore() - RMSObjects.game.getDownScore()) + "\n" + Resources.resTexts[0].getHashedString(57) + ": " + RMSObjects.game.getBombScore() + "\n" + (this._iGameMode == 2 ? Resources.resTexts[0].getHashedString(59) + ": " + RMSObjects.game.getEscScore() + "\n" : "") + (this._iGameMode == 3 ? Resources.resTexts[0].getHashedString(58) + ": " + RMSObjects.game.getDownScore() + "\n" : "");
        _sTmpFinal = MainCanvas.HEIGHT <= 220 || MainCanvas.HEIGHT == 307 ? _sTmpFinal + "TOTAL: " + this.gameScore : _sTmpFinal + "TOTAL: " + this.gameScore;
        this._ptGameTxts2.prepareText(_sTmpFinal, this._rectText.width - iSpace);
        boolean bEs = false;
        if (MainCanvas.HEIGHT < 640 && MainCanvas.HEIGHT < 480 && Resources.getLangCode().compareTo("es") == 0) {
            bEs = true;
        }
        int iHeight = this._ptGameTxts.getTextHeight() + (this.imgStarActive.getHeight() >> 1) + this._ptGameTxts2.getTextHeight();
        int iSpaceY = Resources.resGFonts[0].getHeight();
        if (bEs) {
            iSpaceY -= Resources.resGFonts[0].getHeight() >> 2;
        }
        int iTotalHeight = iHeight + (iSpaceY << 1);
        int iY = this._rectText.getCenterY() - (iTotalHeight >> 1);
        int y = this.rectDialogInstr.y + (this.fontRed.getHeight() >> 2);
        if (MainCanvas.HEIGHT < 800) {
            iY = (y -= this.fontRed.getHeight() >> 2) + (this.fontRed.getHeight() << 1);
            if (MainCanvas.HEIGHT <= 640) {
                iY = y + this.fontRed.getHeight();
            }
        } else {
            iY += this.fontMain.getHeight() >> 1;
        }
        this.fontRed.drawString(g, Resources.resTexts[0].getHashedString(9).toCharArray(), this._rectText.getCenterX(), y, 17);
        if (MainCanvas.HEIGHT == 480 && MainCanvas.WIDTH == 360) {
            iY += this.fontMain.getHeight();
        } else if (MainCanvas.HEIGHT == 400 && MainCanvas.WIDTH == 240) {
            iY += this.fontMain.getHeight() << 1;
        }
        this.fontMain.drawString(g, (Resources.resTexts[0].getHashedString(8) + " " + (this.actualLevel + 1)).toCharArray(), this._rectText.getCenterX(), iY, 17);
        iY += Resources.resGFonts[0].getHeight();
        if (MainCanvas.HEIGHT == 480 && MainCanvas.WIDTH == 360) {
            iY += this.sprStarsActive.getHeight();
        }
        int yStarCenter = (iY += iSpaceY) - (this.fontMain.getHeight() >> 1) + (this.imgStarActive.getHeight() >> 1);
        int ySmallStar = yStarCenter + (this.imgStarActive.getHeight() >> 1) + (this.sprStarsActive.getHeight() >> 3) - this.sprStarsActive.getHeight();
        int offsetSmallStar = this.sprStarsActive.getWidth() >> 3;
        int _iTmpPositionX = this._rectText.getCenterX() - (this.imgStarActive.getWidth() >> 1);
        if (this.gameScore >= Level._iScoreHig) {
            this.sprStarsActive.setFrame(0);
            this.sprStarsActive.setPosition((MainCanvas.WIDTH >> 1) - this.sprStarsActive.getWidth() - (this.imgStarActive.getWidth() >> 1) + offsetSmallStar, ySmallStar);
            this.sprStarsActive.paint(g);
            g.drawImage(this.imgStarActive, MainCanvas.WIDTH >> 1, yStarCenter, 3);
            this.sprStarsActive.setFrame(1);
            this.sprStarsActive.setPosition((MainCanvas.WIDTH >> 1) + (this.imgStarActive.getWidth() >> 1) - offsetSmallStar, ySmallStar);
            this.sprStarsActive.paint(g);
        } else if (this.gameScore >= Level._iScoreMid) {
            this.sprStarsActive.setFrame(0);
            this.sprStarsActive.setPosition((MainCanvas.WIDTH >> 1) - this.sprStarsActive.getWidth() - (this.imgStarActive.getWidth() >> 1) + offsetSmallStar, ySmallStar);
            this.sprStarsActive.paint(g);
            g.drawImage(this.imgStarActive, MainCanvas.WIDTH >> 1, yStarCenter, 3);
            this.sprStarsInactive.setFrame(1);
            this.sprStarsInactive.setPosition((MainCanvas.WIDTH >> 1) + (this.imgStarActive.getWidth() >> 1) - offsetSmallStar, ySmallStar);
            this.sprStarsInactive.paint(g);
        } else if (this.gameScore >= Level._iScoreMin) {
            this.sprStarsActive.setFrame(0);
            this.sprStarsActive.setPosition((MainCanvas.WIDTH >> 1) - this.sprStarsActive.getWidth() - (this.imgStarActive.getWidth() >> 1) + offsetSmallStar, ySmallStar);
            this.sprStarsActive.paint(g);
            g.drawImage(this.imgStarInactive, MainCanvas.WIDTH >> 1, yStarCenter, 3);
            this.sprStarsInactive.setFrame(1);
            this.sprStarsInactive.setPosition((MainCanvas.WIDTH >> 1) + (this.imgStarActive.getWidth() >> 1) - offsetSmallStar, ySmallStar);
            this.sprStarsInactive.paint(g);
        }
        iY += this.imgStarActive.getHeight() >> 1;
        if (MainCanvas.HEIGHT == 480 && MainCanvas.WIDTH == 360) {
            iY += this.sprStarsActive.getHeight();
        }
        iY += iSpaceY;
        if (MainCanvas.HEIGHT < 800) {
            iY += this.fontRed.getHeight();
        }
        for (int i = 0; i < this._ptGameTxts2.getTextLines(); ++i) {
            Resources.resGFonts[0].drawString(g, this._ptGameTxts2.getText(i).toCharArray(), this._rectText.getCenterX(), iY, 17);
            iY += Resources.resGFonts[0].getHeight();
        }
    }

    private void paintLoseTxt(Graphics g) {
        int iSpace = Resources.resGFonts[0].getHeight();
        this._ptGameTxts.prepareText(Resources.resTexts[0].getHashedString(60), this._rectText.width - iSpace);
        String _sTmpFinal = "";
        switch (RMSObjects.game.getLoseMode()) {
            case 1: {
                _sTmpFinal = _sTmpFinal + Resources.resTexts[0].getHashedString(63);
                break;
            }
            case 3: {
                _sTmpFinal = _sTmpFinal + Resources.resTexts[0].getHashedString(64);
                break;
            }
            case 4: {
                _sTmpFinal = _sTmpFinal + Resources.resTexts[0].getHashedString(62);
                break;
            }
            case 2: {
                _sTmpFinal = _sTmpFinal + Resources.resTexts[0].getHashedString(61);
                break;
            }
            default: {
                _sTmpFinal = _sTmpFinal + Resources.resTexts[0].getHashedString(61);
            }
        }
        _sTmpFinal = _sTmpFinal + "\n" + Resources.resTexts[0].getHashedString(52);
        _sTmpFinal = _sTmpFinal + "\n\nTOTAL: " + this.gameScore;
        this._ptGameTxts2.prepareText(_sTmpFinal, this._rectText.width);
        int iHeight = this._ptGameTxts.getTextHeight() + this._ptGameTxts2.getTextHeight();
        int iSpaceY = Resources.resGFonts[0].getHeight() << 1;
        int iTotalHeight = iHeight + iSpaceY;
        int iY = this._rectText.getCenterY() - (iTotalHeight >> 1);
        int y = this.rectDialogInstr.y + (this.fontRed.getHeight() >> 2);
        if (MainCanvas.HEIGHT < 800) {
            y -= this.fontRed.getHeight() >> 2;
        }
        this.fontRed.drawString(g, Resources.resTexts[0].getHashedString(79).toCharArray(), this._rectText.getCenterX(), y, 17);
        this.fontMain.drawString(g, (Resources.resTexts[0].getHashedString(8) + " " + (this.actualLevel + 1)).toCharArray(), this._rectText.getCenterX(), iY += this.fontMain.getHeight() >> 1, 17);
        iY += iSpaceY;
        for (int i = 0; i < this._ptGameTxts2.getTextLines(); ++i) {
            Resources.resGFonts[0].drawString(g, this._ptGameTxts2.getText(i).toCharArray(), this._rectText.getCenterX(), iY, 17);
            iY += Resources.resGFonts[0].getHeight();
        }
    }

    private void paintFK(Graphics g) {
        if (this._iStatus == 0) {
            this.paintRightFK(Common.SMALL_PAUSE, 0, g, this.sprSmallIcons);
        } else if (this._iStatus == 2) {
            if (RMSObjects.game.isGameOver()) {
                this.paintLeftFK(Common.MIDDLE_PREV, 0, g, this.sprMediumIcons1);
                this.paintMiddleBtn(Common.BIG_RESTART, g, this.sprBigIcons);
            } else if (RMSObjects.game.isLevelDone()) {
                this.paintLeftFK(Common.MIDDLE_PREV, 0, g, this.sprMediumIcons1);
                if (this.actualLevel < 79) {
                    this.paintMiddleBtn(Common.BIG_START, g, this.sprBigIcons);
                }
                this.paintRightFK(Common.MIDDLE_RESTART, 0, g, this.sprMediumIcons1);
            }
        } else if (this._iStatus == 3) {
            this.paintRightFK(Common.SMALL_ARROW, 0, g, this.sprSmallIcons);
        } else if (this._iStatus == 1) {
            this.paintRightFK(Common.SMALL_ARROW, 0, g, this.sprSmallIcons);
        } else if (this._iStatus == 4) {
            this.paintLeftFK(Common.MIDDLE_YES, 0, g, this.sprMediumIcons2);
        } else if (this._iStatus == 5) {
            this.paintLeftFK(Common.MIDDLE_YES, 0, g, this.sprMediumIcons2);
        } else if (this._iStatus == 7) {
            this.paintRightFK(Common.MIDDLE_PREV, 0, g, this.sprMediumIcons1);
        } else if (this._iStatus == 6) {
            this.paintLeftFK(Common.MIDDLE_YES, 0, g, this.sprMediumIcons2);
            this.paintRightFK(Common.MIDDLE_NO, 0, g, this.sprMediumIcons2);
        } else if (this._iStatus == 8) {
            this.paintLeftFK(Common.MIDDLE_YES, 0, g, this.sprMediumIcons2);
            this.paintRightFK(Common.MIDDLE_NO, 0, g, this.sprMediumIcons2);
        }
    }

    private void paintLeftFK(int frame, int transform, Graphics g, Sprite sprite) {
        if (this._iStatus == 2 && (RMSObjects.game.isGameOver() || RMSObjects.game.isLevelDone())) {
            g.drawImage(this.imgMiddleButton, this._rectItems[0].getRight(), this.rectDialogInstr.getBottom() - (this.imgMiddleButton.getHeight() >> 2), 24);
            sprite.setFrame(frame);
            sprite.setTransform(transform);
            sprite.setPosition(this._rectItems[0].getRight() - (this.imgMiddleButton.getWidth() >> 1) - (sprite.getWidth() >> 1), this.rectDialogInstr.getBottom() + (this.imgMiddleButton.getHeight() >> 2) - (sprite.getHeight() >> 1));
            sprite.paint(g);
            return;
        }
        if (this._iStatus == 8 || this._iStatus == 5 || this._iStatus == 4 || this._iStatus == 6) {
            g.drawImage(this.imgMiddleButton, this._rectItems[0].getCenterX(), this._rectItems[0].getCenterY(), 3);
        } else {
            g.drawImage(this.imgSmallButton, this._rectItems[0].getCenterX(), this._rectItems[0].getCenterY(), 3);
        }
        sprite.setFrame(frame);
        sprite.setTransform(transform);
        sprite.setPosition(this._rectItems[0].getCenterX() - (sprite.getWidth() >> 1), this._rectItems[0].getCenterY() - (sprite.getHeight() >> 1));
        sprite.paint(g);
    }

    private void paintRightFK(int frame, int transform, Graphics g, Sprite sprite) {
        if (this._iStatus == 2 && (RMSObjects.game.isGameOver() || RMSObjects.game.isLevelDone())) {
            g.drawImage(this.imgMiddleButton, this._rectItems[4].x, this.rectDialogInstr.getBottom() - (this.imgMiddleButton.getHeight() >> 2), 20);
            sprite.setFrame(frame);
            sprite.setTransform(transform);
            sprite.setPosition(this._rectItems[4].x + (this.imgMiddleButton.getWidth() >> 1) - (sprite.getWidth() >> 1), this.rectDialogInstr.getBottom() + (this.imgMiddleButton.getHeight() >> 2) - (sprite.getHeight() >> 1));
            sprite.paint(g);
            return;
        }
        if (this._iStatus != 8 && this._iStatus != 6) {
            g.drawImage(this.imgSmallButton, this.rectFK.getCenterX(), this.rectFK.getCenterY(), 3);
            sprite.setFrame(frame);
            sprite.setTransform(transform);
            sprite.setPosition(this.rectFK.getCenterX() - (sprite.getWidth() >> 1), this.rectFK.getCenterY() - (sprite.getHeight() >> 1));
            sprite.paint(g);
            return;
        }
        g.drawImage(this.imgMiddleButton, this._rectItems[4].getCenterX(), this._rectItems[4].getCenterY(), 3);
        sprite.setFrame(frame);
        sprite.setTransform(transform);
        sprite.setPosition(this._rectItems[4].getCenterX() - (sprite.getWidth() >> 1), this._rectItems[4].getCenterY() - (sprite.getHeight() >> 1));
        sprite.paint(g);
    }

    private int getTopScore() {
        if (!this._bBonusPack) {
            Vector scores = RMSObjects.localScores.getScoresForGame(0);
            int scoresCount = 0;
            if (scores != null) {
                scoresCount = scores.size();
            }
            PowV2ScoreItem scoreItem = null;
            if (scoresCount > 0) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(0);
                return scoreItem.scoreValue;
            }
            return 0;
        }
        Vector scores = RMSObjects.localScoresBonus.getScoresForGame(0);
        int scoresCount = 0;
        if (scores != null) {
            scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            return scoreItem.scoreValue;
        }
        return 0;
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        switch (this._iStatus) {
            case 5: {
                if (Keys.isActionGeneratedByKey(1, keyCode) || Keys.isActionGeneratedByKey(2, keyCode)) {
                    return;
                }
                if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 0);
                break;
            }
            case 8: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.startAnimation(true, 1);
                }
                if (!Keys.isFKLeftCode(keyCode)) break;
                this.startMenuScreen();
                break;
            }
            case 4: {
                if (Keys.isActionGeneratedByKey(1, keyCode) || Keys.isActionGeneratedByKey(2, keyCode)) {
                    return;
                }
                if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionGeneratedByKey(5, keyCode)) break;
                if (MainCanvas.controlsTut == 0) {
                    this.startAnimation(true, 4);
                    ++MainCanvas.controlsTut;
                    break;
                }
                if (MainCanvas.controlsTut != 1) break;
                this.startAnimation(true, 5);
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.setGameMenuStatus();
                    break;
                }
                if (Keys.isFKLeftCode(keyCode)) {
                    RMSObjects.game.showHint();
                    break;
                }
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    RMSObjects.game.moveLeft();
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    RMSObjects.game.moveRight();
                    break;
                }
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    RMSObjects.game.moveUp();
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    RMSObjects.game.moveDown();
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                Game.pressed = true;
                RMSObjects.game.DragOrDrop();
                break;
            }
            case 1: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                this.keyReleasedMenuGame(keyCode);
                break;
            }
            case 2: {
                this.keyReleasedResult(keyCode);
                break;
            }
            case 3: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55 || !Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                this._iTextOffsetY = 0;
                this._bScrollUP = false;
                this._bScrollDOWN = true;
                this._iSelectedCompId = 1;
                break;
            }
            case 6: {
                if (Keys.isFKLeftCode(keyCode)) {
                    if (!this._bBonusPack) {
                        Level.getLevel(this.actualLevel);
                    } else {
                        Level.getBonusLevel(this.actualLevel);
                    }
                    MainCanvas.moveCounter = 0;
                    if (this._iGameMode == 4 || this._iGameMode == 5) {
                        RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                    } else {
                        RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                    }
                    this.startAnimation(true, 0);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
            }
        }
        this.mainCanvas.repaint();
    }

    private void setGameMenuStatus() {
        int rmsConnectId = this.getRMSConnectIdByGameType(0);
        if (!RMSObjects.rmsConnects[rmsConnectId].isExist()) {
            RMSObjects.rmsConnects[rmsConnectId].create();
        }
        RMSObjects.rmsConnects[rmsConnectId].save();
        this.startAnimation(true, 1);
        this._iSelectedCompId = 5;
        this._iSelectedCompId = 5;
    }

    private void keyReleasedMenuGame(int keyCode) {
        switch (this._iSelectedCompId) {
            case 5: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 1;
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    this._iSelectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    this._iSelectedCompId = 1;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 1;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 6);
                this.mainCanvas.repaint();
                break;
            }
            case 3: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    this._iSelectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    this._iSelectedCompId = 1;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                break;
            }
            case 1: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    this._iSelectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    this._iSelectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 3);
                break;
            }
            case 6: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    this._iSelectedCompId = 1;
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    this._iSelectedCompId = 1;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 8);
            }
        }
        if (Keys.isFKRightCode(keyCode)) {
            this.startAnimation(true, 0);
        }
    }

    private void keyReleasedResult(int keyCode) {
        if (RMSObjects.game.isGameOver()) {
            if (!Keys.isFKRightCode(keyCode)) {
                if (Keys.isFKLeftCode(keyCode)) {
                    this.stars = "";
                    this.startSelectLevel();
                    if (!this._bBonusPack) {
                        if (MainCanvas.slcLvl < 59) {
                            if (MainCanvas.counterX < 3) {
                                ++MainCanvas.counterX;
                                ++MainCanvas.slcLvl;
                            } else {
                                if (MainCanvas.slcLvl == 19) {
                                    ++MainCanvas.slcPack;
                                    MainCanvas.counterY = 0;
                                } else if (MainCanvas.slcLvl == 39) {
                                    MainCanvas.counterY = 0;
                                    ++MainCanvas.slcPack;
                                } else {
                                    ++MainCanvas.counterY;
                                }
                                MainCanvas.counterX = 0;
                                ++MainCanvas.slcLvl;
                            }
                        }
                    } else if (MainCanvas.slcLvl < 19) {
                        if (MainCanvas.counterX < 3) {
                            ++MainCanvas.counterX;
                            ++MainCanvas.slcLvl;
                        } else {
                            MainCanvas.counterX = 0;
                            ++MainCanvas.counterY;
                            ++MainCanvas.slcLvl;
                        }
                    }
                    this.startAnimation(true, 9);
                } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                    this.stars = "";
                    if (!this._bBonusPack) {
                        Level.getLevel(this.actualLevel);
                    } else {
                        Level.getBonusLevel(this.actualLevel);
                    }
                    MainCanvas.moveCounter = 0;
                    if (this._iGameMode == 4 || this._iGameMode == 5) {
                        this.startAnimation(true, 5);
                        RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                    } else {
                        this.startAnimation(true, 5);
                        if (!this._bBonusPack) {
                            Level.getLevel(this.actualLevel);
                        } else {
                            Level.getBonusLevel(this.actualLevel);
                        }
                        RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                    }
                    this.mainCanvas.getSoundManager().Stop();
                    this._iSelectedCompId = 0;
                }
            }
        } else if (RMSObjects.game.isLevelDone()) {
            if (Keys.isFKLeftCode(keyCode)) {
                this.stars = "";
                this.addScoreToTable();
                this.startSelectLevel();
                if (!this._bBonusPack) {
                    if (MainCanvas.slcLvl < 59) {
                        if (MainCanvas.counterX < 3) {
                            ++MainCanvas.counterX;
                            ++MainCanvas.slcLvl;
                        } else {
                            if (MainCanvas.slcLvl == 19) {
                                ++MainCanvas.slcPack;
                                MainCanvas.counterY = 0;
                            } else if (MainCanvas.slcLvl == 39) {
                                MainCanvas.counterY = 0;
                                ++MainCanvas.slcPack;
                            } else {
                                ++MainCanvas.counterY;
                            }
                            MainCanvas.counterX = 0;
                            ++MainCanvas.slcLvl;
                        }
                    }
                } else if (MainCanvas.slcLvl < 19) {
                    if (MainCanvas.counterX < 3) {
                        ++MainCanvas.counterX;
                        ++MainCanvas.slcLvl;
                    } else {
                        MainCanvas.counterX = 0;
                        ++MainCanvas.counterY;
                        ++MainCanvas.slcLvl;
                    }
                }
                this.startAnimation(true, 9);
            } else if (Keys.isFKRightCode(keyCode)) {
                this.stars = "";
                if (!this._bBonusPack) {
                    Level.getLevel(this.actualLevel);
                } else {
                    Level.getBonusLevel(this.actualLevel);
                }
                MainCanvas.moveCounter = 0;
                if (this._iGameMode == 4 || this._iGameMode == 5) {
                    this.startAnimation(true, 5);
                    RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                } else {
                    this.startAnimation(true, 5);
                    if (!this._bBonusPack) {
                        Level.getLevel(this.actualLevel);
                    } else {
                        Level.getBonusLevel(this.actualLevel);
                    }
                    RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                }
                this.mainCanvas.getSoundManager().Stop();
                this._iSelectedCompId = 0;
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                if (this.actualLevel < 79) {
                    this.stars = "";
                    this.addScoreToTable();
                    ++this.actualLevel;
                    MainCanvas.slcLvl = this.actualLevel;
                    Level.getLevel(this.actualLevel);
                    this._iGameMode = Level._iGameMode;
                    MainCanvas.moveCounter = 0;
                    this.lvl = this._iGameMode == Level.TYPE_BLOCKER || this._iGameMode == Level.TYPE_MIXED_TIME_AND_BLOCKS ? Level._iBlockScheme : 1;
                    this.startAnimation(true, 5);
                    RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                    this.mainCanvas.getSoundManager().Stop();
                }
                this._iSelectedCompId = 0;
            } else if (Keys.isKeyPressed(53)) {
                System.out.println("dalsi level");
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this._iStatus == 0 && this._rectGameArea.contains(x, y)) {
            Game.bhint = false;
            RMSObjects.game.pointerPressed(x, y);
            return;
        }
        if (this._iStatus == 3) {
            if (this._rectText.contains(x, y)) {
                MainCanvas.lastPointerPressedY = y;
                this.bDragInstructions = true;
                return;
            }
            if (this._rectItems[7].contains(x, y)) {
                this._iSelectedCompId = 7;
                Keys.keyPressed(50);
                return;
            }
            if (this._rectItems[8].contains(x, y)) {
                this._iSelectedCompId = 8;
                Keys.keyPressed(56);
                return;
            }
        }
        block6: for (int i = 0; i < this._rectItems.length; ++i) {
            if (!this.existComponentInState(i, this._iStatus) || !this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 0: {
                    if (this._iStatus != 1) {
                        Keys.keyPressed(-6);
                        continue block6;
                    }
                    Keys.keyPressed(-6);
                    continue block6;
                }
                case 4: {
                    if (this._iStatus == 3) {
                        this.startAnimation(true, 1);
                        this._iTextOffsetY = 0;
                        this._bScrollUP = false;
                        this._bScrollDOWN = true;
                        this.mainCanvas.repaint();
                        continue block6;
                    }
                    Keys.keyPressed(-7);
                    continue block6;
                }
                case 3: {
                    this.mainCanvas.repaint();
                    continue block6;
                }
                case 9: {
                    if (this._iStatus != 2) continue block6;
                    Keys.keyPressed(53);
                    continue block6;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                }
            }
        }
    }

    private boolean existComponentInState(int i, int _iStatus) {
        if (_iStatus == 0) {
            if (i == 4) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (_iStatus == 8) {
            if (i == 4) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (_iStatus == 1) {
            if (i == 0) {
                return true;
            }
            if (i == 4) {
                return true;
            }
            if (i == 5) {
                return true;
            }
            if (i == 3) {
                return true;
            }
            if (i == 1) {
                return true;
            }
            if (i == 6) {
                return true;
            }
        } else if (_iStatus == 3) {
            if (i == 4) {
                return true;
            }
        } else if (_iStatus == 2) {
            if (i == 4) {
                return true;
            }
            if (i == 0) {
                return true;
            }
            if (i == 9) {
                return true;
            }
        } else if (_iStatus == 6) {
            if (i == 4) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (_iStatus == 3 ? i == 4 : (_iStatus == 5 ? i == 0 : _iStatus == 4 && i == 0)) {
            return true;
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        if (this._iStatus == 0) {
            if (this._rectGameArea.contains(x, y)) {
                RMSObjects.game.pointerPressed(x, y);
            }
            return;
        }
        if (this._iStatus == 3 && this.bDragInstructions) {
            int iTextShiftY;
            if (!this._rectText.contains(x, y)) {
                this.bDragInstructions = false;
            }
            if ((iTextShiftY = MainCanvas.lastPointerPressedY - y) > 0) {
                this.dragDown();
            } else if (iTextShiftY < 0) {
                this.dragUp();
            }
            MainCanvas.lastPointerPressedY = y;
        }
        if (!this._rectItems[this._iSelectedCompId].contains(x, y)) {
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyReleased(-6);
                    break;
                }
                case 4: {
                    if (this._iStatus == 3) {
                        this.startAnimation(true, 1);
                        this._iTextOffsetY = 0;
                        this._bScrollUP = false;
                        this._bScrollDOWN = true;
                        break;
                    }
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                    if (this._iStatus != 1) break;
                    this.mainCanvas.repaint();
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this._iStatus == 0) {
            Game.pressed = true;
        }
        if (this._iStatus == 3) {
            if (this.bDragInstructions) {
                this.bDragInstructions = false;
            }
            switch (this._iSelectedCompId) {
                case 7: {
                    if (!Keys.isKeyPressed(50)) break;
                    this.keyReleased(50);
                    Keys.keyReleased(50);
                    break;
                }
                case 8: {
                    if (!Keys.isKeyPressed(56)) break;
                    this.keyReleased(56);
                    Keys.keyReleased(56);
                    break;
                }
            }
        }
        switch (this._iSelectedCompId) {
            case 0: {
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                break;
            }
            case 4: {
                if (this._iStatus == 3) {
                    this.startAnimation(true, 1);
                    this._iTextOffsetY = 0;
                    this._bScrollUP = false;
                    this._bScrollDOWN = true;
                    break;
                }
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            default: {
                if (Keys.isKeyPressed(53)) {
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
                if (this._iStatus != 1) break;
                this._iSelectedCompId = 1;
                this.mainCanvas.repaint();
            }
        }
    }

    public void textMove() {
        this._bNeedRepaint = false;
        if (this._ptInstructions.getTextHeight() < this._rectText.height) {
            return;
        }
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            } else {
                this._iTextOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            }
            if (this._iTextOffsetY < 0) {
                this._iTextOffsetY = 0;
                this._bScrollUP = false;
                this._bScrollDOWN = true;
            }
            this._bNeedRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = this._ptInstructions.getTextHeight() - this._rectText.height;
            if (Resources.sysFont) {
                this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            } else {
                this._iTextOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            }
            if (this._iTextOffsetY > maxOffsetY) {
                this._iTextOffsetY = maxOffsetY;
                this._bScrollUP = true;
                this._bScrollDOWN = false;
            }
            this._bNeedRepaint = true;
        }
        if (this._bNeedRepaint) {
            this.mainCanvas.repaint();
        }
    }

    public void dragUp() {
        if (this._ptInstructions.getTextHeight() < this._rectText.height) {
            return;
        }
        if (Resources.sysFont) {
            this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        } else {
            this._iTextOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        }
        if (this._iTextOffsetY < 0) {
            this._iTextOffsetY = 0;
            this._bScrollUP = false;
            this._bScrollDOWN = true;
        }
        this._bNeedRepaint = true;
        this.mainCanvas.repaint();
    }

    public void dragDown() {
        if (this._ptInstructions.getTextHeight() < this._rectText.height) {
            return;
        }
        int maxOffsetY = this._ptInstructions.getTextHeight() - this._rectText.height;
        if (Resources.sysFont) {
            this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        } else {
            this._iTextOffsetY += Resources.resGFonts[0].getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        }
        if (this._iTextOffsetY > maxOffsetY) {
            this._iTextOffsetY = maxOffsetY;
            this._bScrollUP = true;
            this._bScrollDOWN = false;
        }
        this._bNeedRepaint = true;
        this.mainCanvas.repaint();
    }

    private void paintMiddleBtn(int frame, Graphics g, Sprite sprite) {
        int yOffset = this.imgMiddleButton.getHeight() >> 2;
        if (MainCanvas.WIDTH == 240 && MainCanvas.HEIGHT == 320) {
            yOffset += this.imgMiddleButton.getHeight() >> 3;
        }
        g.drawImage(this.imgBigButton, this._rectItems[9].getCenterX(), this.rectDialogInstr.getBottom() - yOffset, 17);
        sprite.setFrame(frame);
        sprite.setPosition(this._rectItems[9].getCenterX() - (sprite.getWidth() >> 1), this.rectDialogInstr.getBottom() - yOffset + (this.imgBigButton.getHeight() >> 1) - (sprite.getHeight() >> 1));
        sprite.paint(g);
    }
}

