/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenAbout
implements IScreen {
    private MainCanvas mainCanvas;
    private static final int COMP_ID_BACK = 0;
    private static final int TOTAL_COMP_IDS = 1;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iSelectedCompId;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private int[] _animationSequence = new int[4];
    private boolean _bChangeSequence = false;
    private Rectangle[] _rectItems = new Rectangle[1];
    private Rectangle _rectDialog;
    private Rectangle rectScreen;
    private Rectangle rectBack;
    private Rectangle rectLogo;
    private Rectangle rectFK;
    private Image _imgBg;
    private Image imgLogo;
    private Image imgButtonSmall;
    private Sprite sprIcons;
    private PreparedText preparedTextAbout;
    private AnimationComponent[] _animationComponents = new AnimationComponent[4];
    public int _iInteruption = 0;
    public int _iCycle;
    public int _iMusicControler;

    public ScreenAbout(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
        this.initDimensions();
    }

    public void beforeShow() {
        this.rectScreen = new Rectangle(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this.loadResources();
        this.initSprites();
        this.initImages();
        this.initFonts();
        this.initBack();
        this.initLogo();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 3, 9});
        Resources.loadSprites(new int[]{40});
        Resources.loadGFont(2);
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2, 3, 9});
        Resources.freeSprites(new int[]{40});
        Resources.freeGFont(2);
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
    }

    private void initSprites() {
        this.sprIcons = Resources.resSprs[40];
    }

    private void initImages() {
        this._imgBg = Resources.resImgs[2];
        this.imgLogo = Resources.resImgs[3];
        this.imgButtonSmall = Resources.resImgs[9];
    }

    private void initFonts() {
        this.preparedTextAbout = new PreparedText(Resources.resGFonts[2]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0] = 0;
        this._animationSequence[1] = 1;
        this._animationSequence[2] = 2;
    }

    private void initAnimationComponents() {
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this._rectDialog, this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectFK, this._WIDTH, this._HEIGHT);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
    }

    private void showAnimationComponent() {
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
    }

    private void hideAnimationComponent() {
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(1);
    }

    private void freeGraphics() {
        this._imgBg = null;
        this.imgLogo = null;
        this.imgButtonSmall = null;
        this.sprIcons = null;
    }

    private void calculatePositions() {
        int _iBorder = this.rectScreen.width >> 3;
        int _iWidth = this.rectScreen.width - (this.rectScreen.width >> 2);
        this.preparedTextAbout.prepareText(X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + "\n" + X.singleton.getAppProperty("MIDlet-Version"), _iWidth - _iBorder);
        int _iHeight = (_iBorder << 1) + this.imgLogo.getHeight() + this.preparedTextAbout.getTextHeight();
        this._rectDialog = new Rectangle(_iBorder, this._HEIGHT - this.rectBack.height - _iHeight >> 1, _iWidth, _iHeight);
        this._rectItems[0] = new Rectangle(MainCanvas.WIDTH - (this.rectBack.width << 1), MainCanvas.HEIGHT - (this.rectBack.height << 1), this.rectBack.width << 1, this.rectBack.height << 1);
        int offset = this.imgButtonSmall.getWidth() >> 3;
        int xCenterFK = MainCanvas.WIDTH - (this.imgButtonSmall.getWidth() >> 1) - offset;
        int yCenterFK = MainCanvas.HEIGHT - (this.imgButtonSmall.getHeight() >> 1) - offset;
        this.rectFK = new Rectangle(xCenterFK - (this.imgButtonSmall.getWidth() >> 1), yCenterFK - (this.imgButtonSmall.getHeight() >> 1), this.imgButtonSmall.getWidth(), this.imgButtonSmall.getHeight());
    }

    public void beforeInteruption() {
        this.mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
        this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
    }

    public void update(long lastRunLenght) {
        this.updateSoundInterupt();
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void updateSoundInterupt() {
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        if (this._iSequence == this._iSequenceHide) {
            this._iSequence = this._iSequenceShow;
            this._bChangeSequence = true;
            this.mainCanvas.repaint();
            this.startNextScreen(this._iNextMode);
        } else if (this._iSequence == this._iSequenceShow) {
            this._iSequence = this._iSequenceStop;
            this.mainCanvas.repaint();
        }
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _nextMode) {
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 2));
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintBody(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.drawImage(this._imgBg, 0, 0, 20);
    }

    private void paintBody(Graphics g) {
        g.drawImage(this.imgLogo, this.rectLogo.getCenterX(), this.rectLogo.getCenterY(), 33);
        this.preparedTextAbout.drawText(g, this._rectDialog, this.preparedTextAbout.getTextHeight(), 33);
    }

    private void paintFK(Graphics g) {
        g.drawImage(this.imgButtonSmall, this.rectFK.getCenterX(), this.rectFK.getCenterY(), 3);
        this.sprIcons.setFrame(Common.SMALL_ARROW);
        this.sprIcons.setPosition(this.rectFK.getCenterX() - (this.sprIcons.getWidth() >> 1), this.rectFK.getCenterY() - (this.sprIcons.getHeight() >> 1));
        this.sprIcons.paint(g);
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        if (Keys.isFKRightCode(keyCode)) {
            this.startAnimation(true, 0);
            this.mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this._rectItems.length; ++i) {
            if (this._rectItems[i] == null || !this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyPressed(-7);
                    break;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this._rectItems[this._iSelectedCompId].contains(x, y)) {
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this._iSelectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            default: {
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }

    private void initBack() {
        int width = this.imgButtonSmall.getWidth();
        int height = this.imgButtonSmall.getHeight();
        int x = this.rectScreen.width - (width + (width >> 2));
        int y = this.rectScreen.height - (height + (height >> 2));
        this.rectBack = new Rectangle(x, y, width, height);
    }

    private void initLogo() {
        int width = this.imgLogo.getWidth();
        int height = this.imgLogo.getHeight();
        int x = this.rectScreen.getCenterX() - (width >> 1);
        int y = this.rectScreen.getCenterY() - (height >> 1);
        if (MainCanvas.HEIGHT < 300) {
            y += Resources.resGFonts[2].getHeight();
        }
        this.rectLogo = new Rectangle(x, y, width, height);
    }
}

