/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSplash
implements IScreen {
    private MainCanvas _mainCanvas;
    private static final int MODE_ENABLE_MUSIC_QUESTION = 0;
    private static final int MODE_COMPANY_LOGO = 1;
    private static final int MODE_SPLASH = 2;
    private static final int MODE_MENU = 3;
    private static final int MODE_TIME = 3000;
    private static final int _COMP_ID_YES = 0;
    private static final int _COMP_ID_NO = 1;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iMode;
    private int _iKcode;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode;
    private int _iInteruption = 0;
    private int[][] _animationSequence = new int[3][3];
    private long _iModeDelay;
    private boolean _bChangeSequence = false;
    private Rectangle[] _rectItems = new Rectangle[2];
    private Rectangle _rectDialog;
    private Rectangle rectScreen;
    private Rectangle rectNo;
    private Rectangle rectYes;
    private Rectangle rectWindow;
    private Image _imgBg;
    private Image imgLogo;
    private Image imgButton;
    private Image imgWindow;
    private Sprite sprMiddleIcons;
    private Sprite sprWindow;
    private PreparedText _ptTitle;
    private AnimationComponent[] _animationComponents = new AnimationComponent[3];

    public ScreenSplash(MainCanvas mC) {
        this._mainCanvas = mC;
        this._iMode = 1;
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this._iModeDelay = 3000L;
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.initBottomButtons();
        this.initWindow();
        this.prepareTxt();
        this.calculatePosition();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.startAnimation(true, 1);
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 3, 9, 10, 15});
        Resources.loadSprites(new int[]{42, 44});
        Resources.loadGFont(0);
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2, 3, 9, 10, 15});
        Resources.freeSprites(new int[]{42, 44});
        Resources.freeGFont(0);
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
        this.rectScreen = new Rectangle(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    private void initSprites() {
        this.sprMiddleIcons = Resources.resSprs[42];
        this.sprWindow = Resources.resSprs[44];
    }

    private void initImages() {
        this._imgBg = Resources.resImgs[2];
        this.imgLogo = Resources.resImgs[3];
        this.imgButton = Resources.resImgs[15];
        this.imgWindow = Resources.resImgs[10];
    }

    private void initFonts() {
        this._ptTitle = new PreparedText(Resources.resGFonts[0]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 0;
        this._animationSequence[0][1] = 1;
        this._animationSequence[0][2] = 2;
        this._animationSequence[1][0] = 0;
        this._animationSequence[1][1] = 1;
        this._animationSequence[1][2] = 2;
        this._animationSequence[2][0] = 0;
        this._animationSequence[2][1] = 2;
        this._animationSequence[2][2] = 1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this._mainCanvas, this.rectWindow, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this._mainCanvas, this.rectNo, this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this._mainCanvas, this.rectYes, this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(0);
        this._animationComponents[2].startHideAnimation(1);
    }

    private void prepareTxt() {
        System.out.println("" + Resources.resTexts[0].getHashedString(28));
        this._ptTitle.prepareText(Resources.resTexts[0].getHashedString(5), this._mainCanvas.getWidth());
    }

    private void freeGraphics() {
        this._imgBg = null;
        this.imgLogo = null;
        this.imgButton = null;
        this.sprMiddleIcons = null;
        this._ptTitle = null;
    }

    public void calculatePosition() {
        this._rectDialog = new Rectangle(this.sprMiddleIcons.getWidth(), 0, this._WIDTH - (this.sprMiddleIcons.getWidth() << 1), this._HEIGHT);
        this._rectItems[0] = new Rectangle(0, MainCanvas.HEIGHT - (this.imgButton.getHeight() << 1), this.imgButton.getWidth() << 1, this.imgButton.getHeight() << 1);
        this._rectItems[1] = new Rectangle(this._WIDTH - (this.imgButton.getWidth() << 1), MainCanvas.HEIGHT - (this.imgButton.getHeight() << 1), this.imgButton.getWidth() << 1, this.imgButton.getHeight() << 1);
        int _windowWidth = this._WIDTH >> 1;
        int _windowHeight = this._HEIGHT >> 1;
    }

    public void beforeInteruption() {
        if (this._iMode == 0) {
            this._mainCanvas.getSoundManager().Stop();
        }
        this._mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
        if (this._iMode == 0) {
            this._mainCanvas.getSoundManager().Stop();
        }
    }

    public void update(long lastRunLenght) {
        switch (this._iMode) {
            case 1: {
                if (this._iModeDelay > 0L) {
                    this._iModeDelay -= lastRunLenght;
                    break;
                }
                this._iModeDelay = 3000L;
                this.nextMode();
                break;
            }
            case 2: {
                if (this._iModeDelay > 0L) {
                    this._iModeDelay -= lastRunLenght;
                    break;
                }
                this._iModeDelay = 3000L;
                this.nextMode();
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(this._iKcode)) {
                    MainCanvas.music = false;
                    Settings.musicOn = false;
                    this._mainCanvas.getSoundManager().SetSoundOn(false);
                    break;
                }
                if (!Keys.isFKLeftCode(this._iKcode)) break;
                MainCanvas.music = false;
                Settings.musicOn = false;
                this._mainCanvas.getSoundManager().SetSoundOn(false);
            }
        }
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void nextMode() {
        switch (this._iMode) {
            case 0: {
                this.startAnimation(true, 1);
                this._mainCanvas.repaint();
                this._mainCanvas.serviceRepaints();
                break;
            }
            case 1: {
                this.startAnimation(true, 3);
                this._mainCanvas.repaint();
                this._mainCanvas.serviceRepaints();
                break;
            }
            case 2: {
                this.startAnimation(true, 3);
                this._mainCanvas.repaint();
                this._mainCanvas.serviceRepaints();
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        if (this._iSequence == this._iSequenceHide) {
            this._iSequence = this._iSequenceShow;
            this._iMode = this._iNextMode;
            this._bChangeSequence = true;
            this._mainCanvas.repaint();
            return;
        }
        if (this._iSequence == this._iSequenceShow) {
            this._iSequence = this._iSequenceStop;
            this._mainCanvas.repaint();
            return;
        }
        if (this._iNextMode == 3) {
            this.startMenuScreen();
            return;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                if (this._iNextMode == 3) {
                    this.startMenuScreen();
                }
                this._iSequence = this._iSequenceShow;
                this._iMode = this._iNextMode;
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startMenuScreen() {
        ScreenMenu sg = new ScreenMenu(this._mainCanvas, 0);
        this._mainCanvas.changeLastActiveScreen(sg);
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this._iMode) {
            case 0: {
                this.paintMusic(g);
                break;
            }
            case 1: {
                this.paintCorpLogo(g);
                break;
            }
        }
    }

    private void paintBackground(Graphics g) {
        g.drawImage(this._imgBg, 0, 0, 20);
    }

    private void paintMusic(Graphics g) {
        this.paintMusicBody(g);
        this.paintMusicFk(g);
    }

    private void paintCorpLogo(Graphics g) {
        g.drawImage(this.imgLogo, this.rectWindow.getCenterX(), this.rectWindow.getCenterY(), 3);
    }

    private void paintMusicBody(Graphics g) {
        this.paintWindow(g, false);
        this.paintMusicImg(g);
    }

    private void paintMusicImg(Graphics g) {
        int iLinesCount = this._ptTitle.getTextLines();
        int iY = this.rectWindow.getCenterY() - (this._ptTitle.getTextHeight() >> 1);
        for (int i = 0; i < iLinesCount; ++i) {
            Resources.resGFonts[0].drawString(g, this._ptTitle.getText(i).toCharArray(), this.rectWindow.getCenterX(), iY, 17);
            iY += Resources.resGFonts[0].getHeight();
        }
    }

    private void paintMusicFk(Graphics g) {
        g.drawImage(this.imgButton, this.rectYes.getCenterX(), this.rectYes.getCenterY(), 3);
        this.sprMiddleIcons.setFrame(Common.MIDDLE_YES);
        this.sprMiddleIcons.setPosition(this.rectYes.getCenterX() - (this.sprMiddleIcons.getWidth() >> 1), this.rectYes.getCenterY() - (this.sprMiddleIcons.getHeight() >> 1));
        this.sprMiddleIcons.paint(g);
        g.drawImage(this.imgButton, this.rectNo.getCenterX(), this.rectNo.getCenterY(), 3);
        this.sprMiddleIcons.setFrame(Common.MIDDLE_NO);
        this.sprMiddleIcons.setPosition(this.rectNo.getCenterX() - (this.sprMiddleIcons.getWidth() >> 1), this.rectNo.getCenterY() - (this.sprMiddleIcons.getHeight() >> 1));
        this.sprMiddleIcons.paint(g);
    }

    private void paintWindow(Graphics g, boolean bBig) {
        if (MainCanvas.WIDTH > 400 && MainCanvas.HEIGHT > 640) {
            g.drawImage(this.imgWindow, this.rectWindow.getCenterX(), this.rectWindow.getCenterY(), 3);
        } else {
            int rows = 4;
            int cols = 5;
            int y = (MainCanvas.HEIGHT >> 1) - (this.sprWindow.getHeight() << 1);
            int frame = 0;
            int row = 0;
            while (row < rows) {
                int x = (MainCanvas.WIDTH >> 1) - (this.sprWindow.getWidth() << 1) - (this.sprWindow.getWidth() >> 1);
                frame = row == 0 ? 0 : (row == 3 ? 6 : 3);
                this.sprWindow.setFrame(frame);
                this.sprWindow.setPosition(x, y);
                this.sprWindow.paint(g);
                x += this.sprWindow.getWidth();
                int col = 1;
                while (col < cols - 1) {
                    frame = row == 0 ? 1 : (row == 3 ? 7 : 4);
                    this.sprWindow.setFrame(frame);
                    this.sprWindow.setPosition(x, y);
                    this.sprWindow.paint(g);
                    ++col;
                    x += this.sprWindow.getWidth();
                }
                frame = row == 0 ? 2 : (row == 3 ? 8 : 5);
                this.sprWindow.setFrame(frame);
                this.sprWindow.setPosition(x, y);
                this.sprWindow.paint(g);
                ++row;
                y += this.sprWindow.getHeight();
            }
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        switch (this._iMode) {
            case 0: {
                if (Keys.isFKLeftCode(keyCode)) {
                    this._iKcode = keyCode;
                    Settings.musicOn = true;
                    this._mainCanvas.getSoundManager().SetSoundOn(true);
                    this.nextMode();
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this._iKcode = keyCode;
                Settings.musicOn = false;
                this._mainCanvas.getSoundManager().SetSoundOn(false);
                this.nextMode();
                break;
            }
            case 1: 
            case 2: {
                if (this._iModeDelay >= 3000L || !Keys.isActionGeneratedByKey(5, keyCode) || this._iModeDelay <= 100L) break;
                this._iModeDelay = 3000L;
                this.nextMode();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        switch (this._iMode) {
            case 0: {
                for (int i = 0; i < this._rectItems.length; ++i) {
                    if (!this._rectItems[i].contains(x, y)) continue;
                    if (i == 0) {
                        Settings.musicOn = true;
                        MainCanvas.music = true;
                        this._mainCanvas.getSoundManager().SetSoundOn(true);
                        this.nextMode();
                        continue;
                    }
                    if (i != 1) continue;
                    Settings.musicOn = false;
                    this._mainCanvas.getSoundManager().SetSoundOn(false);
                    this.nextMode();
                    MainCanvas.music = false;
                }
                break;
            }
            case 1: 
            case 2: {
                if (this._iModeDelay >= 3000L) break;
                Keys.keyPressed(53);
            }
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        switch (this._iMode) {
            case 0: {
                for (int i = 0; i < this._rectItems.length; ++i) {
                    if (!this._rectItems[i].contains(x, y)) continue;
                    if (i == 0) {
                        Settings.musicOn = true;
                        MainCanvas.music = true;
                        this._mainCanvas.getSoundManager().SetSoundOn(true);
                        this.nextMode();
                        continue;
                    }
                    if (i != 1) continue;
                    Settings.musicOn = false;
                    this._mainCanvas.getSoundManager().SetSoundOn(false);
                    this.nextMode();
                    MainCanvas.music = false;
                }
                break;
            }
            case 1: 
            case 2: {
                if (this._iModeDelay >= 3000L || !Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }

    private void initBottomButtons() {
        int width = this.imgButton.getWidth();
        int height = this.imgButton.getHeight();
        int x = width >> 2;
        int y = this.rectScreen.height - (height + (height >> 2));
        this.rectYes = new Rectangle(x, y, width, height);
        x = this.rectScreen.width - (width + (width >> 2));
        this.rectNo = new Rectangle(x, y, width, height);
    }

    private void initWindow() {
        int width = this.imgWindow.getWidth();
        int height = this.imgWindow.getHeight();
        int x = (this.rectScreen.width >> 1) - (width >> 1);
        int y = (this.rectScreen.height >> 1) - (height >> 1);
        this.rectWindow = new Rectangle(x, y, width, height);
    }
}

