/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Common;
import sk.inlogic.Level;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenGame;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSelectLevel
implements IScreen {
    MainCanvas mainCanvas;
    long modeDelay;
    private static final int COMP_ID_BACK = 0;
    private static final int COMP_ID_ARR_UP = 1;
    private static final int COMP_ID_ARR_DOWN = 2;
    private static final int COMP_ID_ALLLEVELS = 3;
    private static final int TOTAL_COMP_IDS = 4;
    private Rectangle[] _rectItems = new Rectangle[4];
    private Rectangle[] _rectLevel = new Rectangle[16];
    private Rectangle _rSelectedLevel;
    private Rectangle _rectLevelBody;
    private Rectangle rectFK;
    int mode;
    private int _iNextModePack1 = 0;
    private int _iNextModePack2 = 1;
    private int _iNextModePack3 = 2;
    private int _iNextModePack4 = 3;
    private int _iNextModePack5 = 4;
    private int _iNextModeMenu = 5;
    private int _iNextModeGame = 6;
    private int _iSelectedCompId;
    private int _iGameMode;
    private Rectangle rectTop;
    private Rectangle rectDown;
    private int dy = 0;
    private int _iSelectorDx = 0;
    private int _iSelectorDy = 0;
    private int _iCounterX = 0;
    private int _iCounterY = 0;
    private int scoresCount = 0;
    private int count = 0;
    private int x = 0;
    private int y = 0;
    private int interuption = 0;
    private int selectedPack = 0;
    private int selectdLevel = 0;
    private int levelNumber = 0;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private String[] levelStars = new String[80];
    private String[] levelnames = new String[80];
    private int _iOffsetLevelX = 0;
    private int _iOffsetLevelY = 0;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private boolean _bChangeSequence = false;
    private Image _imgBg;
    private Image imgButtonSmall;
    private Image imgArrowUp;
    private Image imgArrowDown;
    private Sprite _sprLevel;
    private Sprite _sprLevelSelector;
    private Sprite _sprLevelLock;
    private Sprite _sprLevelStar;
    private Sprite sprSmallIcons;
    private Sprite sprLevelStarActive;
    private Sprite sprLevelStarInactive;
    private PreparedText _ptLevelNum;
    private PreparedText _prLevelStars;
    private int[] _animationSequence = new int[4];
    private AnimationComponent[] _animationComponents = new AnimationComponent[4];
    private boolean _bShitDevice = false;
    public boolean animatedMenu = false;
    private int cycle = 10;

    public ScreenSelectLevel(MainCanvas mC, int selectedLevel) {
        System.out.println("screen select level");
        this.mainCanvas = mC;
        this._iCounterX = MainCanvas.slcLvl % 4;
        this._iCounterY = MainCanvas.slcLvl / 4 % 4;
        MainCanvas.counterX = this._iCounterX;
        MainCanvas.counterY = this._iCounterY;
        this.selectedPack = MainCanvas.slcLvl / 16;
        MainCanvas.slcPack = this.selectedPack;
        this.selectdLevel = MainCanvas.slcLvl;
        MainCanvas.totalStars = 0;
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.prepareTxt();
        this.prepareLevelStars();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.startAnimation(true, -1);
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 9, 13, 12});
        Resources.loadSprites(new int[]{24, 7, 6, 9, 40, 45, 46});
        Resources.loadGFonts(new int[]{0});
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2, 9, 13, 12});
        Resources.freeSprites(new int[]{24, 7, 6, 9, 40, 45, 46});
        Resources.freeGFonts(new int[]{0});
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
        if (this._WIDTH == 176 && this._HEIGHT == 208) {
            this._bShitDevice = true;
        }
        if (this._WIDTH == 176 && this._HEIGHT == 220) {
            this._bShitDevice = true;
        }
        this._bShitDevice = this._WIDTH == 208 && this._HEIGHT == 208;
    }

    private void initImages() {
        this._imgBg = Resources.resImgs[2];
        this.imgButtonSmall = Resources.resImgs[9];
        this.imgArrowDown = Resources.resImgs[13];
        this.imgArrowUp = Resources.resImgs[12];
    }

    private void initSprites() {
        this._sprLevel = Resources.resSprs[24];
        this._sprLevelSelector = Resources.resSprs[7];
        this._sprLevelLock = Resources.resSprs[6];
        this._sprLevelStar = Resources.resSprs[9];
        this.sprSmallIcons = Resources.resSprs[40];
        this.sprLevelStarActive = Resources.resSprs[45];
        this.sprLevelStarInactive = Resources.resSprs[46];
    }

    private void initFonts() {
        this._ptLevelNum = new PreparedText(Resources.resGFonts[0]);
        this._prLevelStars = new PreparedText(Resources.resGFonts[0]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0] = 0;
        this._animationSequence[1] = 1;
        this._animationSequence[2] = 2;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this._rectLevelBody, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectDown, this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectFK, this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectTop, this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(2);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(2);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(1);
        this._animationComponents[3].startHideAnimation(2);
    }

    private void prepareTxt() {
        this._ptLevelNum.prepareText("1", this._sprLevel.getWidth());
    }

    private void freeGraphics() {
        this._imgBg = null;
        this._sprLevel = null;
        this._sprLevelSelector = null;
        this._sprLevelLock = null;
        this._sprLevelStar = null;
        this._ptLevelNum = null;
        this._prLevelStars = null;
    }

    private void prepareLevelStars() {
        Vector scores;
        for (int i = 0; i < 80; ++i) {
            this.levelStars[i] = null;
            this.levelnames[i] = null;
        }
        RMSObjects.createRMSConnect(0);
        if (!RMSObjects.rmsConnects[0].load()) {
            RMSObjects.rmsConnects[0].create();
        }
        if ((scores = RMSObjects.localScores.getScoresForGame(0)) != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        for (int i = 0; i < 80; ++i) {
            if (i < this.scoresCount) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(i);
                this.levelStars[i] = Integer.toString(scoreItem.scoreValue);
                MainCanvas.totalStars += scoreItem.scoreValue;
                ++this.count;
                continue;
            }
            this.levelStars[i] = null;
        }
    }

    public void beforeInteruption() {
        this.mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
        this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
    }

    private void calculatePositions() {
        int fkWidth = this.imgButtonSmall.getWidth();
        int sprArrwUpDownWidth = this.imgArrowDown.getWidth() + (this.imgButtonSmall.getWidth() >> 1);
        int sprArrwUpDownHeigth = this.imgArrowDown.getHeight() + (this.imgButtonSmall.getHeight() >> 1);
        int marginLeft = fkWidth;
        this.rectTop = new Rectangle((MainCanvas.WIDTH >> 1) - (this.imgArrowUp.getWidth() >> 1), this.imgArrowUp.getHeight() >> 2, this.imgArrowUp.getWidth(), this.imgArrowUp.getHeight());
        this.rectDown = new Rectangle((MainCanvas.WIDTH >> 1) - (this.imgArrowDown.getWidth() >> 1), MainCanvas.HEIGHT - (this.imgArrowDown.getHeight() >> 2) - this.imgArrowDown.getHeight(), this.imgArrowDown.getWidth(), this.imgArrowDown.getHeight());
        this._rectItems[0] = new Rectangle(MainCanvas.WIDTH - (this.imgButtonSmall.getWidth() << 1), MainCanvas.HEIGHT - (this.imgButtonSmall.getHeight() << 1), this.imgButtonSmall.getWidth() << 1, this.imgButtonSmall.getHeight() << 1);
        this._rectItems[1] = new Rectangle(this.rectTop.getCenterX() - sprArrwUpDownWidth / 2, this.rectTop.getCenterY() - sprArrwUpDownHeigth / 2, sprArrwUpDownWidth, sprArrwUpDownHeigth);
        this._rectItems[2] = new Rectangle(this.rectDown.getCenterX() - sprArrwUpDownWidth / 2, this.rectDown.getCenterY() - sprArrwUpDownHeigth / 2, sprArrwUpDownWidth, sprArrwUpDownHeigth);
        this._rectItems[3] = new Rectangle(0, sprArrwUpDownHeigth, this.mainCanvas.getWidth(), this.mainCanvas.getHeight() - this.rectTop.height - this.rectDown.height);
        this.dy = this.imgButtonSmall.getHeight();
        this._iSelectorDx = this._sprLevel.getWidth();
        this._iSelectorDy = this.dy;
        int _iOffsetX = this._WIDTH % 4 == 0 ? 0 : this._WIDTH % 4 >> 1;
        int _iOffsetTop = this.imgArrowDown.getHeight();
        int _iOffsetBottom = this.imgArrowDown.getHeight();
        int _iOffsetTmpY = this._HEIGHT - _iOffsetTop - _iOffsetBottom;
        int _iOffsetY = _iOffsetTop + (_iOffsetTmpY - (this._sprLevel.getHeight() + this._sprLevelStar.getHeight() << 2)) / 5;
        this._rectLevelBody = new Rectangle(_iOffsetX, _iOffsetY, this._WIDTH - (_iOffsetX << 1), this._HEIGHT - _iOffsetTop - _iOffsetBottom);
        this._iOffsetLevelX = (this._rectLevelBody.width - this._sprLevel.getWidth() * 4) / 5;
        this._iOffsetLevelY = (this._rectLevelBody.height - this._sprLevel.getHeight() * 4) / 5;
        if (this._iOffsetLevelY < this._ptLevelNum.getTextHeight()) {
            this._iOffsetLevelY = this._ptLevelNum.getTextHeight();
        }
        int offset = this.imgButtonSmall.getWidth() >> 3;
        int xCenterFK = MainCanvas.WIDTH - (this.imgButtonSmall.getWidth() >> 1) - offset;
        int yCenterFK = MainCanvas.HEIGHT - (this.imgButtonSmall.getHeight() >> 1) - offset;
        this.rectFK = new Rectangle(xCenterFK - (this.imgButtonSmall.getWidth() >> 1), yCenterFK - (this.imgButtonSmall.getHeight() >> 1), this.imgButtonSmall.getWidth(), this.imgButtonSmall.getHeight());
    }

    public void update(long lastRunLenght) {
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _nextMode) {
        if (_nextMode == this._iNextModeGame) {
            MainCanvas.slcLvl = this.selectdLevel;
            ScreenGame sg = new ScreenGame(this.mainCanvas, this._iGameMode, this.selectdLevel, false);
            this.mainCanvas.changeLastActiveScreen(sg);
            this.mainCanvas.getSoundManager().Stop();
            if (this.mainCanvas.getSoundManager().IsSoundOn()) {
                this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
            }
        } else if (_nextMode == this._iNextModeMenu) {
            this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintArrows(g);
        this.paintLvl(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.drawImage(this._imgBg, 0, 0, 20);
    }

    private void paintLvl(Graphics g) {
        int iShiftX = Resources.resGFonts[0].getHeight() >> 3;
        int iShiftY = -iShiftX;
        if (MainCanvas.HEIGHT >= 640) {
            iShiftY = iShiftX;
        } else if (MainCanvas.HEIGHT >= 480) {
            iShiftY = 0;
        }
        Resources.resGFonts[0].drawString(g, (this.selectedPack + 1 + "/5").toCharArray(), iShiftX, iShiftY, 20);
        int _iTmpLvlIdx = 0;
        int _iTmpLvlStr = 0;
        int _iLvlX = 0;
        int _iLvlY = 0;
        String _sTmpNumber = "";
        String _sTmpStr = "";
        if (this.selectedPack == this._iNextModePack1) {
            this.levelNumber = 0;
        } else if (this.selectedPack == this._iNextModePack2) {
            this.levelNumber = 16;
        } else if (this.selectedPack == this._iNextModePack3) {
            this.levelNumber = 32;
        } else if (this.selectedPack == this._iNextModePack4) {
            this.levelNumber = 48;
        } else if (this.selectedPack == this._iNextModePack5) {
            this.levelNumber = 64;
        }
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                _iTmpLvlStr = 0;
                _sTmpStr = "";
                _iLvlX = this._rectLevelBody.x + (x * this._sprLevel.getWidth() + (x == 0 ? this._iOffsetLevelX : (x + 1) * this._iOffsetLevelX));
                _iLvlY = this._rectLevelBody.y + (y * this._sprLevel.getHeight() + y * this._iOffsetLevelY) + (this.sprLevelStarActive.getHeight() >> 1);
                if (this.selectdLevel == _iTmpLvlIdx + this.levelNumber) {
                    // empty if block
                }
                this._sprLevel.setFrame(0);
                this._sprLevel.setPosition(_iLvlX, _iLvlY);
                this._sprLevel.paint(g);
                this._rectLevel[_iTmpLvlIdx] = this._rSelectedLevel = new Rectangle(this._sprLevel.getX(), this._sprLevel.getY(), this._sprLevel.getWidth(), this._sprLevel.getHeight());
                if (_iTmpLvlIdx + this.levelNumber + 1 <= this.count + 1) {
                    _sTmpNumber = "" + (_iTmpLvlIdx + this.levelNumber + 1);
                    try {
                        if (_iTmpLvlIdx + this.levelNumber + 1 < this.count + 1 && this.levelStars[_iTmpLvlIdx] != null) {
                            _iTmpLvlStr = Integer.parseInt(this.levelStars[_iTmpLvlIdx]);
                        }
                    }
                    catch (Exception r) {
                        // empty catch block
                    }
                    this._ptLevelNum.prepareText(_sTmpNumber, this._sprLevel.getWidth());
                    this._ptLevelNum.drawText(g, this._rSelectedLevel, 0, 3);
                } else {
                    this._sprLevelLock.setFrame(0);
                    this._sprLevelLock.setPosition(_iLvlX, _iLvlY);
                    this._sprLevelLock.paint(g);
                }
                int _iPosX = this._rectLevel[_iTmpLvlIdx].getCenterX() - (this.sprLevelStarActive.getWidth() >> 1);
                if (this.selectdLevel == _iTmpLvlIdx + this.levelNumber) {
                    if (_iTmpLvlIdx + this.levelNumber + 1 <= this.count + 1) {
                        this._sprLevelSelector.setPosition(this._sprLevel.getX() + ((this._sprLevel.getWidth() >> 1) - (this._sprLevelSelector.getWidth() >> 1)), this._sprLevel.getY() + ((this._sprLevel.getHeight() >> 1) - (this._sprLevelSelector.getHeight() >> 1)));
                        this._sprLevelSelector.paint(g);
                    } else {
                        this._sprLevelSelector.setPosition(this._sprLevel.getX() + ((this._sprLevel.getWidth() >> 1) - (this._sprLevelSelector.getWidth() >> 1)), this._sprLevel.getY() + ((this._sprLevel.getHeight() >> 1) - (this._sprLevelSelector.getHeight() >> 1)));
                        this._sprLevelSelector.paint(g);
                    }
                }
                int x1 = _iPosX - this.sprLevelStarActive.getWidth();
                int y1 = this._rectLevel[y * 4 + x].y - (this.sprLevelStarActive.getHeight() >> 2);
                if (_iTmpLvlStr > 0) {
                    this.sprLevelStarActive.setFrame(0);
                    this.sprLevelStarActive.setPosition(x1, y1);
                    this.sprLevelStarActive.paint(g);
                } else {
                    this.sprLevelStarInactive.setFrame(0);
                    this.sprLevelStarInactive.setPosition(x1, y1);
                    this.sprLevelStarInactive.paint(g);
                }
                int x2 = _iPosX;
                int y2 = this._rectLevel[y * 4 + x].y - (this.sprLevelStarActive.getHeight() >> 1);
                if (_iTmpLvlStr > 1) {
                    this.sprLevelStarActive.setFrame(1);
                    this.sprLevelStarActive.setPosition(x2, y2);
                    this.sprLevelStarActive.paint(g);
                } else {
                    this.sprLevelStarInactive.setFrame(1);
                    this.sprLevelStarInactive.setPosition(x2, y2);
                    this.sprLevelStarInactive.paint(g);
                }
                int x3 = _iPosX + this.sprLevelStarActive.getWidth();
                int y3 = this._rectLevel[y * 4 + x].y - (this.sprLevelStarActive.getHeight() >> 2);
                if (_iTmpLvlStr > 2) {
                    this.sprLevelStarActive.setFrame(2);
                    this.sprLevelStarActive.setPosition(x3, y3);
                    this.sprLevelStarActive.paint(g);
                } else {
                    this.sprLevelStarInactive.setFrame(2);
                    this.sprLevelStarInactive.setPosition(x3, y3);
                    this.sprLevelStarInactive.paint(g);
                }
                ++_iTmpLvlIdx;
            }
        }
    }

    private void paintArrows(Graphics g) {
        this.sprSmallIcons.setFrame(Common.SMALL_ARROW);
        if (this.selectedPack != 0) {
            g.drawImage(this.imgArrowUp, this.rectTop.getCenterX(), this.rectTop.getCenterY(), 3);
        }
        if (this.selectedPack != 4) {
            g.drawImage(this.imgArrowDown, this.rectDown.getCenterX(), this.rectDown.getCenterY(), 3);
        }
    }

    private void paintFK(Graphics g) {
        g.drawImage(this.imgButtonSmall, this.rectFK.getCenterX(), this.rectFK.getCenterY(), 3);
        this.sprSmallIcons.setFrame(Common.SMALL_ARROW);
        this.sprSmallIcons.setTransform(0);
        this.sprSmallIcons.setPosition(this.rectFK.getCenterX() - (this.sprSmallIcons.getWidth() >> 1), this.rectFK.getCenterY() - (this.sprSmallIcons.getHeight() >> 1));
        this.sprSmallIcons.paint(g);
    }

    public void keyPressed(int keyCode) {
        if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) {
            // empty if block
        }
    }

    public void keyReleased(int keyCode) {
        if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55 && !Keys.isFKLeftCode(keyCode)) {
            if (Keys.isFKRightCode(keyCode)) {
                this.startAnimation(true, this._iNextModeMenu);
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                if (this.selectdLevel <= this.count) {
                    MainCanvas.counterX = this._iCounterX;
                    MainCanvas.counterY = this._iCounterY;
                    Level.getLevel(this.selectdLevel);
                    this._iGameMode = Level._iGameMode;
                    MainCanvas.slcLvl = this.selectdLevel;
                    this.startAnimation(true, this._iNextModeGame);
                }
            } else if (Keys.isActionGeneratedByKey(3, keyCode)) {
                if (this._iCounterX > 0) {
                    --this._iCounterX;
                    --MainCanvas.counterX;
                    --this.selectdLevel;
                }
            } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
                if (this._iCounterX < 3) {
                    ++this._iCounterX;
                    ++MainCanvas.counterX;
                    ++this.selectdLevel;
                }
            } else if (Keys.isActionGeneratedByKey(1, keyCode)) {
                if (this._iCounterY > 0) {
                    --this._iCounterY;
                    --MainCanvas.counterY;
                    this.selectdLevel -= 4;
                } else if (this.selectedPack > 0) {
                    this._iCounterY = 3;
                    MainCanvas.counterY = 3;
                    --this.selectedPack;
                    --MainCanvas.slcPack;
                    this.selectdLevel -= 4;
                }
            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                if (this._iCounterY < 3) {
                    ++this._iCounterY;
                    ++MainCanvas.counterY;
                    this.selectdLevel += 4;
                } else if (this.selectedPack < 4) {
                    this._iCounterY = 0;
                    MainCanvas.counterY = 0;
                    ++this.selectedPack;
                    ++MainCanvas.slcPack;
                    this.selectdLevel += 4;
                }
            }
        }
        this.mainCanvas.repaint();
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this._rectItems.length; ++i) {
            if (!this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 1: {
                    Keys.keyPressed(50);
                    Keys.resetAllPressedKeysAndActions();
                    break;
                }
                case 2: {
                    Keys.keyPressed(56);
                    Keys.resetAllPressedKeysAndActions();
                    break;
                }
                case 0: {
                    Keys.keyPressed(-7);
                    break;
                }
                case 3: {
                    break;
                }
            }
            return;
        }
    }

    public void pointerDragged(int x, int y) {
        if (this._iSelectedCompId != -1 && !this._rectItems[this._iSelectedCompId].contains(x, y)) {
            switch (this._iSelectedCompId) {
                case 1: {
                    Keys.keyReleased(49);
                    break;
                }
                case 2: {
                    Keys.keyReleased(49);
                    break;
                }
                case 0: {
                    Keys.keyReleased(-7);
                    break;
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this._iSelectedCompId != -1) {
            switch (this._iSelectedCompId) {
                case 1: {
                    if (this.selectedPack > 0) {
                        this._iCounterX = 0;
                        this._iCounterY = 0;
                        --this.selectedPack;
                        --MainCanvas.slcPack;
                        this.selectdLevel -= 16;
                    }
                    this.keyReleased(49);
                    this.mainCanvas.repaint();
                    break;
                }
                case 2: {
                    if (this.selectedPack < 4) {
                        this._iCounterX = 0;
                        this._iCounterY = 0;
                        ++this.selectedPack;
                        ++MainCanvas.slcPack;
                        this.selectdLevel += 16;
                    }
                    this.keyReleased(49);
                    this.mainCanvas.repaint();
                    break;
                }
                case 0: {
                    if (!Keys.isKeyPressed(-7)) break;
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                    break;
                }
                case 3: {
                    for (int i = 0; i < this._rectLevel.length; ++i) {
                        if (this._rectLevel[i] == null || !this._rectLevel[i].contains(x, y) || i + this.selectedPack * 16 > this.count) continue;
                        Level.getLevel(i + this.selectedPack * 16);
                        this._iGameMode = Level._iGameMode;
                        this.selectdLevel = i + this.selectedPack * 16;
                        this.startAnimation(true, this._iNextModeGame);
                    }
                    this.mainCanvas.repaint();
                    break;
                }
                default: {
                    this.keyReleased(5);
                }
            }
            this._iSelectedCompId = -1;
        }
    }
}

