/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Resources;
import sk.inlogic.util.RandomNum;

public class Jewel {
    public static final int BONUS_NONE = 0;
    public static final int BONUS_BOMB = 1;
    public static final int BONUS_SPECTRUM = 2;
    public static final int BONUS_ROW = 3;
    public static final int BONUS_COL = 4;
    public static final int BONUS_CROSS = 5;
    public static final int BONUS_FALL = 6;
    public static final int BONUS_ESCAPE = 7;
    public static final int RES_ROTATE = 0;
    public static final int RES_FADE = 1;
    public static final int RES_SPECTRUM = 2;
    public static final int RES_FALL = 3;
    public static final int RES_FADEFALL = 4;
    public static int BLOCKSIZE;
    public static int MOVE_VELOCITY;
    public static int DSP_BNSBOMB;
    public static int DSP_BNSCROSS;
    public static final int UPDATEDURATION = 50;
    public static int SHIFT_HORIZONTAL_SEL;
    public static int SHIFT_VERTICAL_SEL;
    public static int SHIFT_HORIZONTAL;
    public static int SHIFT_VERTICAL;
    public static int SHIFT_HORIZONTAL_FALL;
    public static int SHIFT_VERTICAL_FALL;
    public static int SHIFT_HORIZONTAL_ESCAPE;
    public static int SHIFT_VERTICAL_ESCAPE;
    private static final int[] RESROTATEFRAMESEQUENCE;
    private static final int[] RESSPECTRUMFRAMESEQUENCE;
    private static final int[] RESCROSSFRAMESEQUENCE;
    private static final int[] RESEXPLODEFRAMESEQUENCE;
    private static final int[] RESESCAPEFFRAMESEQUENCE;
    private int _iResource;
    private int _iResourceFrame;
    private int _iRepeats;
    private int _iColor;
    private int _iDeltaX;
    private int _iDeltaY;
    private int _iVelX;
    private int _iVelY;
    private int _iAccX;
    private int _iAccY;
    private int _iBonusType;
    private int _iBonusFrame;
    Sprite sprRes;

    public Jewel() {
        this.reset();
    }

    public void reset() {
        this._iResource = 0;
        this._iColor = 0;
        this._iDeltaX = 0;
        this._iDeltaY = 0;
        this._iVelX = 0;
        this._iVelY = 0;
        this._iAccX = 0;
        this._iAccY = 0;
        this._iRepeats = 0;
        this._iResourceFrame = 0;
        this._iBonusType = 0;
        this._iBonusFrame = 0;
    }

    public void update() {
        this.updatePosition();
        this.updateAnimation();
        this.updateBonus();
    }

    public void updateFall() {
        this.updatePositionFall();
        this.updateAnimation();
        this.updateBonus();
    }

    private void updatePositionFall() {
        this._iDeltaX += this._iVelX;
        this._iVelX += this._iAccX;
        this._iDeltaY += this._iVelY;
        this._iVelY += this._iAccY;
        if (this._iVelX < -1280) {
            this._iVelX = -1280;
        }
    }

    private void updatePosition() {
        if (this._iDeltaX > 0) {
            this._iDeltaX += this._iVelX;
            this._iVelX += this._iAccX;
            if (this._iDeltaX <= 0) {
                this._iDeltaX = 0;
                this._iVelX = 0;
                this._iAccX = 0;
            }
        } else if (this._iDeltaX < 0) {
            this._iDeltaX += this._iVelX;
            this._iVelX += this._iAccX;
            if (this._iDeltaX >= 0) {
                this._iDeltaX = 0;
                this._iVelX = 0;
                this._iAccX = 0;
            }
        }
        if (this._iDeltaY > 0) {
            this._iDeltaY += this._iVelY;
            this._iVelY += this._iAccY;
            if (this._iDeltaY <= 0) {
                this._iDeltaY = 0;
                this._iVelY = 0;
                this._iAccY = 0;
            }
        } else if (this._iDeltaY < 0) {
            this._iDeltaY += this._iVelY;
            this._iVelY += this._iAccY;
            if (this._iDeltaY >= 0) {
                this._iDeltaY = 0;
                this._iVelY = 0;
                this._iAccY = 0;
            }
        }
    }

    private void updateAnimation() {
        if (this._iRepeats != 0) {
            int framesCount = 0;
            if (this._iResource == 0) {
                framesCount = RESROTATEFRAMESEQUENCE.length - 1;
            } else if (this._iResource == 2) {
                framesCount = RESSPECTRUMFRAMESEQUENCE.length - 1;
            }
            if (this._iResourceFrame < framesCount) {
                ++this._iResourceFrame;
            } else {
                if (this._iRepeats > 0) {
                    --this._iRepeats;
                }
                this._iResourceFrame = 0;
            }
        }
    }

    private void updateBonusEscape() {
        if (this._iBonusType == 7) {
            this._iBonusFrame = this._iBonusFrame < RESESCAPEFFRAMESEQUENCE.length - 1 ? ++this._iBonusFrame : 0;
            this._iBonusFrame = 0;
        }
    }

    private void updateBonus() {
        if (this._iBonusType == 5) {
            this._iBonusFrame = this._iBonusFrame < RESCROSSFRAMESEQUENCE.length - 1 ? ++this._iBonusFrame : 0;
        } else if (this._iBonusType == 1) {
            this._iBonusFrame = this._iBonusFrame < RESEXPLODEFRAMESEQUENCE.length - 1 ? ++this._iBonusFrame : 0;
        }
        this.updateBonusEscape();
    }

    public void paint(Graphics g, int x, int y, boolean shake) {
        int bonusType = this._iBonusType;
        int resource = this._iResource;
        int resourceFrame = this._iResourceFrame;
        this.sprRes = Resources.resSprs[13];
        int animFrame = 0;
        int color = this._iColor;
        int dx = 0;
        int dy = 0;
        boolean _bDownFall = false;
        if (resource == 0) {
            if (resourceFrame >= RESROTATEFRAMESEQUENCE.length) {
                resourceFrame = 0;
            }
            animFrame = 0;
            if (shake) {
                dx = RandomNum.getRandomInt(2);
                dy = RandomNum.getRandomInt(2);
            }
        } else if (resource != 1) {
            if (resource == 2) {
                this.sprRes = Resources.resSprs[15];
                animFrame = RESSPECTRUMFRAMESEQUENCE[resourceFrame];
                color = 0;
            } else if (resource == 3) {
                this.sprRes = Resources.resSprs[30];
                animFrame = 0;
                color = 0;
                _bDownFall = true;
            } else if (resource == 4) {
                this.sprRes = Resources.resSprs[30];
                animFrame = 0;
                color = 0;
                _bDownFall = true;
            }
        }
        this.sprRes.setFrame(color + animFrame);
        if (!_bDownFall) {
            this.sprRes.setPosition(x + (this._iDeltaX >> 8) + dx + SHIFT_HORIZONTAL, y + (this._iDeltaY >> 8) + dy + SHIFT_VERTICAL);
        } else {
            this.sprRes.setPosition(x + (this._iDeltaX >> 8) + dx + SHIFT_HORIZONTAL_FALL, y + (this._iDeltaY >> 8) + dy);
        }
        if (bonusType == 7) {
            this.sprRes.setPosition(x + (this._iDeltaX >> 8) + dx + SHIFT_HORIZONTAL_ESCAPE, y + (this._iDeltaY >> 8) + dy + SHIFT_VERTICAL_ESCAPE);
        }
        if (bonusType != 1 && bonusType != 5 && bonusType != 7) {
            this.sprRes.paint(g);
        }
        color = this._iColor;
        if (bonusType == 1) {
            Sprite sprBns = Resources.resSprs[16];
            sprBns.setFrame(color + RESEXPLODEFRAMESEQUENCE[this._iBonusFrame]);
            sprBns.setPosition(x + (this._iDeltaX >> 8) - DSP_BNSBOMB, y + (this._iDeltaY >> 8) - DSP_BNSBOMB);
            sprBns.paint(g);
        } else if (bonusType == 7) {
            Sprite sprBns = Resources.resSprs[18];
            sprBns.setFrame(color);
            sprBns.setPosition(x + (this._iDeltaX >> 8) + SHIFT_HORIZONTAL_ESCAPE, y + (this._iDeltaY >> 8) + SHIFT_VERTICAL_ESCAPE);
            sprBns.paint(g);
        } else if (bonusType == 5) {
            Sprite sprBns = Resources.resSprs[17];
            sprBns.setFrame(color + RESCROSSFRAMESEQUENCE[this._iBonusFrame]);
            sprBns.setPosition(x + (this._iDeltaX >> 8) - DSP_BNSCROSS, y + (this._iDeltaY >> 8) - DSP_BNSCROSS);
            sprBns.paint(g);
        }
    }

    public int getResource() {
        return this._iResource;
    }

    public int getColor() {
        return this._iColor;
    }

    public int getDeltaX() {
        return this._iDeltaX >> 8;
    }

    public int getDeltaY() {
        return this._iDeltaY >> 8;
    }

    public int getVelX() {
        return this._iVelX;
    }

    public int getVelY() {
        return this._iVelY;
    }

    public int getAccY() {
        return this._iAccY;
    }

    public int getAccX() {
        return this._iAccX;
    }

    public int getAnimationRepeats() {
        return this._iRepeats;
    }

    public int getAnimationFrame() {
        return this._iResourceFrame;
    }

    public void setResource(int resource) {
        this._iResource = resource;
    }

    public void setColor(int color) {
        this._iColor = color;
    }

    public void setVelX(int velX) {
        this._iVelX = velX;
    }

    public void setVelY(int velY) {
        this._iVelY = velY;
    }

    public void setAccY(int accY) {
        this._iAccY = accY;
    }

    public void setAccX(int accX) {
        this._iAccX = accX;
    }

    public void setDeltaX(int dx) {
        this._iDeltaX = dx << 8;
    }

    public void setDeltaY(int dy) {
        this._iDeltaY = dy << 8;
    }

    public boolean isMoving() {
        return this._iDeltaX != 0 || this._iDeltaY != 0;
    }

    public void startAnimation(int repeat) {
        this._iRepeats = repeat;
        this._iResourceFrame = 0;
    }

    public void stopAnimation() {
        this._iRepeats = 0;
        this._iResourceFrame = 0;
    }

    public void setBonus(int bonusType) {
        this._iBonusType = bonusType;
        this._iBonusFrame = 0;
        this._iResource = 0;
        if (bonusType == 2) {
            this._iResource = 2;
            this.startAnimation(-1);
        } else if (bonusType == 6) {
            this._iResource = 3;
            this.startAnimation(-1);
        }
    }

    public int getBonus() {
        return this._iBonusType;
    }

    public boolean isColorDepended() {
        return this._iBonusType != 2 && this._iBonusType != 6;
    }

    public int getTileColor(int i, int j) {
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                if ((x + y) % 2 == 0) {
                    if (x != i || y != j) continue;
                    return 0;
                }
                if (x != i || y != j) continue;
                return 1;
            }
        }
        return 0;
    }

    public void load(DataInputStream dis) throws IOException {
        this._iResource = dis.readInt();
        this._iResourceFrame = dis.readInt();
        this._iRepeats = dis.readInt();
        this._iColor = dis.readInt();
        this._iDeltaX = dis.readInt();
        this._iDeltaY = dis.readInt();
        this._iVelX = dis.readInt();
        this._iVelY = dis.readInt();
        this._iAccX = dis.readInt();
        this._iAccY = dis.readInt();
        this._iBonusType = dis.readInt();
        this._iBonusFrame = dis.readInt();
    }

    public void save(DataOutputStream dos) throws IOException {
        dos.writeInt(this._iResource);
        dos.writeInt(this._iResourceFrame);
        dos.writeInt(this._iRepeats);
        dos.writeInt(this._iColor);
        dos.writeInt(this._iDeltaX);
        dos.writeInt(this._iDeltaY);
        dos.writeInt(this._iVelX);
        dos.writeInt(this._iVelY);
        dos.writeInt(this._iAccX);
        dos.writeInt(this._iAccY);
        dos.writeInt(this._iBonusType);
        dos.writeInt(this._iBonusFrame);
    }

    static {
        RESROTATEFRAMESEQUENCE = new int[]{0};
        RESSPECTRUMFRAMESEQUENCE = new int[]{0};
        RESCROSSFRAMESEQUENCE = new int[]{0};
        RESEXPLODEFRAMESEQUENCE = new int[]{0};
        RESESCAPEFFRAMESEQUENCE = new int[]{0, 0, 1, 1};
    }
}

