/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenAbout;
import sk.inlogic.screen.ScreenInstructions;
import sk.inlogic.screen.ScreenRealyQuit;
import sk.inlogic.screen.ScreenSelectLevel;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMenu
implements IScreen {
    private MainCanvas _mainCanvas;
    public static final int COMP_ID_PLAY = 0;
    public static final int COMP_ID_INSTRUCTIONS = 1;
    public static final int COMP_ID_ABOUT = 2;
    public static final int COMP_ID_SOUND = 3;
    public static final int COMP_ID_SETTINGS = 4;
    public static final int COMP_ID_QUIT = 5;
    public static final int COMP_ID_NONE = 6;
    private static final int TOTAL_COMP_IDS = 7;
    private int[] _arrImages;
    private int[] _arrSprites;
    private int[] _arrFonts;
    private final int _iNextScreenPack;
    private final int _iNextScreenInst;
    private final int _iNextScreenAbou;
    private final int _iNextScreenQuit;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iSelectedCompId;
    private int _iSelectorCompId;
    private int _iOffsetButton = 0;
    private int _iOffsetY;
    private int _iTmpSlctdCmpId;
    private int _interuption = 0;
    private int _iCycle = 10;
    private int _iMusicControler = 0;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private int sel;
    private int force;
    private boolean _bCheck = false;
    private boolean _bChangeSequence = false;
    private boolean _bReleasedTouch = false;
    private boolean _bActiveButton = true;
    private Rectangle[] rectButtons = new Rectangle[7];
    private Rectangle rectGameName;
    private Rectangle rectScreen;
    private Rectangle rectFK;
    private AnimationComponent[] _animationComponents = new AnimationComponent[7];
    private Image imgBG;
    private Image imgGameName;
    private Image imgButtonSmall;
    private Image imgPlayButton;
    private Image imgButtonMiddle;
    private Image imgMiddleSelector;
    private Image imgBigSelector;
    private Sprite _sprSelectorBig;
    private Sprite _sprSelectorSmall;
    private Sprite sprMiddleIcons1;
    private Sprite sprSmallIcons;
    private Sprite sprBigIcons;
    private PreparedText _ptItemName;

    public ScreenMenu(MainCanvas mC, int selectedItem) {
        this._iNextScreenPack = 0;
        this._iNextScreenInst = 1;
        this._iNextScreenAbou = 2;
        this._iNextScreenQuit = 3;
        MainCanvas.counterX = 0;
        MainCanvas.counterY = 0;
        MainCanvas.slcPack = 0;
        this._mainCanvas = mC;
        this._iSelectedCompId = selectedItem;
        this._iSelectorCompId = selectedItem;
        this.initDimensions();
    }

    public void beforeShow() {
        System.out.println("before show");
        this.prepareResources();
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.initGameName();
        this.calculatePositions();
        this.prepareTxt();
        this.initAnimationComponents();
        this.startAnimation(true, -1);
        System.out.println("before show end");
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void prepareResources() {
        this._arrImages = new int[]{4, 2, 9, 15, 11, 22, 23};
        this._arrSprites = new int[]{40, 26, 27, 41, 43};
        this._arrFonts = new int[]{0};
    }

    private void loadResources() {
        Resources.loadImages(this._arrImages);
        Resources.loadSprites(this._arrSprites);
        Resources.loadGFonts(this._arrFonts);
    }

    private void freeResources() {
        Resources.freeImages(this._arrImages);
        Resources.freeSprites(this._arrSprites);
        Resources.freeGFonts(this._arrFonts);
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
        this.rectScreen = new Rectangle(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    private void initImages() {
        this.imgBG = Resources.resImgs[2];
        this.imgGameName = Resources.resImgs[4];
        this.imgButtonSmall = Resources.resImgs[9];
        this.imgButtonMiddle = Resources.resImgs[15];
        this.imgPlayButton = Resources.resImgs[11];
        this.imgMiddleSelector = Resources.resImgs[22];
        this.imgBigSelector = Resources.resImgs[23];
    }

    private void initSprites() {
        this._sprSelectorBig = Resources.resSprs[26];
        this._sprSelectorSmall = Resources.resSprs[27];
        this.sprMiddleIcons1 = Resources.resSprs[41];
        this.sprSmallIcons = Resources.resSprs[40];
        this.sprBigIcons = Resources.resSprs[43];
    }

    private void initFonts() {
        this._ptItemName = new PreparedText(Resources.resGFonts[1]);
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this._mainCanvas, this.rectGameName, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this._mainCanvas, this.rectButtons[0], this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this._mainCanvas, this.rectButtons[1], this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this._mainCanvas, this.rectButtons[2], this._WIDTH, this._HEIGHT);
        this._animationComponents[4] = new AnimationComponent(this._mainCanvas, this.rectButtons[3], this._WIDTH, this._HEIGHT);
        this._animationComponents[5] = new AnimationComponent(this._mainCanvas, this.rectFK, this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(2);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5].startShowAnimation(1);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(2);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5].startShowAnimation(1);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(2);
        this._animationComponents[2].startHideAnimation(0);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(3);
        this._animationComponents[5].startHideAnimation(1);
    }

    private void prepareTxt() {
        this._ptItemName.prepareText("PLAY", this.rectButtons[0].width);
    }

    private void freeGraphics() {
        this.imgBG = null;
        this.imgGameName = null;
        this.sprSmallIcons = null;
        this.imgPlayButton = null;
        this.sprMiddleIcons1 = null;
        this._ptItemName = null;
    }

    public void beforeInteruption() {
        this._bCheck = this._mainCanvas.getSoundManager().IsSoundOn();
        this._mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
        this._mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        this._iMusicControler = 0;
    }

    private void calculatePositions() {
        this.rectButtons[0] = new Rectangle(this.rectScreen.getCenterX() - (this.imgPlayButton.getWidth() >> 1), this.rectGameName.getBottom() + (this.imgPlayButton.getHeight() >> 2), this.imgPlayButton.getWidth(), this.imgPlayButton.getHeight());
        int pY = this.rectButtons[0].getBottom() - (this.imgButtonSmall.getHeight() >> 2) + (this.imgButtonSmall.getHeight() >> 1);
        int pX = this.rectScreen.width >> 2;
        this.rectButtons[1] = new Rectangle(pX - (this.imgButtonSmall.getWidth() >> 1), pY - (this.imgButtonSmall.getHeight() >> 1), this.imgButtonSmall.getWidth(), this.imgButtonSmall.getHeight());
        this.rectButtons[3] = new Rectangle((pX += this.rectScreen.width >> 2) - (this.imgButtonSmall.getWidth() >> 1), (pY += this.imgButtonSmall.getHeight() >> 1) - (this.imgButtonSmall.getHeight() >> 1), this.imgButtonSmall.getWidth(), this.imgButtonSmall.getHeight());
        this.rectButtons[2] = new Rectangle((pX += this.rectScreen.width >> 2) - (this.imgButtonSmall.getWidth() >> 1), (pY -= this.imgButtonSmall.getHeight() >> 1) - (this.imgButtonSmall.getHeight() >> 1), this.imgButtonSmall.getWidth(), this.imgButtonSmall.getHeight());
        this.rectButtons[5] = new Rectangle(this._WIDTH - (this.imgButtonSmall.getWidth() << 1), this._HEIGHT - (this.imgButtonSmall.getHeight() << 1), this.imgButtonSmall.getWidth() << 1, this.imgButtonSmall.getHeight() << 1);
        int offset = this.imgButtonSmall.getWidth() >> 3;
        int xCenterFK = MainCanvas.WIDTH - (this.imgButtonSmall.getWidth() >> 1) - offset;
        int yCenterFK = MainCanvas.HEIGHT - (this.imgButtonSmall.getHeight() >> 1) - offset;
        this.rectFK = new Rectangle(xCenterFK - (this.imgButtonSmall.getWidth() >> 1), yCenterFK - (this.imgButtonSmall.getHeight() >> 1), this.imgButtonSmall.getWidth(), this.imgButtonSmall.getHeight());
        if (MainCanvas.WIDTH == 360 && MainCanvas.HEIGHT == 480) {
            int yOffset = this.imgBigSelector.getHeight();
            this.rectButtons[0].y += yOffset;
            this.rectButtons[3].y += yOffset;
            this.rectButtons[2].y += yOffset;
            this.rectButtons[1].y += yOffset;
        }
    }

    public void update(long lastRunLenght) {
        this.updateSoundInterupt();
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void updateSoundInterupt() {
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this._mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _iNextScreen) {
        switch (_iNextScreen) {
            case 0: {
                this._mainCanvas.changeLastActiveScreen(new ScreenSelectLevel(this._mainCanvas, 0));
                break;
            }
            case 1: {
                this._mainCanvas.changeLastActiveScreen(new ScreenInstructions(this._mainCanvas));
                break;
            }
            case 2: {
                this._mainCanvas.changeLastActiveScreen(new ScreenAbout(this._mainCanvas));
                break;
            }
            case 3: {
                this._mainCanvas.changeLastActiveScreen(new ScreenRealyQuit(this._mainCanvas, this._iSelectorCompId));
            }
        }
        this._mainCanvas.repaint();
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintDialog(g);
        this.paintGameName(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.drawImage(this.imgBG, this.rectScreen.getCenterX(), this.rectScreen.getCenterY(), 3);
    }

    private void paintGameName(Graphics g) {
        g.drawImage(this.imgGameName, this.rectGameName.getCenterX(), this.rectGameName.getCenterY(), 3);
    }

    private void paintDialog(Graphics g) {
        if (this._iSelectorCompId == 0) {
            this.paintButton(g, 0, true);
        } else {
            this.paintButton(g, 0, false);
        }
        if (this._iSelectorCompId == 1) {
            this.paintButton(g, 1, true);
        } else {
            this.paintButton(g, 1, false);
        }
        if (this._iSelectorCompId == 2) {
            this.paintButton(g, 2, true);
        } else {
            this.paintButton(g, 2, false);
        }
        if (this._iSelectorCompId == 3) {
            this.paintButton(g, 3, true);
        } else {
            this.paintButton(g, 3, false);
        }
    }

    private void paintButton(Graphics g, int _iDx, boolean _bSelected) {
        switch (_iDx) {
            case 2: {
                g.drawImage(this.imgButtonMiddle, this.rectButtons[_iDx].getCenterX(), this.rectButtons[_iDx].getCenterY(), 3);
                this.sprMiddleIcons1.setFrame(Common.MIDDLE_ABOUT);
                this.sprMiddleIcons1.setPosition(this.rectButtons[_iDx].getCenterX() - (this.sprMiddleIcons1.getWidth() >> 1), this.rectButtons[_iDx].getCenterY() - (this.sprMiddleIcons1.getHeight() >> 1));
                this.sprMiddleIcons1.paint(g);
                break;
            }
            case 1: {
                g.drawImage(this.imgButtonMiddle, this.rectButtons[_iDx].getCenterX(), this.rectButtons[_iDx].getCenterY(), 3);
                this.sprMiddleIcons1.setFrame(Common.MIDDLE_INSTRUCTIONS);
                this.sprMiddleIcons1.setPosition(this.rectButtons[_iDx].getCenterX() - (this.sprMiddleIcons1.getWidth() >> 1), this.rectButtons[_iDx].getCenterY() - (this.sprMiddleIcons1.getHeight() >> 1));
                this.sprMiddleIcons1.paint(g);
                break;
            }
            case 0: {
                g.drawImage(this.imgPlayButton, this.rectButtons[_iDx].getCenterX(), this.rectButtons[_iDx].getCenterY(), 3);
                break;
            }
            case 3: {
                g.drawImage(this.imgButtonMiddle, this.rectButtons[_iDx].getCenterX(), this.rectButtons[_iDx].getCenterY(), 3);
                this.sprMiddleIcons1.setFrame(this._mainCanvas.getSoundManager().IsSoundOn() ? Common.MIDDLE_SOUND_ON : Common.MIDDLE_SOUND_OFF);
                this.sprMiddleIcons1.setPosition(this.rectButtons[_iDx].getCenterX() - (this.sprMiddleIcons1.getWidth() >> 1), this.rectButtons[_iDx].getCenterY() - (this.sprMiddleIcons1.getHeight() >> 1));
                this.sprMiddleIcons1.paint(g);
            }
        }
    }

    private void paintButtonsTxt(Graphics g) {
        this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(21), this.rectButtons[0].width);
        this._ptItemName.drawText(g, this.rectButtons[0], this._ptItemName.getTextHeight() >> 2, 3);
        this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(22), this.rectButtons[1].width);
        this._ptItemName.drawText(g, this.rectButtons[1], this._ptItemName.getTextHeight() >> 2, 3);
        this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(23), this.rectButtons[1].width);
        this._ptItemName.drawText(g, this.rectButtons[2], this._ptItemName.getTextHeight() >> 2, 3);
        if (this._mainCanvas.getSoundManager().IsSoundOn()) {
            this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(26), this.rectButtons[1].width);
        } else {
            this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(27), this.rectButtons[1].width);
        }
        this._ptItemName.drawText(g, this.rectButtons[3], this._ptItemName.getTextHeight() >> 2, 3);
    }

    private void paintFK(Graphics g) {
        g.drawImage(this.imgButtonSmall, this.rectFK.getCenterX(), this.rectFK.getCenterY(), 3);
        this.sprSmallIcons.setFrame(Common.SMALL_QUIT);
        this.sprSmallIcons.setPosition(this.rectFK.getCenterX() - (this.sprSmallIcons.getWidth() >> 1), this.rectFK.getCenterY() - (this.sprSmallIcons.getHeight() >> 1));
        this.sprSmallIcons.paint(g);
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        this._iTmpSlctdCmpId = keyCode;
        if (this._bActiveButton) {
            if (Keys.isFKLeftCode(keyCode)) {
                switch (this._iSelectedCompId) {
                    case 0: {
                        this.startAnimation(true, 0);
                        break;
                    }
                    case 1: {
                        this.startAnimation(true, 1);
                        break;
                    }
                    case 2: {
                        this.startAnimation(true, 2);
                        break;
                    }
                    case 3: {
                        if (this._mainCanvas.getSoundManager().IsSoundOn()) {
                            this._mainCanvas.getSoundManager().SetSoundOn(false);
                            Settings.musicOn = false;
                            this._mainCanvas.getSoundManager().Stop();
                            break;
                        }
                        this._mainCanvas.getSoundManager().SetSoundOn(true);
                        Settings.musicOn = true;
                        this._mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
                        break;
                    }
                }
            } else if (Keys.isFKRightCode(keyCode)) {
                this.startAnimation(true, 3);
            } else {
                if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
                    switch (this._iSelectedCompId) {
                        case 0: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 3;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 3;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                this._iSelectedCompId = 1;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                this._iSelectedCompId = 2;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            Keys.keyReleased(keyCode);
                            this._bReleasedTouch = true;
                            this.startAnimation(true, 0);
                            break;
                        }
                        case 1: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 0;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 3;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                this._iSelectedCompId = 2;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                this._iSelectedCompId = 2;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            this._bReleasedTouch = true;
                            this.startAnimation(true, 1);
                            break;
                        }
                        case 2: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 0;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 3;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                this._iSelectedCompId = 1;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                this._iSelectedCompId = 1;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            this._bReleasedTouch = true;
                            this.startAnimation(true, 2);
                            break;
                        }
                        case 3: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 0;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 0;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                this._iSelectedCompId = 1;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                this._iSelectedCompId = 2;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            this._bReleasedTouch = true;
                            if (this._mainCanvas.getSoundManager().IsSoundOn()) {
                                this._mainCanvas.getSoundManager().SetSoundOn(false);
                                this._mainCanvas.getSoundManager().Stop();
                                break;
                            }
                            this._mainCanvas.getSoundManager().SetSoundOn(true);
                            this._mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
                        }
                    }
                }
                this._iSelectorCompId = this._iSelectedCompId;
                this._iTmpSlctdCmpId = this._iSelectedCompId;
                this.force = this._iSelectedCompId;
            }
            this._mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this.rectButtons.length; ++i) {
            if (i == 6 || this.rectButtons[i] == null || !this.rectButtons[i].contains(x, y)) continue;
            this.sel = i <= 4 ? i : this.sel;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 4: {
                    Keys.keyPressed(5);
                    break;
                }
                case 5: {
                    Keys.keyPressed(-7);
                    break;
                }
                default: {
                    this._iSelectorCompId = i;
                    this._iTmpSlctdCmpId = this._iSelectedCompId;
                    Keys.keyPressed(53);
                    this._mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (this._iSelectedCompId != 6) {
            if (!this.rectButtons[this._iSelectedCompId].contains(x, y)) {
                switch (this._iSelectedCompId) {
                    case 4: {
                        Keys.keyReleased(5);
                        break;
                    }
                    case 5: {
                        Keys.keyReleased(-7);
                        break;
                    }
                    default: {
                        Keys.keyReleased(53);
                        break;
                    }
                }
            }
        } else {
            this._mainCanvas.repaint();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this._iSelectedCompId != 6) {
            switch (this._iSelectedCompId) {
                case 5: {
                    this._mainCanvas.changeLastActiveScreen(new ScreenRealyQuit(this._mainCanvas, this._iSelectorCompId));
                    if (!Keys.isKeyPressed(-7)) break;
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                    break;
                }
                case 4: {
                    if (!Keys.isKeyPressed(5)) break;
                    this._iSelectedCompId = this.force;
                    this.keyReleased(-5);
                    Keys.keyReleased(-5);
                    break;
                }
                default: {
                    this._bActiveButton = true;
                    if (!Keys.isKeyPressed(53)) break;
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
            }
        }
        this._mainCanvas.repaint();
    }

    private void initGameName() {
        int width = this.imgGameName.getWidth();
        int height = this.imgGameName.getHeight();
        int x = this.rectScreen.getCenterX() - (width >> 1);
        int y = height >> 3;
        this.rectGameName = new Rectangle(x, y, width, height);
    }
}

