/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenInstructions
implements IScreen {
    private MainCanvas _mainCanvas;
    private static final int COMP_ID_BACK = 0;
    private static final int COMP_ID_ARR_UP = 1;
    private static final int COMP_ID_ARR_DOWN = 2;
    private static final int TOTAL_COMP_IDS = 3;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iInteruption = 0;
    private int _iSelectedCompId;
    private int _iTextOffsetY;
    private int _iCycle = 10;
    private int _iFinalHeight;
    private int _iTotalRowTiles = 0;
    private int _iTotalColTiles = 0;
    private int _iOffsetX;
    private int _iOffsetXDefault = 5;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private int[] _animationSequence = new int[6];
    private boolean _bChangeSequence = false;
    private boolean _bNeedRepaint;
    private boolean _bScrollUP = false;
    private boolean _bScrollDOWN = true;
    private boolean isUpPressed;
    private boolean isDownPressed;
    private Rectangle[] _rectItems = new Rectangle[3];
    private Rectangle _rectText;
    private Rectangle rectDialogInstr;
    private Rectangle rectSmallDialogInstr;
    private Rectangle rectFK;
    private Rectangle _rectTop;
    private Image _imgBg;
    private Image imgButtonSmall;
    private Image imgArrowUp;
    private Image imgArrowDown;
    private Image imgSelectorArrowUp;
    private Image imgSelectorArrowDown;
    private Sprite sprMiddleIcons1;
    private Sprite sprSmallIcons;
    private Sprite sprWindow;
    private PreparedText _ptTitle;
    private PreparedText _ptInstructions;
    private AnimationComponent[] _animationComponents = new AnimationComponent[5];
    int iBBSoundProbTimer = 0;
    int a;
    boolean bDragInstructions = false;

    public ScreenInstructions(MainCanvas mC) {
        this._mainCanvas = mC;
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.prepareTxt();
        this._iTextOffsetY = 0;
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 9, 13, 12, 20, 21});
        Resources.loadSprites(new int[]{41, 40, 44});
        Resources.loadGFont(0);
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2, 9, 13, 12, 20, 21});
        Resources.freeSprites(new int[]{41, 40, 44});
        Resources.freeGFont(0);
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
    }

    private void initImages() {
        this._imgBg = Resources.resImgs[2];
        this.imgButtonSmall = Resources.resImgs[9];
        this.imgArrowDown = Resources.resImgs[13];
        this.imgArrowUp = Resources.resImgs[12];
        this.imgSelectorArrowDown = Resources.resImgs[20];
        this.imgSelectorArrowUp = Resources.resImgs[21];
    }

    private void initSprites() {
        this.sprMiddleIcons1 = Resources.resSprs[41];
        this.sprSmallIcons = Resources.resSprs[40];
        this.sprWindow = Resources.resSprs[44];
    }

    private void initFonts() {
        this._ptTitle = new PreparedText(Resources.resGFonts[0]);
        this._ptInstructions = new PreparedText(Resources.resGFonts[0]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0] = 0;
        this._animationSequence[1] = 1;
        this._animationSequence[2] = 2;
        this._animationSequence[3] = 3;
        this._animationSequence[4] = 4;
        this._animationSequence[5] = 5;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this._mainCanvas, this._rectTop, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this._mainCanvas, this._rectText, this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this._mainCanvas, this._rectItems[2], this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this._mainCanvas, this._rectItems[1], this._WIDTH, this._HEIGHT);
        this._animationComponents[4] = new AnimationComponent(this._mainCanvas, this.rectFK, this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(3);
        this._animationComponents[3].startShowAnimation(3);
        this._animationComponents[4].startShowAnimation(1);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(3);
        this._animationComponents[3].startShowAnimation(3);
        this._animationComponents[4].startShowAnimation(1);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(3);
        this._animationComponents[3].startHideAnimation(3);
        this._animationComponents[4].startHideAnimation(1);
    }

    private void prepareTxt() {
        String _sTmpControls = Resources.resTexts[0].getHashedString(17);
        int iSpace = Resources.resGFonts[0].getHeight();
        iSpace = 0;
        this._ptInstructions.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + _sTmpControls, this._rectText.width - iSpace);
        this._ptInstructions.setLineHeightCorrection(-2);
        this._ptTitle.prepareText(Resources.resTexts[0].getHashedString(22), this._rectTop.width);
    }

    private void freeGraphics() {
        this._imgBg = null;
        this._ptTitle = null;
        this._ptInstructions = null;
    }

    public void beforeInteruption() {
        this._mainCanvas.getSoundManager().Stop();
        this.iBBSoundProbTimer = 50;
    }

    public void afterInteruption() {
        this._mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
    }

    private void calculatePositions() {
        this._rectTop = new Rectangle(this._iOffsetXDefault, this.sprSmallIcons.getHeight() - this.sprSmallIcons.getHeight(), this._WIDTH - (this._iOffsetXDefault << 1), this.sprSmallIcons.getHeight());
        int _windowWidth = this._WIDTH >> 1;
        int _offsetTopY = this.imgButtonSmall.getHeight();
        int _offsetBottomY = this.imgButtonSmall.getHeight();
        int _panelHeight = this._HEIGHT - _offsetTopY - _offsetBottomY;
        int iRectTextShiftY = 0;
        iRectTextShiftY = MainCanvas.HEIGHT >= 640 ? _offsetTopY : (MainCanvas.HEIGHT >= 480 ? (_offsetTopY << 1) - (_offsetTopY >> 2) : (MainCanvas.HEIGHT >= 320 ? _offsetTopY + (_offsetTopY >> 1) : (MainCanvas.HEIGHT >= 287 ? _offsetTopY + (_offsetTopY >> 2) : _offsetTopY + (_offsetTopY >> 2))));
        int iRectTextSpaceX = this.sprSmallIcons.getWidth() >> 1;
        int iRectTextHeightShiftY = 0;
        if (MainCanvas.HEIGHT < 320 && MainCanvas.HEIGHT < 287) {
            iRectTextHeightShiftY = _offsetTopY;
        }
        int countX = MainCanvas.WIDTH / this.sprWindow.getWidth();
        int countY = MainCanvas.HEIGHT / this.sprWindow.getHeight();
        if (MainCanvas.HEIGHT == 300) {
            --countX;
            --countY;
        }
        int width = this.sprWindow.getWidth() * countX;
        int height = this.sprWindow.getHeight() * countY;
        if (countX % 2 == 1) {
            width += this.sprWindow.getWidth() >> 1;
        }
        if (countY % 2 == 1) {
            height += this.sprWindow.getHeight() >> 1;
        }
        this.rectDialogInstr = new Rectangle((MainCanvas.WIDTH >> 1) - (width >> 1), (MainCanvas.HEIGHT >> 1) - (height >> 1), width, height);
        this.rectSmallDialogInstr = new Rectangle(this.rectDialogInstr.x + this.sprWindow.getWidth(), this.rectDialogInstr.y + this.sprWindow.getHeight(), width - (this.sprWindow.getWidth() << 1), height - (this.sprWindow.getHeight() << 1));
        int heightArrow = this.imgArrowDown.getHeight();
        int widthArrow = this.imgArrowDown.getWidth();
        this._rectText = new Rectangle(this.rectDialogInstr.x + (heightArrow >> 1), this.rectDialogInstr.y + heightArrow + (heightArrow >> 2), this.rectDialogInstr.width - heightArrow, this.rectDialogInstr.height - (heightArrow + (heightArrow >> 2) << 1));
        this._rectItems[1] = new Rectangle((MainCanvas.WIDTH >> 1) - (widthArrow >> 1), this.rectDialogInstr.y + (heightArrow >> 3), widthArrow, heightArrow);
        this._rectItems[2] = new Rectangle((MainCanvas.WIDTH >> 1) - (widthArrow >> 1), this.rectDialogInstr.getBottom() - heightArrow - (heightArrow >> 3), widthArrow, heightArrow);
        this._rectItems[0] = new Rectangle(MainCanvas.WIDTH - (this.imgButtonSmall.getWidth() << 1), MainCanvas.HEIGHT - (this.imgButtonSmall.getHeight() << 1), this.imgButtonSmall.getWidth() << 1, this.imgButtonSmall.getHeight() << 1);
        int offset = this.imgButtonSmall.getWidth() >> 3;
        int xCenterFK = MainCanvas.WIDTH - (this.imgButtonSmall.getWidth() >> 1) - offset;
        int yCenterFK = MainCanvas.HEIGHT - (this.imgButtonSmall.getHeight() >> 1) - offset;
        this.rectFK = new Rectangle(xCenterFK - (this.imgButtonSmall.getWidth() >> 1), yCenterFK - (this.imgButtonSmall.getHeight() >> 1), this.imgButtonSmall.getWidth(), this.imgButtonSmall.getHeight());
    }

    public void update(long lastRunLenght) {
        if (this._mainCanvas.isInterrupted()) {
            this.iBBSoundProbTimer = 50;
            return;
        }
        if (this.iBBSoundProbTimer > 0) {
            --this.iBBSoundProbTimer;
            if (this.iBBSoundProbTimer <= 0 && !this._mainCanvas.getSoundManager().IsPlaying(Sounds.SOUND_MENU)) {
                this._mainCanvas.getSoundManager().Stop();
                this._mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
                this.iBBSoundProbTimer = 50;
            }
        }
        this.updateSoundInterupt();
        if (Keys.isKeyPressed(27)) {
            this._bScrollDOWN = false;
            this._bScrollUP = false;
            this._mainCanvas.repaint();
        }
        if (this._bNeedRepaint) {
            this._mainCanvas.repaint();
        }
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void updateSoundInterupt() {
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this._mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _nextMode) {
        this._mainCanvas.changeLastActiveScreen(new ScreenMenu(this._mainCanvas, 1));
    }

    private void textMove() {
        if (this._ptInstructions.getTextHeight() < this._rectText.height) {
            return;
        }
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            } else {
                this._iTextOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            }
            if (this._iTextOffsetY < 0) {
                this._iTextOffsetY = 0;
                this._bScrollUP = false;
                this._bScrollDOWN = true;
            }
            this._bNeedRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = this._ptInstructions.getTextHeight() - this._rectText.height;
            if (Resources.sysFont) {
                this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            } else {
                this._iTextOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            }
            if (this._iTextOffsetY > maxOffsetY) {
                this._iTextOffsetY = maxOffsetY;
                this._bScrollUP = true;
                this._bScrollDOWN = false;
            }
            this._bNeedRepaint = true;
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintBody(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.drawImage(this._imgBg, 0, 0, 20);
    }

    private void paintBody(Graphics g) {
        this.paintDialog(g);
        this.paintInstructions(g);
        this.paintArrows(g);
    }

    private void paintTitle(Graphics g) {
        this._ptTitle.drawText(g, this._rectTop, this._ptTitle.getTextHeight() >> 2, 3);
    }

    private void paintDialog(Graphics g) {
        int y;
        for (int x = this.rectSmallDialogInstr.x; x < this.rectSmallDialogInstr.getRight(); x += this.sprWindow.getWidth()) {
            if (x + this.sprWindow.getWidth() > this.rectSmallDialogInstr.getRight()) {
                x = this.rectSmallDialogInstr.getRight() - this.sprWindow.getWidth();
            }
            this.sprWindow.setFrame(1);
            this.sprWindow.setPosition(x, this.rectDialogInstr.y);
            this.sprWindow.paint(g);
            this.sprWindow.setFrame(7);
            this.sprWindow.setPosition(x, this.rectDialogInstr.getBottom() - this.sprWindow.getHeight());
            this.sprWindow.paint(g);
        }
        for (y = this.rectSmallDialogInstr.y; y < this.rectSmallDialogInstr.getBottom(); y += this.sprWindow.getHeight()) {
            if (y + this.sprWindow.getHeight() > this.rectSmallDialogInstr.getBottom()) {
                y = this.rectSmallDialogInstr.getBottom() - this.sprWindow.getHeight();
            }
            this.sprWindow.setFrame(3);
            this.sprWindow.setPosition(this.rectDialogInstr.x, y);
            this.sprWindow.paint(g);
            this.sprWindow.setFrame(5);
            this.sprWindow.setPosition(this.rectDialogInstr.getRight() - this.sprWindow.getWidth(), y);
            this.sprWindow.paint(g);
        }
        for (y = this.rectSmallDialogInstr.y; y < this.rectSmallDialogInstr.getBottom(); y += this.sprWindow.getHeight()) {
            for (int x = this.rectSmallDialogInstr.x; x < this.rectSmallDialogInstr.getRight(); x += this.sprWindow.getWidth()) {
                if (x + this.sprWindow.getWidth() > this.rectSmallDialogInstr.getRight()) {
                    x = this.rectSmallDialogInstr.getRight() - this.sprWindow.getWidth();
                }
                this.sprWindow.setFrame(4);
                this.sprWindow.setPosition(x, y);
                this.sprWindow.paint(g);
            }
        }
        this.sprWindow.setFrame(0);
        this.sprWindow.setPosition(this.rectDialogInstr.x, this.rectDialogInstr.y);
        this.sprWindow.paint(g);
        this.sprWindow.setFrame(2);
        this.sprWindow.setPosition(this.rectDialogInstr.getRight() - this.sprWindow.getWidth(), this.rectDialogInstr.y);
        this.sprWindow.paint(g);
        this.sprWindow.setFrame(6);
        this.sprWindow.setPosition(this.rectDialogInstr.x, this.rectDialogInstr.getBottom() - this.sprWindow.getHeight());
        this.sprWindow.paint(g);
        this.sprWindow.setFrame(8);
        this.sprWindow.setPosition(this.rectDialogInstr.getRight() - this.sprWindow.getWidth(), this.rectDialogInstr.getBottom() - this.sprWindow.getHeight());
        this.sprWindow.paint(g);
    }

    private void paintInstructions(Graphics g) {
        this._ptInstructions.drawText(g, this._rectText, this._iTextOffsetY, 17);
    }

    private void paintFK(Graphics g) {
        g.drawImage(this.imgButtonSmall, this.rectFK.getCenterX(), this.rectFK.getCenterY(), 3);
        this.sprSmallIcons.setFrame(Common.SMALL_ARROW);
        this.sprSmallIcons.setTransform(0);
        this.sprSmallIcons.setPosition(this.rectFK.getCenterX() - (this.sprSmallIcons.getWidth() >> 1), this.rectFK.getCenterY() - (this.sprSmallIcons.getHeight() >> 1));
        this.sprSmallIcons.paint(g);
    }

    private int getWindowTileSprite(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < this._iTotalColTiles - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == this._iTotalColTiles - 1) {
            return 2;
        }
        if (_y == this._iTotalRowTiles - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < this._iTotalRowTiles - 1 && _y > 0) {
            return 3;
        }
        if (_x == this._iTotalColTiles - 1 && _y < this._iTotalRowTiles - 1 && _y > 0) {
            return 5;
        }
        if (_y == this._iTotalRowTiles - 1 && _x < this._iTotalColTiles - 1 && _x > 0) {
            return 7;
        }
        if (_y == this._iTotalRowTiles - 1 && _x == this._iTotalColTiles - 1) {
            return 8;
        }
        return 4;
    }

    private void paintArrows(Graphics g) {
        if (this._bChangeSequence || this._animationComponents[2]._iDefaultY - this._animationComponents[2]._defaultRectangle.y != 0) {
            return;
        }
        if (this._ptInstructions.getTextHeight() >= this._rectText.height) {
            if (this._bScrollUP) {
                g.drawImage(this.imgArrowUp, this._rectItems[1].getCenterX(), this._rectItems[1].getCenterY(), 3);
            }
            if (this._bScrollDOWN) {
                g.drawImage(this.imgArrowDown, this._rectItems[2].getCenterX(), this._rectItems[2].getCenterY(), 3);
            }
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) {
            // empty if block
        }
        if (keyCode == 50) {
            this.isUpPressed = true;
        } else if (keyCode == 56) {
            this.isDownPressed = true;
        }
        this._mainCanvas.repaint();
    }

    public void keyReleased(int keyCode) {
        this.a = keyCode;
        if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
            if (Keys.isFKRightCode(keyCode)) {
                this.startAnimation(true, 0);
                this._mainCanvas.repaint();
            } else if (keyCode == 50) {
                this.isUpPressed = false;
                this.dragUp();
            } else if (keyCode == 56) {
                this.isDownPressed = false;
                this.dragDown();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this._rectText.contains(x, y)) {
            MainCanvas.lastPointerPressedY = y;
            this.bDragInstructions = true;
        }
        block5: for (int i = 0; i < this._rectItems.length; ++i) {
            if (!this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyPressed(27);
                    continue block5;
                }
                case 1: {
                    Keys.keyPressed(50);
                    this.isUpPressed = true;
                    continue block5;
                }
                case 2: {
                    Keys.keyPressed(56);
                    this.isDownPressed = true;
                    continue block5;
                }
                default: {
                    this._mainCanvas.keyPressed(53);
                }
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this._rectItems[this._iSelectedCompId].contains(x, y)) {
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyReleased(27);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                }
            }
        }
        if (this.bDragInstructions) {
            int iTextShiftY;
            if (!this._rectText.contains(x, y)) {
                this.bDragInstructions = false;
            }
            if ((iTextShiftY = MainCanvas.lastPointerPressedY - y) > 0) {
                this.dragDown();
            } else if (iTextShiftY < 0) {
                this.dragUp();
            }
            MainCanvas.lastPointerPressedY = y;
        }
    }

    public void dragUp() {
        if (this._ptInstructions.getTextHeight() < this._rectText.height) {
            return;
        }
        if (Resources.sysFont) {
            this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        } else {
            this._iTextOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        }
        if (this._iTextOffsetY < 0) {
            this._iTextOffsetY = 0;
            this._bScrollUP = false;
            this._bScrollDOWN = true;
        }
        this._bNeedRepaint = true;
    }

    public void dragDown() {
        if (this._ptInstructions.getTextHeight() < this._rectText.height) {
            return;
        }
        int maxOffsetY = this._ptInstructions.getTextHeight() - this._rectText.height;
        if (Resources.sysFont) {
            this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        } else {
            this._iTextOffsetY += Resources.resGFonts[0].getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        }
        if (this._iTextOffsetY > maxOffsetY) {
            this._iTextOffsetY = maxOffsetY;
            this._bScrollUP = true;
            this._bScrollDOWN = false;
        }
        this._bNeedRepaint = true;
    }

    public void pointerReleased(int x, int y) {
        if (this.bDragInstructions) {
            this.bDragInstructions = false;
        }
        switch (this._iSelectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(27)) break;
                this.keyReleased(27);
                Keys.keyReleased(27);
                break;
            }
            case 1: {
                this.isUpPressed = false;
                if (!Keys.isKeyPressed(50)) break;
                this.keyReleased(50);
                Keys.keyReleased(50);
                break;
            }
            case 2: {
                this.isDownPressed = false;
                if (!Keys.isKeyPressed(56)) break;
                this.keyReleased(56);
                Keys.keyReleased(56);
                break;
            }
            default: {
                if (Keys.isKeyPressed(50)) {
                    this.keyReleased(50);
                    Keys.keyReleased(50);
                }
                if (Keys.isKeyPressed(56)) {
                    this.keyReleased(56);
                    Keys.keyReleased(56);
                }
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }
}

