/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenIntro
implements IScreen {
    private static final int SCREEN_LOGO_INLOGIC = 0;
    private static final int SCREEN_LANGUAGE = 1;
    private static final int SCREEN_ENABLE_MUSIC = 2;
    private static final int DELAY_TIME = 2000;
    MainCanvas mainCanvas;
    private long delay;
    private int screen;
    Sprite sprLanguages;
    Sprite sprHand;
    private static String[] langCodes = new String[]{"en", "de", "fr", "it", "es", "pt"};
    private static final int[] LANGUAGES = new int[]{0, 1, 2, 5, 3, 4};
    private static final int TOTAL_LANGUAGES = 6;
    private Rectangle[] rectLanguages = new Rectangle[6];
    private int selectedItem;
    private int handFrame;
    Rectangle[] rectControls = new Rectangle[2];
    Image imgBg;
    Image imgLogoInlogic;
    Sprite sprIcons;
    Sprite sprButtonIcon;
    Sprite sprDialog;
    GFont fontMainWhiteDarkBg;
    PreparedText prepText;
    boolean[] bPressedControl = new boolean[2];
    int iNextScreenCounter = 0;

    public ScreenIntro(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{3, 1});
        this.imgBg = Resources.resImgs[3];
        this.imgLogoInlogic = Resources.resImgs[1];
        this.screen = 0;
        this.delay = 2000L;
    }

    public void afterHide() {
    }

    public void beforeInteruption() {
    }

    public void afterInteruption() {
    }

    public void update(long lastRunLenght) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        switch (this.screen) {
            case 1: 
            case 2: {
                this.updateNextScreen();
                break;
            }
            default: {
                if (this.delay > 0L) {
                    this.delay -= lastRunLenght;
                    break;
                }
                this.nextScreen();
            }
        }
        this.mainCanvas.repaint();
    }

    public void updateNextScreen() {
        if (this.iNextScreenCounter > 0) {
            --this.iNextScreenCounter;
            if (this.iNextScreenCounter <= 0) {
                this.iNextScreenCounter = 0;
                this.nextScreen();
            }
        }
    }

    public void nextScreen() {
        for (int i = 0; i < 2; ++i) {
            if (!this.bPressedControl[i]) continue;
            this.bPressedControl[i] = false;
        }
        switch (this.screen) {
            case 0: {
                Resources.freeImage(1);
                this.imgLogoInlogic = null;
                Resources.loadSprite(1);
                this.sprLanguages = Resources.resSprs[1];
                Resources.loadSprite(0);
                this.sprHand = Resources.resSprs[0];
                this.selectedItem = 0;
                Resources.loadText(0);
                Resources.loadGFont(3);
                this.fontMainWhiteDarkBg = Resources.resGFonts[3];
                Resources.loadSprites(new int[]{2, 11, 13});
                this.sprIcons = Resources.resSprs[2];
                this.sprButtonIcon = Resources.resSprs[11];
                this.sprDialog = Resources.resSprs[13];
                this.calculatePositions();
                this.screen = 1;
                break;
            }
            case 1: {
                Resources.freeSprite(0);
                Resources.freeSprite(1);
                Resources.loadText(0);
                int iDialogMaxWidth = this.sprDialog.getWidth() * 15 - this.sprDialog.getWidth() * 15 * 100 / 380;
                if (MainCanvas.WIDTH < 320 || MainCanvas.HEIGHT < 480) {
                    iDialogMaxWidth -= this.sprDialog.getWidth() * 15 * 100 / 380 >> 2;
                }
                String sText = Resources.resTexts[0].getHashedString(3);
                this.prepText = new PreparedText(this.fontMainWhiteDarkBg);
                this.prepText.prepareText(sText, iDialogMaxWidth);
                this.selectedItem = 0;
                this.screen = 2;
                break;
            }
            case 2: {
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, 0, 0));
                break;
            }
        }
    }

    public void paint(Graphics g) {
        switch (this.screen) {
            case 0: {
                this.paintBg(g);
                this.paintLogoInlogic(g);
                break;
            }
            case 1: {
                this.paintBg(g);
                this.paintFlags(g);
                this.paintControls(g);
                break;
            }
            case 2: {
                this.paintBg(g);
                this.paintDialog(g);
                this.paintControls(g);
                break;
            }
        }
    }

    private void paintFlags(Graphics g) {
        for (int i = 0; i < 6; ++i) {
            this.sprLanguages.setFrame(LANGUAGES[i]);
            this.sprLanguages.setPosition(this.rectLanguages[i].x, this.rectLanguages[i].y);
            this.sprLanguages.paint(g);
        }
        this.sprHand.setFrame(this.handFrame);
        this.sprHand.setPosition(this.rectLanguages[this.selectedItem].getCenterX() - this.sprHand.getWidth(), this.rectLanguages[this.selectedItem].getCenterY());
        this.sprHand.paint(g);
    }

    public void paintBg(Graphics g) {
        g.drawImage(this.imgBg, 0, 0, 20);
    }

    public void paintLogoInlogic(Graphics g) {
        g.drawImage(this.imgLogoInlogic, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, 3);
    }

    public void paintDialog(Graphics g) {
        int iLines;
        int posX;
        int sw = this.sprDialog.getWidth();
        int x = (MainCanvas.WIDTH >> 1) - 7 * sw;
        int y = (MainCanvas.HEIGHT >> 1) - 8 * sw;
        int w = 13 * sw;
        int rows = 14;
        if (MainCanvas.HEIGHT == 220 && MainCanvas.WIDTH == 176) {
            x -= this.sprDialog.getWidth();
            w += this.sprDialog.getWidth() << 1;
            y -= this.sprDialog.getHeight();
            rows = 16;
        }
        this.sprDialog.setFrame(0);
        this.sprDialog.setPosition(x, y);
        this.sprDialog.paint(g);
        for (posX = x + sw; posX < x + w; posX += sw) {
            this.sprDialog.setFrame(1);
            this.sprDialog.setPosition(posX, y);
            this.sprDialog.paint(g);
        }
        this.sprDialog.setFrame(2);
        this.sprDialog.setPosition(x + w, y);
        this.sprDialog.paint(g);
        y += this.sprDialog.getHeight();
        for (int row = 0; row < rows; ++row) {
            this.sprDialog.setFrame(3);
            this.sprDialog.setPosition(x, y);
            this.sprDialog.paint(g);
            for (int posX2 = x + sw; posX2 < x + w; posX2 += sw) {
                this.sprDialog.setFrame(4);
                this.sprDialog.setPosition(posX2, y);
                this.sprDialog.paint(g);
            }
            this.sprDialog.setFrame(5);
            this.sprDialog.setPosition(x + w, y);
            this.sprDialog.paint(g);
            y += this.sprDialog.getHeight();
        }
        this.sprDialog.setFrame(6);
        this.sprDialog.setPosition(x, y);
        this.sprDialog.paint(g);
        for (posX = x + sw; posX < x + w; posX += sw) {
            this.sprDialog.setFrame(7);
            this.sprDialog.setPosition(posX, y);
            this.sprDialog.paint(g);
        }
        this.sprDialog.setFrame(8);
        this.sprDialog.setPosition(x + w, y);
        this.sprDialog.paint(g);
        if (this.prepText != null && (iLines = this.prepText.getTextHeight() / this.fontMainWhiteDarkBg.getHeight()) >= 1) {
            int pomY = (MainCanvas.HEIGHT >> 1) - (this.prepText.getTextHeight() >> 1);
            for (int i = 0; i < iLines; ++i) {
                this.fontMainWhiteDarkBg.drawString(g, this.prepText.getText(i).toCharArray(), MainCanvas.WIDTH >> 1, pomY, 17);
                pomY += this.fontMainWhiteDarkBg.getHeight();
            }
        }
    }

    public void paintControls(Graphics g) {
        switch (this.screen) {
            case 1: {
                break;
            }
            case 2: {
                this.paintControl(g, 0, 0);
                this.paintControl(g, 1, 1);
                break;
            }
        }
    }

    public void paintControl(Graphics g, int id, int iconFrame) {
        this.sprButtonIcon.setFrame(0);
        this.sprButtonIcon.setPosition(this.rectControls[id].x, this.rectControls[id].y);
        this.sprButtonIcon.paint(g);
        if (this.bPressedControl[id]) {
            this.sprButtonIcon.setFrame(1);
        } else {
            this.sprButtonIcon.setFrame(0);
        }
        this.sprButtonIcon.setPosition(this.rectControls[id].x, this.rectControls[id].y);
        this.sprButtonIcon.paint(g);
        if (this.bPressedControl[id]) {
            this.sprIcons.setFrame(iconFrame + 11);
        } else {
            this.sprIcons.setFrame(iconFrame);
        }
        this.sprIcons.setPosition(this.rectControls[id].getCenterX() - (this.sprIcons.getWidth() >> 1), this.rectControls[id].getCenterY() - (this.sprIcons.getHeight() >> 1));
        this.sprIcons.paint(g);
    }

    public void keyPressed(int keyCode) {
        if (this.iNextScreenCounter <= 0) {
            switch (this.screen) {
                case 1: {
                    if (Keys.isActionPressed(5) || Keys.isKeyPressed(-6)) {
                        this.bPressedControl[0] = true;
                        this.handFrame = 1;
                        return;
                    }
                    if (this.handFrame != 0) break;
                    if (Keys.isActionPressed(3)) {
                        this.changeSelectedLanguage(0);
                        break;
                    }
                    if (Keys.isActionPressed(4)) {
                        this.changeSelectedLanguage(1);
                        break;
                    }
                    if (Keys.isActionPressed(1)) {
                        this.changeSelectedLanguage(2);
                        break;
                    }
                    if (!Keys.isActionPressed(2)) break;
                    this.changeSelectedLanguage(3);
                    break;
                }
                case 2: {
                    if (Keys.isKeyPressed(-6)) {
                        this.bPressedControl[0] = true;
                        this.soundOn();
                        return;
                    }
                    if (!Keys.isKeyPressed(-7)) break;
                    this.bPressedControl[1] = true;
                    this.soundOff();
                    return;
                }
                default: {
                    if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(-6) || this.delay <= 100L) break;
                    this.delay = 100L;
                }
            }
        }
    }

    public void keyReleased(int keyCode) {
        if (this.iNextScreenCounter <= 0) {
            switch (this.screen) {
                case 1: {
                    if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(-6) || this.handFrame <= 0 || this.selectedItem <= -1) break;
                    this.handFrame = 0;
                    Resources.initLangDirs(langCodes[this.selectedItem]);
                    this.iNextScreenCounter = 3;
                    break;
                }
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.iNextScreenCounter <= 0) {
            // empty if block
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.iNextScreenCounter <= 0) {
            // empty if block
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.iNextScreenCounter <= 0) {
            // empty if block
        }
    }

    private void calculatePositions() {
        int iControlsX = this.sprButtonIcon.getWidth() << 1;
        int iControlsY = MainCanvas.HEIGHT - (this.sprButtonIcon.getHeight() << 1);
        if (MainCanvas.HEIGHT < 480) {
            iControlsY = MainCanvas.HEIGHT - this.sprButtonIcon.getHeight() - (this.sprButtonIcon.getHeight() >> 2);
            iControlsX = this.sprButtonIcon.getWidth() >> 2;
        }
        this.rectControls = new Rectangle[2];
        this.rectControls[0] = new Rectangle(iControlsX, iControlsY, this.sprButtonIcon.getWidth(), this.sprButtonIcon.getHeight());
        this.rectControls[1] = new Rectangle(MainCanvas.WIDTH - iControlsX - this.sprButtonIcon.getWidth(), iControlsY, this.sprButtonIcon.getWidth(), this.sprButtonIcon.getHeight());
        int iWidth = this.sprLanguages.getWidth();
        int iHeight = this.sprLanguages.getHeight();
        int shiftX = iWidth >> 2;
        int shiftY = iHeight >> 1;
        int spaceX = (MainCanvas.WIDTH - (shiftX << 1) - (iWidth << 1)) / 3;
        int spaceY = (MainCanvas.HEIGHT - ((shiftY << 1) - (shiftY >> 2)) - iHeight * 3) / 4;
        int iX1 = shiftX + spaceX;
        int iX2 = iX1 + spaceX + iWidth;
        int iY = shiftY + spaceY;
        iY -= this.sprButtonIcon.getHeight() >> 1;
        int id = 0;
        for (int i = 0; i < 3; ++i) {
            this.rectLanguages[id] = new Rectangle(iX1, iY + (this.sprLanguages.getHeight() >> 2), iWidth, iHeight);
            this.rectLanguages[id + 1] = new Rectangle(iX2, iY + (this.sprLanguages.getHeight() >> 2), iWidth, iHeight);
            iY += spaceY + iHeight;
            id += 2;
        }
        this.handFrame = 0;
    }

    private void changeSelectedLanguage(int action) {
        switch (action) {
            case 0: {
                if (this.selectedItem <= 0 || this.selectedItem % 2 != 1) break;
                --this.selectedItem;
                break;
            }
            case 1: {
                if (this.selectedItem % 2 != 0) break;
                ++this.selectedItem;
                break;
            }
            case 2: {
                if (this.selectedItem <= 1) break;
                this.selectedItem -= 2;
                break;
            }
            case 3: {
                if (this.selectedItem >= 4) break;
                this.selectedItem += 2;
                break;
            }
        }
    }

    private void soundOn() {
        Settings.bSet = false;
        Settings.bMusic = true;
        MainCanvas.soundManager.SetSoundOn(true);
        MainCanvas.soundManager.SetMusicOn(true);
        this.iNextScreenCounter = 3;
    }

    private void soundOff() {
        Settings.bSet = false;
        Settings.bMusic = false;
        MainCanvas.soundManager.SetSoundOn(false);
        MainCanvas.soundManager.SetMusicOn(false);
        this.iNextScreenCounter = 3;
    }
}

