/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.GeneralDefs;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenGame;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMenu
implements IScreen {
    MainCanvas mainCanvas;
    static final byte SCREEN_MAIN_MENU = 0;
    static final byte SCREEN_GAME_MODE = 1;
    static final byte SCREEN_SETTINGS = 2;
    static final byte SCREEN_INSTRUCTIONS = 3;
    static final byte SCREEN_ABOUT = 4;
    static final byte SCREEN_QUIT = 5;
    static final byte SCREEN_SELECT_LEVEL = 6;
    static final byte SCREEN_PAUSE = 7;
    static final byte SCREEN_RESET = 8;
    static final byte SCREEN_QUIT_TO_MENU = 9;
    static final byte SCREEN_RESTART = 10;
    static final byte SCREEN_GAME_EASY = 11;
    static final byte SCREEN_GAME_MEDIUM = 12;
    static final byte SCREEN_GAME_HARD = 13;
    static final byte SCREEN_GAME_TUTORIAL = 14;
    final byte ID_LOADING = (byte)4;
    final byte ID_PLAY;
    final byte ID_SETTINGS_SOUND;
    final byte ID_INSTRUCTIONS = (byte)2;
    final byte ID_ABOUT = (byte)3;
    final byte TOTAL_MAIN_MENU = (byte)4;
    final byte ID_SETTINGS;
    final byte ID_SETTINGS_RESET;
    final byte TOTAL_SETTINGS = (byte)2;
    final byte ID_MODE_NONE = (byte)-1;
    final byte ID_MODE_EASY;
    final byte ID_MODE_MEDIUM;
    final byte ID_MODE_HARD = (byte)2;
    final byte ID_MODE_TUTORIAL = (byte)3;
    final byte TOTAL_GAME_MODE = (byte)4;
    final byte ID_PAUSE_CONTINUE;
    final byte ID_PAUSE_RESTART;
    final byte ID_PAUSE_SOUND = (byte)2;
    final byte ID_PAUSE_QUIT_TO_MENU = (byte)3;
    final byte TOTAL_PAUSE = (byte)4;
    private Rectangle[] rectMenu;
    private Rectangle[] rectGameMode;
    private Rectangle[] rectSettings;
    private Rectangle[] rectControls = new Rectangle[2];
    private Rectangle rectDialog;
    private Rectangle rectInfo;
    private Rectangle rectInstr;
    private PreparedText preparedTextInfo;
    private Rectangle rectMenuDialog;
    private Rectangle[] rectMenuBtns;
    private Rectangle[] rectLevelTiles;
    private Rectangle[] rectArrows = new Rectangle[2];
    private Rectangle[] rectOptions = new Rectangle[2];
    GFont fontMainWhite;
    GFont fontMainWhiteSmall;
    GFont fontMainDark;
    GFont fontMainWhiteBlackBg;
    GFont fontMainWhiteBlackBgSmall;
    Image imgBg;
    Image imgLogo;
    Image imgLogoInlogic;
    Image imgAboutLogo;
    Image imgButton;
    Image imgButtonActive;
    Image imgScoreStar;
    Sprite sprIcons;
    Sprite sprArrows;
    Sprite sprMedals;
    Sprite sprButton;
    Sprite sprButtonIcons;
    Sprite sprButtonActive;
    Sprite sprDialog;
    Sprite sprButtonLevel;
    Sprite sprTopBg;
    String[] str;
    private int screen;
    private int selectedItem = -1;
    private int iBookedSpaceY;
    private int iLogoY;
    private int iDialogCenterY;
    private int iAboutHeight;
    private int iDialogMaxWidth;
    private int iDialogMaxHeight;
    private int iTopY;
    private int iTopYIn;
    private int iTopYOut;
    private int iCounterUp = 0;
    private int xDialog;
    private int yDialog;
    private int wDialog;
    private int swDialog;
    private int hDialog;
    private int xBar;
    private int yBar;
    private int wBar;
    private int swBar;
    private int yPosBar;
    private int iPage;
    private int iMaxPages;
    private int level;
    private int[] scores;
    private int[] medals;
    private int levelTilesX;
    private int levelTilesY;
    private int levelTilesHeight;
    private int spaceXLevelTiles;
    private int spaceYLevelTiles;
    private int gameMode;
    private int loadingCounter = 0;
    private int iScrollerWidth = 0;
    private int iRepaintCounter = 0;
    private int nextScreenStep = 0;
    private int nextScreen = 0;
    private int nextSelectedItem = 0;
    private int iUpdateCounterPaintLevel = 0;
    private boolean loading = false;
    private boolean infoSizeSet = false;
    boolean isLoading;
    boolean[] levelsLocked;
    boolean isFromMainMenu;
    boolean bChangeSound = false;
    boolean bQuit = false;
    boolean[] bPressedControl = new boolean[2];
    boolean bNewStonesArrangement = true;
    boolean bShowedPaintLevel = true;
    boolean bContinue = false;
    int iInstructionsTextShift = 0;

    public ScreenMenu(MainCanvas mainCanvas, int screen, int gameMode, int level) {
        this.ID_PLAY = 0;
        this.ID_SETTINGS_SOUND = 1;
        this.ID_SETTINGS = 0;
        this.ID_SETTINGS_RESET = 1;
        this.ID_MODE_EASY = 0;
        this.ID_MODE_MEDIUM = 1;
        this.ID_PAUSE_CONTINUE = 0;
        this.ID_PAUSE_RESTART = 1;
        System.out.println("\n \nSCREEN MENU");
        this.mainCanvas = mainCanvas;
        this.screen = screen;
        this.gameMode = gameMode;
        this.level = level;
        this.initScores();
        this.initSettings();
    }

    public void update(long lastRunLenght) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (this.bContinue) {
            this.mainCanvas.repaint();
            return;
        }
        if (!this.isLoading && this.loadingCounter == 0) {
            this.updateNextScreen();
            if (this.screen == 3) {
                if (this.iRepaintCounter == 0) {
                    this.updateInstructions();
                }
            } else if (this.screen == 6) {
                this.updatePaintLevelCounter(lastRunLenght);
            }
            this.updateStatusBar();
            ++this.iCounterUp;
            if (this.screen == 3) {
                if (this.iRepaintCounter == 0) {
                    ++this.iRepaintCounter;
                    this.mainCanvas.repaint();
                } else {
                    this.iRepaintCounter = 0;
                }
            } else {
                this.mainCanvas.repaint();
            }
        }
    }

    public void updateStatusBar() {
        int iTopShiftStepY = this.sprTopBg.getHeight() >> 2;
        if (iTopShiftStepY < 1) {
            iTopShiftStepY = 1;
        }
        if (this.screen == 6) {
            if (this.iTopY != this.iTopYIn) {
                this.iTopY += iTopShiftStepY;
                if (this.iTopY > this.iTopYIn) {
                    this.iTopY = this.iTopYIn;
                }
            }
        } else if (this.iTopY != this.iTopYOut) {
            this.iTopY -= iTopShiftStepY;
            if (this.iTopY < this.iTopYOut) {
                this.iTopY = this.iTopYOut;
            }
        }
    }

    public void updatePaintLevelCounter(long lTick) {
        this.iUpdateCounterPaintLevel = (int)((long)this.iUpdateCounterPaintLevel + lTick);
        if (this.iUpdateCounterPaintLevel >= 375) {
            this.iUpdateCounterPaintLevel = 0;
            this.bShowedPaintLevel = !this.bShowedPaintLevel;
        }
    }

    public void deactivatePressedControls() {
        for (int i = 0; i < this.bPressedControl.length; ++i) {
            if (!this.bPressedControl[i]) continue;
            this.bPressedControl[i] = false;
        }
    }

    public void updateNextScreen() {
        if (this.nextScreenStep > 0) {
            --this.nextScreenStep;
            if (this.nextScreenStep <= 0) {
                this.nextScreenStep = 0;
                this.deactivatePressedControls();
                this.screen = this.nextScreen;
                this.selectedItem = this.nextSelectedItem;
                if (this.screen == 14) {
                    this.mainCanvas.changeLastActiveScreen(new ScreenGame(this.mainCanvas, 3, -1, this.bNewStonesArrangement));
                    this.mainCanvas.repaint();
                } else if (this.screen == 11) {
                    this.mainCanvas.changeLastActiveScreen(new ScreenGame(this.mainCanvas, 0, this.level, this.bNewStonesArrangement));
                    this.mainCanvas.repaint();
                } else if (this.screen == 12) {
                    this.mainCanvas.changeLastActiveScreen(new ScreenGame(this.mainCanvas, 1, this.level, this.bNewStonesArrangement));
                    this.mainCanvas.repaint();
                } else if (this.screen == 13) {
                    this.mainCanvas.changeLastActiveScreen(new ScreenGame(this.mainCanvas, 2, this.level, this.bNewStonesArrangement));
                    this.mainCanvas.repaint();
                } else if (this.bChangeSound) {
                    this.bChangeSound = false;
                    this.changeSound();
                } else if (this.bQuit) {
                    this.quit();
                } else {
                    this.calculatePositions();
                }
            }
        }
    }

    public void nextScreen(int nextScreen, int nextSelectedItem) {
        this.nextScreen = nextScreen;
        this.nextSelectedItem = nextSelectedItem;
        this.nextScreenStep = 3;
    }

    public void paint(Graphics g) {
        if (this.bContinue) {
            this.paintContinue(g);
            return;
        }
        if (!MainCanvas.soundManager.IsPlaying(Sounds.MUSIC_MENU)) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
        }
        this.paintBg(g);
        switch (this.screen) {
            case 0: 
            case 1: 
            case 7: {
                this.paintLogo(g);
                this.paintMenuDialog(g);
                this.paintMenuBtns(g);
                break;
            }
            case 3: {
                if (!this.infoSizeSet) break;
                this.paintLogo(g);
                this.paintInstructions(g);
                break;
            }
            case 4: {
                this.paintLogo(g);
                this.paintAbout(g);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                if (this.screen == 10 && this.loading) {
                    this.paintDialog(g);
                    int x = this.xDialog + this.swDialog;
                    int y = this.yDialog + this.sprDialog.getHeight();
                    Rectangle rectInfo = new Rectangle(x, y, this.wDialog - (this.swDialog >> 1) - this.swDialog, this.hDialog * this.sprDialog.getHeight());
                    this.preparedTextInfo = new PreparedText(this.fontMainWhiteBlackBg);
                    this.preparedTextInfo.prepareText(this.str[4], this.sprDialog.getWidth() * 6 << 1);
                    this.preparedTextInfo.drawText(g, rectInfo, 3);
                }
                this.paintLogo(g);
                this.paintQuestion(g);
                break;
            }
            case 6: {
                this.paintStatusBar(g);
                this.paintLevels(g);
                this.paintArrows(g);
                if (!this.loading) break;
                this.paintDialog(g);
                int x = this.xDialog + this.swDialog;
                int y = this.yDialog + this.sprDialog.getHeight();
                this.preparedTextInfo = new PreparedText(this.fontMainWhiteBlackBg);
                this.preparedTextInfo.prepareText(this.str[4], this.sprDialog.getWidth() * 6 << 1);
                Rectangle rectInfo = new Rectangle(x, y, this.wDialog - (this.swDialog >> 1) - this.swDialog, this.hDialog * this.sprDialog.getHeight());
                this.preparedTextInfo.drawText(g, this.rectDialog, 3);
                break;
            }
        }
        this.paintControls(g);
    }

    public void paintContinue(Graphics g) {
        this.paintBg(g);
        this.paintDialog(g);
        String s = Resources.resTexts[0].getHashedString(133);
        this.fontMainWhiteBlackBg.drawString(g, s.toCharArray(), this.rectDialog.getCenterX(), this.rectDialog.getCenterY(), 17);
        this.paintControl(g, 0, 6);
    }

    public void paintBg(Graphics g) {
        g.drawImage(this.imgBg, 0, 0, 20);
    }

    public boolean isSmallAspectRatio() {
        return MainCanvas.WIDTH * 100 / MainCanvas.HEIGHT >= 75;
    }

    public boolean isBigAspectRatio() {
        return MainCanvas.WIDTH * 100 / MainCanvas.HEIGHT < 57;
    }

    public void paintLogo(Graphics g) {
        g.drawImage(this.imgLogo, MainCanvas.WIDTH >> 1, this.iLogoY, 3);
    }

    public void paintMenu(Graphics g) {
        int total = 0;
        switch (this.screen) {
            case 0: {
                total = 4;
                break;
            }
            case 1: {
                total = 4;
                break;
            }
            case 7: {
                total = 4;
                break;
            }
        }
        int shiftY = 0;
        if (MainCanvas.WIDTH < 176 || MainCanvas.HEIGHT < 220) {
            shiftY = 1;
        }
        Sprite button = this.sprButton;
        for (int i = 0; i < total; ++i) {
            button = i == this.selectedItem ? this.sprButtonActive : this.sprButton;
            Rectangle[] rect = this.rectMenu;
            if (this.screen == 0) {
                rect = this.rectMenu;
            } else if (this.screen == 1) {
                rect = this.rectGameMode;
            }
            int sw = button.getWidth();
            int x = rect[i].x;
            int y = rect[i].y + shiftY;
            int w = rect[i].width;
            if (MainCanvas.HEIGHT == 160 && MainCanvas.WIDTH == 128) {
                x -= sw;
                w += sw << 1;
            }
            if (MainCanvas.HEIGHT == 220 && MainCanvas.WIDTH == 176) {
                x -= sw + (sw >> 1);
                w += (sw << 1) + sw;
            }
            button.setFrame(0);
            button.setPosition(x, y);
            button.paint(g);
            for (int posX = x + sw; posX < x + w; posX += sw) {
                button.setFrame(1);
                button.setPosition(posX, y);
                button.paint(g);
            }
            button.setFrame(2);
            button.setPosition(x + w, y);
            button.paint(g);
            if (this.str[i] == null) continue;
            if (i != this.selectedItem) {
                if (MainCanvas.HEIGHT < 200) {
                    this.fontMainWhite.drawString(g, this.str[i].toCharArray(), MainCanvas.WIDTH >> 1, rect[i].getCenterY() - (this.fontMainDark.getHeight() >> 1), 17);
                    continue;
                }
                this.fontMainDark.drawString(g, this.str[i].toCharArray(), MainCanvas.WIDTH >> 1, rect[i].getCenterY() - (this.fontMainDark.getHeight() >> 1), 17);
                continue;
            }
            this.fontMainWhite.drawString(g, this.str[i].toCharArray(), MainCanvas.WIDTH >> 1, rect[i].getCenterY() - (this.fontMainWhite.getHeight() >> 1), 17);
        }
    }

    public void paintSettings(Graphics g) {
        int shiftY = 0;
        if (MainCanvas.WIDTH < 176 || MainCanvas.HEIGHT < 220) {
            shiftY = 1;
        }
        Sprite button = this.sprButton;
        for (int i = 0; i < 2; ++i) {
            button = i == this.selectedItem ? this.sprButtonActive : this.sprButton;
            button.setPosition(this.rectSettings[i].x, this.rectSettings[i].y + shiftY);
            int sw = button.getWidth();
            int x = this.rectSettings[i].x;
            int y = this.rectSettings[i].y + shiftY;
            int w = 12 * sw;
            button.setFrame(0);
            button.setPosition(x, y);
            button.paint(g);
            for (int posX = x + sw; posX < x + w; posX += sw) {
                button.setFrame(1);
                button.setPosition(posX, y);
                button.paint(g);
            }
            button.setFrame(2);
            button.setPosition(x + w, y);
            button.paint(g);
            if (this.str[i] == null) continue;
            if (i != this.selectedItem) {
                this.fontMainDark.drawString(g, this.str[i].toCharArray(), this.rectSettings[i].getCenterX(), this.rectSettings[i].getCenterY() - (this.fontMainDark.getHeight() >> 1), 17);
                continue;
            }
            this.fontMainWhiteBlackBg.drawString(g, this.str[i].toCharArray(), this.rectSettings[i].getCenterX(), this.rectSettings[i].getCenterY() - (this.fontMainWhiteBlackBg.getHeight() >> 1), 17);
        }
    }

    public void paintDialog(Graphics g) {
        int posX;
        int y = this.yDialog;
        this.sprDialog.setFrame(0);
        this.sprDialog.setPosition(this.xDialog, y);
        this.sprDialog.paint(g);
        for (posX = this.xDialog + this.swDialog; posX < this.xDialog + this.wDialog; posX += this.swDialog) {
            this.sprDialog.setFrame(1);
            this.sprDialog.setPosition(posX, y);
            this.sprDialog.paint(g);
        }
        this.sprDialog.setFrame(2);
        this.sprDialog.setPosition(this.xDialog + this.wDialog, y);
        this.sprDialog.paint(g);
        y += this.sprDialog.getHeight();
        for (int row = 0; row < this.hDialog; ++row) {
            this.sprDialog.setFrame(3);
            this.sprDialog.setPosition(this.xDialog, y);
            this.sprDialog.paint(g);
            for (int posX2 = this.xDialog + this.swDialog; posX2 < this.xDialog + this.wDialog; posX2 += this.swDialog) {
                this.sprDialog.setFrame(4);
                this.sprDialog.setPosition(posX2, y);
                this.sprDialog.paint(g);
            }
            this.sprDialog.setFrame(5);
            this.sprDialog.setPosition(this.xDialog + this.wDialog, y);
            this.sprDialog.paint(g);
            y += this.sprDialog.getHeight();
        }
        this.sprDialog.setFrame(6);
        this.sprDialog.setPosition(this.xDialog, y);
        this.sprDialog.paint(g);
        for (posX = this.xDialog + this.swDialog; posX < this.xDialog + this.wDialog; posX += this.swDialog) {
            this.sprDialog.setFrame(7);
            this.sprDialog.setPosition(posX, y);
            this.sprDialog.paint(g);
        }
        this.sprDialog.setFrame(8);
        this.sprDialog.setPosition(this.xDialog + this.wDialog, y);
        this.sprDialog.paint(g);
    }

    public void paintInstructions(Graphics g) {
        this.paintDialog(g);
        if (this.preparedTextInfo != null) {
            g.setClip(this.rectInstr.x, this.rectInstr.y, this.rectInstr.width, this.rectInstr.height);
            this.preparedTextInfo.drawText(g, this.rectInstr, 20);
            g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            this.paintScroller(g);
        }
    }

    public void paintQuestion(Graphics g) {
        this.paintDialog(g);
        if (this.preparedTextInfo != null) {
            this.preparedTextInfo.drawText(g, this.rectInfo, 3);
        }
    }

    public void paintAbout(Graphics g) {
        this.paintMenuDialog(g);
        g.drawImage(this.imgAboutLogo, MainCanvas.WIDTH >> 1, this.rectMenuDialog.getCenterY() + this.fontMainWhiteBlackBgSmall.getHeight(), 33);
        if (this.preparedTextInfo != null) {
            this.preparedTextInfo.drawText(g, this.rectInfo, 17);
        }
    }

    public void paintStatusBar(Graphics g) {
        int yMid = this.yPosBar + ((this.sprTopBg.getHeight() >> 1) - (this.fontMainWhiteBlackBg.getHeight() >> 1));
        this.sprTopBg.setFrame(0);
        this.sprTopBg.setPosition(this.xBar, this.yPosBar);
        this.sprTopBg.paint(g);
        for (int posX = this.xBar + this.swBar; posX < this.xBar + this.wBar; posX += this.swBar) {
            this.sprTopBg.setFrame(1);
            this.sprTopBg.setPosition(posX, this.yPosBar);
            this.sprTopBg.paint(g);
        }
        this.sprTopBg.setFrame(2);
        this.sprTopBg.setPosition(this.xBar + this.wBar, this.yPosBar);
        this.sprTopBg.paint(g);
        int iX1 = (MainCanvas.WIDTH >> 1) - (this.iDialogMaxWidth >> 1);
        int iX2 = (MainCanvas.WIDTH >> 1) + (this.iDialogMaxWidth >> 1);
        iX1 = this.xBar + (this.imgScoreStar.getWidth() >> 1);
        iX2 = this.xBar + this.wBar + this.swBar - (this.imgScoreStar.getWidth() >> 1);
        String sText = Resources.resTexts[0].getHashedString(17) + " " + (this.level + 1);
        if (this.levelsLocked[this.level]) {
            sText = Resources.resTexts[0].getHashedString(138);
            this.fontMainWhiteBlackBg.drawString(g, sText.toCharArray(), MainCanvas.WIDTH >> 1, yMid, 17);
        } else {
            this.fontMainWhiteBlackBg.drawString(g, sText.toCharArray(), iX1, yMid, 20);
        }
        this.yBar = this.sprTopBg.getHeight() + (this.sprTopBg.getHeight() >> 1);
        if (MainCanvas.HEIGHT == 480 && MainCanvas.WIDTH == 360) {
            this.yBar = this.yPosBar + (this.sprTopBg.getHeight() >> 1);
        }
        if (MainCanvas.HEIGHT == 220 && MainCanvas.WIDTH == 176) {
            this.yBar = this.yPosBar + (this.sprTopBg.getHeight() >> 1);
        }
        if (this.scores[this.level] > 0 || !this.levelsLocked[this.level]) {
            sText = this.scores[this.level] + "";
            iX2 -= this.fontMainWhiteBlackBg.stringWidth(sText.toCharArray());
            if (MainCanvas.HEIGHT == 320 && MainCanvas.WIDTH == 240) {
                this.yBar -= this.yBar >> 1;
                this.yBar += this.imgScoreStar.getHeight() >> 1;
            } else if (MainCanvas.HEIGHT == 220 && MainCanvas.WIDTH == 176) {
                this.yBar = this.yPosBar + (this.sprTopBg.getHeight() >> 1);
            }
            g.drawImage(this.imgScoreStar, iX2 - (this.sprTopBg.getWidth() << 1), yMid, 20);
            this.fontMainWhiteBlackBg.drawString(g, sText.toCharArray(), (iX2 += this.imgScoreStar.getWidth() + (this.imgScoreStar.getWidth() >> 1)) - (this.sprTopBg.getWidth() << 1), yMid, 20);
        }
    }

    public void paintLevels(Graphics g) {
        int iShiftTextY = this.sprButtonLevel.getHeight() >> 4;
        if (MainCanvas.WIDTH < 360 || MainCanvas.HEIGHT < 640) {
            iShiftTextY = MainCanvas.WIDTH >= 176 && MainCanvas.HEIGHT >= 220 ? (iShiftTextY += this.sprButtonLevel.getHeight() >> 5) : (iShiftTextY += this.sprButtonLevel.getHeight() >> 4);
        }
        for (int i = 0; i < 16; ++i) {
            int pom = i + this.iPage * 16;
            if (pom == this.level && !this.levelsLocked[pom]) {
                this.paintLevelButton(g, this.rectLevelTiles[i].x, this.rectLevelTiles[i].y, 1, 3, this.medals[pom] >= 0);
            } else if (pom == this.level && this.levelsLocked[pom]) {
                this.paintLevelButton(g, this.rectLevelTiles[i].x, this.rectLevelTiles[i].y, 1, 2, false);
            } else if (this.levelsLocked[pom]) {
                this.paintLevelButton(g, this.rectLevelTiles[i].x, this.rectLevelTiles[i].y, 0, 2, false);
            } else {
                this.paintLevelButton(g, this.rectLevelTiles[i].x, this.rectLevelTiles[i].y, 0, 3, this.medals[pom] >= 0);
            }
            if (this.medals[pom] < 0) {
                if (!this.levelsLocked[pom]) {
                    this.fontMainWhite.drawString(g, (pom + 1 + "").toCharArray(), this.rectLevelTiles[i].getCenterX(), this.rectLevelTiles[i].getCenterY() - (this.fontMainWhite.getHeight() >> 1) - iShiftTextY, 17);
                    continue;
                }
                this.fontMainDark.drawString(g, (pom + 1 + "").toCharArray(), this.rectLevelTiles[i].getCenterX(), this.rectLevelTiles[i].getCenterY() - (this.fontMainWhite.getHeight() >> 1) - iShiftTextY, 17);
                continue;
            }
            this.sprMedals.setFrame((int)GeneralDefs.MEDALS[this.medals[pom]]);
            this.sprMedals.setPosition(this.rectLevelTiles[i].getCenterX() - (this.sprMedals.getWidth() >> 1), this.rectLevelTiles[i].getCenterY() - (this.sprMedals.getHeight() >> 1));
            this.sprMedals.paint(g);
        }
        System.out.println("--------------");
        int iCenterY = this.rectLevelTiles[0].y - (this.rectLevelTiles[0].y - (this.yPosBar + this.sprTopBg.getHeight()) >> 1) - (this.fontMainWhiteBlackBg.getHeight() >> 1);
        String sText = "3/" + this.iMaxPages;
        int iRightX = (MainCanvas.WIDTH >> 1) + (this.fontMainWhite.stringWidth(sText.toCharArray()) >> 1);
        sText = this.iPage + 1 + "/" + this.iMaxPages;
        this.fontMainWhiteBlackBg.drawString(g, sText.toCharArray(), iRightX, iCenterY, 24);
    }

    public void paintLevelButton(Graphics g, int x, int y, int id1, int id2, boolean bMedal) {
        boolean bOk = true;
        if (id1 == 1 && !this.bShowedPaintLevel) {
            bOk = false;
        }
        if (bOk) {
            this.sprButtonLevel.setFrame(0);
        } else {
            this.sprButtonLevel.setFrame(1);
        }
        this.sprButtonLevel.setPosition(x, y);
        this.sprButtonLevel.paint(g);
    }

    public void paintArrows(Graphics g) {
        switch (this.screen) {
            case 6: {
                if (this.iPage > 0) {
                    this.sprArrows.setFrame(0);
                    this.sprArrows.setPosition(this.rectArrows[0].x, this.rectArrows[0].y);
                    this.sprArrows.paint(g);
                }
                if (this.iPage >= this.iMaxPages - 1) break;
                this.sprArrows.setFrame(1);
                this.sprArrows.setPosition(this.rectArrows[1].x, this.rectArrows[1].y);
                this.sprArrows.paint(g);
                break;
            }
        }
    }

    public void paintControls(Graphics g) {
        switch (this.screen) {
            case 0: {
                this.paintControl(g, 0, 6);
                this.paintControl(g, 1, 7);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                this.paintControl(g, 0, 6);
                this.paintControl(g, 1, 2);
                break;
            }
            case 3: 
            case 4: {
                this.paintControl(g, 1, 2);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                this.paintControl(g, 0, 6);
                this.paintControl(g, 1, 3);
                break;
            }
        }
    }

    public void paintControl(Graphics g, int id, int iconFrame) {
        this.sprButtonIcons.setFrame(0);
        this.sprButtonIcons.setPosition(this.rectControls[id].x, this.rectControls[id].y);
        this.sprButtonIcons.paint(g);
        if (this.bPressedControl[id]) {
            this.sprButtonIcons.setFrame(1);
        } else {
            this.sprButtonIcons.setFrame(0);
        }
        this.sprButtonIcons.setPosition(this.rectControls[id].x, this.rectControls[id].y);
        this.sprButtonIcons.paint(g);
        if (this.bPressedControl[id]) {
            this.sprIcons.setFrame(iconFrame + 11);
        } else {
            this.sprIcons.setFrame(iconFrame);
        }
        this.sprIcons.setPosition(this.rectControls[id].getCenterX() - (this.sprIcons.getWidth() >> 1), this.rectControls[id].getCenterY() - (this.sprIcons.getHeight() >> 1));
        this.sprIcons.paint(g);
    }

    public void keyPressed(int keyCode) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        if (this.bContinue) {
            if (!this.mainCanvas.isInterrupted() && (Keys.isActionPressed(5) || Keys.isKeyPressed(-6))) {
                MainCanvas.soundManager.Stop();
                MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
                this.calculatePositions();
                this.bContinue = false;
            }
            return;
        }
        if (!this.isLoading && this.loadingCounter == 0 && this.nextScreenStep <= 0) {
            switch (this.screen) {
                case 0: 
                case 1: 
                case 2: 
                case 7: {
                    if (Keys.isActionPressed(2)) {
                        this.down();
                    }
                    if (Keys.isActionPressed(1)) {
                        this.up();
                    }
                    if (Keys.isActionPressed(5) || Keys.isKeyPressed(-6)) {
                        this.bPressedControl[0] = true;
                        this.confirm();
                    }
                    if (!Keys.isKeyPressed(-7)) break;
                    this.bPressedControl[1] = true;
                    this.back();
                    break;
                }
                case 6: {
                    if (Keys.isActionPressed(3)) {
                        this.levelLeft();
                    }
                    if (Keys.isActionPressed(4)) {
                        this.levelRight();
                    }
                    if (Keys.isActionPressed(2)) {
                        this.levelDown();
                    }
                    if (Keys.isActionPressed(1)) {
                        this.levelUp();
                    }
                    if (Keys.isActionPressed(5) || Keys.isKeyPressed(-6)) {
                        this.bPressedControl[0] = true;
                        this.confirm();
                    }
                    if (!Keys.isKeyPressed(-7)) break;
                    this.bPressedControl[1] = true;
                    this.back();
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    if (Keys.isKeyPressed(-6)) {
                        this.bPressedControl[0] = true;
                        this.confirm();
                    }
                    if (!Keys.isKeyPressed(-7)) break;
                    this.bPressedControl[1] = true;
                    this.back();
                    break;
                }
                case 3: 
                case 4: {
                    if (!Keys.isKeyPressed(-7)) break;
                    this.bPressedControl[1] = true;
                    this.back();
                    break;
                }
                case 5: {
                    if (Keys.isKeyPressed(-6)) {
                        this.bPressedControl[0] = true;
                        this.bQuit = true;
                        this.nextScreen(this.screen, this.selectedItem);
                    }
                    if (!Keys.isKeyPressed(-7)) break;
                    this.bPressedControl[1] = true;
                    this.back();
                    break;
                }
            }
        }
    }

    public void updatePage() {
        this.iPage = this.level / 16;
        this.iUpdateCounterPaintLevel = 0;
        this.bShowedPaintLevel = true;
    }

    public void levelLeft() {
        if (this.level > 0) {
            --this.level;
            this.updatePage();
        }
    }

    public void levelRight() {
        if (this.level < 47) {
            ++this.level;
            this.updatePage();
        }
    }

    public void levelDown() {
        if (this.level < 47) {
            this.level += 4;
            if (this.level > 47) {
                this.level = 47;
            }
            this.updatePage();
        }
    }

    public void levelUp() {
        if (this.level > 0) {
            this.level -= 4;
            if (this.level < 0) {
                this.level = 0;
            }
            this.updatePage();
        }
    }

    public void keyReleased(int keyCode) {
        switch (this.screen) {
            case 3: {
                if (Keys.isActionPressed(1)) {
                    this.preparedTextInfo.setTextOffsetY(this.preparedTextInfo.getTextOffsetY() - (this.fontMainWhiteSmall.getHeight() >> 1));
                    break;
                }
                if (!Keys.isActionPressed(2)) break;
                int textOffsetY = this.preparedTextInfo.getTextOffsetY() + this.fontMainWhiteSmall.getHeight();
                int maxOffsetY = this.preparedTextInfo.getTextHeight() - this.rectInfo.height;
                if (maxOffsetY < 0) {
                    maxOffsetY = 0;
                }
                if (textOffsetY > maxOffsetY) {
                    textOffsetY = maxOffsetY;
                }
                this.preparedTextInfo.setTextOffsetY(textOffsetY);
                break;
            }
        }
        if (this.screen == 6 && this.bPressedControl[0]) {
            this.bPressedControl[0] = false;
        }
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void afterHide() {
        Resources.freeAllResources();
        MainCanvas.soundManager.Stop();
    }

    public void beforeShow() {
        this.isLoading = true;
        Resources.loadText(0);
        Resources.loadGFonts(new int[]{0, 1, 2, 3, 4});
        this.fontMainWhite = Resources.resGFonts[0];
        this.fontMainWhiteSmall = Resources.resGFonts[1];
        this.fontMainDark = Resources.resGFonts[2];
        this.fontMainWhiteBlackBg = Resources.resGFonts[3];
        this.fontMainWhiteBlackBgSmall = Resources.resGFonts[4];
        Resources.loadImages(new int[]{3, 2, 1, 6, 7});
        this.imgBg = Resources.resImgs[3];
        this.imgLogo = Resources.resImgs[2];
        this.imgLogoInlogic = Resources.resImgs[1];
        this.imgAboutLogo = Resources.resImgs[7];
        this.imgScoreStar = Resources.resImgs[6];
        Resources.loadSprites(new int[]{2, 3, 4, 10, 11, 12, 13, 15, 16});
        this.sprIcons = Resources.resSprs[2];
        this.sprArrows = Resources.resSprs[3];
        this.sprMedals = Resources.resSprs[4];
        this.sprButton = Resources.resSprs[10];
        this.sprButtonIcons = Resources.resSprs[11];
        this.sprButtonActive = Resources.resSprs[12];
        this.sprDialog = Resources.resSprs[13];
        this.sprButtonLevel = Resources.resSprs[15];
        this.sprTopBg = Resources.resSprs[16];
        this.selectedItem = 0;
        this.initParameters();
        this.calculatePositions();
        if (!this.mainCanvas.isInterrupted()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
        }
        this.isLoading = false;
    }

    public void initParameters() {
        ++this.loadingCounter;
        this.swDialog = this.sprDialog.getWidth();
        this.xDialog = (MainCanvas.WIDTH >> 1) - 7 * this.swDialog - (this.swDialog >> 1);
        this.yDialog = (MainCanvas.HEIGHT >> 1) - (this.sprDialog.getHeight() << 3) + (this.sprDialog.getHeight() << 2) + this.sprDialog.getHeight();
        this.wDialog = 14 * this.swDialog;
        this.hDialog = 14;
        if (MainCanvas.HEIGHT >= 480 && MainCanvas.WIDTH >= 480) {
            if (MainCanvas.WIDTH == 640) {
                this.yDialog -= (this.sprDialog.getHeight() >> 1) + (this.sprDialog.getHeight() >> 2);
                ++this.hDialog;
            }
            this.yDialog += (this.sprDialog.getHeight() >> 2) + (this.sprDialog.getHeight() >> 2);
            this.hDialog -= 2;
            this.xDialog += this.swDialog;
            this.wDialog -= this.swDialog << 1;
        } else if (MainCanvas.HEIGHT >= 360 && MainCanvas.WIDTH >= 352 && MainCanvas.HEIGHT != 400) {
            if (MainCanvas.HEIGHT == 416) {
                this.xDialog += this.swDialog;
                this.wDialog -= this.swDialog << 1;
                this.yDialog += (this.sprDialog.getHeight() >> 1) - (this.sprDialog.getHeight() >> 2);
                --this.hDialog;
            } else if (MainCanvas.HEIGHT == 480) {
                this.xDialog += this.swDialog;
                this.wDialog -= this.swDialog << 1;
                this.hDialog -= 2;
            }
            this.yDialog -= this.sprDialog.getHeight() >> 1;
        } else if (MainCanvas.HEIGHT >= 320 && MainCanvas.WIDTH >= 320) {
            this.hDialog -= 2;
            this.xDialog += this.swDialog + (this.swDialog >> 1);
            this.wDialog -= (this.swDialog << 1) + this.swDialog;
            this.yDialog -= this.sprDialog.getHeight() >> 1;
        } else if (MainCanvas.HEIGHT >= 224 && MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT != 260) {
            if (MainCanvas.HEIGHT == 224) {
                this.xDialog -= this.swDialog >> 1;
                this.wDialog += this.swDialog;
                this.yDialog -= this.sprDialog.getHeight();
            } else if (MainCanvas.HEIGHT >= 290 && MainCanvas.HEIGHT <= 310 && MainCanvas.WIDTH == 240) {
                this.xDialog -= this.swDialog;
                this.wDialog += this.swDialog << 1;
                ++this.hDialog;
                this.yDialog -= (this.sprDialog.getHeight() << 1) - (this.sprDialog.getHeight() >> 2);
            } else if (MainCanvas.HEIGHT == 240 && MainCanvas.WIDTH == 320) {
                this.xDialog -= this.swDialog;
                this.wDialog += this.swDialog << 1;
                this.yDialog -= this.sprDialog.getHeight();
            } else if (MainCanvas.HEIGHT == 320 && MainCanvas.WIDTH == 240) {
                this.xDialog += this.swDialog;
                this.wDialog -= this.swDialog << 1;
                --this.hDialog;
            } else if ((MainCanvas.HEIGHT == 348 || MainCanvas.HEIGHT == 400 || MainCanvas.HEIGHT == 432) && MainCanvas.WIDTH == 240) {
                this.hDialog -= 2;
                this.wDialog -= this.swDialog << 1;
                this.xDialog += this.swDialog;
                this.yDialog += this.sprDialog.getHeight() >> 2;
            } else if (MainCanvas.HEIGHT == 287) {
                this.yDialog -= (this.sprDialog.getHeight() >> 1) + this.sprDialog.getHeight();
            } else {
                this.hDialog -= 2;
                this.wDialog -= this.swDialog << 1;
                this.xDialog += this.swDialog << 1;
            }
        } else if (MainCanvas.HEIGHT >= 176 && MainCanvas.WIDTH >= 176) {
            this.yDialog -= this.sprDialog.getHeight() >> 1;
            if (MainCanvas.WIDTH == 220) {
                this.wDialog -= this.swDialog << 2;
                this.xDialog += this.swDialog << 1;
                this.hDialog -= 4;
                if (MainCanvas.HEIGHT == 205) {
                    this.xDialog -= this.swDialog << 1;
                    this.wDialog += this.swDialog << 2;
                    this.hDialog += 3;
                }
            } else {
                this.hDialog = 15;
                this.wDialog += this.swDialog << 1;
                this.xDialog -= this.swDialog;
            }
        } else if (MainCanvas.HEIGHT < 176 && MainCanvas.WIDTH < 176) {
            this.yDialog += this.sprDialog.getHeight() >> 1;
            this.hDialog = 9;
            this.wDialog -= this.swDialog << 2;
            this.xDialog += this.swDialog << 1;
        }
        if (MainCanvas.HEIGHT < 640 && MainCanvas.WIDTH < 480) {
            ++this.hDialog;
            this.wDialog += this.swDialog << 1;
            this.xDialog -= this.swDialog;
        }
        this.swBar = this.sprTopBg.getWidth();
        this.xBar = (MainCanvas.WIDTH >> 1) - 10 * this.swBar;
        this.yBar = this.sprTopBg.getHeight();
        this.wBar = 19 * this.swBar;
        this.yPosBar = 0;
        if (!(MainCanvas.HEIGHT >= 480 && MainCanvas.WIDTH >= 480 || MainCanvas.HEIGHT >= 360 && MainCanvas.WIDTH >= 352 && MainCanvas.HEIGHT != 400 || MainCanvas.HEIGHT >= 320 && MainCanvas.WIDTH >= 320)) {
            if (MainCanvas.HEIGHT >= 224 && MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT != 260) {
                this.yBar -= this.yBar >> 1;
            } else if (MainCanvas.HEIGHT >= 176 && MainCanvas.WIDTH >= 176) {
                if (MainCanvas.WIDTH == 220) {
                    this.yBar -= this.yBar >> 1;
                }
                this.yBar -= this.yBar >> 1;
            } else if (MainCanvas.HEIGHT < 176 && MainCanvas.WIDTH < 176) {
                this.xBar += this.swBar << 1;
                this.wBar -= this.swBar << 2;
                this.yBar -= this.sprTopBg.getHeight() >> 1;
            }
        }
        this.yPosBar = this.yBar;
        this.iLogoY = this.imgLogo.getHeight() >> 5;
        if (this.iLogoY < 1) {
            this.iLogoY = 1;
        }
        this.iBookedSpaceY = this.iLogoY + this.imgLogo.getHeight();
        this.iDialogCenterY = this.iBookedSpaceY + (MainCanvas.HEIGHT - this.iBookedSpaceY - this.sprButtonIcons.getHeight() >> 1);
        int iControlsX = this.sprButtonIcons.getWidth() >> 1;
        int iControlsY = MainCanvas.HEIGHT - (this.sprButtonIcons.getHeight() >> 1) - this.sprButtonIcons.getHeight();
        if (MainCanvas.HEIGHT < 480) {
            iControlsY = MainCanvas.HEIGHT - this.sprButtonIcons.getHeight() - (this.sprButtonIcons.getHeight() >> 2);
            iControlsX = this.sprButtonIcons.getWidth() >> 2;
        }
        this.rectControls = new Rectangle[2];
        this.rectControls[0] = new Rectangle(iControlsX, iControlsY, this.sprButtonIcons.getWidth(), this.sprButtonIcons.getHeight());
        this.rectControls[1] = new Rectangle(MainCanvas.WIDTH - this.sprButtonIcons.getWidth() - iControlsX, iControlsY, this.sprButtonIcons.getWidth(), this.sprButtonIcons.getHeight());
        int iOptionsY = MainCanvas.HEIGHT - (this.sprButtonIcons.getHeight() >> 1) - this.sprButtonIcons.getHeight();
        this.rectOptions = new Rectangle[2];
        this.rectOptions[0] = new Rectangle(MainCanvas.WIDTH >> 2, iOptionsY, this.sprButtonIcons.getWidth(), this.sprButtonIcons.getHeight());
        this.rectOptions[1] = new Rectangle(MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2) - this.sprButtonIcons.getWidth(), iOptionsY, this.sprButtonIcons.getWidth(), this.sprButtonIcons.getHeight());
        this.iDialogMaxWidth = this.wDialog;
        if (MainCanvas.WIDTH < 320 || MainCanvas.HEIGHT < 480) {
            this.iDialogMaxWidth -= this.sprDialog.getWidth() * 13 * 100 / 380 >> 2;
        }
        this.iDialogMaxHeight = 15 * this.sprDialog.getHeight();
        if (MainCanvas.HEIGHT == 320 && MainCanvas.WIDTH == 240) {
            this.iDialogMaxHeight -= this.sprDialog.getHeight() << 1;
        } else if (MainCanvas.HEIGHT == 220 && MainCanvas.WIDTH == 176) {
            this.iDialogMaxHeight += this.sprDialog.getHeight() << 1;
        } else if (MainCanvas.HEIGHT == 160 && MainCanvas.WIDTH == 128) {
            this.iDialogMaxHeight -= this.sprDialog.getHeight() << 2;
        }
        this.rectDialog = new Rectangle((MainCanvas.WIDTH >> 1) - (this.sprDialog.getWidth() * 16 >> 1), this.iDialogCenterY - (17 * this.sprDialog.getHeight() >> 1), this.sprDialog.getWidth() * 15, 17 * this.sprDialog.getHeight());
        this.iTopYIn = 0;
        this.iTopY = this.iTopYOut = -this.sprTopBg.getHeight();
        this.iScrollerWidth = this.fontMainWhite.getSpaceWidth() - (this.fontMainWhite.getSpaceWidth() >> 2);
        if (this.iScrollerWidth < 4) {
            this.iScrollerWidth = 4;
        }
        this.deactivatePressedControls();
        this.iLogoY = this.yDialog >> 1;
        this.initMenuDialog();
        this.initMenuBtns();
        --this.loadingCounter;
    }

    public void calculatePositions() {
        ++this.loadingCounter;
        this.str = new String[5];
        switch (this.screen) {
            case 0: {
                this.str[0] = Resources.resTexts[0].getHashedString(6);
                this.str[1] = Resources.resTexts[0].getHashedString(11);
                this.str[1] = Settings.bMusic ? this.str[1] + " " + Resources.resTexts[0].getHashedString(18) : this.str[1] + " " + Resources.resTexts[0].getHashedString(19);
                this.str[2] = Resources.resTexts[0].getHashedString(8);
                this.str[3] = Resources.resTexts[0].getHashedString(9);
                break;
            }
            case 1: {
                this.str = new String[4];
                this.str[0] = Resources.resTexts[0].getHashedString(30);
                this.str[1] = Resources.resTexts[0].getHashedString(31);
                this.str[2] = Resources.resTexts[0].getHashedString(32);
                this.str[3] = Resources.resTexts[0].getHashedString(33);
                break;
            }
            case 2: {
                this.str[1] = Resources.resTexts[0].getHashedString(11);
                this.str[1] = Resources.resTexts[0].getHashedString(14);
                if (Settings.bMusic) {
                    this.str[1] = this.str[1] + " " + Resources.resTexts[0].getHashedString(18);
                    break;
                }
                this.str[1] = this.str[1] + " " + Resources.resTexts[0].getHashedString(19);
                break;
            }
            case 7: {
                this.str[0] = Resources.resTexts[0].getHashedString(132);
                this.str[1] = Resources.resTexts[0].getHashedString(135);
                this.str[2] = Resources.resTexts[0].getHashedString(11);
                this.str[3] = Resources.resTexts[0].getHashedString(15);
                if (Settings.bMusic) {
                    this.str[2] = this.str[2] + " " + Resources.resTexts[0].getHashedString(18);
                    break;
                }
                this.str[2] = this.str[2] + " " + Resources.resTexts[0].getHashedString(19);
                break;
            }
            case 6: {
                this.str[4] = Resources.resTexts[0].getHashedString(137);
                this.calculatePositionsSelectLevel();
                this.loadLevels();
                this.updatePage();
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                this.str[4] = Resources.resTexts[0].getHashedString(137);
                switch (this.screen) {
                    case 8: {
                        this.str[0] = Resources.resTexts[0].getHashedString(134);
                        break;
                    }
                    case 5: {
                        this.str[0] = Resources.resTexts[0].getHashedString(2);
                        break;
                    }
                    case 9: {
                        this.str[0] = Resources.resTexts[0].getHashedString(16);
                        break;
                    }
                    case 10: {
                        this.str[0] = Resources.resTexts[0].getHashedString(136);
                        break;
                    }
                }
                this.preparedTextInfo = new PreparedText(this.fontMainWhiteBlackBg);
                this.preparedTextInfo.prepareText(this.str[0], this.sprDialog.getWidth() * 6 << 1);
                this.preparedTextInfo.setTextOffsetY(this.preparedTextInfo.getTextHeight() >> 1);
                int iDialogHeight = this.sprDialog.getHeight() * this.hDialog;
                int x = this.xDialog + (this.swDialog >> 1);
                int y = this.yDialog + this.swDialog;
                if (MainCanvas.HEIGHT >= 224 && MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT != 260) {
                    x += this.swDialog >> 1;
                }
                if (MainCanvas.HEIGHT <= 220) {
                    x += this.swDialog >> 1;
                }
                if (MainCanvas.HEIGHT >= 480 || MainCanvas.HEIGHT >= 480) {
                    x -= this.swDialog >> 1;
                }
                this.rectInfo = new Rectangle(x, y, this.iDialogMaxWidth, iDialogHeight);
                break;
            }
            case 3: {
                this.str[0] = Resources.resTexts[0].getHashedString(105) + "\n\n\n";
                this.str[0] = this.str[0] + Resources.resTexts[0].getHashedString(106) + " 144 " + Resources.resTexts[0].getHashedString(1060) + "\n\n\n";
                this.str[0] = this.str[0] + Resources.resTexts[0].getHashedString(107);
                int iWidth = this.wDialog - (this.iScrollerWidth << 1);
                int iHeight = this.sprDialog.getHeight() * (this.hDialog + 1) - (this.sprDialog.getHeight() >> 1);
                int iX = this.xDialog + this.swDialog + (this.swDialog >> 1);
                int iY = this.yDialog + (this.sprDialog.getHeight() >> 1);
                if (!(MainCanvas.HEIGHT >= 480 && MainCanvas.WIDTH >= 480 || MainCanvas.HEIGHT >= 360 && MainCanvas.WIDTH >= 352 && MainCanvas.HEIGHT != 400)) {
                    if (MainCanvas.HEIGHT >= 320 && MainCanvas.WIDTH >= 320) {
                        iWidth += this.iScrollerWidth;
                    } else if (MainCanvas.HEIGHT >= 224 && MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT != 260) {
                        iWidth += this.iScrollerWidth;
                        if (MainCanvas.HEIGHT == 287 || MainCanvas.HEIGHT == 224) {
                            iX += this.swDialog >> 1;
                            iY += this.sprDialog.getHeight() >> 1;
                            iWidth -= this.swDialog >> 1;
                            iHeight -= this.sprDialog.getHeight() >> 2;
                        }
                        if (MainCanvas.HEIGHT >= 290 && MainCanvas.HEIGHT <= 310 && MainCanvas.WIDTH == 240) {
                            iX += this.swDialog >> 1;
                            iY += this.sprDialog.getHeight() >> 1;
                            iWidth -= this.iScrollerWidth;
                            iHeight -= this.sprDialog.getHeight() >> 2;
                        } else if (MainCanvas.HEIGHT == 240 && MainCanvas.WIDTH == 320) {
                            iX += this.swDialog >> 1;
                            iY += this.sprDialog.getHeight() >> 1;
                            iWidth -= this.iScrollerWidth;
                            iHeight -= this.sprDialog.getHeight() >> 2;
                        }
                    } else if (MainCanvas.HEIGHT >= 176 && MainCanvas.WIDTH >= 176) {
                        if (MainCanvas.HEIGHT == 220 || MainCanvas.HEIGHT <= 208 && MainCanvas.HEIGHT >= 200 || MainCanvas.WIDTH == 220) {
                            iX += this.swDialog >> 1;
                            iY += this.sprDialog.getHeight() >> 1;
                            iHeight -= this.sprDialog.getHeight() >> 2;
                        }
                    } else if (MainCanvas.HEIGHT < 176 && MainCanvas.WIDTH < 176) {
                        iX += this.swDialog >> 1;
                        iY += this.sprDialog.getHeight() >> 1;
                    }
                }
                this.preparedTextInfo = new PreparedText(this.fontMainWhiteBlackBgSmall);
                this.preparedTextInfo.prepareText(this.str[0], iWidth);
                this.rectInstr = new Rectangle(iX - this.sprDialog.getWidth(), iY + (this.imgLogo.getHeight() >> 2) - this.sprButton.getHeight(), iWidth, iHeight);
                this.infoSizeSet = true;
                break;
            }
            case 4: {
                this.str[0] = X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + "\n" + Resources.resTexts[0].getHashedString(20) + " " + X.singleton.getAppProperty("MIDlet-Version").toUpperCase();
                int width = this.rectMenuDialog.width - (this.sprButton.getWidth() << 1);
                int height = this.fontMainWhiteBlackBgSmall.getHeight() * 3;
                int xRect = (MainCanvas.WIDTH >> 1) - (width >> 1);
                int yRect = this.rectMenuDialog.getCenterY() + (this.rectMenuDialog.height >> 2) - (height >> 1);
                this.rectInfo = new Rectangle(xRect, yRect, width, height);
                this.preparedTextInfo = new PreparedText(this.fontMainWhiteBlackBgSmall);
                this.preparedTextInfo.prepareText(this.str[0], this.rectInfo.width);
                break;
            }
        }
        --this.loadingCounter;
    }

    public void down() {
        if (this.nextScreenStep <= 0) {
            switch (this.screen) {
                case 0: {
                    this.selectedItem = (this.selectedItem + 1) % 4;
                    break;
                }
                case 1: {
                    this.selectedItem = (this.selectedItem + 1) % 4;
                    break;
                }
                case 7: {
                    this.selectedItem = (this.selectedItem + 1) % 4;
                    break;
                }
                case 2: {
                    if (this.isFromMainMenu) {
                        this.selectedItem = (this.selectedItem + 1) % 2;
                        break;
                    }
                    this.selectedItem = (this.selectedItem + 1) % 1;
                    break;
                }
            }
        }
    }

    public void up() {
        if (this.nextScreenStep <= 0) {
            switch (this.screen) {
                case 0: {
                    if (this.selectedItem > 0) {
                        --this.selectedItem;
                        break;
                    }
                    this.selectedItem = 3;
                    break;
                }
                case 1: {
                    if (this.selectedItem > 0) {
                        --this.selectedItem;
                        break;
                    }
                    this.selectedItem = 3;
                    break;
                }
                case 7: {
                    if (this.selectedItem > 0) {
                        --this.selectedItem;
                        break;
                    }
                    this.selectedItem = 3;
                    break;
                }
                case 2: {
                    if (this.selectedItem > 0) {
                        --this.selectedItem;
                        break;
                    }
                    if (this.isFromMainMenu) {
                        this.selectedItem = 1;
                        break;
                    }
                    this.selectedItem = 0;
                    break;
                }
            }
        }
    }

    public void back() {
        block0 : switch (this.screen) {
            case 0: {
                this.nextScreen(5, this.selectedItem);
                break;
            }
            case 1: {
                this.nextScreen(0, 0);
                break;
            }
            case 6: {
                switch (this.gameMode) {
                    case 0: {
                        this.nextScreen(1, 0);
                        break block0;
                    }
                    case 1: {
                        this.nextScreen(1, 1);
                        break block0;
                    }
                    case 2: {
                        this.nextScreen(1, 2);
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                this.bNewStonesArrangement = false;
                switch (this.gameMode) {
                    case 0: {
                        this.nextScreen(11, this.selectedItem);
                        break;
                    }
                    case 1: {
                        this.nextScreen(12, this.selectedItem);
                        break;
                    }
                    case 2: {
                        this.nextScreen(13, this.selectedItem);
                        break;
                    }
                    case 3: {
                        this.nextScreen(14, this.selectedItem);
                        break;
                    }
                }
                this.mainCanvas.repaint();
                break;
            }
            case 3: {
                this.nextScreen(0, 2);
                break;
            }
            case 4: {
                this.nextScreen(0, 3);
                break;
            }
            case 8: {
                this.nextScreen(2, this.selectedItem);
                break;
            }
            case 5: {
                this.nextScreen(0, this.selectedItem);
                break;
            }
            case 9: {
                this.nextScreen(7, 3);
                break;
            }
            case 10: {
                this.nextScreen(7, 1);
                break;
            }
        }
    }

    public void calculatePositionsSelectLevel() {
        this.rectLevelTiles = new Rectangle[16];
        this.levelsLocked = new boolean[48];
        this.scores = new int[48];
        this.medals = new int[48];
        this.iMaxPages = 3;
        int iLabelHeight = this.fontMainWhite.getHeight() << 1;
        this.spaceXLevelTiles = this.sprButtonIcons.getWidth() >> 2;
        this.spaceYLevelTiles = this.sprButtonIcons.getHeight() >> 2;
        if (this.spaceXLevelTiles < 1) {
            this.spaceXLevelTiles = 1;
        }
        if (this.spaceYLevelTiles < 1) {
            this.spaceYLevelTiles = 1;
        }
        int levelTilesWidth = 4 * this.sprButtonLevel.getWidth() + 3 * this.spaceXLevelTiles;
        this.levelTilesHeight = 4 * this.sprButtonLevel.getHeight() + 3 * this.spaceYLevelTiles;
        this.levelTilesX = (MainCanvas.WIDTH >> 1) - (levelTilesWidth >> 1);
        this.levelTilesY = iLabelHeight + (MainCanvas.HEIGHT - this.levelTilesHeight - iLabelHeight - this.sprButtonLevel.getHeight() >> 1);
        if (this.isSmallAspectRatio()) {
            this.levelTilesY += this.sprButtonLevel.getHeight() >> 2;
        }
        int x = 0;
        int y = 0;
        int width = this.sprButtonLevel.getWidth();
        int height = this.sprButtonLevel.getHeight();
        for (int i = 0; i < 16; ++i) {
            x = this.levelTilesX + i % 4 * (this.sprButtonLevel.getWidth() + this.spaceXLevelTiles);
            y = this.levelTilesY + i / 4 * (this.sprButtonLevel.getHeight() + this.spaceYLevelTiles) + (this.sprButtonLevel.getHeight() >> 1);
            this.rectLevelTiles[i] = new Rectangle(x, y, width, height);
        }
        width = this.sprArrows.getWidth();
        height = this.sprArrows.getHeight();
        int iArrowX = (this.levelTilesX >> 1) - (width >> 2);
        if (MainCanvas.WIDTH >= 240 && MainCanvas.HEIGHT >= 320) {
            iArrowX -= width >> 2;
        }
        if (iArrowX < 1) {
            iArrowX = 1;
        }
        int iArrowY = this.levelTilesY + (this.levelTilesHeight >> 1) - (height >> 1);
        this.rectArrows[0] = new Rectangle(iArrowX, iArrowY + (this.sprButtonLevel.getHeight() >> 1), width, height);
        this.rectArrows[1] = new Rectangle(MainCanvas.WIDTH - width - iArrowX, iArrowY + (this.sprButtonLevel.getHeight() >> 1), width, height);
    }

    public void nextPage() {
        if (this.iPage < this.iMaxPages - 1) {
            ++this.iPage;
        }
    }

    public void previousPage() {
        if (this.iPage > 0) {
            --this.iPage;
        }
    }

    public void confirm() {
        block0 : switch (this.screen) {
            case 0: {
                switch (this.selectedItem) {
                    case 0: {
                        this.nextScreen(1, 0);
                        break block0;
                    }
                    case 1: {
                        this.isFromMainMenu = true;
                        this.bChangeSound = true;
                        this.nextScreen(this.screen, this.selectedItem);
                        break block0;
                    }
                    case 2: {
                        this.isFromMainMenu = true;
                        this.nextScreen(3, this.selectedItem);
                        break block0;
                    }
                    case 3: {
                        this.isFromMainMenu = true;
                        this.nextScreen(4, this.selectedItem);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.selectedItem) {
                    case 0: {
                        System.out.println("EASY");
                        this.gameMode = 0;
                        this.nextScreen(6, this.selectedItem);
                        break block0;
                    }
                    case 1: {
                        System.out.println("MEDIUM");
                        this.gameMode = 1;
                        this.nextScreen(6, this.selectedItem);
                        break block0;
                    }
                    case 2: {
                        System.out.println("HARD");
                        this.gameMode = 2;
                        this.nextScreen(6, this.selectedItem);
                        break block0;
                    }
                    case 3: {
                        System.out.println("TUTORIAL");
                        this.gameMode = 3;
                        this.deleteSavedGame(this.gameMode);
                        this.nextScreen(14, this.selectedItem);
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                if (this.levelsLocked[this.level]) break;
                this.deleteSavedGame(this.gameMode);
                this.bNewStonesArrangement = true;
                switch (this.gameMode) {
                    case 0: {
                        this.nextScreen(11, this.selectedItem);
                        break;
                    }
                    case 1: {
                        this.nextScreen(12, this.selectedItem);
                        break;
                    }
                    case 2: {
                        this.nextScreen(13, this.selectedItem);
                        break;
                    }
                    case 3: {
                        this.nextScreen(14, this.selectedItem);
                        break;
                    }
                }
                this.loading = true;
                break;
            }
            case 7: {
                switch (this.selectedItem) {
                    case 0: {
                        this.back();
                        break block0;
                    }
                    case 1: {
                        this.nextScreen(10, this.selectedItem);
                        break block0;
                    }
                    case 2: {
                        this.bChangeSound = true;
                        this.nextScreen(this.screen, this.selectedItem);
                        break block0;
                    }
                    case 3: {
                        this.nextScreen(9, this.selectedItem);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.selectedItem) {
                    case 0: {
                        this.bChangeSound = true;
                        this.nextScreen(this.screen, this.selectedItem);
                        break block0;
                    }
                    case 1: {
                        this.nextScreen(8, this.selectedItem);
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                this.reset();
                break;
            }
            case 5: {
                this.bQuit = true;
                this.nextScreen(this.screen, this.selectedItem);
                break;
            }
            case 9: {
                this.deleteSavedGame(this.gameMode);
                this.nextScreen(0, 0);
                break;
            }
            case 10: {
                this.loading = true;
                this.deleteSavedGame(this.gameMode);
                this.bNewStonesArrangement = true;
                switch (this.gameMode) {
                    case 0: {
                        this.nextScreen(11, this.selectedItem);
                        break block0;
                    }
                    case 1: {
                        this.nextScreen(12, this.selectedItem);
                        break block0;
                    }
                    case 2: {
                        this.nextScreen(13, this.selectedItem);
                        break block0;
                    }
                    case 3: {
                        this.nextScreen(14, this.selectedItem);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void changeSound() {
        if (!Settings.bMusic) {
            this.soundOn();
        } else {
            this.soundOff();
        }
        int id = 1;
        if (!this.isFromMainMenu) {
            id = 2;
        }
        this.str[id] = Resources.resTexts[0].getHashedString(11);
        if (Settings.bMusic) {
            int n = id;
            this.str[n] = this.str[n] + " " + Resources.resTexts[0].getHashedString(18);
        } else {
            int n = id;
            this.str[n] = this.str[n] + " " + Resources.resTexts[0].getHashedString(19);
        }
    }

    public void beforeInteruption() {
        MainCanvas.soundManager.Stop();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.bContinue = true;
    }

    public void afterInteruption() {
        if (!this.mainCanvas.isInterrupted()) {
            // empty if block
        }
    }

    public void soundOn() {
        if (!Settings.bMusic) {
            Settings.bMusic = true;
            MainCanvas.soundManager.SetSoundOn(true);
            MainCanvas.soundManager.SetMusicOn(true);
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
        }
    }

    public void soundOff() {
        if (Settings.bMusic) {
            Settings.bMusic = false;
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.SetSoundOn(false);
            MainCanvas.soundManager.SetMusicOn(false);
        }
    }

    public void reset() {
        this.deleteAllScoresAndSaves();
        this.nextScreen(0, 0);
    }

    public void quit() {
        X.quitApp();
    }

    public void loadLevels() {
        int i;
        ++this.loadingCounter;
        int levelsCount = 48;
        for (i = 0; i < levelsCount; ++i) {
            this.levelsLocked[i] = false;
            this.scores[i] = 0;
            this.medals[i] = -1;
        }
        switch (this.gameMode) {
            case 0: {
                RMSObjects.createRMSConnect(5);
                if (!RMSObjects.rmsConnects[5].isExist()) {
                    RMSObjects.rmsConnects[5].create();
                }
                if (RMSObjects.rmsConnects[5].load()) {
                    for (i = 0; i < levelsCount; ++i) {
                        this.levelsLocked[i] = RMSObjects.scoresEasy.getLocked(i);
                        this.scores[i] = RMSObjects.scoresEasy.getScore(i);
                        this.medals[i] = RMSObjects.scoresEasy.getMedal(i);
                    }
                }
                RMSObjects.freeRMSConnect(5);
                break;
            }
            case 1: {
                RMSObjects.createRMSConnect(6);
                if (!RMSObjects.rmsConnects[6].isExist()) {
                    RMSObjects.rmsConnects[6].create();
                }
                if (RMSObjects.rmsConnects[6].load()) {
                    for (i = 0; i < levelsCount; ++i) {
                        this.levelsLocked[i] = RMSObjects.scoresMedium.getLocked(i);
                        this.scores[i] = RMSObjects.scoresMedium.getScore(i);
                        this.medals[i] = RMSObjects.scoresMedium.getMedal(i);
                    }
                }
                RMSObjects.freeRMSConnect(6);
                break;
            }
            case 2: {
                RMSObjects.createRMSConnect(7);
                if (!RMSObjects.rmsConnects[7].isExist()) {
                    RMSObjects.rmsConnects[7].create();
                }
                if (RMSObjects.rmsConnects[7].load()) {
                    for (i = 0; i < 48; ++i) {
                        this.levelsLocked[i] = RMSObjects.scoresHard.getLocked(i);
                        this.scores[i] = RMSObjects.scoresHard.getScore(i);
                        this.medals[i] = RMSObjects.scoresHard.getMedal(i);
                    }
                }
                RMSObjects.freeRMSConnect(7);
                break;
            }
            case 3: {
                for (i = 0; i < levelsCount; ++i) {
                    this.levelsLocked[i] = false;
                }
                break;
            }
        }
        this.levelsLocked[0] = false;
        if (this.gameMode != 3) {
            for (i = 47; i >= 0; --i) {
                if (this.levelsLocked[i]) continue;
                this.level = i;
                break;
            }
        }
        --this.loadingCounter;
    }

    public boolean isSavedLevel(int gameMode) {
        ++this.loadingCounter;
        boolean isSaved = false;
        switch (gameMode) {
            case 0: {
                RMSObjects.createRMSConnect(1);
                if (!RMSObjects.rmsConnects[1].isExist()) {
                    RMSObjects.rmsConnects[1].create();
                }
                if (RMSObjects.rmsConnects[1].load()) {
                    isSaved = RMSObjects.savedEasy.isSavedGame();
                }
                RMSObjects.freeRMSConnect(1);
                break;
            }
            case 1: {
                RMSObjects.createRMSConnect(2);
                if (!RMSObjects.rmsConnects[2].isExist()) {
                    RMSObjects.rmsConnects[2].create();
                }
                if (RMSObjects.rmsConnects[2].load()) {
                    isSaved = RMSObjects.savedMedium.isSavedGame();
                }
                RMSObjects.freeRMSConnect(2);
                break;
            }
            case 2: {
                RMSObjects.createRMSConnect(3);
                if (!RMSObjects.rmsConnects[3].isExist()) {
                    RMSObjects.rmsConnects[3].create();
                }
                if (RMSObjects.rmsConnects[3].load()) {
                    isSaved = RMSObjects.savedHard.isSavedGame();
                }
                RMSObjects.freeRMSConnect(3);
                break;
            }
            case 3: {
                RMSObjects.createRMSConnect(4);
                if (!RMSObjects.rmsConnects[4].isExist()) {
                    RMSObjects.rmsConnects[4].create();
                }
                if (RMSObjects.rmsConnects[4].load()) {
                    isSaved = RMSObjects.savedTutorial.isSavedTutorial();
                }
                RMSObjects.freeRMSConnect(4);
                break;
            }
        }
        --this.loadingCounter;
        return isSaved;
    }

    public void deleteSavedGame(int gameMode) {
        ++this.loadingCounter;
        switch (gameMode) {
            case 0: {
                RMSObjects.createRMSConnect(1);
                if (RMSObjects.rmsConnects[1].load()) {
                    RMSObjects.rmsConnects[1].delete();
                }
                RMSObjects.freeRMSConnect(1);
                break;
            }
            case 1: {
                RMSObjects.createRMSConnect(2);
                if (RMSObjects.rmsConnects[2].load()) {
                    RMSObjects.rmsConnects[2].delete();
                }
                RMSObjects.freeRMSConnect(2);
                break;
            }
            case 2: {
                RMSObjects.createRMSConnect(3);
                if (RMSObjects.rmsConnects[3].load()) {
                    RMSObjects.rmsConnects[3].delete();
                }
                RMSObjects.freeRMSConnect(3);
                break;
            }
            case 3: {
                RMSObjects.createRMSConnect(4);
                RMSObjects.rmsConnects[4].delete();
                RMSObjects.freeRMSConnect(4);
                break;
            }
        }
        --this.loadingCounter;
    }

    public void deleteSaves() {
        ++this.loadingCounter;
        RMSObjects.createRMSConnect(1);
        RMSObjects.rmsConnects[1].delete();
        RMSObjects.freeRMSConnect(1);
        RMSObjects.createRMSConnect(2);
        RMSObjects.rmsConnects[2].delete();
        RMSObjects.freeRMSConnect(2);
        RMSObjects.createRMSConnect(3);
        RMSObjects.rmsConnects[3].delete();
        RMSObjects.freeRMSConnect(3);
        RMSObjects.createRMSConnect(4);
        RMSObjects.rmsConnects[4].delete();
        RMSObjects.freeRMSConnect(4);
        --this.loadingCounter;
    }

    public void deleteScores() {
        ++this.loadingCounter;
        RMSObjects.createRMSConnect(5);
        RMSObjects.rmsConnects[5].delete();
        RMSObjects.freeRMSConnect(5);
        RMSObjects.createRMSConnect(6);
        RMSObjects.rmsConnects[6].delete();
        RMSObjects.freeRMSConnect(6);
        RMSObjects.createRMSConnect(7);
        RMSObjects.rmsConnects[7].delete();
        RMSObjects.freeRMSConnect(7);
        --this.loadingCounter;
    }

    public void initScores() {
        ++this.loadingCounter;
        RMSObjects.createRMSConnect(5);
        if (!RMSObjects.rmsConnects[5].isExist()) {
            RMSObjects.rmsConnects[5].create();
            RMSObjects.scoresEasy.initScores();
            RMSObjects.rmsConnects[5].save();
        }
        RMSObjects.freeRMSConnect(5);
        RMSObjects.createRMSConnect(6);
        if (!RMSObjects.rmsConnects[6].isExist()) {
            RMSObjects.rmsConnects[6].create();
            RMSObjects.scoresMedium.initScores();
            RMSObjects.rmsConnects[6].save();
        }
        RMSObjects.freeRMSConnect(6);
        RMSObjects.createRMSConnect(7);
        if (!RMSObjects.rmsConnects[7].isExist()) {
            RMSObjects.rmsConnects[7].create();
            RMSObjects.scoresHard.initScores();
            RMSObjects.rmsConnects[7].save();
        }
        RMSObjects.freeRMSConnect(7);
        --this.loadingCounter;
    }

    public void deleteAllScoresAndSaves() {
        this.deleteScores();
        this.initScores();
        this.deleteSavedGame(0);
        this.deleteSavedGame(1);
        this.deleteSavedGame(2);
        this.deleteSavedGame(3);
        System.out.println("ALL SCORES AND SAVES DELETED!!!");
    }

    public void initSettings() {
        if (!Settings.bSet) {
            Settings.bMusic = MainCanvas.soundManager.IsSoundOn();
            Settings.bSet = true;
        }
    }

    private void updateInstructions() {
        if (this.preparedTextInfo.getTextOffsetY() < 0) {
            this.preparedTextInfo.setTextOffsetY(0);
        }
    }

    private void paintScroller(Graphics g) {
        int lineWidth = this.iScrollerWidth >> 2;
        if (lineWidth < 1) {
            lineWidth = 1;
        }
        int iScrollerHeight = this.rectInstr.height - (lineWidth << 1);
        int iSliderHeight = iScrollerHeight >> 2;
        int iX = this.rectInstr.getRight() + (this.iScrollerWidth >> 1);
        int iY = this.rectInstr.getCenterY() - (iScrollerHeight >> 1);
        if (MainCanvas.HEIGHT == 348 || MainCanvas.HEIGHT == 432) {
            iX -= this.iScrollerWidth >> 2;
        }
        g.setColor(4137493);
        for (int i = 0; i < lineWidth; ++i) {
            g.drawRect(iX + i, iY + i, this.iScrollerWidth - (i << 1) - 1, iScrollerHeight - (i << 1) - 1);
        }
        int maxOffset = this.preparedTextInfo.getTextHeight() - this.rectInstr.height;
        if (maxOffset > 0) {
            int textOffset = this.preparedTextInfo.getTextOffsetY();
            if (textOffset < 0) {
                textOffset = 0;
            }
            int scrollOffset = textOffset * (iScrollerHeight - iSliderHeight - (lineWidth << 1)) / maxOffset;
            g.fillRect(iX, iY + lineWidth + scrollOffset, this.iScrollerWidth, iSliderHeight);
        }
    }

    private void initMenuDialog() {
        String maxText = Resources.resTexts[0].getHashedString(8);
        int textMaxWith = this.fontMainDark.stringWidth(maxText.toCharArray());
        int imgLogoBottom = this.iLogoY + (this.imgLogo.getHeight() >> 1);
        int cols = textMaxWith / this.sprDialog.getWidth() + 4;
        int rows = (MainCanvas.HEIGHT - imgLogoBottom - this.sprButton.getHeight()) / this.sprDialog.getHeight();
        if (rows > 6 * this.sprButton.getHeight() / this.sprDialog.getHeight()) {
            rows = 6 * this.sprButton.getHeight() / this.sprDialog.getHeight();
        }
        if (MainCanvas.HEIGHT < 200) {
            cols -= 2;
        }
        int width = cols * this.sprDialog.getWidth();
        int height = rows * this.sprDialog.getHeight();
        int x = (MainCanvas.WIDTH >> 1) - (width >> 1);
        int y = (MainCanvas.HEIGHT - imgLogoBottom >> 1) + imgLogoBottom - (height >> 1);
        this.rectMenuDialog = new Rectangle(x, y, width, height);
    }

    private void initMenuBtns() {
        String maxText = Resources.resTexts[0].getHashedString(8);
        int textMaxWith = this.fontMainDark.stringWidth(maxText.toCharArray());
        int col = textMaxWith / this.sprButton.getWidth() + 2;
        int width = col * this.sprButton.getWidth();
        int height = this.sprButton.getHeight();
        int x = (MainCanvas.WIDTH >> 1) - (width >> 1);
        this.rectMenu = new Rectangle[4];
        int yOffset = (this.rectMenuDialog.height - 4 * height) / 5;
        int y = this.rectMenuDialog.y + yOffset;
        int i = 0;
        while (i < 4) {
            this.rectMenu[i] = new Rectangle(x, y, width, height);
            ++i;
            y += height + yOffset;
        }
        this.rectGameMode = new Rectangle[4];
        yOffset = (this.rectMenuDialog.height - 4 * height) / 5;
        y = this.rectMenuDialog.y + yOffset;
        i = 0;
        while (i < 4) {
            this.rectGameMode[i] = new Rectangle(x, y, width, height);
            ++i;
            y += height + yOffset;
        }
        this.rectSettings = new Rectangle[2];
        yOffset = (this.rectMenuDialog.height - 2 * height) / 3;
        y = this.rectMenuDialog.y + yOffset;
        i = 0;
        while (i < 2) {
            this.rectSettings[i] = new Rectangle(x, y, width, height);
            ++i;
            y += height + yOffset;
        }
    }

    private void paintMenuDialog(Graphics g) {
        int x;
        int width = this.sprDialog.getWidth();
        int height = this.sprDialog.getHeight();
        for (x = this.rectMenuDialog.x + width; x < this.rectMenuDialog.getRight() - width; x += width) {
            this.sprDialog.setFrame(1);
            this.sprDialog.setPosition(x, this.rectMenuDialog.y);
            this.sprDialog.paint(g);
            this.sprDialog.setFrame(7);
            this.sprDialog.setPosition(x, this.rectMenuDialog.getBottom() - height);
            this.sprDialog.paint(g);
        }
        for (int y = this.rectMenuDialog.y + height; y < this.rectMenuDialog.getBottom() - height; y += height) {
            this.sprDialog.setFrame(3);
            this.sprDialog.setPosition(this.rectMenuDialog.x, y);
            this.sprDialog.paint(g);
            this.sprDialog.setFrame(5);
            this.sprDialog.setPosition(this.rectMenuDialog.getRight() - width, y);
            this.sprDialog.paint(g);
        }
        int y = this.rectMenuDialog.y + height;
        for (x = this.rectMenuDialog.x + width; (x < this.rectMenuDialog.getRight() - width || y < this.rectMenuDialog.getBottom() - height) && y != this.rectMenuDialog.getBottom() - height; x += width) {
            if (x == this.rectMenuDialog.getRight() - width) {
                x = this.rectMenuDialog.x;
                y += height;
                continue;
            }
            this.sprDialog.setFrame(4);
            this.sprDialog.setPosition(x, y);
            this.sprDialog.paint(g);
        }
        this.sprDialog.setFrame(0);
        this.sprDialog.setPosition(this.rectMenuDialog.x, this.rectMenuDialog.y);
        this.sprDialog.paint(g);
        this.sprDialog.setFrame(2);
        this.sprDialog.setPosition(this.rectMenuDialog.getRight() - width, this.rectMenuDialog.y);
        this.sprDialog.paint(g);
        this.sprDialog.setFrame(6);
        this.sprDialog.setPosition(this.rectMenuDialog.x, this.rectMenuDialog.getBottom() - height);
        this.sprDialog.paint(g);
        this.sprDialog.setFrame(8);
        this.sprDialog.setPosition(this.rectMenuDialog.getRight() - width, this.rectMenuDialog.getBottom() - height);
        this.sprDialog.paint(g);
    }

    private void paintMenuBtns(Graphics g) {
        int total = 0;
        switch (this.screen) {
            case 0: {
                total = 4;
                break;
            }
            case 1: {
                total = 4;
                break;
            }
            case 7: {
                total = 4;
                break;
            }
        }
        Sprite button = this.sprButton;
        for (int i = 0; i < total; ++i) {
            button = i == this.selectedItem ? this.sprButtonActive : this.sprButton;
            Rectangle[] rect = this.rectMenu;
            if (this.screen == 0) {
                rect = this.rectMenu;
            } else if (this.screen == 1) {
                rect = this.rectGameMode;
            }
            int y = rect[i].y;
            button.setFrame(0);
            button.setPosition(rect[i].x, y);
            button.paint(g);
            for (int x = rect[i].x + this.sprButton.getWidth(); x < rect[i].getRight() - this.sprButton.getWidth(); x += this.sprButton.getWidth()) {
                button.setFrame(1);
                button.setPosition(x, y);
                button.paint(g);
            }
            button.setFrame(2);
            button.setPosition(rect[i].getRight() - this.sprButton.getWidth(), y);
            button.paint(g);
            if (this.str[i] == null) continue;
            if (i != this.selectedItem) {
                if (MainCanvas.HEIGHT < 200) {
                    this.fontMainWhite.drawString(g, this.str[i].toCharArray(), MainCanvas.WIDTH >> 1, rect[i].getCenterY() - (this.fontMainDark.getHeight() >> 1), 17);
                    continue;
                }
                this.fontMainDark.drawString(g, this.str[i].toCharArray(), MainCanvas.WIDTH >> 1, rect[i].getCenterY() - (this.fontMainDark.getHeight() >> 1), 17);
                continue;
            }
            this.fontMainWhite.drawString(g, this.str[i].toCharArray(), MainCanvas.WIDTH >> 1, rect[i].getCenterY() - (this.fontMainWhite.getHeight() >> 1), 17);
        }
    }
}

