/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.saves;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.saves.SavedItem;

public class SavedGame
implements RMSHandler {
    public Vector savedGames = new Vector();

    public boolean isSavedGame() {
        return this.savedGames.size() > 0;
    }

    public SavedItem getSavedGame() {
        if (this.savedGames.size() > 0) {
            return (SavedItem)this.savedGames.firstElement();
        }
        return null;
    }

    public void saveGame(SavedItem gameItem) {
        if (this.savedGames.size() > 0) {
            this.savedGames.setElementAt(gameItem, 0);
        } else {
            this.savedGames.addElement(gameItem);
        }
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
        this.savedGames.removeAllElements();
        if (dis.readInt() != 0) {
            int j;
            SavedItem gameItem = new SavedItem();
            gameItem.level = dis.readInt();
            gameItem.matches = dis.readInt();
            gameItem.points = dis.readInt();
            gameItem.playedTime = dis.readInt();
            gameItem.maxTime = dis.readInt();
            gameItem.removedCursor = dis.readInt();
            gameItem.tilesCount = dis.readInt();
            gameItem.screen = dis.readInt();
            gameItem.combos = dis.readInt();
            gameItem.comboTime = dis.readInt();
            gameItem.comboMultiplier = dis.readInt();
            gameItem.resultStep = dis.readInt();
            gameItem.score = dis.readInt();
            gameItem.usedUndo = dis.readInt();
            gameItem.medal = dis.readInt();
            gameItem.showedMatches = dis.readInt();
            gameItem.showedUsedUndo = dis.readInt();
            gameItem.showedTime = dis.readInt();
            gameItem.showedTotalScore = dis.readInt();
            gameItem.showedMedal = dis.readInt();
            gameItem.tiles = new byte[gameItem.tilesCount];
            gameItem.removed = new int[gameItem.tilesCount];
            gameItem.showed = new byte[gameItem.tilesCount];
            gameItem.markedTiles = new int[2];
            gameItem.markedTilesType = new byte[2];
            gameItem.hints = new int[2];
            for (j = 0; j < gameItem.tilesCount; ++j) {
                gameItem.tiles[j] = dis.readByte();
            }
            for (j = 0; j < gameItem.tilesCount; ++j) {
                gameItem.removed[j] = dis.readInt();
            }
            for (j = 0; j < gameItem.tilesCount; ++j) {
                gameItem.showed[j] = dis.readByte();
            }
            for (j = 0; j < 2; ++j) {
                gameItem.markedTiles[j] = dis.readInt();
            }
            for (j = 0; j < 2; ++j) {
                gameItem.markedTilesType[j] = dis.readByte();
            }
            for (j = 0; j < 2; ++j) {
                gameItem.hints[j] = dis.readInt();
            }
            gameItem.isOutOfMoves = dis.readBoolean();
            gameItem.isNoSolution = dis.readBoolean();
            gameItem.isHint = dis.readBoolean();
            gameItem.isDialog = dis.readBoolean();
            gameItem.isFinished = dis.readBoolean();
            gameItem.bNewRecord = dis.readBoolean();
            gameItem.bNewRecordFlag = dis.readBoolean();
            this.savedGames.addElement(gameItem);
        }
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
        int j;
        SavedItem gameItem = (SavedItem)this.savedGames.firstElement();
        dos.writeInt(1);
        dos.writeInt(gameItem.level);
        dos.writeInt(gameItem.matches);
        dos.writeInt(gameItem.points);
        dos.writeInt(gameItem.playedTime);
        dos.writeInt(gameItem.maxTime);
        dos.writeInt(gameItem.removedCursor);
        dos.writeInt(gameItem.tilesCount);
        dos.writeInt(gameItem.screen);
        dos.writeInt(gameItem.combos);
        dos.writeInt(gameItem.comboTime);
        dos.writeInt(gameItem.comboMultiplier);
        dos.writeInt(gameItem.resultStep);
        dos.writeInt(gameItem.score);
        dos.writeInt(gameItem.usedUndo);
        dos.writeInt(gameItem.medal);
        dos.writeInt(gameItem.showedMatches);
        dos.writeInt(gameItem.showedUsedUndo);
        dos.writeInt(gameItem.showedTime);
        dos.writeInt(gameItem.showedTotalScore);
        dos.writeInt(gameItem.showedMedal);
        for (j = 0; j < gameItem.tilesCount; ++j) {
            dos.writeByte(gameItem.tiles[j]);
        }
        for (j = 0; j < gameItem.tilesCount; ++j) {
            dos.writeInt(gameItem.removed[j]);
        }
        for (j = 0; j < gameItem.tilesCount; ++j) {
            dos.writeByte(gameItem.showed[j]);
        }
        for (j = 0; j < 2; ++j) {
            dos.writeInt(gameItem.markedTiles[j]);
        }
        for (j = 0; j < 2; ++j) {
            dos.writeByte(gameItem.markedTilesType[j]);
        }
        for (j = 0; j < 2; ++j) {
            dos.writeInt(gameItem.hints[j]);
        }
        dos.writeBoolean(gameItem.isOutOfMoves);
        dos.writeBoolean(gameItem.isNoSolution);
        dos.writeBoolean(gameItem.isHint);
        dos.writeBoolean(gameItem.isDialog);
        dos.writeBoolean(gameItem.isFinished);
        dos.writeBoolean(gameItem.bNewRecord);
        dos.writeBoolean(gameItem.bNewRecordFlag);
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
        dos.writeInt(0);
    }
}

