/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import net.rim.device.api.system.GlobalEventListener;
import net.rim.device.api.system.KeyListener;
import net.rim.device.api.ui.Keypad;
import net.rim.device.api.ui.UiApplication;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.fx.SoundManager;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenIntro;
import sk.inlogic.util.Keys;

public class MainCanvas
extends GameCanvas
implements Runnable,
GlobalEventListener,
KeyListener {
    public static final int FPS = 40;
    public static int lastPointerPressedX = 0;
    public static int lastPointerPressedY = 0;
    public static int WIDTH = 0;
    public static int HEIGHT = 0;
    public static int WIDTH_FROM_DC = 0;
    public static int HEIGHT_FROM_DC = 0;
    private static Thread mainThread;
    private Vector activeScreens = new Vector();
    public long lLastRun;
    private boolean interuptionIn;
    private boolean handsetTiled;
    private boolean paintIn;
    public boolean paintPaused;
    private boolean bScreenSizeAdjusted;
    public static SoundManager soundManager;
    private UiApplication app;

    public MainCanvas() {
        super(false);
        this.initCanvas();
        Keys.canvas = this;
        this.handsetTiled = false;
        soundManager = new SoundManager(2);
        soundManager.LoadPlayList(Sounds.GAME_MUSIC_FILES, Sounds.GAME_SOUND_TYPES, Sounds.GAME_SOUND_FLAGS);
        this.app = UiApplication.getUiApplication();
        this.app.addGlobalEventListener((GlobalEventListener)this);
        this.app.addKeyListener((KeyListener)this);
    }

    public void eventOccurred(long guid, int data0, int data1, Object object0, Object object1) {
        if (guid == 5961289116197897667L) {
            if (data0 == 1) {
                this.hideNotify();
            } else if (data0 == 2) {
                this.showNotify();
            }
        }
    }

    public boolean keyChar(char key, int status, int time) {
        return false;
    }

    public boolean keyDown(int keycode, int time) {
        if (Keys.isFKLeftCode(Keypad.key((int)keycode))) {
            this.keyPressed(4098);
            return true;
        }
        if (Keypad.key((int)keycode) == 27) {
            this.keyPressed(27);
            return true;
        }
        return false;
    }

    public boolean keyRepeat(int keycode, int time) {
        return false;
    }

    public boolean keyStatus(int keycode, int time) {
        return false;
    }

    public boolean keyUp(int keycode, int time) {
        if (Keys.isFKLeftCode(Keypad.key((int)keycode))) {
            this.keyReleased(4098);
            return true;
        }
        if (Keypad.key((int)keycode) == 27) {
            this.keyReleased(27);
            return true;
        }
        return false;
    }

    public void startGame() {
        mainThread = new Thread(this);
        mainThread.start();
    }

    public void pausePaint() {
        this.paintPaused = true;
    }

    private void initCanvas() {
        super.setFullScreenMode(true);
        mainThread = new Thread(this);
        mainThread.start();
        this.interuptionIn = false;
        this.paintIn = false;
        this.paintPaused = false;
        this.bScreenSizeAdjusted = false;
        this.lLastRun = 0L;
    }

    public void changeLastActiveScreen(IScreen newScreen) {
        if (newScreen == null || this.activeScreens.size() == 0) {
            return;
        }
        Keys.resetAllPressedKeysAndActions();
        this.paintPaused = true;
        while (this.paintIn) {
        }
        ((IScreen)this.activeScreens.lastElement()).afterHide();
        this.activeScreens.removeElement(this.activeScreens.lastElement());
        System.gc();
        newScreen.beforeShow();
        this.activeScreens.addElement(newScreen);
        this.lLastRun = System.currentTimeMillis();
        this.paintPaused = false;
    }

    public void addActiveScreen(IScreen screen) {
        if (screen == null) {
            return;
        }
        Keys.resetAllPressedKeysAndActions();
        screen.beforeShow();
        this.activeScreens.addElement(screen);
    }

    public void removeLastActiveScreen() {
        if (this.activeScreens.size() == 0) {
            return;
        }
        Keys.resetAllPressedKeysAndActions();
        this.paintPaused = true;
        while (this.paintIn) {
        }
        ((IScreen)this.activeScreens.lastElement()).afterHide();
        this.activeScreens.removeElement(this.activeScreens.lastElement());
        System.gc();
        this.paintPaused = false;
    }

    public void hideNotify() {
        if (this.interuptionIn) {
            return;
        }
        this.interuptionIn = true;
        soundManager.Stop();
        ((IScreen)this.activeScreens.lastElement()).beforeInteruption();
    }

    public void showNotify() {
        if (!this.interuptionIn) {
            return;
        }
        this.interuptionIn = false;
        ((IScreen)this.activeScreens.lastElement()).afterInteruption();
        this.repaint();
    }

    public boolean isInterrupted() {
        return this.interuptionIn;
    }

    public void run() {
        this.lLastRun = System.currentTimeMillis();
        while (Thread.currentThread() == mainThread) {
            Thread.yield();
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lLastRun < 40L) continue;
            if (!this.bScreenSizeAdjusted) {
                this.repaint();
                this.lLastRun = currentTime;
                continue;
            }
            if (this.handsetTiled) {
                this.repaint();
                continue;
            }
            if (!this.paintPaused && currentTime - this.lLastRun > 2000L) {
                this.hideNotify();
                this.showNotify();
            }
            int activeScreensCount = this.activeScreens.size();
            for (int i = 0; i < activeScreensCount; ++i) {
                ((IScreen)this.activeScreens.elementAt(i)).update(currentTime - this.lLastRun);
            }
            if (currentTime <= this.lLastRun) continue;
            this.lLastRun = currentTime;
        }
    }

    public void paint(Graphics g) {
        if (this.paintPaused) {
            return;
        }
        HEIGHT = g.getClipHeight();
        WIDTH = g.getClipWidth();
        if (WIDTH_FROM_DC < HEIGHT_FROM_DC && WIDTH > HEIGHT || WIDTH_FROM_DC > HEIGHT_FROM_DC && WIDTH < HEIGHT) {
            this.handsetTiled = true;
            this.paintResRotation(g);
            int h = HEIGHT;
            HEIGHT = WIDTH;
            WIDTH = h;
            return;
        }
        this.handsetTiled = false;
        if (!this.bScreenSizeAdjusted) {
            this.bScreenSizeAdjusted = true;
            this.addActiveScreen(new ScreenIntro(this));
        }
        if (this.activeScreens.size() > 0) {
            this.paintIn = true;
            g.setColor(0);
            g.fillRect(0, 0, WIDTH, HEIGHT);
            g.setColor(0);
            g.setClip(0, 0, WIDTH, HEIGHT);
            int activeScreensCount = this.activeScreens.size();
            for (int i = 0; i < activeScreensCount; ++i) {
                ((IScreen)this.activeScreens.elementAt(i)).paint(g);
            }
            this.paintIn = false;
        }
    }

    private void paintResRotation(Graphics g) {
        g.setClip(0, 0, WIDTH, HEIGHT);
        g.setColor(0);
        g.fillRect(0, 0, WIDTH, HEIGHT);
        if (Resources.resImgs[0] == null) {
            Resources.loadImage(0);
        } else {
            g.drawImage(Resources.resImgs[0], WIDTH / 2, HEIGHT / 2, 3);
        }
    }

    public void keyPressed(int keyCode) {
        if (this.handsetTiled) {
            return;
        }
        if (keyCode == 115) {
            keyCode = 52;
        } else if (keyCode == 102) {
            keyCode = 54;
        } else if (keyCode == 100) {
            keyCode = 53;
        } else if (keyCode == 101) {
            keyCode = 50;
        } else if (keyCode == 120) {
            keyCode = 56;
        } else if (keyCode == 97 || keyCode == 42) {
            keyCode = 42;
        } else if (keyCode == 32 || keyCode == 106 || keyCode == 117 || keyCode == 107 || keyCode == 104 || keyCode == 110 || keyCode == 108 || keyCode == 103 || keyCode == 99 || keyCode == 114 || keyCode == 8) {
            return;
        }
        Keys.keyPressed(keyCode);
        if (this.activeScreens.size() > 0) {
            ((IScreen)this.activeScreens.lastElement()).keyPressed(keyCode);
        }
    }

    private void onKeyReleased(int keyCode) {
        if (this.activeScreens.size() > 0) {
            ((IScreen)this.activeScreens.lastElement()).keyReleased(keyCode);
        }
        Keys.keyReleased(keyCode);
    }

    public void keyReleased(int keyCode) {
        if (this.handsetTiled) {
            return;
        }
        if (keyCode == 115) {
            keyCode = 52;
        } else if (keyCode == 102) {
            keyCode = 54;
        } else if (keyCode == 100) {
            keyCode = 53;
        } else if (keyCode == 101) {
            keyCode = 50;
        } else if (keyCode == 120) {
            keyCode = 56;
        } else if (keyCode == 97 || keyCode == 42) {
            keyCode = 42;
        } else if (keyCode == 32 || keyCode == 106 || keyCode == 117 || keyCode == 107 || keyCode == 104 || keyCode == 110 || keyCode == 108 || keyCode == 103 || keyCode == 99 || keyCode == 114 || keyCode == 8) {
            return;
        }
        this.onKeyReleased(keyCode);
    }

    public void pointerPressed(int x, int y) {
        if (this.handsetTiled) {
            return;
        }
        lastPointerPressedX = x;
        lastPointerPressedY = y;
        if (this.activeScreens.size() > 0) {
            ((IScreen)this.activeScreens.lastElement()).pointerPressed(x, y);
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.handsetTiled) {
            return;
        }
        if (this.activeScreens.size() > 0) {
            ((IScreen)this.activeScreens.lastElement()).pointerDragged(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.handsetTiled) {
            return;
        }
        if (this.activeScreens.size() > 0) {
            ((IScreen)this.activeScreens.lastElement()).pointerReleased(x, y);
        }
    }

    static {
        String fullCanvasSize = "480x360";
        try {
            WIDTH = WIDTH_FROM_DC = Integer.valueOf(fullCanvasSize.substring(0, fullCanvasSize.indexOf("x"))).intValue();
            HEIGHT = HEIGHT_FROM_DC = Integer.valueOf(fullCanvasSize.substring(fullCanvasSize.indexOf("x") + 1)).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

