/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public final class BPFontReader {
    private static final String RESOURCES_FILE_NAME = "resources.bin";
    public static String[][] textAsString;
    public static String[][] langsAsString;
    public static byte[][][] textAsOffset;
    public static byte[][][] langsAsOffset;
    static char[][] alphabetAsChar;
    static short[][] alphabetAsOffset;
    static char[][] specialsAsChar;
    static short[][] baseOffsetStart;
    static short[][] baseOffsetEnd;
    static short[][] specOffsetStart;
    static short[][] specOffsetEnd;
    static short[][] posX;
    static short[][] posY;
    public static Image[] alphabetAsImage;
    public static Image[] specialsAsImage;
    static short[] fontHeight;
    public static short[] specMaxUp;
    public static short[] alphabetIndex;
    public static short[] langsAlphabetIndex;
    public static short[] letterSpacingArr;
    public static short[] langsLetterSpacing;
    static short[] langSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(MIDlet mIDlet, boolean bl, boolean bl2) {
        FilterInputStream filterInputStream = null;
        try {
            int n;
            int n2;
            int n3;
            int n4;
            filterInputStream = new DataInputStream(mIDlet.getClass().getResourceAsStream(RESOURCES_FILE_NAME));
            int n5 = ((DataInputStream)filterInputStream).readInt();
            langSize = new short[n5 + 1];
            BPFontReader.langSize[0] = (short)((DataInputStream)filterInputStream).readInt();
            for (n4 = 0; n4 < n5; n4 = (int)((short)(n4 + 1))) {
                BPFontReader.langSize[n4 + 1] = (short)((DataInputStream)filterInputStream).readInt();
            }
            n4 = ((DataInputStream)filterInputStream).readInt();
            alphabetAsImage = new Image[n4];
            specialsAsImage = new Image[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                byte[] byArray = new byte[((DataInputStream)filterInputStream).readInt()];
                for (int n6 = 0; n6 < byArray.length; n6 = (int)((short)(n6 + 1))) {
                    byArray[n6] = ((DataInputStream)filterInputStream).readByte();
                }
                Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                if (bl2) {
                    BPFontReader.alphabetAsImage[n3] = image;
                }
                byArray = null;
                n2 = ((DataInputStream)filterInputStream).readInt();
                byArray = new byte[n2];
                if (n2 != 0) {
                    for (n = 0; n < byArray.length; n = (int)((short)(n + 1))) {
                        byArray[n] = ((DataInputStream)filterInputStream).readByte();
                    }
                    image = null;
                    image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                    if (!bl2) continue;
                    BPFontReader.specialsAsImage[n3] = image;
                    continue;
                }
                BPFontReader.specialsAsImage[n3] = null;
            }
            if (bl) {
                return;
            }
            fontHeight = new short[n4];
            specMaxUp = new short[n4];
            alphabetAsChar = new char[n4][];
            alphabetAsOffset = new short[n4][];
            specialsAsChar = new char[n4][];
            baseOffsetStart = new short[n4][];
            baseOffsetEnd = new short[n4][];
            specOffsetStart = new short[n4][];
            specOffsetEnd = new short[n4][];
            posX = new short[n4][];
            posY = new short[n4][];
            for (n3 = 0; n3 < n4; n3 = (int)((short)(n3 + 1))) {
                int n7;
                BPFontReader.fontHeight[n3] = (short)((DataInputStream)filterInputStream).readInt();
                int n8 = ((DataInputStream)filterInputStream).readInt();
                BPFontReader.alphabetAsOffset[n3] = new short[n8];
                for (n7 = 0; n7 < n8; n7 = (int)((short)(n7 + 1))) {
                    BPFontReader.alphabetAsOffset[n3][n7] = (short)((DataInputStream)filterInputStream).readInt();
                }
                n7 = ((DataInputStream)filterInputStream).readInt();
                BPFontReader.alphabetAsChar[n3] = new char[n7];
                for (n2 = 0; n2 < n7; n2 = (int)((short)(n2 + 1))) {
                    BPFontReader.alphabetAsChar[n3][n2] = (char)(((DataInputStream)filterInputStream).readChar() ^ n2);
                }
                n2 = ((DataInputStream)filterInputStream).readInt();
                BPFontReader.specialsAsChar[n3] = new char[n2];
                BPFontReader.baseOffsetStart[n3] = new short[n2];
                BPFontReader.baseOffsetEnd[n3] = new short[n2];
                BPFontReader.specOffsetStart[n3] = new short[n2];
                BPFontReader.specOffsetEnd[n3] = new short[n2];
                BPFontReader.posX[n3] = new short[n2];
                BPFontReader.posY[n3] = new short[n2];
                for (n = 0; n < n2; ++n) {
                    BPFontReader.specialsAsChar[n3][n] = (char)(((DataInputStream)filterInputStream).readChar() ^ n);
                    BPFontReader.baseOffsetStart[n3][n] = (short)((DataInputStream)filterInputStream).readInt();
                    BPFontReader.baseOffsetEnd[n3][n] = (short)((DataInputStream)filterInputStream).readInt();
                    BPFontReader.specOffsetStart[n3][n] = (short)((DataInputStream)filterInputStream).readInt();
                    BPFontReader.specOffsetEnd[n3][n] = (short)((DataInputStream)filterInputStream).readInt();
                    BPFontReader.posX[n3][n] = (short)((DataInputStream)filterInputStream).readInt();
                    BPFontReader.posY[n3][n] = (short)((DataInputStream)filterInputStream).readInt();
                }
            }
            n3 = ((DataInputStream)filterInputStream).readInt();
            langsAsString = new String[n3][];
            langsAlphabetIndex = new short[n3];
            langsLetterSpacing = new short[n3];
            langsAsOffset = new byte[n3][][];
            for (int i = 0; i < n3; ++i) {
                ((DataInputStream)filterInputStream).readUTF();
                int n9 = ((DataInputStream)filterInputStream).readInt();
                if (n9 == 0 || n9 == 1) {
                    n2 = ((DataInputStream)filterInputStream).readInt();
                    BPFontReader.langsAsString[i] = new String[n2];
                    for (n = 0; n < n2; ++n) {
                        BPFontReader.langsAsString[i][n] = new String(BPFontReader.decodeText(((DataInputStream)filterInputStream).readUTF()));
                    }
                    continue;
                }
                BPFontReader.langsAlphabetIndex[i] = (short)(n9 - 2);
                BPFontReader.langsLetterSpacing[i] = (short)((DataInputStream)filterInputStream).readInt();
                n2 = ((DataInputStream)filterInputStream).readInt();
                BPFontReader.langsAsOffset[i] = new byte[n2][];
                for (n = 0; n < n2; ++n) {
                    int n10 = ((DataInputStream)filterInputStream).readInt();
                    BPFontReader.langsAsOffset[i][n] = new byte[n10];
                    for (int j = 0; j < n10; ++j) {
                        BPFontReader.langsAsOffset[i][n][j] = ((DataInputStream)filterInputStream).readByte();
                    }
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void loadLanguage(MIDlet mIDlet, int n) {
        textAsString = null;
        alphabetIndex = null;
        letterSpacingArr = null;
        textAsOffset = null;
        System.gc();
        DataInputStream dataInputStream = null;
        try {
            int n2;
            dataInputStream = new DataInputStream(mIDlet.getClass().getResourceAsStream(RESOURCES_FILE_NAME));
            int n3 = dataInputStream.readInt();
            dataInputStream.readInt();
            for (n2 = 0; n2 < n3; ++n2) {
                dataInputStream.readInt();
            }
            if (n + 1 >= langSize.length) {
                return;
            }
            n2 = 0;
            short s = 0;
            while ((n2 += dataInputStream.skipBytes(langSize[n] - n2)) < langSize[n] && ++s <= langSize[n]) {
            }
            if (s > langSize[n]) {
                return;
            }
            dataInputStream.readUTF();
            int n4 = dataInputStream.readInt();
            textAsString = new String[n4][];
            alphabetIndex = new short[n4];
            letterSpacingArr = new short[n4];
            textAsOffset = new byte[n4][][];
            for (int i = 0; i < n4; ++i) {
                int n5 = dataInputStream.readInt();
                if (n5 < 2) {
                    n5 = 2;
                }
                BPFontReader.alphabetIndex[i] = (short)(n5 - 2);
                BPFontReader.letterSpacingArr[i] = alphabetIndex[i] == 1 ? (short)(dataInputStream.readInt() + 1) : (alphabetIndex[i] == 2 ? (short)(dataInputStream.readInt() - 1) : (short)(dataInputStream.readInt() - 1));
                int n6 = dataInputStream.readInt();
                BPFontReader.textAsOffset[i] = new byte[n6][];
                for (int j = 0; j < n6; ++j) {
                    int n7 = dataInputStream.readInt();
                    BPFontReader.textAsOffset[i][j] = new byte[n7];
                    for (int k = 0; k < n7; ++k) {
                        BPFontReader.textAsOffset[i][j][k] = dataInputStream.readByte();
                    }
                }
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    public static void freeMemory(boolean bl) {
        alphabetAsImage = null;
        if (bl) {
            textAsString = null;
            textAsOffset = null;
            langsAsString = null;
            langsAsOffset = null;
            alphabetAsChar = null;
            alphabetAsOffset = null;
            fontHeight = null;
            specMaxUp = null;
            alphabetIndex = null;
            langsAlphabetIndex = null;
        }
        System.gc();
    }

    public static void drawSystemTextLine(String string, int n, int n2, Font font, int n3, Graphics graphics) {
        graphics.setFont(font);
        graphics.setColor(n3);
        graphics.drawString(string, n, n2, 20);
    }

    public static void drawGraphicTextLine(int n, int n2, int n3, int n4, Graphics graphics, int n5) {
        short s;
        byte[] byArray;
        if (n >= 1000) {
            byArray = langsAsOffset[n -= 1000][n2];
            s = langsAlphabetIndex[n];
            n += 1000;
        } else {
            byArray = textAsOffset[n][n2];
            s = alphabetIndex[n];
        }
        int n6 = alphabetAsImage[s].getWidth();
        if (n5 == 8) {
            n3 -= BPFontReader.getGraphicTextWidth(n, n2);
        } else if (n5 == 1) {
            n3 -= BPFontReader.getGraphicTextWidth(n, n2) >> 1;
        }
        n -= n >= 1000 ? 1000 : 0;
        n4 += specMaxUp[s];
        for (int i = 0; i < byArray.length; ++i) {
            int n7;
            int n8;
            int n9;
            short s2;
            short s3;
            int n10;
            if (byArray[i] < 0) {
                n10 = -byArray[i] - 1;
                s3 = baseOffsetStart[s][n10];
                s2 = baseOffsetEnd[s][n10];
                n9 = s2 - s3;
                n8 = s3 / n6;
                n7 = s3 - n8 * n6;
            } else {
                n10 = alphabetAsOffset[s][byArray[i]];
                n9 = alphabetAsOffset[s][byArray[i] + 1] - n10;
                n8 = n10 / n6;
                n7 = n10 - n8 * n6;
            }
            graphics.setClip(n3 - i, n4, n9, (int)fontHeight[s]);
            graphics.drawImage(alphabetAsImage[s], n3 - i - n7, n4 - n8 * fontHeight[s], 20);
            if (byArray[i] < 0) {
                n10 = -byArray[i] - 1;
                s3 = specOffsetStart[s][n10];
                s2 = specOffsetEnd[s][n10];
                short s4 = posX[s][n10];
                short s5 = posY[s][n10];
                n8 = s3 / specialsAsImage[s].getWidth();
                n7 = s3 - n8 * specialsAsImage[s].getWidth();
                graphics.setClip(n3 - i + s4, n4 + s5, s2 - s3, specialsAsImage[s].getHeight());
                graphics.drawImage(specialsAsImage[s], n3 - i + s4 - n7, n4 + s5 - n8 * fontHeight[s], 20);
            }
            n3 += n9 + letterSpacingArr[n];
        }
    }

    public static void drawGraphicTextLine(byte[] byArray, int n, int n2, Graphics graphics, int n3, int n4, int n5) {
        try {
            int n6 = alphabetAsImage[n4].getWidth();
            if (n3 == 8) {
                n -= BPFontReader.getTextAsOffsetWidth(byArray, n4, n5);
            } else if (n3 == 1) {
                n -= BPFontReader.getTextAsOffsetWidth(byArray, n4, n5) >> 1;
            }
            n2 += specMaxUp[n4];
            for (int i = 0; i < byArray.length; ++i) {
                int n7;
                int n8;
                int n9;
                short s;
                short s2;
                int n10;
                if (byArray[i] < 0) {
                    n10 = -byArray[i] - 1;
                    s2 = baseOffsetStart[n4][n10];
                    s = baseOffsetEnd[n4][n10];
                    n9 = s - s2;
                    n8 = s2 / n6;
                    n7 = s2 - n8 * n6;
                } else {
                    n10 = alphabetAsOffset[n4][byArray[i]];
                    n9 = alphabetAsOffset[n4][byArray[i] + 1] - n10;
                    n8 = n10 / n6;
                    n7 = n10 - n8 * n6;
                }
                graphics.setClip(n - i, n2, n9, (int)fontHeight[n4]);
                graphics.drawImage(alphabetAsImage[n4], n - i - n7, n2 - n8 * fontHeight[n4], 20);
                if (byArray[i] < 0) {
                    n10 = -byArray[i] - 1;
                    s2 = specOffsetStart[n4][n10];
                    s = specOffsetEnd[n4][n10];
                    short s3 = posX[n4][n10];
                    short s4 = posY[n4][n10];
                    n8 = s2 / specialsAsImage[n4].getWidth();
                    n7 = s2 - n8 * specialsAsImage[n4].getWidth();
                    graphics.setClip(n - i + s3, n2 + s4, s - s2, specialsAsImage[n4].getHeight());
                    graphics.drawImage(specialsAsImage[n4], n - i + s3 - n7, n2 + s4 - n8 * fontHeight[n4], 20);
                }
                n += n9 + n5;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void drawGraphicTextLine(String string, int n, int n2, int n3, int n4, Graphics graphics, int n5) {
        int n6 = alphabetAsImage[n3].getWidth();
        if (n5 == 8) {
            n -= BPFontReader.getTextWidth(string, n3, n4);
        } else if (n5 == 1) {
            n -= BPFontReader.getTextWidth(string, n3, n4) >> 1;
        }
        n2 += specMaxUp[n3];
        for (int i = 0; i < string.length(); ++i) {
            int n7;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            short s = 0;
            boolean bl = true;
            char c = string.charAt(i);
            for (n7 = 0; n7 < alphabetAsChar[n3].length; ++n7) {
                if (alphabetAsChar[n3][n7] != c) continue;
                bl = false;
                s = alphabetAsOffset[n3][n7];
                n8 = alphabetAsOffset[n3][n7 + 1] - s;
                n9 = s / n6;
                n10 = s - n9 * n6;
                break;
            }
            if (bl) {
                for (n7 = 0; n7 < specialsAsChar[n3].length; ++n7) {
                    if (specialsAsChar[n3][n7] != c) continue;
                    n8 = baseOffsetEnd[n3][n7] - baseOffsetStart[n3][n7];
                    n9 = baseOffsetStart[n3][n7] / n6;
                    n10 = baseOffsetStart[n3][n7] - n9 * n6;
                    break;
                }
            }
            graphics.setClip(n - i, n2, n8, (int)fontHeight[n3]);
            graphics.drawImage(alphabetAsImage[n3], n - n10 - i, n2 - n9 * fontHeight[n3], 20);
            if (bl) {
                short s2 = specOffsetStart[n3][n7];
                short s3 = specOffsetEnd[n3][n7];
                short s4 = posX[n3][n7];
                short s5 = posY[n3][n7];
                n9 = s2 / specialsAsImage[n3].getWidth();
                n10 = s2 - n9 * specialsAsImage[n3].getWidth();
                graphics.setClip(n - i + s4, n2 + s5, s3 - s2, specialsAsImage[n3].getHeight());
                graphics.drawImage(specialsAsImage[n3], n - i + s4 - n10, n2 + s5 - n9 * fontHeight[n3], 20);
            }
            n += n8 + n4;
        }
    }

    public static void drawGraphicText(int n, int n2, int n3, Graphics graphics, int n4, int n5) {
        for (int i = 0; i < textAsOffset[n].length; ++i) {
            BPFontReader.drawGraphicTextLine(n, i, n2, n3, graphics, n4);
            n3 += n5 + fontHeight[alphabetIndex[n]];
        }
    }

    public static void drawSystemText(int n, int n2, int n3, Font font, int n4, Graphics graphics, int n5) {
        for (int i = 0; i < textAsString[n].length; ++i) {
            BPFontReader.drawSystemTextLine(textAsString[n][i], n2, n3, font, n4, graphics);
            n3 += n5 + font.getHeight();
        }
    }

    public static int drawGraphicTextInWindow(int n, int n2, int n3, int n4, int n5, int n6, int n7, Graphics graphics, int n8, int n9) {
        int n10 = n6 - n2;
        if (n8 == 8) {
            n10 = n2;
        } else if (n8 == 1) {
            n10 = n6;
        }
        byte[][] byArray = BPFontReader.splitGraphicText(n, n10, true);
        int n11 = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            if (n3 + n5 + fontHeight[alphabetIndex[n]] > n5 + n7) {
                return n11;
            }
            if (n3 >= 0) {
                BPFontReader.drawGraphicTextLine(byArray[i], n2 + n4, n3 + n5, graphics, n8, alphabetIndex[n], (int)letterSpacingArr[n]);
            }
            n3 += n9 + fontHeight[alphabetIndex[n]];
        }
        return n11;
    }

    public static int drawGraphicTextInWindow(String string, int n, int n2, int n3, int n4, int n5, int n6, Graphics graphics, int n7, int n8, int n9, int n10) {
        int n11 = n5 - n;
        if (n7 == 8) {
            n11 = n;
        } else if (n7 == 1) {
            n11 = Math.min(n, n5 - n) << 1;
        }
        String[] stringArray = BPFontReader.splitText(string, n11, n9, n10);
        int n12 = stringArray.length;
        for (int i = 0; i < stringArray.length; ++i) {
            if (n2 + n4 + fontHeight[n9] > n4 + n6) {
                return n12;
            }
            if (n2 >= 0) {
                BPFontReader.drawGraphicTextLine(stringArray[i], n + n3, n2 + n4, n9, n10, graphics, n7);
            }
            n2 += n8 + fontHeight[n9];
        }
        return n12;
    }

    public static void drawComposedText(int n, int n2, String string, int n3, int n4, int n5, int n6, Graphics graphics, int n7) {
        if (n7 == 8) {
            n3 -= BPFontReader.getGraphicTextWidth(n, n2) + BPFontReader.getTextWidth(string, n5, n6);
        } else if (n7 == 1) {
            n3 -= BPFontReader.getGraphicTextWidth(n, n2) + BPFontReader.getTextWidth(string, n5, n6) >> 1;
        }
        BPFontReader.drawGraphicTextLine(n, n2, n3, n4, graphics, 4);
        BPFontReader.drawGraphicTextLine(string, n3 += BPFontReader.getGraphicTextWidth(n, n2), n4, n5, n6, graphics, 4);
    }

    public static void drawComposedText2(int n, int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, Graphics graphics, int n9) {
        if (n9 == 8) {
            n5 -= BPFontReader.getGraphicTextWidth(n, n2) + BPFontReader.getTextWidth(string, n7, n8) + BPFontReader.getGraphicTextWidth(n3, n4);
        } else if (n9 == 1) {
            n5 -= BPFontReader.getGraphicTextWidth(n, n2) + BPFontReader.getTextWidth(string, n7, n8) + BPFontReader.getGraphicTextWidth(n3, n4) >> 1;
        }
        BPFontReader.drawGraphicTextLine(n, n2, n5, n6, graphics, 4);
        BPFontReader.drawGraphicTextLine(string, n5 += BPFontReader.getGraphicTextWidth(n, n2), n6, n7, n8, graphics, 4);
        BPFontReader.drawGraphicTextLine(n3, n4, n5 += BPFontReader.getTextWidth(string, n7, n8), n6, graphics, 4);
    }

    public static int drawComposedTextInWindow(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Graphics graphics, int n9, int n10, int n11) {
        int n12;
        int n13 = n7 - n3;
        if (n9 == 8) {
            n13 = n3;
        } else if (n9 == 1) {
            n13 = Math.min(n3, n7 - n3) << 1;
        }
        byte[][] byArray = BPFontReader.splitGraphicText(n, n13, false);
        byte[][] byArray2 = BPFontReader.splitGraphicText(n2, n13, false);
        int n14 = n12 = byArray.length + byArray2.length + 1;
        for (int i = 0; i < n12; ++i) {
            if (i < byArray.length) {
                if (n4 + n6 + fontHeight[alphabetIndex[n]] > n6 + n8) {
                    return n14;
                }
                if (n4 >= 0) {
                    BPFontReader.drawGraphicTextLine(byArray[i], n3 + n5, n4 + n6, graphics, n9, alphabetIndex[n], (int)letterSpacingArr[n]);
                }
                n4 += n10 + fontHeight[alphabetIndex[n]];
                continue;
            }
            if (i == byArray.length) {
                if (n4 + n6 + fontHeight[alphabetIndex[n]] > n6 + n8) {
                    return n14;
                }
                if (n4 >= 0) {
                    BPFontReader.drawGraphicTextLine(string, n3 + n5, n4 + n6, n11, (int)letterSpacingArr[n], graphics, n9);
                }
                n4 += n10 + fontHeight[alphabetIndex[n]];
                continue;
            }
            int n15 = i - byArray.length - 1;
            if (n4 + n6 + fontHeight[alphabetIndex[n2]] > n6 + n8) {
                return n14;
            }
            if (n4 >= 0) {
                BPFontReader.drawGraphicTextLine(byArray2[n15], n3 + n5, n4 + n6, graphics, n9, alphabetIndex[n2], (int)letterSpacingArr[n2]);
            }
            n4 += n10 + fontHeight[alphabetIndex[n2]];
        }
        return n14;
    }

    public static int drawComposedTextInWindow(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, Graphics graphics, int n8, int n9, int n10) {
        int n11;
        int n12 = n6 - n2;
        if (n8 == 8) {
            n12 = n2;
        } else if (n8 == 1) {
            n12 = Math.min(n2, n6 - n2) << 1;
        }
        byte[][] byArray = BPFontReader.splitGraphicText(n, n12, false);
        int n13 = n11 = byArray.length + 1;
        for (int i = 0; i < n11; ++i) {
            if (i < 1) {
                if (n3 >= 0) {
                    BPFontReader.drawGraphicTextLine(string, n2 + n4, n3 + n5, n10, (int)letterSpacingArr[n], graphics, n8);
                }
                n3 += n9 + fontHeight[alphabetIndex[n]];
                continue;
            }
            int n14 = i - 1;
            if (n3 + n5 + fontHeight[alphabetIndex[n]] > n5 + n7) {
                return n13;
            }
            if (n3 >= 0) {
                BPFontReader.drawGraphicTextLine(byArray[n14], n2 + n4, n3 + n5, graphics, n8, alphabetIndex[n], (int)letterSpacingArr[n]);
            }
            n3 += n9 + fontHeight[alphabetIndex[n]];
        }
        return n13;
    }

    public static void drawGraphicLang(int n, int n2, int n3, int n4, Graphics graphics) {
        try {
            byte[] byArray = langsAsOffset[n][n2];
            short s = langsAlphabetIndex[n];
            int n5 = alphabetAsImage[s].getWidth();
            n4 += specMaxUp[s];
            for (int i = 0; i < byArray.length; ++i) {
                short s2 = alphabetAsOffset[s][byArray[i]];
                int n6 = alphabetAsOffset[s][byArray[i] + 1] - s2;
                int n7 = s2 / n5;
                int n8 = s2 - n7 * n5;
                graphics.setClip(n3 - i, n4, n6, alphabetAsImage[s].getHeight());
                graphics.drawImage(alphabetAsImage[s], n3 - i - n8, n4 - n7 * alphabetAsImage[s].getHeight(), 20);
                n3 += n6 + langsLetterSpacing[n];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getTextWidth(String string, int n, int n2) {
        int n3 = n2 - 1;
        int n4 = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n5;
            boolean bl = true;
            char c = string.charAt(i);
            int n6 = 0;
            for (n5 = 0; n5 < alphabetAsChar[n].length; ++n5) {
                if (alphabetAsChar[n][n5] != c) continue;
                bl = false;
                n6 = alphabetAsOffset[n][n5 + 1] - alphabetAsOffset[n][n5];
                break;
            }
            if (bl) {
                for (n5 = 0; n5 < specialsAsChar[n].length; ++n5) {
                    if (specialsAsChar[n][n5] != c) continue;
                    n6 = baseOffsetEnd[n][n5] - baseOffsetStart[n][n5];
                    break;
                }
            }
            n4 += n6 + n3;
        }
        return n4 - n3;
    }

    public static int getGraphicTextWidth(int n, int n2) {
        byte[] byArray;
        short s;
        if (letterSpacingArr == null) {
            return 0;
        }
        int n3 = 0;
        if (n >= 1000) {
            s = langsAlphabetIndex[n -= 1000];
            byArray = langsAsOffset[n][n2];
        } else {
            s = alphabetIndex[n];
            byArray = textAsOffset[n][n2];
        }
        int n4 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n4 = 0;
            if (byArray[i] < 0) {
                int n5 = -byArray[i] - 1;
                n4 = baseOffsetEnd[s][n5] - baseOffsetStart[s][n5];
            } else {
                n4 = alphabetAsOffset[s][byArray[i] + 1] - alphabetAsOffset[s][byArray[i]];
            }
            n3 += n4 + letterSpacingArr[n] - 1;
        }
        return n3 - letterSpacingArr[n] + 1;
    }

    public static int getLangsNumber() {
        return langsAsOffset.length;
    }

    public static int getFontHeight(int n) {
        if (n >= 1000) {
            return fontHeight[langsAlphabetIndex[n - 1000]];
        }
        return fontHeight[alphabetIndex[n]];
    }

    public static String getStringFromOffsets(int n) {
        String string = "";
        for (int i = 0; i < textAsOffset[n].length; ++i) {
            string = string + BPFontReader.getStringFromOffsets(n, i) + " ";
        }
        return string;
    }

    public static String getStringFromOffsets(int n, int n2) {
        String string = "";
        short s = alphabetIndex[n];
        for (int i = 0; i < textAsOffset[n][n2].length; ++i) {
            if (textAsOffset[n][n2][i] >= 0) {
                string = string + alphabetAsChar[s][textAsOffset[n][n2][i]];
                continue;
            }
            int n3 = -textAsOffset[n][n2][i] - 1;
            string = string + specialsAsChar[s][n3];
        }
        return string;
    }

    public static int getTextAsOffsetWidth(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n4 = 0;
            if (byArray[i] < 0) {
                int n5 = -byArray[i] - 1;
                n4 = baseOffsetEnd[n][n5] - baseOffsetStart[n][n5];
            } else {
                n4 = alphabetAsOffset[n][byArray[i] + 1] - alphabetAsOffset[n][byArray[i]];
            }
            n3 += n4 + n2 - 1;
        }
        return n3 - n2 + 1;
    }

    public static int getLinesCntFromWindow(int n, int n2, int n3, int n4) {
        int n5 = n3 - n2;
        if (n4 == 8) {
            n5 = n2;
        } else if (n4 == 1) {
            n5 = Math.min(n2, n3 - n2) << 1;
        }
        return BPFontReader.splitGraphicText(n, n5, false).length;
    }

    private static byte getSeparatorIndex(char c, int n) {
        for (int i = 0; i < alphabetAsChar[n].length; ++i) {
            if (alphabetAsChar[n][i] != c) continue;
            return (byte)i;
        }
        return -1;
    }

    public static byte[][] splitGraphicText(int n, int n2, boolean bl) {
        byte[] byArray;
        byte[] byArray2;
        short s = alphabetIndex[n];
        byte by = BPFontReader.getSeparatorIndex(' ', s);
        int n3 = textAsOffset[n].length;
        short s2 = letterSpacingArr[n];
        byte[] byArray3 = new byte[]{by};
        int n4 = BPFontReader.getTextAsOffsetWidth(byArray3, s, s2);
        byArray3 = null;
        Vector<byte[]> vector = new Vector<byte[]>();
        for (int i = 0; i < n3; ++i) {
            if (BPFontReader.getTextAsOffsetWidth(textAsOffset[n][i], s, s2) <= n2) {
                vector.addElement(textAsOffset[n][i]);
                continue;
            }
            byte[][] byArray4 = BPFontReader.splitTextAsOffset(textAsOffset[n][i], by);
            if (byArray4.length == 1) {
                vector.addElement(textAsOffset[n][i]);
                continue;
            }
            byArray2 = byArray4[0];
            for (int j = 1; j < byArray4.length; ++j) {
                byte[] byArray5 = byArray4[j];
                if (BPFontReader.getTextAsOffsetWidth(byArray2, s, s2) + BPFontReader.getTextAsOffsetWidth(byArray5, s, s2) + n4 <= n2) {
                    byArray = new byte[byArray2.length + byArray5.length + 1];
                    System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                    byArray[byArray2.length] = by;
                    System.arraycopy(byArray5, 0, byArray, byArray2.length + 1, byArray5.length);
                    byArray2 = new byte[byArray.length];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    continue;
                }
                vector.addElement(byArray2);
                byArray2 = byArray4[j];
            }
            if (byArray2.length <= 0) continue;
            vector.addElement(byArray2);
        }
        byte[][] byArrayArray = new byte[vector.size()][];
        for (int i = 0; i < vector.size(); ++i) {
            byArray2 = (byte[])vector.elementAt(i);
            byArrayArray[i] = new byte[byArray2.length];
            byArrayArray[i] = byArray2;
        }
        if (bl) {
            BPFontReader.textAsOffset[n] = byArrayArray;
        }
        byArray = null;
        vector = null;
        return byArrayArray;
    }

    public static String[] splitSystemText(int n, int n2, int n3, int n4, boolean bl) {
        String string;
        int n5 = textAsString[n].length;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n5; ++i) {
            if (textAsString[n][i].length() * (n4 + n3) <= n2) {
                vector.addElement(textAsString[n][i]);
                continue;
            }
            String[] stringArray = BPFontReader.splitWord(textAsString[n][i]);
            if (stringArray.length == 1) {
                vector.addElement(textAsString[n][i]);
                continue;
            }
            string = stringArray[0];
            for (int j = 1; j < stringArray.length; ++j) {
                if ((string.length() + stringArray[j].length() + 1) * (n4 + n3) <= n2) {
                    string = string + " " + stringArray[j];
                    continue;
                }
                vector.addElement(string);
                string = stringArray[j];
            }
            if (string == null) continue;
            vector.addElement(string);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = string = (String)vector.elementAt(i);
        }
        if (bl) {
            BPFontReader.textAsString[n] = stringArray;
        }
        return stringArray;
    }

    public static String[] split(String string, char c) {
        int n;
        Vector<String> vector = new Vector<String>();
        String string2 = new String();
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n != c) {
                string2 = string2 + (char)n;
                continue;
            }
            vector.addElement(string2);
            string2 = new String();
        }
        if (string2.length() != 0) {
            vector.addElement(string2);
        }
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    public static String[] splitText(String string, int n, int n2, int n3) {
        String string2;
        String[] stringArray = BPFontReader.split(string, '#');
        int n4 = BPFontReader.getTextWidth(" ", n2, n3);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (BPFontReader.getTextWidth(stringArray[i], n2, n3) <= n) {
                vector.addElement(stringArray[i]);
                continue;
            }
            String[] stringArray2 = BPFontReader.splitWord(stringArray[i]);
            if (stringArray2.length == 1) {
                vector.addElement(stringArray[i]);
                continue;
            }
            string2 = stringArray2[0];
            for (int j = 1; j < stringArray2.length; ++j) {
                if (BPFontReader.getTextWidth(string2, n2, n3) + BPFontReader.getTextWidth(stringArray2[j], n2, n3) + n4 <= n) {
                    string2 = string2 + " " + stringArray2[j];
                    continue;
                }
                vector.addElement(string2);
                string2 = stringArray2[j];
            }
            if (string2 == null) continue;
            vector.addElement(string2);
        }
        String[] stringArray3 = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray3[i] = string2 = (String)vector.elementAt(i);
        }
        return stringArray3;
    }

    private static String[] splitWord(String string) {
        int n;
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        String string2 = new String();
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n != 32) {
                string2 = string2 + (char)n;
                bl = true;
                continue;
            }
            if (bl && n == 32) {
                vector.addElement(string2);
                bl = false;
                string2 = new String();
                continue;
            }
            string2 = string2 + (char)n;
            bl = false;
        }
        if (string2.length() != 0) {
            vector.addElement(string2);
        }
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    private static byte[][] splitTextAsOffset(byte[] byArray, byte by) {
        Vector<Vector> vector = new Vector<Vector>();
        Vector vector2 = new Vector();
        boolean bl = false;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != by) {
                vector2.addElement(new Byte(byArray[i]));
                bl = true;
                continue;
            }
            if (bl && byArray[i] == by) {
                vector.addElement(vector2);
                vector2 = new Vector();
                bl = false;
                continue;
            }
            vector2.addElement(new Byte(byArray[i]));
            bl = false;
        }
        if (vector2.size() != 0) {
            vector.addElement(vector2);
        }
        byte[][] byArrayArray = new byte[vector.size()][];
        for (int i = 0; i < vector.size(); ++i) {
            vector2 = null;
            vector2 = (Vector)vector.elementAt(i);
            byArrayArray[i] = new byte[vector2.size()];
            for (int j = 0; j < vector2.size(); ++j) {
                byArrayArray[i][j] = (Byte)vector2.elementAt(j);
            }
        }
        vector2 = null;
        vector = null;
        return byArrayArray;
    }

    private static char[] decodeText(String string) {
        char[] cArray = new char[string.length()];
        for (int n = 0; n < string.length(); n = (int)((char)(n + 1))) {
            cArray[n] = (char)(string.charAt(n) ^ n);
        }
        return cArray;
    }
}

