/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenRealyQuit
implements IScreen {
    private MainCanvas mainCanvas;
    private static final int COMP_ID_YES = 0;
    private static final int COMP_ID_NO = 1;
    private static final int TOTAL_COMP_IDS = 2;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int interuption = 0;
    private int _iSelectedCompId;
    private int _iSelectedComMenuId;
    private int _iCycle = 10;
    private int _iFinalHeight;
    private int _iOffsetX;
    private int _iOffsetXDefault = 5;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private int[] _animationSequence = new int[4];
    private int rowDialog;
    private int colDialog;
    private int selectedOption;
    private boolean _bChangeSequence = false;
    private Rectangle[] _rectItems = new Rectangle[2];
    private Rectangle _rectDialog;
    private Rectangle _rectTop;
    private Rectangle rectWindow;
    private Rectangle rectYes;
    private Rectangle rectNo;
    private Rectangle rectScreen;
    private Image imgBg;
    private Sprite sprIcons;
    private Sprite sprDialog;
    private Sprite sprButton;
    private PreparedText preparedTextQuit;
    private PreparedText _ptTitle;
    private GFont fontBig;
    private AnimationComponent[] _animationComponents = new AnimationComponent[4];

    public ScreenRealyQuit(MainCanvas mC, int selectedItem) {
        this.mainCanvas = mC;
        this._iSelectedComMenuId = selectedItem;
        this.initDimensions();
    }

    public void beforeShow() {
        this.rectScreen = new Rectangle(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this.loadResources();
        this.initSprites();
        this.initImages();
        this.initFonts();
        this.initBottomButtons();
        this.initDialog();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.prepareTxt();
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2});
        Resources.loadSprites(new int[]{51, 52, 50});
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2});
        Resources.freeSprites(new int[]{51, 52, 50});
        Resources.freeGFont(1);
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
    }

    private void initSprites() {
        this.sprIcons = Resources.resSprs[51];
        this.sprDialog = Resources.resSprs[52];
        this.sprButton = Resources.resSprs[50];
    }

    private void initImages() {
        this.imgBg = Resources.resImgs[2];
    }

    private void initFonts() {
        Resources.loadGFont(1);
        this.fontBig = Resources.resGFonts[1];
        this.preparedTextQuit = new PreparedText(this.fontBig);
        this._ptTitle = new PreparedText(this.fontBig);
    }

    private void initAnimationSequences() {
        this._animationSequence[0] = 0;
        this._animationSequence[1] = 1;
        this._animationSequence[2] = 2;
        this._animationSequence[3] = 3;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this._rectTop, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectWindow, this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectNo, this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectYes, this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(0);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(0);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(1);
        this._animationComponents[3].startHideAnimation(0);
    }

    private void prepareTxt() {
        this.preparedTextQuit.prepareText(Resources.resTexts[0].getHashedString(2), this._rectDialog.width);
        this._ptTitle.prepareText(Resources.resTexts[0].getHashedString(2), this._rectDialog.width);
    }

    private void freeGraphics() {
        this.imgBg = null;
    }

    private void calculatePositions() {
        this._rectTop = new Rectangle(this._iOffsetXDefault, this.sprIcons.getHeight() - this.sprIcons.getHeight(), this._WIDTH - (this._iOffsetXDefault << 1), this.sprIcons.getHeight());
        int _windowWidth = this._WIDTH >> 1;
        int _offsetX = _windowWidth % this.rectWindow.width > 0 ? _windowWidth % this.rectWindow.width : this.rectWindow.width;
        int _offsetTopY = (this.sprIcons.getHeight() - this.sprIcons.getHeight() << 1) + this.sprIcons.getHeight();
        int _offsetBottomY = this.sprIcons.getHeight() + (this.sprIcons.getHeight() - this.sprIcons.getHeight());
        int _panelHeight = this._HEIGHT - _offsetTopY - _offsetBottomY;
        this._iOffsetX = _offsetX >>= 1;
        this._iFinalHeight = _panelHeight % this.rectWindow.width == 0 ? _panelHeight : _panelHeight - _panelHeight % this.rectWindow.width;
        this._rectDialog = new Rectangle(_offsetX, _offsetTopY, this._WIDTH - (_offsetX << 1), this._iFinalHeight);
        this._rectItems[0] = new Rectangle(0, MainCanvas.HEIGHT - (this.sprButton.getHeight() << 1), this.sprButton.getWidth() << 1, this.sprButton.getHeight() << 1);
        this._rectItems[1] = new Rectangle(MainCanvas.WIDTH - (this.sprButton.getWidth() << 1), MainCanvas.HEIGHT - (this.sprButton.getHeight() << 1), this.sprButton.getWidth() << 1, this.sprButton.getHeight() << 1);
    }

    public void beforeInteruption() {
        this.mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
        this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
    }

    public void update(long lastRunLenght) {
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _nextMode) {
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintBody(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.drawImage(this.imgBg, 0, 0, 20);
    }

    private void paintBody(Graphics g) {
        this.paintDialog(g);
        this.paintQuit(g);
    }

    private void paintDialog(Graphics g) {
        int row = 0;
        int y = this.rectWindow.y;
        while (row < this.rowDialog) {
            int x = this.rectWindow.x;
            int frame = row == 0 ? 0 : (row == this.rowDialog - 1 ? 6 : 3);
            this.drawSprite(g, x, y, this.sprDialog, frame);
            x += this.sprDialog.getHeight();
            int col = 1;
            while (col < this.colDialog - 1) {
                int frameMid = row == 0 ? 1 : (row == this.rowDialog - 1 ? 7 : 4);
                this.drawSprite(g, x, y, this.sprDialog, frameMid);
                ++col;
                x += this.sprDialog.getHeight();
            }
            frame = row == 0 ? 2 : (row == this.rowDialog - 1 ? 8 : 5);
            this.drawSprite(g, x, y, this.sprDialog, frame);
            ++row;
            y += this.sprDialog.getHeight();
        }
    }

    private void paintQuit(Graphics g) {
        int iShiftY = this.fontBig.getHeight() >> 1;
        this.preparedTextQuit.drawText(g, this.rectWindow, (this.preparedTextQuit.getTextHeight() >> 1) - iShiftY, 3);
    }

    private void paintFK(Graphics g) {
        this.sprButton.setFrame(0);
        if (this.selectedOption == 1) {
            this.sprButton.setFrame(1);
        }
        this.sprButton.setPosition(this.rectYes.x, this.rectYes.y);
        this.sprButton.paint(g);
        this.sprIcons.setFrame(Common.ICON_YES);
        this.sprIcons.setPosition(this.rectYes.getCenterX() - (this.sprIcons.getWidth() >> 1), this.rectYes.getCenterY() - (this.sprIcons.getHeight() >> 1));
        this.sprIcons.paint(g);
        if (this.selectedOption == 2) {
            this.sprButton.setFrame(1);
        }
        this.sprButton.setPosition(this.rectNo.x, this.rectNo.y);
        this.sprButton.paint(g);
        this.sprIcons.setFrame(Common.ICON_NO);
        this.sprIcons.setPosition(this.rectNo.getCenterX() - (this.sprIcons.getWidth() >> 1), this.rectNo.getCenterY() - (this.sprIcons.getHeight() >> 1));
        this.sprIcons.paint(g);
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        if (Keys.isFKLeftCode(keyCode)) {
            this.selectedOption = 1;
            X.quitApp();
        } else if (Keys.isFKRightCode(keyCode)) {
            this.selectedOption = 2;
            this.startAnimation(true, 0);
        }
        this.mainCanvas.repaint();
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this._rectItems.length; ++i) {
            if (!this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 0: {
                    this.selectedOption = 1;
                    Keys.keyPressed(-6);
                    break;
                }
                case 1: {
                    this.selectedOption = 2;
                    Keys.keyPressed(-7);
                    break;
                }
                default: {
                    Keys.keyPressed(53);
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this._rectItems[this._iSelectedCompId].contains(x, y)) {
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyReleased(-6);
                    break;
                }
                case 1: {
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                }
            }
            this.pointerPressed(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this._iSelectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                break;
            }
            case 1: {
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            default: {
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }

    private void initDialog() {
        this.rowDialog = 7;
        this.colDialog = this.rectScreen.width / this.sprDialog.getWidth() - 2;
        int width = this.sprDialog.getWidth() * this.colDialog;
        int height = this.sprDialog.getHeight() * this.rowDialog;
        int x = (this.rectScreen.width >> 1) - (width >> 1);
        int y = (this.rectScreen.height >> 1) - (height >> 1);
        this.rectWindow = new Rectangle(x, y, width, height);
    }

    private void initBottomButtons() {
        int width = this.sprButton.getWidth();
        int height = this.sprButton.getHeight();
        int x = width >> 2;
        int y = this.rectScreen.height - (height + (height >> 2));
        this.rectYes = new Rectangle(x, y, width, height);
        x = this.rectScreen.width - (width + (width >> 2));
        this.rectNo = new Rectangle(x, y, width, height);
    }

    private void drawSprite(Graphics g, int x, int y, Sprite spr, int frame) {
        spr.setFrame(frame);
        spr.setPosition(x, y);
        spr.paint(g);
    }
}

