/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Block;
import sk.inlogic.Flame;
import sk.inlogic.Jewel;
import sk.inlogic.Level;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Storm;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.util.Particles;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Game
implements RMSHandler {
    public static final int MODE_MOVES = 0;
    public static final int MODE_TIME_ATTACK = 1;
    public static final int MODE_ESCAPE = 2;
    public static final int MODE_FALL = 3;
    public static final int MODE_MIXED_TIME_AND_BLOCKS = 4;
    public static final int MODE_BLOCK = 5;
    public static final int MODE_MIXED_TIME_AND_ESCAPE = 6;
    public static final int MODE_MIXED_TIME_AND_MOVES = 7;
    public static final int MODE_ENDLESS = 20;
    public static final int MODE_ACTION = 60;
    public static final int MODE_MIXED = 8;
    public static final int JEWELSINROW = 8;
    public static final int JEWELSCOUNT = 64;
    private static final int SCOREPERJEWEL = 5;
    private static final int STATUS_INITLEVEL = 0;
    private static final int STATUS_FALL = 1;
    private static final int STATUS_READY = 2;
    private static final int STATUS_SWAP = 3;
    private static final int STATUS_SWAPBACK = 4;
    private static final int STATUS_DESTROY = 5;
    private static final int STATUS_LEVELDONE = 6;
    private static final int STATUS_GAMEOVER = 7;
    private static final int STATUS_ESCAPESWAP = 8;
    public static final int LOSE_OUT_OF_MOVES = 1;
    public static final int LOSE_OUT_OF_OPTIONS = 2;
    public static final int LOSE_OUT_OF_TIME = 3;
    public static final int LOSE_BUBBLE_ESCAPED = 4;
    public static final int LOSE_SCORE = 5;
    public static int _iLoseStatus = 0;
    public static int _iProgressSecondary;
    private int _iStatus;
    private int _iGameMode;
    private int _iGameLevel;
    private int _iLoseMode = 0;
    private int _iScore;
    private int _iScoreBomb;
    private int _iScoreEsc;
    private int _iScoreDown;
    private int _iMultiplicator;
    private int _iSelectorFrame;
    private int _iProgressSecondaryFinal;
    private int _iMaxSpecialGems;
    private int selectorPos;
    private int swappedPos;
    private int totalColors;
    private int blockModel;
    public int _iHint;
    public int _iSynchro;
    public int offsetX;
    public int offsetY;
    private long _lTimeElapsed;
    private long _lProgressMain;
    private long _lProgressMainFinal;
    private Jewel[] jewels = new Jewel[64];
    private Jewel[] fallBonus = new Jewel[8];
    public Rectangle rectGameArea;
    private boolean _bIsFinishedScreen;
    private boolean _bIsDragged;
    private boolean _bAllowEscapeSwap;
    private boolean _bPenalty;
    private boolean canMoveUp;
    public static boolean pressed;
    private MainCanvas _mainCanvas;
    private Image _imgGameTile;
    private Sprite _sprBlock;
    private Sprite _sprSelector;
    public static boolean blockChecker;
    public static boolean bhint;

    public void setGameArea(Rectangle rectGameArea) {
        this.rectGameArea = rectGameArea;
    }

    public void restartGame(MainCanvas mc, int gameMode, int gameLevel, int score, int totalCol) {
        int i;
        this.initGraphics();
        this._mainCanvas = mc;
        Level.getLevel(gameLevel);
        Storm.reset(0);
        this._iGameMode = gameMode;
        this._iGameLevel = gameLevel;
        this._iScore = score;
        this._bPenalty = false;
        this._iSelectorFrame = 1;
        this.totalColors = totalCol;
        this.blockModel = score;
        int iShiftY = 0;
        if (MainCanvas.HEIGHT < 640) {
            iShiftY = MainCanvas.HEIGHT >= 480 ? Jewel.BLOCKSIZE >> 3 : Jewel.BLOCKSIZE >> 2;
        }
        this.offsetX = MainCanvas.WIDTH >= 360 ? 2 : 1;
        this.offsetY = MainCanvas.HEIGHT >= 400 ? 2 : 1;
        this.offsetY = 0;
        this.offsetX = 0;
        if (MainCanvas.HEIGHT < 300) {
            iShiftY += iShiftY >> 1;
        }
        this._iSynchro = 0;
        this.selectorPos = 27;
        this._bIsDragged = false;
        this._lTimeElapsed = 0L;
        this._iStatus = 0;
        this._bIsFinishedScreen = false;
        this._iMultiplicator = 1;
        this._iHint = -1;
        Block.reset();
        Flame.reset();
        Particles.resetParticles();
        this.initLevelVariables();
        int deltaY0 = -8 * Jewel.BLOCKSIZE;
        for (i = 0; i < 64; ++i) {
            if (i < 8) {
                this.fallBonus[i] = null;
            }
            this.jewels[i] = new Jewel();
            do {
                int _iTmpNumber;
                if ((_iTmpNumber = RandomNum.getRandomUInt(this.totalColors)) < 0) {
                    _iTmpNumber *= -1;
                }
                this.jewels[i].setColor(_iTmpNumber);
            } while (!this.validatePosition(i));
            this.jewels[i].setAccY(256);
            if (i < 56) continue;
            this.jewels[i].setDeltaY(deltaY0 - RandomNum.getRandomUInt(2 * Jewel.BLOCKSIZE));
        }
        this.initModeVariables();
        for (i = 55; i >= 0; --i) {
            this.jewels[i].setDeltaY(this.jewels[i + 8].getDeltaY() - RandomNum.getRandomUInt(2 * Jewel.BLOCKSIZE));
        }
        this._iScoreBomb = 0;
        this._iScoreEsc = 0;
        this._iScoreDown = 0;
        this._iScore = 0;
    }

    private void initGraphics() {
        if (this._imgGameTile == null) {
            this._imgGameTile = Resources.resImgs[5];
        }
        if (this._sprBlock == null) {
            this._sprBlock = Resources.resSprs[19];
        }
        if (this._sprSelector == null) {
            this._sprSelector = Resources.resSprs[14];
        }
    }

    private void initLevelVariables() {
        switch (this._iGameMode) {
            case 20: {
                this._lProgressMainFinal = 500 * (this._iGameLevel + 2) * (this._iGameLevel + 2);
                break;
            }
            case 0: {
                this._lProgressMainFinal = Level._iMoves;
                break;
            }
            case 7: {
                this._lProgressMainFinal = Level._lTime * 1000L;
                break;
            }
            case 1: {
                this._lProgressMainFinal = Level._lTime * 1000L;
                break;
            }
            case 8: {
                this._lProgressMainFinal = Level._lTime * 1000L;
                break;
            }
            case 60: {
                if (this._iGameLevel > 6) {
                    this._lProgressMainFinal = 90000 - (this._iGameLevel - 7) * 5000;
                    break;
                }
                if (this._iGameLevel > 4) {
                    this._lProgressMainFinal = 100000 - (this._iGameLevel - 5) * 10000;
                    break;
                }
                if (this._iGameLevel > 2) {
                    this._lProgressMainFinal = 110000 - (this._iGameLevel - 3) * 10000;
                    break;
                }
                this._lProgressMainFinal = 120000 - (this._iGameLevel - 1) * 10000;
                break;
            }
            case 2: {
                this._iMaxSpecialGems = 4 + Level._iEscapeObjCount;
                this._lProgressMainFinal = Level._iEscapeObjCount * 3000 / 2;
                this._iProgressSecondaryFinal = Level._iEscapeObjCount;
                break;
            }
            case 6: {
                this._iMaxSpecialGems = 4 + Level._iEscapeObjCount;
                this._lProgressMainFinal = 3000L;
                this._iProgressSecondaryFinal = Level._iEscapeObjCount;
                break;
            }
            case 3: {
                this._iMaxSpecialGems = 4 + Level._iDownfallObjCount;
                this._lProgressMainFinal = Level._iMoves;
                this._iProgressSecondaryFinal = Level._iDownfallObjCount;
                break;
            }
            case 4: {
                this._lProgressMainFinal = Level._lTime * 1000L;
                Block.createBlockShape(this.blockModel);
                break;
            }
            case 5: {
                this._lProgressMainFinal = Level._iMoves;
                Block.createBlockShape(this.blockModel);
            }
        }
    }

    private void initModeVariables() {
        switch (this._iGameMode) {
            case 0: {
                this._lProgressMain = 0L;
                break;
            }
            case 1: {
                this._lProgressMain = this._lProgressMainFinal;
                break;
            }
            case 20: {
                this._lProgressMain = 0L;
                break;
            }
            case 2: {
                this._lProgressMain = this._lProgressMainFinal;
                this.jewels[56 + RandomNum.getRandomUInt(8)].setBonus(7);
                _iProgressSecondary = 0;
                break;
            }
            case 60: {
                this._lProgressMain = this._lProgressMainFinal / 2L;
                break;
            }
            case 3: {
                int random = RandomNum.getRandomUInt(8);
                this.jewels[random].setBonus(6);
                _iProgressSecondary = 0;
            }
            case 4: {
                this._lProgressMain = this._lProgressMainFinal;
                break;
            }
            case 6: {
                this._lProgressMain = 0L;
                _iProgressSecondary = 0;
                break;
            }
            case 5: {
                this._lProgressMain = 0L;
                break;
            }
            case 7: {
                this._lProgressMain = this._lProgressMainFinal;
            }
        }
    }

    private boolean validatePosition(int pos) {
        if (pos / 8 > 1 && this.jewels[pos].isColorDepended() && this.jewels[pos].getColor() == this.jewels[pos - 8].getColor() && this.jewels[pos - 8].isColorDepended() && this.jewels[pos].getColor() == this.jewels[pos - 16].getColor() && this.jewels[pos - 16].isColorDepended()) {
            return false;
        }
        return pos % 8 <= 1 || !this.jewels[pos].isColorDepended() || this.jewels[pos].getColor() != this.jewels[pos - 1].getColor() || !this.jewels[pos - 1].isColorDepended() || this.jewels[pos].getColor() != this.jewels[pos - 2].getColor() || !this.jewels[pos - 2].isColorDepended();
    }

    public void moveUp() {
        if ((this._iStatus == 2 || this._iStatus == 5 || this._iStatus == 1) && this.selectorPos >= 8) {
            if (this._bIsDragged) {
                this.swappedPos = this.selectorPos - 8;
                this.swap(this.selectorPos, this.swappedPos);
                this.selectorPos -= 8;
                this.swappedPos += 8;
                this.setStatus(3);
                MainCanvas.moveCheck = true;
            } else {
                this.selectorPos -= 8;
            }
        }
    }

    public void moveDown() {
        if ((this._iStatus == 2 || this._iStatus == 5 || this._iStatus == 1) && this.selectorPos < 56) {
            if (this._bIsDragged) {
                this.swappedPos = this.selectorPos + 8;
                this.swap(this.selectorPos, this.swappedPos);
                this.selectorPos += 8;
                this.swappedPos -= 8;
                this.setStatus(3);
                MainCanvas.moveCheck = true;
            } else {
                this.selectorPos += 8;
            }
        }
    }

    public void moveLeft() {
        if ((this._iStatus == 2 || this._iStatus == 5 || this._iStatus == 1) && this.selectorPos % 8 > 0) {
            if (this._bIsDragged) {
                this.swappedPos = this.selectorPos - 1;
                this.swap(this.selectorPos, this.swappedPos);
                --this.selectorPos;
                ++this.swappedPos;
                this.setStatus(3);
                MainCanvas.moveCheck = true;
            } else {
                --this.selectorPos;
            }
        }
    }

    public void moveRight() {
        if ((this._iStatus == 2 || this._iStatus == 5 || this._iStatus == 1) && this.selectorPos % 8 < 7) {
            if (this._bIsDragged) {
                this.swappedPos = this.selectorPos + 1;
                this.swap(this.selectorPos, this.swappedPos);
                ++this.selectorPos;
                --this.swappedPos;
                this.setStatus(3);
                MainCanvas.moveCheck = true;
            } else {
                ++this.selectorPos;
            }
        }
    }

    private void swap(int pos1, int pos2) {
        int dx = 0;
        int dy = 0;
        int vx = 0;
        int vy = 0;
        if (pos2 == pos1 - 8) {
            dy = Jewel.BLOCKSIZE;
            vy = -Jewel.MOVE_VELOCITY;
        } else if (pos2 == pos1 + 8) {
            dy = -Jewel.BLOCKSIZE;
            vy = Jewel.MOVE_VELOCITY;
        } else if (pos2 == pos1 - 1) {
            dx = Jewel.BLOCKSIZE;
            vx = -Jewel.MOVE_VELOCITY;
        } else if (pos2 == pos1 + 1) {
            dx = -Jewel.BLOCKSIZE;
            vx = Jewel.MOVE_VELOCITY;
        } else {
            return;
        }
        this.jewels[pos1].setDeltaX(dx);
        this.jewels[pos1].setDeltaY(dy);
        this.jewels[pos1].setVelX(vx);
        this.jewels[pos1].setVelY(vy);
        this.jewels[pos2].setDeltaX(-dx);
        this.jewels[pos2].setDeltaY(-dy);
        this.jewels[pos2].setVelX(-vx);
        this.jewels[pos2].setVelY(-vy);
        Jewel gb = this.jewels[pos1];
        this.jewels[pos1] = this.jewels[pos2];
        this.jewels[pos2] = gb;
        if (this.jewels[pos1].getResource() == 0) {
            this.jewels[pos1].startAnimation(1);
        }
        if (this.jewels[pos2].getResource() == 0) {
            this.jewels[pos2].startAnimation(1);
        }
    }

    public void DragOrDrop() {
        if (this._iStatus == 2) {
            boolean bl = this._bIsDragged = !this._bIsDragged;
            if (!this._bIsDragged) {
                this._iSelectorFrame = 1;
            }
        }
    }

    public void bomb() {
        this.jewels[this.selectorPos].setBonus(5);
    }

    public void pointerPressed(int x, int y) {
        if (this._iStatus == 2 || this._iStatus == 5 || this._iStatus == 1) {
            int i = (x - this.rectGameArea.x) / (this.rectGameArea.width / 8);
            int j = (y - 1 - this.rectGameArea.y) / (this.rectGameArea.height / 8);
            int pointedPos = j * 8 + i;
            if (this._bIsDragged) {
                if (this.selectorPos == pointedPos - 1) {
                    this.moveRight();
                } else if (this.selectorPos == pointedPos + 1) {
                    this.moveLeft();
                } else if (this.selectorPos == pointedPos - 8) {
                    this.moveDown();
                } else if (this.selectorPos == pointedPos + 8) {
                    this.moveUp();
                } else {
                    this.selectorPos = pointedPos;
                }
            } else {
                this.selectorPos = pointedPos;
            }
            if (this._iStatus == 2) {
                this._bIsDragged = true;
            }
        }
    }

    public int getMode() {
        return this._iGameMode;
    }

    public int getLevel() {
        return this._iGameLevel;
    }

    public int getScore() {
        return this._iScore;
    }

    public int getBombScore() {
        return this._iScoreBomb;
    }

    public int getEscScore() {
        return this._iScoreEsc;
    }

    public int getDownScore() {
        return this._iScoreDown;
    }

    public int getTimeInSec() {
        return (int)(this._lTimeElapsed / 1000L);
    }

    public int getProgresRate() {
        return (int)((this._lProgressMain << 8) / this._lProgressMainFinal);
    }

    public String getProgresText() {
        return Integer.toString(_iProgressSecondary) + "/" + Integer.toString(this._iProgressSecondaryFinal);
    }

    public boolean isGameOver() {
        return this._bIsFinishedScreen && this._iStatus == 7;
    }

    public boolean isLevelDone() {
        return this._bIsFinishedScreen && this._iStatus == 6;
    }

    public void update(long lastRunLenght) {
        if (this._bIsFinishedScreen) {
            return;
        }
        this.updateJewels(lastRunLenght);
        this._iSelectorFrame = this._bIsDragged ? (this._iSelectorFrame + 1) % 4 : 0;
        switch (this._iStatus) {
            case 0: {
                this.updateStatusInitLevel();
                break;
            }
            case 2: {
                this.updateTime(lastRunLenght);
                break;
            }
            case 3: {
                this.updateStatusSwap();
                this.updateTime(lastRunLenght);
                break;
            }
            case 4: {
                this.updateStatusSwapBack();
                this.updateTime(lastRunLenght);
                break;
            }
            case 1: {
                this.updateStatusFall();
                this.updateTime(lastRunLenght);
                this.canMoveUp = true;
                break;
            }
            case 5: {
                this.updateStatusDestroy();
                this.updateTime(lastRunLenght);
                break;
            }
            case 8: {
                this.updateStatusSwap();
                this.updateStatusEscapeSwap();
                this.updateTime(lastRunLenght);
                this.canMoveUp = false;
                pressed = false;
                break;
            }
            case 6: {
                this.updateStatusFinishLevel();
                break;
            }
            case 7: {
                this.updateStatusFinishLevel();
            }
        }
    }

    private void updateTime(long lastRunLenght) {
        if (lastRunLenght < 1000L) {
            this._lTimeElapsed += lastRunLenght;
            if (!(this._iGameMode != 1 && this._iGameMode != 60 && this._iGameMode != 2 && this._iGameMode != 7 && this._iGameMode != 4 && this._iGameMode != 6 || this._iGameMode == 2 && this._iStatus != 2 && this._iStatus != 3 && this._iStatus != 4)) {
                this._lProgressMain -= lastRunLenght;
                if (this._lProgressMain < 0L) {
                    if (this._iGameMode == 6) {
                        if ((long)this.getTimeInSec() >= Level._lTime) {
                            if (_iProgressSecondary < this._iProgressSecondaryFinal && this.getScore() < Level._iScoreMin && MainCanvas.moveCounter > Level._iMoves) {
                                this.setStatus(7);
                            }
                        } else if ((long)this.getTimeInSec() >= Level._lTime) {
                            if (_iProgressSecondary >= this._iProgressSecondaryFinal && this.getScore() + this.getResidueScore() >= Level._iScoreMin) {
                                this._iScore += this.getResidueScore();
                                if (MainCanvas.moveCounter == Level._iMoves) {
                                    this.setStatus(6);
                                }
                            }
                        } else {
                            this.swapEscapeGems();
                        }
                    } else if (this._iGameMode == 2) {
                        this.swapEscapeGems();
                    } else if (this._iGameMode == 1) {
                        if (Level._iScoreMin <= this.getScore() + this.getResidueScore()) {
                            this.setStatus(6);
                        } else if ((long)this.getTimeInSec() >= Level._lTime) {
                            this.setStatus(7);
                            this.setLoseMode(3);
                        }
                    } else if (this._iGameMode == 4) {
                        if (Block.count() > 0) {
                            if ((long)this.getTimeInSec() >= Level._lTime) {
                                this.setStatus(7);
                                this.setLoseMode(3);
                            }
                        } else if ((long)this.getTimeInSec() >= Level._lTime) {
                            if (this.getScore() + this.getResidueScore() >= Level._iScoreMin) {
                                this._iScore += this.getResidueScore();
                                this.setStatus(6);
                            } else {
                                this.setStatus(7);
                                this.setLoseMode(3);
                            }
                        }
                    } else if (this._iGameMode == 7) {
                        if ((long)this.getTimeInSec() >= Level._lTime) {
                            if (MainCanvas.moveCounter >= Level._iMoves) {
                                if (Level._iScoreMin <= this.getScore()) {
                                    this.setStatus(6);
                                } else {
                                    this.setStatus(7);
                                    this.setLoseMode(3);
                                }
                            } else {
                                this.setStatus(7);
                                this.setLoseMode(1);
                            }
                        }
                    } else {
                        this.setStatus(7);
                        this.setLoseMode(3);
                    }
                }
            }
        }
    }

    private void updateJewels(long lastRunLenght) {
        this._iSynchro = (int)((long)this._iSynchro + lastRunLenght);
        if (this._iSynchro > 50) {
            for (int pos = 0; pos < 64; ++pos) {
                this.jewels[pos].update();
                if (pos >= 8 || this.fallBonus[pos] == null) continue;
                this.fallBonus[pos].updateFall();
            }
            this._iSynchro -= 50;
        }
    }

    private void updateStatusInitLevel() {
        for (int pos = 0; pos < 8; ++pos) {
            if (!this.jewels[pos].isMoving()) continue;
            return;
        }
        this.setStatus(2);
    }

    private void updateStatusFinishLevel() {
        for (int pos = 0; pos < 8; ++pos) {
            if (this.jewels[pos].getDeltaY() >= 8 * Jewel.BLOCKSIZE) continue;
            return;
        }
        this._bIsFinishedScreen = true;
    }

    private void updateStatusSwap() {
        if (!this.jewels[this.selectorPos].isMoving()) {
            this._bIsDragged = false;
            this.destroyPosition(this.selectorPos);
            this.destroyPosition(this.swappedPos);
            if (this._iStatus == 3) {
                this.swap(this.selectorPos, this.swappedPos);
                int back = this.selectorPos;
                this.selectorPos = this.swappedPos;
                this.swappedPos = back;
                this.setStatus(4);
            }
        }
    }

    private void updateStatusEscapeSwap() {
        int pos;
        for (pos = 0; pos < 64; ++pos) {
            if (this.jewels[pos].getBonus() != 7) continue;
            if (this.jewels[pos].getDeltaY() < -30) {
                this.setStatus(7);
                this.setLoseMode(4);
                return;
            }
            if (this.jewels[pos].getDeltaY() == 0) continue;
            return;
        }
        for (pos = 0; pos < 64; ++pos) {
            if (this.jewels[pos].getBonus() != 7) continue;
            this.destroyPosition(pos);
            if (pos >= 56) continue;
            this.destroyPosition(pos + 8);
        }
        if (this._iStatus == 8) {
            this.setStatus(2);
        }
    }

    private void destroyPosition(int pos) {
        int toppos;
        int vsize;
        int leftpos = this.getLeftBoundColorBlock(pos);
        int hsize = this.getHSizeOfColorBlock(leftpos);
        if (hsize > 2) {
            this.destroyBlockHorizontally(leftpos, hsize);
            this.setStatus(5);
        }
        if ((vsize = this.getVSizeOfColorBlock(toppos = this.getTopBoundColorPosition(pos))) > 2) {
            this.destroyBlockVertically(toppos, vsize);
            this.setStatus(5);
        }
        if (this.jewels[pos].getBonus() == 2) {
            this.destroyJewelOnPosition(pos);
            this.setStatus(5);
        }
        if (!(pos != this.selectorPos && pos != this.swappedPos || this.jewels[pos].getBonus() != 5 && this.jewels[pos].getBonus() != 1)) {
            if (this.jewels[this.selectorPos].getBonus() == 5 && this.jewels[this.swappedPos].getBonus() == 1) {
                this.destroyBonusCrossCross(this.selectorPos);
                this.destroyBonusBombBomb(this.swappedPos);
                this.setStatus(5);
            } else if (this.jewels[this.swappedPos].getBonus() == 5 && this.jewels[this.selectorPos].getBonus() == 1) {
                this.destroyBonusCrossCross(this.swappedPos);
                this.destroyBonusBombBomb(this.selectorPos);
                this.setStatus(5);
            } else if (this.jewels[this.selectorPos].getBonus() == 5 && this.jewels[this.swappedPos].getBonus() == 5 || this.jewels[this.swappedPos].getBonus() == 5 && this.jewels[this.selectorPos].getBonus() == 5) {
                this.destroyBonusCrossCross(this.selectorPos);
                this.destroyBonusCrossCross(this.swappedPos);
                this.setStatus(5);
            } else if (this.jewels[this.selectorPos].getBonus() == 1 && this.jewels[this.swappedPos].getBonus() == 1 || this.jewels[this.swappedPos].getBonus() == 1 && this.jewels[this.selectorPos].getBonus() == 1) {
                this.destroyBonusBombBomb(this.selectorPos);
                this.destroyBonusBombBomb(this.swappedPos);
                this.setStatus(5);
            }
        }
        if (hsize > 2 && vsize > 2) {
            this.jewels[pos].setBonus(5);
            if (hsize > 4) {
                this.jewels[pos - 1].setBonus(2);
            } else if (hsize > 3) {
                if (leftpos < pos - 1) {
                    this.jewels[pos - 1].setBonus(1);
                } else {
                    this.jewels[pos + 1].setBonus(1);
                }
            }
            if (vsize > 4) {
                this.jewels[toppos].setBonus(2);
            } else if (vsize > 3) {
                this.jewels[toppos].setBonus(1);
            }
        } else if (hsize > 4) {
            this.jewels[pos].setBonus(2);
        } else if (vsize > 4) {
            this.jewels[pos].setBonus(2);
        } else if (hsize > 3) {
            this.jewels[pos].setBonus(1);
        } else if (vsize > 3) {
            this.jewels[pos].setBonus(1);
        }
    }

    private void destroyBonusBombBomb(int pos) {
        if (pos % 8 > 0) {
            this.destroyJewelOnPosition(pos - 1);
            Flame.setFlame(pos - 1);
            if (pos / 8 > 0) {
                this.destroyJewelOnPosition(pos - 8 - 1);
                Flame.setFlame(pos - 8 - 1);
            }
            if (pos / 8 < 7) {
                this.destroyJewelOnPosition(pos + 8 - 1);
                Flame.setFlame(pos + 8 - 1);
            }
        }
        if (pos % 8 < 7) {
            this.destroyJewelOnPosition(pos + 1);
            Flame.setFlame(pos + 1);
            if (pos / 8 > 0) {
                this.destroyJewelOnPosition(pos - 8 + 1);
                Flame.setFlame(pos - 8 + 1);
            }
            if (pos / 8 < 7) {
                this.destroyJewelOnPosition(pos + 8 + 1);
                Flame.setFlame(pos + 8 + 1);
            }
        }
        if (pos / 8 > 0) {
            this.destroyJewelOnPosition(pos - 8);
            Flame.setFlame(pos - 8);
        }
        if (pos / 8 < 7) {
            this.destroyJewelOnPosition(pos + 8);
            Flame.setFlame(pos + 8);
        }
        this.setExplosionMove(pos);
        this.setStatus(2);
    }

    private void destroyBonusCrossCross(int pos) {
        int i;
        for (i = pos % 8; i < 64; i += 8) {
            this.destroyJewelOnPosition(i);
            Flame.setFlame(i);
        }
        for (i = pos / 8 * 8; i < (pos / 8 + 1) * 8; ++i) {
            this.destroyJewelOnPosition(i);
            Flame.setFlame(i);
        }
        this.setStatus(2);
    }

    private int getLeftBoundColorBlock(int pos) {
        if (!this.jewels[pos].isColorDepended()) {
            return pos;
        }
        while (pos % 8 > 0 && this.jewels[pos - 1].isColorDepended() && this.jewels[pos].getColor() == this.jewels[pos - 1].getColor()) {
            --pos;
        }
        return pos;
    }

    private int getTopBoundColorPosition(int pos) {
        if (!this.jewels[pos].isColorDepended()) {
            return pos;
        }
        while (pos / 8 > 0 && this.jewels[pos - 8].isColorDepended() && this.jewels[pos].getColor() == this.jewels[pos - 8].getColor()) {
            pos -= 8;
        }
        return pos;
    }

    private int getHSizeOfColorBlock(int pos) {
        int size = 1;
        if (!this.jewels[pos].isColorDepended()) {
            return size;
        }
        int i = pos;
        while (i % 8 < 7 && this.jewels[i + 1].isColorDepended() && this.jewels[i].getColor() == this.jewels[i + 1].getColor()) {
            ++size;
            ++i;
        }
        return size;
    }

    private int getVSizeOfColorBlock(int pos) {
        int size = 1;
        if (!this.jewels[pos].isColorDepended()) {
            return size;
        }
        int i = pos;
        while (i / 8 < 7 && this.jewels[i + 8].isColorDepended() && this.jewels[i].getColor() == this.jewels[i + 8].getColor()) {
            ++size;
            i += 8;
        }
        return size;
    }

    private void destroyBlockHorizontally(int pos, int size) {
        for (int i = pos; i < pos + size; ++i) {
            this.destroyJewelOnPosition(i);
        }
    }

    private void destroyBlockVertically(int pos, int size) {
        for (int i = pos; i < pos + size * 8; i += 8) {
            this.destroyJewelOnPosition(i);
        }
    }

    private void destroyJewelOnPosition(int pos) {
        if (this.jewels[pos].getBonus() == 6) {
            return;
        }
        if (this.jewels[pos].getResource() != 1) {
            Block.destroy(pos);
            this.addScoreAndTime(1);
            this.jewels[pos].setResource(1);
            this.jewels[pos].startAnimation(1);
            if (this.jewels[pos].getBonus() == 7) {
                this._iScore += 250;
                this._iScoreEsc += 250;
            }
            if (this.jewels[pos].getBonus() == 1) {
                if (pos % 8 > 0) {
                    this.destroyJewelOnPosition(pos - 1);
                    Flame.setFlame(pos - 1);
                    if (pos / 8 > 0) {
                        this.destroyJewelOnPosition(pos - 8 - 1);
                        Flame.setFlame(pos - 8 - 1);
                    }
                    if (pos / 8 < 7) {
                        this.destroyJewelOnPosition(pos + 8 - 1);
                        Flame.setFlame(pos + 8 - 1);
                    }
                }
                if (pos % 8 < 7) {
                    this.destroyJewelOnPosition(pos + 1);
                    Flame.setFlame(pos + 1);
                    if (pos / 8 > 0) {
                        this.destroyJewelOnPosition(pos - 8 + 1);
                        Flame.setFlame(pos - 8 + 1);
                    }
                    if (pos / 8 < 7) {
                        this.destroyJewelOnPosition(pos + 8 + 1);
                        Flame.setFlame(pos + 8 + 1);
                    }
                }
                if (pos / 8 > 0) {
                    this.destroyJewelOnPosition(pos - 8);
                    Flame.setFlame(pos - 8);
                }
                if (pos / 8 < 7) {
                    this.destroyJewelOnPosition(pos + 8);
                    Flame.setFlame(pos + 8);
                }
                this.setExplosionMove(pos);
            } else if (this.jewels[pos].getBonus() == 5) {
                int i;
                for (i = pos % 8; i < 64; i += 8) {
                    this.destroyJewelOnPosition(i);
                    Flame.setFlame(i);
                }
                for (i = pos / 8 * 8; i < (pos / 8 + 1) * 8; ++i) {
                    this.destroyJewelOnPosition(i);
                    Flame.setFlame(i);
                }
            } else if (this.jewels[pos].getBonus() == 2) {
                int color = -1;
                if ((pos == this.selectorPos || pos == this.swappedPos) && this.jewels[this.selectorPos].getBonus() == 2 && this.jewels[this.swappedPos].getBonus() == 2) {
                    for (int i = 0; i < 64; ++i) {
                        this.destroyJewelOnPosition(i);
                    }
                } else if ((pos == this.selectorPos || pos == this.swappedPos) && this.jewels[this.selectorPos].getBonus() == 2 && this.jewels[this.swappedPos].getBonus() == 5) {
                    int i;
                    for (i = 0; i < 64; ++i) {
                        if (this.jewels[i].getColor() != this.jewels[this.swappedPos].getColor()) continue;
                        this.jewels[i].setBonus(5);
                        this.destroyJewelOnPosition(i);
                    }
                    for (i = 0; i < 64; ++i) {
                        if (this.jewels[i].getBonus() != 5) continue;
                        this.destroyJewelOnPosition(i);
                    }
                } else if ((pos == this.selectorPos || pos == this.swappedPos) && this.jewels[this.swappedPos].getBonus() == 2 && this.jewels[this.selectorPos].getBonus() == 5) {
                    int i;
                    for (i = 0; i < 64; ++i) {
                        if (this.jewels[i].getColor() != this.jewels[this.selectorPos].getColor()) continue;
                        this.jewels[i].setBonus(5);
                        this.destroyJewelOnPosition(i);
                    }
                    for (i = 0; i < 64; ++i) {
                        if (this.jewels[i].getBonus() != 5) continue;
                        this.destroyJewelOnPosition(i);
                    }
                } else if ((pos == this.selectorPos || pos == this.swappedPos) && this.jewels[this.selectorPos].getBonus() == 2 && this.jewels[this.swappedPos].getBonus() == 1) {
                    int i;
                    for (i = 0; i < 64; ++i) {
                        if (this.jewels[i].getColor() != this.jewels[this.swappedPos].getColor()) continue;
                        this.jewels[i].setBonus(1);
                        this.destroyJewelOnPosition(i);
                    }
                    for (i = 0; i < 64; ++i) {
                        if (this.jewels[i].getBonus() != 1) continue;
                        this.destroyJewelOnPosition(i);
                    }
                } else if ((pos == this.selectorPos || pos == this.swappedPos) && this.jewels[this.swappedPos].getBonus() == 2 && this.jewels[this.selectorPos].getBonus() == 1) {
                    int i;
                    for (i = 0; i < 64; ++i) {
                        if (this.jewels[i].getColor() != this.jewels[this.selectorPos].getColor()) continue;
                        this.jewels[i].setBonus(1);
                        this.destroyJewelOnPosition(i);
                    }
                    for (i = 0; i < 64; ++i) {
                        if (this.jewels[i].getBonus() != 1) continue;
                        this.destroyJewelOnPosition(i);
                    }
                } else {
                    color = pos == this.selectorPos && this.jewels[this.swappedPos].isColorDepended() ? this.jewels[this.swappedPos].getColor() : (pos == this.swappedPos && this.jewels[this.selectorPos].isColorDepended() ? this.jewels[this.selectorPos].getColor() : (pos >= 8 && this.jewels[pos - 8].getBonus() == 7 ? this.jewels[pos - 8].getColor() : RandomNum.getRandomUInt(this.totalColors)));
                    if (Storm.getCount() == 0) {
                        Storm.reset(pos);
                    }
                    int i = pos;
                    while ((i = this.getNearestOf(i, color)) != -1) {
                        this.destroyJewelOnPosition(i);
                        Storm.addPoint(i);
                        if (i != -1) continue;
                    }
                    for (int j = 0; j < 64; ++j) {
                        if (this.jewels[j].getColor() != color || !this.jewels[j].isColorDepended() || this.jewels[j].getResource() == 1) continue;
                        this.destroyJewelOnPosition(j);
                        Storm.addPoint(j);
                    }
                }
            } else if (this.jewels[pos].getBonus() == 7) {
                ++_iProgressSecondary;
            }
        }
        if (MainCanvas.moveCheck) {
            ++MainCanvas.moveCounter;
            MainCanvas.moveCheck = false;
        }
    }

    private void setExplosionMove(int pos) {
        int vel = this.rectGameArea.width * 1024 / 240;
        int acc = this.rectGameArea.width * 256 / 240;
        for (int i = 1; i < 3; ++i) {
            int p1 = pos - i * 8 - i;
            int p2 = pos + i * 8 + i;
            for (int j = 0; j <= i * 2; ++j) {
                int k;
                if (p1 + j >= 0 && p1 + j < 64 && (p1 + j) / 8 == pos / 8 - i) {
                    this.jewels[p1 + j].setDeltaY(-1);
                    this.jewels[p1 + j].setVelY(-vel / i);
                    this.jewels[p1 + j].setAccY(acc / i);
                    k = j - i;
                    this.jewels[p1 + j].setDeltaX(k);
                    this.jewels[p1 + j].setVelX(k * vel / i);
                    this.jewels[p1 + j].setAccX(-k * acc / i);
                }
                if (p1 + j * 8 >= 0 && p1 + j * 8 < 64 && p1 / 8 + j - (p1 < 0 ? 1 : 0) == pos / 8 - i + j) {
                    this.jewels[p1 + j * 8].setDeltaX(-1);
                    this.jewels[p1 + j * 8].setVelX(-vel / i);
                    this.jewels[p1 + j * 8].setAccX(acc / i);
                    k = j - i;
                    this.jewels[p1 + j * 8].setDeltaY(k);
                    this.jewels[p1 + j * 8].setVelY(k * vel / i);
                    this.jewels[p1 + j * 8].setAccY(-k * acc / i);
                }
                if (p2 - j >= 0 && p2 - j < 64 && (p2 - j) / 8 == pos / 8 + i) {
                    this.jewels[p2 - j].setDeltaY(1);
                    this.jewels[p2 - j].setVelY(vel / i);
                    this.jewels[p2 - j].setAccY(-acc / i);
                    k = i - j;
                    this.jewels[p2 - j].setDeltaX(k);
                    this.jewels[p2 - j].setVelX(k * vel / i);
                    this.jewels[p2 - j].setAccX(-k * acc / i);
                }
                if (p2 - j * 8 < 0 || p2 - j * 8 >= 64 || p2 / 8 - j + (p2 >= 64 ? 1 : 0) != pos / 8 + i - j) continue;
                this.jewels[p2 - j * 8].setDeltaX(1);
                this.jewels[p2 - j * 8].setVelX(vel / i);
                this.jewels[p2 - j * 8].setAccX(-acc / i);
                k = i - j;
                this.jewels[p2 - j * 8].setDeltaY(k);
                this.jewels[p2 - j * 8].setVelY(k * vel / i);
                this.jewels[p2 - j * 8].setAccY(-k * acc / i);
            }
        }
    }

    private int getNearestOf(int pos, int color) {
        for (int i = 1; i < 8; ++i) {
            int j;
            for (j = pos - i - i * 8; j <= pos + i - i * 8; ++j) {
                if (j < 0 || j >= 64 || this.jewels[j].getColor() != color || !this.jewels[j].isColorDepended() || this.jewels[j].getResource() == 1) continue;
                return j;
            }
            for (j = pos - i; j <= pos + i; ++j) {
                if (j < 0 || j >= 64 || this.jewels[j].getColor() != color || !this.jewels[j].isColorDepended() || this.jewels[j].getResource() == 1) continue;
                return j;
            }
            for (j = pos - i + i * 8; j <= pos + i + i * 8; ++j) {
                if (j < 0 || j >= 64 || this.jewels[j].getColor() != color || !this.jewels[j].isColorDepended() || this.jewels[j].getResource() == 1) continue;
                return j;
            }
        }
        return -1;
    }

    private void updateStatusSwapBack() {
        if (!this.jewels[this.selectorPos].isMoving()) {
            this.setStatus(2);
        }
    }

    private void updateStatusFall() {
        for (int pos = 0; pos < 8; ++pos) {
            if (!this.jewels[pos].isMoving()) continue;
            return;
        }
        this.destroyJewels();
        if (this._iStatus == 1) {
            if (Level._iGameMode == Level.TYPE_MOVES) {
                if (MainCanvas.moveCounter == Level._iMoves) {
                    if (this.getScore() + this.getResidueScore() >= Level._iScoreMin) {
                        this._iScore = this.getScore() + this.getResidueScore();
                        this.setStatus(6);
                    } else {
                        this.setStatus(7);
                        this.setLoseMode(1);
                    }
                } else {
                    this.setStatus(2);
                }
            } else if (Level._iGameMode == Level.TYPE_TIME_ATTACK) {
                if ((long)this.getTimeInSec() == Level._lTime) {
                    if (this.getScore() + this.getResidueScore() >= Level._iScoreMin) {
                        this._iScore = this.getScore() + this.getResidueScore();
                        this.setStatus(6);
                    } else {
                        this.setStatus(7);
                        this.setLoseMode(3);
                    }
                } else {
                    this.setStatus(2);
                }
            } else if (this._iGameMode == 7) {
                if ((long)this.getTimeInSec() >= Level._lTime) {
                    if (MainCanvas.moveCounter >= Level._iMoves) {
                        if (Level._iScoreMin <= this.getScore()) {
                            this.setStatus(6);
                        } else {
                            this.setStatus(7);
                            this.setLoseMode(3);
                        }
                    } else {
                        this.setStatus(7);
                    }
                } else {
                    this.setStatus(2);
                }
            } else if (this._iGameMode == 4) {
                if (Block.count() > 0) {
                    this.setStatus(2);
                } else if ((long)this.getTimeInSec() >= Level._lTime) {
                    if (this.getScore() + this.getResidueScore() >= Level._iScoreMin) {
                        this._iScore = this.getScore() + this.getResidueScore();
                        this.setStatus(6);
                    } else {
                        this.setStatus(7);
                        this.setLoseMode(3);
                    }
                } else {
                    this.setStatus(2);
                }
            } else if (this._iGameMode == 5) {
                if (Block.count() > 0) {
                    if (MainCanvas.moveCounter < Level._iMoves) {
                        this.setStatus(2);
                    } else {
                        this.setStatus(7);
                        this.setLoseMode(1);
                    }
                } else if (MainCanvas.moveCounter >= Level._iMoves) {
                    this._iScore += (Level._iMoves - MainCanvas.moveCounter) * 100;
                    if (this.getScore() + this.getResidueScore() >= Level._iScoreMin) {
                        this._iScore = this.getScore() + this.getResidueScore();
                        this.setStatus(6);
                    } else {
                        this.setStatus(7);
                        this.setLoseMode(1);
                    }
                } else if (MainCanvas.moveCounter < Level._iMoves) {
                    this.setStatus(2);
                } else {
                    this.setStatus(7);
                }
            } else if (this._iGameMode == 3) {
                if (MainCanvas.moveCounter == Level._iMoves) {
                    if (Level._iScoreMin <= this.getScore() + this.getResidueScore()) {
                        if (_iProgressSecondary >= this._iProgressSecondaryFinal) {
                            this._iScore = this.getScore() + this.getResidueScore();
                            this.setStatus(6);
                        } else {
                            this.setStatus(7);
                            this.setLoseMode(1);
                        }
                    } else {
                        this.setStatus(7);
                        this.setLoseMode(1);
                    }
                } else if (MainCanvas.moveCounter >= Level._iMoves) {
                    this.setStatus(7);
                } else {
                    this.setStatus(2);
                }
            } else if (this._iGameMode == 2) {
                if (MainCanvas.moveCounter == Level._iMoves) {
                    if (Level._iScoreMin <= this.getScore() + this.getResidueScore()) {
                        if (_iProgressSecondary >= this._iProgressSecondaryFinal) {
                            this._iScore = this.getScore() + this.getResidueScore();
                            this.setStatus(6);
                        } else {
                            this.setStatus(7);
                            this.setLoseMode(1);
                        }
                    } else {
                        this.setStatus(7);
                        this.setLoseMode(1);
                    }
                } else if (MainCanvas.moveCounter < Level._iMoves) {
                    if (this._bAllowEscapeSwap) {
                        this.swapEscapeGems();
                    } else {
                        this.setStatus(2);
                    }
                } else if (MainCanvas.moveCounter > Level._iMoves) {
                    this.setStatus(7);
                }
            } else if (this._iGameMode == 6) {
                if ((long)this.getTimeInSec() >= Level._lTime) {
                    if (_iProgressSecondary >= this._iProgressSecondaryFinal) {
                        if (this.getScore() + this.getResidueScore() >= Level._iScoreMin) {
                            if (MainCanvas.moveCounter <= Level._iMoves) {
                                this._iScore = this.getScore() + this.getResidueScore();
                                this.setStatus(6);
                            } else {
                                this.setStatus(7);
                            }
                        } else {
                            this.setStatus(7);
                        }
                    } else {
                        this.setStatus(7);
                    }
                } else {
                    this.setStatus(2);
                }
            }
        }
    }

    private void swapEscapeGems() {
        this._bAllowEscapeSwap = false;
        if (this._iGameMode == 2 && this.canMoveUp && pressed) {
            int pos;
            this._lProgressMain = this._lProgressMainFinal;
            for (pos = 0; pos < 8; ++pos) {
                if (this.jewels[pos].getBonus() != 7) continue;
                this.jewels[pos].setDeltaY(-1);
                this.jewels[pos].setVelY(-(Jewel.MOVE_VELOCITY << 8));
                this.setStatus(8);
            }
            for (pos = 8; pos < 64; ++pos) {
                if (this.jewels[pos].getBonus() != 7 || this.jewels[pos - 8].getBonus() == 7) continue;
                Jewel gb = this.jewels[pos];
                gb.setDeltaY(Jewel.BLOCKSIZE);
                gb.setVelY(-Jewel.MOVE_VELOCITY);
                this.jewels[pos] = this.jewels[pos - 8];
                this.jewels[pos].setDeltaY(-Jewel.BLOCKSIZE);
                this.jewels[pos].setVelY(Jewel.MOVE_VELOCITY);
                this.jewels[pos - 8] = gb;
                this.setStatus(8);
            }
            int escapeCount = 0;
            for (int i = 0; i < 64; ++i) {
                if (this.jewels[i].getBonus() != 7) continue;
                ++escapeCount;
            }
            int p = RandomNum.getRandomUInt(100);
            if (p < (this._iMaxSpecialGems - escapeCount) * 100 / this._iMaxSpecialGems) {
                int pos2 = 56 + RandomNum.getRandomUInt(8);
                for (int i = 0; i < 8 && this.jewels[pos2].getBonus() != 0; ++i) {
                    if (++pos2 < 64) continue;
                    pos2 -= 8;
                }
                this.jewels[pos2].setBonus(7);
            }
        }
    }

    private void setFadeFall(int pos) {
        this.jewels[pos].setResource(4);
        this.jewels[pos].startAnimation(-1);
        int dx = Resources.resSprs[51].getWidth() - this.rectGameArea.x - pos % 8 * Jewel.BLOCKSIZE;
        this.jewels[pos].setVelX(dx << 3);
        this.jewels[pos].setVelY(-this.rectGameArea.width * 3840 / 240);
        this.jewels[pos].setAccY(this.rectGameArea.width * 256 / 240);
        this.fallBonus[pos % 8] = this.jewels[pos];
        this.jewels[pos] = new Jewel();
        this.jewels[pos].setResource(4);
        this.setStatus(5);
        ++_iProgressSecondary;
        this._iScore += 250;
        this._iScoreDown += 250;
    }

    private void destroyJewels() {
        for (int pos = 0; pos < 64; ++pos) {
            if (pos >= 56 && this.jewels[pos].getBonus() == 6) {
                this.setFadeFall(pos);
                continue;
            }
            int leftpos = this.getLeftBoundColorBlock(pos);
            int hsize = this.getHSizeOfColorBlock(leftpos);
            int toppos = this.getTopBoundColorPosition(pos);
            int vsize = this.getVSizeOfColorBlock(toppos);
            if (hsize > 2 && vsize > 2) {
                this.destroyBlockHorizontally(leftpos, hsize);
                this.destroyBlockVertically(toppos, vsize);
                this.jewels[pos].setBonus(5);
                this.setStatus(5);
                continue;
            }
            if (hsize > 2 && pos == leftpos + hsize - 1) {
                if (this.jewels[pos].getResource() != 1) {
                    this.destroyBlockHorizontally(leftpos, hsize);
                }
                if (hsize > 4) {
                    this.jewels[pos].setBonus(2);
                } else if (hsize > 3) {
                    this.jewels[pos].setBonus(1);
                }
                this.setStatus(5);
                continue;
            }
            if (vsize <= 2 || pos != toppos + (vsize - 1) * 8) continue;
            if (this.jewels[pos].getResource() != 1) {
                this.destroyBlockVertically(toppos, vsize);
            }
            if (vsize > 4) {
                this.jewels[toppos].setBonus(2);
            } else if (vsize > 3) {
                this.jewels[pos].setBonus(1);
            }
            this.setStatus(5);
        }
    }

    private void updateStatusDestroy() {
        int p;
        int pos;
        int col = -1;
        int fallCount = 0;
        for (pos = 0; pos < 64; ++pos) {
            if (this.jewels[pos].getResource() != 1 || this.jewels[pos].getAnimationRepeats() == 0) continue;
            return;
        }
        for (pos = 0; pos < 64; ++pos) {
            if (this.jewels[pos].getBonus() == 6) {
                ++fallCount;
            }
            if (this.jewels[pos].getResource() != 4 && (this.jewels[pos].getResource() != 1 || this.jewels[pos].getAnimationRepeats() != 0)) continue;
            this.leachJewelOnTop(pos);
            if (this._iStatus == 1) continue;
            if (this._iGameMode == 3) {
                col = pos % 8;
            }
            Storm.reset(0);
            this.setStatus(1);
            ++this._iMultiplicator;
        }
        if (col >= 0 && (p = RandomNum.getRandomUInt(100)) < (this._iMaxSpecialGems - fallCount) * 100 / this._iMaxSpecialGems) {
            this.jewels[col].setBonus(6);
        }
    }

    private void leachJewelOnTop(int pos) {
        Jewel gb = this.jewels[pos];
        for (int i = pos; i >= 8; i -= 8) {
            this.jewels[i] = this.jewels[i - 8];
            int dy = this.jewels[i].getDeltaY();
            this.jewels[i].setDeltaY(dy - Jewel.BLOCKSIZE);
            this.jewels[i].setVelY(Jewel.MOVE_VELOCITY);
            this.jewels[i].setAccY(128);
        }
        this.jewels[pos % 8] = gb;
        gb.reset();
        gb.setColor(RandomNum.getRandomUInt(this.totalColors));
        int dy = this.jewels[pos % 8 + 8].getDeltaY();
        if (dy > -Jewel.BLOCKSIZE) {
            dy = -Jewel.BLOCKSIZE;
        }
        gb.setDeltaY(dy);
        gb.setVelY(Jewel.MOVE_VELOCITY);
        gb.setAccY(128);
    }

    private void addScoreAndTime(int mul) {
        int scoretoadd = (10 * this._iMultiplicator + 40) / 10;
        this._iScore += scoretoadd;
    }

    public int getGameOverMessage() {
        if (this._iHint == -1) {
            return 12;
        }
        if (this._lProgressMain <= 0L) {
            return 11;
        }
        return 0;
    }

    private void setStatus(int next_status) {
        if (next_status != this._iStatus) {
            this._iStatus = next_status;
            if (this._iStatus == 6 || this._iStatus == 7) {
                if (this._mainCanvas.getSoundManager().IsSoundOn()) {
                    if (this._iStatus == 6) {
                        // empty if block
                    }
                    if (this._iStatus == 7) {
                        // empty if block
                    }
                }
                for (int i = 0; i < 64; ++i) {
                    if (this.jewels[i].getBonus() == 7 && this.jewels[i].getDeltaY() < 0) {
                        this.jewels[i].setDeltaX(MainCanvas.WIDTH);
                        this.jewels[i].setVelX(0);
                        this.jewels[i].setAccX(0);
                    }
                    this.jewels[i].setDeltaY(1);
                    this.jewels[i].setVelY(this.rectGameArea.width * 1280 / 240);
                    this.jewels[i].setAccY(this.rectGameArea.width * 256 / 240);
                    if (this.jewels[i].getBonus() == 1) {
                        this._iScore += 50;
                        continue;
                    }
                    if (this.jewels[i].getBonus() == 5) {
                        this._iScore += 100;
                        continue;
                    }
                    if (this.jewels[i].getBonus() != 2) continue;
                    this._iScore += 250;
                }
            } else if (this._iStatus == 2) {
                this._bAllowEscapeSwap = true;
                this._iMultiplicator = 1;
                int turns = this.getMovesCount();
                if (turns == 0 && this._iGameMode == 20) {
                    this.setStatus(1);
                    this.swapJewels();
                }
            }
        }
    }

    private void swapJewels() {
        for (int i = 0; i < 64; ++i) {
            if (this.jewels[i].isMoving()) continue;
            int direction = RandomNum.getRandomUInt(4);
            if (direction == 0) {
                if (i % 8 >= 7 || this.jewels[i + 1].isMoving()) continue;
                this.swap(i, i + 1);
                continue;
            }
            if (direction == 1) {
                if (i / 8 >= 7 || this.jewels[i + 8].isMoving()) continue;
                this.swap(i, i + 8);
                continue;
            }
            if (direction == 2) {
                if (i % 8 <= 0 || this.jewels[i - 1].isMoving()) continue;
                this.swap(i, i - 1);
                continue;
            }
            if (direction != 3 || i / 8 <= 0 || this.jewels[i - 8].isMoving()) continue;
            this.swap(i, i - 8);
        }
    }

    private int getMovesCount() {
        int count = 0;
        this._bPenalty = false;
        this._iHint = -1;
        int p0 = RandomNum.getRandomUInt(100);
        for (int pos = 0; pos < 64; ++pos) {
            if (this.jewels[pos].getBonus() == 2) {
                if (p0 >= 100 / ++count) continue;
                this._iHint = pos;
                continue;
            }
            if (this.jewels[pos].getBonus() == 6) continue;
            int row = pos / 8;
            int col = pos % 8;
            if (col > 0 && col < 7) {
                if (row > 0 && this.isDestructible(pos, pos - 1 - 8) && this.isDestructible(pos, pos + 1 - 8)) {
                    if (p0 >= 100 / ++count) continue;
                    this._iHint = pos;
                    continue;
                }
                if (row < 7 && this.isDestructible(pos, pos - 1 + 8) && this.isDestructible(pos, pos + 1 + 8)) {
                    if (p0 >= 100 / ++count) continue;
                    this._iHint = pos;
                    continue;
                }
            }
            if (col > 1) {
                if (row > 0 && this.isDestructible(pos, pos - 1 - 8) && this.isDestructible(pos, pos - 2 - 8)) {
                    if (p0 >= 100 / ++count) continue;
                    this._iHint = pos;
                    continue;
                }
                if (row < 7 && this.isDestructible(pos, pos - 1 + 8) && this.isDestructible(pos, pos - 2 + 8)) {
                    if (p0 >= 100 / ++count) continue;
                    this._iHint = pos;
                    continue;
                }
            }
            if (col > 2 && this.isDestructible(pos, pos - 2) && this.isDestructible(pos, pos - 3)) {
                if (p0 >= 100 / ++count) continue;
                this._iHint = pos;
                continue;
            }
            if (col < 6) {
                if (row > 0 && this.isDestructible(pos, pos + 1 - 8) && this.isDestructible(pos, pos + 2 - 8)) {
                    if (p0 >= 100 / ++count) continue;
                    this._iHint = pos;
                    continue;
                }
                if (row < 7 && this.isDestructible(pos, pos + 1 + 8) && this.isDestructible(pos, pos + 2 + 8)) {
                    if (p0 >= 100 / ++count) continue;
                    this._iHint = pos;
                    continue;
                }
            }
            if (col < 5 && this.isDestructible(pos, pos + 2) && this.isDestructible(pos, pos + 3)) {
                if (p0 >= 100 / ++count) continue;
                this._iHint = pos;
                continue;
            }
            if (row > 0 && row < 7) {
                if (col > 0 && this.isDestructible(pos, pos - 1 - 8) && this.isDestructible(pos, pos - 1 + 8)) {
                    if (p0 >= 100 / ++count) continue;
                    this._iHint = pos;
                    continue;
                }
                if (col < 7 && this.isDestructible(pos, pos + 1 - 8) && this.isDestructible(pos, pos + 1 + 8)) {
                    if (p0 >= 100 / ++count) continue;
                    this._iHint = pos;
                    continue;
                }
            }
            if (row > 1) {
                if (col > 0 && this.isDestructible(pos, pos - 1 - 8) && this.isDestructible(pos, pos - 1 - 16)) {
                    if (p0 >= 100 / ++count) continue;
                    this._iHint = pos;
                    continue;
                }
                if (col < 7 && this.isDestructible(pos, pos + 1 - 8) && this.isDestructible(pos, pos + 1 - 16)) {
                    if (p0 >= 100 / ++count) continue;
                    this._iHint = pos;
                    continue;
                }
            }
            if (row > 2 && this.isDestructible(pos, pos - 16) && this.isDestructible(pos, pos - 24)) {
                if (p0 >= 100 / ++count) continue;
                this._iHint = pos;
                continue;
            }
            if (row < 6) {
                if (col > 0 && this.isDestructible(pos, pos - 1 + 8) && this.isDestructible(pos, pos - 1 + 16)) {
                    if (p0 >= 100 / ++count) continue;
                    this._iHint = pos;
                    continue;
                }
                if (col < 7 && this.isDestructible(pos, pos + 1 + 8) && this.isDestructible(pos, pos + 1 + 16)) {
                    if (p0 >= 100 / ++count) continue;
                    this._iHint = pos;
                    continue;
                }
            }
            if (row >= 5 || !this.isDestructible(pos, pos + 16) || !this.isDestructible(pos, pos + 24) || p0 >= 100 / ++count) continue;
            this._iHint = pos;
        }
        return count;
    }

    private boolean isDestructible(int pos1, int pos2) {
        if (this.jewels[pos2].getBonus() == 2) {
            return false;
        }
        if (this.jewels[pos2].getBonus() == 6) {
            return false;
        }
        return this.jewels[pos1].getColor() == this.jewels[pos2].getColor();
    }

    public void showHint() {
        bhint = true;
        if (this._iStatus == 2) {
            if (!this._bPenalty) {
                this._bPenalty = true;
                if (this._iGameMode == 60) {
                    this._lProgressMain = 96L * this._lProgressMain / 100L;
                } else if (this._iGameMode == 1) {
                    this._lProgressMain = 96L * this._lProgressMain / 100L;
                } else if (this._iGameMode == 7) {
                    this._lProgressMain = 96L * this._lProgressMain / 100L;
                } else if (this._iGameMode == 4) {
                    this._lProgressMain -= 2000L;
                } else if (this._iGameMode == 2) {
                    this._lProgressMain = 6L * this._lProgressMain / 10L;
                }
            }
            this.selectorPos = this._iHint;
            if (this.jewels[this.selectorPos].getAnimationRepeats() == 0) {
                this.jewels[this.selectorPos].startAnimation(4);
            }
        }
    }

    private int getResidueScore() {
        int score = 0;
        for (int i = 0; i < 64; ++i) {
            if (this.jewels[i].getBonus() == 1) {
                score += 50;
                this._iScoreBomb += 50;
                continue;
            }
            if (this.jewels[i].getBonus() == 5) {
                score += 100;
                this._iScoreBomb += 100;
                continue;
            }
            if (this.jewels[i].getBonus() != 2) continue;
            score += 250;
            this._iScoreBomb += 250;
        }
        return score;
    }

    private void paintGameBackground(Graphics g) {
    }

    private void paintGameTiles(Graphics g) {
        if (this._imgGameTile == null) {
            this._imgGameTile = Resources.resImgs[5];
        }
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                g.drawImage(this._imgGameTile, this.rectGameArea.x + x * this._imgGameTile.getWidth(), this.rectGameArea.y + this._imgGameTile.getHeight() / 2 + y * this._imgGameTile.getHeight(), 6);
            }
        }
    }

    private void paintBlocksLayer(Graphics g) {
        for (int pos = 0; pos < 64; ++pos) {
            if (Block.getValue(pos) <= 0) continue;
            int x = this.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + (this._imgGameTile.getWidth() - this._sprBlock.getWidth() >> 1);
            int y = this.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + (this._imgGameTile.getWidth() - this._sprBlock.getWidth() >> 1);
            this._sprBlock.setRefPixelPosition(x, y);
            this._sprBlock.setFrame(Block.getValue(pos) - 1);
            this._sprBlock.paint(g);
        }
    }

    public void paint(Graphics g) {
        this.paintGameBackground(g);
        this.paintGameTiles(g);
        g.setClip(this.rectGameArea.x, this.rectGameArea.y, this.rectGameArea.width, this.rectGameArea.height);
        this.paintBlocksLayer(g);
        for (int pos = 0; pos < 64; ++pos) {
            int x = this.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE;
            int y = this.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE;
            if (this.jewels[pos].getBonus() == 6) {
                if (Jewel.BLOCKSIZE >= 29) {
                    ++y;
                }
            } else if (this.jewels[pos].getBonus() == 2) {
                if (Jewel.BLOCKSIZE >= 29) {
                    ++y;
                }
            } else if (this.jewels[pos].getBonus() != 0) {
                if (Jewel.BLOCKSIZE >= 29) {
                    ++y;
                }
            } else if (Jewel.BLOCKSIZE >= 29) {
                ++y;
            }
            boolean shake = false;
            if (this._iGameMode == 2 && this.jewels[pos].getBonus() == 7 && pos / 8 < 3) {
                shake = true;
            }
            if (this._iStatus == 7 && this.jewels[pos].getDeltaY() <= 0) continue;
            this.jewels[pos].paint(g, x, y, shake);
            if (pos < 56 || this.fallBonus[pos % 8] == null) continue;
            g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            this.fallBonus[pos % 8].paint(g, x, y, false);
            g.setClip(this.rectGameArea.x, this.rectGameArea.y, this.rectGameArea.width, this.rectGameArea.height);
        }
        this._sprSelector.setFrame(0);
        if (this._iStatus != 1) {
            this._sprSelector.setRefPixelPosition(this.rectGameArea.x + this.selectorPos % 8 * Jewel.BLOCKSIZE - (Jewel.SHIFT_HORIZONTAL_SEL >> 1), this.rectGameArea.y + this.selectorPos / 8 * Jewel.BLOCKSIZE - (Jewel.SHIFT_HORIZONTAL_SEL >> 1));
        } else {
            this._sprSelector.setRefPixelPosition(this.rectGameArea.x + this.selectorPos % 8 * Jewel.BLOCKSIZE - (Jewel.SHIFT_HORIZONTAL_SEL >> 1), this.rectGameArea.y + this.selectorPos / 8 * Jewel.BLOCKSIZE - (Jewel.SHIFT_HORIZONTAL_SEL >> 1));
        }
        if (this._iSelectorFrame % 2 == 0) {
            this._sprSelector.paint(g);
        }
        Storm.paint(g, this.rectGameArea);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    private int getParticlesColor(int color) {
        switch (color) {
            case 0: {
                return 14825540;
            }
            case 1: {
                return 16374064;
            }
            case 2: {
                return 10277142;
            }
            case 3: {
                return 6862702;
            }
            case 4: {
                return 5425662;
            }
            case 5: {
                return 16620483;
            }
            case 6: {
                return 15287771;
            }
            case 999: {
                return 13122762;
            }
        }
        return 15406336;
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
        this._iStatus = dis.readInt();
        this._iGameMode = dis.readInt();
        this._iGameLevel = dis.readInt();
        this._lTimeElapsed = dis.readLong();
        this._iScore = dis.readInt();
        this._iMultiplicator = dis.readInt();
        this._iHint = dis.readInt();
        this._lProgressMain = dis.readLong();
        this._lProgressMainFinal = dis.readLong();
        this._iProgressSecondaryFinal = dis.readInt();
        _iProgressSecondary = dis.readInt();
        this.selectorPos = dis.readInt();
        this.swappedPos = dis.readInt();
        this._bIsDragged = dis.readBoolean();
        this.totalColors = dis.readInt();
        this._bAllowEscapeSwap = dis.readBoolean();
        this._iMaxSpecialGems = dis.readInt();
        for (int i = 0; i < 64; ++i) {
            this.jewels[i].load(dis);
            Block.setValue(i, dis.readInt());
        }
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
        dos.writeInt(this._iStatus);
        dos.writeInt(this._iGameMode);
        dos.writeInt(this._iGameLevel);
        dos.writeLong(this._lTimeElapsed);
        dos.writeInt(this._iScore);
        dos.writeInt(this._iMultiplicator);
        dos.writeInt(this._iHint);
        dos.writeLong(this._lProgressMain);
        dos.writeLong(this._lProgressMainFinal);
        dos.writeInt(this._iProgressSecondaryFinal);
        dos.writeInt(_iProgressSecondary);
        dos.writeInt(this.selectorPos);
        dos.writeInt(this.swappedPos);
        dos.writeBoolean(this._bIsDragged);
        dos.writeInt(this.totalColors);
        dos.writeBoolean(this._bAllowEscapeSwap);
        dos.writeInt(this._iMaxSpecialGems);
        for (int i = 0; i < 64; ++i) {
            this.jewels[i].save(dos);
            dos.writeInt(Block.getValue(i));
        }
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
        dos.writeInt(0);
        dos.writeInt(this._iGameMode);
        dos.writeInt(1);
        dos.writeLong(0L);
        dos.writeInt(0);
        dos.writeInt(1);
        dos.writeLong(0L);
        dos.writeLong(1000L);
        dos.writeInt(1000);
        dos.writeInt(5);
        dos.writeInt(0);
        dos.writeInt(27);
        dos.writeInt(0);
        dos.writeBoolean(false);
        dos.writeInt(5);
        dos.writeBoolean(true);
    }

    private void setLoseMode(int loseMode) {
        this._iLoseMode = loseMode;
    }

    public int getLoseMode() {
        return this._iLoseMode;
    }

    static {
        blockChecker = false;
        bhint = false;
    }
}

