/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import sk.inlogic.util.Rectangle;

public class Common {
    public static int SMALL_QUIT = 0;
    public static int SMALL_ARROW = 1;
    public static int SMALL_PAUSE = 2;
    public static int MIDDLE_YES = 0;
    public static int MIDDLE_NO = 1;
    public static int BIG_START = 0;
    public static int BIG_RESTART = 1;
    public static int BIG_NEXT = 2;
    public static int MIDDLE_PREV = 0;
    public static int MIDDLE_RESTART = 1;
    public static int MIDDLE_INSTRUCTIONS = 2;
    public static int MIDDLE_SOUND_OFF = 3;
    public static int MIDDLE_SOUND_ON = 4;
    public static int MIDDLE_ABOUT = 5;
    public static int MIDDLE_MENU = 6;
    public static int ICON_PLAY = 0;
    public static int ICON_YES = 1;
    public static int ICON_NO = 2;
    public static int ICON_RESTART = 3;
    public static int ICON_MENU = 4;
    public static int ICON_PAUSE = 5;
    public static int ICON_SETTING = 6;
    public static int ICON_POWER = 7;
    public static int ICON_INSTR = 8;
    public static int ICON_SOUND_OFF = 9;
    public static int ICON_SOUND_ON = 10;
    public static int ICON_LEVELS = 11;
    public static int ICON_BACK = 12;
    public static int ICON_ABOUT = 13;

    public static String scoreToPrint(int score) {
        String s = "";
        while (score >= 1000) {
            s = score % 1000 < 10 ? ".00" + Integer.toString(score % 1000) + s : (score % 1000 < 100 ? ".0" + Integer.toString(score % 1000) + s : "." + Integer.toString(score % 1000) + s);
            score /= 1000;
        }
        s = Integer.toString(score) + s;
        return s;
    }

    public static String secToTime(int sec) {
        int minutes;
        String time = "";
        int hours = sec / 3600;
        if (hours > 0) {
            time = Integer.toString(hours) + ":";
        }
        time = (minutes = sec % 3600 / 60) > 9 ? time + Integer.toString(minutes) + ":" : (minutes > 0 ? time + "0" + Integer.toString(minutes) + ":" : time + "00:");
        int seconds = sec % 60;
        time = seconds > 9 ? time + Integer.toString(seconds) : (seconds > 0 ? time + "0" + Integer.toString(seconds) : time + "00");
        return time;
    }

    public static void trace(String s) {
        System.out.println(s);
    }

    public static void trace(int i) {
        System.out.println(i);
    }

    public static void trace(boolean b) {
        System.out.println(b);
    }

    public static Rectangle getMenuArea(int width, int height) {
        int marginTop = 0;
        int marginBottom = 0;
        if (height <= 130) {
            marginTop = 30;
            marginBottom = 5;
        } else if (height <= 149) {
            marginTop = 45;
            marginBottom = 10;
        } else if (height <= 160) {
            marginTop = 50;
            marginBottom = 25;
        } else if (height <= 176) {
            marginTop = 65;
            marginBottom = 15;
        } else if (height <= 208) {
            marginTop = 65;
            marginBottom = 20;
        } else if (height <= 220) {
            marginTop = 70;
            marginBottom = 20;
        } else if (height <= 240) {
            marginTop = 80;
            marginBottom = 27;
        } else if (height <= 260) {
            marginTop = 85;
            marginBottom = 20;
        } else if (height <= 287) {
            marginTop = 85;
            marginBottom = 20;
        } else if (height <= 320) {
            if (width == 480) {
                marginTop = 120;
                marginBottom = 5;
            } else {
                marginTop = 100;
                marginBottom = 20;
            }
        } else if (height <= 348) {
            marginTop = 100;
            marginBottom = 25;
        } else if (height <= 360) {
            marginTop = 120;
            marginBottom = 40;
        } else if (height <= 416) {
            marginTop = 125;
            marginBottom = 75;
        } else if (height <= 432) {
            marginTop = 100;
            marginBottom = 132;
        } else if (height <= 480) {
            marginTop = 140;
            marginBottom = 25;
        } else if (height <= 640) {
            if (width == 480) {
                marginTop = 180;
                marginBottom = 40;
            } else {
                marginTop = 200;
                marginBottom = 140;
            }
        } else if (height <= 696) {
            marginTop = 240;
            marginBottom = 70;
        } else if (height <= 854) {
            marginTop = 260;
            marginBottom = 140;
        } else if (height <= 960) {
            marginTop = 260;
            marginBottom = 170;
        }
        return new Rectangle(0, 0 + marginTop, width, height - marginTop - marginBottom);
    }
}

