/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Common;
import sk.inlogic.Level;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.graphics.GFont;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenGame;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSelectLevel
implements IScreen {
    MainCanvas mainCanvas;
    long modeDelay;
    private static final int COMP_ID_BACK = 0;
    private static final int COMP_ID_ARR_UP = 1;
    private static final int COMP_ID_ARR_DOWN = 2;
    private static final int COMP_ID_ALLLEVELS = 3;
    private static final int TOTAL_COMP_IDS = 4;
    private Rectangle[] _rectItems = new Rectangle[4];
    private Rectangle[] _rectLevel = new Rectangle[16];
    private Rectangle _rSelectedLevel;
    private Rectangle _rectLevelBody;
    private Rectangle rectFK;
    int mode;
    private int _iNextModePack1 = 0;
    private int _iNextModePack2 = 1;
    private int _iNextModePack3 = 2;
    private int _iNextModePack4 = 3;
    private int _iNextModePack5 = 4;
    private int _iNextModeMenu = 5;
    private int _iNextModeGame = 6;
    private int _iSelectedCompId;
    private int _iGameMode;
    private int selectedOption;
    private Rectangle rectTop;
    private Rectangle rectDown;
    private int dy = 0;
    private int _iSelectorDx = 0;
    private int _iSelectorDy = 0;
    private int _iCounterX = 0;
    private int _iCounterY = 0;
    private int scoresCount = 0;
    private int count = 0;
    private int x = 0;
    private int y = 0;
    private int interuption = 0;
    private int selectedPack = 0;
    private int selectdLevel = 0;
    private int levelNumber = 0;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private String[] levelStars = new String[80];
    private String[] levelnames = new String[80];
    private int _iOffsetLevelX = 0;
    private int _iOffsetLevelY = 0;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private boolean _bChangeSequence = false;
    private Image _imgBg;
    private Image imgLevelSelector;
    private Sprite sprButton;
    private Sprite sprIcons;
    private Sprite sprLevel;
    private Sprite sprLevelStar;
    private Sprite sprArrow;
    private Sprite sprNumSmall;
    private PreparedText _ptLevelNum;
    private GFont fontBig;
    private GFont fontSmall;
    private int[] _animationSequence = new int[4];
    private AnimationComponent[] _animationComponents = new AnimationComponent[4];
    private boolean _bShitDevice = false;
    public boolean animatedMenu = false;
    private int cycle = 10;

    public ScreenSelectLevel(MainCanvas mC, int selectedLevel) {
        System.out.println("screen select level");
        this.mainCanvas = mC;
        this._iCounterX = MainCanvas.slcLvl % 4;
        this._iCounterY = MainCanvas.slcLvl / 4 % 4;
        MainCanvas.counterX = this._iCounterX;
        MainCanvas.counterY = this._iCounterY;
        this.selectedPack = MainCanvas.slcLvl / 16;
        MainCanvas.slcPack = this.selectedPack;
        this.selectdLevel = MainCanvas.slcLvl;
        MainCanvas.totalStars = 0;
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.prepareTxt();
        this.prepareLevelStars();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.startAnimation(true, -1);
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 27});
        Resources.loadSprites(new int[]{9, 53, 50, 51, 54, 55});
        Resources.loadGFonts(new int[]{0, 1});
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2, 27});
        Resources.freeSprites(new int[]{9, 53, 50, 51, 54, 55});
        Resources.freeGFonts(new int[]{0, 1});
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
        if (this._WIDTH == 176 && this._HEIGHT == 208) {
            this._bShitDevice = true;
        }
        if (this._WIDTH == 176 && this._HEIGHT == 220) {
            this._bShitDevice = true;
        }
        this._bShitDevice = this._WIDTH == 208 && this._HEIGHT == 208;
    }

    private void initImages() {
        this._imgBg = Resources.resImgs[2];
        this.imgLevelSelector = Resources.resImgs[27];
    }

    private void initSprites() {
        this.sprLevel = Resources.resSprs[53];
        this.sprLevelStar = Resources.resSprs[9];
        this.sprIcons = Resources.resSprs[51];
        this.sprButton = Resources.resSprs[50];
        this.sprArrow = Resources.resSprs[54];
        this.sprNumSmall = Resources.resSprs[55];
    }

    private void initFonts() {
        this.fontBig = Resources.resGFonts[1];
        this.fontSmall = Resources.resGFonts[0];
        this._ptLevelNum = new PreparedText(this.fontBig);
    }

    private void initAnimationSequences() {
        this._animationSequence[0] = 0;
        this._animationSequence[1] = 1;
        this._animationSequence[2] = 2;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this._rectLevelBody, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectDown, this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectFK, this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectTop, this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(2);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(2);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(1);
        this._animationComponents[3].startHideAnimation(2);
    }

    private void prepareTxt() {
        this._ptLevelNum.prepareText("1", this.sprLevel.getWidth());
    }

    private void freeGraphics() {
        this._imgBg = null;
        this._ptLevelNum = null;
    }

    private void prepareLevelStars() {
        Vector scores;
        for (int i = 0; i < 80; ++i) {
            this.levelStars[i] = null;
            this.levelnames[i] = null;
        }
        RMSObjects.createRMSConnect(0);
        if (!RMSObjects.rmsConnects[0].load()) {
            RMSObjects.rmsConnects[0].create();
        }
        if ((scores = RMSObjects.localScores.getScoresForGame(0)) != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        for (int i = 0; i < 80; ++i) {
            if (i < this.scoresCount) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(i);
                this.levelStars[i] = Integer.toString(scoreItem.scoreValue);
                MainCanvas.totalStars += scoreItem.scoreValue;
                ++this.count;
                continue;
            }
            this.levelStars[i] = null;
        }
    }

    public void beforeInteruption() {
        this.mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
        this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
    }

    private void calculatePositions() {
        int fkWidth = this.sprButton.getWidth();
        int sprArrwUpDownWidth = this.sprArrow.getWidth() + (this.sprButton.getWidth() >> 1);
        int sprArrwUpDownHeigth = this.sprArrow.getHeight() + (this.sprButton.getHeight() >> 1);
        int marginLeft = fkWidth;
        this.rectTop = new Rectangle((MainCanvas.WIDTH >> 1) - (this.sprArrow.getWidth() >> 1), this.sprArrow.getHeight() >> 2, this.sprArrow.getWidth(), this.sprArrow.getHeight());
        this.rectDown = new Rectangle((MainCanvas.WIDTH >> 1) - (this.sprArrow.getWidth() >> 1), MainCanvas.HEIGHT - (this.sprArrow.getHeight() >> 2) - this.sprArrow.getHeight(), this.sprArrow.getWidth(), this.sprArrow.getHeight());
        this._rectItems[0] = new Rectangle(MainCanvas.WIDTH - (this.sprButton.getWidth() << 1), MainCanvas.HEIGHT - (this.sprButton.getHeight() << 1), this.sprButton.getWidth() << 1, this.sprButton.getHeight() << 1);
        this._rectItems[1] = new Rectangle(this.rectTop.getCenterX() - sprArrwUpDownWidth / 2, this.rectTop.getCenterY() - sprArrwUpDownHeigth / 2, sprArrwUpDownWidth, sprArrwUpDownHeigth);
        this._rectItems[2] = new Rectangle(this.rectDown.getCenterX() - sprArrwUpDownWidth / 2, this.rectDown.getCenterY() - sprArrwUpDownHeigth / 2, sprArrwUpDownWidth, sprArrwUpDownHeigth);
        this._rectItems[3] = new Rectangle(0, sprArrwUpDownHeigth, this.mainCanvas.getWidth(), this.mainCanvas.getHeight() - this.rectTop.height - this.rectDown.height);
        this.dy = this.sprButton.getHeight();
        this._iSelectorDx = this.sprLevel.getWidth();
        this._iSelectorDy = this.dy;
        int _iOffsetX = this._WIDTH % 4 == 0 ? 0 : this._WIDTH % 4 >> 1;
        int _iOffsetTop = this.sprArrow.getHeight();
        int _iOffsetBottom = this.sprArrow.getHeight();
        int _iOffsetTmpY = this._HEIGHT - _iOffsetTop - _iOffsetBottom;
        int _iOffsetY = _iOffsetTop + (_iOffsetTmpY - (this.sprLevel.getHeight() + this.sprLevelStar.getHeight() << 2)) / 5;
        this._rectLevelBody = new Rectangle(_iOffsetX, _iOffsetY, this._WIDTH - (_iOffsetX << 1), this._HEIGHT - _iOffsetTop - _iOffsetBottom);
        this._iOffsetLevelX = (this._rectLevelBody.width - this.sprLevel.getWidth() * 4) / 5;
        this._iOffsetLevelY = (this._rectLevelBody.height - this.sprLevel.getHeight() * 4) / 5;
        if (this._iOffsetLevelY < this._ptLevelNum.getTextHeight()) {
            this._iOffsetLevelY = this._ptLevelNum.getTextHeight();
        }
        int offset = this.sprButton.getWidth() >> 3;
        int xCenterFK = MainCanvas.WIDTH - (this.sprButton.getWidth() >> 1) - offset;
        int yCenterFK = MainCanvas.HEIGHT - (this.sprButton.getHeight() >> 1) - offset;
        this.rectFK = new Rectangle(xCenterFK - (this.sprButton.getWidth() >> 1), yCenterFK - (this.sprButton.getHeight() >> 1), this.sprButton.getWidth(), this.sprButton.getHeight());
    }

    public void update(long lastRunLenght) {
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _nextMode) {
        if (_nextMode == this._iNextModeGame) {
            MainCanvas.slcLvl = this.selectdLevel;
            ScreenGame sg = new ScreenGame(this.mainCanvas, this._iGameMode, this.selectdLevel, false);
            this.mainCanvas.changeLastActiveScreen(sg);
            this.mainCanvas.getSoundManager().Stop();
            if (this.mainCanvas.getSoundManager().IsSoundOn()) {
                this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
            }
        } else if (_nextMode == this._iNextModeMenu) {
            this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintArrows(g);
        this.paintLvl(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.drawImage(this._imgBg, 0, 0, 20);
    }

    private void paintLvl(Graphics g) {
        int iShiftX = this.fontSmall.getHeight() >> 3;
        int iShiftY = -iShiftX;
        if (MainCanvas.HEIGHT >= 640) {
            iShiftY = iShiftX;
        } else if (MainCanvas.HEIGHT >= 480) {
            iShiftY = 0;
        }
        this.fontBig.drawString(g, (this.selectedPack + 1 + "/5").toCharArray(), iShiftX, iShiftY, 20);
        int levelIndex = 0;
        int _iTmpLvlStr = 0;
        int _iLvlX = 0;
        int _iLvlY = 0;
        if (this.selectedPack == this._iNextModePack1) {
            this.levelNumber = 0;
        } else if (this.selectedPack == this._iNextModePack2) {
            this.levelNumber = 16;
        } else if (this.selectedPack == this._iNextModePack3) {
            this.levelNumber = 32;
        } else if (this.selectedPack == this._iNextModePack4) {
            this.levelNumber = 48;
        } else if (this.selectedPack == this._iNextModePack5) {
            this.levelNumber = 64;
        }
        for (int y = 0; y < 4; ++y) {
            int x = 0;
            while (x < 4) {
                _iTmpLvlStr = 0;
                _iLvlX = this._rectLevelBody.x + (x * this.sprLevel.getWidth() + (x == 0 ? this._iOffsetLevelX : (x + 1) * this._iOffsetLevelX));
                _iLvlY = this._rectLevelBody.y + (y * this.sprLevel.getHeight() + y * this._iOffsetLevelY) + (this.sprLevelStar.getHeight() >> 1);
                if (this.selectdLevel == levelIndex + this.levelNumber) {
                    // empty if block
                }
                this.sprLevel.setFrame(0);
                this.sprLevel.setPosition(_iLvlX, _iLvlY);
                this.sprLevel.paint(g);
                this._rectLevel[levelIndex] = this._rSelectedLevel = new Rectangle(this.sprLevel.getX(), this.sprLevel.getY(), this.sprLevel.getWidth(), this.sprLevel.getHeight());
                if (levelIndex + this.levelNumber + 1 <= this.count + 1) {
                    try {
                        if (levelIndex + this.levelNumber + 1 < this.count + 1 && this.levelStars[levelIndex + this.levelNumber] != null) {
                            _iTmpLvlStr = Integer.parseInt(this.levelStars[levelIndex]);
                        }
                    }
                    catch (Exception r) {
                        System.out.println("omg autor tu nic nedal.. " + r.getMessage());
                    }
                    this.paintNumSmallLevel(levelIndex + this.levelNumber + 1, this._rSelectedLevel.getCenterX(), this._rSelectedLevel.getCenterY(), g);
                } else {
                    this.sprLevel.setFrame(1);
                    this.sprLevel.setPosition(_iLvlX, _iLvlY);
                    this.sprLevel.paint(g);
                }
                int _iPosX = this._rectLevel[levelIndex].getCenterX() - (this.sprLevelStar.getWidth() >> 1);
                if (this.selectdLevel == levelIndex + this.levelNumber) {
                    if (levelIndex + this.levelNumber + 1 <= this.count + 1) {
                        g.drawImage(this.imgLevelSelector, this.sprLevel.getX() + (this.imgLevelSelector.getWidth() >> 1), this.sprLevel.getY() + (this.imgLevelSelector.getHeight() >> 1), 3);
                    } else {
                        g.drawImage(this.imgLevelSelector, this.sprLevel.getX() + (this.imgLevelSelector.getWidth() >> 1), this.sprLevel.getY() + (this.imgLevelSelector.getHeight() >> 1), 3);
                    }
                }
                int inactiveStar = 1;
                int activeStar = 0;
                int yOffset = this.sprLevelStar.getHeight() >> 1;
                int x1 = _iPosX - this.sprLevelStar.getWidth();
                int y1 = this._rectLevel[y * 4 + x].y - (this.sprLevelStar.getHeight() >> 2) - yOffset;
                if (_iTmpLvlStr > 0) {
                    this.sprLevelStar.setFrame(activeStar);
                    this.sprLevelStar.setPosition(x1, y1);
                    this.sprLevelStar.paint(g);
                } else {
                    this.sprLevelStar.setFrame(inactiveStar);
                    this.sprLevelStar.setPosition(x1, y1);
                    this.sprLevelStar.paint(g);
                }
                int x2 = _iPosX;
                int y2 = this._rectLevel[y * 4 + x].y - (this.sprLevelStar.getHeight() >> 1) - yOffset;
                if (_iTmpLvlStr > 1) {
                    this.sprLevelStar.setFrame(activeStar);
                    this.sprLevelStar.setPosition(x2, y2);
                    this.sprLevelStar.paint(g);
                } else {
                    this.sprLevelStar.setFrame(inactiveStar);
                    this.sprLevelStar.setPosition(x2, y2);
                    this.sprLevelStar.paint(g);
                }
                int x3 = _iPosX + this.sprLevelStar.getWidth();
                int y3 = this._rectLevel[y * 4 + x].y - (this.sprLevelStar.getHeight() >> 2) - yOffset;
                if (_iTmpLvlStr > 2) {
                    this.sprLevelStar.setFrame(activeStar);
                    this.sprLevelStar.setPosition(x3, y3);
                    this.sprLevelStar.paint(g);
                } else {
                    this.sprLevelStar.setFrame(inactiveStar);
                    this.sprLevelStar.setPosition(x3, y3);
                    this.sprLevelStar.paint(g);
                }
                ++x;
                ++levelIndex;
            }
        }
    }

    private void paintArrows(Graphics g) {
        if (this.selectedPack != 0) {
            this.sprArrow.setFrame(0);
            this.sprArrow.setTransform(5);
            this.sprArrow.setPosition(this.rectTop.x, this.rectTop.y);
            this.sprArrow.paint(g);
        }
        if (this.selectedPack != 4) {
            this.sprArrow.setFrame(0);
            this.sprArrow.setTransform(6);
            this.sprArrow.setPosition(this.rectDown.x, this.rectDown.y);
            this.sprArrow.paint(g);
        }
    }

    private void paintFK(Graphics g) {
        this.sprButton.setFrame(0);
        if (this.selectedOption == 1) {
            this.sprButton.setFrame(1);
        }
        this.sprButton.setPosition(this.rectFK.x, this.rectFK.y);
        this.sprButton.paint(g);
        this.sprIcons.setFrame(Common.ICON_BACK);
        this.sprIcons.setTransform(0);
        this.sprIcons.setPosition(this.rectFK.getCenterX() - (this.sprIcons.getWidth() >> 1), this.rectFK.getCenterY() - (this.sprIcons.getHeight() >> 1));
        this.sprIcons.paint(g);
    }

    public void keyPressed(int keyCode) {
        if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) {
            // empty if block
        }
    }

    public void keyReleased(int keyCode) {
        if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55 && !Keys.isFKLeftCode(keyCode)) {
            if (Keys.isFKRightCode(keyCode)) {
                this.selectedOption = 1;
                this.startAnimation(true, this._iNextModeMenu);
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                if (this.selectdLevel <= this.count) {
                    MainCanvas.counterX = this._iCounterX;
                    MainCanvas.counterY = this._iCounterY;
                    Level.getLevel(this.selectdLevel);
                    this._iGameMode = Level._iGameMode;
                    MainCanvas.slcLvl = this.selectdLevel;
                    this.startAnimation(true, this._iNextModeGame);
                }
            } else if (Keys.isActionGeneratedByKey(3, keyCode)) {
                if (this._iCounterX > 0) {
                    --this._iCounterX;
                    --MainCanvas.counterX;
                    --this.selectdLevel;
                }
            } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
                if (this._iCounterX < 3) {
                    ++this._iCounterX;
                    ++MainCanvas.counterX;
                    ++this.selectdLevel;
                }
            } else if (Keys.isActionGeneratedByKey(1, keyCode)) {
                if (this._iCounterY > 0) {
                    --this._iCounterY;
                    --MainCanvas.counterY;
                    this.selectdLevel -= 4;
                } else if (this.selectedPack > 0) {
                    this._iCounterY = 3;
                    MainCanvas.counterY = 3;
                    --this.selectedPack;
                    --MainCanvas.slcPack;
                    this.selectdLevel -= 4;
                }
            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                if (this._iCounterY < 3) {
                    ++this._iCounterY;
                    ++MainCanvas.counterY;
                    this.selectdLevel += 4;
                } else if (this.selectedPack < 4) {
                    this._iCounterY = 0;
                    MainCanvas.counterY = 0;
                    ++this.selectedPack;
                    ++MainCanvas.slcPack;
                    this.selectdLevel += 4;
                }
            }
        }
        this.mainCanvas.repaint();
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this._rectItems.length; ++i) {
            if (!this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 1: {
                    Keys.keyPressed(50);
                    Keys.resetAllPressedKeysAndActions();
                    break;
                }
                case 2: {
                    Keys.keyPressed(56);
                    Keys.resetAllPressedKeysAndActions();
                    break;
                }
                case 0: {
                    this.selectedOption = 1;
                    Keys.keyPressed(-22);
                    break;
                }
                case 3: {
                    break;
                }
            }
            return;
        }
    }

    public void pointerDragged(int x, int y) {
        if (this._iSelectedCompId != -1 && !this._rectItems[this._iSelectedCompId].contains(x, y)) {
            switch (this._iSelectedCompId) {
                case 1: {
                    Keys.keyReleased(49);
                    break;
                }
                case 2: {
                    Keys.keyReleased(49);
                    break;
                }
                case 0: {
                    Keys.keyReleased(-22);
                    break;
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this._iSelectedCompId != -1) {
            switch (this._iSelectedCompId) {
                case 1: {
                    if (this.selectedPack > 0) {
                        this._iCounterX = 0;
                        this._iCounterY = 0;
                        --this.selectedPack;
                        --MainCanvas.slcPack;
                        this.selectdLevel -= 16;
                    }
                    this.keyReleased(49);
                    this.mainCanvas.repaint();
                    break;
                }
                case 2: {
                    if (this.selectedPack < 4) {
                        this._iCounterX = 0;
                        this._iCounterY = 0;
                        ++this.selectedPack;
                        ++MainCanvas.slcPack;
                        this.selectdLevel += 16;
                    }
                    this.keyReleased(49);
                    this.mainCanvas.repaint();
                    break;
                }
                case 0: {
                    if (!Keys.isKeyPressed(-22)) break;
                    this.selectedOption = 0;
                    this.keyReleased(-22);
                    Keys.keyReleased(-22);
                    break;
                }
                case 3: {
                    for (int i = 0; i < this._rectLevel.length; ++i) {
                        if (this._rectLevel[i] == null || !this._rectLevel[i].contains(x, y) || i + this.selectedPack * 16 > this.count) continue;
                        Level.getLevel(i + this.selectedPack * 16);
                        this._iGameMode = Level._iGameMode;
                        this.selectdLevel = i + this.selectedPack * 16;
                        this.startAnimation(true, this._iNextModeGame);
                    }
                    this.mainCanvas.repaint();
                    break;
                }
                default: {
                    this.keyReleased(5);
                }
            }
            this._iSelectedCompId = -1;
        }
    }

    private void paintNumSmallLevel(int number, int x, int y, Graphics g) {
        y -= (this.sprNumSmall.getHeight() >> 1) + (this.fontSmall.getHeight() >> 2);
        if (number < 10) {
            this.sprNumSmall.setFrame(number - 1);
            this.sprNumSmall.setPosition(x - (this.sprNumSmall.getWidth() >> 1), y);
            this.sprNumSmall.paint(g);
        } else if (number < 100) {
            this.sprNumSmall.setFrame(number / 10 - 1);
            this.sprNumSmall.setPosition(x - this.sprNumSmall.getWidth(), y);
            this.sprNumSmall.paint(g);
            int d = number % 10 == 0 ? 10 : number % 10;
            this.sprNumSmall.setFrame(d - 1);
            this.sprNumSmall.setPosition(x, y);
            this.sprNumSmall.paint(g);
        }
    }
}

