/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.text;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.StringTokenizer;
import sk.inlogic.util.Rectangle;

public class PreparedText {
    private Vector textLines = null;
    private Font font = null;
    private GFont gFont = null;
    private int fontColor = 65280;
    private int lineHeightCorrection = 0;

    public PreparedText(Font font) {
        this.font = font;
    }

    public PreparedText(GFont gFont) {
        this.gFont = gFont;
    }

    public void setLineHeightCorrection(int lineHeightCorrection) {
        this.lineHeightCorrection = lineHeightCorrection;
    }

    private void separateTextToLines(Vector lines, String text, int maxLineWidth) {
        String acceptableStr = "";
        String tokenStr = "";
        String tmpStr = "";
        int tmpStrWidth = 0;
        StringTokenizer st = new StringTokenizer(text, " ");
        while (st.hasMoreTokens()) {
            tokenStr = st.nextToken();
            tmpStr = tmpStr + (tmpStr == "" ? "" : " ") + tokenStr;
            if (this.gFont != null) {
                tmpStrWidth = this.gFont.stringWidth(tmpStr.toCharArray());
            } else if (this.font != null) {
                tmpStrWidth = this.font.stringWidth(tmpStr);
            }
            if (tmpStrWidth <= maxLineWidth) {
                acceptableStr = new String(tmpStr);
                continue;
            }
            lines.addElement(new String(acceptableStr));
            tmpStr = tokenStr;
            acceptableStr = tokenStr;
        }
        lines.addElement(new String(acceptableStr));
    }

    public void prepareText(String text, int maxLineWidth) {
        Vector<String> hardLines = new Vector<String>();
        StringTokenizer st = new StringTokenizer(text, "\n");
        while (st.hasMoreTokens()) {
            hardLines.addElement(st.nextToken());
        }
        this.textLines = new Vector();
        int hardLinesCount = hardLines.size();
        for (int i = 0; i < hardLinesCount; ++i) {
            this.separateTextToLines(this.textLines, (String)hardLines.elementAt(i), maxLineWidth);
        }
    }

    public void drawText(Graphics g, Rectangle bounds, int offsetY, int anchor) {
        int fontHeight = 0;
        Rectangle clip = new Rectangle(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        g.setClip(bounds.x, bounds.y, bounds.width, bounds.height);
        if (this.gFont != null) {
            fontHeight = this.gFont.getHeight() + this.lineHeightCorrection;
        } else if (this.font != null) {
            fontHeight = this.font.getHeight() + this.lineHeightCorrection;
        }
        int linesCount = this.textLines.size();
        int x = bounds.x;
        int y = bounds.y;
        if ((anchor & 0x20) == 32) {
            y = bounds.getBottom();
        } else if ((anchor & 2) == 2) {
            y = bounds.getCenterY();
        }
        if ((anchor & 8) == 8) {
            x = bounds.getRight();
        } else if ((anchor & 1) == 1) {
            x = bounds.getCenterX();
        }
        for (int i = 0; i < linesCount; ++i) {
            if (this.gFont != null) {
                this.gFont.drawString(g, ((String)this.textLines.elementAt(i)).toCharArray(), x, y + i * fontHeight - offsetY, anchor);
                continue;
            }
            if (this.font == null) continue;
            g.setColor(this.fontColor);
            g.drawString((String)this.textLines.elementAt(i), x, y + i * fontHeight - offsetY, anchor);
        }
        g.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    public void setFontColor(int color) {
        this.fontColor = color;
    }

    public int getTextHeight() {
        int fontHeight = 0;
        if (this.gFont != null) {
            fontHeight = this.gFont.getHeight() + this.lineHeightCorrection;
        } else if (this.font != null) {
            fontHeight = this.font.getHeight() + this.lineHeightCorrection;
        }
        return this.textLines.size() * fontHeight;
    }

    public int getTextLines() {
        return this.textLines.size();
    }

    public String getText(int line) {
        return this.textLines.elementAt(line).toString();
    }
}

