/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSplash
implements IScreen {
    private MainCanvas _mainCanvas;
    private static final int MODE_ENABLE_MUSIC_QUESTION = 0;
    private static final int MODE_COMPANY_LOGO = 1;
    private static final int MODE_SPLASH = 2;
    private static final int MODE_MENU = 3;
    private static final int MODE_TIME = 1500;
    private static final int _COMP_ID_YES = 0;
    private static final int _COMP_ID_NO = 1;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iMode;
    private int _iKcode;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode;
    private int selectedOption;
    private int rowDialog;
    private int colDialog;
    private int[][] _animationSequence = new int[3][3];
    private long _iModeDelay;
    private boolean _bChangeSequence = false;
    private Rectangle[] _rectItems = new Rectangle[2];
    private Rectangle rectScreen;
    private Rectangle rectNo;
    private Rectangle rectYes;
    private Rectangle rectWindow;
    private Image _imgBg;
    private Image imgLogo;
    private Image imgSplash;
    private Sprite sprIcons;
    private Sprite sprButton;
    private Sprite sprDialog;
    private PreparedText _ptTitle;
    private GFont fontBig;
    private AnimationComponent[] _animationComponents = new AnimationComponent[3];

    public ScreenSplash(MainCanvas mC) {
        System.out.println("splash");
        this._mainCanvas = mC;
        this._iMode = 0;
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this._iModeDelay = 1500L;
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.initBottomButtons();
        this.initDialog();
        this.prepareTxt();
        this.calculatePosition();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.startAnimation(true, 0);
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 3, 1});
        Resources.loadSprites(new int[]{44, 50, 51, 52});
        Resources.loadGFont(1);
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2, 3, 1});
        Resources.freeSprites(new int[]{44, 50, 51, 52});
        Resources.freeGFont(1);
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
        this.rectScreen = new Rectangle(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    private void initSprites() {
        this.sprButton = Resources.resSprs[50];
        this.sprIcons = Resources.resSprs[51];
        this.sprDialog = Resources.resSprs[52];
    }

    private void initImages() {
        this._imgBg = Resources.resImgs[2];
        this.imgSplash = Resources.resImgs[1];
        this.imgLogo = Resources.resImgs[3];
    }

    private void initFonts() {
        this.fontBig = Resources.resGFonts[1];
        this._ptTitle = new PreparedText(this.fontBig);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 0;
        this._animationSequence[0][1] = 1;
        this._animationSequence[0][2] = 2;
        this._animationSequence[1][0] = 0;
        this._animationSequence[1][1] = 1;
        this._animationSequence[1][2] = 2;
        this._animationSequence[2][0] = 0;
        this._animationSequence[2][1] = 2;
        this._animationSequence[2][2] = 1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this._mainCanvas, this.rectWindow, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this._mainCanvas, this.rectNo, this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this._mainCanvas, this.rectYes, this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(0);
        this._animationComponents[2].startHideAnimation(1);
    }

    private void prepareTxt() {
        System.out.println("" + Resources.resTexts[0].getHashedString(28));
        this._ptTitle.prepareText(Resources.resTexts[0].getHashedString(5), this._mainCanvas.getWidth());
    }

    private void freeGraphics() {
        this._imgBg = null;
        this.imgSplash = null;
        this.imgLogo = null;
        this._ptTitle = null;
    }

    public void calculatePosition() {
        this._rectItems[0] = new Rectangle(0, MainCanvas.HEIGHT - (this.sprButton.getHeight() << 1), this.sprButton.getWidth() << 1, this.sprButton.getHeight() << 1);
        this._rectItems[1] = new Rectangle(this._WIDTH - (this.sprButton.getWidth() << 1), MainCanvas.HEIGHT - (this.sprButton.getHeight() << 1), this.sprButton.getWidth() << 1, this.sprButton.getHeight() << 1);
    }

    public void beforeInteruption() {
        if (this._iMode == 0) {
            this._mainCanvas.getSoundManager().Stop();
        }
        this._mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
        this._mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        if (this._iMode == 0) {
            this._mainCanvas.getSoundManager().Stop();
        }
    }

    public void update(long lastRunLenght) {
        switch (this._iMode) {
            case 1: {
                if (this._iModeDelay > 0L) {
                    this._iModeDelay -= lastRunLenght;
                    break;
                }
                this._iModeDelay = 1500L;
                this.nextMode();
                break;
            }
            case 2: {
                if (this._iModeDelay > 0L) {
                    this._iModeDelay -= lastRunLenght;
                    break;
                }
                this._iModeDelay = 1500L;
                this.nextMode();
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(this._iKcode)) {
                    MainCanvas.music = false;
                    Settings.musicOn = false;
                    this._mainCanvas.getSoundManager().SetSoundOn(false);
                    break;
                }
                if (!Keys.isFKLeftCode(this._iKcode)) break;
                MainCanvas.music = true;
                Settings.musicOn = true;
                this._mainCanvas.getSoundManager().SetSoundOn(true);
            }
        }
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void nextMode() {
        switch (this._iMode) {
            case 0: {
                this.startAnimation(true, 1);
                this._mainCanvas.repaint();
                this._mainCanvas.serviceRepaints();
                break;
            }
            case 1: {
                this.startAnimation(true, 2);
                this._mainCanvas.repaint();
                this._mainCanvas.serviceRepaints();
                break;
            }
            case 2: {
                this.startAnimation(true, 3);
                this._mainCanvas.repaint();
                this._mainCanvas.serviceRepaints();
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationSequence[this._iMode].length; ++i) {
            if (this._animationSequence[this._iMode][i] == -1 || this._animationComponents[this._animationSequence[this._iMode][i]] == null || this._animationComponents[this._animationSequence[this._iMode][i]].isComponentAnimated()) continue;
            this._animationComponents[this._animationSequence[this._iMode][i]].update();
            this._mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                if (this._iNextMode == 3) {
                    this.startMenuScreen();
                }
                this._iSequence = this._iSequenceShow;
                this._iMode = this._iNextMode;
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startMenuScreen() {
        ScreenMenu sg = new ScreenMenu(this._mainCanvas, 0);
        if (this._mainCanvas.getSoundManager().IsSoundOn()) {
            this._mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        }
        this._mainCanvas.changeLastActiveScreen(sg);
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this._iMode) {
            case 0: {
                this.paintMusic(g);
                break;
            }
            case 1: {
                this.paintCorpLogo(g);
                break;
            }
            case 2: {
                this.paintSplash(g);
            }
        }
    }

    private void paintBackground(Graphics g) {
        g.drawImage(this._imgBg, 0, 0, 20);
    }

    private void paintMusic(Graphics g) {
        this.paintMusicBody(g);
        this.paintMusicFk(g);
    }

    private void paintCorpLogo(Graphics g) {
        g.drawImage(this.imgLogo, this.rectScreen.getCenterX(), this.rectScreen.getCenterY(), 3);
    }

    private void paintSplash(Graphics g) {
        g.drawImage(this.imgSplash, this.rectScreen.getCenterX(), this.rectScreen.getCenterY(), 3);
    }

    private void paintMusicBody(Graphics g) {
        this.paintDialog(g);
        this.paintMusicImg(g);
    }

    private void paintMusicImg(Graphics g) {
        int iLinesCount = this._ptTitle.getTextLines();
        int iY = this.rectWindow.getCenterY() - (this._ptTitle.getTextHeight() >> 1);
        for (int i = 0; i < iLinesCount; ++i) {
            this.fontBig.drawString(g, this._ptTitle.getText(i).toCharArray(), this.rectWindow.getCenterX(), iY, 17);
            iY += this.fontBig.getHeight();
        }
    }

    private void paintMusicFk(Graphics g) {
        this.sprButton.setFrame(0);
        if (this.selectedOption == 1) {
            this.sprButton.setFrame(1);
        }
        this.sprButton.setPosition(this.rectYes.x, this.rectYes.y);
        this.sprButton.paint(g);
        this.sprIcons.setFrame(Common.ICON_YES);
        this.sprIcons.setPosition(this.rectYes.getCenterX() - (this.sprIcons.getWidth() >> 1), this.rectYes.getCenterY() - (this.sprIcons.getHeight() >> 1));
        this.sprIcons.paint(g);
        if (this.selectedOption == 2) {
            this.sprButton.setFrame(1);
        }
        this.sprButton.setPosition(this.rectNo.x, this.rectNo.y);
        this.sprButton.paint(g);
        this.sprIcons.setFrame(Common.ICON_NO);
        this.sprIcons.setPosition(this.rectNo.getCenterX() - (this.sprIcons.getWidth() >> 1), this.rectNo.getCenterY() - (this.sprIcons.getHeight() >> 1));
        this.sprIcons.paint(g);
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        switch (this._iMode) {
            case 0: {
                if (Keys.isFKLeftCode(keyCode)) {
                    this.selectedOption = 1;
                    this._iKcode = keyCode;
                    Settings.musicOn = true;
                    this._mainCanvas.getSoundManager().SetSoundOn(true);
                    this.nextMode();
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.selectedOption = 2;
                this._iKcode = keyCode;
                Settings.musicOn = false;
                this._mainCanvas.getSoundManager().SetSoundOn(false);
                this.nextMode();
                break;
            }
            case 1: 
            case 2: {
                if (this._iModeDelay >= 1500L || !Keys.isActionGeneratedByKey(5, keyCode) || this._iModeDelay <= 100L) break;
                this._iModeDelay = 1500L;
                this.nextMode();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        switch (this._iMode) {
            case 0: {
                for (int i = 0; i < this._rectItems.length; ++i) {
                    if (!this._rectItems[i].contains(x, y)) continue;
                    if (i == 0) {
                        this.selectedOption = 1;
                        Settings.musicOn = true;
                        MainCanvas.music = true;
                        this._mainCanvas.getSoundManager().SetSoundOn(true);
                        this.nextMode();
                        continue;
                    }
                    if (i != 1) continue;
                    this.selectedOption = 2;
                    Settings.musicOn = false;
                    this._mainCanvas.getSoundManager().SetSoundOn(false);
                    this.nextMode();
                    MainCanvas.music = false;
                }
                break;
            }
            case 1: 
            case 2: {
                this._iModeDelay = 0L;
                if (this._iModeDelay >= 1500L) break;
                Keys.keyPressed(53);
            }
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        switch (this._iMode) {
            case 0: {
                for (int i = 0; i < this._rectItems.length; ++i) {
                    if (!this._rectItems[i].contains(x, y)) continue;
                    if (i == 0) {
                        Settings.musicOn = true;
                        MainCanvas.music = true;
                        this._mainCanvas.getSoundManager().SetSoundOn(true);
                        this.nextMode();
                        continue;
                    }
                    if (i != 1) continue;
                    Settings.musicOn = false;
                    this._mainCanvas.getSoundManager().SetSoundOn(false);
                    this.nextMode();
                    MainCanvas.music = false;
                }
                break;
            }
            case 1: 
            case 2: {
                if (this._iModeDelay >= 1500L || !Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }

    private void initBottomButtons() {
        int width = this.sprButton.getWidth();
        int height = this.sprButton.getHeight();
        int x = width >> 2;
        int y = this.rectScreen.height - (height + (height >> 2));
        this.rectYes = new Rectangle(x, y, width, height);
        x = this.rectScreen.width - (width + (width >> 2));
        this.rectNo = new Rectangle(x, y, width, height);
    }

    private void initDialog() {
        this.rowDialog = 7;
        this.colDialog = this.rectScreen.width / this.sprDialog.getWidth() - 2;
        int width = this.sprDialog.getWidth() * this.colDialog;
        int height = this.sprDialog.getHeight() * this.rowDialog;
        int x = (this.rectScreen.width >> 1) - (width >> 1);
        int y = (this.rectScreen.height >> 1) - (height >> 1);
        this.rectWindow = new Rectangle(x, y, width, height);
    }

    private void paintDialog(Graphics g) {
        int row = 0;
        int y = this.rectWindow.y;
        while (row < this.rowDialog) {
            int x = this.rectWindow.x;
            int frame = row == 0 ? 0 : (row == this.rowDialog - 1 ? 6 : 3);
            this.drawSprite(g, x, y, this.sprDialog, frame);
            x += this.sprDialog.getHeight();
            int col = 1;
            while (col < this.colDialog - 1) {
                int frameMid = row == 0 ? 1 : (row == this.rowDialog - 1 ? 7 : 4);
                this.drawSprite(g, x, y, this.sprDialog, frameMid);
                ++col;
                x += this.sprDialog.getHeight();
            }
            frame = row == 0 ? 2 : (row == this.rowDialog - 1 ? 8 : 5);
            this.drawSprite(g, x, y, this.sprDialog, frame);
            ++row;
            y += this.sprDialog.getHeight();
        }
    }

    private void drawSprite(Graphics g, int x, int y, Sprite spr, int frame) {
        spr.setFrame(frame);
        spr.setPosition(x, y);
        spr.paint(g);
    }
}

