/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Block;
import sk.inlogic.Common;
import sk.inlogic.Game;
import sk.inlogic.Jewel;
import sk.inlogic.Level;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.graphics.GFont;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.screen.ScreenSelectBonusLevel;
import sk.inlogic.screen.ScreenSelectLevel;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    private MainCanvas mainCanvas;
    private boolean _bNeedRepaint;
    private int iStatus = -1;
    private int _iGameMode;
    private int highScore;
    private static final int STATUS_GAME = 0;
    private static final int STATUS_INGAMEMENU = 1;
    private static final int STATUS_RESULTDIALOG = 2;
    private static final int STATUS_INSTRUCTIONS = 3;
    private static final int STATUS_TUTORIAL = 4;
    private static final int STATUS_STARTSCREEN = 5;
    private static final int STATUS_RESTARTSCREEN = 6;
    private static final int STATUS_LAST_MESSAGE = 7;
    private static final int STATUS_REALY_QUIT = 8;
    private static final int STATUS_MAIN_MENU = 9;
    private static final int STATUS_MAIN_LEVEL_SELECT = 9;
    private static final int COMP_ID_HINT = 0;
    private static final int COMP_ID_MENU = 4;
    private static final int COMP_ID_RESTART = 5;
    private static final int COMP_ID_SOUNDS = 3;
    private static final int COMP_ID_MAINMENU = 6;
    private static final int COMP_ID_INSTRUCTIONS = 1;
    private static final int COMP_ID_ARR_UP = 7;
    private static final int COMP_ID_ARR_DOWN = 8;
    private static final int CENTER_BUTTON = 9;
    private static final int TOTAL_COMP_IDS = 10;
    private Rectangle[] _rectItems = new Rectangle[10];
    private Rectangle rectGameArea;
    private Rectangle _rectDialog;
    private Rectangle rectLogo;
    private Rectangle _rectTop;
    private Rectangle rectDialogInstr;
    private Rectangle rectSmallDialogInstr;
    private Rectangle rectFK;
    private Rectangle rectTopCenter;
    private int _iOffsetY;
    private int _iOffsetXDefault = 5;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private int selectedButton = -1;
    private int startDialogRows;
    private int startDialogColumns;
    private int exitDialogRows;
    private int exitDialogColumns;
    private int instrDialogRows;
    private int instrDialogColumns;
    private int resultDialogRows;
    private int resultDialogColumns;
    private Rectangle rectStartDialog;
    private Rectangle rectStartGameText;
    private Rectangle rectExitDialog;
    private Rectangle rectExitGameText;
    private Rectangle rectInstrDialog;
    private Rectangle rectInstrGameText;
    private Rectangle rectResultDialog;
    private Rectangle rectResultGameText;
    private Rectangle rectStartTextUp;
    private Rectangle rectStartTextDown;
    private boolean _bChangeSequence = false;
    private Image imgBG;
    private Image imgButtonSelector;
    private Image imgGameLogo;
    private Image imgTopPanel;
    private Image imgResult;
    private Sprite sprIcons;
    private Sprite sprButton;
    private Sprite sprResultStarsActive;
    private Sprite sprResultStarsInactive;
    private Sprite sprGameMode;
    private Sprite sprTopbarIcons;
    private Sprite sprTopBarIconsMini;
    private Sprite sprWindow;
    private Sprite sprResult;
    private Sprite sprRibbon;
    private Sprite sprArrow;
    private Sprite sprBigNumbers;
    private Sprite sprSmallNumbers;
    private Sprite sprTopBarIcons;
    private Sprite sprTopPanelBg;
    private PreparedText _ptInstructions;
    private PreparedText _ptGameTutorial;
    private PreparedText _ptGameTxts;
    private PreparedText _ptGameTxts2;
    private PreparedText _ptGameScore;
    private PreparedText _ptMoves;
    private GFont fontBig;
    private GFont fontSmall;
    private GFont fontWhite;
    private int[][] _animationSequence = new int[9][13];
    private AnimationComponent[] _animationComponents = new AnimationComponent[13];
    private int _iSelectedCompId;
    private int icount;
    private int _iTextOffsetY;
    private boolean _bScrollUP = false;
    private boolean _bScrollDOWN = true;
    int level = 0;
    private int actualLevel;
    private boolean _bBonusPack = false;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iFinalHeight;
    public int interuption = 0;
    public int _iCycle;
    public int _iMusicControler;
    int _iBw;
    private int score = 0;
    private String stars = "";
    int lvl = 0;
    int checkButton = 5;
    int checkButton2 = 5;
    boolean bDragInstructions = false;

    public ScreenGame(MainCanvas mC, int gameMode, int level, boolean bonus) {
        System.out.println("SCREEN GAME");
        this.mainCanvas = mC;
        this._iGameMode = gameMode;
        this.actualLevel = level;
        this._bBonusPack = bonus;
        System.out.println("actual level: " + this.actualLevel);
        System.out.println("level: " + level);
        if (this._bBonusPack) {
            Level.getBonusLevel(this.actualLevel);
        } else {
            Level.getLevel(this.actualLevel);
        }
        this.initDimensions();
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.initData();
        System.out.println("init data");
        this.calculatePositions();
        System.out.println("calculate done");
        this.preapreTxt();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.loadLevel();
        this.loadData();
        if (Level._bIsTutorial) {
            this.startAnimation(true, 5);
        } else {
            this.startAnimation(true, 5);
        }
    }

    public void afterHide() {
        RMSObjects.freeRMSConnect(this.getRMSConnectIdByGameType(this._iGameMode));
        this.freeResources();
        this.freeGraphics();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{2, 4, 5, 29, 24, 30});
        Resources.loadSprites(new int[]{22, 13, 14, 15, 16, 17, 18, 30, 19, 31, 31, 35, 36, 37, 44, 47, 59, 58, 51, 50, 57, 54, 56, 55, 31, 9, 32, 60});
        Resources.loadGFonts(new int[]{0, 1, 2});
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(new int[]{2, 4, 5, 29, 24, 30});
        Resources.freeSprites(new int[]{22, 13, 15, 16, 17, 18, 30, 19, 31, 35, 36, 37, 51, 50, 44, 47, 59, 58, 57, 54, 56, 55, 31, 9, 32, 60});
        Resources.freeGFonts(new int[]{0, 1, 2});
    }

    private void initDimensions() {
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
    }

    private void initImages() {
        this.imgBG = Resources.resImgs[2];
        this.imgGameLogo = Resources.resImgs[4];
        this.imgButtonSelector = Resources.resImgs[29];
        this.imgTopPanel = Resources.resImgs[24];
        this.imgResult = Resources.resImgs[30];
    }

    private void initSprites() {
        this.sprIcons = Resources.resSprs[51];
        this.sprButton = Resources.resSprs[50];
        this.sprTopbarIcons = Resources.resSprs[31];
        this.sprTopBarIconsMini = Resources.resSprs[32];
        this.sprGameMode = Resources.resSprs[37];
        this.sprResultStarsActive = Resources.resSprs[58];
        this.sprResultStarsInactive = Resources.resSprs[59];
        this.sprWindow = Resources.resSprs[44];
        this.sprResult = Resources.resSprs[47];
        this.sprRibbon = Resources.resSprs[57];
        this.sprArrow = Resources.resSprs[54];
        this.sprBigNumbers = Resources.resSprs[56];
        this.sprSmallNumbers = Resources.resSprs[55];
        this.sprTopBarIcons = Resources.resSprs[31];
        this.sprTopPanelBg = Resources.resSprs[60];
    }

    private void initFonts() {
        this.fontBig = Resources.resGFonts[1];
        this.fontSmall = Resources.resGFonts[0];
        this.fontWhite = Resources.resGFonts[2];
        this._ptInstructions = new PreparedText(this.fontBig);
        this._ptGameScore = new PreparedText(this.fontSmall);
        this._ptMoves = new PreparedText(this.fontBig);
        this._ptGameTutorial = new PreparedText(this.fontBig);
        this._ptGameTxts = new PreparedText(this.fontBig);
        this._ptGameTxts2 = new PreparedText(this.fontBig);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 5;
        this._animationSequence[0][1] = 10;
        this._animationSequence[0][2] = 11;
        this._animationSequence[0][3] = 12;
        this._animationSequence[0][4] = -1;
        this._animationSequence[0][5] = -1;
        this._animationSequence[1][0] = 4;
        this._animationSequence[1][1] = 6;
        this._animationSequence[1][2] = 7;
        this._animationSequence[1][3] = 8;
        this._animationSequence[1][4] = 9;
        this._animationSequence[1][5] = 10;
        this._animationSequence[3][0] = 1;
        this._animationSequence[3][1] = 3;
        this._animationSequence[3][2] = 5;
        this._animationSequence[3][3] = 10;
        this._animationSequence[3][4] = -1;
        this._animationSequence[3][5] = -1;
        this._animationSequence[7][0] = 1;
        this._animationSequence[7][1] = 3;
        this._animationSequence[7][2] = 10;
        this._animationSequence[7][3] = -1;
        this._animationSequence[7][4] = -1;
        this._animationSequence[7][5] = -1;
        this._animationSequence[8][0] = 1;
        this._animationSequence[8][1] = 3;
        this._animationSequence[8][2] = 10;
        this._animationSequence[8][3] = 11;
        this._animationSequence[8][4] = -1;
        this._animationSequence[8][5] = -1;
        this._animationSequence[6][0] = 1;
        this._animationSequence[6][1] = 3;
        this._animationSequence[6][2] = 10;
        this._animationSequence[6][3] = 11;
        this._animationSequence[6][4] = -1;
        this._animationSequence[6][5] = -1;
        this._animationSequence[2][0] = 1;
        this._animationSequence[2][1] = 3;
        this._animationSequence[2][2] = 10;
        this._animationSequence[2][3] = 11;
        this._animationSequence[2][4] = -1;
        this._animationSequence[2][5] = -1;
        this._animationSequence[5][0] = 1;
        this._animationSequence[5][1] = 3;
        this._animationSequence[5][2] = 11;
        this._animationSequence[5][3] = -1;
        this._animationSequence[5][4] = -1;
        this._animationSequence[5][5] = -1;
        this._animationSequence[4][0] = 1;
        this._animationSequence[4][1] = 3;
        this._animationSequence[4][2] = 11;
        this._animationSequence[4][3] = -1;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, new Rectangle(0, 0, 0, 0), this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, new Rectangle(0, 0, 0, 0), this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = this.iStatus == 5 || this.iStatus == 4 ? new AnimationComponent(this.mainCanvas, this.rectStartGameText, this._WIDTH, this._HEIGHT) : (this.iStatus == 6 || this.iStatus == 8 || this.iStatus == 7 ? new AnimationComponent(this.mainCanvas, this.rectExitGameText, this._WIDTH, this._HEIGHT) : (this.iStatus == 3 ? new AnimationComponent(this.mainCanvas, this.rectInstrGameText, this._WIDTH, this._HEIGHT) : new AnimationComponent(this.mainCanvas, this.rectStartGameText, this._WIDTH, this._HEIGHT)));
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this.rectLogo, this._WIDTH, this._HEIGHT);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this._rectTop, this._WIDTH, this._HEIGHT);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, this._rectItems[5], this._WIDTH, this._HEIGHT);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this._rectItems[3], this._WIDTH, this._HEIGHT);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this._rectItems[1], this._WIDTH, this._HEIGHT);
        this._animationComponents[9] = new AnimationComponent(this.mainCanvas, this._rectItems[6], this._WIDTH, this._HEIGHT);
        this._animationComponents[10] = new AnimationComponent(this.mainCanvas, this._rectItems[4], this._WIDTH, this._HEIGHT);
        this._animationComponents[11] = new AnimationComponent(this.mainCanvas, this._rectItems[0], this._WIDTH, this._HEIGHT);
        this._animationComponents[12] = new AnimationComponent(this.mainCanvas, this.rectGameArea, this._WIDTH, this._HEIGHT);
        this.showAnimationComponent();
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[2].startShowAnimation(2);
        this._animationComponents[3].startShowAnimation(3);
        this._animationComponents[4].startShowAnimation(2);
        this._animationComponents[5].startShowAnimation(2);
        this._animationComponents[6].startShowAnimation(1);
        this._animationComponents[7].startShowAnimation(0);
        this._animationComponents[8].startShowAnimation(1);
        this._animationComponents[9].startShowAnimation(0);
        this._animationComponents[10].startShowAnimation(1);
        this._animationComponents[11].startShowAnimation(0);
        this._animationComponents[12].startShowAnimation(3);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[2].startHideAnimation(2);
        this._animationComponents[3].startHideAnimation(3);
        this._animationComponents[4].startHideAnimation(2);
        this._animationComponents[5].startHideAnimation(2);
        this._animationComponents[6].startHideAnimation(1);
        this._animationComponents[7].startHideAnimation(0);
        this._animationComponents[8].startHideAnimation(1);
        this._animationComponents[9].startHideAnimation(0);
        this._animationComponents[10].startHideAnimation(1);
        this._animationComponents[11].startHideAnimation(0);
        this._animationComponents[12].startHideAnimation(3);
    }

    private void preapreTxt() {
        String _sTmpControls = Resources.resTexts[0].getHashedString(16);
        this._ptInstructions.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + _sTmpControls, this.rectInstrGameText.width);
        this._ptInstructions.setLineHeightCorrection(-2);
        this._ptGameScore.prepareText("0", this._rectTop.width);
        this._ptMoves.prepareText("0", this._rectTop.width);
    }

    private void loadLevel() {
        this.lvl = this._iGameMode == Level.TYPE_BLOCKER || this._iGameMode == Level.TYPE_MIXED_TIME_AND_BLOCKS ? Level._iBlockScheme : 1;
        RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
    }

    private void loadData() {
        int rmsConnectId = this.getRMSConnectIdByGameType(0);
        RMSObjects.createRMSConnect(rmsConnectId);
        if (!this._bBonusPack) {
            RMSObjects.createRMSConnect(0);
            RMSObjects.rmsConnects[0].load();
        } else {
            RMSObjects.createRMSConnect(9);
            RMSObjects.rmsConnects[9].load();
        }
    }

    private void freeGraphics() {
        this.imgBG = null;
        this.imgGameLogo = null;
        this._ptInstructions = null;
        this.sprGameMode = null;
    }

    private void addScoreToTable() {
        if (RMSObjects.game.getScore() < Level._iScoreMin) {
            return;
        }
        if (!this._bBonusPack) {
            PowV2ScoreItem scoreItem = new PowV2ScoreItem();
            scoreItem.powGameId = 0;
            scoreItem.scorePos = this.actualLevel;
            scoreItem.userName = Integer.toString(this.actualLevel);
            scoreItem.scoreValue = RMSObjects.game.getScore() >= Level._iScoreHig ? 3 : (RMSObjects.game.getScore() >= Level._iScoreMid ? 2 : (RMSObjects.game.getScore() >= Level._iScoreMin ? 1 : 0));
            if (this.score > this.highScore) {
                this.highScore = this.score;
            }
            scoreItem.highScore = this.highScore;
            RMSObjects.localScores.userName = Integer.toString(this.actualLevel);
            System.out.println("RMSObjects.localScores.userName: " + RMSObjects.localScores.userName);
            RMSObjects.localScores.insertScoreItem(scoreItem, this.actualLevel);
            if (!RMSObjects.rmsConnects[0].isExist()) {
                RMSObjects.rmsConnects[0].create();
            }
            RMSObjects.rmsConnects[0].save();
        } else {
            PowV2ScoreItem scoreItem = new PowV2ScoreItem();
            scoreItem.powGameId = 0;
            scoreItem.scorePos = this.actualLevel;
            scoreItem.userName = Integer.toString(this.actualLevel);
            scoreItem.scoreValue = RMSObjects.game.getScore() >= Level._iScoreHig ? 3 : (RMSObjects.game.getScore() >= Level._iScoreMid ? 2 : (RMSObjects.game.getScore() >= Level._iScoreMin ? 1 : 0));
            if (this.score > this.highScore) {
                this.highScore = this.score;
            }
            scoreItem.highScore = this.highScore;
            RMSObjects.localScoresBonus.userName = Integer.toString(this.actualLevel);
            RMSObjects.localScoresBonus.insertScoreItem(scoreItem, this.actualLevel);
            if (!RMSObjects.rmsConnects[9].isExist()) {
                RMSObjects.rmsConnects[9].create();
            }
            RMSObjects.rmsConnects[9].save();
        }
    }

    private int getRMSConnectIdByGameType(int gameType) {
        switch (0) {
            case 20: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
        }
        return 0;
    }

    public void beforeInteruption() {
        System.out.println("before interuption");
        if (this.iStatus == 0) {
            this.setGameMenuStatus();
        }
        this.mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
        System.out.println("after interuption");
        this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
    }

    private void calculatePositions() {
        Jewel.SHIFT_HORIZONTAL_SEL = 0;
        Jewel.SHIFT_VERTICAL_SEL = 0;
        Jewel.BLOCKSIZE = Resources.resImgs[5].getWidth();
        Jewel.SHIFT_HORIZONTAL = (Resources.resImgs[5].getWidth() >> 1) - (Resources.resSprs[13].getWidth() >> 1);
        Jewel.SHIFT_VERTICAL = (Resources.resImgs[5].getHeight() >> 1) - (Resources.resSprs[13].getHeight() >> 1);
        Jewel.SHIFT_HORIZONTAL_FALL = (Resources.resImgs[5].getWidth() >> 1) - (Resources.resSprs[13].getWidth() >> 1);
        Jewel.SHIFT_VERTICAL_FALL = (Resources.resImgs[5].getHeight() >> 1) - 1;
        Jewel.SHIFT_HORIZONTAL_ESCAPE = (Resources.resImgs[5].getWidth() >> 1) - (Resources.resSprs[18].getWidth() >> 1);
        Jewel.SHIFT_VERTICAL_ESCAPE = (Resources.resImgs[5].getHeight() >> 1) - (Resources.resSprs[18].getHeight() >> 1);
        this._iOffsetY >>= 4;
        int _iTmpY = (MainCanvas.HEIGHT - (Jewel.BLOCKSIZE << 3) >> 1) - this.sprTopPanelBg.getHeight() >> 1;
        this._rectTop = new Rectangle(this._iOffsetXDefault, _iTmpY, this._WIDTH - (this._iOffsetXDefault << 1), this.sprTopPanelBg.getHeight());
        this._rectItems[5] = new Rectangle((this._WIDTH >> 1) - (this.sprButton.getWidth() >> 1), this._HEIGHT - (this.sprButton.getHeight() << 2) - 1, this.sprButton.getWidth(), this.sprButton.getHeight());
        int pY = this._rectItems[5].y + this._rectItems[5].height + (this.sprButton.getHeight() >> 3);
        int pX = (this._WIDTH >> 1) - (this.sprButton.getWidth() >> 1);
        int pXoffset = this.sprButton.getWidth() + (this.sprButton.getWidth() >> 2);
        this.rectLogo = new Rectangle(this._WIDTH >> 1, this.imgGameLogo.getHeight() >> 1, this.imgGameLogo.getWidth(), this.imgGameLogo.getHeight());
        int countX = MainCanvas.WIDTH / this.sprWindow.getWidth();
        int countY = (MainCanvas.HEIGHT - (this.sprButton.getHeight() << 1)) / this.sprWindow.getHeight();
        if (MainCanvas.HEIGHT <= 300) {
            --countX;
            --countY;
            if (MainCanvas.HEIGHT <= 220) {
                ++countY;
            }
        }
        int width = this.sprWindow.getWidth() * countX;
        int height = this.sprWindow.getHeight() * countY;
        if (countX % 2 == 1) {
            width += this.sprWindow.getWidth() >> 1;
        }
        if (countY % 2 == 1) {
            height += this.sprWindow.getHeight() >> 1;
        }
        if (MainCanvas.HEIGHT <= 220) {
            height += this.sprWindow.getHeight() >> 1;
        }
        if (MainCanvas.HEIGHT == 208) {
            height += this.sprWindow.getHeight() >> 1;
        }
        int y = MainCanvas.HEIGHT - height - this.sprButton.getHeight();
        if (MainCanvas.HEIGHT == 240 && MainCanvas.WIDTH == 320) {
            y -= this.sprWindow.getHeight();
            height += this.sprWindow.getHeight();
        }
        this.rectDialogInstr = new Rectangle((MainCanvas.WIDTH >> 1) - (width >> 1), y, width, height);
        this.rectSmallDialogInstr = new Rectangle(this.rectDialogInstr.x + this.sprWindow.getWidth(), y + this.sprWindow.getHeight(), width - (this.sprWindow.getWidth() << 1), height - (this.sprWindow.getHeight() << 1));
        this._rectItems[3] = new Rectangle(pX, pY + (this.sprButton.getHeight() >> 2), this.sprButton.getWidth(), this.sprButton.getHeight());
        this._rectItems[1] = new Rectangle(pX - pXoffset, pY - (this.sprButton.getHeight() >> 1), this.sprButton.getWidth(), this.sprButton.getHeight());
        this._rectItems[6] = new Rectangle(pX + pXoffset, pY - (this.sprButton.getHeight() >> 1), this.sprButton.getWidth(), this.sprButton.getHeight());
        int iShiftY = 0;
        if (MainCanvas.HEIGHT < 640) {
            iShiftY = MainCanvas.HEIGHT >= 480 ? Jewel.BLOCKSIZE >> 3 : Jewel.BLOCKSIZE >> 2;
        }
        y = this.sprTopPanelBg.getHeight() + (MainCanvas.HEIGHT - this.sprTopPanelBg.getHeight() >> 1) - (Jewel.BLOCKSIZE << 2) - (this.sprButton.getHeight() >> 1);
        this.rectGameArea = new Rectangle(MainCanvas.WIDTH - (Jewel.BLOCKSIZE << 3) >> 1, y, Jewel.BLOCKSIZE << 3, Jewel.BLOCKSIZE << 3);
        RMSObjects.game.setGameArea(this.rectGameArea);
        Jewel.MOVE_VELOCITY = (this.rectGameArea.width << 8) / 48;
        Jewel.DSP_BNSBOMB = Resources.resSprs[16].getWidth() - Jewel.BLOCKSIZE >> 1;
        Jewel.DSP_BNSCROSS = Resources.resSprs[17].getWidth() - Jewel.BLOCKSIZE >> 1;
        int offset = this.sprButton.getWidth() >> 3;
        int xCenterFK = MainCanvas.WIDTH - (this.sprButton.getWidth() >> 1) - offset;
        int yCenterFK = MainCanvas.HEIGHT - (this.sprButton.getHeight() >> 1) - offset;
        this.rectFK = new Rectangle(xCenterFK - (this.sprButton.getWidth() >> 1), yCenterFK - (this.sprButton.getHeight() >> 1), this.sprButton.getWidth(), this.sprButton.getHeight());
        int x = (MainCanvas.WIDTH >> 1) - (this.imgTopPanel.getWidth() >> 1);
        this.rectTopCenter = new Rectangle(x, 0, this.imgTopPanel.getWidth(), this.imgTopPanel.getHeight());
        int countTilesDialogColumns = MainCanvas.WIDTH / this.sprWindow.getWidth();
        int countTilesDialogRows = MainCanvas.HEIGHT / this.sprWindow.getHeight();
        width = this.imgResult.getWidth();
        height = this.imgResult.getHeight();
        this.rectStartDialog = new Rectangle((MainCanvas.WIDTH >> 1) - (width >> 1), (MainCanvas.HEIGHT >> 1) - (height >> 1), width, height);
        this.rectStartGameText = new Rectangle(this.rectStartDialog.x + (this.sprButton.getWidth() >> 1) + (this.sprButton.getWidth() >> 2), this.rectStartDialog.y + (this.sprButton.getHeight() >> 1), this.rectStartDialog.width - this.sprButton.getWidth() - (this.sprButton.getWidth() >> 1), this.rectStartDialog.height - this.sprButton.getHeight() - this.sprButton.getHeight());
        this.startDialogColumns = countTilesDialogColumns - 2;
        this.startDialogRows = countTilesDialogRows - 8;
        width = this.sprWindow.getWidth() * this.startDialogColumns;
        height = this.sprWindow.getHeight() * this.startDialogRows;
        this.exitDialogColumns = countTilesDialogColumns - 3;
        this.exitDialogRows = countTilesDialogRows - 10;
        if (MainCanvas.HEIGHT <= 260) {
            this.exitDialogRows += 5;
            ++this.exitDialogColumns;
        }
        width = this.sprWindow.getWidth() * this.exitDialogColumns;
        height = this.sprWindow.getHeight() * this.exitDialogRows;
        this.rectExitDialog = new Rectangle((MainCanvas.WIDTH >> 1) - (width >> 1), (MainCanvas.HEIGHT >> 1) - (height >> 1), width, height);
        this.rectExitGameText = new Rectangle(this.rectExitDialog.x + (this.sprButton.getWidth() >> 1), this.rectExitDialog.y + (this.sprButton.getHeight() >> 1), this.rectExitDialog.width - this.sprButton.getWidth(), this.rectExitDialog.height - this.sprButton.getHeight());
        this.instrDialogColumns = countTilesDialogColumns - 3;
        this.instrDialogRows = countTilesDialogRows - 6;
        width = this.sprWindow.getWidth() * this.instrDialogColumns;
        height = this.sprWindow.getHeight() * this.instrDialogRows;
        this.rectInstrDialog = new Rectangle((MainCanvas.WIDTH >> 1) - (width >> 1), (MainCanvas.HEIGHT >> 1) - (height >> 1), width, height);
        this.rectInstrGameText = new Rectangle(this.rectInstrDialog.x + this.sprArrow.getWidth(), this.rectInstrDialog.y + this.sprArrow.getHeight(), this.rectInstrDialog.width - (this.sprArrow.getWidth() << 1), this.rectInstrDialog.height - (this.sprArrow.getHeight() << 1));
        this.resultDialogColumns = this.sprRibbon.getWidth() / this.sprWindow.getWidth() + 1;
        this.resultDialogRows = countTilesDialogRows - 6;
        width = this.imgResult.getWidth();
        height = this.imgResult.getHeight();
        this.rectResultDialog = new Rectangle((MainCanvas.WIDTH >> 1) - (width >> 1), (MainCanvas.HEIGHT >> 1) - (height >> 1), width, height);
        this.rectResultGameText = new Rectangle(this.rectResultDialog.x + (this.sprButton.getWidth() >> 1), this.rectResultDialog.y + (this.sprButton.getHeight() >> 1), this.rectResultDialog.width - this.sprButton.getWidth(), this.rectResultDialog.height - this.sprButton.getHeight());
        int widthArrow = this.sprArrow.getHeight();
        int heightArrow = this.sprArrow.getWidth();
        this._rectItems[7] = new Rectangle((MainCanvas.WIDTH >> 1) - (widthArrow >> 1), this.rectInstrDialog.y + (heightArrow >> 3), widthArrow, heightArrow);
        this._rectItems[8] = new Rectangle((MainCanvas.WIDTH >> 1) - (widthArrow >> 1), this.rectInstrDialog.getBottom() - heightArrow - (heightArrow >> 3), widthArrow, heightArrow);
        int widthBtn = MainCanvas.WIDTH / 3;
        this._rectItems[0] = new Rectangle(0, this.rectDialogInstr.getBottom() - (this.sprButton.getHeight() >> 2), widthBtn, (this.sprButton.getHeight() << 1) + (this.sprButton.getHeight() >> 2));
        this._rectItems[4] = new Rectangle(MainCanvas.WIDTH - widthBtn, this.rectDialogInstr.getBottom() - (this.sprButton.getHeight() >> 2), widthBtn, (this.sprButton.getHeight() << 1) + (this.sprButton.getHeight() >> 2));
        this._rectItems[9] = new Rectangle((MainCanvas.WIDTH >> 1) - (widthBtn >> 1), this._rectItems[4].y, widthBtn, this.sprButton.getHeight());
        width = this.rectStartGameText.width;
        height = (this.rectStartGameText.height >> 1) - (this.sprGameMode.getHeight() >> 1);
        this.rectStartTextUp = new Rectangle(this.rectStartGameText.x, this.rectStartGameText.y, width, height);
        this.rectStartTextDown = new Rectangle(this.rectStartGameText.x, this.rectStartGameText.getBottom() - height, width, height);
    }

    public void update(long lastRunLenght) {
        if (this.iStatus == 5) {
            this.reset();
        }
        if (this.iStatus == 0 && this._iNextMode != 2) {
            RMSObjects.game.update(lastRunLenght);
            if (this.score > this.highScore) {
                this.highScore = this.score;
            }
            if (RMSObjects.game.isLevelDone()) {
                this.startAnimation(true, 2);
                this.addScoreToTable();
            } else if (RMSObjects.game.isGameOver()) {
                this.startAnimation(true, 2);
                this.icount = -1;
                if (this.getTopScore() < this.score) {
                    this.icount = 0;
                }
            }
        }
        if (this.iStatus == 2 && this.icount >= 0) {
            ++this.icount;
            this.icount %= 10;
        }
        if (this.iStatus == 3) {
            this._bNeedRepaint = false;
            this.textMove();
        }
        this.animationController();
        this.animationComponentsUpdate();
        this.mainCanvas.repaint();
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == 4 ? this._iSequenceHide : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        if (this.iStatus != -1) {
            for (int i = 0; i < this._animationSequence[this.iStatus].length; ++i) {
                if (i >= this._animationSequence[this.iStatus].length || this._animationSequence[this.iStatus][i] == -1 || this._animationComponents[this._animationSequence[this.iStatus][i]] == null || this._animationComponents[this._animationSequence[this.iStatus][i]].isComponentAnimated()) continue;
                this._animationComponents[this._animationSequence[this.iStatus][i]].update();
                this.mainCanvas.repaint();
                _return = true;
            }
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                if (this._iNextMode == 9) {
                    this.startMenuScreen();
                }
                if (this._iNextMode == 9) {
                    this.startSelectLevel();
                }
                this._iSequence = this._iSequenceShow;
                this.iStatus = this._iNextMode;
                this._bChangeSequence = true;
                this.selectedButton = -1;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startMenuScreen() {
        ScreenMenu sg = new ScreenMenu(this.mainCanvas, 0);
        if (this.mainCanvas.getSoundManager().IsSoundOn()) {
            this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        }
        this.mainCanvas.changeLastActiveScreen(sg);
    }

    private void startSelectLevel() {
        if (!this._bBonusPack) {
            this.mainCanvas.changeLastActiveScreen(new ScreenSelectLevel(this.mainCanvas, 0));
        } else {
            this.mainCanvas.changeLastActiveScreen(new ScreenSelectBonusLevel(this.mainCanvas, 0));
        }
        this.mainCanvas.getSoundManager().Stop();
        if (this.mainCanvas.getSoundManager().IsSoundOn()) {
            this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        }
    }

    private void reset() {
        this.score = 0;
        this.stars = "";
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this.iStatus) {
            case 0: {
                this.paintGame(g);
                break;
            }
            case 1: {
                this.paintGameMenuScreen(g);
                break;
            }
            case 3: {
                this.paintInstructionsScreen(g);
                break;
            }
            case 7: {
                this.paintLastMessageScreen(g);
                break;
            }
            case 8: {
                this.paintRealyQuitScreen(g);
                break;
            }
            case 6: {
                this.paintRestartScreen(g);
                break;
            }
            case 2: {
                this.paintResultScreen(g);
                break;
            }
            case 5: {
                this.paintLevelGoalScreen(g);
                break;
            }
            case 4: {
                this.paintTutorialScreen(g);
            }
        }
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        if (this.iStatus == 1) {
            g.drawImage(this.imgBG, 0, 0, 20);
        } else {
            g.drawImage(this.imgBG, 0, 0, 20);
        }
    }

    private void paintGame(Graphics g) {
        RMSObjects.game.paint(g);
        this.paintGameProgressBar(g);
    }

    private void paintGameMenuScreen(Graphics g) {
        this.paintLogo(g);
        this.paintDialog(g);
    }

    private void paintInstructionsScreen(Graphics g) {
        this.paintDialogByParam(g, this.instrDialogRows, this.instrDialogColumns, this.rectInstrDialog);
        this.paintInstructionsTxt(g);
        this.paintArrows(g);
    }

    private void paintLastMessageScreen(Graphics g) {
        this.paintDialogByParam(g, this.exitDialogRows, this.exitDialogColumns, this.rectExitDialog);
        this.paintLastMessageTxt(g);
    }

    private void paintRealyQuitScreen(Graphics g) {
        this.paintDialogByParam(g, this.exitDialogRows, this.exitDialogColumns, this.rectExitDialog);
        this.paintRealyQuitMessageTxt(g);
    }

    private void paintRestartScreen(Graphics g) {
        this.paintDialogByParam(g, this.exitDialogRows, this.exitDialogColumns, this.rectExitDialog);
        this.paintRestartTxt(g);
    }

    private void paintResultScreen(Graphics g) {
        g.drawImage(this.imgResult, this.rectResultDialog.getCenterX(), this.rectResultDialog.getCenterY(), 3);
        this.paintResultTxt(g);
    }

    private void paintLevelGoalScreen(Graphics g) {
        g.drawImage(this.imgResult, this.rectStartDialog.getCenterX(), this.rectStartDialog.getCenterY(), 3);
        this.paintLevelGoalTxt(g);
    }

    private void paintTutorialScreen(Graphics g) {
        g.drawImage(this.imgResult, this.rectStartDialog.getCenterX(), this.rectStartDialog.getCenterY(), 3);
        this.paintTutorialTxt(g);
    }

    private void paintLogo(Graphics g) {
        g.drawImage(this.imgGameLogo, this.rectLogo.x, this.rectLogo.y, 17);
    }

    private void paintDialog(Graphics g) {
        this.paintButton(g, 5, this._iSelectedCompId == 5);
        this.paintButton(g, 1, this._iSelectedCompId == 1);
        this.paintButton(g, 3, this._iSelectedCompId == 3);
        this.paintButton(g, 6, this._iSelectedCompId == 6);
    }

    private void paintButton(Graphics g, int _iDx, boolean _bSelected) {
        this.sprButton.setFrame(0);
        switch (_iDx) {
            case 5: {
                if (this.selectedButton == 5) {
                    this.sprButton.setFrame(1);
                }
                this.sprButton.setPosition(this._rectItems[_iDx].x, this._rectItems[_iDx].y);
                this.sprButton.paint(g);
                this.sprIcons.setFrame(Common.ICON_RESTART);
                this.sprIcons.setPosition(this._rectItems[_iDx].getCenterX() - (this.sprIcons.getWidth() >> 1), this._rectItems[_iDx].getCenterY() - (this.sprIcons.getHeight() >> 1));
                this.sprIcons.paint(g);
                break;
            }
            case 1: {
                if (this.selectedButton == 1) {
                    this.sprButton.setFrame(1);
                }
                this.sprButton.setPosition(this._rectItems[_iDx].x, this._rectItems[_iDx].y);
                this.sprButton.paint(g);
                this.sprIcons.setFrame(Common.ICON_INSTR);
                this.sprIcons.setPosition(this._rectItems[_iDx].getCenterX() - (this.sprIcons.getWidth() >> 1), this._rectItems[_iDx].getCenterY() - (this.sprIcons.getHeight() >> 1));
                this.sprIcons.paint(g);
                break;
            }
            case 3: {
                if (this.selectedButton == 3) {
                    this.sprButton.setFrame(1);
                }
                this.sprButton.setPosition(this._rectItems[_iDx].x, this._rectItems[_iDx].y);
                this.sprButton.paint(g);
                this.sprIcons.setFrame(this.mainCanvas.getSoundManager().IsSoundOn() ? Common.ICON_SOUND_ON : Common.ICON_SOUND_OFF);
                this.sprIcons.setPosition(this._rectItems[_iDx].getCenterX() - (this.sprIcons.getWidth() >> 1), this._rectItems[_iDx].getCenterY() - (this.sprIcons.getHeight() >> 1));
                this.sprIcons.paint(g);
                break;
            }
            case 6: {
                if (this.selectedButton == 6) {
                    this.sprButton.setFrame(1);
                }
                this.sprButton.setPosition(this._rectItems[_iDx].x, this._rectItems[_iDx].y);
                this.sprButton.paint(g);
                this.sprIcons.setFrame(Common.ICON_LEVELS);
                this.sprIcons.setPosition(this._rectItems[_iDx].getCenterX() - (this.sprIcons.getWidth() >> 1), this._rectItems[_iDx].getCenterY() - (this.sprIcons.getHeight() >> 1));
                this.sprIcons.paint(g);
            }
        }
    }

    private void paint3x1Skin(int x, int y, int width, Sprite spr, Graphics g) {
        g.setClip(x + spr.getWidth(), y, width - (spr.getWidth() << 1), spr.getHeight());
        spr.setFrame(1);
        for (int i = 0; i < width / spr.getWidth(); ++i) {
            spr.setPosition(x + i * spr.getWidth(), y);
            spr.paint(g);
        }
        g.setClip(x, y, width, spr.getHeight());
        spr.setFrame(0);
        spr.setPosition(x, y);
        spr.paint(g);
        spr.setFrame(2);
        spr.setPosition(x + width - spr.getWidth(), y);
        spr.paint(g);
        g.setClip(0, 0, this._WIDTH, this._HEIGHT);
    }

    private void paintMoves(Graphics g, int yOffset) {
        String _s = Level._iMoves - MainCanvas.moveCounter + "";
        int yMove = this._animationComponents[5]._iDefaultY - this._animationComponents[5]._defaultRectangle.y;
        Rectangle _lect = new Rectangle(this.rectTopCenter.x, this.rectTopCenter.getCenterY() - yMove + yOffset - (this.rectTopCenter.height >> 2), this.rectTopCenter.width, this.fontBig.getHeight());
        this._ptMoves.prepareText(_s, _lect.width);
        this._ptMoves.drawText(g, _lect, 0, 3);
    }

    private void paintTime(Graphics g, int yOffset) {
        String _s = Integer.toString((int)Level._lTime - RMSObjects.game.getTimeInSec() < 0 ? 0 : (int)Level._lTime - RMSObjects.game.getTimeInSec()) + "";
        int yMove = this._animationComponents[5]._iDefaultY - this._animationComponents[5]._defaultRectangle.y;
        Rectangle _lect = new Rectangle(this.rectTopCenter.x, this.rectTopCenter.getCenterY() - yMove + yOffset - (this.rectTopCenter.height >> 2), this.rectTopCenter.width, this.fontBig.getHeight());
        this._ptMoves.prepareText(_s, _lect.width);
        this._ptMoves.drawText(g, _lect, 0, 3);
    }

    private void paintScore(Graphics g) {
        this.score = RMSObjects.game.getScore();
        String scoreNumbers = String.valueOf(this.score);
        int count = scoreNumbers.length() / 3;
        int x = MainCanvas.WIDTH - (this.sprButton.getWidth() >> 1);
        int y = this.sprTopPanelBg.getHeight() >> 2;
        this.fontBig.drawString(g, this.addWhitespace(scoreNumbers, count).toCharArray(), x, y, 10);
    }

    private void paintLevelGoal(int icon, int value, Graphics g) {
        int x = this.sprButton.getWidth() >> 1;
        int y = this.sprTopPanelBg.getHeight() >> 2;
        if (value < 0) {
            value = 0;
        }
        String text = "X" + value + " ";
        int width = MainCanvas.WIDTH >> 2;
        Rectangle rect = new Rectangle(x, y, width, this.fontBig.getHeight());
        this.sprTopBarIcons.setFrame(icon);
        this.sprTopBarIcons.setPosition(rect.x - (this.sprTopBarIcons.getWidth() >> 1), rect.getCenterY() - (this.sprTopBarIcons.getHeight() >> 1));
        this.sprTopBarIcons.paint(g);
        this.fontSmall.drawString(g, text.toCharArray(), x += this.sprTopBarIcons.getWidth() >> 1, rect.getCenterY(), 6);
    }

    private void paintStars(Graphics g) {
        Sprite sprBg = Resources.resSprs[35];
        Sprite sprFill = Resources.resSprs[36];
        Sprite sprStars = Resources.resSprs[9];
        int y = this.sprTopPanelBg.getHeight() - sprStars.getHeight() - (sprBg.getHeight() << 1);
        int offset = this._WIDTH >> 2;
        int barW = this._WIDTH - (offset << 1);
        int fillOffset = sprBg.getHeight() - sprFill.getHeight() >> 1;
        int scoreClip = (this.score << 7) / ((Level._iScoreHig << 7) / (barW - (fillOffset << 1)));
        if (scoreClip > barW - (fillOffset << 1)) {
            scoreClip = barW - (fillOffset << 1);
        }
        this.paint3x1Skin(offset, y, barW, sprBg, g);
        this.paint3x1Skin(offset + fillOffset, y + fillOffset, scoreClip, sprFill, g);
        int starY = y + (sprBg.getHeight() >> 1) - (sprStars.getHeight() >> 1) - (sprStars.getHeight() >> 2);
        int starX = offset + (Level._iScoreMin << 7) / ((Level._iScoreHig << 7) / barW) - (sprStars.getWidth() >> 1);
        sprStars.setFrame(this.score > Level._iScoreMin ? 2 : 3);
        sprStars.setPosition(starX, starY);
        sprStars.paint(g);
        starX = offset + (Level._iScoreMid << 7) / ((Level._iScoreHig << 7) / barW) - (sprStars.getWidth() >> 1);
        sprStars.setFrame(this.score > Level._iScoreMid ? 2 : 3);
        sprStars.setPosition(starX, starY);
        sprStars.paint(g);
        sprStars.setFrame(this.score > Level._iScoreHig ? 2 : 3);
        sprStars.setPosition(this._WIDTH - offset - (sprStars.getWidth() >> 1), starY);
        sprStars.paint(g);
    }

    private void paintGameProgressBar(Graphics g) {
        this.paintTopBarBg(g);
        this.paintTopCenter(g);
        this.paintScore(g);
        this.paintTopLeft(g);
        this.paintStars(g);
    }

    private void paintArrows(Graphics g) {
        if (this._ptInstructions.getTextHeight() < this.rectInstrGameText.height) {
            System.out.println("nothing");
        } else {
            if (this._bScrollUP) {
                this.sprArrow.setFrame(0);
                this.sprArrow.setTransform(5);
                this.sprArrow.setPosition(this._rectItems[7].getCenterX() - (this.sprArrow.getWidth() >> 1), this._rectItems[7].getBottom() - this.sprArrow.getHeight());
                this.sprArrow.paint(g);
            }
            if (this._bScrollDOWN) {
                this.sprArrow.setFrame(0);
                this.sprArrow.setTransform(6);
                this.sprArrow.setPosition(this._rectItems[8].getCenterX() - (this.sprArrow.getWidth() >> 1), this._rectItems[8].y);
                this.sprArrow.paint(g);
            }
        }
    }

    private void paintInstructionsTxt(Graphics g) {
        this._ptInstructions.drawText(g, this.rectInstrGameText, this._iTextOffsetY, 17);
    }

    private void paintTutorialTxt(Graphics g) {
        String _sTutotialTxt = "";
        if (MainCanvas.controlsTut == 0 && this.level == 0) {
            _sTutotialTxt = Resources.resTexts[0].getHashedString(30);
        } else {
            switch (this._iGameMode) {
                case 0: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(31);
                    break;
                }
                case 1: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(35);
                    break;
                }
                case 2: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(33);
                    break;
                }
                case 3: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(34);
                    break;
                }
                case 5: {
                    _sTutotialTxt = Resources.resTexts[0].getHashedString(32);
                }
            }
        }
        boolean _bShitDevice = false;
        if (this._WIDTH == 176 && this._HEIGHT == 208) {
            _bShitDevice = true;
        }
        if (this._WIDTH == 176 && this._HEIGHT == 220) {
            _bShitDevice = true;
        }
        if (this._WIDTH == 208 && this._HEIGHT == 208) {
            _bShitDevice = true;
        }
        if (MainCanvas._bFranceLang) {
            _bShitDevice = true;
        }
        if (_bShitDevice) {
            this._ptGameTutorial.prepareText(_sTutotialTxt, this.rectStartGameText.width);
            Rectangle _rectTmp = new Rectangle(this.rectStartGameText.x, this.rectStartGameText.getCenterY() - (this._ptGameTutorial.getTextHeight() >> 1), this.rectStartGameText.width, this._ptGameTutorial.getTextHeight());
            this._ptGameTutorial.setLineHeightCorrection(-2);
            this._ptGameTutorial.drawText(g, _rectTmp, 0, 17);
        } else {
            this._ptGameTutorial.prepareText(_sTutotialTxt, this.rectStartGameText.width);
            Rectangle _rectTmp = new Rectangle(this.rectStartGameText.x, this.rectStartGameText.getCenterY() - (this._ptGameTutorial.getTextHeight() >> 1), this.rectStartGameText.width, this._ptGameTutorial.getTextHeight());
            this._ptGameTutorial.setLineHeightCorrection(-2);
            this._ptGameTutorial.drawText(g, _rectTmp, 0, 17);
        }
    }

    private void paintLevelGoalTxt(Graphics g) {
        String _sGoalsTxt = "";
        switch (this._iGameMode) {
            case 0: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(43) + " " + Level._iMoves + " " + Resources.resTexts[0].getHashedString(44) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 1: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level._lTime + " " + Resources.resTexts[0].getHashedString(46);
                break;
            }
            case 2: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(39) + " " + Level._iEscapeObjCount + " " + Resources.resTexts[0].getHashedString(40) + " " + Resources.resTexts[0].getHashedString(43) + " " + Level._iMoves + " " + Resources.resTexts[0].getHashedString(48) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 3: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(41) + " " + Level._iDownfallObjCount + " " + Resources.resTexts[0].getHashedString(42) + " " + Resources.resTexts[0].getHashedString(47) + " " + Level._iMoves + " " + Resources.resTexts[0].getHashedString(48) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 4: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(38) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level._lTime + " " + Resources.resTexts[0].getHashedString(46) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 5: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(38) + "\n" + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 6: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(39) + " " + Level._iEscapeObjCount + " " + Resources.resTexts[0].getHashedString(40) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level._lTime + " " + Resources.resTexts[0].getHashedString(46) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
                break;
            }
            case 7: {
                _sGoalsTxt = Resources.resTexts[0].getHashedString(43) + " " + Level._iMoves + " " + Resources.resTexts[0].getHashedString(44) + " " + Resources.resTexts[0].getHashedString(45) + " " + Level._lTime + " " + Resources.resTexts[0].getHashedString(46) + ". " + Resources.resTexts[0].getHashedString(36) + " " + Level._iScoreMin + " " + Resources.resTexts[0].getHashedString(37);
            }
        }
        this._ptGameTxts.prepareText(_sGoalsTxt, this.rectStartGameText.width);
        this._ptGameTxts2.prepareText(Resources.resTexts[0].getHashedString(8) + " " + (this.actualLevel + 1), this.rectStartGameText.width);
        this._ptGameTxts2.setLineHeightCorrection(-2);
        this._ptGameTxts2.drawText(g, this.rectStartTextUp, 0, 3);
        int x = this.rectStartGameText.getCenterX() - (this.sprGameMode.getWidth() >> 1);
        int y = this.rectStartGameText.getCenterY() - (this.sprGameMode.getHeight() >> 1);
        int yOffset = this.rectStartTextDown.getBottom() - this._ptGameTxts.getTextHeight();
        Rectangle rect = new Rectangle(this.rectStartTextDown);
        rect.y = yOffset;
        rect.height = this._ptGameTxts.getTextHeight();
        if (y + this.sprGameMode.getHeight() > rect.y) {
            y = rect.y - this.sprGameMode.getHeight();
        }
        switch (this._iGameMode) {
            case 0: {
                this.sprGameMode.setFrame(0);
                this.sprGameMode.setPosition(x, y);
                this.sprGameMode.paint(g);
                break;
            }
            case 1: {
                this.sprGameMode.setFrame(4);
                this.sprGameMode.setPosition(x, y);
                this.sprGameMode.paint(g);
                break;
            }
            case 2: {
                this.sprGameMode.setFrame(2);
                this.sprGameMode.setPosition(x, y);
                this.sprGameMode.paint(g);
                break;
            }
            case 3: {
                this.sprGameMode.setFrame(1);
                this.sprGameMode.setPosition(this._WIDTH - this.sprGameMode.getWidth() >> 1, y);
                this.sprGameMode.paint(g);
                break;
            }
            case 4: {
                this.sprGameMode.setFrame(4);
                this.sprGameMode.setPosition((this._WIDTH >> 1) - this.sprGameMode.getWidth() + this.sprGameMode.getWidth() / 5, y);
                this.sprGameMode.paint(g);
                this.sprGameMode.setFrame(3);
                this.sprGameMode.setPosition((this._WIDTH >> 1) - this.sprGameMode.getWidth() / 5, y);
                this.sprGameMode.paint(g);
                break;
            }
            case 5: {
                this.sprGameMode.setFrame(3);
                this.sprGameMode.setPosition(x, y);
                this.sprGameMode.paint(g);
                break;
            }
            case 6: {
                this.sprGameMode.setFrame(4);
                this.sprGameMode.setPosition((this._WIDTH >> 1) - this.sprGameMode.getWidth() + this.sprGameMode.getWidth() / 5, y);
                this.sprGameMode.paint(g);
                this.sprGameMode.setFrame(2);
                this.sprGameMode.setPosition((this._WIDTH >> 1) - this.sprGameMode.getWidth() / 5, y);
                this.sprGameMode.paint(g);
                break;
            }
            case 7: {
                this.sprGameMode.setFrame(4);
                this.sprGameMode.setPosition((this._WIDTH >> 1) - this.sprGameMode.getWidth() + this.sprGameMode.getWidth() / 5, y);
                this.sprGameMode.paint(g);
                this.sprGameMode.setFrame(0);
                this.sprGameMode.setPosition((this._WIDTH >> 1) - this.sprGameMode.getWidth() / 5, y);
                this.sprGameMode.paint(g);
            }
        }
        this._ptGameTxts.setLineHeightCorrection(-2);
        this._ptGameTxts.drawText(g, rect, 0, 17);
    }

    private void paintLastMessageTxt(Graphics g) {
        String _sLastLevelGameMessge = "";
        _sLastLevelGameMessge = !this._bBonusPack ? (MainCanvas.totalStars == 180 ? Resources.resTexts[0].getHashedString(73) + " " + Resources.resTexts[0].getHashedString(74) : Resources.resTexts[0].getHashedString(72)) : (MainCanvas.totalBonusStars == 60 ? Resources.resTexts[0].getHashedString(76) : Resources.resTexts[0].getHashedString(75));
        this._ptGameTxts.prepareText(_sLastLevelGameMessge, this.rectExitGameText.width);
        Rectangle _rectTmp = new Rectangle(this.rectExitGameText.x, this.rectExitGameText.getCenterY() - (this._ptGameTxts.getTextHeight() >> 1), this.rectExitGameText.width, this._ptGameTxts.getTextHeight());
        this._ptGameTxts.setLineHeightCorrection(-2);
        this._ptGameTxts.drawText(g, _rectTmp, 0, 17);
    }

    private void paintRealyQuitMessageTxt(Graphics g) {
        String _sQuitQuestion = Resources.resTexts[0].getHashedString(77);
        this._ptGameTxts.prepareText(_sQuitQuestion, this.rectExitGameText.width);
        int iLinesCount = this._ptGameTxts.getTextLines();
        int iY = this.rectExitGameText.getCenterY() - (this._ptGameTxts.getTextHeight() >> 1);
        if (iLinesCount >= 7) {
            iY -= this.fontSmall.getHeight() >> 1;
        } else if (iLinesCount >= 5) {
            iY -= this.fontSmall.getHeight() >> 2;
        } else if (iLinesCount >= 3) {
            iY -= this.fontSmall.getHeight() >> 3;
        }
        for (int i = 0; i < iLinesCount; ++i) {
            this.fontBig.drawString(g, this._ptGameTxts.getText(i).toCharArray(), this.rectExitGameText.getCenterX(), iY, 17);
            iY += this.fontBig.getHeight();
        }
    }

    private void paintRestartTxt(Graphics g) {
        String _sRestart = Resources.resTexts[0].getHashedString(78);
        this._ptGameTxts.prepareText(_sRestart, this.rectExitGameText.width);
        this._ptGameTxts.setLineHeightCorrection(-2);
        this._ptGameTxts.drawText(g, this.rectExitGameText, 0, 3);
    }

    private void paintResultTxt(Graphics g) {
        if (RMSObjects.game.isLevelDone()) {
            this.paintNewWin(g);
        } else if (RMSObjects.game.isGameOver()) {
            this.paintNewLose(g);
        }
    }

    private void paintWinTxt(Graphics g) {
        int _iTmpScore = RMSObjects.game.getScore();
        int iSpace = this.fontSmall.getHeight();
        this._ptGameTxts.prepareText(Resources.resTexts[0].getHashedString(56), this.rectResultGameText.width - iSpace * 2);
        String _sTmpFinal = Resources.resTexts[0].getHashedString(10) + ": " + (_iTmpScore - RMSObjects.game.getBombScore() - RMSObjects.game.getEscScore() - RMSObjects.game.getDownScore()) + "\n" + Resources.resTexts[0].getHashedString(57) + ": " + RMSObjects.game.getBombScore() + "\n" + (this._iGameMode == 2 ? Resources.resTexts[0].getHashedString(59) + ": " + RMSObjects.game.getEscScore() + "\n" : "") + (this._iGameMode == 3 ? Resources.resTexts[0].getHashedString(58) + ": " + RMSObjects.game.getDownScore() + "\n" : "");
        _sTmpFinal = MainCanvas.HEIGHT <= 220 || MainCanvas.HEIGHT == 307 ? _sTmpFinal + "TOTAL: " + _iTmpScore : _sTmpFinal + "TOTAL: " + _iTmpScore;
        this._ptGameTxts2.prepareText(_sTmpFinal, this.rectResultGameText.width - iSpace);
        boolean bEs = false;
        if (MainCanvas.HEIGHT < 640 && MainCanvas.HEIGHT < 480 && Resources.getLangCode().compareTo("es") == 0) {
            bEs = true;
        }
        int iHeight = this._ptGameTxts.getTextHeight() + (this.sprResultStarsActive.getHeight() >> 1) + this._ptGameTxts2.getTextHeight();
        int iSpaceY = this.fontSmall.getHeight();
        if (bEs) {
            iSpaceY -= this.fontSmall.getHeight() >> 2;
        }
        int iTotalHeight = iHeight + (iSpaceY << 1);
        int iY = this.rectResultGameText.getCenterY() - (iTotalHeight >> 1);
        int y = this.rectDialogInstr.y + (this.fontSmall.getHeight() >> 2);
        if (MainCanvas.HEIGHT < 800) {
            iY = (y -= this.fontSmall.getHeight() >> 2) + (this.fontSmall.getHeight() << 1);
            if (MainCanvas.HEIGHT <= 640) {
                iY = y + this.fontSmall.getHeight();
            }
        } else {
            iY += this.fontBig.getHeight() >> 1;
        }
        this.fontSmall.drawString(g, Resources.resTexts[0].getHashedString(9).toCharArray(), this.rectResultGameText.getCenterX(), y, 17);
        this.fontBig.drawString(g, (Resources.resTexts[0].getHashedString(8) + " " + (this.actualLevel + 1)).toCharArray(), this.rectResultGameText.getCenterX(), iY, 17);
        iY += this.fontSmall.getHeight();
        iY += iSpaceY + this.sprResultStarsActive.getHeight();
        int xStar = this.rectResultDialog.getCenterX() - (this.sprResultStarsActive.getWidth() >> 1) - this.sprResultStarsActive.getWidth();
        int yStar = this.rectResultDialog.y + (this.sprResultStarsActive.getHeight() >> 2);
        int starWidth = this.sprResultStarsActive.getWidth();
        if (_iTmpScore >= Level._iScoreHig) {
            this.sprResultStarsActive.setFrame(0);
            this.sprResultStarsActive.setPosition(xStar, yStar);
            this.sprResultStarsActive.paint(g);
            this.sprResultStarsActive.setFrame(1);
            this.sprResultStarsActive.setPosition(xStar += starWidth, yStar);
            this.sprResultStarsActive.paint(g);
            this.sprResultStarsActive.setFrame(2);
            this.sprResultStarsActive.setPosition(xStar += starWidth, yStar);
            this.sprResultStarsActive.paint(g);
        } else if (_iTmpScore >= Level._iScoreMid) {
            this.sprResultStarsActive.setFrame(0);
            this.sprResultStarsActive.setPosition(xStar, yStar);
            this.sprResultStarsActive.paint(g);
            this.sprResultStarsActive.setFrame(1);
            this.sprResultStarsActive.setPosition(xStar += starWidth, yStar);
            this.sprResultStarsActive.paint(g);
            this.sprResultStarsInactive.setFrame(2);
            this.sprResultStarsInactive.setPosition(xStar += starWidth, yStar);
            this.sprResultStarsInactive.paint(g);
        } else if (_iTmpScore >= Level._iScoreMin) {
            this.sprResultStarsActive.setFrame(0);
            this.sprResultStarsActive.setPosition(xStar, yStar);
            this.sprResultStarsActive.paint(g);
            this.sprResultStarsInactive.setFrame(1);
            this.sprResultStarsInactive.setPosition(xStar += starWidth, yStar);
            this.sprResultStarsInactive.paint(g);
            this.sprResultStarsInactive.setFrame(2);
            this.sprResultStarsInactive.setPosition(xStar += starWidth, yStar);
            this.sprResultStarsInactive.paint(g);
        }
        this.sprRibbon.setFrame(0);
        this.sprRibbon.setPosition(this.rectResultDialog.getCenterX() - (this.sprRibbon.getWidth() >> 1), this.rectResultDialog.y + this.sprResultStarsActive.getHeight() + (this.sprResultStarsActive.getHeight() >> 1));
        this.sprRibbon.paint(g);
        iY += this.sprResultStarsActive.getHeight() >> 1;
        iY += iSpaceY;
        if (MainCanvas.HEIGHT < 800) {
            iY += this.fontBig.getHeight();
        }
        for (int i = 0; i < this._ptGameTxts2.getTextLines(); ++i) {
            this.fontSmall.drawString(g, this._ptGameTxts2.getText(i).toCharArray(), this.rectResultGameText.getCenterX(), iY, 17);
            iY += this.fontSmall.getHeight();
        }
    }

    private void paintLoseTxt(Graphics g) {
        int _iTmpScore = RMSObjects.game.getScore();
        int iSpace = this.fontSmall.getHeight();
        this._ptGameTxts.prepareText(Resources.resTexts[0].getHashedString(60), this.rectResultGameText.width - iSpace);
        String _sTmpFinal = "";
        switch (RMSObjects.game.getLoseMode()) {
            case 1: {
                _sTmpFinal = _sTmpFinal + Resources.resTexts[0].getHashedString(63);
                break;
            }
            case 3: {
                _sTmpFinal = _sTmpFinal + Resources.resTexts[0].getHashedString(64);
                break;
            }
            case 4: {
                _sTmpFinal = _sTmpFinal + Resources.resTexts[0].getHashedString(62);
                break;
            }
            case 2: {
                _sTmpFinal = _sTmpFinal + Resources.resTexts[0].getHashedString(61);
                break;
            }
            default: {
                _sTmpFinal = _sTmpFinal + Resources.resTexts[0].getHashedString(61);
            }
        }
        _sTmpFinal = _sTmpFinal + "\n" + Resources.resTexts[0].getHashedString(52);
        _sTmpFinal = _sTmpFinal + "\n\nTOTAL: " + _iTmpScore;
        this._ptGameTxts2.prepareText(_sTmpFinal, this.rectResultGameText.width);
        int iHeight = this._ptGameTxts.getTextHeight() + this._ptGameTxts2.getTextHeight();
        int iSpaceY = this.fontSmall.getHeight() << 1;
        int iTotalHeight = iHeight + iSpaceY;
        int iY = this.rectResultGameText.getCenterY() - (iTotalHeight >> 1);
        int y = this.rectDialogInstr.y + (this.fontSmall.getHeight() >> 2);
        if (MainCanvas.HEIGHT < 800) {
            y -= this.fontSmall.getHeight() >> 2;
        }
        this.fontSmall.drawString(g, Resources.resTexts[0].getHashedString(79).toCharArray(), this.rectResultGameText.getCenterX(), y, 17);
        this.fontSmall.drawString(g, (Resources.resTexts[0].getHashedString(8) + " " + (this.actualLevel + 1)).toCharArray(), this.rectResultGameText.getCenterX(), iY += this.fontSmall.getHeight() >> 1, 17);
        iY += iSpaceY;
        for (int i = 0; i < this._ptGameTxts2.getTextLines(); ++i) {
            this.fontSmall.drawString(g, this._ptGameTxts2.getText(i).toCharArray(), this.rectResultGameText.getCenterX(), iY, 17);
            iY += this.fontSmall.getHeight();
        }
        int yStar = this.rectResultDialog.y + (this.sprResultStarsActive.getHeight() >> 2);
        this.paintResultStars(g, yStar);
        this.paintRibbon(g, yStar += this.sprResultStarsActive.getHeight() + (this.sprResultStarsActive.getHeight() >> 1), false);
    }

    private void paintFK(Graphics g) {
        if (this.iStatus == 0) {
            this.paintRightFK(Common.ICON_PAUSE, 0, g, this.sprIcons);
        } else if (this.iStatus == 2) {
            if (RMSObjects.game.isGameOver()) {
                this.paintLeftFK(Common.ICON_LEVELS, 0, g, this.sprIcons);
                this.paintMiddleBtn(Common.ICON_RESTART, g, this.sprIcons);
            } else if (RMSObjects.game.isLevelDone()) {
                this.paintLeftFK(Common.ICON_LEVELS, 0, g, this.sprIcons);
                if (this.actualLevel < 79) {
                    this.paintMiddleBtn(Common.ICON_PLAY, g, this.sprIcons);
                }
                this.paintRightFK(Common.ICON_RESTART, 0, g, this.sprIcons);
            }
        } else if (this.iStatus == 3) {
            this.paintRightFK(Common.ICON_BACK, 0, g, this.sprIcons);
        } else if (this.iStatus == 1) {
            this.paintRightFK(Common.ICON_BACK, 0, g, this.sprIcons);
        } else if (this.iStatus == 4) {
            this.paintLeftFK(Common.ICON_YES, 0, g, this.sprIcons);
        } else if (this.iStatus == 5) {
            this.paintLeftFK(Common.ICON_YES, 0, g, this.sprIcons);
        } else if (this.iStatus == 7) {
            this.paintRightFK(Common.ICON_BACK, 0, g, this.sprIcons);
        } else if (this.iStatus == 6) {
            this.paintLeftFK(Common.ICON_YES, 0, g, this.sprIcons);
            this.paintRightFK(Common.ICON_NO, 0, g, this.sprIcons);
        } else if (this.iStatus == 8) {
            this.paintLeftFK(Common.ICON_YES, 0, g, this.sprIcons);
            this.paintRightFK(Common.ICON_NO, 0, g, this.sprIcons);
        }
    }

    private void paintLeftFK(int frame, int transform, Graphics g, Sprite sprite) {
        if (this.iStatus == 2 && (RMSObjects.game.isGameOver() || RMSObjects.game.isLevelDone())) {
            this.sprButton.setFrame(0);
            if (this.selectedButton == 0) {
                this.sprButton.setFrame(1);
            }
            int x = this._rectItems[0].getRight() - this.sprButton.getWidth();
            int y = this._rectItems[9].getCenterY() - (this.sprButton.getHeight() >> 1);
            this.sprButton.setPosition(x, y);
            this.sprButton.paint(g);
            sprite.setFrame(frame);
            sprite.setTransform(transform);
            sprite.setPosition(this._rectItems[0].getRight() - (this.sprButton.getWidth() >> 1) - (sprite.getWidth() >> 1), this.rectDialogInstr.getBottom() + (this.sprButton.getHeight() >> 2) - (sprite.getHeight() >> 1));
            sprite.paint(g);
            return;
        }
        if (this.iStatus == 8 || this.iStatus == 5 || this.iStatus == 4 || this.iStatus == 6) {
            this.sprButton.setFrame(0);
            if (this.selectedButton == 0) {
                this.sprButton.setFrame(1);
            }
            int x = this._rectItems[0].getCenterX() - (this.sprButton.getWidth() >> 1);
            int y = this._rectItems[0].getCenterY() - (this.sprButton.getHeight() >> 1) - (this.sprButton.getHeight() >> 1);
            this.sprButton.setPosition(x, y);
            this.sprButton.paint(g);
        } else {
            this.sprButton.setFrame(0);
            if (this.selectedButton == 0) {
                this.sprButton.setFrame(1);
            }
            int x = this._rectItems[0].getCenterX() - (this.sprButton.getWidth() >> 1);
            int y = this._rectItems[0].getCenterY() - (this.sprButton.getHeight() >> 1) - (this.sprButton.getHeight() >> 1);
            this.sprButton.setPosition(x, y);
            this.sprButton.paint(g);
        }
        sprite.setFrame(frame);
        sprite.setTransform(transform);
        sprite.setPosition(this._rectItems[0].getCenterX() - (sprite.getWidth() >> 1), this._rectItems[0].getCenterY() - (sprite.getHeight() >> 1) - (this.sprButton.getHeight() >> 1));
        sprite.paint(g);
    }

    private void paintRightFK(int frame, int transform, Graphics g, Sprite sprite) {
        if (this.iStatus == 2 && (RMSObjects.game.isGameOver() || RMSObjects.game.isLevelDone())) {
            this.sprButton.setFrame(0);
            if (this.selectedButton == 4) {
                this.sprButton.setFrame(1);
            }
            int x = this._rectItems[4].x;
            int y = this._rectItems[9].getCenterY() - (this.sprButton.getHeight() >> 1);
            this.sprButton.setPosition(x, y);
            this.sprButton.paint(g);
            sprite.setFrame(frame);
            sprite.setTransform(transform);
            sprite.setPosition(this._rectItems[4].x + (this.sprButton.getWidth() >> 1) - (sprite.getWidth() >> 1), this.rectDialogInstr.getBottom() + (this.sprButton.getHeight() >> 2) - (sprite.getHeight() >> 1));
            sprite.paint(g);
            return;
        }
        if (this.iStatus == 8 || this.iStatus == 6) {
            this.sprButton.setFrame(0);
            if (this.selectedButton == 4) {
                this.sprButton.setFrame(1);
            }
        } else {
            this.sprButton.setFrame(0);
            if (this.selectedButton == 4) {
                this.sprButton.setFrame(1);
            }
            int x = this._rectItems[4].getCenterX() - (this.sprButton.getWidth() >> 1) + (this.sprButton.getWidth() >> 1);
            int y = this._rectItems[4].getCenterY() - (this.sprButton.getHeight() >> 1) - (this.sprButton.getHeight() >> 1);
            this.sprButton.setPosition(x, y);
            this.sprButton.paint(g);
            sprite.setFrame(frame);
            sprite.setTransform(transform);
            sprite.setPosition(this._rectItems[4].getCenterX() - (sprite.getWidth() >> 1) + (this.sprButton.getHeight() >> 1), this._rectItems[4].getCenterY() - (sprite.getHeight() >> 1) - (this.sprButton.getHeight() >> 1));
            sprite.paint(g);
            return;
        }
        int x = this._rectItems[4].getCenterX() - (this.sprButton.getWidth() >> 1);
        int y = this._rectItems[4].getCenterY() - (this.sprButton.getHeight() >> 1) - (this.sprButton.getHeight() >> 1);
        this.sprButton.setPosition(x, y);
        this.sprButton.paint(g);
        sprite.setFrame(frame);
        sprite.setTransform(transform);
        sprite.setPosition(this._rectItems[4].getCenterX() - (sprite.getWidth() >> 1), this._rectItems[4].getCenterY() - (sprite.getHeight() >> 1) - (this.sprButton.getHeight() >> 1));
        sprite.paint(g);
    }

    private int getTopScore() {
        if (!this._bBonusPack) {
            Vector scores = RMSObjects.localScores.getScoresForGame(0);
            int scoresCount = 0;
            if (scores != null) {
                scoresCount = scores.size();
            }
            PowV2ScoreItem scoreItem = null;
            if (scoresCount > 0) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(0);
                return scoreItem.scoreValue;
            }
            return 0;
        }
        Vector scores = RMSObjects.localScoresBonus.getScoresForGame(0);
        int scoresCount = 0;
        if (scores != null) {
            scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            return scoreItem.scoreValue;
        }
        return 0;
    }

    public void keyPressed(int keyCode) {
        if (this.iStatus == 1 && (Keys.isActionPressed(5) || Keys.isKeyPressed(53)) && this._iSelectedCompId == 3) {
            this.selectedButton = 3;
        }
    }

    public void keyReleased(int keyCode) {
        switch (this.iStatus) {
            case 5: {
                if (Keys.isActionGeneratedByKey(1, keyCode) || Keys.isActionGeneratedByKey(2, keyCode)) {
                    return;
                }
                if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.selectedButton = 0;
                this.startAnimation(true, 0);
                break;
            }
            case 8: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.selectedButton = 4;
                    this.startAnimation(true, 1);
                }
                if (!Keys.isFKLeftCode(keyCode)) break;
                this.selectedButton = 0;
                this.startAnimation(true, 9);
                break;
            }
            case 4: {
                if (Keys.isActionGeneratedByKey(1, keyCode) || Keys.isActionGeneratedByKey(2, keyCode)) {
                    return;
                }
                if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.selectedButton = 0;
                if (MainCanvas.controlsTut == 0) {
                    this.startAnimation(true, 5);
                    ++MainCanvas.controlsTut;
                    break;
                }
                if (MainCanvas.controlsTut != 1) break;
                this.startAnimation(true, 5);
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.selectedButton = 4;
                    this.setGameMenuStatus();
                    break;
                }
                if (Keys.isFKLeftCode(keyCode)) {
                    RMSObjects.game.showHint();
                    break;
                }
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    RMSObjects.game.moveLeft();
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    RMSObjects.game.moveRight();
                    break;
                }
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    RMSObjects.game.moveUp();
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    RMSObjects.game.moveDown();
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                Game.pressed = true;
                RMSObjects.game.DragOrDrop();
                break;
            }
            case 1: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                this.keyReleasedMenuGame(keyCode);
                if (this._iSelectedCompId != 5 && this._iSelectedCompId != 1 && this._iSelectedCompId != 6) break;
                this.checkButton2 = this._iSelectedCompId;
                this.selectedButton = this._iSelectedCompId;
                break;
            }
            case 2: {
                System.out.println("som tu 222");
                this.keyReleasedResult(keyCode);
                break;
            }
            case 3: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                if (Keys.isFKRightCode(keyCode)) {
                    this.selectedButton = 4;
                    this.startAnimation(true, 1);
                    this._iTextOffsetY = 0;
                    this._bScrollUP = false;
                    this._bScrollDOWN = true;
                    this._iSelectedCompId = 1;
                    break;
                }
                if (keyCode == 50) {
                    this.dragUp();
                    break;
                }
                if (keyCode != 56) break;
                this.dragDown();
                break;
            }
            case 6: {
                if (Keys.isFKLeftCode(keyCode)) {
                    this.selectedButton = 0;
                    if (!this._bBonusPack) {
                        Level.getLevel(this.actualLevel);
                    } else {
                        Level.getBonusLevel(this.actualLevel);
                    }
                    MainCanvas.moveCounter = 0;
                    if (this._iGameMode == 4 || this._iGameMode == 5) {
                        RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                    } else {
                        RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                    }
                    this.startAnimation(true, 0);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.selectedButton = 4;
                this.startAnimation(true, 1);
            }
        }
    }

    private void setGameMenuStatus() {
        int rmsConnectId = this.getRMSConnectIdByGameType(0);
        if (!RMSObjects.rmsConnects[rmsConnectId].isExist()) {
            RMSObjects.rmsConnects[rmsConnectId].create();
        }
        RMSObjects.rmsConnects[rmsConnectId].save();
        this.startAnimation(true, 1);
        this._iSelectedCompId = 5;
        this._iSelectedCompId = 5;
    }

    private void keyReleasedMenuGame(int keyCode) {
        switch (this._iSelectedCompId) {
            case 5: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    this._iSelectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    this._iSelectedCompId = 1;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 3;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.selectedButton = 5;
                this.startAnimation(true, 6);
                this.mainCanvas.repaint();
                break;
            }
            case 3: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    this._iSelectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    this._iSelectedCompId = 1;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.selectedButton = -1;
                if (this.mainCanvas.getSoundManager().IsSoundOn()) {
                    this.mainCanvas.getSoundManager().SetSoundOn(false);
                    Settings.musicOn = false;
                    this.mainCanvas.getSoundManager().Stop();
                    break;
                }
                this.mainCanvas.getSoundManager().SetSoundOn(true);
                Settings.musicOn = true;
                this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
                break;
            }
            case 1: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    this._iSelectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    this._iSelectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 3;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.selectedButton = 1;
                this.startAnimation(true, 3);
                break;
            }
            case 6: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    this._iSelectedCompId = 1;
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    this._iSelectedCompId = 1;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.selectedButton = 6;
                this.startAnimation(true, 8);
            }
        }
        if (Keys.isFKRightCode(keyCode)) {
            this.selectedButton = 4;
            this.startAnimation(true, 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void keyReleasedResult(int keyCode) {
        block56: {
            block58: {
                block54: {
                    block57: {
                        block55: {
                            if (!RMSObjects.game.isGameOver()) break block54;
                            if (!Keys.isFKRightCode(keyCode)) break block55;
                            System.out.println("game over right button");
                            break block56;
                        }
                        if (!Keys.isFKLeftCode(keyCode)) break block57;
                        System.out.println("game over left button");
                        this.stars = "";
                        this.startAnimation(true, 5);
                        if (!this._bBonusPack) {
                            if (MainCanvas.slcLvl < 59) {
                                if (MainCanvas.counterX < 3) {
                                    ++MainCanvas.counterX;
                                    ++MainCanvas.slcLvl;
                                } else {
                                    if (MainCanvas.slcLvl == 19) {
                                        ++MainCanvas.slcPack;
                                        MainCanvas.counterY = 0;
                                    } else if (MainCanvas.slcLvl == 39) {
                                        ++MainCanvas.slcPack;
                                        MainCanvas.counterY = 0;
                                    } else {
                                        ++MainCanvas.counterY;
                                    }
                                    MainCanvas.counterX = 0;
                                    ++MainCanvas.slcLvl;
                                }
                            }
                        } else if (MainCanvas.slcLvl < 19) {
                            if (MainCanvas.counterX < 3) {
                                ++MainCanvas.counterX;
                                ++MainCanvas.slcLvl;
                            } else {
                                MainCanvas.counterX = 0;
                                ++MainCanvas.counterY;
                                ++MainCanvas.slcLvl;
                            }
                        }
                        if (this.actualLevel != 19) ** GOTO lbl-1000
                        if (MainCanvas.slcPack == 0) {
                            ++MainCanvas.slcPack;
                            MainCanvas.counterY = 0;
                        } else if (this.actualLevel == 39) {
                            if (MainCanvas.slcPack == 1) {
                                ++MainCanvas.slcPack;
                                MainCanvas.counterY = 0;
                            }
                        }
                        this.startAnimation(true, 9);
                        break block56;
                    }
                    if (Keys.isActionGeneratedByKey(5, keyCode)) {
                        System.out.println("game over restart");
                        if (!this._bBonusPack) {
                            Level.getLevel(this.actualLevel);
                        } else {
                            Level.getBonusLevel(this.actualLevel);
                        }
                        MainCanvas.moveCounter = 0;
                        if (this._iGameMode == 4 || this._iGameMode == 5) {
                            this.startAnimation(true, 5);
                            RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                        } else {
                            this.startAnimation(true, 5);
                            if (!this._bBonusPack) {
                                Level.getLevel(this.actualLevel);
                            } else {
                                Level.getBonusLevel(this.actualLevel);
                            }
                            RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                        }
                        this.mainCanvas.getSoundManager().Stop();
                        if (this.mainCanvas.getSoundManager().IsSoundOn()) {
                            this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
                        }
                        this._iSelectedCompId = 0;
                    }
                    break block56;
                }
                if (!RMSObjects.game.isLevelDone()) break block56;
                if (!Keys.isFKLeftCode(keyCode)) break block58;
                System.out.println("successfull dat spat");
                this.startAnimation(true, 5);
                if (!this._bBonusPack) {
                    if (MainCanvas.slcLvl < 59) {
                        if (MainCanvas.counterX < 3) {
                            ++MainCanvas.counterX;
                            ++MainCanvas.slcLvl;
                        } else {
                            if (MainCanvas.slcLvl == 19) {
                                ++MainCanvas.slcPack;
                                MainCanvas.counterY = 0;
                            } else if (MainCanvas.slcLvl == 39) {
                                ++MainCanvas.slcPack;
                                MainCanvas.counterY = 0;
                            } else {
                                ++MainCanvas.counterY;
                            }
                            MainCanvas.counterX = 0;
                            ++MainCanvas.slcLvl;
                        }
                    }
                } else if (MainCanvas.slcLvl < 19) {
                    if (MainCanvas.counterX < 3) {
                        ++MainCanvas.counterX;
                        ++MainCanvas.slcLvl;
                    } else {
                        MainCanvas.counterX = 0;
                        ++MainCanvas.counterY;
                        ++MainCanvas.slcLvl;
                    }
                }
                if (this.actualLevel != 19) ** GOTO lbl-1000
                if (MainCanvas.slcPack == 0) {
                    ++MainCanvas.slcPack;
                    MainCanvas.counterY = 0;
                } else if (this.actualLevel == 39) {
                    if (MainCanvas.slcPack == 1) {
                        ++MainCanvas.slcPack;
                        MainCanvas.counterY = 0;
                    }
                }
                this.startAnimation(true, 9);
                break block56;
            }
            if (Keys.isFKRightCode(keyCode)) {
                System.out.println("successfull dat restart");
                this.stars = "";
                if (!this._bBonusPack) {
                    Level.getLevel(this.actualLevel);
                } else {
                    Level.getBonusLevel(this.actualLevel);
                }
                MainCanvas.moveCounter = 0;
                if (this._iGameMode == 4 || this._iGameMode == 5) {
                    this.startAnimation(true, 5);
                    RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                } else {
                    this.startAnimation(true, 5);
                    if (!this._bBonusPack) {
                        Level.getLevel(this.actualLevel);
                    } else {
                        Level.getBonusLevel(this.actualLevel);
                    }
                    RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                }
                this.mainCanvas.getSoundManager().Stop();
                if (this.mainCanvas.getSoundManager().IsSoundOn()) {
                    this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
                }
                this._iSelectedCompId = 0;
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                System.out.println("successfull dat dalsi level");
                if (this.actualLevel < 79) {
                    ++this.actualLevel;
                    MainCanvas.slcLvl = this.actualLevel;
                    Level.getLevel(this.actualLevel);
                    this._iGameMode = Level._iGameMode;
                    MainCanvas.moveCounter = 0;
                    this.lvl = this._iGameMode == Level.TYPE_BLOCKER || this._iGameMode == Level.TYPE_MIXED_TIME_AND_BLOCKS ? Level._iBlockScheme : 1;
                    this.startAnimation(true, 5);
                    RMSObjects.game.restartGame(this.mainCanvas, this._iGameMode, this.actualLevel, this.lvl, Level._iGameColors);
                    this.mainCanvas.getSoundManager().Stop();
                    if (this.mainCanvas.getSoundManager().IsSoundOn()) {
                        this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
                    }
                }
                this._iSelectedCompId = 0;
            } else if (Keys.isKeyPressed(53)) {
                System.out.println("dalsi level");
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this._iSelectedCompId == 5 || this._iSelectedCompId == 1 || this._iSelectedCompId == 6) {
            this.checkButton = this._iSelectedCompId;
        }
        if (this.iStatus == 0 && this.rectGameArea.contains(x, y)) {
            Game.bhint = false;
            RMSObjects.game.pointerPressed(x, y);
            System.out.println("return");
            return;
        }
        if (this.iStatus == 3) {
            if (this.rectInstrGameText.contains(x, y)) {
                MainCanvas.lastPointerPressedY = y;
                this.bDragInstructions = true;
                return;
            }
            if (this._rectItems[7].contains(x, y)) {
                this._iSelectedCompId = 7;
                Keys.keyPressed(50);
                return;
            }
            if (this._rectItems[8].contains(x, y)) {
                this._iSelectedCompId = 8;
                Keys.keyPressed(56);
                return;
            }
        }
        block6: for (int i = 0; i < this._rectItems.length; ++i) {
            if (!this.existComponentInState(i, this.iStatus) || !this._rectItems[i].contains(x, y)) continue;
            this.selectedButton = i;
            this._iSelectedCompId = i;
            if (this._iSelectedCompId == 5 || this._iSelectedCompId == 1 || this._iSelectedCompId == 6) {
                this.checkButton2 = this._iSelectedCompId;
            }
            switch (this._iSelectedCompId) {
                case 0: {
                    if (this.iStatus != 1) {
                        Keys.keyPressed(-6);
                        continue block6;
                    }
                    Keys.keyPressed(-6);
                    continue block6;
                }
                case 4: {
                    if (this.iStatus == 3) {
                        this.startAnimation(true, 1);
                        this._iTextOffsetY = 0;
                        this._bScrollUP = false;
                        this._bScrollDOWN = true;
                        this._iSelectedCompId = 1;
                        this.mainCanvas.repaint();
                        continue block6;
                    }
                    Keys.keyPressed(-7);
                    continue block6;
                }
                case 3: {
                    if (this.mainCanvas.getSoundManager().IsSoundOn()) {
                        this.mainCanvas.getSoundManager().SetSoundOn(false);
                        this.mainCanvas.getSoundManager().Stop();
                    } else {
                        this.mainCanvas.getSoundManager().SetSoundOn(true);
                        this.mainCanvas.getSoundManager().Play(Sounds.SOUND_GAME, -1);
                    }
                    if (this._iSelectedCompId == 3) {
                        this._iSelectedCompId = this.checkButton2;
                    }
                    this.mainCanvas.repaint();
                    continue block6;
                }
                case 9: {
                    System.out.println("next level spravit");
                    if (this.iStatus != 2) continue block6;
                    Keys.keyPressed(53);
                    continue block6;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                }
            }
        }
    }

    private boolean existComponentInState(int i, int _iStatus) {
        if (_iStatus == 0) {
            if (i == 4) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (_iStatus == 8) {
            if (i == 4) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (_iStatus == 1) {
            if (i == 0) {
                return true;
            }
            if (i == 4) {
                return true;
            }
            if (i == 5) {
                return true;
            }
            if (i == 3) {
                return true;
            }
            if (i == 1) {
                return true;
            }
            if (i == 6) {
                return true;
            }
        } else if (_iStatus == 3) {
            if (i == 4) {
                return true;
            }
        } else if (_iStatus == 2) {
            if (i == 4) {
                return true;
            }
            if (i == 0) {
                return true;
            }
            if (i == 9) {
                return true;
            }
        } else if (_iStatus == 6) {
            if (i == 4) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (_iStatus == 3 ? i == 4 : (_iStatus == 5 ? i == 0 : _iStatus == 4 && i == 0)) {
            return true;
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        if (this.iStatus == 0) {
            if (this.rectGameArea.contains(x, y)) {
                RMSObjects.game.pointerPressed(x, y);
            }
            return;
        }
        if (this.iStatus == 3 && this.bDragInstructions) {
            int iTextShiftY;
            if (!this.rectInstrGameText.contains(x, y)) {
                this.bDragInstructions = false;
            }
            if ((iTextShiftY = MainCanvas.lastPointerPressedY - y) > 0) {
                this.dragDown();
            } else if (iTextShiftY < 0) {
                this.dragUp();
            }
            MainCanvas.lastPointerPressedY = y;
        }
        if (this._iSelectedCompId > -1 && !this._rectItems[this._iSelectedCompId].contains(x, y)) {
            System.out.println("retardace");
            switch (this._iSelectedCompId) {
                case 0: {
                    Keys.keyReleased(-6);
                    break;
                }
                case 4: {
                    if (this.iStatus == 3) {
                        this.startAnimation(true, 1);
                        this._iTextOffsetY = 0;
                        this._bScrollUP = false;
                        this._bScrollDOWN = true;
                        this._iSelectedCompId = 1;
                        break;
                    }
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                    if (this.iStatus != 1) break;
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.iStatus == 0) {
            Game.pressed = true;
        }
        if (this.iStatus == 3) {
            if (this.bDragInstructions) {
                this.bDragInstructions = false;
            }
            switch (this._iSelectedCompId) {
                case 7: {
                    if (!Keys.isKeyPressed(50)) break;
                    this.keyReleased(50);
                    Keys.keyReleased(50);
                    break;
                }
                case 8: {
                    if (!Keys.isKeyPressed(56)) break;
                    this.keyReleased(56);
                    Keys.keyReleased(56);
                    break;
                }
            }
        }
        switch (this._iSelectedCompId) {
            case 0: {
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                if (this._iSelectedCompId != 1 && (this._iSelectedCompId == 5 || this._iSelectedCompId == 6)) {
                    if (this.checkButton2 == 1 || this.checkButton2 == 5 || this.checkButton2 == 6) {
                        this._iSelectedCompId = this.checkButton2;
                        break;
                    }
                    this._iSelectedCompId = 5;
                    break;
                }
                this._iSelectedCompId = this.checkButton;
                break;
            }
            case 4: {
                if (this.iStatus == 3) {
                    this.startAnimation(true, 1);
                    this._iTextOffsetY = 0;
                    this._bScrollUP = false;
                    this._bScrollDOWN = true;
                    this._iSelectedCompId = 1;
                    break;
                }
                if (!Keys.isKeyPressed(-7)) break;
                if (this.iStatus == 0) {
                    this._iSelectedCompId = 5;
                }
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            default: {
                if (Keys.isKeyPressed(53)) {
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
                if (this.iStatus != 1) break;
            }
        }
        if (this._iSelectedCompId == 3) {
            this._iSelectedCompId = 5;
        }
        this.selectedButton = -1;
        this._iSelectedCompId = -1;
    }

    public void textMove() {
        this._bNeedRepaint = false;
        if (this._ptInstructions.getTextHeight() < this.rectInstrGameText.height) {
            return;
        }
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            } else {
                this._iTextOffsetY -= this.fontSmall.getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            }
            if (this._iTextOffsetY < 0) {
                this._iTextOffsetY = 0;
                this._bScrollUP = false;
                this._bScrollDOWN = true;
            }
            this._bNeedRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = this._ptInstructions.getTextHeight() - this.rectInstrGameText.height;
            if (Resources.sysFont) {
                this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            } else {
                this._iTextOffsetY += this.fontSmall.getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            }
            if (this._iTextOffsetY > maxOffsetY) {
                this._iTextOffsetY = maxOffsetY;
                this._bScrollUP = true;
                this._bScrollDOWN = false;
            }
            this._bNeedRepaint = true;
        }
        if (this._bNeedRepaint) {
            this.mainCanvas.repaint();
        }
    }

    public void dragUp() {
        if (this._ptInstructions.getTextHeight() < this.rectInstrGameText.height) {
            return;
        }
        if (Resources.sysFont) {
            this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        } else {
            this._iTextOffsetY -= this.fontSmall.getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        }
        if (this._iTextOffsetY < 0) {
            this._iTextOffsetY = 0;
            this._bScrollUP = false;
            this._bScrollDOWN = true;
        }
        this._bNeedRepaint = true;
        this.mainCanvas.repaint();
    }

    public void dragDown() {
        if (this._ptInstructions.getTextHeight() < this.rectInstrGameText.height) {
            return;
        }
        int maxOffsetY = this._ptInstructions.getTextHeight() - this.rectInstrGameText.height;
        if (Resources.sysFont) {
            this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        } else {
            this._iTextOffsetY += this.fontSmall.getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        }
        if (this._iTextOffsetY > maxOffsetY) {
            this._iTextOffsetY = maxOffsetY;
            this._bScrollUP = true;
            this._bScrollDOWN = false;
        }
        this._bNeedRepaint = true;
        this.mainCanvas.repaint();
    }

    private void paintMiddleBtn(int frame, Graphics g, Sprite sprite) {
        this.sprButton.setFrame(0);
        if (this.selectedButton == 9) {
            this.sprButton.setFrame(1);
        }
        int x = this._rectItems[9].getCenterX() - (this.sprButton.getWidth() >> 1);
        int y = this._rectItems[9].getCenterY() - (this.sprButton.getHeight() >> 1);
        this.sprButton.setPosition(x, y);
        this.sprButton.paint(g);
        sprite.setFrame(frame);
        sprite.setPosition(this._rectItems[9].getCenterX() - (sprite.getWidth() >> 1), this.rectDialogInstr.getBottom() - (this.sprButton.getHeight() >> 2) + (this.sprButton.getHeight() >> 1) - (sprite.getHeight() >> 1));
        sprite.paint(g);
    }

    private void paintDialogByParam(Graphics g, int rows, int columns, Rectangle rect) {
        int width = this.sprWindow.getWidth();
        int height = this.sprWindow.getHeight();
        int x = rect.x + width;
        int y = rect.y;
        int col = 1;
        while (col < columns - 1) {
            this.sprWindow.setFrame(1);
            this.sprWindow.setPosition(x, y);
            this.sprWindow.paint(g);
            this.sprWindow.setFrame(7);
            this.sprWindow.setPosition(x, rect.getBottom() - height);
            this.sprWindow.paint(g);
            ++col;
            x += width;
        }
        x = rect.x;
        y = rect.y + height;
        int row = 1;
        while (row < rows - 1) {
            this.sprWindow.setFrame(3);
            this.sprWindow.setPosition(x, y);
            this.sprWindow.paint(g);
            this.sprWindow.setFrame(5);
            this.sprWindow.setPosition(rect.getRight() - width, y);
            this.sprWindow.paint(g);
            ++row;
            y += height;
        }
        x = rect.x + width;
        y = rect.y + height;
        row = 1;
        while (row < rows - 1) {
            int col2 = 1;
            while (col2 < columns - 1) {
                this.sprWindow.setFrame(4);
                this.sprWindow.setPosition(x, y);
                this.sprWindow.paint(g);
                ++col2;
                x += width;
            }
            ++row;
            y += height;
            x = rect.x + width;
        }
        x = rect.x;
        y = rect.y;
        this.sprWindow.setFrame(0);
        this.sprWindow.setPosition(x, y);
        this.sprWindow.paint(g);
        this.sprWindow.setFrame(2);
        this.sprWindow.setPosition(rect.getRight() - width, y);
        this.sprWindow.paint(g);
        this.sprWindow.setFrame(6);
        this.sprWindow.setPosition(x, rect.getBottom() - height);
        this.sprWindow.paint(g);
        this.sprWindow.setFrame(8);
        this.sprWindow.setPosition(rect.getRight() - width, rect.getBottom() - height);
        this.sprWindow.paint(g);
    }

    private void paintNewWin(Graphics g) {
        int yPos = this.rectResultDialog.y + (this.sprResultStarsActive.getHeight() >> 2);
        if (MainCanvas.HEIGHT <= 432 || MainCanvas.HEIGHT == 480 && MainCanvas.WIDTH == 320) {
            yPos -= this.sprRibbon.getHeight() >> 2;
        }
        this.paintResultStars(g, yPos);
        yPos += this.sprResultStarsActive.getHeight() + (this.sprResultStarsActive.getHeight() >> 2);
        if (MainCanvas.HEIGHT <= 300) {
            yPos -= this.sprRibbon.getHeight() >> 2;
        }
        this.paintRibbon(g, yPos, true);
        this.fontWhite.drawString(g, Resources.resTexts[0].getHashedString(9).toCharArray(), this.rectResultDialog.getCenterX(), yPos + (this.sprRibbon.getHeight() >> 1), 3);
        this.fontBig.drawString(g, (Resources.resTexts[0].getHashedString(8) + " " + (this.actualLevel + 1)).toCharArray(), this.rectResultDialog.getCenterX(), yPos += this.sprRibbon.getHeight() + this.fontBig.getHeight(), 3);
        yPos += this.fontSmall.getHeight() << 1;
        if (MainCanvas.HEIGHT <= 300) {
            yPos -= this.fontSmall.getHeight();
        }
        this.fontSmall.drawString(g, (Resources.resTexts[0].getHashedString(10) + ":").toCharArray(), this.rectResultDialog.getCenterX(), yPos, 3);
        String numbers = String.valueOf(this.score);
        numbers = this.addWhitespace(numbers, numbers.length() / 3);
        int width = numbers.length() * this.sprBigNumbers.getWidth();
        int xPos = this.rectResultGameText.getCenterX() - (width >> 1);
        this.paintNumbers(g, numbers, xPos, yPos += this.fontSmall.getHeight(), 0, this.sprBigNumbers);
        yPos += this.sprBigNumbers.getHeight() + this.fontBig.getHeight();
        if (MainCanvas.HEIGHT <= 300) {
            yPos -= this.fontBig.getHeight() >> 2;
        }
        this.fontSmall.drawString(g, "YOUR BEST:".toCharArray(), this.rectResultDialog.getCenterX(), yPos, 3);
        numbers = String.valueOf(this.highScore);
        numbers = this.addWhitespace(numbers, numbers.length() / 3);
        width = numbers.length() * this.sprSmallNumbers.getWidth();
        xPos = this.rectResultGameText.getCenterX() - (width >> 1);
        this.paintNumbers(g, numbers, xPos, yPos += this.fontSmall.getHeight(), 0, this.sprSmallNumbers);
    }

    private void paintNewLose(Graphics g) {
        int yPos = this.rectResultDialog.y + (this.sprResultStarsActive.getHeight() >> 2);
        if (MainCanvas.HEIGHT <= 432 || MainCanvas.HEIGHT == 480 && MainCanvas.WIDTH == 320) {
            yPos -= this.sprRibbon.getHeight() >> 2;
        }
        this.paintResultStars(g, yPos);
        yPos += this.sprResultStarsActive.getHeight() + (this.sprResultStarsActive.getHeight() >> 2);
        if (MainCanvas.HEIGHT <= 300) {
            yPos -= this.sprRibbon.getHeight() >> 2;
        }
        this.paintRibbon(g, yPos, false);
        this.fontWhite.drawString(g, Resources.resTexts[0].getHashedString(79).toCharArray(), this.rectResultDialog.getCenterX(), yPos + (this.sprRibbon.getHeight() >> 1), 3);
        this.fontBig.drawString(g, (Resources.resTexts[0].getHashedString(8) + " " + (this.actualLevel + 1)).toCharArray(), this.rectResultDialog.getCenterX(), yPos += this.sprRibbon.getHeight() + this.fontBig.getHeight(), 3);
        yPos += this.fontSmall.getHeight() << 1;
        if (MainCanvas.HEIGHT <= 300) {
            yPos -= this.fontSmall.getHeight();
        }
        this.fontSmall.drawString(g, (Resources.resTexts[0].getHashedString(10) + ":").toCharArray(), this.rectResultDialog.getCenterX(), yPos, 3);
        String numbers = String.valueOf(this.score);
        numbers = this.addWhitespace(numbers, numbers.length() / 3);
        int width = numbers.length() * this.sprBigNumbers.getWidth();
        int xPos = this.rectResultGameText.getCenterX() - (width >> 1);
        this.paintNumbers(g, numbers, xPos, yPos += this.fontSmall.getHeight(), 0, this.sprBigNumbers);
        this.fontSmall.drawString(g, "YOUR BEST:".toCharArray(), this.rectResultDialog.getCenterX(), yPos += this.sprBigNumbers.getHeight() + this.fontBig.getHeight(), 3);
        yPos += this.fontSmall.getHeight();
        if (MainCanvas.HEIGHT <= 300) {
            yPos -= this.fontBig.getHeight() >> 2;
        }
        numbers = String.valueOf(this.highScore);
        numbers = this.addWhitespace(numbers, numbers.length() / 3);
        width = numbers.length() * this.sprSmallNumbers.getWidth();
        xPos = this.rectResultGameText.getCenterX() - (width >> 1);
        this.paintNumbers(g, numbers, xPos, yPos, 0, this.sprSmallNumbers);
    }

    private void paintResultStars(Graphics g, int yPos) {
        int xStar = this.rectResultDialog.getCenterX() - (this.sprResultStarsActive.getWidth() >> 1) - this.sprResultStarsActive.getWidth();
        Sprite sprite = this.sprResultStarsActive;
        if (this.score <= Level._iScoreMin) {
            sprite = this.sprResultStarsInactive;
        }
        sprite.setFrame(0);
        sprite.setPosition(xStar, yPos);
        sprite.paint(g);
        if (this.score <= Level._iScoreMid) {
            sprite = this.sprResultStarsInactive;
        }
        sprite.setFrame(1);
        sprite.setPosition(xStar += sprite.getWidth(), yPos);
        sprite.paint(g);
        if (this.score <= Level._iScoreHig) {
            sprite = this.sprResultStarsInactive;
        }
        sprite.setFrame(2);
        sprite.setPosition(xStar += sprite.getWidth(), yPos);
        sprite.paint(g);
    }

    private void paintRibbon(Graphics g, int yPos, boolean isWin) {
        if (isWin) {
            this.sprRibbon.setFrame(0);
        } else {
            this.sprRibbon.setFrame(1);
        }
        this.sprRibbon.setPosition(this.rectResultDialog.getCenterX() - (this.sprRibbon.getWidth() >> 1), yPos);
        this.sprRibbon.paint(g);
    }

    private void paintNumbers(Graphics g, String numbers, int xPos, int yPos, int pos, Sprite sprite) {
        if (numbers.length() == pos) {
            return;
        }
        int x = xPos + pos * sprite.getWidth();
        if (numbers.charAt(pos) == ' ') {
            this.paintNumbers(g, numbers, xPos, yPos, ++pos, sprite);
        } else {
            int frame = numbers.charAt(pos) - 48 - 1;
            if (frame < 0) {
                frame = 9;
            }
            sprite.setFrame(frame);
            sprite.setPosition(x, yPos);
            sprite.paint(g);
            this.paintNumbers(g, numbers, xPos, yPos, ++pos, sprite);
        }
    }

    private String addWhitespace(String string, int count) {
        if (count == 0) {
            return string;
        }
        int pos = count * 3;
        String first = string.substring(0, string.length() - pos);
        String second = string.substring(string.length() - pos);
        string = first + " " + second;
        return this.addWhitespace(string, --count);
    }

    private void paintTopBarBg(Graphics g) {
        int width = this.sprTopPanelBg.getWidth();
        int y = 0;
        int count = 4;
        int x = (MainCanvas.WIDTH >> 1) - (width << 1);
        int xLast = MainCanvas.WIDTH - width;
        int index = 0;
        while (index < count) {
            if (x >= width >> 1 && x <= xLast - (width >> 1)) {
                this.sprTopPanelBg.setFrame(1);
                this.sprTopPanelBg.setPosition(x, y);
                this.sprTopPanelBg.paint(g);
            }
            ++index;
            x += width;
        }
        this.sprTopPanelBg.setFrame(0);
        this.sprTopPanelBg.setPosition(0, y);
        this.sprTopPanelBg.paint(g);
        this.sprTopPanelBg.setFrame(2);
        this.sprTopPanelBg.setPosition(xLast, y);
        this.sprTopPanelBg.paint(g);
    }

    private void paintTopCenter(Graphics g) {
        g.drawImage(this.imgTopPanel, this.rectTopCenter.getCenterX(), this.rectTopCenter.getCenterY(), 3);
        int yPos = 0 - (this._animationComponents[5]._iDefaultY - this._animationComponents[5]._defaultRectangle.y);
        int yOffset = 0;
        this.sprTopBarIconsMini.setFrame(0);
        this.sprTopBarIconsMini.setPosition(this.rectTopCenter.getCenterX() - (this.sprTopBarIconsMini.getWidth() >> 1), yPos);
        if (this._iGameMode == 5 || this._iGameMode == 2 || this._iGameMode == 3 || this._iGameMode == 7 || this._iGameMode == 0) {
            this.sprTopBarIconsMini.setFrame(3);
            this.sprTopBarIconsMini.paint(g);
            yOffset = Math.abs(this.rectTopCenter.getCenterY() - this.sprTopBarIconsMini.getHeight());
        }
        if (MainCanvas.HEIGHT == 224 && MainCanvas.WIDTH == 320) {
            yOffset += this.fontSmall.getHeight() >> 1;
        }
        if (this._iGameMode == 0 || this._iGameMode == 2 || this._iGameMode == 3 || this._iGameMode == 5) {
            this.paintMoves(g, yOffset);
        } else if (this._iGameMode == 1 || this._iGameMode == 4 || this._iGameMode == 7) {
            this.paintTime(g, yOffset);
        }
    }

    private void paintTopLeft(Graphics g) {
        if (this._iGameMode != 0 && this._iGameMode != 1) {
            if (this._iGameMode == 2) {
                this.paintGoal(2, Level._iEscapeObjCount - Game._iProgressSecondary, g);
            } else if (this._iGameMode == 3) {
                this.paintGoal(0, Level._iDownfallObjCount - Game._iProgressSecondary, g);
            } else if (this._iGameMode == 4) {
                this.paintGoal(1, Block.count(), g);
            } else if (this._iGameMode == 5) {
                this.paintGoal(1, Block.count(), g);
            } else if (this._iGameMode == 7) {
                this.paintGoal(3, Level._iMoves - MainCanvas.moveCounter, g);
            }
        }
    }

    private void paintGoal(int icon, int value, Graphics g) {
        int x = this.sprButton.getWidth() >> 1;
        int y = this.sprTopPanelBg.getHeight() >> 2;
        if (value < 0) {
            value = 0;
        }
        int width = MainCanvas.WIDTH >> 2;
        Rectangle rect = new Rectangle(x, y, width, this.fontBig.getHeight());
        this.sprTopBarIconsMini.setFrame(icon);
        this.sprTopBarIconsMini.setPosition(rect.x - (this.sprTopBarIconsMini.getWidth() >> 1), rect.getCenterY() - (this.sprTopBarIconsMini.getHeight() >> 1));
        this.sprTopBarIconsMini.paint(g);
        this.fontSmall.drawString(g, (value + "").toCharArray(), x += (this.sprTopBarIconsMini.getWidth() >> 1) + (this.sprButton.getWidth() >> 2), rect.getCenterY(), 6);
    }

    private void initData() {
        Vector scores = RMSObjects.localScores.getScoresForGame(0);
        if (scores != null) {
            PowV2ScoreItem scoreItem = null;
            if (scores.size() > this.actualLevel) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(this.actualLevel);
                this.highScore = scoreItem.highScore;
            } else {
                this.highScore = 0;
            }
        }
    }
}

