/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import sk.inlogic.Level;
import sk.inlogic.RMSObjects;
import sk.inlogic.rms.RMSHandler;

public class Profile
implements RMSHandler {
    static Profile pInstance;
    public static boolean bMusic;
    public static int iLevel;
    public static int hints;
    public static int stars;
    public static int[] openLevels;
    public static int[] completedLevels;
    public static int[] stage2;
    public static int[] stage4;
    public static boolean dailyAvailable;
    public static long dailyReset;
    public static boolean tutorial;

    public static void defaultValues() {
        iLevel = 0;
        hints = 0;
        stars = 0;
        openLevels = new int[Level.LAST_LEVEL];
        completedLevels = new int[Level.LAST_LEVEL];
        stage2 = new int[Level.LAST_LEVEL];
        stage4 = new int[Level.LAST_LEVEL];
        dailyAvailable = true;
        dailyReset = 0L;
        tutorial = false;
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
        if (rmsName.equals("p.conf")) {
            int flag = dis.readInt();
            bMusic = flag == 1 ? dis.readBoolean() : true;
        } else if (rmsName.equals("g.conf")) {
            int i;
            hints = dis.readInt();
            stars = dis.readInt();
            for (i = 0; i < openLevels.length; ++i) {
                Profile.openLevels[i] = dis.readInt();
            }
            for (i = 0; i < completedLevels.length; ++i) {
                Profile.completedLevels[i] = dis.readInt();
            }
            iLevel = 0;
            for (i = 0; i < openLevels.length; ++i) {
                if (openLevels[i] == 1 && completedLevels[i] == 0) {
                    iLevel = i;
                    break;
                }
                if (completedLevels[i] != 1) continue;
                iLevel = i;
            }
            dailyAvailable = dis.readBoolean();
            dailyReset = dis.readLong();
            for (i = 0; i < stage2.length; ++i) {
                Profile.stage2[i] = dis.readInt();
            }
            for (i = 0; i < stage4.length; ++i) {
                Profile.stage4[i] = dis.readInt();
            }
            tutorial = dis.readBoolean();
        }
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
        if (rmsName.equals("p.conf")) {
            dos.writeInt(1);
            dos.writeInt(0);
            dos.writeBoolean(bMusic);
        } else if (rmsName.equals("g.conf")) {
            int i;
            dos.writeInt(hints);
            dos.writeInt(stars);
            for (i = 0; i < openLevels.length; ++i) {
                dos.writeInt(openLevels[i]);
            }
            for (i = 0; i < completedLevels.length; ++i) {
                dos.writeInt(completedLevels[i]);
            }
            dos.writeBoolean(dailyAvailable);
            dos.writeLong(dailyReset);
            for (i = 0; i < stage2.length; ++i) {
                dos.writeInt(stage2[i]);
            }
            for (i = 0; i < stage4.length; ++i) {
                dos.writeInt(stage4[i]);
            }
            dos.writeBoolean(tutorial);
        }
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
        if (rmsName.equals("p.conf")) {
            dos.writeInt(0);
        } else if (rmsName.equals("g.conf")) {
            int i;
            dos.writeInt(hints);
            dos.writeInt(stars);
            for (i = 0; i < openLevels.length; ++i) {
                Profile.openLevels[i] = i == 0 ? 1 : 0;
                dos.writeInt(openLevels[i]);
            }
            for (i = 0; i < completedLevels.length; ++i) {
                Profile.completedLevels[i] = 0;
                dos.writeInt(completedLevels[i]);
            }
            dos.writeBoolean(dailyAvailable);
            dos.writeLong(dailyReset);
            for (i = 0; i < stage2.length; ++i) {
                Profile.stage2[i] = 0;
                dos.writeInt(stage2[i]);
            }
            for (i = 0; i < stage4.length; ++i) {
                Profile.stage4[i] = 0;
                dos.writeInt(stage4[i]);
            }
            dos.writeBoolean(tutorial);
        }
    }

    public static void load() {
        RMSObjects.createRMSConnect(0);
        if (!RMSObjects.rmsConnects[0].isExist()) {
            RMSObjects.rmsConnects[0].create();
        }
        RMSObjects.rmsConnects[0].load();
        RMSObjects.freeRMSConnect(0);
        RMSObjects.createRMSConnect(1);
        if (!RMSObjects.rmsConnects[1].isExist()) {
            RMSObjects.rmsConnects[1].create();
        }
        RMSObjects.rmsConnects[1].load();
        RMSObjects.freeRMSConnect(1);
    }

    public static void save() {
        RMSObjects.createRMSConnect(0);
        if (!RMSObjects.rmsConnects[0].isExist()) {
            RMSObjects.rmsConnects[0].create();
        }
        RMSObjects.rmsConnects[0].save();
        RMSObjects.createRMSConnect(1);
        if (!RMSObjects.rmsConnects[1].isExist()) {
            RMSObjects.rmsConnects[1].create();
        }
        RMSObjects.rmsConnects[1].save();
    }

    public static void reset() {
        Profile.defaultValues();
        RMSObjects.createRMSConnect(1);
        RMSObjects.rmsConnects[1].create();
        RMSObjects.rmsConnects[1].load();
        RMSObjects.freeRMSConnect(1);
    }

    static {
        bMusic = true;
        iLevel = 0;
        hints = 0;
        stars = 0;
        openLevels = new int[Level.LAST_LEVEL];
        completedLevels = new int[Level.LAST_LEVEL];
        stage2 = new int[Level.LAST_LEVEL];
        stage4 = new int[Level.LAST_LEVEL];
        dailyAvailable = true;
        dailyReset = 0L;
        tutorial = false;
        pInstance = new Profile();
    }
}

