/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSplash
implements IScreen {
    private static final int MODE_ENABLE_MUSIC_QUESTION = 0;
    private static final int MODE_SPLASH = 1;
    private MainCanvas mainCanvas;
    private int mode;
    private long modeDelay = 2000L;
    private Rectangle BB_BACK;
    private Rectangle BB_MENU;
    private Rectangle Logo;
    private Rectangle Question;
    private byte[] _arrImages;
    private byte[] _arrSprites;
    private byte[] _arrFonts;
    private int _ANIM_LOGO = 0;
    private int _ANIM_QUEST = 1;
    private int _ANIM_YES = 2;
    private int _ANIM_NO = 3;
    private int _ANIM_TOTAL = 4;
    private AnimationComponent[] _animationComponent = new AnimationComponent[this._ANIM_TOTAL];
    PreparedText navigationKeysBB;
    private int interuption = 0;
    private PreparedText _soundQuestions;
    private Image _imgCorpLogo;
    private Sprite _spr_IconOff;
    private int _BUTTON_NO = 0;
    private int _BUTTON_YES = 1;
    private int _TOTAL_BUTTONS = 2;
    private int _selectedButton = -1;
    private static int _WIDTH = 0;
    private static int _HEIGHT = 0;
    int _iColorBg = 15691352;
    Rectangle[] Button = new Rectangle[this._TOTAL_BUTTONS];
    private boolean hideLogo = false;
    private boolean hideQuest = false;
    boolean startMusic = false;

    public ScreenSplash(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
        this.initDimensions();
    }

    public void beforeShow() {
        this.mode = 0;
        this.mode = 1;
        this.prepareResources();
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.prepareTxt();
        this.calculatePosition();
        this.initAnimationControllers();
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void prepareResources() {
        this._arrImages = new byte[]{1};
        this._arrSprites = new byte[]{0};
        this._arrFonts = new byte[]{2};
    }

    private void loadResources() {
        Resources.loadImages(this._arrImages);
        Resources.loadSprites(this._arrSprites);
        Resources.loadGFonts(this._arrFonts);
        Resources.loadText((byte)0);
    }

    private void freeResources() {
        Resources.freeImages(this._arrImages);
        Resources.freeSprites(this._arrSprites);
        Resources.loadGFonts(this._arrFonts);
    }

    public void calculatePosition() {
        if (this._spr_IconOff == null) {
            System.out.println("icon is null");
        }
        int itemHeight = this._spr_IconOff.getHeight();
        this.Logo = new Rectangle(_WIDTH >> 1, _HEIGHT >> 1, this._imgCorpLogo.getWidth(), this._imgCorpLogo.getHeight());
        this.Question = new Rectangle(0, 0, _WIDTH, _HEIGHT);
        this.Button[this._BUTTON_YES] = new Rectangle(0, MainCanvas.HEIGHT - (this._spr_IconOff.getWidth() + (this._spr_IconOff.getWidth() >> 1)), this._spr_IconOff.getWidth() + (this._spr_IconOff.getWidth() >> 1), this._spr_IconOff.getHeight() + (this._spr_IconOff.getHeight() >> 1));
        this.Button[this._BUTTON_NO] = new Rectangle(MainCanvas.WIDTH - (this._spr_IconOff.getWidth() + (this._spr_IconOff.getWidth() >> 1)), MainCanvas.HEIGHT - this._spr_IconOff.getWidth() - (this._spr_IconOff.getWidth() >> 1), this._spr_IconOff.getWidth() + (this._spr_IconOff.getWidth() >> 1), this._spr_IconOff.getHeight() + (this._spr_IconOff.getHeight() >> 1));
        this.BB_BACK = new Rectangle(0, MainCanvas.HEIGHT - (itemHeight << 1), _WIDTH - (itemHeight << 1), itemHeight << 1);
        this.BB_MENU = new Rectangle(this._spr_IconOff.getX() + (this._spr_IconOff.getWidth() << 1), MainCanvas.HEIGHT - (itemHeight << 1), _WIDTH, itemHeight << 1);
    }

    private void initAnimationControllers() {
        this._animationComponent[this._ANIM_LOGO] = new AnimationComponent(this.mainCanvas, this.Logo, _WIDTH, _HEIGHT);
        this._animationComponent[this._ANIM_LOGO].startShowAnimation(2);
        this._animationComponent[this._ANIM_QUEST] = new AnimationComponent(this.mainCanvas, this.Question, _WIDTH, _HEIGHT);
        this._animationComponent[this._ANIM_QUEST].startShowAnimation(2);
        this._animationComponent[this._ANIM_YES] = new AnimationComponent(this.mainCanvas, this.Button[this._BUTTON_YES], _WIDTH, _HEIGHT);
        this._animationComponent[this._ANIM_YES].startShowAnimation(0);
        this._animationComponent[this._ANIM_NO] = new AnimationComponent(this.mainCanvas, this.Button[this._BUTTON_NO], _WIDTH, _HEIGHT);
        this._animationComponent[this._ANIM_NO].startShowAnimation(1);
    }

    private void initDimensions() {
        _WIDTH = MainCanvas.WIDTH;
        _HEIGHT = MainCanvas.HEIGHT;
    }

    private void initImages() {
        this._imgCorpLogo = Resources.resImgs[1];
    }

    private void initSprites() {
        this._spr_IconOff = Resources.resSprs[0];
        if (Resources.resSprs[0] == null) {
            System.out.println("icon is null initSprites");
        }
    }

    private void freeGraphics() {
        this._imgCorpLogo = null;
        this._spr_IconOff = null;
    }

    private void prepareTxt() {
        this._soundQuestions = new PreparedText(Resources.resGFonts[2]);
        this._soundQuestions.prepareText(Resources.resTexts[0].getHashedString(10), MainCanvas.WIDTH);
        this.navigationKeysBB = new PreparedText(Resources.resGFonts[2]);
    }

    public void beforeInteruption() {
        if (this.mode == 0) {
            MainCanvas.soundManager.Stop();
        }
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        if (this.mode == 0) {
            MainCanvas.soundManager.Stop();
        }
    }

    public void update(long lastRunLenght) {
        if (this.mode == 1) {
            if (!this.hideLogo) {
                this._animationComponent[this._ANIM_LOGO].update();
            }
            this.modeDelay -= lastRunLenght;
            if (this.modeDelay < 0L) {
                if (this.startMusic) {
                    Settings.musicOn = true;
                    MainCanvas.music = true;
                    MainCanvas.soundManager.SetSoundOn(true);
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    }
                } else {
                    Settings.musicOn = false;
                    MainCanvas.music = false;
                    MainCanvas.soundManager.SetSoundOn(false);
                }
                if (!this.hideLogo) {
                    this._animationComponent[this._ANIM_LOGO].startHideAnimation(2);
                    this.hideLogo = true;
                }
                if (!this._animationComponent[this._ANIM_LOGO].isComponentAnimated()) {
                    this._animationComponent[this._ANIM_LOGO].update();
                    return;
                }
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
            }
        } else if (this.mode == 0) {
            if (this.hideQuest) {
                if (!this._animationComponent[this._ANIM_QUEST].isComponentAnimated()) {
                    this._animationComponent[this._ANIM_QUEST].update();
                    this._animationComponent[this._ANIM_YES].update();
                    this._animationComponent[this._ANIM_NO].update();
                    return;
                }
                this.mode = 1;
            } else {
                this._animationComponent[this._ANIM_QUEST].update();
                this._animationComponent[this._ANIM_YES].update();
                this._animationComponent[this._ANIM_NO].update();
            }
        }
        this.mainCanvas.repaint();
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        if (this.mode == 0) {
            this._soundQuestions.drawText(g, this.Question, 0, 3);
            this.paintFK(g);
        } else if (this.mode == 1) {
            g.drawImage(this._imgCorpLogo, this.Logo.x, this.Logo.y, 3);
        } else {
            g.drawImage(this._imgCorpLogo, this.Logo.x, this.Logo.y, 3);
        }
    }

    public void paintBackground(Graphics g) {
        g.setColor(9230335);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public void paintFK(Graphics g) {
        this._spr_IconOff.setFrame(10);
        this._spr_IconOff.setPosition(this.Button[this._BUTTON_YES].getCenterX() - (this._spr_IconOff.getWidth() >> 1), this.Button[this._BUTTON_YES].getCenterY() - (this._spr_IconOff.getHeight() >> 1));
        this._spr_IconOff.paint(g);
        this._spr_IconOff.setFrame(11);
        this._spr_IconOff.setPosition(this.Button[this._BUTTON_NO].getCenterX() - (this._spr_IconOff.getWidth() >> 1), this.Button[this._BUTTON_NO].getCenterY() - (this._spr_IconOff.getHeight() >> 1));
        this._spr_IconOff.paint(g);
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        if (this.mode == 0) {
            if (Keys.isFKRightCode(keyCode)) {
                this._animationComponent[this._ANIM_QUEST].startHideAnimation(2);
                this._animationComponent[this._ANIM_YES].startHideAnimation(1);
                this._animationComponent[this._ANIM_NO].startHideAnimation(0);
                this.hideQuest = true;
                this.startMusic = false;
                this.mainCanvas.repaint();
            } else if (Keys.isFKLeftCode(keyCode)) {
                this._animationComponent[this._ANIM_QUEST].startHideAnimation(2);
                this._animationComponent[this._ANIM_YES].startHideAnimation(1);
                this._animationComponent[this._ANIM_NO].startHideAnimation(0);
                this.hideQuest = true;
                this.startMusic = true;
                this.mainCanvas.repaint();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.mode == 0) {
            for (int i = 0; i < this.Button.length; ++i) {
                if (!this.Button[i].contains(x, y)) continue;
                this._selectedButton = i;
            }
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        if (this.mode == 0) {
            if (this._selectedButton == this._BUTTON_NO) {
                this._animationComponent[this._ANIM_QUEST].startHideAnimation(2);
                this._animationComponent[this._ANIM_YES].startHideAnimation(1);
                this._animationComponent[this._ANIM_NO].startHideAnimation(0);
                this.mode = 1;
                this.startMusic = false;
                Settings.musicOn = false;
                MainCanvas.music = false;
                MainCanvas.soundManager.SetSoundOn(false);
            } else if (this._selectedButton == this._BUTTON_YES) {
                this._animationComponent[this._ANIM_QUEST].startHideAnimation(2);
                this._animationComponent[this._ANIM_YES].startHideAnimation(1);
                this._animationComponent[this._ANIM_NO].startHideAnimation(0);
                this.mode = 1;
                this.startMusic = true;
                Settings.musicOn = true;
                MainCanvas.music = true;
                MainCanvas.soundManager.SetSoundOn(true);
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            }
        }
    }
}

