/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.ResourceBundle;

public class Resources {
    private static String graphicsBaseDir = "/";
    private static String graphicsDisplayDir = "/";
    public static final byte _IMG_SPLASH = 0;
    public static final byte _IMG_INLOGIC_LOGO = 1;
    public static final byte _IMG_INLOGIC_LOGO_ABOUT = 2;
    public static final byte _IMG_RES_ROTATION = 3;
    public static final byte _IMG_P_FRANCE = 4;
    public static final byte _IMG_P_HOLAND = 5;
    public static final byte _IMG_P_CHINA = 6;
    public static final byte _IMG_P_MEXICO = 7;
    public static final byte _IMG_LOCK = 8;
    public static final byte TOTAL_IMGS = 9;
    public static Image[] resImgs = new Image[9];
    public static final byte _SPR_ICON_OFF = 0;
    public static final byte _SPR_BUTTON_ON = 1;
    public static final byte _SPR_BUTTON_OFF = 2;
    public static final byte _SPR_DIALOG_BG = 3;
    public static final byte _SPR_P_FRANCE = 4;
    public static final byte _SPR_P_HOLAND = 5;
    public static final byte _SPR_P_CHINA = 6;
    public static final byte _SPR_P_MEXICO = 7;
    public static final byte _SPR_TEXT_BG = 8;
    public static final byte _SPR_TITLE_BG = 9;
    public static final byte _SPR_COIN = 10;
    public static final byte _SPR_DOTS = 11;
    public static final byte _SPR_AROWS = 12;
    public static final byte _SPR_LOCK = 13;
    public static final byte _SPR_BINGO = 14;
    public static final byte _SPR_BALL_BAR = 15;
    public static final byte _SPR_GAME_BAR = 16;
    public static final byte _SPR_BALL_ICON = 17;
    public static final byte _SPR_BALL_BIG = 18;
    public static final byte _SPR_BALL_SMALL = 19;
    public static final byte _SPR_GAME_TILES = 20;
    public static final byte _SPR_MARKS_ON = 21;
    public static final byte _SPR_MARKS_OFF = 22;
    public static final byte _SPR_TEXT_BG_FOR_BAD_BINGO = 23;
    public static final byte _SPR_LANG_FLAGS = 24;
    public static final byte _SPR_PARTICLES = 25;
    public static final byte _SPR_SELECTOR = 26;
    public static final byte TOTAL_SPRS = 27;
    public static Sprite[] resSprs = new Sprite[27];
    public static final byte _GFONT_WHITE = 0;
    public static final byte _GFONT_AZURE = 1;
    public static final byte _GFONT_MUD = 2;
    public static final byte _GFONT_NUMBERS_MUD = 3;
    public static final byte _GFONT_NUMBERS_BLACK = 4;
    public static final byte TOTAL_GFONTS = 5;
    public static GFont[] resGFonts = new GFont[5];
    public static final byte TEXT_MAIN = 0;
    public static final byte TOTAL_TEXTS = 95;
    private static String langDir = "/";
    public static ResourceBundle[] resTexts = new ResourceBundle[95];
    public static final byte TEXT_PLAY = 1;
    public static final byte TEXT_SETTINGS = 2;
    public static final byte TEXT_INSTRUCTION = 3;
    public static final byte TEXT_MUSIC_ON = 4;
    public static final byte TEXT_MUSIC_OFF = 5;
    public static final byte TEXT_MAIN_INSTRUCTIONS = 6;
    public static final byte TEXT_CONTROLS_NOTOUCH = 7;
    public static final byte TEXT_CONTROLS_TOUCH = 8;
    public static final byte TEXT_REALY_QUIT = 9;
    public static final byte TEXT_MAIN_ENABLE_MUSIC = 10;
    public static final byte TEXT_FRANCE = 11;
    public static final byte TEXT_HOLAND = 12;
    public static final byte TEXT_CHINA = 13;
    public static final byte TEXT_MEXICO = 14;
    public static final byte TEXT_BUY_300 = 15;
    public static final byte TEXT_BUY_800 = 16;
    public static final byte TEXT_BUY_2000 = 17;
    public static final byte TEXT_TIME_8S = 18;
    public static final byte TEXT_TIME_7S = 19;
    public static final byte TEXT_TIME_6S = 20;
    public static final byte TEXT_TIME_5S = 21;
    public static final byte TEXT_CARD = 22;
    public static final byte TEXT_CARDS = 23;
    public static final byte TEXT_FREE = 24;
    public static final byte TEXT_BINGO = 25;
    public static final byte TEXT_BAD_BINGO = 26;
    public static final byte TEXT_PAUSE = 27;
    public static final byte TEXT_MENU = 28;
    public static final byte TEXT_RESUME = 29;
    public static final byte TEXT_INGAME_REALY_QUIT = 30;
    public static final byte TEXT_CONGRATULATIONS = 31;
    public static final byte TEXT_BALLS = 32;
    public static final byte TEXT_BAD_BALLS = 33;
    public static final byte TEXT_COLLECT = 34;
    public static final int TEXT_BACK = 35;
    public static final int TEXT_SOUND_ON = 36;
    public static final int TEXT_SOUND_OFF = 37;
    public static boolean sysFont;
    public static int widht;

    public static void initGraphicsDirs(int width, int height) {
        graphicsBaseDir = "/";
        graphicsDisplayDir = "/";
    }

    public static Image createImage(String imgName) {
        Image image = null;
        try {
            image = Image.createImage((String)imgName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return image;
    }

    public static Sprite createSprite(Image image, int slicesX, int slicesY) {
        Sprite sprite = null;
        try {
            int sprWidth = image.getWidth() / slicesX;
            int sprHeight = image.getHeight() / slicesY;
            sprite = new Sprite(image, sprWidth, sprHeight);
        }
        catch (Exception e) {
            sprite = null;
        }
        return sprite;
    }

    public static void loadImage(byte _iImgIdx) {
        String _sImgPath = null;
        switch (_iImgIdx) {
            case 0: {
                _sImgPath = graphicsBaseDir + "splash.png";
                break;
            }
            case 1: {
                _sImgPath = graphicsBaseDir + "I.png";
                break;
            }
            case 2: {
                _sImgPath = graphicsBaseDir + "logo.png";
                break;
            }
            case 3: {
                _sImgPath = graphicsBaseDir + "rot.png";
                break;
            }
        }
        if (_sImgPath != null && resImgs[_iImgIdx] == null) {
            Resources.resImgs[_iImgIdx] = Resources.createImage(_sImgPath);
        }
    }

    public static void freeImage(byte imgIdx) {
        Resources.resImgs[imgIdx] = null;
    }

    public static void loadImages(byte[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; i = (int)((byte)(i + 1))) {
            Resources.loadImage(imgsIdx[i]);
        }
    }

    public static void freeImages(byte[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; i = (int)((byte)(i + 1))) {
            Resources.resImgs[imgsIdx[i]] = null;
        }
    }

    public static void loadSprite(byte _iSprIdx) {
        String _sSprPath = null;
        int _iSlicesX = 1;
        int _iSlicesY = 1;
        switch (_iSprIdx) {
            case 1: {
                _sSprPath = graphicsBaseDir + "button_on.png";
                _iSlicesX = 3;
                _iSlicesY = 1;
                break;
            }
            case 2: {
                _sSprPath = graphicsBaseDir + "button_off.png";
                _iSlicesX = 3;
                _iSlicesY = 1;
                break;
            }
            case 0: {
                _sSprPath = graphicsBaseDir + "icon_off.png";
                _iSlicesX = 6;
                _iSlicesY = 2;
                break;
            }
            case 3: {
                _sSprPath = graphicsBaseDir + "dialog_bg.png";
                _iSlicesX = 3;
                _iSlicesY = 3;
                break;
            }
            case 8: {
                _sSprPath = graphicsBaseDir + "text_bg.png";
                _iSlicesX = 3;
                _iSlicesY = 3;
                break;
            }
            case 4: {
                _sSprPath = graphicsBaseDir + "p_france.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 5: {
                _sSprPath = graphicsBaseDir + "p_holand.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 6: {
                _sSprPath = graphicsBaseDir + "p_china.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 7: {
                _sSprPath = graphicsBaseDir + "p_mexico.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 9: {
                _sSprPath = graphicsBaseDir + "title_bg.png";
                _iSlicesX = 3;
                _iSlicesY = 1;
                break;
            }
            case 10: {
                _sSprPath = graphicsBaseDir + "coin.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 11: {
                _sSprPath = graphicsBaseDir + "dots.png";
                _iSlicesX = 2;
                _iSlicesY = 1;
                break;
            }
            case 12: {
                _sSprPath = graphicsBaseDir + "arows.png";
                _iSlicesX = 2;
                _iSlicesY = 1;
                break;
            }
            case 13: {
                _sSprPath = graphicsBaseDir + "lock.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 14: {
                _sSprPath = graphicsBaseDir + "bingo.png";
                _iSlicesX = 5;
                _iSlicesY = 1;
                break;
            }
            case 18: {
                _sSprPath = graphicsBaseDir + "ball_big.png";
                _iSlicesX = 5;
                _iSlicesY = 1;
                break;
            }
            case 19: {
                _sSprPath = graphicsBaseDir + "ball_small.png";
                _iSlicesX = 5;
                _iSlicesY = 1;
                break;
            }
            case 20: {
                _sSprPath = graphicsBaseDir + "game_tiles.png";
                _iSlicesX = 5;
                _iSlicesY = 1;
                break;
            }
            case 21: {
                _sSprPath = graphicsBaseDir + "marks_on.png";
                _iSlicesX = 1;
                _iSlicesY = 3;
                break;
            }
            case 22: {
                _sSprPath = graphicsBaseDir + "marks_off.png";
                _iSlicesX = 1;
                _iSlicesY = 3;
                break;
            }
            case 24: {
                _sSprPath = graphicsBaseDir + "flags.png";
                _iSlicesX = 2;
                _iSlicesY = 6;
                break;
            }
            case 23: {
                _sSprPath = graphicsBaseDir + "text_bg.png";
                _iSlicesX = 3;
                _iSlicesY = 1;
                break;
            }
            case 15: {
                _sSprPath = graphicsBaseDir + "ball_bar.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 16: {
                _sSprPath = graphicsBaseDir + "game_bar.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 17: {
                _sSprPath = graphicsBaseDir + "ball_icon.png";
                _iSlicesX = 1;
                _iSlicesY = 1;
                break;
            }
            case 26: {
                _sSprPath = graphicsBaseDir + "selector.png";
                _iSlicesX = 4;
                _iSlicesY = 1;
                break;
            }
            case 25: {
                _sSprPath = graphicsBaseDir + "particles.png";
                _iSlicesX = 12;
                _iSlicesY = 1;
                break;
            }
        }
        if (_sSprPath != null && resSprs[_iSprIdx] == null) {
            Resources.resSprs[_iSprIdx] = Resources.createSprite(Resources.createImage(_sSprPath), _iSlicesX, _iSlicesY);
            if (resSprs[_iSprIdx] == null) {
                System.out.println("spr is null. path: " + _sSprPath + " ,sliceX: " + _iSlicesX + " ,sliceY: " + _iSlicesY);
            }
        }
    }

    public static void freeSprite(byte sprIdx) {
        Resources.resSprs[sprIdx] = null;
    }

    public static void loadSprites(byte[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; i = (int)((byte)(i + 1))) {
            Resources.loadSprite(sprsIdx[i]);
        }
    }

    public static void freeSprites(byte[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; i = (int)((byte)(i + 1))) {
            Resources.resSprs[sprsIdx[i]] = null;
        }
    }

    private static GFont createGFontWhite(Image gFontImg) {
        char[] _fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u011a', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u00dd', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u00df', '$', '#', '&', '@', '\\', '/', '\u20ac', '(', ')', '%', '\u00b0', '+', '=', '\u00f7', '~', '^', '.', ',', ':', ';', '`', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 1;
        switch (gFontImg.getHeight()) {
            case 38: {
                fontCharsWidth = new short[]{20, 18, 18, 20, 16, 15, 20, 19, 7, 12, 18, 15, 24, 19, 21, 18, 23, 18, 17, 18, 19, 21, 27, 19, 19, 17, 21, 20, 20, 21, 21, 20, 18, 17, 19, 16, 16, 15, 16, 15, 10, 10, 14, 13, 18, 19, 20, 22, 22, 21, 22, 22, 18, 19, 18, 19, 19, 19, 18, 18, 17, 17, 18, 17, 19, 17, 22, 21, 34, 13, 12, 19, 10, 9, 25, 11, 17, 15, 16, 17, 15, 7, 9, 8, 8, 10, 14, 7, 16, 7, 16, 18, 11, 19, 12, 15, 16, 21, 16, 17, 16, 17, 17};
                break;
            }
            case 28: {
                fontCharsWidth = new short[]{15, 15, 14, 16, 13, 13, 16, 15, 7, 10, 15, 13, 19, 15, 17, 14, 19, 14, 14, 15, 15, 17, 22, 16, 15, 14, 16, 15, 17, 16, 17, 16, 15, 15, 16, 13, 13, 13, 13, 13, 8, 9, 12, 10, 15, 15, 16, 18, 18, 17, 18, 18, 15, 15, 15, 14, 15, 16, 14, 15, 14, 14, 14, 14, 15, 14, 18, 18, 27, 10, 10, 16, 8, 9, 21, 10, 14, 13, 13, 14, 12, 7, 7, 7, 8, 9, 10, 6, 12, 7, 13, 14, 9, 15, 10, 14, 13, 16, 13, 14, 14, 14, 14};
                break;
            }
            case 25: {
                fontCharsWidth = new short[]{13, 12, 12, 14, 11, 11, 14, 13, 5, 8, 13, 11, 16, 13, 15, 12, 16, 12, 12, 12, 12, 14, 19, 13, 13, 12, 13, 14, 14, 14, 14, 14, 12, 12, 13, 11, 11, 11, 10, 11, 7, 7, 10, 8, 12, 13, 13, 15, 15, 15, 15, 15, 13, 13, 13, 13, 13, 13, 12, 13, 11, 12, 12, 12, 13, 11, 16, 14, 22, 9, 8, 13, 7, 7, 17, 8, 12, 10, 11, 12, 10, 5, 6, 5, 6, 7, 10, 5, 11, 5, 11, 13, 8, 12, 8, 11, 11, 13, 11, 12, 11, 12, 11};
                break;
            }
            case 19: {
                fontCharsWidth = new short[]{10, 9, 9, 10, 8, 9, 10, 10, 4, 7, 10, 8, 12, 10, 12, 9, 12, 10, 9, 10, 10, 10, 15, 10, 10, 9, 11, 10, 11, 10, 11, 10, 9, 9, 10, 9, 9, 8, 8, 8, 5, 6, 7, 6, 9, 10, 10, 11, 11, 12, 12, 11, 10, 10, 9, 10, 10, 10, 9, 9, 8, 9, 9, 9, 10, 9, 12, 11, 17, 6, 6, 10, 6, 5, 13, 6, 9, 8, 8, 9, 8, 4, 5, 4, 5, 5, 7, 4, 8, 4, 9, 9, 6, 9, 7, 9, 9, 10, 9, 9, 9, 9, 9};
                break;
            }
            case 13: {
                fontCharsWidth = new short[]{5, 5, 5, 5, 5, 5, 5, 5, 1, 5, 5, 4, 7, 5, 5, 5, 5, 5, 5, 5, 5, 5, 7, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 2, 2, 3, 3, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 7, 4, 4, 6, 3, 3, 7, 3, 5, 5, 5, 4, 5, 1, 2, 1, 2, 2, 4, 1, 5, 1, 5, 6, 4, 5, 2, 5, 5, 5, 5, 5, 5, 5, 5};
                break;
            }
            case 10: {
                fontCharsWidth = new short[]{4, 4, 4, 4, 3, 3, 4, 4, 1, 4, 4, 3, 5, 4, 4, 4, 4, 4, 4, 3, 4, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 2, 2, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 5, 4, 4, 5, 5, 5, 5, 4, 4, 5, 2, 2, 5, 3, 5, 3, 3, 5, 3, 1, 1, 1, 1, 2, 3, 1, 4, 1, 3, 3, 3, 4, 2, 4, 4, 4, 4, 4, 4, 4, 4};
                break;
            }
            default: {
                System.out.println("1d error");
            }
        }
        return new GFont(gFontImg, _fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[0]);
    }

    private static GFont createGFontAzure(Image gFontImg) {
        char[] _fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u011a', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u00dd', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u00df', '$', '#', '&', '@', '\\', '/', '\u20ac', '(', ')', '%', '\u00b0', '+', '=', '\u00f7', '~', '^', '.', ',', ':', ';', '`', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 1;
        switch (gFontImg.getHeight()) {
            case 38: {
                fontCharsWidth = new short[]{20, 18, 18, 20, 16, 15, 20, 19, 7, 12, 18, 15, 24, 19, 21, 18, 23, 18, 17, 18, 19, 21, 27, 19, 19, 17, 21, 20, 20, 21, 21, 20, 18, 17, 19, 16, 16, 15, 16, 15, 10, 10, 14, 13, 18, 19, 20, 22, 22, 21, 22, 22, 18, 19, 18, 19, 19, 19, 18, 18, 17, 17, 18, 17, 19, 17, 22, 21, 34, 13, 12, 19, 10, 9, 25, 11, 17, 15, 16, 17, 15, 7, 9, 8, 8, 10, 14, 7, 16, 7, 16, 18, 11, 19, 12, 15, 16, 21, 16, 17, 16, 17, 17};
                break;
            }
            case 28: {
                fontCharsWidth = new short[]{15, 15, 14, 16, 13, 13, 16, 15, 7, 10, 15, 13, 19, 15, 17, 14, 19, 14, 14, 15, 15, 17, 22, 16, 15, 14, 16, 15, 17, 16, 17, 16, 15, 15, 16, 13, 13, 13, 13, 13, 8, 9, 12, 10, 15, 15, 16, 18, 18, 17, 18, 18, 15, 15, 15, 14, 15, 16, 14, 15, 14, 14, 14, 14, 15, 14, 18, 18, 27, 10, 10, 16, 8, 9, 21, 10, 14, 12, 13, 14, 12, 6, 7, 7, 8, 9, 10, 6, 12, 7, 13, 14, 9, 15, 10, 14, 13, 16, 13, 14, 14, 14, 14};
                break;
            }
            case 25: {
                fontCharsWidth = new short[]{13, 12, 12, 14, 11, 11, 14, 13, 5, 8, 13, 11, 16, 13, 15, 12, 16, 12, 12, 12, 12, 14, 19, 13, 13, 12, 13, 14, 14, 14, 14, 14, 12, 12, 13, 11, 11, 11, 10, 11, 7, 7, 10, 8, 12, 13, 13, 15, 15, 15, 15, 15, 13, 13, 13, 13, 13, 13, 12, 13, 11, 12, 12, 12, 13, 11, 16, 14, 22, 9, 8, 13, 7, 7, 17, 8, 12, 10, 11, 12, 10, 5, 6, 5, 6, 7, 10, 5, 11, 5, 11, 13, 8, 12, 8, 11, 11, 13, 11, 12, 11, 12, 11};
                break;
            }
            case 19: {
                fontCharsWidth = new short[]{10, 9, 9, 10, 8, 9, 10, 10, 4, 7, 10, 8, 12, 10, 12, 9, 12, 10, 9, 10, 10, 10, 15, 10, 10, 9, 11, 10, 11, 10, 11, 10, 9, 9, 10, 9, 9, 8, 8, 8, 5, 6, 7, 6, 9, 10, 10, 11, 11, 12, 12, 11, 10, 10, 9, 10, 10, 10, 9, 9, 8, 9, 9, 9, 10, 9, 12, 11, 17, 6, 6, 10, 6, 5, 13, 6, 9, 8, 8, 9, 8, 4, 5, 4, 5, 5, 7, 4, 8, 4, 9, 9, 6, 9, 7, 9, 9, 10, 9, 9, 9, 9, 9};
                break;
            }
            case 13: {
                fontCharsWidth = new short[]{5, 5, 5, 5, 5, 5, 5, 5, 1, 5, 5, 4, 7, 5, 5, 5, 5, 5, 5, 5, 5, 5, 7, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 2, 2, 3, 3, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 7, 4, 4, 6, 3, 3, 7, 3, 5, 5, 5, 4, 5, 1, 2, 1, 2, 2, 4, 1, 5, 1, 5, 6, 4, 5, 2, 5, 5, 5, 5, 5, 5, 5, 5};
                break;
            }
            case 10: {
                fontCharsWidth = new short[]{4, 4, 4, 4, 3, 3, 4, 4, 1, 4, 4, 3, 5, 4, 4, 4, 4, 4, 4, 3, 4, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 2, 2, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 5, 4, 4, 5, 5, 5, 5, 4, 4, 5, 2, 2, 5, 3, 5, 3, 3, 5, 3, 1, 1, 1, 1, 2, 3, 1, 4, 1, 3, 3, 3, 4, 2, 4, 4, 4, 4, 4, 4, 4, 4};
                break;
            }
            default: {
                System.out.println("2d error");
            }
        }
        return new GFont(gFontImg, _fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[0]);
    }

    private static GFont createGFontMud(Image gFontImg) {
        char[] _fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u011a', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u00dd', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u00df', '$', '#', '&', '@', '\\', '/', '\u20ac', '(', ')', '%', '\u00b0', '+', '=', '\u00f7', '~', '^', '.', ',', ':', ';', '`', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 1;
        switch (gFontImg.getHeight()) {
            case 31: {
                fontCharsWidth = new short[]{17, 15, 15, 17, 14, 14, 17, 16, 6, 10, 16, 13, 20, 16, 18, 15, 20, 15, 14, 16, 16, 18, 24, 16, 16, 15, 17, 17, 18, 18, 18, 18, 15, 16, 16, 13, 14, 13, 13, 14, 8, 9, 12, 11, 16, 16, 16, 19, 19, 18, 19, 19, 16, 16, 17, 16, 16, 17, 16, 15, 14, 14, 16, 14, 17, 15, 19, 18, 28, 11, 11, 16, 8, 8, 21, 10, 15, 13, 14, 14, 13, 7, 7, 7, 8, 8, 12, 6, 13, 6, 13, 15, 9, 16, 10, 14, 14, 17, 14, 15, 14, 15, 14};
                break;
            }
            case 23: {
                fontCharsWidth = new short[]{13, 12, 12, 13, 10, 10, 13, 13, 4, 8, 12, 10, 15, 12, 14, 11, 15, 12, 11, 12, 12, 14, 18, 13, 13, 12, 13, 14, 13, 13, 14, 13, 12, 12, 13, 10, 11, 10, 11, 10, 7, 7, 10, 8, 12, 12, 12, 14, 15, 15, 15, 15, 12, 12, 12, 12, 12, 13, 12, 12, 11, 11, 11, 11, 12, 11, 15, 14, 21, 9, 8, 12, 6, 6, 16, 8, 11, 10, 10, 10, 9, 5, 6, 5, 6, 7, 9, 5, 11, 5, 10, 12, 7, 12, 8, 11, 11, 13, 11, 12, 10, 11, 12};
                break;
            }
            case 20: {
                fontCharsWidth = new short[]{11, 10, 11, 12, 10, 10, 12, 11, 5, 7, 11, 9, 14, 11, 13, 10, 14, 10, 10, 10, 11, 12, 16, 12, 11, 10, 12, 12, 12, 12, 12, 12, 11, 10, 11, 9, 10, 9, 9, 9, 6, 6, 9, 8, 10, 12, 11, 13, 13, 13, 12, 12, 11, 11, 11, 11, 11, 11, 10, 10, 10, 10, 10, 10, 11, 10, 13, 12, 20, 8, 7, 11, 6, 6, 15, 7, 10, 9, 10, 9, 9, 4, 6, 5, 6, 6, 8, 4, 9, 5, 9, 10, 7, 11, 7, 9, 9, 12, 9, 10, 9, 10, 10};
                break;
            }
            case 15: {
                fontCharsWidth = new short[]{9, 8, 8, 9, 7, 7, 9, 9, 3, 6, 9, 6, 11, 9, 10, 8, 10, 8, 7, 8, 9, 10, 12, 9, 9, 8, 10, 9, 9, 9, 9, 9, 8, 8, 8, 7, 7, 7, 7, 7, 5, 5, 6, 6, 8, 9, 9, 10, 10, 10, 10, 10, 9, 9, 9, 8, 8, 9, 8, 8, 8, 8, 8, 8, 8, 8, 10, 10, 14, 6, 5, 9, 4, 5, 11, 6, 8, 7, 8, 8, 7, 3, 5, 4, 4, 4, 6, 4, 7, 4, 7, 9, 5, 8, 5, 8, 8, 9, 7, 8, 7, 8, 8};
                break;
            }
            case 10: {
                fontCharsWidth = new short[]{4, 4, 4, 4, 3, 3, 4, 4, 1, 4, 4, 3, 5, 4, 4, 4, 4, 4, 4, 3, 4, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 2, 2, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 5, 4, 4, 5, 5, 5, 5, 4, 4, 5, 2, 2, 5, 3, 5, 3, 3, 5, 3, 1, 1, 1, 1, 2, 3, 1, 4, 1, 3, 3, 3, 4, 2, 4, 4, 4, 4, 4, 4, 4, 4};
                break;
            }
            default: {
                System.out.println("3d error");
            }
        }
        return new GFont(gFontImg, _fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[0]);
    }

    private static GFont createGFontNumbersMud(Image gFontImg) {
        char[] _fontChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 1;
        switch (gFontImg.getHeight()) {
            case 34: {
                fontCharsWidth = new short[]{24, 24, 24, 24, 24, 24, 24, 24, 24, 24};
                break;
            }
            case 25: {
                fontCharsWidth = new short[]{18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
                break;
            }
            case 23: {
                fontCharsWidth = new short[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
                break;
            }
            case 17: {
                fontCharsWidth = new short[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
                break;
            }
            case 13: {
                fontCharsWidth = new short[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
                break;
            }
            case 10: {
                fontCharsWidth = new short[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
                break;
            }
            default: {
                System.out.println("NB error");
            }
        }
        return new GFont(gFontImg, _fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[0]);
    }

    private static GFont createGFontNumbersBlack(Image gFontImg) {
        char[] _fontChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', '-'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 25: {
                fontCharsWidth = new short[]{17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
                break;
            }
            case 19: {
                fontCharsWidth = new short[]{13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
                break;
            }
            case 16: {
                fontCharsWidth = new short[]{11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11};
                break;
            }
            case 13: {
                fontCharsWidth = new short[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
                break;
            }
            case 10: {
                fontCharsWidth = new short[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
                break;
            }
            case 5: {
                fontCharsWidth = new short[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
                break;
            }
            default: {
                System.out.println("NS error");
            }
        }
        return new GFont(gFontImg, _fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[0]);
    }

    public static void loadGFont(byte gFontIdx) {
        Image gFontImg = null;
        if (resGFonts[gFontIdx] != null) {
            return;
        }
        switch (gFontIdx) {
            case 0: {
                gFontImg = Resources.createImage(graphicsBaseDir + "font_1_d.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontWhite(gFontImg);
                break;
            }
            case 1: {
                gFontImg = Resources.createImage(graphicsBaseDir + "font_2_d.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontAzure(gFontImg);
                break;
            }
            case 2: {
                gFontImg = Resources.createImage(graphicsBaseDir + "font_3_d.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMud(gFontImg);
                break;
            }
            case 3: {
                gFontImg = Resources.createImage(graphicsBaseDir + "number_big.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontNumbersMud(gFontImg);
                break;
            }
            case 4: {
                gFontImg = Resources.createImage(graphicsBaseDir + "number_small.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontNumbersBlack(gFontImg);
                break;
            }
        }
    }

    public static void freeGFont(byte gFontIdx) {
        Resources.resGFonts[gFontIdx] = null;
    }

    public static void loadGFonts(byte[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; i = (int)((byte)(i + 1))) {
            Resources.loadGFont(gFontsIdx[i]);
        }
    }

    public static void freeGFonts(byte[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; i = (int)((byte)(i + 1))) {
            Resources.resGFonts[gFontsIdx[i]] = null;
        }
    }

    public static void initLangDirs(String langCode) {
        if (langCode.equals("fr")) {
            MainCanvas.languageFR = true;
        }
        langDir = "/lang/" + langCode + "/";
        if (langCode == "ru" || langCode == "cn") {
            sysFont = true;
        }
    }

    public static void loadText(byte textIdx) {
        String textPath = null;
        switch (textIdx) {
            case 0: {
                textPath = langDir + "m.csr";
            }
        }
        Resources.resTexts[textIdx] = new ResourceBundle(X.singleton, textPath);
    }

    public static void freeText(byte textIdx) {
        Resources.resTexts[textIdx] = null;
    }

    static {
        widht = 0;
    }
}

