/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class MenuScreen
extends Canvas
implements CommandListener {
    public String[] str = new String[]{"New Game", "OK", "Continue", "High Scores", "Instructions", "Settings", "Quit", "Difficulty", "Balls", "Beginner", "Intermediate", "Game addict", "Guru", "God", "You got a high score", "Catch the balls by moving your hands left and right. ", "Press 4 to move left, 6 to move right.", "Press 0 to pause.", "Game Over", "Paused", "Your name", "Back", "About"};
    public static final byte MODE_MENU = 1;
    private byte mode;
    private Command quitComm;
    private Command backComm;
    private Command okComm;
    private Command continueGameComm;
    private Command newGameComm;
    private Command instructionsComm;
    private Command highScoresComm;
    private Command settingsComm;
    private Command aboutComm;
    private Form highScoresForm;
    private Form instructionsForm;
    private Form settingsForm;
    private Form aboutForm;
    public Form nameForm;
    private TextField nameField;
    public ChoiceGroup balls;
    public ChoiceGroup difficulty;
    public HighScores hs;
    private String[] ballStrings = new String[]{"2", "3"};
    private String[] difficultyStrings = new String[]{this.str[9], this.str[10], this.str[11], this.str[12], this.str[13]};
    public GameScreen gameScreen;
    private Image splashScreen;

    public MenuScreen() {
        this.setCommandListener(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        LanguageLoader ll = new LanguageLoader();
        String[] tmp = ll.ReadLangFile(23);
        if (tmp != null) {
            this.str = tmp;
        }
        this.difficultyStrings[0] = this.str[9];
        this.difficultyStrings[1] = this.str[10];
        this.difficultyStrings[2] = this.str[11];
        this.difficultyStrings[3] = this.str[12];
        this.difficultyStrings[4] = this.str[13];
        this.gameScreen = new GameScreen(this);
        this.splashScreen = GameMidlet.getImage("splash2.png");
        this.quitComm = new Command(this.str[6], 6, 10);
        this.backComm = new Command(this.str[21], 2, 1);
        this.okComm = new Command(this.str[1], 4, 1);
        this.continueGameComm = new Command(this.str[2], 1, 2);
        this.newGameComm = new Command(this.str[0], 1, 3);
        this.settingsComm = new Command(this.str[5], 1, 4);
        this.instructionsComm = new Command(this.str[4], 1, 5);
        this.highScoresComm = new Command(this.str[3], 1, 6);
        this.aboutComm = new Command(this.str[22], 1, 7);
        this.aboutForm = new Form(this.str[22]);
        this.aboutForm.append("Version: 1.11.12\nCopyright: Tracebit Ltd");
        this.aboutForm.addCommand(this.backComm);
        this.aboutForm.setCommandListener((CommandListener)this);
        this.highScoresForm = new Form(this.str[3]);
        this.highScoresForm.addCommand(this.backComm);
        this.highScoresForm.setCommandListener((CommandListener)this);
        this.hs = HighScores.loadHighScores();
        this.settingsForm = new Form(this.str[5]);
        this.balls = new ChoiceGroup(this.str[8], 1, this.ballStrings, null);
        this.difficulty = new ChoiceGroup(this.str[7], 1, this.difficultyStrings, null);
        this.settingsForm.append((Item)this.balls);
        this.settingsForm.append((Item)this.difficulty);
        this.settingsForm.addCommand(this.backComm);
        this.settingsForm.setCommandListener((CommandListener)this);
        this.nameForm = new Form(this.str[14]);
        this.nameField = new TextField(this.str[20], "", 10, 0);
        this.nameForm.append((Item)this.nameField);
        this.nameForm.addCommand(this.okComm);
        this.nameForm.setCommandListener((CommandListener)this);
        this.instructionsForm = new Form(this.str[4]);
        this.instructionsForm.append(this.str[15]);
        this.instructionsForm.append(String.valueOf(String.valueOf(this.str[16])).concat(String.valueOf(String.valueOf(this.str[17]))));
        this.instructionsForm.addCommand(this.backComm);
        this.instructionsForm.setCommandListener((CommandListener)this);
    }

    public void commandAction(Command c, Displayable d) {
        if (c.getCommandType() == 6) {
            GameMidlet.quitApp();
        } else if (c == this.continueGameComm) {
            this.continueGame();
        } else if (c == this.newGameComm) {
            this.newGame();
        } else if (c == this.instructionsComm) {
            this.showInstructions();
        } else if (c == this.aboutComm) {
            this.showAbout();
        } else if (c == this.settingsComm) {
            this.showSettings();
        } else if (c == this.highScoresComm) {
            this.showHighScores();
        } else if (c == this.backComm) {
            if (d == this.highScoresForm || d == this.instructionsForm || d == this.settingsForm || d == this.aboutForm) {
                this.showMenu();
            }
        } else if (c == this.okComm && d == this.nameForm) {
            this.hs.setHighScore(this.gameScreen.points, this.nameField.getString());
            this.showHighScores();
        }
    }

    public void showMenu() {
        this.removeCommand(this.okComm);
        this.removeCommand(this.backComm);
        this.addCommand(this.aboutComm);
        this.addCommand(this.quitComm);
        if (GameMidlet.gameRunning) {
            this.addCommand(this.continueGameComm);
        } else {
            this.removeCommand(this.continueGameComm);
        }
        this.addCommand(this.newGameComm);
        this.addCommand(this.settingsComm);
        this.addCommand(this.instructionsComm);
        this.addCommand(this.highScoresComm);
        this.mode = 1;
        GameMidlet.instance.setDisplayable((Displayable)this);
    }

    public void showAbout() {
        GameMidlet.instance.setDisplayable((Displayable)this.aboutForm);
    }

    public void showInstructions() {
        GameMidlet.instance.setDisplayable((Displayable)this.instructionsForm);
    }

    public void showSettings() {
        GameMidlet.instance.setDisplayable((Displayable)this.settingsForm);
    }

    public void showHighScores() {
        int i;
        for (i = this.highScoresForm.size(); i > 0; --i) {
            this.highScoresForm.delete(0);
        }
        for (i = 0; i < 10; ++i) {
            this.highScoresForm.append(String.valueOf(String.valueOf(new StringBuffer("").append(i + 1).append(". ").append(this.hs.getScore(i)).append(" ").append(this.hs.getName(i)).append('\r').append('\n'))));
        }
        GameMidlet.instance.setDisplayable((Displayable)this.highScoresForm);
    }

    public void newGame() {
        GameMidlet.gameRunning = false;
        SingleItemDB.delete("GameData");
        GameMidlet.instance.setDisplayable((Displayable)this.gameScreen);
    }

    public void continueGame() {
        GameMidlet.instance.setDisplayable((Displayable)this.gameScreen);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    protected void paint(Graphics g) {
        this.renderMenuMode(g);
    }

    private void renderMenuMode(Graphics g) {
        int drawWidth = this.getWidth();
        int drawHeight = this.getHeight();
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, drawWidth, drawHeight);
        g.drawImage(this.splashScreen, drawWidth / 2, drawHeight / 2, 3);
    }

    public void cleanUp() {
    }

    static {
        MODE_MENU = 1;
    }
}

