/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DeviceControl;
import com.nokia.mid.ui.FullCanvas;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameScreen
extends FullCanvas {
    private Sound catchSound;
    private Sound dropSound;
    private MenuScreen menuScreen;
    private Timer frameUpdateTimer;
    private Timer EngineTimer;
    private int frameRate = 20;
    private FrameUpdateTask frameUpdateTask;
    Image ball;
    Image hand1;
    Image hand2;
    Image hand3;
    Image crash1;
    Image crash2;
    Image crashIcon;
    byte[] ball1PositionsX = new byte[]{3, 7, 14, 23, 34, 46, 60, 74, 87, 97, 105, 109};
    byte[] ball1PositionsY = new byte[]{56, 43, 31, 19, 9, 3, 2, 6, 15, 28, 41, 55};
    byte[] ball2PositionsX = new byte[]{16, 19, 26, 36, 47, 61, 74, 85, 93, 97};
    byte[] ball2PositionsY = new byte[]{55, 43, 31, 20, 13, 12, 18, 30, 43, 55};
    byte[] ball3PositionsX = new byte[]{27, 32, 38, 49, 61, 72, 80, 85};
    byte[] ball3PositionsY = new byte[]{55, 43, 31, 23, 22, 30, 43, 56};
    private boolean startingthread = false;
    private boolean isrunning = false;
    private boolean gameOver = false;
    private long pos0Time;
    private long pos1Time;
    private long pos2Time;
    private byte ballCount = (byte)3;
    private byte ball1Pos;
    private byte ball2Pos;
    private byte ball3Pos;
    private byte ball1Dir;
    private byte ball2Dir;
    private byte ball3Dir;
    private byte handPos;
    private int gameSpeed;
    private byte crashes;
    public int points;
    private boolean crashDetected;
    private boolean gameStarting;
    private boolean gameReStarting;
    private int ballsPlayed;
    private int oldBallsPlayed;
    HiScoreTask hiscoreTask;
    public Image wheel1;
    public Image wheel2;
    public Image wheel3;
    private int wheelpos = 0;
    private EThread EngineThread;

    public GameScreen(MenuScreen ms) {
        this.menuScreen = ms;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startFrameUpdate() {
        if (!this.startingthread) {
            this.startingthread = true;
            if (this.frameUpdateTimer == null) {
                this.frameUpdateTimer = new Timer();
            }
            if (this.EngineTimer == null) {
                this.EngineTimer = new Timer();
            }
            try {
                if (this.frameUpdateTask != null) {
                    this.frameUpdateTask.cancel();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.EngineThread != null) {
                    this.EngineThread.cancel();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.EngineThread = new EThread();
            this.isrunning = true;
            this.gameOver = false;
            this.EngineTimer.schedule((TimerTask)this.EngineThread, 0L, (long)this.gameSpeed);
            this.frameUpdateTask = new FrameUpdateTask();
            this.frameUpdateTimer.schedule((TimerTask)this.frameUpdateTask, 0L, (long)(1000 / this.frameRate));
            this.startingthread = false;
        }
    }

    private void stopFrameUpdate() {
        this.frameUpdateTask.cancel();
    }

    private void jbInit() throws Exception {
        this.wheel1 = GameMidlet.getImage("background.png");
        this.ball = GameMidlet.getImage("ball.png");
        this.hand1 = GameMidlet.getImage("hand1.png");
        this.hand2 = GameMidlet.getImage("hand2.png");
        this.hand3 = GameMidlet.getImage("hand3.png");
        this.crash1 = GameMidlet.getImage("crashleft.png");
        this.crash2 = GameMidlet.getImage("crashright.png");
        this.crashIcon = GameMidlet.getImage("crashicon.png");
        this.catchSound = new Sound(880, 100L);
        this.dropSound = new Sound(440, 600L);
    }

    public void showNotify() {
        this.startFrameUpdate();
    }

    public void hideNotify() {
        this.stopFrameUpdate();
    }

    public void keyPressed(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        switch (this.handPos) {
            case 0: {
                this.pos0Time = System.currentTimeMillis();
                break;
            }
            case 1: {
                this.pos1Time = System.currentTimeMillis();
                break;
            }
            case 2: {
                this.pos2Time = System.currentTimeMillis();
            }
        }
        switch (gameAction) {
            case 2: {
                if (this.handPos <= 0) break;
                this.handPos = (byte)(this.handPos - 1);
                break;
            }
            case 5: {
                if (this.handPos >= 2) break;
                this.handPos = (byte)(this.handPos + 1);
                break;
            }
            default: {
                this.isrunning = false;
                if (!this.gameOver) {
                    this.saveGame();
                }
                this.menuScreen.showMenu();
            }
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    protected void paint(Graphics g) {
        g.translate(0 - g.getTranslateX(), 0 - g.getTranslateY());
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.translate((this.getWidth() - 120) / 2, (this.getHeight() - 96) / 2);
        int drawWidth = 120;
        int drawHeight = 96;
        g.setColor(0, 0, 0);
        g.drawImage(this.wheel1, 0, 0, 20);
        switch (this.handPos) {
            case 0: {
                g.drawImage(this.hand1, 0, 0, 20);
                break;
            }
            case 1: {
                g.drawImage(this.hand2, 0, 0, 20);
                break;
            }
            case 2: {
                g.drawImage(this.hand3, 0, 0, 20);
            }
        }
        g.drawString(String.valueOf(this.points), drawWidth, 0, 24);
        if (this.ball1Pos == -1) {
            g.drawImage(this.crash1, 6, 79, 20);
        } else if (this.ball1Pos == 12) {
            g.drawImage(this.crash2, 92, 79, 20);
        } else {
            g.drawImage(this.ball, (int)this.ball1PositionsX[this.ball1Pos], (int)this.ball1PositionsY[this.ball1Pos], 20);
        }
        if (this.ball2Pos == -1) {
            g.drawImage(this.crash1, 6, 79, 20);
        } else if (this.ball2Pos == 10) {
            g.drawImage(this.crash2, 92, 79, 20);
        } else {
            g.drawImage(this.ball, (int)this.ball2PositionsX[this.ball2Pos], (int)this.ball2PositionsY[this.ball2Pos], 20);
        }
        if (this.ball3Pos == -1) {
            g.drawImage(this.crash1, 6, 79, 20);
        } else if (this.ball3Pos == 8) {
            g.drawImage(this.crash2, 92, 79, 20);
        } else if (this.ball3Pos >= 0) {
            g.drawImage(this.ball, (int)this.ball3PositionsX[this.ball3Pos], (int)this.ball3PositionsY[this.ball3Pos], 20);
        }
        if (this.crashes > 0) {
            g.drawImage(this.crashIcon, 0, 0, 20);
        }
        if (this.crashes > 1) {
            g.drawImage(this.crashIcon, 8, 0, 20);
        }
        if (this.crashes > 2) {
            g.drawImage(this.crashIcon, 17, 0, 20);
        }
        if (this.gameOver) {
            g.drawString("GAME OVER", drawWidth / 2, 20, 65);
            this.frameUpdateTask.cancel();
            return;
        }
    }

    private void saveGame() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeByte(this.ballCount);
            dout.writeByte(this.ball1Pos);
            dout.writeByte(this.ball2Pos);
            dout.writeByte(this.ball3Pos);
            dout.writeByte(this.ball1Dir);
            dout.writeByte(this.ball2Dir);
            dout.writeByte(this.ball3Dir);
            dout.writeByte(this.handPos);
            dout.writeInt(this.gameSpeed);
            dout.writeByte(this.crashes);
            dout.writeInt(this.points);
            dout.writeBoolean(this.crashDetected);
            GameMidlet.saveGameData = bout.toByteArray();
            SingleItemDB.save("GameData", GameMidlet.saveGameData);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void cleanUp() {
        if (this.frameUpdateTimer != null) {
            this.frameUpdateTimer.cancel();
        }
    }

    private class HiScoreTask
    extends TimerTask {
        private HiScoreTask() {
        }

        public void run() {
            if (((GameScreen)GameScreen.this).menuScreen.hs.isHighScore(GameScreen.this.points)) {
                GameMidlet.instance.setDisplayable((Displayable)((GameScreen)GameScreen.this).menuScreen.nameForm);
            }
        }
    }

    class EThread
    extends TimerTask {
        private Random random = new Random();
        long timenow = 0L;
        int caught = 0;
        int oldpoints = 0;
        int sleeptimer = 0;

        EThread() {
            GameScreen.this.gameStarting = true;
            if (!GameMidlet.gameRunning) {
                GameScreen.this.ballCount = (byte)(((GameScreen)GameScreen.this).menuScreen.balls.getSelectedIndex() + 2);
                switch (((GameScreen)GameScreen.this).menuScreen.difficulty.getSelectedIndex()) {
                    case 0: {
                        GameScreen.this.gameSpeed = 120 * GameScreen.this.ballCount;
                        break;
                    }
                    case 1: {
                        GameScreen.this.gameSpeed = 80 * GameScreen.this.ballCount;
                        break;
                    }
                    case 2: {
                        GameScreen.this.gameSpeed = 50 * GameScreen.this.ballCount;
                        break;
                    }
                    case 3: {
                        GameScreen.this.gameSpeed = 40 * GameScreen.this.ballCount;
                        break;
                    }
                    case 4: {
                        GameScreen.this.gameSpeed = 30 * GameScreen.this.ballCount;
                    }
                }
                GameScreen.this.ball1Pos = (byte)2;
                GameScreen.this.ball2Pos = (byte)2;
                if (GameScreen.this.ballCount == 2) {
                    GameScreen.this.ball3Pos = (byte)-2;
                } else {
                    GameScreen.this.ball3Pos = (byte)1;
                }
                GameScreen.this.ball1Dir = (byte)1;
                GameScreen.this.ball2Dir = (byte)1;
                GameScreen.this.ball3Dir = (byte)1;
                GameScreen.this.handPos = (byte)1;
                GameScreen.this.crashes = (byte)0;
                GameScreen.this.points = 0;
                GameScreen.this.crashDetected = false;
                GameScreen.this.pos0Time = 0L;
                GameScreen.this.pos1Time = System.currentTimeMillis();
                GameScreen.this.pos2Time = 0L;
                GameScreen.this.ballsPlayed = 0;
                GameScreen.this.oldBallsPlayed = 0;
            } else {
                GameMidlet.saveGameData = SingleItemDB.load("GameData");
                if (GameMidlet.saveGameData != null) {
                    try {
                        ByteArrayInputStream bin = new ByteArrayInputStream(GameMidlet.saveGameData);
                        DataInputStream din = new DataInputStream(bin);
                        GameScreen.this.ballCount = din.readByte();
                        GameScreen.this.ball1Pos = din.readByte();
                        GameScreen.this.ball2Pos = din.readByte();
                        GameScreen.this.ball3Pos = din.readByte();
                        GameScreen.this.ball1Dir = din.readByte();
                        GameScreen.this.ball2Dir = din.readByte();
                        GameScreen.this.ball3Dir = din.readByte();
                        GameScreen.this.handPos = din.readByte();
                        GameScreen.this.gameSpeed = din.readInt();
                        GameScreen.this.crashes = din.readByte();
                        GameScreen.this.points = din.readInt();
                        GameScreen.this.crashDetected = din.readBoolean();
                        GameScreen.this.ballsPlayed = din.readInt();
                        GameScreen.this.oldBallsPlayed = GameScreen.this.ballsPlayed;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            GameMidlet.gameRunning = true;
            SingleItemDB.delete("GameData");
        }

        public void run() {
            block19: {
                try {
                    if (!GameScreen.this.isrunning || GameScreen.this.gameOver) break block19;
                    if ((GameScreen.this.gameStarting || GameScreen.this.gameReStarting) && this.sleeptimer < 4) {
                        ++this.sleeptimer;
                        GameScreen.this.gameReStarting = true;
                        return;
                    }
                    if (GameScreen.this.gameStarting) {
                        GameScreen.this.gameStarting = false;
                        this.sleeptimer = 0;
                        GameScreen.this.gameReStarting = false;
                    }
                    if (GameScreen.this.crashDetected) {
                        ++this.sleeptimer;
                        if (this.sleeptimer < 5) {
                            return;
                        }
                        GameScreen.this.ball1Pos = (byte)2;
                        GameScreen.this.ball2Pos = (byte)2;
                        if (GameScreen.this.ballCount == 3) {
                            GameScreen.this.ball3Pos = (byte)1;
                        }
                        GameScreen.this.ball1Dir = (byte)1;
                        GameScreen.this.ball2Dir = (byte)1;
                        GameScreen.this.ball3Dir = (byte)1;
                        GameScreen.this.crashDetected = false;
                        this.sleeptimer = 0;
                        return;
                    }
                    GameScreen.this.ball1Pos = (byte)(GameScreen.this.ball1Pos + GameScreen.this.ball1Dir);
                    GameScreen.this.ball2Pos = (byte)(GameScreen.this.ball2Pos + GameScreen.this.ball2Dir);
                    if (GameScreen.this.ballCount == 3) {
                        GameScreen.this.ball3Pos = (byte)(GameScreen.this.ball3Pos + GameScreen.this.ball3Dir);
                    }
                    this.timenow = System.currentTimeMillis();
                    if (GameScreen.this.ball1Pos == 12 && (GameScreen.this.handPos == 2 || this.timenow - GameScreen.this.pos2Time < (long)GameScreen.this.gameSpeed)) {
                        GameScreen.this.ball1Pos = (byte)10;
                        GameScreen.this.ball1Dir = (byte)-1;
                        ++this.caught;
                    }
                    if (GameScreen.this.ball1Pos == -1 && (GameScreen.this.handPos == 0 || this.timenow - GameScreen.this.pos0Time < (long)GameScreen.this.gameSpeed)) {
                        GameScreen.this.ball1Pos = (byte)1;
                        GameScreen.this.ball1Dir = (byte)1;
                        ++this.caught;
                    }
                    if (GameScreen.this.ball2Pos == 10 && (GameScreen.this.handPos == 1 || this.timenow - GameScreen.this.pos1Time < (long)GameScreen.this.gameSpeed)) {
                        GameScreen.this.ball2Pos = (byte)8;
                        GameScreen.this.ball2Dir = (byte)-1;
                        ++this.caught;
                    }
                    if (GameScreen.this.ball2Pos == -1 && (GameScreen.this.handPos == 1 || this.timenow - GameScreen.this.pos1Time < (long)GameScreen.this.gameSpeed)) {
                        GameScreen.this.ball2Pos = (byte)1;
                        GameScreen.this.ball2Dir = (byte)1;
                        ++this.caught;
                    }
                    if (GameScreen.this.ball3Pos == 8 && (GameScreen.this.handPos == 0 || this.timenow - GameScreen.this.pos0Time < (long)GameScreen.this.gameSpeed)) {
                        GameScreen.this.ball3Pos = (byte)6;
                        GameScreen.this.ball3Dir = (byte)-1;
                        ++this.caught;
                    }
                    if (GameScreen.this.ball3Pos == -1 && (GameScreen.this.handPos == 2 || this.timenow - GameScreen.this.pos2Time < (long)GameScreen.this.gameSpeed)) {
                        GameScreen.this.ball3Pos = (byte)1;
                        GameScreen.this.ball3Dir = (byte)1;
                        ++this.caught;
                    }
                    if (this.caught > 0) {
                        GameScreen.this.catchSound.play(1);
                        GameScreen.this.oldBallsPlayed = GameScreen.this.ballsPlayed;
                        GameScreen.this.points += this.caught * (300 / GameScreen.this.gameSpeed) * (((GameScreen)GameScreen.this).menuScreen.difficulty.getSelectedIndex() + 1) / 2 + 1;
                        GameScreen.this.ballsPlayed += this.caught;
                        this.caught = 0;
                        if (GameScreen.this.ballsPlayed / 20 != GameScreen.this.oldBallsPlayed / 20) {
                            GameScreen.this.gameSpeed = GameScreen.this.gameSpeed * 19 / 20;
                        }
                    }
                    if (GameScreen.this.ball1Pos != -1 && GameScreen.this.ball2Pos != -1 && GameScreen.this.ball3Pos != -1 && GameScreen.this.ball1Pos != 12 && GameScreen.this.ball2Pos != 10 && GameScreen.this.ball3Pos != 8) break block19;
                    GameScreen.this.dropSound.play(1);
                    try {
                        DeviceControl.startVibra((int)50, (long)500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    GameScreen.this.crashDetected = true;
                    GameScreen.this.crashes = (byte)(GameScreen.this.crashes + 1);
                    if (GameScreen.this.crashes >= 3) {
                        GameScreen.this.gameOver = true;
                        GameMidlet.gameRunning = false;
                        SingleItemDB.delete("GameData");
                        GameScreen.this.hiscoreTask = new HiScoreTask();
                        GameScreen.this.frameUpdateTimer.schedule((TimerTask)GameScreen.this.hiscoreTask, 2000L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class FrameUpdateTask
    extends TimerTask {
        private FrameUpdateTask() {
        }

        public void run() {
            GameScreen.this.repaint();
        }
    }
}

