/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class ScrollableScreen {
    static final int BGCOLOR = 0xDD0077;
    static final int BORDERCOLOR = 0xFFFFFF;
    static short CORNER;
    static short HEIGHT;
    static short MARGIN;
    static short SCREEN_HEIGHT;
    static final byte SCREEN_HS = 2;
    static final byte SCREEN_MENU = 1;
    static final byte SCREEN_TEXT = 0;
    static final int SELECTEDTEXTCOLOR = 16771328;
    static final int TEXTCOLOR = 0xFFFFFF;
    static short WIDTH;
    static Image bg_image;
    static final Font f;
    protected int hswidth = f.stringWidth("10. ");
    protected int itemCount;
    static Image logo;
    protected int maxRows;
    protected int[] menuItemCodes;
    protected int rowCount;
    static final int rowHeight;
    protected byte screenType;
    protected int screenid;
    protected int selectedItem;
    protected Vector texts;
    String title;
    protected int topRow;
    protected int width;

    static {
        f = Font.getFont((int)0, (int)0, (int)0);
        rowHeight = f.getHeight() + 2;
    }

    protected ScrollableScreen(int n, String string, Image image, Image image2, byte by) {
        this.screenid = n;
        if (bg_image == null) {
            try {
                bg_image = Image.createImage((String)"/bg_image.png");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (logo == null) {
            try {
                logo = Image.createImage((String)"/uptitle.png");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.screenType = by;
        this.menuItemCodes = new int[10];
        this.texts = new Vector();
        this.title = string;
        ScrollableScreen.sizeChanged(MenuScreen.instance.getWidth(), MenuScreen.instance.getHeight());
    }

    protected ScrollableScreen() {
    }

    void addMenuItem(String string, int n) {
        this.texts.addElement(string);
        this.menuItemCodes[this.texts.size() - 1] = n;
        this.rowCount = this.itemCount = this.texts.size();
    }

    void changeMenuItem(String string, int n) {
        int n2 = 0;
        while (n2 < this.texts.size()) {
            if (this.menuItemCodes[n2] == n) {
                this.texts.setElementAt(string, n2);
                break;
            }
            ++n2;
        }
    }

    void destroy() {
        this.texts.removeAllElements();
        this.texts = null;
        this.title = null;
        this.menuItemCodes = null;
    }

    void keyPressed(int n) {
        int n2 = 0;
        try {
            n2 = MenuScreen.instance.getGameAction(n);
        }
        catch (Exception exception) {
            n2 = 0;
        }
        if (this.screenType == 1) {
            if (n == -6) {
                GameMidlet.menuScreen.callBack(this.screenid, this.menuItemCodes[this.selectedItem]);
            } else if (n2 == 1) {
                this.selectedItem = this.selectedItem > 0 ? --this.selectedItem : this.itemCount - 1;
                if (this.selectedItem < this.topRow) {
                    this.topRow = this.selectedItem;
                } else if (this.selectedItem > this.topRow + this.maxRows - 1) {
                    this.topRow = this.selectedItem - this.maxRows + 1;
                }
                MenuScreen.instance.repaint();
                MenuScreen.instance.serviceRepaints();
            } else if (n2 == 6) {
                ++this.selectedItem;
                this.selectedItem %= this.itemCount;
                if (this.selectedItem < this.topRow) {
                    this.topRow = this.selectedItem;
                } else if (this.selectedItem > this.topRow + this.maxRows - 1) {
                    this.topRow = this.selectedItem - this.maxRows + 1;
                }
                MenuScreen.instance.repaint();
                MenuScreen.instance.serviceRepaints();
            } else if (n2 == 8 || n == 53) {
                GameMidlet.menuScreen.callBack(this.screenid, this.menuItemCodes[this.selectedItem]);
            }
        } else if (n == -7) {
            GameMidlet.menuScreen.callBack(this.screenid, 0);
            this.topRow = 0;
        } else if (n2 == 1) {
            if (this.topRow > 0) {
                --this.topRow;
            }
            MenuScreen.instance.repaint();
            MenuScreen.instance.serviceRepaints();
        } else if (n2 == 6) {
            if (this.topRow < this.rowCount - this.maxRows) {
                ++this.topRow;
            }
            MenuScreen.instance.repaint();
            MenuScreen.instance.serviceRepaints();
        } else if (n2 == 8 || n == 53) {
            GameMidlet.menuScreen.callBack(this.screenid, 0);
            this.topRow = 0;
        }
    }

    void keyRepeated(int n) {
        this.keyPressed(n);
    }

    void paint(Graphics graphics) {
        try {
            int n;
            this.width = this.screenType == 1 ? WIDTH - MARGIN * 4 - 5 : WIDTH - MARGIN * 4;
            this.maxRows = (HEIGHT - MARGIN * 4) / rowHeight - 2;
            graphics.setFont(f);
            graphics.setColor(0xDD0077);
            graphics.fillRect(0, 0, (int)WIDTH, (int)SCREEN_HEIGHT);
            if (logo != null) {
                graphics.drawImage(logo, WIDTH / 2, 0, 0x10 | 1);
            }
            graphics.translate(0, SCREEN_HEIGHT - HEIGHT);
            if (bg_image != null) {
                graphics.drawImage(bg_image, WIDTH / 2, HEIGHT / 2, 2 | 1);
            }
            int n2 = 0;
            graphics.setColor(0xFFFFFF);
            graphics.drawRoundRect((int)MARGIN, rowHeight + MARGIN, WIDTH - MARGIN * 2, HEIGHT - 2 * rowHeight - MARGIN * 3, (int)CORNER, (int)CORNER);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(this.title, WIDTH / 2, 1, 0x10 | 1);
            if (this.screenType == 1) {
                graphics.setColor(0xFFFFFF);
                graphics.setClip((int)MARGIN, rowHeight + MARGIN, WIDTH - MARGIN * 2, HEIGHT - 2 * rowHeight - MARGIN * 3);
                n = this.topRow;
                while (n < this.rowCount) {
                    if (this.selectedItem == n) {
                        graphics.setColor(16771328);
                        graphics.drawString((String)this.texts.elementAt(n), MARGIN * 2 + 2 + 5, (n2 + 1) * rowHeight + MARGIN * 2, 0x10 | 4);
                        graphics.fillRect(MARGIN * 2 + 1, (n2 + 1) * rowHeight + MARGIN * 2 + rowHeight / 2 - 4, 3, 3);
                        graphics.setColor(0xFFFFFF);
                    } else {
                        graphics.drawString((String)this.texts.elementAt(n), MARGIN * 2 + 2 + 5, (n2 + 1) * rowHeight + MARGIN * 2, 0x10 | 4);
                    }
                    if (++n2 > this.maxRows) break;
                    ++n;
                }
                graphics.setClip(0, 0, (int)WIDTH, (int)HEIGHT);
                this.showSoftKeys(this.screenType, graphics);
            } else if (this.screenType == 2) {
                graphics.setClip((int)MARGIN, rowHeight + MARGIN, WIDTH - MARGIN * 2, HEIGHT - 2 * rowHeight - MARGIN * 3);
                n = this.topRow;
                while (n < this.rowCount) {
                    graphics.drawString(n + 1 + ". ", MARGIN * 2 + this.hswidth, (n2 + 1) * rowHeight + MARGIN * 2, 0x10 | 8);
                    graphics.drawString((String)this.texts.elementAt(n * 2), MARGIN * 2 + this.hswidth, (n2 + 1) * rowHeight + MARGIN * 2, 0x10 | 4);
                    graphics.drawString((String)this.texts.elementAt(n * 2 + 1), WIDTH - MARGIN * 2, (n2 + 1) * rowHeight + MARGIN * 2, 0x10 | 8);
                    if (++n2 > this.maxRows) break;
                    ++n;
                }
                graphics.setClip(0, 0, (int)WIDTH, (int)HEIGHT);
                this.showSoftKeys(this.screenType, graphics);
            } else {
                graphics.setClip((int)MARGIN, rowHeight + MARGIN, WIDTH - MARGIN * 2, HEIGHT - 2 * rowHeight - MARGIN * 3);
                n = this.topRow;
                while (n < this.rowCount) {
                    graphics.drawString((String)this.texts.elementAt(n), MARGIN * 2, (n2 + 1) * rowHeight + MARGIN * 2, 0x10 | 4);
                    if (++n2 > this.maxRows) break;
                    ++n;
                }
                graphics.setClip(0, 0, (int)WIDTH, (int)HEIGHT);
                this.showSoftKeys(this.screenType, graphics);
            }
            if (this.rowCount > this.maxRows) {
                graphics.setColor(0xFFFFFF);
                n = this.maxRows * rowHeight * this.maxRows / this.rowCount;
                graphics.fillRect(WIDTH - 2, rowHeight + MARGIN * 2 + this.topRow * (rowHeight * this.maxRows) / this.rowCount, 2, n);
                if (this.topRow != 0) {
                    int n3 = HEIGHT - rowHeight - MARGIN + 2;
                    graphics.drawLine(WIDTH / 2, n3, WIDTH / 2 + 3, n3 + 3);
                    graphics.drawLine(WIDTH / 2, n3, WIDTH / 2 - 3, n3 + 3);
                    graphics.drawLine(WIDTH / 2 - 3, n3 + 3, WIDTH / 2 + 3, n3 + 3);
                }
                if (this.topRow + this.maxRows < this.rowCount) {
                    graphics.drawLine(WIDTH / 2, HEIGHT - 1, WIDTH / 2 + 3, HEIGHT - 4);
                    graphics.drawLine(WIDTH / 2, HEIGHT - 1, WIDTH / 2 - 3, HEIGHT - 4);
                    graphics.drawLine(WIDTH / 2 - 3, HEIGHT - 4, WIDTH / 2 + 3, HEIGHT - 4);
                }
            }
            graphics.translate(0, HEIGHT - SCREEN_HEIGHT);
        }
        catch (Exception exception) {
            MenuScreen.debug = MenuScreen.debug + "Exception in SS.paint: " + exception.toString() + '\n';
        }
    }

    void setMenuItems(String[] stringArray, int[] nArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.texts.addElement(stringArray[n]);
            ++n;
        }
        this.menuItemCodes = nArray;
        this.rowCount = this.itemCount = this.texts.size();
    }

    void setText(String string) {
        try {
            this.width = this.screenType == 1 ? WIDTH - MARGIN * 4 - 5 : WIDTH - MARGIN * 4;
            this.texts = ScrollableScreen.wrapText(string, this.width, f);
            this.rowCount = this.texts.size();
            if (this.screenType == 1) {
                this.itemCount = this.rowCount;
            } else if (this.screenType == 2) {
                this.rowCount /= 2;
            }
        }
        catch (Exception exception) {
            MenuScreen.debug = MenuScreen.debug + "setText Exception: " + exception.toString() + '\n';
        }
    }

    protected void showSoftKeys(int n, Graphics graphics) {
        if (n == 1) {
            graphics.drawString(Texts.str[9], 1, HEIGHT - 1, 0x20 | 4);
        } else {
            graphics.drawString(Texts.str[10], WIDTH - 1, HEIGHT - 1, 0x20 | 8);
        }
    }

    static void sizeChanged(int n, int n2) {
        WIDTH = (short)n;
        SCREEN_HEIGHT = (short)n2;
        CORNER = (short)(WIDTH / 22);
        MARGIN = (short)(WIDTH / 40);
        HEIGHT = logo == null ? SCREEN_HEIGHT : (short)(SCREEN_HEIGHT - logo.getHeight());
    }

    static Vector wrapText(String string, int n, Font font) {
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 != string.length()) {
            n3 = string.indexOf(10, n2);
            if (n3 == -1) {
                n3 = string.length();
            }
            String string2 = "";
            try {
                string2 = string.substring(n2, n3).trim();
            }
            catch (Exception exception) {
                MenuScreen.debug = MenuScreen.debug + "substring1: " + exception.toString() + '\n';
            }
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            boolean bl = false;
            int n8 = 0;
            while (true) {
                if ((n6 = string2.indexOf(32, (n8 = n6) + 1)) == -1) {
                    n6 = string2.length();
                    bl = true;
                }
                ++n7;
                try {
                    n4 = font.substringWidth(string2, n5, n6 - n5);
                }
                catch (Exception exception) {
                    MenuScreen.debug = MenuScreen.debug + "substringwidth: " + n5 + " " + n6 + " " + string2.length() + " " + exception.toString() + '\n';
                }
                if (n4 > n) {
                    if (n7 > 1) {
                        vector.addElement(string2.substring(n5, n8));
                        n5 = n8 + 1;
                    } else {
                        n8 = n5 + (n6 - n5) * (n * 9) / (n4 * 10);
                        vector.addElement(string2.substring(n5, n8) + "-");
                        n5 = n8;
                    }
                    n6 = n5;
                    n7 = 0;
                    continue;
                }
                if (bl) break;
            }
            vector.addElement(string2.substring(n5, n6));
            n2 = n3 + 1;
        }
        return vector;
    }
}

