/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

final class Menu {
    static byte[][] TEXT_HIGHSCORE;
    static byte[][] TEXT_HELP;
    static byte[][] TEXT_ABOUT;
    static byte[][] TEXT_EXIT;
    static final int SCROLL_DELAY = 200;
    static final int SPLASH_DELAY = 500;
    static final int STADY_HELP = 0;
    static final int STADY_MENU = 1;
    static final int STADY_HISCORE = 2;
    static final int STADY_ADD_HISCORE = 10;
    static final int STADY_ABOUT = 5;
    static final int STADY_EXIT = 6;
    static final int HISCORE_END = 20;
    static final int HISCORE_LEFT = 55;
    static final int SPACE_BETWEEN_HISCORE_STRINGS = 8;
    static final int HISCORE_DELTA_LEFT_FROM_CENTER = 4;
    static final int MENU_START = 45;
    static final int MENU_END = 18;
    static final int MENU_HEIGHT = 67;
    static final int TOTAL_MENU_ITEMS_COUNT = 22;
    static final int SELECT_CONTINUE = 0;
    static final int SELECT_NEWGAME = 1;
    static final int SELECT_HISCORE = 2;
    static final int SELECT_HELP = 3;
    static final int SELECT_SOUND = 4;
    static final int SELECT_ABOUT = 5;
    static final int SELECT_EXIT = 6;
    static boolean scroll;
    static int position;
    static char[] name;
    static int quitMenu;
    static int deltaY;
    static int menuItemHeight;
    static int curLetter;
    static long timeVar;
    static long timeVar2;
    static int maxHelpY;
    static int menuHelpCnt;
    static int deltaAboutX;
    static int maxAboutY;
    static int menuAboutHt;
    static boolean canContinue;
    static String[] scoreString;
    static String[] scoreNum;
    static int[] _scoreNum;
    static int globalPos;
    static int localPos;
    static int stady;
    static Image menuBackground;
    static Image imgQuit;
    static Image menuTop;
    static Image menuText;
    static final int MENU_ITEMS_COUNT = 7;
    static final int LOCAL_MENU_ITEMS_COUNT = 3;
    static final int LOCAL_MENU_ITEMS_COUNT_MINUS1 = 2;
    static int MENU_TEXT_BEGIN_X;
    static int MENU_TEXT_BEGIN_Y;

    static void init() {
        Menu.loadImages();
        Menu.loadText();
        Screen.isMenu = true;
    }

    static void loadText() {
        Font.setFont(1);
        TEXT_ABOUT = Font.getTextArray("about");
        TEXT_HELP = Font.getTextArray("help");
        TEXT_HIGHSCORE = Font.getTextArray("highscore");
        TEXT_EXIT = Font.getTextArray("exit");
    }

    static void loadImages() {
        menuBackground = LoadSave.getImage("m_back.png");
        menuTop = LoadSave.getImage("m_top.png");
        menuText = LoadSave.getImage("m_text.png");
        imgQuit = LoadSave.getImage("menuexit.png");
        menuItemHeight = menuText.getHeight() / 22;
        MENU_TEXT_BEGIN_X = (130 - menuText.getWidth()) / 2;
        MENU_TEXT_BEGIN_Y = 130 - menuItemHeight * 5;
        stady = 1;
        byte[][] RS = LoadSave.getRecord();
        if (RS[1][0] == 0) {
            canContinue = false;
            localPos = 1;
        } else {
            canContinue = true;
            localPos = 0;
        }
        Screen.sound = RS[0][0] == 1;
        Game.showTips = Game.firstRun = (RS[0][1] & 1) == 1;
        Game.firstGarage = RS[0][1] > 1;
        RS = null;
    }

    static void loadHelp() {
        menuHelpCnt = 67 / Font.currentFontHeight;
        maxHelpY = TEXT_HELP.length - menuHelpCnt;
        if (maxHelpY < 0) {
            maxHelpY = 0;
        }
    }

    static void drawBackground(Graphics g) {
        g.setClip(0, 0, 130, 130);
        g.drawImage(menuBackground, 0, 0, 0);
        g.drawImage(menuTop, 0, 0, 0);
    }

    static void doSomething(Graphics g) {
        Font.setFont(1);
        if (stady == 10) {
            if (Screen.key == 0) {
                timeVar = 0L;
            } else {
                timeVar2 = System.currentTimeMillis();
            }
            scroll = false;
            if ((Screen.key & 1) != 0) {
                if (timeVar == (long)0) {
                    scroll = true;
                    timeVar = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - timeVar > (long)200) {
                    scroll = true;
                    timeVar = System.currentTimeMillis();
                }
                if (scroll) {
                    if (name[curLetter] < 'Z') {
                        int n = curLetter;
                        name[n] = (char)(name[n] + '\u0001');
                    } else {
                        Menu.name[Menu.curLetter] = 65;
                    }
                }
            } else if ((Screen.key & 2) != 0) {
                if (timeVar == (long)0) {
                    scroll = true;
                    timeVar = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - timeVar > (long)200) {
                    scroll = true;
                    timeVar = System.currentTimeMillis();
                }
                if (scroll) {
                    if (name[curLetter] > 'A') {
                        int n = curLetter;
                        name[n] = (char)(name[n] - '\u0001');
                    } else {
                        Menu.name[Menu.curLetter] = 90;
                    }
                }
            } else if ((Screen.key & 4) != 0) {
                if (curLetter > 0) {
                    Screen.keyReset();
                    --curLetter;
                }
            } else if ((Screen.key & 8) != 0) {
                if (curLetter < 2) {
                    Screen.keyReset();
                    ++curLetter;
                }
            } else if ((Screen.key & 0x10) != 0) {
                if (curLetter < 2) {
                    Screen.keyReset();
                    SoundEffect.play(0);
                    ++curLetter;
                } else {
                    try {
                        Menu.scoreString[Menu.position] = "" + name;
                        byte[][] RS = LoadSave.getRecord();
                        ByteArrayOutputStream bs = new ByteArrayOutputStream();
                        DataOutputStream ds = new DataOutputStream(bs);
                        for (int i = 0; i < LoadSave.hiscoreListLength; ++i) {
                            ds.writeInt(_scoreNum[i]);
                            ds.writeChars(scoreString[i]);
                        }
                        RS[2] = bs.toByteArray();
                        ds.close();
                        LoadSave.setRecord(RS);
                        RS = null;
                        stady = 2;
                        menuText = LoadSave.getImage("m_text.png");
                        Game.level = 0;
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            switch (Screen.key & 0x7F) {
                case 1: 
                case 4: {
                    Menu.moveUp(g);
                    Screen.keyReset();
                    break;
                }
                case 2: 
                case 8: {
                    Menu.moveDown(g);
                    Screen.keyReset();
                    break;
                }
                case 16: {
                    Menu.select();
                    Screen.keyReset();
                    break;
                }
                case 32: {
                    stady = 1;
                    Screen.keyReset();
                    return;
                }
            }
        }
        if (Screen.isMenu) {
            Menu.menuPaint(g);
        }
    }

    static void moveUp(Graphics g) {
        if (5 == stady || 2 == stady) {
            return;
        }
        if (!SoundEffect.play(0)) {
            return;
        }
        if (stady == 0) {
            if (--deltaY < 0) {
                deltaY = 0;
            }
            return;
        }
        if (6 == stady) {
            quitMenu = 1 - quitMenu;
            return;
        }
        if (localPos > 0) {
            --localPos;
        } else if (globalPos > 0) {
            --globalPos;
        }
        if (localPos == 0 && globalPos == 0 && !canContinue) {
            localPos = 1;
        }
    }

    static void moveDown(Graphics g) {
        if (5 == stady || 2 == stady) {
            return;
        }
        if (!SoundEffect.play(0)) {
            return;
        }
        if (stady == 0) {
            if (++deltaY > maxHelpY) {
                deltaY = maxHelpY;
            }
            return;
        }
        if (6 == stady) {
            quitMenu = 1 - quitMenu;
            return;
        }
        if (localPos < 2) {
            ++localPos;
        } else if (globalPos < 4) {
            ++globalPos;
        }
    }

    static void select() {
        if (!SoundEffect.play(0)) {
            return;
        }
        if (stady == 0) {
            stady = 1;
            return;
        }
        if (5 == stady) {
            stady = 1;
            return;
        }
        if (2 == stady) {
            stady = 1;
            return;
        }
        if (6 == stady) {
            stady = 1;
            localPos = 1;
            globalPos = 0;
            if (quitMenu == 0) {
                Screen.quit = true;
            }
            return;
        }
        switch (globalPos + localPos) {
            case 0: {
                LoadSave.loadLevel();
                Screen.startGame(false);
                break;
            }
            case 1: {
                Screen.startGame(true);
                break;
            }
            case 2: {
                stady = 2;
                Menu.loadHiscore();
                break;
            }
            case 3: {
                stady = 0;
                Menu.loadHelp();
                deltaY = 0;
                break;
            }
            case 4: {
                byte[][] RS = LoadSave.getRecord();
                Screen.sound = !Screen.sound;
                RS[0][0] = RS[0][0] == 1 ? (byte)0 : 1;
                LoadSave.setRecord(RS);
                RS = null;
                break;
            }
            case 5: {
                stady = 5;
                break;
            }
            case 6: {
                quitMenu = 1;
                stady = 6;
                break;
            }
        }
    }

    static void drawArrows(Graphics g) {
        g.setClip(MENU_TEXT_BEGIN_X, MENU_TEXT_BEGIN_Y - menuItemHeight, 100, menuItemHeight);
        if (globalPos > 0 & localPos == 0) {
            g.drawImage(menuText, MENU_TEXT_BEGIN_X, MENU_TEXT_BEGIN_Y - menuItemHeight * 8, 0);
        } else {
            g.drawImage(menuText, MENU_TEXT_BEGIN_X, MENU_TEXT_BEGIN_Y - menuItemHeight * 17, 0);
        }
        g.setClip(MENU_TEXT_BEGIN_X, MENU_TEXT_BEGIN_Y + menuItemHeight * 3, 100, menuItemHeight);
        if (globalPos < 4 & localPos == 2) {
            g.drawImage(menuText, MENU_TEXT_BEGIN_X, MENU_TEXT_BEGIN_Y - menuItemHeight * 5, 0);
        } else {
            g.drawImage(menuText, MENU_TEXT_BEGIN_X, MENU_TEXT_BEGIN_Y - menuItemHeight * 14, 0);
        }
    }

    static void drawArrowsHelp(Graphics g) {
        g.setClip(MENU_TEXT_BEGIN_X, 45 - menuItemHeight, 100, menuItemHeight);
        if (deltaY > 0) {
            g.drawImage(menuText, MENU_TEXT_BEGIN_X, 45 - menuItemHeight * 8, 0);
        } else {
            g.drawImage(menuText, MENU_TEXT_BEGIN_X, 45 - menuItemHeight * 17, 0);
        }
        g.setClip(MENU_TEXT_BEGIN_X, 130 - menuItemHeight, 100, menuItemHeight);
        if (deltaY < maxHelpY) {
            g.drawImage(menuText, MENU_TEXT_BEGIN_X, 130 - menuItemHeight * 9, 0);
        } else {
            g.drawImage(menuText, MENU_TEXT_BEGIN_X, 130 - menuItemHeight * 18, 0);
        }
    }

    static void menuPaint(Graphics g) {
        switch (stady) {
            case 1: {
                Menu.drawBackground(g);
                for (int k = 0; k < 3; ++k) {
                    g.setClip(MENU_TEXT_BEGIN_X, MENU_TEXT_BEGIN_Y + k * menuItemHeight, 100, menuItemHeight);
                    if (k == 0 && globalPos == 0 && !canContinue) {
                        g.drawImage(menuText, MENU_TEXT_BEGIN_X, MENU_TEXT_BEGIN_Y - 18 * menuItemHeight, 0);
                        continue;
                    }
                    if (globalPos + k == 4 && !Screen.sound) {
                        if (localPos == k) {
                            g.drawImage(menuText, MENU_TEXT_BEGIN_X, MENU_TEXT_BEGIN_Y - 19 * menuItemHeight + k * menuItemHeight, 0);
                            continue;
                        }
                        g.drawImage(menuText, MENU_TEXT_BEGIN_X, MENU_TEXT_BEGIN_Y - 21 * menuItemHeight + k * menuItemHeight, 0);
                        continue;
                    }
                    if (localPos == k) {
                        g.drawImage(menuText, MENU_TEXT_BEGIN_X, MENU_TEXT_BEGIN_Y - globalPos * menuItemHeight, 0);
                        continue;
                    }
                    g.drawImage(menuText, MENU_TEXT_BEGIN_X, MENU_TEXT_BEGIN_Y - (9 + globalPos) * menuItemHeight, 0);
                }
                Menu.drawArrows(g);
                return;
            }
            case 2: {
                g.setClip(0, 0, 130, 130);
                g.drawImage(menuBackground, 0, 0, 0);
                int i = LoadSave.hiscoreListLength;
                while (i-- > 0) {
                    Font.drawStringHCenter(new StringBuffer(i != 0 ? " " : "").append(10 - i).append(". ").append(scoreString[i]).append(" ").append(scoreNum[i]), 61, 130 - i * 8 - 20, g);
                }
                return;
            }
            case 10: {
                Menu.drawBackground(g);
                g.setClip(0, 0, 130, 130);
                Font.drawStringHCenter(TEXT_HIGHSCORE, 65, MENU_TEXT_BEGIN_Y - 10, g);
                Font.drawStringHCenter(new StringBuffer().append(Game.score), 65, MENU_TEXT_BEGIN_Y - 10 + Font.currentFontHeight * 4, g);
                Font.drawStringHCenter(new StringBuffer().append(LoadSave.hiscoreListLength - position), 65, MENU_TEXT_BEGIN_Y - 10 + Font.currentFontHeight * 6, g);
                g.setClip(0, 0, 130, 130);
                char[] name_t = new char[name.length];
                for (int k = 0; k < name.length; ++k) {
                    name_t[k] = name[k];
                }
                if (System.currentTimeMillis() - timeVar2 > (long)1000) {
                    timeVar2 = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - timeVar2 > (long)500) {
                    name_t[Menu.curLetter] = 32;
                }
                Font.drawStringHCenter(new StringBuffer().append(name_t), 65, MENU_TEXT_BEGIN_Y - 10 + Font.currentFontHeight * 8, g);
                name_t = null;
                return;
            }
            case 0: {
                g.setClip(0, 0, 130, 130);
                g.drawImage(menuBackground, 0, 0, 0);
                Font.drawStringHCenter(TEXT_HELP, deltaY, menuHelpCnt, 65, 45, g);
                g.setClip(0, 45, 130, 67);
                Menu.drawArrowsHelp(g);
                return;
            }
            case 5: {
                g.setClip(0, 0, 130, 130);
                g.drawImage(menuBackground, 0, 0, 0);
                g.drawImage(menuTop, 0, 0, 0);
                Font.drawStringHCenter(TEXT_ABOUT, 65, MENU_TEXT_BEGIN_Y, g);
                return;
            }
            case 6: {
                g.setClip(0, 0, 130, 130);
                g.drawImage(menuBackground, 0, 0, 0);
                g.drawImage(menuTop, 0, 0, 0);
                g.drawImage(imgQuit, (130 - imgQuit.getWidth()) / 2, (130 - imgQuit.getHeight()) / 2, 0);
                g.setColor(255, 255, 0);
                g.drawRect(65 + quitMenu * 30 - 25 - 1, 65, 25, Font.currentFontHeight * 2);
                Font.drawStringHCenter(TEXT_EXIT, 65, (130 - imgQuit.getHeight() + Font.currentFontHeight) / 2, g);
                return;
            }
        }
    }

    static void loadHiscore() {
        position = 0;
        Menu.getHiscore();
    }

    static void scrollHiscore(int pos) {
        for (int count = 1; count <= pos; ++count) {
            Menu.scoreNum[count - 1] = scoreNum[count];
            Menu.scoreString[count - 1] = scoreString[count];
        }
    }

    static void addHiScore() {
        menuBackground = LoadSave.getImage("m_back.png");
        menuTop = LoadSave.getImage("m_top.png");
        menuText = LoadSave.getImage("m_text.png");
        byte[][] RS = LoadSave.getRecord();
        if (!canContinue) {
            RS[1][0] = 0;
            LoadSave.setRecord(RS);
        }
        RS = null;
        Menu.getHiscore();
        Screen.keyReset();
        stady = 10;
        if (Game.score >= _scoreNum[0]) {
            int hiscore = Game.score;
            for (int i = LoadSave.hiscoreListLength - 1; i >= 0; --i) {
                if (hiscore < _scoreNum[i]) continue;
                Menu.scrollHiscore(i);
                position = i;
                name = "AAA".toCharArray();
                curLetter = 0;
                Menu._scoreNum[i] = hiscore;
                String t = "000000" + hiscore;
                Menu.scoreNum[i] = t = t.substring(t.length() - 6, t.length());
                break;
            }
            stady = 10;
        } else {
            stady = 2;
        }
    }

    static void getHiscore() {
        scoreString = null;
        scoreString = new String[LoadSave.hiscoreListLength];
        scoreNum = null;
        scoreNum = new String[LoadSave.hiscoreListLength];
        _scoreNum = null;
        _scoreNum = new int[LoadSave.hiscoreListLength];
        byte[][] RS = LoadSave.getRecord();
        ByteArrayInputStream bs = new ByteArrayInputStream(RS[2]);
        DataInputStream ds = new DataInputStream(bs);
        try {
            for (int i = 0; i < LoadSave.hiscoreListLength; ++i) {
                int s;
                Menu._scoreNum[i] = s = ds.readInt();
                String t = "000000" + s;
                Menu.scoreNum[i] = t.substring(t.length() - 6, t.length());
                Menu.scoreString[i] = new String(new StringBuffer().append(ds.readChar()).append(ds.readChar()).append(ds.readChar())).toString();
                t = null;
            }
            ds.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RS = null;
        System.gc();
    }

    static void deInit() {
        imgQuit = null;
        menuBackground = null;
        menuText = null;
        menuTop = null;
        TEXT_ABOUT = null;
        TEXT_EXIT = null;
        TEXT_HELP = null;
        TEXT_HIGHSCORE = null;
        System.gc();
        Screen.isMenu = false;
    }

    static {
        SCROLL_DELAY = 200;
        SPLASH_DELAY = 500;
        STADY_HELP = 0;
        STADY_MENU = 1;
        STADY_HISCORE = 2;
        STADY_ADD_HISCORE = 10;
        STADY_ABOUT = 5;
        STADY_EXIT = 6;
        HISCORE_END = 20;
        HISCORE_LEFT = 55;
        SPACE_BETWEEN_HISCORE_STRINGS = 8;
        HISCORE_DELTA_LEFT_FROM_CENTER = 4;
        MENU_START = 45;
        MENU_END = 18;
        MENU_HEIGHT = 67;
        TOTAL_MENU_ITEMS_COUNT = 22;
        SELECT_CONTINUE = 0;
        SELECT_NEWGAME = 1;
        SELECT_HISCORE = 2;
        SELECT_HELP = 3;
        SELECT_SOUND = 4;
        SELECT_ABOUT = 5;
        SELECT_EXIT = 6;
        scroll = false;
        timeVar = 0L;
        timeVar2 = 0L;
        globalPos = 0;
        localPos = 1;
        stady = 1;
        menuBackground = null;
        imgQuit = null;
        menuTop = null;
        menuText = null;
        MENU_ITEMS_COUNT = 7;
        LOCAL_MENU_ITEMS_COUNT = 3;
        LOCAL_MENU_ITEMS_COUNT_MINUS1 = 2;
    }
}

