/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Screen
extends Canvas
implements Runnable {
    static final int width = 130;
    static final int height = 130;
    static byte[] text;
    static final int MILLIS_PER_TICK = 70;
    static boolean quit;
    static boolean isMenu;
    static boolean isGame;
    static boolean isGarage;
    static int key;
    static final int DO_INIT = 0;
    static final int DO_LOAD = 1;
    static final int DO_SPLASH = 2;
    static final int DO_MENU = 3;
    static final int DO_GAME = 4;
    static final int DO_GARAGE = 5;
    static int task;
    static final int KEY_UP = 1;
    static final int KEY_DOWN = 2;
    static final int KEY_LEFT = 4;
    static final int KEY_RIGHT = 8;
    static final int KEY_FIRE = 16;
    static final int KEY_PAUSE = 32;
    static final LoadSave ls;
    static final Game game;
    static final Menu menu;
    static final Garage garage;
    static final Font font;
    static final SoundEffect se;
    static Image logo;
    static boolean sound;

    public Screen() {
        this.setFullScreenMode(true);
        Thread thread = new Thread(this);
        thread.start();
    }

    protected final void hideNotify() {
        try {
            a.instance.pauseApp();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final void paint(Graphics g) {
        try {
            switch (task) {
                case 0: {
                    this.setFullScreenMode(true);
                    SoundEffect.init();
                    LoadSave.init();
                    task = 1;
                    break;
                }
                case 1: {
                    LoadSave.progressBar(g);
                    if (LoadSave.loading != 0) break;
                    Font.init();
                    Screen.keyReset();
                    task = 2;
                    break;
                }
                case 2: {
                    if (logo == null) {
                        logo = LoadSave.getImage("splash.png");
                        Font.setFont(0);
                        text = Font.getText("press");
                    }
                    if ((key & 0x10) == 0) {
                        g.drawImage(logo, 0, 0, 0);
                        if ((System.currentTimeMillis() & (long)767) <= (long)384) break;
                        Font.drawStringHCenter(text, 65, 110, g);
                        break;
                    }
                    Screen.keyReset();
                    logo = null;
                    text = null;
                    System.gc();
                    Screen.startMenu();
                    break;
                }
                case 3: {
                    if (!isMenu) break;
                    Menu.doSomething(g);
                    break;
                }
                case 5: {
                    if (!isGarage) break;
                    Garage.doSomething(g);
                    break;
                }
                case 4: {
                    if (!isGame) break;
                    Game.doSomething(g);
                }
            }
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    protected void keyPressed(int keyCode) {
        switch (keyCode) {
            case 35: 
            case 42: 
            case 49: 
            case 51: 
            case 55: 
            case 57: {
                return;
            }
            case 50: {
                key |= 1;
                return;
            }
            case 56: {
                key |= 2;
                return;
            }
            case 52: {
                key |= 4;
                return;
            }
            case 54: {
                key |= 8;
                return;
            }
            case -23: 
            case 53: {
                key |= 0x10;
                return;
            }
            case 48: {
                key |= 0x20;
                return;
            }
        }
        try {
            switch (this.getGameAction(keyCode)) {
                case 1: {
                    key |= 1;
                    return;
                }
                case 6: {
                    key |= 2;
                    return;
                }
                case 2: {
                    key |= 4;
                    return;
                }
                case 5: {
                    key |= 8;
                    return;
                }
                case -23: 
                case 8: {
                    key |= 0x10;
                    return;
                }
                case 0: {
                    key |= 0x20;
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void keyReleased(int _keyCode) {
        key &= 0x7F;
        int aKeyCode = 0;
        switch (_keyCode) {
            case 35: 
            case 42: 
            case 49: 
            case 51: 
            case 55: 
            case 57: {
                return;
            }
        }
        try {
            switch (this.getGameAction(_keyCode)) {
                case 1: {
                    aKeyCode = 1;
                    break;
                }
                case 6: {
                    aKeyCode = 2;
                    break;
                }
                case 2: {
                    aKeyCode = 4;
                    break;
                }
                case 5: {
                    aKeyCode = 8;
                    break;
                }
                case -23: 
                case 8: {
                    aKeyCode = 16;
                    break;
                }
                case 0: {
                    aKeyCode = 32;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (_keyCode) {
            case 50: {
                aKeyCode = 1;
                break;
            }
            case 56: {
                aKeyCode = 2;
                break;
            }
            case 52: {
                aKeyCode = 4;
                break;
            }
            case 54: {
                aKeyCode = 8;
                break;
            }
            case -23: 
            case 53: {
                aKeyCode = 16;
                break;
            }
            case 48: {
                aKeyCode = 32;
            }
        }
        key &= -1 - aKeyCode;
    }

    protected void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    static void keyReset() {
        key = 0;
    }

    public final void run() {
        try {
            while (!quit) {
                long startTime = System.currentTimeMillis();
                this.repaint();
                this.serviceRepaints();
                long timeTaken = System.currentTimeMillis() - startTime;
                if (timeTaken < (long)70) {
                    Screen screen = this;
                    synchronized (screen) {
                        this.wait((long)70 - timeTaken);
                        continue;
                    }
                }
                Thread.yield();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        a.quitApp();
    }

    static void startMenu() {
        if (isGarage) {
            Garage.deInit();
        }
        if (isGame) {
            Game.deInit();
        }
        Menu.init();
        task = 3;
    }

    static void startGarage() {
        if (isMenu) {
            Menu.deInit();
        }
        if (isGame) {
            Game.deInit();
        }
        Garage.init();
        task = 5;
    }

    static void startGame(boolean reset) {
        if (isGarage) {
            Garage.deInit();
        }
        if (isMenu) {
            Menu.deInit();
        }
        Game.init(reset);
        task = 4;
    }

    static {
        width = 130;
        height = 130;
        MILLIS_PER_TICK = 70;
        quit = false;
        isMenu = false;
        isGame = false;
        isGarage = false;
        key = 0;
        DO_INIT = 0;
        DO_LOAD = 1;
        DO_SPLASH = 2;
        DO_MENU = 3;
        DO_GAME = 4;
        DO_GARAGE = 5;
        task = 0;
        KEY_UP = 1;
        KEY_DOWN = 2;
        KEY_LEFT = 4;
        KEY_RIGHT = 8;
        KEY_FIRE = 16;
        KEY_PAUSE = 32;
        ls = new LoadSave();
        game = new Game();
        menu = new Menu();
        garage = new Garage();
        font = new Font();
        se = new SoundEffect();
        sound = true;
    }
}

