/*
 * Decompiled with CFR 0.152.
 */
package cityKnights;

import cityKnights.AlertForm;
import cityKnights.Game;
import cityKnights.LangSelect;
import cityKnights.SplashScreen;
import cityKnights.Starter;
import cityKnights.common.LoadGame;
import cityKnights.common.OpponentCanvas;
import cityKnights.common.ScoreEntry;
import cityKnights.common.Scores;
import cityKnights.common.SoundSelect;
import cityKnights.common.StoreGameForm;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public final class MenuCanvas
extends Canvas
implements CommandListener {
    Starter starter;
    Game game = null;
    public Command newGameCommand;
    public Command helpCommand;
    public Command highScoresCommand;
    public Command storeCommand;
    public Command loadCommand;
    public Command continueCommand;
    public Command aboutCommand;
    public Command soundCommand;
    public Command langCommand;
    public static boolean soundOn = true;
    String helpText;
    String abutText;
    String prevlang = "";
    String lang;
    String[] LangLabel;
    byte numLangs = 1;
    MenuCanvas MC;

    public MenuCanvas(Starter starter) {
        try {
            this.MC = this;
            this.starter = starter;
            this.addCMDs();
            this.setCommandListener(this);
        }
        catch (Exception exception) {
            System.out.println(exception + " menucanvas ");
        }
    }

    public void addCMDs() {
        this.removeMainCommands();
        this.continueCommand = new Command(this.starter.LD.translate("Resume"), 4, 1);
        this.newGameCommand = new Command(this.starter.LD.translate("NEW GAME"), 1, 1);
        this.loadCommand = new Command(this.starter.LD.translate("LOAD GAME"), 1, 2);
        this.storeCommand = new Command(this.starter.LD.translate("STORE GAME"), 4, 2);
        this.highScoresCommand = new Command(this.starter.LD.translate("HIGH SCORES"), 1, 4);
        this.helpCommand = new Command(this.starter.LD.translate("HELP"), 1, 6);
        this.aboutCommand = new Command(this.starter.LD.translate("ABOUT"), 1, 5);
        this.soundCommand = new Command(this.starter.LD.translate("SOUND"), 1, 3);
        this.langCommand = new Command(this.starter.LD.translate("LANGUAGE"), 1, 3);
        this.addMainCommands();
    }

    private void addMainCommands() {
        this.addCommand(this.continueCommand);
        this.addCommand(this.newGameCommand);
        this.addCommand(this.loadCommand);
        this.addCommand(this.storeCommand);
        this.addCommand(this.highScoresCommand);
        this.addCommand(this.helpCommand);
        this.addCommand(this.aboutCommand);
        this.addCommand(this.soundCommand);
        this.addCommand(this.langCommand);
    }

    private void removeMainCommands() {
        try {
            if (this.continueCommand != null) {
                this.removeCommand(this.continueCommand);
            }
            if (this.storeCommand != null) {
                this.removeCommand(this.storeCommand);
            }
            if (this.newGameCommand != null) {
                this.removeCommand(this.newGameCommand);
            }
            if (this.loadCommand != null) {
                this.removeCommand(this.loadCommand);
            }
            if (this.highScoresCommand != null) {
                this.removeCommand(this.highScoresCommand);
            }
            if (this.helpCommand != null) {
                this.removeCommand(this.helpCommand);
            }
            if (this.aboutCommand != null) {
                this.removeCommand(this.aboutCommand);
            }
            if (this.soundCommand != null) {
                this.removeCommand(this.soundCommand);
            }
            if (this.langCommand != null) {
                this.removeCommand(this.langCommand);
            }
        }
        catch (Exception exception) {
            System.out.println("erwjkehrk " + exception);
        }
    }

    public void setGame(Game game) {
        this.game = game;
        if (game != null && !game.gameOver) {
            this.addCommand(this.continueCommand);
            this.addCommand(this.storeCommand);
        } else {
            if (this.continueCommand != null) {
                this.removeCommand(this.continueCommand);
            }
            if (this.storeCommand != null) {
                this.removeCommand(this.storeCommand);
            }
        }
    }

    protected void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.game != null) {
            graphics.setColor(64, 64, 64);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(0xFFFFFF);
            if (this.game.gameOver) {
                graphics.drawString(this.starter.LD.translate("Game Over"), n / 2, n2 / 2 - 10, 65);
                graphics.drawString(this.starter.LD.translate("Score") + ": " + new Integer(Game.sfStatus.score).toString(), n / 2, n2 / 2 + 10, 65);
            } else {
                graphics.drawString(this.starter.LD.translate("Game Paused"), n / 2, n2 / 2, 65);
            }
        } else {
            try {
                if (this.starter.splashScreen != null) {
                    graphics.drawImage(SplashScreen.flash, n / 2, n2 / 2, 3);
                } else {
                    this.starter.splashScreen = new SplashScreen(this.starter);
                    graphics.drawImage(SplashScreen.flash, n / 2, n2 / 2, 3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 6) {
            this.starter.exitMidlet();
        } else if (command == this.continueCommand) {
            Starter.setDisplayable((Displayable)this.game);
            this.game.resumeGame();
        } else if (command == this.newGameCommand) {
            OpponentCanvas opponentCanvas = new OpponentCanvas(this.starter);
            Starter.setDisplayable((Displayable)opponentCanvas);
        } else if (command == this.helpCommand) {
            this.showHelp();
        } else if (command == this.highScoresCommand) {
            this.showScores();
        } else if (command == this.loadCommand) {
            LoadGame loadGame = new LoadGame((Displayable)this, this.starter, this.starter.LD.translate("Select stored game"));
            Starter.setDisplayable((Displayable)loadGame);
        } else if (command == this.aboutCommand) {
            this.showAbout();
        } else if (command == this.soundCommand) {
            SoundSelect soundSelect = new SoundSelect((Displayable)this, this.starter.LD.translate("Sound"), this.starter.LD.translate("ON"), this.starter.LD.translate("OFF"));
            Starter.setDisplayable((Displayable)soundSelect);
        } else if (command == this.langCommand) {
            LangSelect langSelect = new LangSelect((Displayable)this, this.starter, this.MC);
            Starter.setDisplayable((Displayable)langSelect);
        } else if (command == this.storeCommand) {
            Starter.setDisplayable((Displayable)new StoreGameForm(this.game, this.starter));
        }
    }

    public void showHelp() {
        if (this.helpText == null) {
            this.readHelp(this.lang);
        }
        AlertForm alertForm = new AlertForm(this.starter.LD.translate("HELP"), this.game);
        alertForm.append(this.helpText);
        Starter.setDisplayable((Displayable)alertForm);
    }

    public void showAbout() {
        if (this.abutText == null) {
            this.readAbut(this.lang);
        }
        AlertForm alertForm = new AlertForm(this.starter.LD.translate("ABOUT"), this.game);
        alertForm.append(this.abutText);
        Starter.setDisplayable((Displayable)alertForm);
    }

    public void showScores() {
        AlertForm alertForm = new AlertForm(this.starter.LD.translate("HIGH SCORES"), this.game);
        Scores scores = Starter.scores;
        if (scores != null) {
            String string = "Max Scores:\n";
            int n = 0;
            while (n < scores.size()) {
                ScoreEntry scoreEntry = (ScoreEntry)scores.elementAt(n);
                alertForm.append("" + (n + 1) + "." + scoreEntry.name + "  " + scoreEntry.score + "\n");
                ++n;
            }
        }
        Starter.setDisplayable((Displayable)alertForm);
    }

    public void readHelp(String string) {
        string = this.starter.LD.lang;
        boolean bl = false;
        try {
            String string2 = "";
            Class<?> clazz = ((Object)((Object)this)).getClass();
            InputStream inputStream = clazz.getResourceAsStream("/help." + string + ".txt");
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte[] byArray = new byte[500];
            try {
                dataInputStream.read(byArray);
            }
            catch (Exception exception) {
                System.out.println("2 " + exception);
            }
            if ((char)byArray[0] == 'A') {
                byArray[0] = 32;
                string2 = new String(byArray, "ISO8859_1");
            } else if ((char)byArray[0] == 'B') {
                byArray[0] = 32;
                string2 = new String(byArray, "UTF-8");
            }
            byArray = null;
            inputStream.close();
            dataInputStream = null;
            try {
                this.helpText = "";
                int n = 1;
                while (n < string2.length()) {
                    if (string2.charAt(n) != '|' || string2.charAt(n + 1) != '|' || string2.charAt(n + 2) != '|') {
                        this.helpText = string2.charAt(n) == '~' ? this.helpText + "\n" : this.helpText + string2.charAt(n);
                        ++n;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("1 " + exception);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void readAbut(String string) {
        string = this.starter.LD.lang;
        boolean bl = false;
        try {
            String string2 = "";
            Class<?> clazz = ((Object)((Object)this)).getClass();
            InputStream inputStream = clazz.getResourceAsStream("/about." + string + ".txt");
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte[] byArray = new byte[500];
            try {
                dataInputStream.read(byArray);
            }
            catch (Exception exception) {
                System.out.println("2 " + exception);
            }
            if ((char)byArray[0] == 'A') {
                byArray[0] = 32;
                string2 = new String(byArray, "ISO8859_1");
            } else if ((char)byArray[0] == 'B') {
                byArray[0] = 32;
                string2 = new String(byArray, "UTF-8");
            }
            byArray = null;
            inputStream.close();
            dataInputStream = null;
            try {
                this.abutText = "";
                int n = 1;
                while (n < string2.length()) {
                    if (string2.charAt(n) != '|' || string2.charAt(n + 1) != '|' || string2.charAt(n + 2) != '|') {
                        this.abutText = string2.charAt(n) == '~' ? this.abutText + "\n" : this.abutText + string2.charAt(n);
                        ++n;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("1 " + exception);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

