/*
 * Decompiled with CFR 0.152.
 */
package cityKnights.man;

import cityKnights.Game;
import cityKnights.common.Utils;
import cityKnights.man.MovableMan;
import java.util.Stack;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Fighter
extends MovableMan
implements Runnable {
    public static Image[] fighterImages = new Image[16];
    public static Image ow;
    public Thread gameThread;
    public Stack keyStack = new Stack();

    public Fighter(Game game) {
        super(game);
        this.images = fighterImages;
    }

    public void init() {
        this.gameThread = new Thread(this);
        this.gameThread.start();
        this.lastKickTime = System.currentTimeMillis();
    }

    public void putEvent(int n) {
        this.keyStack.push(new Integer(n));
    }

    public void draw(Graphics graphics, int n) {
        super.draw(graphics, n);
        if (MovableMan.fire == -1) {
            int n2 = Utils.random.nextInt();
            n2 = Math.abs(n2 % 15);
            graphics.drawImage(ow, this.x - Game.currentBkg_X, this.y - 35 + n2, 0x20 | 1);
        }
    }

    public boolean strike() {
        if (this.state == 2) {
            this.state = 6;
            return this.game.checkResult(this);
        }
        return super.strike();
    }

    public boolean kick() {
        if (this.state == 3) {
            this.state = 7;
            return this.game.checkResult(this);
        }
        return super.kick();
    }

    public void run() {
        while (true) {
            if (!this.keyStack.empty()) {
                int n = (Integer)this.keyStack.pop();
                this.process(n);
                this.keyStack.removeAllElements();
                this.game.repaint();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    protected void process(int n) {
        int n2 = this.game.getGameAction(n);
        if (n == 52) {
            this.step(-1);
        } else if (n == 54) {
            this.step(1);
        } else if (n == 50) {
            this.jump();
        } else if (n == 51) {
            this.jumpAhead(1);
        } else if (n == 49) {
            this.jumpAhead(-1);
        } else if (n == 56) {
            this.crouch();
        } else if (n == 57) {
            if (System.currentTimeMillis() - this.lastKickTime > 1000L) {
                this.kick();
                this.lastKickTime = System.currentTimeMillis();
            }
        } else if (n == 53) {
            if (System.currentTimeMillis() - this.lastKickTime > 1000L) {
                this.strike();
                this.lastKickTime = System.currentTimeMillis();
            }
        } else if (n2 == 2) {
            this.step(-1);
        } else if (n2 == 5) {
            this.step(1);
        } else if (n2 == 1) {
            this.jump();
        } else if (n2 == 6) {
            this.crouch();
        } else if (n2 == 8) {
            if (System.currentTimeMillis() - this.lastKickTime > 1000L) {
                this.strike();
                this.lastKickTime = System.currentTimeMillis();
            }
        } else if (n == 48) {
            this.game.gamePaused();
        }
    }
}

