/*
 * Decompiled with CFR 0.152.
 */
package cityKnights.man;

import cityKnights.Constants;
import cityKnights.Game;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class MovableMan
implements Constants {
    public int state = 0;
    public static int fire = 0;
    protected Image[] images = new Image[18];
    protected Game game;
    public int x;
    public int y;
    long lastKickTime;

    public MovableMan(Game game) {
        this.game = game;
    }

    public void draw(Graphics graphics, int n) {
        int n2 = graphics.getClipX();
        int n3 = graphics.getClipY();
        int n4 = graphics.getClipWidth();
        int n5 = graphics.getClipHeight();
        if (this.images[this.state] == null) {
            return;
        }
        graphics.setClip(n2, n3, n4, n5);
        if (n != 0) {
            graphics.drawImage(this.images[this.state], this.x - Game.currentBkg_X, this.y, 0x20 | 1);
        } else {
            graphics.drawImage(this.images[this.state + 10], this.x - Game.currentBkg_X, this.y, 0x20 | 1);
        }
    }

    public void move(int n) {
        int n2 = this.x + n;
        this.x = n2 < Game.start_position ? Game.start_position : (n2 > Game.bkg_width - Game.start_position ? Game.bkg_width - Game.start_position : n2);
    }

    public void setJumpPosition(boolean bl) {
        this.y = Game.bottomline - (bl ? 25 : 0);
    }

    public boolean strike() {
        if (this.state == 0 || this.state == 1) {
            this.state = 4;
            boolean bl = this.game.checkResult(this);
            this.game.repaint();
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.game.gameOver) {
                return false;
            }
            this.state = 0;
            this.game.repaint();
            return bl;
        }
        return false;
    }

    public boolean kick() {
        if (this.state == 0 || this.state == 1) {
            this.state = 5;
            this.game.repaint();
            boolean bl = this.game.checkResult(this);
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.game.gameOver) {
                return false;
            }
            this.state = 0;
            this.game.repaint();
            return bl;
        }
        return false;
    }

    public void crouch() {
        if (this.state == 0 || this.state == 1) {
            this.state = 2;
            this.game.repaint();
            TimerTask timerTask = new TimerTask(){

                public final void run() {
                    if (MovableMan.this.game.gameOver) {
                        return;
                    }
                    MovableMan.this.state = 0;
                    MovableMan.this.game.repaint();
                }
            };
            new Timer().schedule(timerTask, 500L);
        }
    }

    public void jump() {
        if (this.state == 0 || this.state == 1) {
            this.state = 3;
            this.setJumpPosition(true);
            this.game.repaint();
            TimerTask timerTask = new TimerTask(){

                public final void run() {
                    if (MovableMan.this.game.gameOver) {
                        return;
                    }
                    MovableMan.this.setJumpPosition(false);
                    MovableMan.this.state = 0;
                    MovableMan.this.game.repaint();
                }
            };
            new Timer().schedule(timerTask, 500L);
        }
    }

    public void step(int n) {
        if (this.state == 0) {
            this.state = 1;
            this.move(n * 6);
            this.game.repaint();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.state = 0;
            this.game.repaint();
        }
    }

    public void jumpAhead(int n) {
        if (this.game.gameOver) {
            return;
        }
        if (this.state == 0 || this.state == 1) {
            this.state = 3;
            this.move(n * 20 / 2);
            this.setJumpPosition(true);
            this.game.repaint();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.game.gameOver) {
                return;
            }
            this.move(n * 20 / 2);
            this.setJumpPosition(false);
            this.state = 0;
            this.game.repaint();
        }
    }

    public void jumpoff(int n) {
        if (this.game.gameOver) {
            return;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.game.gameOver) {
            return;
        }
        this.move((n * this.game.distance() > 0 ? -1 : 1) * 25);
        this.state = 0;
    }
}

