/*
 * Decompiled with CFR 0.152.
 */
package cityKnights.man;

import cityKnights.Game;
import cityKnights.common.Utils;
import cityKnights.man.MovableMan;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Opponent
extends MovableMan
implements Runnable {
    public static Image[] opponentImages = new Image[16];
    public static Image fw;
    private boolean stop = false;

    public Opponent(Game game) {
        super(game);
        this.images = opponentImages;
    }

    public void init() {
        this.state = 0;
        this.lastKickTime = System.currentTimeMillis();
    }

    public void draw(Graphics graphics, int n) {
        super.draw(graphics, n);
        if (MovableMan.fire == 1) {
            int n2 = Utils.random.nextInt();
            n2 = Math.abs(n2 % 15);
            graphics.drawImage(fw, this.x - Game.currentBkg_X, this.y - 35 + n2, 0x20 | 1);
        }
    }

    public void start() {
        this.stop = false;
        new Thread(this).start();
    }

    public void stop() {
        this.stop = true;
        System.gc();
    }

    public void run() {
        while (!this.stop) {
            this.performAction(this.getNextAction());
            try {
                Thread.sleep(420L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void performAction(int n) {
        switch (n) {
            case 0: {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
            case 1: {
                this.step(this.game.distance() > 0 ? 1 : -1);
                break;
            }
            case 2: {
                this.crouch();
                break;
            }
            case 3: {
                this.jump();
                break;
            }
            case 4: {
                this.jumpAhead(this.game.distance() > 0 ? 1 : -1);
                break;
            }
            case 5: {
                this.kick();
                break;
            }
            case 6: {
                this.strike();
            }
        }
    }

    public int getNextAction() {
        int[] nArray;
        if (this.game.isKickDistance()) {
            if (System.currentTimeMillis() - this.lastKickTime > 1000L) {
                int[] nArray2 = new int[]{3, 2, 6, 5, 5};
                nArray = nArray2;
            } else {
                int[] nArray3;
                nArray = nArray3 = new int[]{3, 2};
            }
        } else if (this.game.isStrikeDistance()) {
            if (System.currentTimeMillis() - this.lastKickTime > 1000L) {
                int[] nArray4 = new int[]{6, 6, 6, 2, 2, 1, 4};
                nArray = nArray4;
            } else {
                int[] nArray5 = new int[]{1, 2, 2, 4};
                nArray = nArray5;
            }
        } else {
            int[] nArray6 = new int[]{1, 1, 1, 1, 1, 0, 0, 0, 0, 4};
            nArray = nArray6;
        }
        int n = Utils.getRandomIntElement(nArray);
        if (n == 5 || n == 6) {
            this.lastKickTime = System.currentTimeMillis();
        }
        return n;
    }
}

