/*
 * Decompiled with CFR 0.152.
 */
package cityKnights;

import cityKnights.AlertForm;
import cityKnights.Game;
import cityKnights.LangSelect;
import cityKnights.SplashScreen;
import cityKnights.Starter;
import cityKnights.common.LoadGame;
import cityKnights.common.OpponentCanvas;
import cityKnights.common.ScoreEntry;
import cityKnights.common.Scores;
import cityKnights.common.StoreGameForm;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public final class MenuCanvas
extends Canvas
implements CommandListener {
    Starter starter;
    Game game = null;
    public Command newGameCommand;
    public Command quitCommand;
    public Command helpCommand;
    public Command highScoresCommand;
    public Command storeCommand;
    public Command loadCommand;
    public Command continueCommand;
    public Command aboutCommand;
    public Command langCommand;
    String helpText;
    String abutText;
    String prevlang = "";
    String lang;
    String[] LangLabel;
    byte numLangs = 1;
    MenuCanvas MC = this;

    public MenuCanvas(Starter starter) {
        this.starter = starter;
        this.addCMDs();
        this.setCommandListener(this);
    }

    public void addCMDs() {
        this.removeMainCommands();
        this.quitCommand = new Command(this.starter.LD.translate("EXIT"), 6, 10);
        this.continueCommand = new Command(this.starter.LD.translate("RESUME"), 4, 1);
        this.newGameCommand = new Command(this.starter.LD.translate("START"), 1, 2);
        this.loadCommand = new Command(this.starter.LD.translate("LOAD GAME"), 1, 3);
        this.storeCommand = new Command(this.starter.LD.translate("STORE GAME"), 4, 3);
        this.highScoresCommand = new Command(this.starter.LD.translate("HIGH SCORES"), 1, 5);
        this.helpCommand = new Command(this.starter.LD.translate("HELP"), 1, 6);
        this.aboutCommand = new Command(this.starter.LD.translate("ABOUT"), 1, 7);
        this.langCommand = new Command(this.starter.LD.translate("LANGUAGE"), 1, 4);
        this.addMainCommands();
    }

    private void addMainCommands() {
        this.addCommand(this.quitCommand);
        this.addCommand(this.continueCommand);
        this.addCommand(this.newGameCommand);
        this.addCommand(this.loadCommand);
        this.addCommand(this.storeCommand);
        this.addCommand(this.highScoresCommand);
        this.addCommand(this.helpCommand);
        this.addCommand(this.aboutCommand);
        this.addCommand(this.langCommand);
    }

    private void removeMainCommands() {
        this.removeCommand(this.continueCommand);
        this.removeCommand(this.storeCommand);
        this.removeCommand(this.newGameCommand);
        this.removeCommand(this.loadCommand);
        this.removeCommand(this.highScoresCommand);
        this.removeCommand(this.helpCommand);
        this.removeCommand(this.aboutCommand);
        this.removeCommand(this.langCommand);
        this.removeCommand(this.quitCommand);
    }

    public void setGame(Game game) {
        this.game = game;
        if (game != null && !game.gameOver) {
            this.addCommand(this.continueCommand);
            this.addCommand(this.storeCommand);
        } else {
            this.removeCommand(this.continueCommand);
            this.removeCommand(this.storeCommand);
        }
    }

    protected void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.game != null) {
            graphics.setColor(64, 64, 64);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(0xFFFFFF);
            if (this.game.gameOver) {
                graphics.drawString(this.starter.LD.translate("Game Over"), n / 2, n2 / 2 - 10, 65);
                graphics.drawString(this.starter.LD.translate("Score") + ": " + new Integer(Game.sfStatus.score).toString(), n / 2, n2 / 2 + 10, 65);
            } else {
                graphics.drawString(this.starter.LD.translate("Game Paused"), n / 2, n2 / 2, 65);
            }
        } else {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, Game.screen_WIDTH, Game.screen_HEIGHT);
            graphics.drawImage(SplashScreen.flash, n / 2, n2 / 2, 3);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 6) {
            this.starter.exitMidlet();
        } else if (command == this.continueCommand) {
            Starter.setDisplayable((Displayable)this.game);
            this.game.resumeGame();
        } else if (command == this.newGameCommand) {
            OpponentCanvas opponentCanvas = new OpponentCanvas((Displayable)this, this.starter);
            Starter.setDisplayable((Displayable)opponentCanvas);
        } else if (command == this.helpCommand) {
            this.showHelp();
        } else if (command == this.highScoresCommand) {
            this.showScores();
        } else if (command == this.loadCommand) {
            LoadGame loadGame = new LoadGame((Displayable)this, this.starter, this.starter.LD.translate("Select stored game"));
            Starter.setDisplayable((Displayable)loadGame);
        } else if (command == this.aboutCommand) {
            this.showAbout();
        } else if (command == this.langCommand) {
            LangSelect langSelect = new LangSelect((Displayable)this, this.starter, this.MC);
            Starter.setDisplayable((Displayable)langSelect);
        } else if (command == this.storeCommand) {
            Starter.setDisplayable((Displayable)new StoreGameForm(this.game, this.starter));
        }
    }

    public void showHelp() {
        if (this.helpText == null) {
            this.readHelp(this.lang);
        }
        AlertForm alertForm = new AlertForm(this.starter.LD.translate("HELP"), this.game, this.starter.LD);
        alertForm.append(this.helpText);
        Starter.setDisplayable((Displayable)alertForm);
    }

    public void showAbout() {
        if (this.abutText == null) {
            this.readAbut(this.lang);
        }
        AlertForm alertForm = new AlertForm(this.starter.LD.translate("ABOUT"), this.game, this.starter.LD);
        alertForm.append(this.abutText);
        Starter.setDisplayable((Displayable)alertForm);
    }

    public void showScores() {
        AlertForm alertForm = new AlertForm(this.starter.LD.translate("HIGH SCORES"), this.game, this.starter.LD);
        Scores scores = Starter.scores;
        if (scores != null) {
            String string = "Max Scores:\n";
            int n = 0;
            while (n < scores.size()) {
                ScoreEntry scoreEntry = (ScoreEntry)scores.elementAt(n);
                alertForm.append("" + (n + 1) + "." + scoreEntry.name + "  " + scoreEntry.score + "\n");
                ++n;
            }
        }
        Starter.setDisplayable((Displayable)alertForm);
    }

    public void readHelp(String string) {
        string = this.starter.LD.lang;
        boolean bl = false;
        try {
            String string2 = "";
            Class<?> clazz = ((Object)((Object)this)).getClass();
            InputStream inputStream = clazz.getResourceAsStream("/help." + string + ".txt");
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte[] byArray = new byte[500];
            try {
                dataInputStream.read(byArray);
            }
            catch (Exception exception) {
                System.out.println("2 " + exception);
            }
            if ((char)byArray[0] == 'A') {
                byArray[0] = 32;
                string2 = new String(byArray, "ISO8859_1");
            } else if ((char)byArray[0] == 'B') {
                byArray[0] = 32;
                string2 = new String(byArray, "UTF-8");
            }
            byArray = null;
            inputStream.close();
            dataInputStream = null;
            try {
                this.helpText = "";
                int n = 1;
                while (n < string2.length()) {
                    if (string2.charAt(n) != '|' || string2.charAt(n + 1) != '|' || string2.charAt(n + 2) != '|') {
                        this.helpText = string2.charAt(n) == '~' ? this.helpText + "\n" : this.helpText + string2.charAt(n);
                        ++n;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("1 " + exception);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println("ssss" + iOException);
        }
    }

    public void readAbut(String string) {
        string = this.starter.LD.lang;
        boolean bl = false;
        try {
            String string2 = "";
            Class<?> clazz = ((Object)((Object)this)).getClass();
            InputStream inputStream = clazz.getResourceAsStream("/about." + string + ".txt");
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte[] byArray = new byte[500];
            try {
                dataInputStream.read(byArray);
            }
            catch (Exception exception) {
                System.out.println("2 " + exception);
            }
            if ((char)byArray[0] == 'A') {
                byArray[0] = 32;
                string2 = new String(byArray, "ISO8859_1");
            } else if ((char)byArray[0] == 'B') {
                byArray[0] = 32;
                string2 = new String(byArray, "UTF-8");
            }
            byArray = null;
            inputStream.close();
            dataInputStream = null;
            try {
                this.abutText = "";
                int n = 1;
                while (n < string2.length()) {
                    if (string2.charAt(n) != '|' || string2.charAt(n + 1) != '|' || string2.charAt(n + 2) != '|') {
                        this.abutText = string2.charAt(n) == '~' ? this.abutText + "\n" : this.abutText + string2.charAt(n);
                        ++n;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("1 " + exception);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println("ssss" + iOException);
        }
    }
}

