/*
 * Decompiled with CFR 0.152.
 */
package cityKnights.common;

import cityKnights.Constants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class SFStatus
implements Constants {
    public String name = "";
    public int opponentType = 0;
    public int level = 1;
    public int score = 0;
    public int bkgNumber = 1;
    public int fighter_life = 10;
    public int opponent_life = 10;
    public int timeLeft = 120000;
    public int fighter_x;
    public int opponent_x;

    public SFStatus() {
        this.resetLevel();
    }

    public SFStatus(int n) {
        this.opponentType = n;
    }

    public void resetLevel() {
        this.timeLeft = 120000;
        this.fighter_life = 10;
        this.opponent_life = SFStatus.getMax_opponent_life(this.level + 1);
    }

    public void writeBytes(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeInt(this.opponentType);
        dataOutputStream.writeInt(this.level);
        dataOutputStream.writeInt(this.score);
        dataOutputStream.writeInt(this.fighter_life);
        dataOutputStream.writeInt(this.opponent_life);
        dataOutputStream.writeInt(this.timeLeft);
        dataOutputStream.writeInt(this.fighter_x);
        dataOutputStream.writeInt(this.opponent_x);
        dataOutputStream.writeInt(this.bkgNumber);
    }

    public void readBytes(DataInputStream dataInputStream) throws IOException {
        this.name = dataInputStream.readUTF();
        this.opponentType = dataInputStream.readInt();
        this.level = dataInputStream.readInt();
        this.score = dataInputStream.readInt();
        this.fighter_life = dataInputStream.readInt();
        this.opponent_life = dataInputStream.readInt();
        this.timeLeft = dataInputStream.readInt();
        this.fighter_x = dataInputStream.readInt();
        this.opponent_x = dataInputStream.readInt();
        this.bkgNumber = dataInputStream.readInt();
    }

    public static int getMax_opponent_life(int n) {
        return 10 + 2 * (n - 1);
    }
}

