/*
 * Decompiled with CFR 0.152.
 */
package cityKnights;

import cityKnights.Constants;
import cityKnights.Starter;
import cityKnights.common.NameForm;
import cityKnights.common.SFStatus;
import cityKnights.common.Utils;
import cityKnights.man.Fighter;
import cityKnights.man.MovableMan;
import cityKnights.man.Opponent;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public final class Game
extends Canvas
implements Constants {
    Starter starter;
    public static final String WINNER = "You are Winner";
    public static final String GAME_OVER = "Game Over";
    public static boolean soundOn = true;
    public static int screen_WIDTH;
    public static int screen_HEIGHT;
    public static SFStatus sfStatus;
    public Fighter fighter;
    public Opponent opponent;
    private Font nameFont;
    private Font pauseFont;
    public static int bottomline;
    public static int start_position;
    private Timer timer;
    public Image currentBkg;
    public static Image toppanel;
    public static Image cloud;
    public static Image ri;
    public static Image vi;
    public static int currentBkg_X;
    public static int bkg_H;
    public static int bkg_width;
    public boolean gameOver = true;
    public boolean waitingForEndOfLevel = false;
    public boolean waitingForBeginOfNewLevel = false;
    int counting = 0;
    boolean pressed = false;

    public Game(Starter starter) {
        this.starter = starter;
        bottomline = 95 * screen_HEIGHT / 100;
        this.pauseFont = Font.getFont((int)32, (int)0, (int)8);
        this.nameFont = Font.getFont((int)32, (int)0, (int)8);
        this.fighter = new Fighter(this);
        this.opponent = new Opponent(this);
    }

    public void startGame(SFStatus sFStatus) {
        Opponent.opponentImages = null;
        this.fighter.init();
        this.opponent.init();
        sfStatus = null;
        sfStatus = sFStatus;
        this.startLevel(sFStatus.level);
    }

    protected void startLevel(int n) {
        System.out.println("Game : Start Level 1 " + Runtime.getRuntime().freeMemory());
        this.setBackground();
        Game.sfStatus.level = n;
        Game.sfStatus.fighter_x = bkg_width / 2 - screen_WIDTH / 2 + start_position;
        Game.sfStatus.opponent_x = bkg_width / 2 + screen_WIDTH / 2 - start_position;
        this.fighter.x = Game.sfStatus.fighter_x;
        this.opponent.x = Game.sfStatus.opponent_x;
        this.fighter.y = this.opponent.y = bottomline;
        this.fighter.state = 0;
        this.gameOver = false;
        Starter.setDisplayable((Displayable)this);
        this.resumeGame();
    }

    public void startClock(int n) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        System.gc();
        TimerTask timerTask = new TimerTask(){

            public void run() {
                Game.this.gameOver();
            }
        };
        TimerTask timerTask2 = new TimerTask(){

            public void run() {
                Game.sfStatus.timeLeft -= 100;
                Game.this.repaint();
            }
        };
        this.timer.schedule(timerTask, n);
        this.timer.schedule(timerTask2, 0L, 100L);
    }

    public void paint(Graphics graphics) {
        this.calcScreenPosition();
        graphics.setClip(0, 0, screen_WIDTH, screen_HEIGHT);
        int n = 27;
        this.paintHeader(graphics, n);
        if (Game.sfStatus.bkgNumber == 1) {
            graphics.setColor(55, 24, 5);
            graphics.drawLine(0, n, screen_WIDTH, n);
            ++n;
        }
        if (Game.sfStatus.bkgNumber == 2) {
            int n2 = n;
            graphics.setColor(153, 204, 255);
            graphics.fillRect(0, n2, screen_WIDTH, n2 + 60);
            n2 += 60;
        }
        try {
            if (this.currentBkg != null) {
                graphics.drawImage(this.currentBkg, -currentBkg_X, n, 20);
                n += bkg_H;
            }
        }
        catch (Exception exception) {
            System.out.println("backg " + exception);
        }
        graphics.setColor(0xFFFFFF);
        graphics.drawString(new Integer(Game.sfStatus.score).toString(), screen_WIDTH / 2, 36, 33);
        this.paintFooter(graphics, n);
        try {
            this.paintFighters(graphics);
        }
        catch (Exception exception) {
            System.out.println("fighter " + exception);
        }
        if (this.waitingForEndOfLevel) {
            graphics.setFont(this.pauseFont);
            graphics.setStrokeStyle(1);
            graphics.setColor(166, 107, 70);
            graphics.setColor(166, 107, 70);
            graphics.fillRect(screen_WIDTH / 2 - 70, n / 2 - 30, 140, 45);
            graphics.setColor(0xFFFFFF);
            graphics.drawString("You won round " + Game.sfStatus.level + "", screen_WIDTH / 2, n / 2 - 10, 33);
            graphics.drawString("Press any key", screen_WIDTH / 2, n / 2 + 10, 33);
        }
        if (this.waitingForBeginOfNewLevel) {
            graphics.setFont(this.pauseFont);
            graphics.setStrokeStyle(1);
            graphics.setColor(166, 107, 70);
            graphics.fillRect(screen_WIDTH / 2 - 70, n / 2 - 30, 140, 45);
            graphics.setColor(0xFFFFFF);
            graphics.drawString("Level " + Game.sfStatus.level + "", screen_WIDTH / 2, n / 2 - 10, 33);
            graphics.drawString("Press any key", screen_WIDTH / 2, n / 2 + 10, 33);
        }
    }

    protected void paintHeader(Graphics graphics, int n) {
        graphics.setColor(166, 107, 70);
        graphics.fillRect(0, 0, screen_WIDTH, n);
        graphics.drawImage(toppanel, screen_WIDTH / 2, 1, 17);
        int n2 = 39;
        int n3 = 10;
        graphics.setFont(this.nameFont);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("You", -n2 + screen_WIDTH / 2, n3, 65);
        graphics.drawString(Constants.opponents[Game.sfStatus.opponentType], n2 + screen_WIDTH / 2, n3, 65);
        int n4 = Game.sfStatus.timeLeft / 60000;
        int n5 = (Game.sfStatus.timeLeft - n4 * 60000) / 1000;
        String string = new Integer(n5).toString();
        if (n5 < 10) {
            string = "0" + string;
        }
        graphics.setColor(0);
        graphics.drawString(n4 + "." + string, screen_WIDTH / 2, n3 + 3, 65);
        int n6 = 4;
        int n7 = 10;
        int n8 = Game.sfStatus.fighter_life;
        while (n8 > 0) {
            graphics.drawImage(ri, screen_WIDTH / 2 - n8 * n6 - n7, 16, 17);
            --n8;
        }
        n7 = 14;
        int n9 = 0;
        while (n9 < Game.sfStatus.opponent_life) {
            int n10 = n9 * 10 / SFStatus.getMax_opponent_life(Game.sfStatus.level);
            graphics.drawImage(vi, screen_WIDTH / 2 + n10 * n6 + n7, 16, 17);
            ++n9;
        }
    }

    protected void paintFooter(Graphics graphics, int n) {
        if (Game.sfStatus.bkgNumber == 1) {
            graphics.setColor(64, 64, 64);
        } else if (Game.sfStatus.bkgNumber == 2) {
            graphics.setColor(164, 165, 177);
        } else if (Game.sfStatus.bkgNumber == 3) {
            graphics.setColor(118, 141, 145);
        } else {
            graphics.setColor(116, 122, 128);
        }
        graphics.fillRect(0, n, screen_WIDTH, screen_HEIGHT - n);
    }

    protected void paintFighters(Graphics graphics) {
        int n = this.distance() > 0 ? 1 : 0;
        this.fighter.draw(graphics, n);
        this.opponent.draw(graphics, 1 - n);
    }

    protected void calcScreenPosition() {
        currentBkg_X = (this.opponent.x + this.fighter.x) / 2 < screen_WIDTH / 2 ? 0 : (bkg_width - (this.opponent.x + this.fighter.x) / 2 < screen_WIDTH / 2 ? bkg_width - screen_WIDTH : (this.opponent.x + this.fighter.x) / 2 - screen_WIDTH / 2);
    }

    public int distance() {
        return this.fighter.x - this.opponent.x;
    }

    public boolean checkResult(MovableMan movableMan) {
        if (this.gameOver) {
            return false;
        }
        boolean bl = this.calcResult(movableMan);
        if (bl) {
            MovableMan.fire = movableMan == this.fighter ? 1 : -1;
            this.repaint();
            TimerTask timerTask = new TimerTask(){

                public final void run() {
                    MovableMan.fire = 0;
                    Game.this.repaint();
                }
            };
            new Timer().schedule(timerTask, 300L);
        }
        return bl;
    }

    public boolean calcResult(MovableMan movableMan) {
        int n = this.fighter.state;
        int n2 = this.fighter.state;
        if (n2 == 5 && n == 3 || n2 == 4 && n == 2 || n2 == 4 && n == 2) {
            return false;
        }
        if (movableMan == this.fighter) {
            if (!(n != 4 && n != 6 || this.isStrikeDistance())) {
                return false;
            }
            if (!(n != 5 && n != 7 || this.isKickDistance())) {
                return false;
            }
            this.fighterSuccess();
            return true;
        }
        if (n2 == 4 && n == 6) {
            return false;
        }
        if (n2 == 5 && n == 7) {
            return false;
        }
        this.opponentSuccess();
        return true;
    }

    private void fighterSuccess() {
        this.opponent.jumpoff(1);
        Game.sfStatus.score += 100;
        --Game.sfStatus.opponent_life;
        if (soundOn) {
            AlertType.ERROR.playSound(Starter.display);
        }
        if (Game.sfStatus.opponent_life == 0) {
            this.gameOver = true;
            this.interruptGame();
            if (soundOn) {
                AlertType.CONFIRMATION.playSound(Starter.display);
            }
            if (Game.sfStatus.level < 10) {
                this.waitingForEndOfLevel = true;
                this.repaint();
            } else {
                this.gameOver();
            }
        } else {
            this.repaint();
        }
    }

    private void opponentSuccess() {
        this.fighter.jumpoff(-1);
        Game.sfStatus.score -= 10;
        if (Game.sfStatus.score < 0) {
            Game.sfStatus.score = 0;
        }
        --Game.sfStatus.fighter_life;
        if (soundOn) {
            AlertType.ERROR.playSound(Starter.display);
        }
        if (Game.sfStatus.fighter_life == 0) {
            if (soundOn) {
                AlertType.WARNING.playSound(Starter.display);
            }
            this.gameOver();
        } else {
            this.repaint();
        }
    }

    private void gameOver() {
        this.gameOver = true;
        System.gc();
        this.interruptGame();
        int n = Starter.scores.evaluateScore();
        if (n >= 0 && n < 10) {
            Starter.setDisplayable((Displayable)new NameForm(this.starter.LD.translate("New high score"), this.starter.LD.translate("Enter Your Name")));
        } else {
            Starter.showMenu(this);
        }
        this.currentBkg = null;
        try {
            Opponent.opponentImages = null;
        }
        catch (Exception exception) {
            System.out.println("oppo " + exception);
        }
    }

    private void setBackground() {
        while (true) {
            try {
                this.currentBkg = null;
                if (Game.sfStatus.bkgNumber > 3) {
                    Game.sfStatus.bkgNumber = 1;
                }
                this.currentBkg = Image.createImage((String)("/bg" + Game.sfStatus.bkgNumber + ".png"));
            }
            catch (Exception exception) {
                Game.sfStatus.bkgNumber = 1;
                continue;
            }
            break;
        }
        System.gc();
        bkg_H = this.currentBkg.getHeight();
        bkg_width = this.currentBkg.getWidth();
        start_position = 10 * bkg_width / 100;
        int n = Game.sfStatus.opponentType;
        try {
            if (Opponent.opponentImages == null) {
                Opponent.opponentImages = Utils.loadImage("/" + (n + 1) + "0.png");
            }
        }
        catch (Exception exception) {
            System.out.println("opponent " + exception);
        }
        System.gc();
    }

    public void keyRepeated(int n) {
        if (!this.pressed) {
            this.keyPressed(n);
            this.pressed = true;
        }
    }

    public void gamePaused() {
        this.interruptGame();
        Starter.showMenu(this);
    }

    public void resumeGame() {
        this.repaint();
        this.fighter.keyStack.removeAllElements();
        System.gc();
        if (!this.gameOver && !this.waitingForBeginOfNewLevel) {
            this.startClock(Game.sfStatus.timeLeft);
            if (this.opponent != null) {
                this.opponent.start();
            }
        }
    }

    public void interruptGame() {
        this.repaint();
        this.fighter.keyStack.removeAllElements();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.opponent != null) {
            this.opponent.stop();
        }
        System.gc();
    }

    public boolean isStrikeDistance() {
        return Math.abs(this.distance()) < 40;
    }

    public boolean isKickDistance() {
        return Math.abs(this.distance()) < 25;
    }

    protected void keyPressed(int n) {
        if (Starter.display.getCurrent() == this) {
            if (this.waitingForEndOfLevel) {
                this.waitingForEndOfLevel = false;
                this.waitingForBeginOfNewLevel = true;
                sfStatus.resetLevel();
                ++Game.sfStatus.bkgNumber;
                this.startLevel(Game.sfStatus.level + 1);
            } else if (this.waitingForBeginOfNewLevel) {
                this.waitingForBeginOfNewLevel = false;
                this.resumeGame();
            } else {
                this.fighter.putEvent(n);
            }
        }
    }

    public MIDlet getStarter() {
        return this.starter;
    }

    public void resume() {
        this.resumeGame();
    }

    public void stop() {
        this.interruptGame();
    }

    public void closePressed() {
    }

    public void keyReleased(int n) {
        this.pressed = false;
    }

    protected void showNotify() {
        this.resumeGame();
    }

    protected void hideNotify() {
        if (!(Starter.display.getCurrent() instanceof NameForm)) {
            this.gamePaused();
        }
    }
}

