/*
 * Decompiled with CFR 0.152.
 */
package cityKnights.man;

import cityKnights.Constants;
import cityKnights.Game;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class MovableMan
implements Constants {
    public int state = 0;
    public static int fire = 0;
    protected Image images;
    protected Game game;
    public int[][] tileX = new int[][]{{0, 24, 52, 76, 96, 148, 184, 218, 260}, {0, 23, 51, 75, 97, 153, 194, 231, 275}, {0, 22, 49, 71, 91, 144, 181, 215, 257}};
    public int[][] tileW = new int[][]{{24, 28, 24, 20, 52, 36, 34, 42}, {23, 28, 24, 22, 56, 41, 37, 44}, {22, 27, 22, 20, 52, 38, 34, 42}};
    public int[][] tileH = new int[][]{{42, 42, 29, 30, 39, 44, 43, 26}, {44, 44, 31, 31, 42, 46, 44, 29}, {42, 42, 30, 29, 39, 45, 42, 26}};
    public int x;
    public int y;
    long lastKickTime;
    boolean t = false;

    public MovableMan(Game game) {
        this.game = game;
    }

    public void draw(Graphics graphics, int n) {
        int n2 = graphics.getClipX();
        int n3 = graphics.getClipY();
        int n4 = graphics.getClipWidth();
        int n5 = graphics.getClipHeight();
        int n6 = 0;
        int n7 = 0;
        if (this.t) {
            n7 = Game.sfStatus.opponentType + 1;
        }
        if (this.images == null) {
            return;
        }
        graphics.setClip(n2, n3, n4, n5);
        switch (n7) {
            case 0: {
                n6 = 44;
                break;
            }
            case 1: {
                n6 = 46;
                break;
            }
            case 2: {
                n6 = 45;
            }
        }
        if (n != 0) {
            if (this.state != 2 && this.state != 7) {
                graphics.setClip(this.x - Game.currentBkg_X - this.tileW[n7][this.state] / 2, this.y - n6, this.tileW[n7][this.state], n6);
                graphics.drawImage(this.images, this.x + this.images.getWidth() / 2 - this.tileW[n7][this.state] / 2 - this.tileX[n7][this.state] - Game.currentBkg_X, this.y, 0x20 | 1);
            } else {
                graphics.setClip(this.x - Game.currentBkg_X - this.tileW[n7][this.state] / 2, this.y - n6 + (n6 - this.tileH[n7][this.state]), this.tileW[n7][this.state], n6);
                graphics.drawImage(this.images, this.x + this.images.getWidth() / 2 - this.tileW[n7][this.state] / 2 - this.tileX[n7][this.state] - Game.currentBkg_X, this.y + (n6 - this.tileH[n7][this.state]), 0x20 | 1);
            }
            graphics.setClip(0, 0, 128, 128);
        } else {
            if (this.state != 2 && this.state != 7) {
                graphics.drawRegion(this.images, this.tileX[n7][this.state], 0, this.tileW[n7][this.state], n6, 2, this.x - Game.currentBkg_X - this.tileW[n7][this.state] / 2, this.y - n6, 0x10 | 4);
            } else {
                graphics.setClip(this.x - Game.currentBkg_X - this.tileW[n7][this.state] / 2, this.y - n6 + (n6 - this.tileH[n7][this.state]), this.tileW[0][this.state], n6);
                graphics.drawRegion(this.images, this.tileX[n7][this.state], 0, this.tileW[0][this.state], n6, 2, this.x - Game.currentBkg_X - this.tileW[n7][this.state] / 2, this.y - n6 + (n6 - this.tileH[n7][this.state]), 0x10 | 4);
            }
            graphics.setClip(0, 0, 128, 128);
        }
    }

    public void move(int n) {
        int n2 = this.x + n;
        this.x = n2 < Game.start_position ? Game.start_position : (n2 > Game.bkg_width - Game.start_position ? Game.bkg_width - Game.start_position : n2);
    }

    public void setJumpPosition(boolean bl) {
        this.y = Game.bottomline - (bl ? 25 : 0);
    }

    public boolean strike() {
        if (this.state == 0 || this.state == 1) {
            this.state = 4;
            boolean bl = this.game.checkResult(this);
            this.game.repaint();
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.game.gameOver) {
                return false;
            }
            this.state = 0;
            this.game.repaint();
            return bl;
        }
        return false;
    }

    public boolean kick() {
        if (this.state == 0 || this.state == 1) {
            this.state = 5;
            this.game.repaint();
            boolean bl = this.game.checkResult(this);
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.game.gameOver) {
                return false;
            }
            this.state = 0;
            this.game.repaint();
            return bl;
        }
        return false;
    }

    public void crouch() {
        if (this.state == 0 || this.state == 1) {
            this.state = 2;
            this.game.repaint();
            TimerTask timerTask = new TimerTask(){

                public final void run() {
                    if (MovableMan.this.game.gameOver) {
                        return;
                    }
                    MovableMan.this.state = 0;
                    MovableMan.this.game.repaint();
                }
            };
            new Timer().schedule(timerTask, 500L);
        }
    }

    public void jump() {
        if (this.state == 0 || this.state == 1) {
            this.state = 3;
            this.setJumpPosition(true);
            this.game.repaint();
            TimerTask timerTask = new TimerTask(){

                public final void run() {
                    if (MovableMan.this.game.gameOver) {
                        return;
                    }
                    MovableMan.this.setJumpPosition(false);
                    MovableMan.this.state = 0;
                    MovableMan.this.game.repaint();
                }
            };
            new Timer().schedule(timerTask, 500L);
        }
    }

    public void step(int n) {
        if (this.state == 0) {
            this.state = 1;
            this.move(n * 6);
            this.game.repaint();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.state = 0;
            this.game.repaint();
        }
    }

    public void jumpAhead(int n) {
        if (this.game.gameOver) {
            return;
        }
        if (this.state == 0 || this.state == 1) {
            this.state = 3;
            this.move(n * 20 / 2);
            this.setJumpPosition(true);
            this.game.repaint();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.game.gameOver) {
                return;
            }
            this.move(n * 20 / 2);
            this.setJumpPosition(false);
            this.state = 0;
            this.game.repaint();
        }
    }

    public void jumpoff(int n) {
        if (this.game.gameOver) {
            return;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.game.gameOver) {
            return;
        }
        this.move((n * this.game.distance() > 0 ? -1 : 1) * 25);
        this.state = 0;
    }
}

