/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.midlet.MIDlet;

public class SoundPlayer {
    static Sound explSound;
    static Sound pickSound;
    static Sound missionSound;
    static Sound bgSound;
    static Sound hiscoreSound;
    int pickAlive = 0;
    int placeAlive = 0;

    public SoundPlayer(MIDlet mIDlet) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/explosion.wav");
            byte[] byArray = new byte[100000];
            inputStream.read(byArray, 0, byArray.length);
            explSound = new Sound(byArray, 5);
            explSound.init(byArray, 5);
            byte[] byArray2 = new byte[1000];
            pickSound = SoundPlayer.GameSound(mIDlet, "/pickup.ott", byArray2);
            missionSound = SoundPlayer.GameSound(mIDlet, "/mission.ott", byArray2);
            bgSound = SoundPlayer.GameSound(mIDlet, "/bg.ott", byArray2);
            hiscoreSound = SoundPlayer.GameSound(mIDlet, "/hiscore.ott", byArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Sound GameSound(MIDlet mIDlet, String string, byte[] byArray) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(mIDlet.getClass().getResourceAsStream(string));
        int n = dataInputStream.read(byArray);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        Sound sound = new Sound(byArray2, 1);
        dataInputStream.close();
        return sound;
    }

    public void stopSounds() {
        try {
            missionSound.stop();
            explSound.stop();
            pickSound.stop();
            bgSound.stop();
            hiscoreSound.stop();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void playExplosion() {
        this.stopSounds();
        this.play(explSound, 1);
    }

    public void playPickup() {
        this.stopSounds();
        this.play(pickSound, 1);
    }

    public void playMissionComplete() {
        this.stopSounds();
        this.play(missionSound, 0);
    }

    public void playBg() {
        this.stopSounds();
        this.play(bgSound, 0);
    }

    public void playHiscore() {
        this.stopSounds();
        this.play(hiscoreSound, 1);
    }

    public void play(Sound sound, int n) {
        try {
            if (sound.getState() != 0) {
                sound.play(n);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

