/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FontText {
    public static int font_small_id = 0;
    public static int font_big_id = 1;
    private static Image[] fontImg = new Image[2];
    private static byte[][] fontX;
    private static byte[][] fontY;
    private static byte[][] fontW;
    private static byte[] fontH;
    private static byte[] fontSpace;
    private static byte[] fontDx;
    private static String mapFile;
    private static byte[][] mTexts;
    private static short[][] mTextIndexes;
    public static final int AA_LT = 0;
    public static final int AA_LC = 4;
    public static final int AA_LB = 8;
    public static final int AA_CT = 1;
    public static final int AA_CC = 5;
    public static final int AA_CB = 9;
    public static final int AA_RT = 2;
    public static final int AA_RC = 6;
    public static final int AA_RB = 10;
    public static final int[] anchorShift;
    public static final byte TCHAR_SPACE = -1;
    public static final byte TCHAR_NEW_LINE = -2;
    public static byte[][] lang;
    public static int curLang;

    public static final void loadFonts(String name) {
        try {
            DataInputStream dis = FontText.getFile(name + ".def");
            int num = dis.readUnsignedByte();
            fontX = new byte[2][num];
            fontY = new byte[2][num];
            fontW = new byte[2][num];
            fontH = new byte[num];
            fontSpace = new byte[num];
            fontDx = new byte[num];
            FontText.fontX[0] = FontText.readByteArray(dis, num);
            FontText.fontY[0] = FontText.readByteArray(dis, num);
            FontText.fontW[0] = FontText.readByteArray(dis, num);
            FontText.fontH[0] = dis.readByte();
            FontText.fontSpace[0] = dis.readByte();
            FontText.fontDx[0] = dis.readByte();
            FontText.fontDx[0] = 0;
            dis.close();
            DataInputStream dis1 = FontText.getFile(name + "1.def");
            num = dis1.readUnsignedByte();
            FontText.fontX[1] = FontText.readByteArray(dis1, num);
            FontText.fontY[1] = FontText.readByteArray(dis1, num);
            FontText.fontW[1] = FontText.readByteArray(dis1, num);
            FontText.fontH[1] = dis1.readByte();
            FontText.fontSpace[1] = dis1.readByte();
            FontText.fontDx[1] = dis1.readByte();
            FontText.fontDx[1] = 0;
            dis1.close();
            FontText.loadMap(name + ".map");
            FontText.fontImg[0] = Image.createImage((String)("/" + name + ".png"));
            FontText.fontImg[1] = Image.createImage((String)("/" + name + "1.png"));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private static final void loadMap(String s) {
        DataInputStream dis = FontText.getFile(s);
        mapFile = "";
        try {
            dis.skip(2L);
            while (dis.available() > 0) {
                int c1 = dis.read();
                int c2 = dis.read();
                int code = (c2 & 0xFF) << 8 | c1 & 0xFF;
                char c3 = (char)code;
                mapFile = mapFile + c3;
            }
            try {
                dis.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    public static final DataInputStream getFile(String a_Name) {
        return new DataInputStream(((Object)((Object)Mid.ins)).getClass().getResourceAsStream("/" + a_Name));
    }

    public static final byte[] readByteArray(DataInputStream a_dis, int a_iSize) throws Exception {
        byte[] result = new byte[a_iSize];
        a_dis.read(result);
        return result;
    }

    public static final short[] readShortArray(DataInputStream a_dis, int a_iSize) throws Exception {
        short[] result = new short[a_iSize];
        for (int i2 = 0; i2 < a_iSize; ++i2) {
            result[i2] = a_dis.readShort();
        }
        return result;
    }

    public static final void renderText(Graphics a_g, int a_iTextId, int a_iX, int a_iY, int a_iAnchor, int font_id) {
        if (a_iTextId != -1) {
            byte[] txt = FontText.textByIndex(a_iTextId, curLang);
            FontText.renderText(a_g, txt, a_iX, a_iY, a_iAnchor, font_id);
        }
    }

    public static final void renderText(Graphics a_g, int a_iTextId, int a_iX, int a_iY, int a_iAnchor, int lang, int font_id) {
        if (a_iTextId != -1) {
            byte[] txt = FontText.textByIndex(a_iTextId, lang);
            FontText.renderText(a_g, txt, a_iX, a_iY, a_iAnchor, font_id);
        }
    }

    public static final void renderText(Graphics a_g, byte[] a_Text, int a_iX, int a_iY, int a_iAnchorXY, int font_id) {
        FontText.renderText(a_g, a_Text, 0, a_Text.length, a_iX, a_iY, a_iAnchorXY, font_id);
    }

    public static final void renderText(Graphics a_g, byte[] a_Text, int a_iIndexFrom, int a_iIndexTo, int a_iX, int a_iY, int a_iAnchorXY, int font_id) {
        try {
            if ((a_iAnchorXY & 3) != 0) {
                a_iX += FontText.anchorOffset(a_iAnchorXY & 3, FontText.textWidth(a_Text, a_iIndexFrom, a_iIndexTo, font_id));
            }
            if (a_iAnchorXY >>> 2 != 0) {
                a_iY += FontText.anchorOffset(a_iAnchorXY >>> 2, fontH[font_id]);
            }
            for (int i2 = a_iIndexFrom; i2 < a_iIndexTo; ++i2) {
                a_iX += fontDx[font_id] + FontText.renderSymbol(a_g, a_Text[i2] & 0xFF, a_iX, a_iY, 0, font_id);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        a_g.setClip(0, 0, Menu.W, Menu.H);
    }

    public static final void loadTexts(String name) {
        int cnt = 0;
        while (Menu.fileExist("/t" + cnt)) {
            ++cnt;
        }
        mTextIndexes = new short[cnt][];
        mTexts = new byte[cnt][];
        for (int i2 = 0; i2 < cnt; ++i2) {
            try {
                DataInputStream dis = FontText.getFile(name + "" + i2);
                FontText.mTextIndexes[i2] = FontText.readShortArray(dis, dis.readUnsignedShort());
                FontText.mTexts[i2] = FontText.readByteArray(dis, dis.readUnsignedShort());
                dis.close();
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public static final int renderSymbol(Graphics a_g, int a_iSymbolId, int a_iX, int a_iY, int a_iAnchorXY, int font_id) {
        int iSymbolW = FontText.symbolWidth(a_iSymbolId, font_id);
        if (a_iSymbolId <= fontW[font_id].length) {
            byte iSymbolH = fontH[font_id];
            a_g.setClip(a_iX += FontText.anchorOffset(a_iAnchorXY & 3, iSymbolW), a_iY += FontText.anchorOffset(a_iAnchorXY >>> 2, iSymbolH), iSymbolW, (int)iSymbolH);
            a_g.drawImage(fontImg[font_id], a_iX - (fontX[font_id][a_iSymbolId] & 0xFF), a_iY - (fontY[font_id][a_iSymbolId] & 0xFF), 20);
        }
        return iSymbolW;
    }

    public static final int symbolWidth(int a_iSymbolId, int font_id) {
        int ID = a_iSymbolId & 0xFF;
        if (ID > fontW[font_id].length) {
            return fontSpace[font_id];
        }
        return fontW[font_id][ID];
    }

    public static final int textWidth(int a_iTextId, int lang, int font_id) {
        return FontText.textWidth(mTexts[lang], mTextIndexes[lang][a_iTextId], mTextIndexes[lang][a_iTextId + 1], font_id);
    }

    public static final int textWidth(byte[] a_iText, int a_iIndexFrom, int a_iIndexTo, int font_id) {
        int result = 0;
        if (a_iIndexFrom < a_iIndexTo) {
            byte dx = fontDx[font_id];
            for (int i2 = a_iIndexFrom; i2 < a_iIndexTo; ++i2) {
                result += FontText.symbolWidth(a_iText[i2], font_id) + dx;
            }
            result -= dx;
        }
        return result;
    }

    public static final int textHeight(int font_id) {
        return fontH[font_id];
    }

    public static final int anchorOffset(int a_iAnchor, int a_iSize) {
        return -(a_iSize >>> anchorShift[a_iAnchor]);
    }

    public static final byte[] textByIndex(int index, int lang) {
        byte[] byArray;
        if (index >= 0) {
            byArray = FontText.submass_of_mass(mTexts[lang], FontText.textIndex(index, lang), FontText.textLength(index, lang));
        } else {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = -1;
        }
        byte[] temp = byArray;
        switch (index) {
            case -2: {
                temp = FontText.submass_of_mass(mTexts[lang], FontText.textIndex(11, lang), FontText.textLength(11, lang));
                temp = FontText.concatTexts(temp, FontText.textByIndex(Data.isSoundOn ? 15 : 16, lang), (byte)-1);
                break;
            }
            case -3: {
                temp = FontText.submass_of_mass(mTexts[lang], FontText.textIndex(12, lang), FontText.textLength(12, lang));
                temp = FontText.concatTexts(temp, FontText.textByIndex(Data.isVibraOn ? 15 : 16, lang), (byte)-1);
                break;
            }
            default: {
                if (index > -10) break;
                int lan = -index - 10;
                temp = FontText.submass_of_mass(mTexts[lan], FontText.textIndex(0, lan), FontText.textLength(0, lan));
            }
        }
        return temp;
    }

    public static final int textIndex(int index, int lang) {
        return mTextIndexes[lang][index] & 0xFFFF;
    }

    public static final int textLength(int index, int lang) {
        return FontText.textIndex(index + 1, lang) - FontText.textIndex(index, lang);
    }

    public static byte[] submass_of_mass(byte[] mass, int ind, int lenght) {
        byte[] result = new byte[lenght];
        System.arraycopy(mass, ind, result, 0, result.length);
        return result;
    }

    public static final byte[] concatTexts(byte[] text1, byte[] text2, byte delim) {
        byte[] res = new byte[text1.length + text2.length + 1];
        System.arraycopy(text1, 0, res, 0, text1.length);
        res[text1.length] = delim;
        System.arraycopy(text2, 0, res, text1.length + 1, text2.length);
        return res;
    }

    public static short[] parseText(int textId, int wid, int font_id) {
        return FontText.parseText(mTexts[curLang], mTextIndexes[curLang][textId], mTextIndexes[curLang][textId + 1], wid, font_id);
    }

    public static short[] parseText(byte[] text, int indFrom, int indTo, int width, int font_id) {
        int i2;
        Menu.scroll = 0;
        if (text == null || width == 0) {
            return null;
        }
        int[] result = new int[100];
        int a_first = indFrom;
        int a_second = indFrom;
        int row = 0;
        for (i2 = indFrom; i2 < indTo; ++i2) {
            if (text[i2] == -2) {
                if (FontText.textWidth(text, a_first, i2, font_id) >= width) {
                    result[row++] = a_first;
                    result[row++] = a_second + 1;
                } else {
                    result[row++] = a_first;
                }
                a_first = i2 + 1;
                a_second = i2 + 1;
                continue;
            }
            if (text[i2] != -1) continue;
            if (FontText.textWidth(text, a_first, i2, font_id) >= width) {
                result[row++] = a_first;
                a_first = a_second + 1;
            }
            a_second = i2;
        }
        if (FontText.textWidth(text, a_first, i2, font_id) >= width) {
            result[row++] = a_first;
            result[row++] = a_second + 1;
        } else {
            result[row++] = a_first;
        }
        short[] lastRes = new short[row + 1];
        for (int j2 = 0; j2 < row; j2 = (int)((byte)(j2 + 1))) {
            lastRes[j2] = (short)result[j2];
        }
        lastRes[row] = (short)indTo;
        return lastRes;
    }

    public static int renderParseText(Graphics g2, short[] massTextId, int scroll_poss, int[] rect, int align, int font_id) {
        byte[] _Text = mTexts[curLang];
        return FontText.renderParseText(g2, _Text, massTextId, scroll_poss, rect, align, font_id);
    }

    public static int renderParseText(Graphics g2, byte[] _Text, short[] massTextId, int scroll_poss, int[] rect, int align, int font_id) {
        if (massTextId == null || _Text == null) {
            return scroll_poss;
        }
        int cntLine = (rect[3] - rect[1]) / FontText.textHeight(font_id);
        int start_h = (rect[3] - rect[1] - Math.min(cntLine, massTextId.length - 1) * FontText.textHeight(font_id)) / 2;
        if (Menu.keys[Menu.UP]) {
            if (scroll_poss > 0) {
                --scroll_poss;
            }
            if (scroll_poss < 0) {
                scroll_poss = 0;
            }
        } else if (Menu.keys[Menu.DOWN] && massTextId.length > cntLine) {
            if (scroll_poss < massTextId.length - 1 - cntLine) {
                ++scroll_poss;
            }
            if (cntLine > massTextId.length) {
                scroll_poss = 0;
                cntLine = massTextId.length - 1 - cntLine;
            }
        }
        if (scroll_poss < 0) {
            scroll_poss = 0;
        }
        for (int i2 = scroll_poss; i2 < scroll_poss + cntLine; ++i2) {
            if (i2 + 1 >= massTextId.length) continue;
            int _x = (rect[2] + rect[0]) / 2;
            int _y = start_h + rect[1] + FontText.textHeight(font_id) * (i2 - scroll_poss);
            if (align == 0) {
                _x = rect[0] + 2;
                _y = rect[1] + FontText.textHeight(font_id) * (i2 - scroll_poss);
            } else if (align == 2) {
                _x = rect[2] - 3;
                _y = rect[1] + FontText.textHeight(font_id) * (i2 - scroll_poss);
            } else {
                align = 1;
            }
            FontText.renderText(g2, _Text, massTextId[i2], massTextId[i2 + 1], _x, _y, align, font_id);
        }
        return scroll_poss;
    }

    public static final byte[] stringToByte(String s) {
        int k2 = 0;
        byte[] res = new byte[s.length()];
        try {
            block2: for (int i2 = 0; i2 < s.length(); ++i2) {
                k2 = 0;
                if (s.charAt(i2) == ' ') {
                    res[i2] = -1;
                    continue;
                }
                if (s.charAt(i2) == '\n') {
                    res[i2] = -2;
                    continue;
                }
                if (s.charAt(i2) == '\r') {
                    res[i2] = -1;
                    continue;
                }
                for (int j2 = 0; j2 < mapFile.length(); ++j2) {
                    if (mapFile.charAt(j2) == '\n') {
                        k2 = (byte)(k2 + 1);
                    }
                    if (mapFile.charAt(j2) == s.charAt(i2)) {
                        res[i2] = k2;
                        continue block2;
                    }
                    res[i2] = -1;
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return res;
    }

    public static int getFontCng() {
        return mTextIndexes.length;
    }

    static {
        anchorShift = new int[]{31, 1, 0};
        curLang = 0;
    }
}

