/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Contact;
import at.emini.physics2D.Event;
import at.emini.physics2D.EventSet;
import at.emini.physics2D.ExternalForce;
import at.emini.physics2D.Joint;
import at.emini.physics2D.Landscape;
import at.emini.physics2D.Motor;
import at.emini.physics2D.MultiShape;
import at.emini.physics2D.ParticleEmitter;
import at.emini.physics2D.PhysicsEventListener;
import at.emini.physics2D.Script;
import at.emini.physics2D.Shape;
import at.emini.physics2D.ShapeSet;
import at.emini.physics2D.Spring;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class World {
    private PhysicsEventListener q;
    private FXVector r = new FXVector(0, 409600);
    private int s = 0;
    private int t = 0;
    private int u = 204;
    private long v = 0x1000000 / this.u;
    private int w = 10;
    private int x = 5;
    private boolean y = false;
    public static final int M_SHAPE_MAX_VERTICES = 12;
    protected ShapeSet mShapeSet = new ShapeSet();
    protected EventSet mEventSet = new EventSet();
    private Body[] z = new Body[128];
    private int A = Integer.MIN_VALUE;
    private int B = Integer.MAX_VALUE;
    int a = 0;
    Body[] b = new Body[128];
    private int C = 0;
    private int D = 0;
    private int E = this.a;
    private Landscape F = new Landscape();
    int c = 0;
    Contact[] d = new Contact[128];
    static int e = 0;
    static Contact[] f = new Contact[32];
    int g = 0;
    Constraint[] h = new Constraint[32];
    protected Vector mParticles = new Vector();
    protected Vector mForces = new Vector();
    Script[] i = new Script[32];
    int j = 0;
    Body[] k = new Body[32];
    int[] l = new int[32];
    int[] m = new int[32];
    int[] n = new int[32];
    int o = 0;
    static int p = 0;
    protected UserData mUserData = null;

    public World() {
    }

    protected World(ShapeSet shapeSet) {
        this.mShapeSet = shapeSet;
    }

    public World(World world) {
        if (world == null) {
            return;
        }
        this.mShapeSet = world.mShapeSet.copy();
        this.r.assign(world.r);
        this.s = world.s;
        this.t = world.t;
        this.A = world.A;
        this.B = world.B;
        this.u = world.u;
        this.v = world.v;
        this.w = world.w;
        this.x = world.x;
        this.addWorld(world);
        this.mEventSet = world.mEventSet.copy();
        if (world.F != null) {
            this.setLandscape(world.F.copy());
        }
        if (world.mUserData != null) {
            this.mUserData = world.mUserData.copy();
        }
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public void setUserData(UserData userData) {
        this.mUserData = userData;
    }

    public static World loadWorld(PhysicsFileReader physicsFileReader) {
        return World.loadWorld(physicsFileReader, null);
    }

    public static World loadWorld(PhysicsFileReader physicsFileReader, UserData userData) {
        int n = physicsFileReader.getVersion();
        if ((n & 0xFF00) < 256 || (n & 0xFF00) > 2560) {
            return null;
        }
        World world = new World();
        Vector<Shape> vector = new Vector<Shape>();
        Vector<Body> vector2 = new Vector<Body>();
        int n2 = 0;
        while (n2 != -1) {
            switch (n2) {
                case 1: {
                    int n3;
                    int n4;
                    int n5 = physicsFileReader.next();
                    for (n4 = 0; n4 < n5; ++n4) {
                        vector.addElement(Shape.loadShape(physicsFileReader, userData));
                    }
                    if (n > 2048) {
                        n4 = physicsFileReader.next();
                        for (n3 = 0; n3 < n4; ++n3) {
                            vector.addElement(MultiShape.loadShape(physicsFileReader, userData, vector));
                        }
                    }
                    world.mShapeSet.registerShapes(vector);
                    break;
                }
                case 2: {
                    int n4;
                    int n6 = physicsFileReader.next();
                    for (n4 = 0; n4 < n6; ++n4) {
                        Body body = Body.loadBody(physicsFileReader, vector, userData);
                        vector2.addElement(body);
                        world.addBody(body);
                    }
                    break;
                }
                case 6: {
                    world.setLandscape(Landscape.loadLandscape(physicsFileReader));
                    break;
                }
                case 3: {
                    int n4;
                    int n7 = physicsFileReader.next();
                    for (n4 = 0; n4 < n7; ++n4) {
                        world.addConstraint(World.loadConstraint(physicsFileReader, vector2, userData));
                    }
                    break;
                }
                case 4: {
                    int n3;
                    int n4;
                    int n8 = physicsFileReader.next();
                    for (n4 = 0; n4 < n8; ++n4) {
                        world.addScript(Script.loadScript(physicsFileReader));
                    }
                    world.o = physicsFileReader.next();
                    for (n4 = 0; n4 < world.o; ++n4) {
                        n3 = physicsFileReader.next();
                        int n9 = physicsFileReader.next();
                        if (n9 < 0 || n9 >= vector2.size() || n3 >= n8) continue;
                        world.l[n4] = physicsFileReader.next();
                        world.k[n4] = (Body)vector2.elementAt(physicsFileReader.next());
                    }
                    break;
                }
                case 5: {
                    int n4;
                    int n10 = physicsFileReader.next();
                    for (n4 = 0; n4 < n10; ++n4) {
                        world.addEvent(Event.loadEvent(physicsFileReader, world, userData));
                    }
                    break;
                }
                case 7: {
                    world.setGravity(physicsFileReader.nextVector());
                    if (physicsFileReader.getVersion() > 2304) {
                        world.setDampingLateralFX(physicsFileReader.nextInt());
                        world.setDampingRotationalFX(physicsFileReader.nextInt());
                    } else {
                        int n11 = 4096 - physicsFileReader.nextInt();
                        world.setDampingLateralFX(n11);
                        world.setDampingRotationalFX(n11);
                    }
                    if (physicsFileReader.getVersion() <= 1792) break;
                    String string = physicsFileReader.nextString();
                    if (userData == null) break;
                    world.mUserData = userData.createNewUserData(string, 6);
                    break;
                }
                case 8: {
                    int n4;
                    int n12 = physicsFileReader.next();
                    for (n4 = 0; n4 < n12; ++n4) {
                        world.addParticleEmitter(ParticleEmitter.loadParticleEmitter(physicsFileReader, world, userData));
                    }
                    break;
                }
            }
            if ((n & 0xFF00) == 256) {
                if (++n2 == 4) {
                    ++n2;
                }
                if (n2 <= 5) continue;
                break;
            }
            n2 = physicsFileReader.next();
        }
        physicsFileReader.close();
        return world;
    }

    public int getTimestepFX() {
        return this.u;
    }

    public long getInverseTimestepFX() {
        return this.v;
    }

    public void setTimestepFX(int n) {
        this.u = n;
        this.v = 0x1000000 / this.u;
    }

    public void setConstraintIterations(int n) {
        this.w = n;
    }

    public void setPositionConstraintIterations(int n) {
        this.x = n;
    }

    public int getConstraintIterations() {
        return this.w;
    }

    public int getPositionConstraintIterations() {
        return this.x;
    }

    public void setConstraintIterationDynamic(boolean bl) {
        this.y = bl;
    }

    public void setPhysicsEventListener(PhysicsEventListener physicsEventListener) {
        this.q = physicsEventListener;
    }

    public void setSimulationArea(int n, int n2) {
        this.A = n << 12;
        this.B = n2 << 12;
    }

    public ShapeSet getShapeSet() {
        return this.mShapeSet;
    }

    public Body[] addWorld(World world) {
        Body body;
        int n;
        int n2 = world.C;
        Body[] bodyArray = new Body[n2];
        for (n = 0; n < world.a; ++n) {
            body = world.b[n].copy();
            this.addBody(body);
            body.calculateAABB(0);
            bodyArray[world.b[n].mId] = body;
        }
        for (n = 0; n < world.g; ++n) {
            this.addConstraint(world.h[n].copy(bodyArray));
        }
        for (n = 0; n < world.j; ++n) {
            this.addScript(world.i[n].copy());
        }
        for (n = 0; n < world.o; ++n) {
            body = bodyArray[world.k[n].mId];
            this.i[world.l[n]].applyToBody(body, this);
            this.m[n] = world.m[n];
            this.n[n] = world.n[n];
        }
        for (n = 0; n < world.mParticles.size(); ++n) {
            this.addParticleEmitter(((ParticleEmitter)world.mParticles.elementAt(n)).copy(bodyArray));
        }
        for (n = 0; n < world.mForces.size(); ++n) {
            this.addExternalForce(((ExternalForce)world.mForces.elementAt(n)).copy(bodyArray));
        }
        Vector vector = world.mEventSet.getEvents();
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            this.addEvent(((Event)vector.elementAt(i)).copy(bodyArray));
        }
        Landscape landscape = world.getLandscape();
        for (int i = 0; i < landscape.mSegmentCount; ++i) {
            this.F.addSegment(new FXVector(landscape.mStartpoints[i]), new FXVector(landscape.mEndpoints[i]), landscape.mFaces[i]);
        }
        return bodyArray;
    }

    public void addBody(Body body) {
        if (body != null) {
            body.mId = this.C++;
            this.b = World.a(this.b, this.a);
            this.b[this.a++] = body;
            this.mShapeSet.registerShape(body.mShape);
            this.a();
            body.forceUpdate(this.u);
        }
    }

    public void setLandscape(Landscape landscape) {
        this.F = landscape;
    }

    public Landscape getLandscape() {
        return this.F;
    }

    public void addParticleEmitter(ParticleEmitter particleEmitter) {
        if (particleEmitter != null) {
            this.mParticles.addElement(particleEmitter);
        }
    }

    public void addExternalForce(ExternalForce externalForce) {
        if (externalForce != null) {
            this.mForces.addElement(externalForce);
        }
    }

    public void removeBody(Body body) {
        int n;
        int n2;
        if (body.mId < 0) {
            return;
        }
        for (n2 = 0; n2 < this.a; ++n2) {
            if (this.b[n2] != body) continue;
            this.b[n2] = null;
            break;
        }
        this.a = World.a((Object[])this.b, this.a);
        this.a();
        for (n2 = 0; n2 < this.o; ++n2) {
            if (this.k[n2] != body) continue;
            this.m[n2] = -1;
            this.n[n2] = -1;
            this.l[n2] = -1;
            this.k[n2] = null;
            World.b(this.m, this.o);
            World.b(this.n, this.o);
            World.b(this.l, this.o);
            this.o = World.a((Object[])this.k, this.o);
        }
        n2 = this.g;
        for (n = 0; n < n2; ++n) {
            if (!this.h[n].concernsBody(body)) continue;
            this.h[n] = null;
        }
        this.g = World.a(this.h, this.g);
        n = this.mParticles.size();
        for (n2 = n - 1; n2 >= 0; --n2) {
            ParticleEmitter particleEmitter = (ParticleEmitter)this.mParticles.elementAt(n2);
            if (particleEmitter.getEmitter() != body) continue;
            this.mParticles.removeElementAt(n2);
        }
        n2 = this.c;
        for (n = 0; n < n2; ++n) {
            if (!this.d[n].concernsBody(body)) continue;
            this.d[n] = null;
        }
        this.c = World.a((Object[])this.d, this.c);
    }

    public void removeConstraint(Constraint constraint) {
        int n = this.g;
        for (int i = 0; i < n; ++i) {
            if (this.h[i] != constraint) continue;
            this.h[i] = null;
        }
        this.g = World.a(this.h, this.g);
    }

    public void removeScript(Script script) {
        int n;
        int n2 = -1;
        for (n = 0; n < this.j; ++n) {
            if (this.i[n] != script) continue;
            this.i[n] = null;
            n2 = n;
            --this.j;
            for (int i = n; i < this.j; ++i) {
                this.i[i] = this.i[i + 1];
            }
            break;
        }
        for (n = 0; n < this.o; ++n) {
            if (this.m[n] != n2) continue;
            this.m[n] = -1;
            this.n[n] = -1;
            this.l[n] = -1;
            this.k[n] = null;
            World.b(this.m, this.o);
            World.b(this.n, this.o);
            World.b(this.l, this.o);
            this.o = World.a((Object[])this.k, this.o);
            return;
        }
    }

    public void removeEvent(Event event) {
        this.mEventSet.removeEvent(event);
    }

    public void removeParticleEmitter(ParticleEmitter particleEmitter) {
        if (particleEmitter != null) {
            this.mParticles.removeElement(particleEmitter);
        }
    }

    public void removeExternalForce(ExternalForce externalForce) {
        if (externalForce != null) {
            this.mForces.removeElement(externalForce);
        }
    }

    static final int[] a(int[] nArray, int n) {
        if (nArray.length <= n) {
            int[] nArray2 = new int[nArray.length + 32];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }
        return nArray;
    }

    static final short[] a(short[] sArray, int n) {
        if (sArray.length <= n) {
            short[] sArray2 = new short[sArray.length + 32];
            System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
            return sArray2;
        }
        return sArray;
    }

    private static Body[] a(Body[] bodyArray, int n) {
        if (bodyArray.length <= n) {
            Body[] bodyArray2 = new Body[bodyArray.length + 32];
            System.arraycopy(bodyArray, 0, bodyArray2, 0, bodyArray.length);
            return bodyArray2;
        }
        return bodyArray;
    }

    static final Contact[] a(Contact[] contactArray, int n) {
        if (contactArray.length <= n) {
            Contact[] contactArray2 = new Contact[contactArray.length + 32];
            System.arraycopy(contactArray, 0, contactArray2, 0, contactArray.length);
            return contactArray2;
        }
        return contactArray;
    }

    static final FXVector[] a(FXVector[] fXVectorArray, int n) {
        if (fXVectorArray.length <= n) {
            FXVector[] fXVectorArray2 = new FXVector[fXVectorArray.length + 32];
            System.arraycopy(fXVectorArray, 0, fXVectorArray2, 0, fXVectorArray.length);
            return fXVectorArray2;
        }
        return fXVectorArray;
    }

    public Body findBodyById(int n) {
        if ((n = this.bodyIndexOf(n)) < 0) {
            return null;
        }
        return this.b[n];
    }

    protected Body findBody(Body body) {
        if (body == null) {
            return null;
        }
        int n = this.bodyIndexOf(body.mId);
        if (n < 0) {
            return null;
        }
        return this.b[n];
    }

    public Body findBodyAt(int n, int n2) {
        Body[] bodyArray = this.getBodies();
        FXVector fXVector = new FXVector();
        for (int i = 0; i < this.getBodyCount(); ++i) {
            Body body = bodyArray[i];
            fXVector.assignFX(n, n2);
            if (n < body.getAABBMinXFX() || n > body.getAABBMaxXFX() || n2 < body.getAABBMinYFX() || n2 > body.getAABBMaxYFX()) continue;
            FXVector[] fXVectorArray = body.getAxes();
            FXVector[] fXVectorArray2 = body.getVertices();
            boolean bl = true;
            for (int j = 0; j < fXVectorArray.length; ++j) {
                long l;
                long l2 = (long)fXVector.xFX * (long)fXVectorArray[j].xFX + (long)fXVector.yFX * (long)fXVectorArray[j].yFX >> 12;
                long l3 = l = (long)fXVectorArray2[0].xFX * (long)fXVectorArray[j].xFX + (long)fXVectorArray2[0].yFX * (long)fXVectorArray[j].yFX >> 12;
                for (int k = 1; k < fXVectorArray2.length; ++k) {
                    long l4 = (long)fXVectorArray2[k].xFX * (long)fXVectorArray[j].xFX + (long)fXVectorArray2[k].yFX * (long)fXVectorArray[j].yFX >> 12;
                    if (l > l4) {
                        l = l4;
                    }
                    if (l3 >= l4) continue;
                    l3 = l4;
                }
                if (l <= l2 && l3 >= l2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return body;
        }
        return null;
    }

    public int bodyIndexOf(int n) {
        for (int i = 0; i < this.a; ++i) {
            if (this.b[i].mId != n) continue;
            return i;
        }
        return -1;
    }

    protected Constraint findConstraint(Constraint constraint) {
        int n = this.indexOf(constraint);
        if (n < 0) {
            return null;
        }
        return this.h[n];
    }

    public int indexOf(Constraint constraint) {
        if (constraint == null) {
            return -1;
        }
        for (int i = 0; i < this.g; ++i) {
            if (!this.h[i].equals(constraint)) continue;
            return i;
        }
        return -1;
    }

    public void addConstraint(Constraint constraint) {
        if (constraint != null) {
            Constraint[] constraintArray;
            int n = this.g;
            Constraint[] constraintArray2 = this.h;
            if (this.h.length <= n) {
                Constraint[] constraintArray3 = new Constraint[constraintArray2.length + 32];
                System.arraycopy(constraintArray2, 0, constraintArray3, 0, constraintArray2.length);
                constraintArray = constraintArray3;
            } else {
                constraintArray = constraintArray2;
            }
            this.h = constraintArray;
            this.h[this.g++] = constraint;
        }
    }

    public void addScript(Script script) {
        if (script != null) {
            Script[] scriptArray;
            int n = this.j;
            Script[] scriptArray2 = this.i;
            if (this.i.length <= n) {
                Script[] scriptArray3 = new Script[scriptArray2.length + 32];
                System.arraycopy(scriptArray2, 0, scriptArray3, 0, scriptArray2.length);
                scriptArray = scriptArray3;
            } else {
                scriptArray = scriptArray2;
            }
            this.i = scriptArray;
            this.i[this.j++] = script;
        }
    }

    protected void addScriptBody(int n, Body body) {
        this.l[this.o] = n;
        this.k[this.o++] = body;
    }

    public void addEvent(Event event) {
        this.mEventSet.registerEvent(event);
    }

    public void setGravity(int n) {
        this.r = new FXVector(0, n << 12);
    }

    public void setGravity(FXVector fXVector) {
        this.r = fXVector;
    }

    public void setDampingLateralFX(int n) {
        this.s = n;
    }

    public void setDampingRotationalFX(int n) {
        this.t = n;
    }

    public void tick() {
        int n;
        int n2;
        int n3;
        Body[] bodyArray = this.b;
        Constraint[] constraintArray = this.h;
        for (n3 = 0; n3 < this.o; ++n3) {
            if (this.k[n3] == null) continue;
            this.i[this.l[n3]].executeScript(n3, this);
        }
        for (n3 = 0; n3 < this.mForces.size(); ++n3) {
            ((ExternalForce)this.mForces.elementAt(n3)).applyForce(bodyArray, this.a, this.u);
        }
        for (n3 = this.D; n3 < this.E; ++n3) {
            Body body = bodyArray[n3];
            if (body.a && body.c) {
                body.applyAcceleration(this.r, this.u);
            }
            body.calculateAABB(this.u);
        }
        this.checkCollisions();
        Contact.a(this.d, this.c);
        Contact.a(this.d, this.c, this.F);
        for (n3 = 0; n3 < this.mParticles.size(); ++n3) {
            ((ParticleEmitter)this.mParticles.elementAt(n3)).applyAcceleration(this.r, this.u);
        }
        this.collideParticles();
        for (n3 = 0; n3 < this.c; ++n3) {
            this.d[n3].precalculate(this.v);
        }
        for (n3 = 0; n3 < this.g; ++n3) {
            constraintArray[n3].precalculate(this.v);
        }
        n3 = 0;
        for (p = 0; !(p >= this.w || n3 != 0 && this.y); ++p) {
            int n4;
            n3 = 1;
            for (n4 = 0; n4 < this.g; ++n4) {
                n3 &= constraintArray[n4].applyMomentum(this.v);
            }
            for (n4 = 0; n4 < this.c; ++n4) {
                n3 &= this.d[n4].applyMomentum();
            }
        }
        for (n2 = 0; n2 < this.g; ++n2) {
            constraintArray[n2].postStep();
        }
        n2 = 4096 - this.s;
        int n5 = 4096 - this.t;
        for (n = this.D; n < this.E; ++n) {
            bodyArray[n].integrateVelocity(this.u);
            bodyArray[n].updateVelocity(n2, n5);
        }
        for (n = 0; n < this.c; ++n) {
            this.d[n].precalculatePositionCorrection(this.u, this.v);
        }
        long l = 0L;
        for (p = 0; p < this.x; ++p) {
            for (n5 = 0; n5 < this.c; ++n5) {
                long l2 = this.d[n5].applyMomentumPositionCorrectionFX();
                l = l < l2 ? l2 : l;
            }
            if (l < 32L) break;
        }
        for (n5 = this.D; n5 < this.E; ++n5) {
            bodyArray[n5].integrateVirtualVelocity(this.u, this.r);
        }
        for (n5 = 0; n5 < this.mParticles.size(); ++n5) {
            ((ParticleEmitter)this.mParticles.elementAt(n5)).integrateParticles(this.u);
        }
        if (this.q != null) {
            this.mEventSet.checkEvents(this, this.q);
        }
    }

    protected void checkCollisions() {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < this.c; ++n3) {
            this.d[n3] = null;
        }
        n3 = this.c = 0;
        this.F.initCollision();
        this.a();
        int n4 = 0;
        int n5 = 0;
        for (n2 = this.D; n2 < this.E; ++n2) {
            n = this.b[n2].e;
            this.F.collisionCheckBody(this, this.b[n2]);
            for (int i = 0; i < n5; ++i) {
                if (this.z[i] == null) continue;
                if (this.z[i].f < n) {
                    --n4;
                    this.z[i] = null;
                    continue;
                }
                if (this.b[n2].g > this.z[i].h || this.z[i].g > this.b[n2].h) continue;
                Body body = this.z[i];
                Body body2 = this.b[n2];
                World world = this;
                if (!body2.a && !body.a || (body2.i & body.i) != 0 || !body2.b || !body.b) continue;
                if (body2.mShape instanceof MultiShape || body.mShape instanceof MultiShape) {
                    int n6 = 1;
                    int n7 = 1;
                    if (body2.mShape instanceof MultiShape) {
                        n6 = ((MultiShape)body2.mShape).getShapeCount();
                    }
                    if (body.mShape instanceof MultiShape) {
                        n7 = ((MultiShape)body.mShape).getShapeCount();
                    }
                    for (int j = 0; j < n6; ++j) {
                        for (int k = 0; k < n7; ++k) {
                            Contact contact = Collision.detectCollision(body2, j, body, k);
                            if (contact == null) continue;
                            world.d = World.a(world.d, world.c);
                            world.d[world.c] = contact;
                            ++world.c;
                        }
                    }
                    continue;
                }
                Contact contact = Collision.detectCollision(body2, body);
                if (contact == null) continue;
                world.d = World.a(world.d, world.c);
                world.d[world.c] = contact;
                ++world.c;
            }
            this.z = World.a(this.z, n5);
            this.z[n5++] = this.b[n2];
            if (n5 <= ++n4 << 1) continue;
            n5 = World.a((Object[])this.z, n5);
        }
        this.F.resetContacts();
        for (n2 = this.D; n2 < this.E; ++n2) {
            this.b[n2].resetContacts();
        }
        this.F.getBody();
        for (n = n3; n < this.c; ++n) {
            Contact contact = this.d[n];
            this.d[n].g = false;
            contact.a.addContact(contact);
            contact.c.addContact(contact);
        }
    }

    protected void collideParticles() {
        for (int i = 0; i < this.mParticles.size(); ++i) {
            ParticleEmitter particleEmitter = (ParticleEmitter)this.mParticles.elementAt(i);
            if (!particleEmitter.a) continue;
            int n = 0;
            for (int j = this.D; j < this.E; ++j) {
                while (n < particleEmitter.mMaxParticleCount && (particleEmitter.mLife[n] <= 0 || this.b[j].e > particleEmitter.mXFX[n])) {
                    ++n;
                }
                for (int k = n; k < particleEmitter.mMaxParticleCount && (particleEmitter.mLife[k] <= 0 || this.b[j].f > particleEmitter.mXFX[k]); ++k) {
                    FXVector fXVector;
                    if (particleEmitter.mLife[k] <= 0 || this.b[j].g >= particleEmitter.mYFX[k] || this.b[j].h <= particleEmitter.mYFX[k] || !this.b[j].b || (fXVector = Collision.detectCollision(this.b[j], particleEmitter.mXFX[k], particleEmitter.mYFX[k])) == null) continue;
                    particleEmitter.collide(fXVector, k);
                }
            }
            this.F.collideParticles(particleEmitter);
        }
    }

    private static int a(Object[] objectArray, int n) {
        int n2 = n--;
        int n3 = 0;
        while (n3 < n) {
            while (objectArray[n3] != null && n3 < n) {
                ++n3;
            }
            while (objectArray[n] == null && n3 < n) {
                --n;
            }
            if (n3 < n) {
                objectArray[n3] = objectArray[n];
                objectArray[n] = null;
            }
            if (objectArray[n] == null) {
                n2 = n;
            }
            --n;
        }
        while (n2 > 0 && objectArray[n2 - 1] == null) {
            --n2;
        }
        return n2;
    }

    static final int b(int[] nArray, int n) {
        int n2 = n--;
        int n3 = 0;
        while (n3 < n) {
            while (nArray[n3] != -1 && n3 < n) {
                ++n3;
            }
            while (nArray[n] == -1 && n3 < n) {
                --n;
            }
            if (n3 < n) {
                nArray[n3] = nArray[n];
                nArray[n] = -1;
                n2 = n;
            }
            --n;
        }
        return n2;
    }

    private final void a() {
        int n;
        for (n = 1; n < this.a; ++n) {
            Body body = this.b[n];
            for (int i = n - 1; i >= 0 && this.b[i].e > body.e; --i) {
                this.b[i + 1] = this.b[i];
            }
            this.b[i + 1] = body;
        }
        this.D = -1;
        this.E = this.a;
        for (n = 0; n < this.a; ++n) {
            if (this.D < 0 && this.b[n].f > this.A) {
                this.D = n;
            }
            if (this.b[n].e >= this.B) continue;
            this.E = n + 1;
        }
        if (this.D < 0) {
            this.D = 0;
        }
    }

    public FXVector getGravity() {
        return this.r;
    }

    public int getDampingLateralFX() {
        return this.s;
    }

    public int getDampingRotationalFX() {
        return this.t;
    }

    public static Constraint loadConstraint(PhysicsFileReader physicsFileReader, Vector vector, UserData userData) {
        int n = physicsFileReader.next();
        switch (n) {
            case 0: {
                return Joint.loadJoint(physicsFileReader, vector, userData);
            }
            case 1: {
                return Spring.loadSpring(physicsFileReader, vector, userData);
            }
            case 3: {
                return Motor.loadMotor(physicsFileReader, vector, userData);
            }
        }
        return null;
    }

    public Vector getEvents() {
        return this.mEventSet.getEvents();
    }

    public Vector getParticleEmitters() {
        return this.mParticles;
    }

    protected int getAreaStartFX() {
        return this.A;
    }

    protected int getAreaEndFX() {
        return this.B;
    }

    public int getBodyCount() {
        return this.a;
    }

    public Body[] getBodies() {
        return this.b;
    }

    public int getBodyStartIndex() {
        return this.D;
    }

    public int getBodyEndIndex() {
        return this.E;
    }

    public int getConstraintCount() {
        return this.g;
    }

    public Constraint[] getConstraints() {
        return this.h;
    }

    public int getContactCount() {
        return this.c;
    }

    public Contact[] getContacts() {
        return this.d;
    }

    public int getScriptCount() {
        return this.j;
    }

    public Script[] getScripts() {
        return this.i;
    }

    public Script getScript(int n) {
        return this.i[n];
    }

    protected int getScriptBodyCount() {
        return this.o;
    }

    protected Body[] getScriptBodies() {
        return this.k;
    }

    protected int[] getScriptIndices() {
        return this.l;
    }

    public Contact[] getContactsForBody(Body contactArray) {
        Contact[] contactArray2 = new Contact[8];
        int n = 0;
        contactArray = contactArray.getContacts();
        for (int i = 0; i < contactArray.length && contactArray[i] != null; ++i) {
            contactArray2[n++] = contactArray[i];
        }
        return contactArray2;
    }

    public void translate(FXVector fXVector) {
        int n = this.getBodyCount();
        Body[] bodyArray = this.getBodies();
        for (int i = 0; i < n; ++i) {
            bodyArray[i].positionFX().xFX += fXVector.xFX;
            bodyArray[i].positionFX().yFX += fXVector.yFX;
            bodyArray[i].calculateAABB(0);
        }
    }

    public long getBodyTotalEnergyFX(Body body) {
        long l = body.velocityFX().lengthSquareFX() / 2;
        long l2 = -((int)((long)body.positionFX().yFX * (long)this.r.yFX) >> 12);
        return l + (l2 += (long)(-((int)((long)body.positionFX().xFX * (long)this.r.xFX) >> 12)));
    }
}

