/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D.util;

public class FXVector {
    public int xFX = 0;
    public int yFX = 0;
    private static FXVector a = new FXVector();
    private static FXVector b = new FXVector();
    public static final FXVector M_UNITY = new FXVector(4096, 0);

    public FXVector() {
    }

    public FXVector(int n, int n2) {
        this.xFX = n;
        this.yFX = n2;
    }

    public FXVector(FXVector fXVector) {
        this.xFX = fXVector.xFX;
        this.yFX = fXVector.yFX;
    }

    public static FXVector newVector(int n, int n2) {
        return new FXVector(n << 12, n2 << 12);
    }

    public final void assign(FXVector fXVector) {
        this.xFX = fXVector.xFX;
        this.yFX = fXVector.yFX;
    }

    public final void assignFX(int n, int n2) {
        this.xFX = n;
        this.yFX = n2;
    }

    public final void assignDiff(FXVector fXVector, FXVector fXVector2) {
        this.xFX = fXVector.xFX - fXVector2.xFX;
        this.yFX = fXVector.yFX - fXVector2.yFX;
    }

    public final void assignScaledFX(FXVector fXVector, long l) {
        this.xFX = (int)(l * (long)fXVector.xFX >> 12);
        this.yFX = (int)(l * (long)fXVector.yFX >> 12);
    }

    public boolean equals(Object object) {
        if (object instanceof FXVector) {
            return this.xFX == ((FXVector)object).xFX && this.yFX == ((FXVector)object).yFX;
        }
        return false;
    }

    public final void add(FXVector fXVector) {
        this.xFX += fXVector.xFX;
        this.yFX += fXVector.yFX;
    }

    public final void add(FXVector fXVector, long l) {
        this.xFX += (int)(l * (long)fXVector.xFX >> 12);
        this.yFX += (int)(l * (long)fXVector.yFX >> 12);
    }

    public final void addFX(int n, int n2, long l) {
        this.xFX += (int)(l * (long)n >> 12);
        this.yFX += (int)(l * (long)n2 >> 12);
    }

    public final void add2FX(FXVector fXVector, long l) {
        this.xFX += (int)(l * (long)fXVector.xFX >> 24);
        this.yFX += (int)(l * (long)fXVector.yFX >> 24);
    }

    public final void subtract(FXVector fXVector) {
        this.xFX -= fXVector.xFX;
        this.yFX -= fXVector.yFX;
    }

    public final void multFX(long l) {
        this.xFX = (int)(l * (long)this.xFX >> 12);
        this.yFX = (int)(l * (long)this.yFX >> 12);
    }

    public final void mult(int n) {
        this.xFX *= n;
        this.yFX *= n;
    }

    public final FXVector timesFX(long l) {
        FXVector fXVector = new FXVector();
        new FXVector().xFX = (int)(l * (long)this.xFX >> 12);
        fXVector.yFX = (int)(l * (long)this.yFX >> 12);
        return fXVector;
    }

    public final FXVector times(int n) {
        FXVector fXVector = new FXVector();
        new FXVector().xFX = this.xFX * n;
        fXVector.yFX = this.yFX * n;
        return fXVector;
    }

    public final FXVector dividedByFX(int n) {
        FXVector fXVector = new FXVector();
        new FXVector().xFX = (int)(((long)this.xFX << 12) / (long)n);
        fXVector.yFX = (int)(((long)this.yFX << 12) / (long)n);
        return fXVector;
    }

    public final void divideByFX(int n) {
        this.xFX = (int)(((long)this.xFX << 12) / (long)n);
        this.yFX = (int)(((long)this.yFX << 12) / (long)n);
    }

    public final void divideBy(int n) {
        this.xFX /= n;
        this.yFX /= n;
    }

    public final void transpose() {
        this.xFX ^= this.yFX;
        this.yFX = this.xFX ^ this.yFX;
        this.xFX ^= this.yFX;
    }

    public final void turnRight() {
        int n = this.xFX;
        this.xFX = this.yFX;
        this.yFX = -n;
    }

    public final int lengthSquare() {
        return (int)((long)this.xFX * (long)this.xFX + (long)this.yFX * (long)this.yFX >> 24);
    }

    public final int lengthSquareFX() {
        return (int)((long)this.xFX * (long)this.xFX + (long)this.yFX * (long)this.yFX >> 12);
    }

    public final int lengthFX() {
        int n;
        int n2 = this.xFX < 0 ? -this.xFX : this.xFX;
        int n3 = n = this.yFX < 0 ? -this.yFX : this.yFX;
        if (n2 < n) {
            n2 ^= n;
            n = n2 ^ n;
            n2 ^= n;
        }
        if ((n2 = n2 - (n2 >> 5) - (n2 >> 7) + ((n += n >> 1) >> 2) + (n >> 6)) == 0) {
            return 0;
        }
        n2 = (int)(((long)this.xFX * (long)this.xFX + (long)this.yFX * (long)this.yFX) / (long)n2 + (long)n2) >> 1;
        return n2;
    }

    public final int preciseLengthFX() {
        int n;
        int n2 = this.xFX < 0 ? -this.xFX : this.xFX;
        int n3 = n = this.yFX < 0 ? -this.yFX : this.yFX;
        if (n2 < n) {
            n2 ^= n;
            n = n2 ^ n;
            n2 ^= n;
        }
        if ((n2 = n2 - (n2 >> 5) - (n2 >> 7) + ((n += n >> 1) >> 2) + (n >> 6)) == 0) {
            return 0;
        }
        n2 = (int)(((long)this.xFX * (long)this.xFX + (long)this.yFX * (long)this.yFX) / (long)n2 + (long)n2) >> 1;
        n2 = (int)(((long)this.xFX * (long)this.xFX + (long)this.yFX * (long)this.yFX) / (long)n2 + (long)n2) >> 1;
        return n2;
    }

    public static final int fastLengthFX(int n, int n2) {
        n = n < 0 ? -n : n;
        int n3 = n2 = n2 < 0 ? -n2 : n2;
        if (n < n2) {
            n ^= n2;
            n2 = n ^ n2;
            n ^= n2;
        }
        n2 += n2 >> 1;
        return n - (n >> 5) - (n >> 7) + (n2 >> 2) + (n2 >> 6);
    }

    public final int fastLengthFX() {
        int n;
        int n2 = this.xFX < 0 ? -this.xFX : this.xFX;
        int n3 = n = this.yFX < 0 ? -this.yFX : this.yFX;
        if (n2 < n) {
            n2 ^= n;
            n = n2 ^ n;
            n2 ^= n;
        }
        n += n >> 1;
        return n2 - (n2 >> 5) - (n2 >> 7) + (n >> 2) + (n >> 6);
    }

    public final int distFX(FXVector fXVector) {
        a.assignDiff(fXVector, this);
        return a.lengthFX();
    }

    public final void normalize() {
        int n = this.lengthFX();
        if (n == 0) {
            return;
        }
        this.xFX = (int)(((long)this.xFX << 12) / (long)n);
        this.yFX = (int)(((long)this.yFX << 12) / (long)n);
    }

    public final void normalizePrecise() {
        int n = this.preciseLengthFX();
        if (n == 0) {
            return;
        }
        this.xFX = (int)(((long)this.xFX << 12) / (long)n);
        this.yFX = (int)(((long)this.yFX << 12) / (long)n);
    }

    public final void normalizeFast() {
        int n = this.fastLengthFX();
        if (n == 0) {
            return;
        }
        this.xFX = (int)(((long)this.xFX << 12) / (long)n);
        this.yFX = (int)(((long)this.yFX << 12) / (long)n);
    }

    public final long dotFX(FXVector fXVector) {
        return (long)this.xFX * (long)fXVector.xFX + (long)this.yFX * (long)fXVector.yFX >> 12;
    }

    public final long crossFX(FXVector fXVector) {
        return (long)this.xFX * (long)fXVector.yFX - (long)this.yFX * (long)fXVector.xFX >> 12;
    }

    public final void crossScalarFX(long l) {
        long l2 = this.xFX;
        this.xFX = (int)(l * (long)this.yFX >> 12);
        this.yFX = -((int)(l * l2 >> 12));
    }

    public final void crossScalar2FX(long l) {
        long l2 = this.xFX;
        this.xFX = (int)(l * (long)this.yFX >> 24);
        this.yFX = -((int)(l * l2 >> 24));
    }

    public final int distanceFX(FXVector fXVector, FXVector fXVector2, FXVector fXVector3, int n) {
        a.assignDiff(this, fXVector);
        long l = (long)FXVector.a.xFX * (long)fXVector3.xFX + (long)FXVector.a.yFX * (long)fXVector3.yFX >> 12;
        if (l < 0L) {
            return Integer.MAX_VALUE;
        }
        if (l > (long)n) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.abs((long)FXVector.a.xFX * (long)fXVector3.yFX - (long)FXVector.a.yFX * (long)fXVector3.xFX >> 12);
    }

    public final int distanceFX(FXVector fXVector, FXVector fXVector2) {
        b.assignDiff(fXVector2, fXVector);
        b.normalize();
        return this.distanceFX(fXVector, fXVector2, b, fXVector.distFX(fXVector2));
    }

    public final boolean leftOf(FXVector fXVector, FXVector fXVector2) {
        a.assignDiff(fXVector2, fXVector);
        b.assignDiff(this, fXVector);
        return (long)FXVector.a.xFX * (long)FXVector.b.yFX - (long)FXVector.a.yFX * (long)FXVector.b.xFX >> 12 > 0L;
    }

    public static boolean intersect(FXVector fXVector, FXVector fXVector2, FXVector fXVector3, FXVector fXVector4, FXVector fXVector5) {
        FXVector fXVector6 = a;
        FXVector fXVector7 = b;
        fXVector6.assignDiff(fXVector2, fXVector);
        fXVector7.assignDiff(fXVector4, fXVector3);
        long l = (long)fXVector7.xFX * (long)fXVector6.yFX - (long)fXVector7.yFX * (long)fXVector6.xFX >> 12;
        if (l == 0L) {
            return false;
        }
        long l2 = ((long)fXVector.xFX * (long)fXVector6.yFX - (long)fXVector.yFX * (long)fXVector6.xFX >> 12) - fXVector3.crossFX(fXVector6);
        long l3 = ((long)fXVector.xFX * (long)fXVector7.yFX - (long)fXVector.yFX * (long)fXVector7.xFX >> 12) - fXVector3.crossFX(fXVector7);
        if (l > 0L && (l2 < -l || l2 > l || l3 < -l || l3 > l) || l < 0L && (l2 > -l || l2 < l || l3 > -l || l3 < l)) {
            return false;
        }
        int n = fXVector.xFX + (int)(l3 * (long)fXVector6.xFX / l);
        int n2 = fXVector3.xFX + (int)(l2 * (long)fXVector7.xFX / l);
        fXVector5.xFX = (n + n2) / 2;
        n = fXVector.yFX + (int)(l3 * (long)fXVector6.yFX / l);
        n2 = fXVector3.yFX + (int)(l2 * (long)fXVector7.yFX / l);
        fXVector5.yFX = (n + n2) / 2;
        return true;
    }

    public final void maxFX(int n) {
        this.xFX = Math.max(this.xFX, n);
        this.yFX = Math.max(this.yFX, n);
    }

    public final void minFX(int n) {
        this.xFX = Math.min(this.xFX, n);
        this.yFX = Math.min(this.yFX, n);
    }

    public final void max(FXVector fXVector) {
        this.xFX = Math.max(this.xFX, fXVector.xFX);
        this.yFX = Math.max(this.yFX, fXVector.yFX);
    }

    public final void min(FXVector fXVector) {
        this.xFX = Math.min(this.xFX, fXVector.xFX);
        this.yFX = Math.min(this.yFX, fXVector.yFX);
    }

    public final boolean isInRect(FXVector fXVector, FXVector fXVector2) {
        return this.xFX >= fXVector.xFX && this.yFX >= fXVector.yFX && this.xFX <= fXVector2.xFX && this.yFX <= fXVector2.yFX;
    }

    public final int xAsInt() {
        if (this.xFX >= 0) {
            return this.xFX >> 12;
        }
        return this.xFX + 4096 - 1 >> 12;
    }

    public final int yAsInt() {
        if (this.yFX >= 0) {
            return this.yFX >> 12;
        }
        return this.yFX + 4096 - 1 >> 12;
    }
}

