/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Shape {
    protected FXVector[] mVertices;
    int[] a;
    int b = 0;
    private int k;
    int c;
    private int l;
    int d;
    long e = 0L;
    protected int mElasticityFX = 0;
    protected int mFrictionFX = 1024;
    int f = 4096;
    long g = 0x1000000L;
    long h = 4096L;
    long i = 0x1000000L;
    int j = -1;
    protected UserData mUserData = null;
    protected FXVector mCcentroid = new FXVector();
    public static final int MAX_MASS_FX = 0x1000001;

    public static Shape createRectangle(int n, int n2) {
        FXVector[] fXVectorArray = new FXVector[4];
        FXVector[] fXVectorArray2 = fXVectorArray;
        fXVectorArray[0] = new FXVector(-(n <<= 12) / 2, -(n2 <<= 12) / 2);
        fXVectorArray2[1] = new FXVector(-n / 2, n2 / 2);
        fXVectorArray2[2] = new FXVector(n / 2, n2 / 2);
        fXVectorArray2[3] = new FXVector(n / 2, -n2 / 2);
        Shape shape = new Shape(fXVectorArray2);
        return shape;
    }

    public static Shape createCircle(int n) {
        FXVector[] fXVectorArray = new FXVector[1];
        FXVector[] fXVectorArray2 = fXVectorArray;
        fXVectorArray[0] = new FXVector(0, n << 12);
        return new Shape(fXVectorArray2);
    }

    public static Shape createRegularPolygon(int n, int n2) {
        FXVector[] fXVectorArray = new FXVector[n2];
        FXVector fXVector = new FXVector(0, n << 12);
        for (int i = 0; i < n2; ++i) {
            long l = 105414356L * (long)((i << 1) + 1) / (long)(n2 << 1);
            FXMatrix fXMatrix = FXMatrix.createRotationMatrix((int)l);
            fXVectorArray[n2 - 1 - i] = fXMatrix.mult(fXVector);
        }
        Shape shape = new Shape(fXVectorArray);
        return shape;
    }

    public static Shape loadShape(PhysicsFileReader object, UserData userData) {
        int n = ((PhysicsFileReader)object).getVersion();
        if (n <= 512) {
            ((PhysicsFileReader)object).next();
        }
        int n2 = ((PhysicsFileReader)object).next();
        FXVector[] fXVectorArray = new FXVector[n2];
        for (int i = 0; i < n2; ++i) {
            fXVectorArray[i] = ((PhysicsFileReader)object).nextVector();
        }
        Shape shape = new Shape(fXVectorArray);
        shape.setElasticityFX(((PhysicsFileReader)object).nextIntFX());
        shape.setFrictionFX(((PhysicsFileReader)object).nextIntFX());
        if (n >= 1280) {
            shape.setMassFX(((PhysicsFileReader)object).nextIntFX());
        }
        if (((PhysicsFileReader)object).getVersion() > 1536) {
            object = ((PhysicsFileReader)object).nextString();
            if (userData != null) {
                shape.mUserData = userData.createNewUserData((String)object, 2);
            }
        }
        return shape;
    }

    public Shape(FXVector[] fXVectorArray) {
        if (fXVectorArray.length > 12) {
            return;
        }
        this.mVertices = fXVectorArray;
        this.updateInternals();
        this.setMass(1);
    }

    public Shape(Shape shape) {
        this.mVertices = new FXVector[shape.mVertices.length];
        System.arraycopy(shape.mVertices, 0, this.mVertices, 0, this.mVertices.length);
        this.setElasticityFX(shape.mElasticityFX);
        this.setFrictionFX(shape.mFrictionFX);
        this.updateInternals();
        this.setMassFX(shape.f);
        if (shape.mUserData != null) {
            this.mUserData = shape.mUserData.copy();
        }
    }

    protected Shape() {
    }

    protected void updateInternals() {
        this.a();
        this.k = 0;
        for (int i = 0; i < this.mVertices.length; ++i) {
            FXVector fXVector = this.mVertices[i];
            int n = fXVector.lengthSquare();
            if (n <= this.k * this.k) continue;
            this.k = fXVector.lengthFX() >> 12;
        }
        this.c = this.k << 12;
        this.b();
        Shape shape = this;
        this.l = shape.d = shape.c << 1;
        for (int i = 0; i < shape.a.length && shape.a[i] >= 0; i += 2) {
            long l;
            FXVector fXVector = new FXVector(shape.mVertices[shape.a[i]]);
            fXVector.subtract(shape.mVertices[shape.a[i + 1]]);
            fXVector.normalize();
            long l2 = l = (long)shape.mVertices[0].xFX * (long)fXVector.yFX - (long)shape.mVertices[0].yFX * (long)fXVector.xFX >> 12;
            for (int j = 1; j < shape.mVertices.length; ++j) {
                long l3 = (long)shape.mVertices[j].xFX * (long)fXVector.yFX - (long)shape.mVertices[j].yFX * (long)fXVector.xFX >> 12;
                if (l3 < l2) {
                    l2 = l3;
                    continue;
                }
                if (l3 <= l) continue;
                l = l3;
            }
            if ((long)shape.d < l - l2) {
                shape.d = (int)(l - l2);
            }
            if ((long)shape.l <= l - l2) continue;
            shape.l = (int)(l - l2);
        }
    }

    public void correctCentroid() {
        if (this.mVertices.length < 3) {
            return;
        }
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        int n2 = this.mVertices.length - 1;
        while (n < this.mVertices.length) {
            long l3 = (long)this.mVertices[n].xFX * (long)this.mVertices[n2].yFX - (long)this.mVertices[n].yFX * (long)this.mVertices[n2].xFX >> 12;
            l += l3 * (long)(this.mVertices[n].xFX + this.mVertices[n2].xFX) >> 12;
            l2 += l3 * (long)(this.mVertices[n].yFX + this.mVertices[n2].yFX) >> 12;
            n2 = n++;
        }
        l = (l << 12) / (this.e * 6L);
        l2 = (l2 << 12) / (this.e * 6L);
        for (n = 0; n < this.mVertices.length; ++n) {
            this.mVertices[n].subtract(new FXVector((int)l, (int)l2));
        }
        this.updateInternals();
    }

    public FXVector[] getCorners() {
        return this.mVertices;
    }

    public int getBoundingRadiusSquare() {
        return this.k * this.k;
    }

    protected int getBoundingRadius() {
        return this.k;
    }

    public int getBoundingRadiusFX() {
        return this.c;
    }

    void a() {
        if (this.mVertices.length == 1) {
            this.a = new int[0];
            this.b = 0;
            return;
        }
        this.a = new int[this.mVertices.length << 1];
        Vector<FXVector> vector = new Vector<FXVector>();
        int n = 0;
        int n2 = this.mVertices.length - 1;
        while (n < this.mVertices.length) {
            FXVector fXVector = new FXVector(this.mVertices[n]);
            fXVector.subtract(this.mVertices[n2]);
            fXVector.normalize();
            boolean bl = true;
            for (int i = 0; i < vector.size(); ++i) {
                FXVector fXVector2 = (FXVector)vector.elementAt(i);
                if (Math.abs((long)fXVector.xFX * (long)fXVector2.xFX + (long)fXVector.yFX * (long)fXVector2.yFX >> 12) <= 4088L) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.a[vector.size() << 1] = n;
                this.a[(vector.size() << 1) + 1] = n2;
                vector.addElement(fXVector);
            }
            n2 = n++;
        }
        this.b = vector.size() << 1;
        for (n = vector.size() << 1; n < this.a.length; ++n) {
            this.a[n] = -1;
        }
    }

    public void setFriction(int n) {
        this.mFrictionFX = (n << 12) / 100;
    }

    public void setFrictionFX(int n) {
        this.mFrictionFX = n;
    }

    public int getFrictionFX() {
        return this.mFrictionFX;
    }

    public void setElasticity(int n) {
        this.mElasticityFX = (n << 12) / 100;
    }

    public void setElasticityFX(int n) {
        this.mElasticityFX = n;
    }

    public int getElasticityFX() {
        return this.mElasticityFX;
    }

    public final void setMass(int n) {
        this.setMassFX(n << 12);
    }

    public final void setMassFX(int n) {
        if (this.e == 0L) {
            this.h = 0x1000001L;
            this.g = 1L;
            this.i = 1L;
            return;
        }
        this.f = n;
        this.g = 0x1000000000L / (long)n;
        if (this.g == 0L) {
            this.g = 1L;
        }
        this.b();
    }

    public int getMass() {
        return this.f >> 12;
    }

    public int getMassFX() {
        return this.f;
    }

    public int getId() {
        return this.j;
    }

    public long getAreaFX() {
        return this.e;
    }

    void b() {
        this.e = 0L;
        this.h = 0L;
        if (this.mVertices.length == 1) {
            this.e = 52707178L * (long)((int)((long)this.c * (long)this.c) >> 24) >> 12;
            this.h = (int)((long)(this.f / 2) * (long)this.c * (long)this.c >> 24);
        } else if (this.mVertices.length > 2) {
            for (int i = 0; i < this.mVertices.length; ++i) {
                FXVector fXVector = this.mVertices[i];
                FXVector fXVector2 = this.mVertices[i + 1 >= this.mVertices.length ? 0 : i + 1];
                long l = (long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12;
                this.e += l / 2L;
                long l2 = fXVector.xFX;
                long l3 = fXVector.yFX;
                long l4 = fXVector2.xFX;
                long l5 = fXVector2.yFX;
                long l6 = (int)((l2 * l2 + l4 * l2 + l4 * l4) / 12L >> 12);
                long l7 = (int)((l3 * l3 + l5 * l3 + l5 * l5) / 12L >> 12);
                this.h += l * (l6 + l7) >> 12;
            }
            this.h = (this.h << 12) / this.e * (long)this.f >> 12;
        }
        if (this.e > 0L) {
            long l = 0L;
            long l8 = 0L;
            int n = 0;
            int n2 = this.mVertices.length - 1;
            while (n < this.mVertices.length) {
                long l9 = (long)this.mVertices[n].xFX * (long)this.mVertices[n2].yFX - (long)this.mVertices[n].yFX * (long)this.mVertices[n2].xFX >> 12;
                l += l9 * (long)(this.mVertices[n].xFX + this.mVertices[n2].xFX) >> 12;
                l8 += l9 * (long)(this.mVertices[n].yFX + this.mVertices[n2].yFX) >> 12;
                n2 = n++;
            }
            l = (l << 12) / (this.e * 6L);
            l8 = (l8 << 12) / (this.e * 6L);
            this.mCcentroid.assignFX((int)l, (int)l8);
        } else {
            this.mCcentroid.assignFX(0, 0);
        }
        this.h += (long)this.f * (long)this.mCcentroid.lengthSquareFX() >> 12;
        if (this.h == 0L) {
            this.i = Integer.MAX_VALUE;
            return;
        }
        this.i = 0x1000000000L / this.h;
    }

    protected final void getVerticesFX(FXVector fXVector, FXMatrix fXMatrix, FXVector[] fXVectorArray) {
        if (fXVectorArray.length < this.mVertices.length) {
            return;
        }
        for (int i = 0; i < this.mVertices.length; ++i) {
            fXMatrix.mult(this.mVertices[i], fXVectorArray[i]);
            fXVectorArray[i].xFX += fXVector.xFX;
            fXVectorArray[i].yFX += fXVector.yFX;
        }
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public void setUserData(UserData userData) {
        this.mUserData = userData;
    }
}

