/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Contact;
import at.emini.physics2D.MultiShape;
import at.emini.physics2D.ParticleEmitter;
import at.emini.physics2D.Shape;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;

public class Landscape {
    private Body a;
    private Shape b;
    protected int mSegmentCount = 0;
    protected FXVector[] mStartpoints = new FXVector[128];
    protected FXVector[] mEndpoints = new FXVector[128];
    protected short[] mFaces = new short[128];
    private int c = 0;
    private int[] d = new int[32];
    private int e = 0;
    private int f = 0;
    public static final short FACE_NONE = 0;
    public static final short FACE_LEFT = 1;
    public static final short FACE_RIGHT = 2;
    private int g = 0;
    private Contact[] h = new Contact[32];

    public Landscape() {
        this.b = new Shape(new FXVector[0]);
        this.a = new Body(0, 0, this.b, false);
    }

    public Landscape(Landscape landscape) {
        this.b = new Shape(new FXVector[0]);
        this.a = new Body(0, 0, this.b, false);
        if (landscape == null) {
            return;
        }
        this.b.mFrictionFX = landscape.b.mFrictionFX;
        this.b.mElasticityFX = landscape.b.mElasticityFX;
        this.mSegmentCount = landscape.mSegmentCount;
        this.mStartpoints = new FXVector[Math.max(128, this.mSegmentCount)];
        this.mEndpoints = new FXVector[Math.max(128, this.mSegmentCount)];
        this.mFaces = new short[Math.max(128, this.mSegmentCount)];
        for (int i = 0; i < this.mSegmentCount; ++i) {
            this.mStartpoints[i] = new FXVector(landscape.mStartpoints[i]);
            this.mEndpoints[i] = new FXVector(landscape.mEndpoints[i]);
            this.mFaces[i] = landscape.mFaces[i];
        }
    }

    public static Landscape loadLandscape(PhysicsFileReader physicsFileReader) {
        Landscape landscape = new Landscape();
        int n = physicsFileReader.nextInt();
        for (int i = 0; i < n; ++i) {
            landscape.addSegment(physicsFileReader.nextVector(), physicsFileReader.nextVector(), (short)physicsFileReader.next());
        }
        landscape.b = Shape.loadShape(physicsFileReader, null);
        landscape.a = new Body(0, 0, landscape.b, false);
        return landscape;
    }

    public Landscape copy() {
        return new Landscape(this);
    }

    public void addSegment(FXVector fXVector, FXVector fXVector2, short s) {
        FXVector fXVector3 = fXVector.xFX < fXVector2.xFX ? fXVector : fXVector2;
        FXVector fXVector4 = fXVector.xFX < fXVector2.xFX ? fXVector2 : fXVector;
        if (fXVector2.xFX <= fXVector.xFX & s != 0) {
            s = (short)(s == 2 ? 1 : 2);
        }
        this.mStartpoints = World.a(this.mStartpoints, this.mSegmentCount);
        this.mEndpoints = World.a(this.mEndpoints, this.mSegmentCount);
        this.mFaces = World.a(this.mFaces, this.mSegmentCount);
        this.mStartpoints[this.mSegmentCount] = fXVector3;
        this.mEndpoints[this.mSegmentCount] = fXVector4;
        this.mFaces[this.mSegmentCount] = s;
        ++this.mSegmentCount;
        this.sortArrays();
    }

    public void removeSegment(int n) {
        if (n < this.mSegmentCount) {
            this.mStartpoints[n] = this.mStartpoints[this.mSegmentCount - 1];
            this.mEndpoints[n] = this.mEndpoints[this.mSegmentCount - 1];
            this.mFaces[n] = this.mFaces[this.mSegmentCount - 1];
            --this.mSegmentCount;
            this.sortArrays();
        }
    }

    protected final void sortArrays() {
        for (int i = 1; i < this.mSegmentCount; ++i) {
            FXVector fXVector = this.mStartpoints[i];
            FXVector fXVector2 = this.mEndpoints[i];
            short s = this.mFaces[i];
            for (int j = i - 1; j >= 0 && this.mStartpoints[j].xFX > fXVector.xFX; --j) {
                this.mStartpoints[j + 1] = this.mStartpoints[j];
                this.mEndpoints[j + 1] = this.mEndpoints[j];
                this.mFaces[j + 1] = this.mFaces[j];
            }
            this.mStartpoints[j + 1] = fXVector;
            this.mEndpoints[j + 1] = fXVector2;
            this.mFaces[j + 1] = s;
        }
    }

    protected final void initCollision() {
        this.c = 0;
        this.d = new int[32];
        this.e = 0;
        this.f = 0;
    }

    protected final void collisionCheckBody(World world, Body body) {
        int n;
        int n2;
        if (!body.a) {
            return;
        }
        if ((body.i & this.a.i) != 0) {
            return;
        }
        for (n2 = 0; n2 < this.e; ++n2) {
            if (this.d[n2] == -1 || this.mEndpoints[this.d[n2]].xFX >= body.e) continue;
            --this.f;
            this.d[n2] = -1;
        }
        n2 = 0;
        while (this.c < this.mSegmentCount && this.mStartpoints[this.c].xFX < body.f) {
            if (this.mEndpoints[this.c].xFX < body.e) {
                ++this.c;
                continue;
            }
            n = 1;
            while (n2 < this.e) {
                if (this.d[n2] == -1) {
                    this.d[n2] = this.c;
                    ++this.f;
                    n = 0;
                    break;
                }
                ++n2;
            }
            if (n != 0) {
                this.d = World.a(this.d, this.e);
                this.d[this.e++] = this.c;
                ++this.f;
            }
            if (this.e > this.f << 1) {
                this.e = World.b(this.d, this.e);
            }
            ++this.c;
        }
        for (n = 0; n < this.e; ++n) {
            if (this.d[n] < 0 || body.g > Math.max(this.mEndpoints[this.d[n]].yFX, this.mStartpoints[this.d[n]].yFX) || Math.min(this.mStartpoints[this.d[n]].yFX, this.mEndpoints[this.d[n]].yFX) > body.h) continue;
            int n3 = this.d[n];
            Body body2 = body;
            World world2 = world;
            Landscape landscape = this;
            if (body2.mShape instanceof MultiShape) {
                int n4 = ((MultiShape)body2.mShape).getShapeCount();
                for (int i = 0; i < n4; ++i) {
                    Contact contact = Collision.detectCollision(body2, i, landscape, n3);
                    if (contact == null) continue;
                    world2.d = World.a(world2.d, world2.c);
                    world2.d[world2.c] = contact;
                    ++world2.c;
                }
                continue;
            }
            Contact contact = Collision.detectCollision(body2, landscape, n3);
            if (contact == null) continue;
            world2.d = World.a(world2.d, world2.c);
            world2.d[world2.c] = contact;
            ++world2.c;
        }
    }

    protected void resetContacts() {
        for (int i = 0; i < this.g; ++i) {
            if (this.h[i] == null || this.h[i].g) continue;
            if (World.e < World.f.length) {
                World.f[World.e++] = this.h[i];
                this.h[i].g = true;
            }
            this.h[i] = null;
        }
        Landscape landscape = this;
        int n = landscape.g;
        int n2 = 0;
        for (int i = landscape.g - 1; n2 < i; --i) {
            while (landscape.h[n2] != null && n2 < i) {
                ++n2;
            }
            while (landscape.h[i] == null && n2 < i) {
                --i;
            }
            if (n2 >= i) continue;
            landscape.h[n2] = landscape.h[i];
            landscape.h[i] = null;
            n = i;
        }
        while (n > 0 && landscape.h[n - 1] == null) {
            --n;
        }
        landscape.g = n;
    }

    protected void addContact(Contact contact) {
        this.h = World.a(this.h, this.g);
        this.h[this.g] = contact;
        ++this.g;
    }

    public Contact[] getContacts() {
        return this.h;
    }

    public final void fillVertices(FXVector[] fXVectorArray, Contact contact, int n) {
        int n2 = contact.a == this.a ? contact.b : contact.d;
        fXVectorArray[0] = this.mStartpoints[n2];
        fXVectorArray[1] = this.mEndpoints[n2];
    }

    protected Contact getContact(Body body, int n, int n2) {
        for (int i = 0; i < this.g; ++i) {
            Contact contact = this.h[i];
            if (contact == null || (contact.a != body || n != contact.b || n2 != contact.d) && (contact.c != body || n != contact.d || n2 != contact.b)) continue;
            return this.h[i];
        }
        return null;
    }

    public void collideParticles(ParticleEmitter particleEmitter) {
        int n = 0;
        for (int i = 0; i < this.mSegmentCount; ++i) {
            while (n < particleEmitter.mMaxParticleCount && (particleEmitter.mLife[n] <= 0 || this.mStartpoints[i].xFX > particleEmitter.mXFX[n] && this.mStartpoints[i].xFX > particleEmitter.mXPrevFX[n])) {
                ++n;
            }
            for (int j = n; j < particleEmitter.mMaxParticleCount && (particleEmitter.mLife[j] <= 0 || this.mEndpoints[i].xFX > particleEmitter.mXFX[j] || this.mEndpoints[i].xFX > particleEmitter.mXPrevFX[j]); ++j) {
                FXVector fXVector;
                if (particleEmitter.mLife[j] <= 0 || (fXVector = Collision.detectCollision(this, i, particleEmitter.mXFX[j], particleEmitter.mYFX[j], particleEmitter.mXPrevFX[j], particleEmitter.mYPrevFX[j])) == null) continue;
                particleEmitter.collide(fXVector, j);
            }
        }
    }

    public Body getBody() {
        return this.a;
    }

    public Shape getShape() {
        return this.b;
    }

    public int segmentCount() {
        return this.mSegmentCount;
    }

    public FXVector[] elementStartPoints() {
        return this.mStartpoints;
    }

    public FXVector[] elementEndPoints() {
        return this.mEndpoints;
    }

    public FXVector startPoint(int n) {
        return this.mStartpoints[n];
    }

    public FXVector endPoint(int n) {
        return this.mEndpoints[n];
    }
}

